#!/bin/bash
###############################################################################
# Copyright Statement:                                                        #
#                                                                             #
#   This software/firmware and related documentation ("MediaTek Software")    #
# are protected under international and related jurisdictions'copyright laws  #
# as unpublished works. The information contained herein is confidential and  #
# proprietary to MediaTek Inc. Without the prior written permission of        #
# MediaTek Inc., any reproduction, modification, use or disclosure of         #
# MediaTek Software, and information contained herein, in whole or in part,   #
# shall be strictly prohibited.                                               #
# MediaTek Inc. Copyright (C) 2010. All rights reserved.                      #
#                                                                             #
#   BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND      #
# AGREES TO THE FOLLOWING:                                                    #
#                                                                             #
#   1)Any and all intellectual property rights (including without             #
# limitation, patent, copyright, and trade secrets) in and to this            #
# Software/firmware and related documentation ("MediaTek Software") shall     #
# remain the exclusive property of MediaTek Inc. Any and all intellectual     #
# property rights (including without limitation, patent, copyright, and       #
# trade secrets) in and to any modifications and derivatives to MediaTek      #
# Software, whoever made, shall also remain the exclusive property of         #
# MediaTek Inc.  Nothing herein shall be construed as any transfer of any     #
# title to any intellectual property right in MediaTek Software to Receiver.  #
#                                                                             #
#   2)This MediaTek Software Receiver received from MediaTek Inc. and/or its  #
# representatives is provided to Receiver on an "AS IS" basis only.           #
# MediaTek Inc. expressly disclaims all warranties, expressed or implied,     #
# including but not limited to any implied warranties of merchantability,     #
# non-infringement and fitness for a particular purpose and any warranties    #
# arising out of course of performance, course of dealing or usage of trade.  #
# MediaTek Inc. does not provide any warranty whatsoever with respect to the  #
# software of any third party which may be used by, incorporated in, or       #
# supplied with the MediaTek Software, and Receiver agrees to look only to    #
# such third parties for any warranty claim relating thereto.  Receiver       #
# expressly acknowledges that it is Receiver's sole responsibility to obtain  #
# from any third party all proper licenses contained in or delivered with     #
# MediaTek Software.  MediaTek is not responsible for any MediaTek Software   #
# releases made to Receiver's specifications or to conform to a particular    #
# standard or open forum.                                                     #
#                                                                             #
#   3)Receiver further acknowledge that Receiver may, either presently        #
# and/or in the future, instruct MediaTek Inc. to assist it in the            #
# development and the implementation, in accordance with Receiver's designs,  #
# of certain softwares relating to Receiver's product(s) (the "Services").    #
# Except as may be otherwise agreed to in writing, no warranties of any       #
# kind, whether express or implied, are given by MediaTek Inc. with respect   #
# to the Services provided, and the Services are provided on an "AS IS"       #
# basis. Receiver further acknowledges that the Services may contain errors   #
# that testing is important and it is solely responsible for fully testing    #
# the Services and/or derivatives thereof before they are used, sublicensed   #
# or distributed. Should there be any third party action brought against      #
# MediaTek Inc. arising out of or relating to the Services, Receiver agree    #
# to fully indemnify and hold MediaTek Inc. harmless.  If the parties         #
# mutually agree to enter into or continue a business relationship or other   #
# arrangement, the terms and conditions set forth herein shall remain         #
# effective and, unless explicitly stated otherwise, shall prevail in the     #
# event of a conflict in the terms in any agreements entered into between     #
# the parties.                                                                #
#                                                                             #
#   4)Receiver's sole and exclusive remedy and MediaTek Inc.'s entire and     #
# cumulative liability with respect to MediaTek Software released hereunder   #
# will be, at MediaTek Inc.'s sole discretion, to replace or revise the       #
# MediaTek Software at issue.                                                 #
#                                                                             #
#   5)The transaction contemplated hereunder shall be construed in            #
# accordance with the laws of Singapore, excluding its conflict of laws       #
# principles.  Any disputes, controversies or claims arising thereof and      #
# related thereto shall be settled via arbitration in Singapore, under the    #
# then current rules of the International Chamber of Commerce (ICC).  The     #
# arbitration shall be conducted in English. The awards of the arbitration    #
# shall be final and binding upon both parties and shall be entered and       #
# enforceable in any court of competent jurisdiction.                         #
###############################################################################

echo "Checking for firmware upgrade..."

DOWNLOAD_XML_PATH='/fw_upgrade/'
LOCAL_PATH='/fw_upgrade/'
USB_PATH='/mnt/'
DO_REBOOT_FLAG=0
/bin/fw_printenv - bootargs file_upgrading

DOWNLOAD_XML=`find ${DOWNLOAD_XML_PATH}download.xml`
VERSION_XML=`find ${DOWNLOAD_XML_PATH}version.xml`

if [ -n "${DOWNLOAD_XML}" ];then
    echo "find download.xml"
else
    echo "can't find download.xml"
    exit 0
fi

find ${LOCAL_PATH}*.tgz
if [ $? -eq 0 ];then

    echo "find tgz file in local flash"

    for AP_NAME in `find ${LOCAL_PATH}*.tgz`;do
        echo "find: ${AP_NAME}"
        AP_BASENAME=`basename ${AP_NAME}`
        AP_PATH=`xml path ${AP_BASENAME} ${DOWNLOAD_XML_PATH}`
        if [ $? -eq 0 ];then
            if [ -n "${AP_PATH}" ];then
                echo "path: ${AP_PATH}"
                if [ ! -d ${AP_PATH} ];then
                    mkdir -p ${AP_PATH};
                fi
                tar -zxf ${AP_NAME} -C ${AP_PATH}
                echo "tar: ${AP_NAME}"
                rm -rf ${AP_NAME}
                echo "rm: ${AP_NAME}"
                
                if [ -n "${VERSION_XML}" ];then
                    xml update ${AP_BASENAME} ${DOWNLOAD_XML_PATH}
                    if [ $? -eq 0 ];then
                        echo "update version: ${AP_BASENAME}"
                    fi
                fi
                sync
                DO_REBOOT_FLAG=1
            fi
        else
            echo "can't find ${AP_BASENAME} in download.xml"
        fi
    done

else

    echo "Checking for USB mount path..."

    if [ -f /etc/scripts/ins_usb_core_mod.sh ]; then   
        sh /etc/scripts/ins_usb_core_mod.sh
    fi

    if [ -f /etc/scripts/ins_fs_mod.sh ]; then   
        sh /etc/scripts/ins_fs_mod.sh
    fi
    if [ -f /etc/scripts/ins_blk_mod.sh ]; then   
        sh /etc/scripts/ins_blk_mod.sh
    fi
    if [ -f /etc/scripts/ins_usb_sub_mod.sh ]; then   
        sh /etc/scripts/ins_usb_sub_mod.sh
    fi

    MOUNT_PATH=`usb_path`
    if [ $? -eq 0 ];then 
        if [ -n "${MOUNT_PATH}" ];then
            echo "mount: /dev/${MOUNT_PATH}"
            mount -t vfat /dev/${MOUNT_PATH} /mnt
        fi
    else
        echo "can't find USB flash"
        rm -rf ${DOWNLOAD_XML}
        echo "rm: ${DOWNLOAD_XML}"
        sync
        exit 0
    fi
    
    find ${USB_PATH}*.tgz
    if [ $? -eq 0 ];then
        echo "find tgz file in USB flash"
    
        for AP_NAME in `find ${USB_PATH}*.tgz`;do
            echo "find: ${AP_NAME}"
            AP_BASENAME=`basename ${AP_NAME}`
            AP_PATH=`xml path ${AP_BASENAME} ${DOWNLOAD_XML_PATH}`
            if [ $? -eq 0 ];then
                if [ -n "${AP_PATH}" ];then
                    echo "path: ${AP_PATH}"
                    if [ ! -d ${AP_PATH} ];then
                        mkdir -p ${AP_PATH};
                    fi
                    tar -zxf ${AP_NAME} -C ${AP_PATH}
                    echo "tar: ${AP_NAME}"
                    rm -rf ${AP_NAME}
                    echo "rm: ${AP_NAME}"
                    
                    if [ -n "${VERSION_XML}" ];then
                        xml update ${AP_BASENAME} ${DOWNLOAD_XML_PATH}
                        if [ $? -eq 0 ];then
                            echo "update version: ${AP_BASENAME}"
                        fi
                    fi
                    sync
                    DO_REBOOT_FLAG=1
                fi
            else
                echo "can't find ${AP_BASENAME} in download.xml"
            fi
        done
    else
        echo "can't find tgz file"
    fi
fi

rm -rf ${DOWNLOAD_XML}
echo "rm: ${DOWNLOAD_XML}"
sync
if [ ${DO_REBOOT_FLAG} -eq 1 ];then
    grep -q no_checker_upg_reboot /proc/cmdline
    if [ $? != 0 ];then
        insmod /basic/dtv_driver.ko
        reboot -f
    fi
fi
