#!/bin/bash

if [ "$#" = "0" ]; then
	echo "please provide globalinfo.txt path"
	exit 0
fi
DEBUG=0
GLOBALTXT="$1"
builddate=`cat $GLOBALTXT  | awk 'BEGIN {FS="\""} {print $4}'`
deviceid=`cat $GLOBALTXT  | awk 'BEGIN {FS="\""} {print $8}'`
component=`cat $GLOBALTXT  | awk 'BEGIN {FS="\""} {print $12}'`
ufversion=`cat $GLOBALTXT  | awk 'BEGIN {FS="\""} {print $16}'`
country=`cat $GLOBALTXT  | awk 'BEGIN {FS="\""} {print $20}'`
ctn=`cat $GLOBALTXT  | awk 'BEGIN {FS="\""} {print $24}'`
op_hour=`cat $GLOBALTXT  | awk 'BEGIN {FS="\""} {print $27}' | awk 'BEGIN {FS=":"} {print $2}' | awk 'BEGIN {FS=","} {print $1}'`
menu_language=`cat $GLOBALTXT | awk 'BEGIN {FS="\""} {print $30}'`
serial=`cat $GLOBALTXT | awk 'BEGIN {FS="\""} {print $34}'`


if [ "$#" = 1 ]; then
	if [ "$DEBUG" = 1 ]; then
		echo "builddate $builddate"
		echo "deviceid $deviceid"
		echo "component $component"
		echo "ufversion $ufversion"
		echo "country $country"
		echo "ctn $ctn"
		echo "op_hour $op_hour"
		echo "menu_language $menu_language"
		echo "serial $serial"
		echo "==================="
	fi
fi

if [ "$#" = 3 ]; then
	eval replaceStr="\${$2}"
	if [ "$DEBUG" = 1 ]; then
		echo "replaceStr $replaceStr -> $3"
	fi
	if [ "$2" = "op_hour" ]; then
		sed -i "s^\"$2\":$replaceStr^\"$2\":$3^g" $GLOBALTXT
	else
		sed -i "s^\"$2\":\"$replaceStr\"^\"$2\":\"$3\"^g" $GLOBALTXT
	fi
fi

