#!/bin/sh

# This script makes sure the setuid sandbox binary is setuid root.  The script
# itself is not needed on production installs.

set -e

# Equivalent to "cd $(dirname $0)." Works also on platforms that don't have the
# dirname command.
script_dir="${0%/*}"
cd "${script_dir:-/}"

if [ `id -u` != 0 ]
then
	echo "Error: This script must be run as root." 1>&2
	exit 1
fi

if [ ! -e ./bin/chrome-sandbox ]
then
	echo "Error: ./bin/chrome-sandbox does not exist." 1>&2
	exit 1
fi

chown root:root ./bin/chrome-sandbox
chmod 4755 ./bin/chrome-sandbox

