#!/bin/sh
# Copyright (C) 2012-2013 Opera Software AS.  All rights reserved.
#
# This file is part of the Opera Devices SDK.
# It includes Opera proprietary information and distribution is prohibited
# without Opera Software's prior, explicit and written consent.

if [ ! -e $PWD/opera_env.sh ]; then
	echo "Error: Only execute this script from the package directory"
	return 1
fi

[ -e /dev/shm ] || {
	echo "Warning: /dev/shm not available, attempting to mount it" 1>&2
	mkdir /dev/shm
	mount -t tmpfs none /dev/shm || {
		echo "Failed to mount /dev/shm - exiting"
		exit 1
	}
}

LD_LIBRARY_PATH="$PWD/lib:$LD_LIBRARY_PATH"
LD_LIBRARY_PATH="/3rd/nettv/:$LD_LIBRARY_PATH"
LD_LIBRARY_PATH="$PWD/opera_dir/uva_backends:$LD_LIBRARY_PATH"

export LD_LIBRARY_PATH
OPERA_DIR="$PWD/opera_dir"
export OPERA_DIR

if [ -z "$UVA_DEBUG" ]; then
       UVA_DEBUG=""
	export UVA_DEBUG
fi

OPERA_EXTRA_DFB_ARGS=
export OPERA_EXTRA_DFB_ARGS
echo -ne "\n\e[48;5;9m opera-env \e[0m OPERA_EXTRA_DFB_ARGS = $OPERA_EXTRA_DFB_ARGS\n"

UVA_BACKEND=libuvabackend-tpvision.so
export UVA_BACKEND
echo -ne "\n\e[48;5;9m opera-env \e[0m UVA_BACKEND = $UVA_BACKEND\n"

UVA_DRM_LIB=$OPERA_DIR/uva_drm_backends/libuvadrmbackendloader.so
export UVA_DRM_LIB
echo -ne "\n\e[48;5;9m opera-env \e[0m UVA_DRM_LIB = $UVA_DRM_LIB\n"

UVA_DRM_LIB_DIR=$OPERA_DIR/uva_drm_backends
export UVA_DRM_LIB_DIR
echo -ne "\n\e[48;5;9m opera-env \e[0m UVA_DRM_LIB_DIR = $UVA_DRM_LIB_DIR\n"
