// JavaScript Document

var EventUtil = {

    addHandler: function(element, type, handler){
        if (element.addEventListener){
            element.addEventListener(type, handler, false);
        } else if (element.attachEvent){
            element.attachEvent("on" + type, handler);
        } else {
            element["on" + type] = handler;
        }
    },
    
    getButton: function(event){
        if (document.implementation.hasFeature("MouseEvents", "2.0")){
            return event.button;
        } else {
            switch(event.button){
                case 0:
                case 1:
                case 3:
                case 5:
                case 7:
                    return 0;
                case 2:
                case 6:
                    return 2;
                case 4: return 1;
            }
        }
    },
    
    getCharCode: function(event){
        if (typeof event.charCode == "number"){
            return event.charCode;
        } else {
            return event.keyCode;
        }
    },
    
    getClipboardText: function(event){
        var clipboardData =  (event.clipboardData || window.clipboardData);
        return clipboardData.getData("text");
    },
    
    getEvent: function(event){
        return event ? event : window.event;
    },
    
    getRelatedTarget: function(event){
        if (event.relatedTarget){
            return event.relatedTarget;
        } else if (event.toElement){
            return event.toElement;
        } else if (event.fromElement){
            return event.fromElement;
        } else {
            return null;
        }
    
    },
    
    getTarget: function(event){
        return event.target || event.srcElement;
    },
    
    getWheelDelta: function(event){
        if (event.wheelDelta){
            return (client.engine.opera && client.engine.opera < 9.5 ? -event.wheelDelta : event.wheelDelta);
        } else {
            return -event.detail * 40;
        }
    },
    
    preventDefault: function(event){
        if (event.preventDefault){
            event.preventDefault();
        } else {
            event.returnValue = false;
        }
    },

    removeHandler: function(element, type, handler){
        if (element.removeEventListener){
            element.removeEventListener(type, handler, false);
        } else if (element.detachEvent){
            element.detachEvent("on" + type, handler);
        } else {
            element["on" + type] = null;
        }
    },
    
    setClipboardText: function(event, value){
        if (event.clipboardData){
            event.clipboardData.setData("text/plain", value);
        } else if (window.clipboardData){
            window.clipboardData.setData("text", value);
        }
    },
    
    stopPropagation: function(event){
        if (event.stopPropagation){
            event.stopPropagation();
        } else {
            event.cancelBubble = true;
        }
    }

};

var lang = "en-US";
var info_timeout;
var tm_duration = 0;

var el_btn_close,
	el_progress, 
	el_play_sprite, 
	el_remaining,
	el_buffering,
    element_td_col1_url,
    element_td_col2_url,
    element_td_col1_security1,
    element_td_col2_security1,
    element_td_col1_security2,
    element_td_col2_security2,
    element_td_col1_cert1,
    element_td_col2_cert1,
    element_td_col1_cert2,
    element_td_col2_cert2,
    element_td_col1_video,
    element_td_col2_video,
    element_td_col1_quality,
    element_td_col2_quality;


// print log to Element for debug
function logToElement(message)
{
 return;
 
    var console = document.getElementById("debuginfo");
    if (console === null){
        console = document.createElement("div");
        console.id = "debuginfo";
        console.style.background = "#dedede";
        console.style.border = "1px solid silver";
        console.style.padding = "5px";
        console.style.width = "200px";
        console.style.position = "absolute";
        console.style.left = "922px";
        console.style.top = "0px";
        document.body.appendChild(console);

    }
    console.innerHTML += "<p>" + message + "</p>";
}

function SetElementXYWH(element,x,y,w,h)//pix value
{
    element.style.left     = x+"px";
    element.style.top      = y+"px";
    element.style.width    = w+"px";
    element.style.height   = h+"px";
}

function SetElementShow(element,bShow)
{
    if (bShow)
    {
        element.style.visibility="visible";
    }
    else
    {
        element.style.visibility="hidden";
    }
}

function sinfo_doTimeout(secs) 
{
	clearTimeout(info_timeout);
	info_timeout = setTimeout("browser_ipc.hide('security_info')", secs * 1000);
}

function set_lang(_lang)
{
	lang = _lang;
}

function update_duration(duration)
{
    tm_duration = duration;	
}

function update_buffering(buffering)
{
	el_buffering.style.width = buffering + "%";	
	
}

function update_elapsed(elapsed)
{
	if(tm_duration > 0)
	{
		if(elapsed <= tm_duration)
		{
			el_remaining.style.width = Math.ceil(((elapsed * 100) / tm_duration)) + "%";
		}
		else
		{
			el_remaining.style.width = "0%";
		}
	}

    el_play_sprite.style.left = el_remaining.offsetLeft + el_remaining.offsetWidth - 15;
	
}

function update_quality(quality)
{
  var imageurl,signalmsg,showmsg;
  
	if(quality >= 80)
	{
	   imageurl  = "strong.png";
	   signalmsg = " Good";
	}
	else if(quality > 40)
	{
	   imageurl  = "normal.png";
	   signalmsg = " Fair";
	}
	else
	{
		imageurl  = "week.png";
		signalmsg = " Poor";
	}
	
 	showmsg   = " "+quality;
	
	element_td_col2_quality.innerHTML = "<img src=\""+imageurl+"\" width=\"46\" height=\"22\">"+ showmsg;
	
}

function sinfo_set_videoplay_status(hasVideoplay)
{
	if(hasVideoplay == 1)//download
	{
      element_td_col1_video.textContent  = msgs.MAIN_SMART_TV_DOWNLOAD[lang];
      SetElementShow(element_td_col1_video,true);
      SetElementShow(element_td_col2_video,true);
	  SetElementShow(element_td_col1_quality,false);
      SetElementShow(element_td_col2_quality,false);
      SetElementShow(el_progress,true);	  
      SetElementShow(el_play_sprite,true);	  
	}
	else if(hasVideoplay == 2)//video streaming
	{
      element_td_col1_video.textContent  = msgs.MAIN_SMART_TV_STREAMING_VIDEO[lang];
      SetElementShow(element_td_col1_video,true);
      SetElementShow(element_td_col2_video,true);
      SetElementShow(element_td_col1_quality,false);
      SetElementShow(element_td_col2_quality,false);
      SetElementShow(el_progress,true);	  
      SetElementShow(el_play_sprite,true);	  
	}
	else
	{
      SetElementShow(element_td_col1_video,false);
      SetElementShow(element_td_col2_video,false);
      SetElementShow(element_td_col1_quality,false);
      SetElementShow(element_td_col2_quality,false);
      SetElementShow(el_progress,false);
      SetElementShow(el_play_sprite,false);	  
	}	
}
function adapterVideoProcessWidth(){
		
		
		var infowidth = element_td_col1_video.clientWidth;
		var progress_bar = document.getElementById("progress_bar");
		progress_bar.style.left=infowidth-40;
		//progress_bar.style.width =  document.getElementById("root").clientWidth - (infowidth-40);
		
		
}
function sinfo_set_params(url, domain, issuedTo, issuedBy)
{
	document.getElementById('div_title').innerHTML = "<b>" + msgs.MAIN_TI_SMART_TV_STATUS[lang] + "</b> ";
	
	//title
	element_td_col1_url.textContent             = "URL";
    element_td_col1_security1.textContent       = msgs.MAIN_SMART_TV_SECURITY[lang];
    element_td_col1_cert1.textContent           = msgs.MAIN_SMART_TV_CERTIFICATE[lang];
    element_td_col1_video.textContent           = msgs.MAIN_SMART_TV_STREAMING_VIDEO[lang];
    element_td_col1_quality.textContent         = msgs.MAIN_SMART_TV_QUALITY[lang];
    element_td_col1_security2.textContent       = "";
    element_td_col1_cert2.textContent           = "";
	element_td_col2_video.textContent           = "";

	//context
    element_td_col2_url.textContent             = url;
		
	if(domain == 1)
	{
	    element_td_col2_security1.innerHTML  = "<img src=\"netTV_info_icon_lock.png\" width=\"17\" height=\"22\">"+" "+ msgs.MAIN_OSD_SECURE_PAGE[lang];
		element_td_col2_security2.innerHTML  = "";
	    element_td_col2_cert1.textContent    = msgs.MAIN_SMART_TV_ISSUE_TO[lang]+" "+issuedTo;
	    element_td_col2_cert2.textContent    = msgs.MAIN_SMART_TV_BY[lang]+" "+issuedBy;
	}
	else
	{
	    element_td_col2_security1.innerHTML  = msgs.MAIN_OSD_NOT_SECURE_PAGE_DESCRIPTION[lang];
		element_td_col2_security2.innerHTML  = "";
	    element_td_col2_cert1.textContent    = msgs.MAIN_OSD_NO_CERTIFICATE[lang] ;
	    element_td_col2_cert2.textContent    = "";
	
	}

	el_btn_close.innerHTML = msgs.close[lang];
	adapterVideoProcessWidth();
}

function sinfo_close_window() 
{
	browser_ipc.hide('security_info');
}

function init()
{
	element_td_col1_url             = document.getElementById("Td_col1_url");
    element_td_col2_url             = document.getElementById("Td_col2_url");
    element_td_col1_security1       = document.getElementById("Td_col1_security1");
    element_td_col2_security1       = document.getElementById("Td_col2_security1");
    element_td_col1_security2       = document.getElementById("Td_col1_security2");
    element_td_col2_security2       = document.getElementById("Td_col2_security2");
    element_td_col1_cert1           = document.getElementById("Td_col1_cert1");
    element_td_col2_cert1           = document.getElementById("Td_col2_cert1");
    element_td_col1_cert2           = document.getElementById("Td_col1_cert2");
    element_td_col2_cert2           = document.getElementById("Td_col2_cert2");
    element_td_col1_video           = document.getElementById("Td_col1_video");
    element_td_col2_video           = document.getElementById("Td_col2_video");
    element_td_col1_quality         = document.getElementById("Td_col1_quality");
    element_td_col2_quality         = document.getElementById("Td_col2_quality");
	el_progress                     = document.getElementById('progress');
	el_play_sprite                  = document.getElementById('play_sprite');
	el_remaining                    = document.getElementById('remaining');
	el_buffering                    = document.getElementById('buffering');
	el_btn_close                    = document.getElementById('btn_close');

	console.log("browser_ipc can't run at this line, need to check\n");

	el_btn_close.focus();
    //default values
    update_duration(100);
	update_buffering(0);
	update_elapsed(0);
	update_quality(99);

	//read values from browser_ipc
	set_lang(browser_ipc.get_lang());

    sinfo_set_params(browser_ipc.get_sec_addr(), 
    	browser_ipc.get_sec_domain(), 
    	browser_ipc.get_sec_subject(), 
    	browser_ipc.get_sec_issuer());
	
	browser_ipc.get_sec_vs_downloading();
	browser_ipc.get_sec_video_streaming();
	browser_ipc.get_sec_videoquality();

	if (browser_ipc.get_sec_vs_downloading() == 1)//download
	{
		sinfo_set_videoplay_status(1);
		update_quality(browser_ipc.get_sec_videoquality());
	}
	else if (browser_ipc.get_sec_video_streaming() == 1)//video streaming on going
	{
		sinfo_set_videoplay_status(2);
		update_quality(browser_ipc.get_sec_videoquality());
	}
	else
	{
		sinfo_set_videoplay_status(0);
	}
	
}

EventUtil.addHandler(window, "keypress", function(event)
{
	event = EventUtil.getEvent(event);
	
	//logToElement(event.type);
	//logToElement(event.keyCode);
	//var achar = String.fromCharCode(EventUtil.getCharCode(event));

    if (event.keyCode == 13)//enter
	{
       //sinfo_close_window();
	}
});

EventUtil.addHandler(window, "keyup", function(event)
{
	event = EventUtil.getEvent(event);
	
	//logToElement(event.type);
	//logToElement(event.keyCode);
	//var achar = String.fromCharCode(EventUtil.getCharCode(event));

    if (event.keyCode == 13)//enter
	{
       sinfo_close_window();
	}
});


EventUtil.addHandler(window,"click",function(event)
{

    event = EventUtil.getEvent(event);
    //logToElement(event.type);
    //logToElement(event.target.id);
	
	if (event.target.id == "close_sprite")
	{
       sinfo_close_window();
	}


} );

