// JavaScript Document

$(function(){        
   //set_lang('en-US');  //delete this lang setting before release edfu code.  
});

/* debug to output the message to UI. 
    make sure donothing before release */
function logToElement(message)
{
    var console = document.getElementById("debuginfo");
    if (console === null){
        console = document.createElement("div");
        console.id               = "debuginfo";
        console.style.background = "#dedede";
        console.style.border     = "1px solid silver";
        console.style.padding    = "5px";
        console.style.width      = "600px";
        console.style.position   = "absolute";
        console.style.left       = "600px";
        console.style.top        = "0px";
        document.body.appendChild(console);
    }
    console.innerHTML += "<p>" + message + "</p>";
}

var diver = 'none';  // diver is CTN

function set_lang(_lang)
{
	var lang         = 'zh-Hans';
	var lang_index   = 0;	
	
	var arr_langtext = new Array(
		/*-- 0--*/['en-US', 'EN'], //English
		/*-- 1--*/['bg-BG', 'BG'], //Bulgarian
		/*-- 2--*/['cs-CZ', 'CS'], //Czech
		/*-- 3--*/['da-DK', 'DA'], //Danish
		/*-- 4--*/['de-DE', 'DE'], //German
		/*-- 5--*/['el-GR', 'EL'], //Greek
		/*-- 6--*/['et-EE', 'ET'], //Estonian
		/*-- 7--*/['es-ES', 'ES'], //Spanish
		/*-- 8--*/['fr-FR', 'FR'], //French
		/*-- 9--*/['ga-GA', 'GA'], //Gaelic-Irish
		/*--10--*/['hr-HR', 'HR'], //Croatian
		/*--11--*/['it-IT', 'IT'], //Italian
		/*--12--*/['kk-KZ', 'KK'], //Kazakh
		/*--13--*/['lv-LV', 'LV'], //Latvian
		/*--14--*/['lt-LT', 'LT'], //Lithuanian
		/*--15--*/['hu-HU', 'HU'], //Hungarian
		/*--16--*/['nl-NL', 'NL'], //Dutch
		/*--17--*/['no-NO', 'NO'], //Norwegian
		/*--18--*/['pl-PL', 'PL'], //Polish
		/*--19--*/['pt-PT', 'PT'], //Portuguese
		/*--20--*/['ro-RO', 'RO'], //Romanian
		/*--21--*/['ru-RU', 'RU'], //Russian
		/*--22--*/['sl-SL', 'SL'], //Slovenian
		/*--23--*/['sk-SK', 'SK'], //Slovak
		/*--24--*/['sr-YU', 'SR'], //Serbian
		/*--25--*/['fi-FI', 'FI'], //Finnish
		/*--26--*/['sv-SE', 'SV'], //Swedish
		/*--27--*/['tr-TR', 'TR'], //Turkish
		/*--28--*/['uk-UA', 'UK'], //Ukrainian
		/*--29--*/['ar-AE', 'AR'], //Arabic
		/*--30--*/['th-TH', 'TH'], //Thai
		/*--31--*/['he-IL', 'HE'], //Hebrew
		/*--32--*/['zh-Hans','ZH'],//Simplified Chinese
		/*--33--*/['es-AR', 'ES-AR'], //Spanish (Argentina)
		/*--34--*/['pt-BR', 'PT-BR'], //Portuguese (Brazil)
		/*--35--*/['id-ID', 'ID'], //Indonesian
		/*--36--*/['vi-VN', 'VI'], //Vietnamese
		/*--37--*/['sq-SQ', 'SQ'], //Albanian
		/*--38--*/['bs-BS', 'BS'], //Bosnian
		/*--39--*/['mk-MK', 'MK'], //Macedonian
		/*--40--*/['me-ME', 'ME'], //Montenegrin
		/*--41--*/['us-US', 'US'], //English
		/*--42--*/['ms-MS', 'MS'], //Malay
		/*--43--*/['ha-HA', 'HA'], //Traditional Chinese
		/*--44--*/['hs-HS', 'HS'], //Spanish Hispanic
		/*--45--*/['ko-KR', 'KO']); //Korean
        //totol 46
		
	lang = _lang;

        //lang = 'vi-VN';//only for test
		
		/*clear div*/
		if($('#index_level1').length > 0)
		{
			 $('#index_level1').remove();
		}  
	
		if($('.ln-letters').length > 0)
		{  
			 $('.ln-letters').remove();
		}
	
		if($('.menuBg').length > 0)
		{
		    $('.menuBg').remove();
		}
			
		if($('#myList li').length > 0 )
		{
			 $('#myList li').remove();  
		}
		/*clear div end*/
				

    for (lang_index = 0; lang_index < arr_langtext.length; lang_index++)
    {
        if (lang == arr_langtext[lang_index][0])
        {         
            break;
        }
    }
    if (lang_index == arr_langtext.length)
    {
        lang_index=0;
    }

	var device = '0';
	var file_name;
	
	var path = window.location.href.split('data.html')[1];
	if(path.indexOf('device') != -1)
	{
		device = path.split('device=')[1].split('?')[0];
	}	

	if (device == '0')
	{
		file_name = 'content/php/'+arr_langtext[lang_index][1]+'.xml';
	}
	else
	{
		file_name = 'content/aoc/'+arr_langtext[lang_index][1]+'.xml';
	}
	
    if (localStorage) 
    {				
        localStorage.setItem('lang_index', lang_index);
		localStorage.setItem('device', device);
    }
        
	getData(file_name);
    
	ChooseChar();
        
}



function getData(file_name)
{   
	var str       = new Array();
	var diverArry = new Array();
	var path      = window.location.href.split('data.html')[1];
	//var path      = '?diver=43PUS626212?lang=en-US';//for test

	//logToElement( "file  = " + file_name );
	//logToElement( "path  = " + path );

	if(path.indexOf('diver') != -1)
	{
		str = path.split('diver=')[1].split('?')[0];
		device = localStorage.getItem('device');
		var diverleng;

		//CTN length is 11 or 12 for PHP platform;
		//CTN length is 10 for AOC platform.
        if((device == '0') && (str.length == 11 || str.length == 12))
        {
        	diverleng = str.length - 2;
            diver = str.substr(0, diverleng) + '/' + str.substr(diverleng, str.length);	
        }
		else if((device == '1') && str.length == 10)
        {
        	diverleng = str.length - 3;
			diver = str.substr(0, diverleng) + '/' + str.substr(diverleng, str.length);
        }
        else
        {
            diver = 'error(length is not 11)';
        }
	}
	else
	{		
	    diver = 'none';
 	}

	//logToElement( "CTN  = " + diver );

   /*send a HTTP Get request to page, get the data result*/
   $.get(file_name,function(d){    
		
		/*clear div*/
		if($('#index_level1').length > 0)
		{
			 $('#index_level1').remove();
		}  
	
		if($('.ln-letters').length > 0)
		{  
			 $('.ln-letters').remove();
		}
	
		if($('.menuBg').length > 0)
		{
		    $('.menuBg').remove();
		}
			
		if($('#myList li').length > 0 )
		{
			 $('#myList li').remove();  
		}
		/*clear div end*/
		
        /*index data*/		
		$(d).find('index').find('ind').each(function(index){
		
			var $chapter = $(this);
			var $index   = $(this).parent('index');
            
			if(diver!='none' && $index.siblings('diversities').length > 0)//siblings is brother element
			{
				var $diver   = $index.siblings('diversities');
				var diverlen = $diver.children('diversity').length;
				
				if(diverlen > 0)
				{
					var te =  new Array();
					$diver.children('diversity').each(function(i){
						 te[i] = $(this).text();
				    });
					
				    if($.inArray(diver,te) == -1)
					{
						index++;						
					}
					else
					{
						var title = $chapter.text();
						if(title != "")
						{
							var tsrc =  $chapter.parent().parent().attr('src');
							var html = '<li><a>' + title + '?' + tsrc + '</a></li>';
							$('#myList').append($(html));
						}		
					}
				}
			}
			else
			{
				var title = $chapter.text();
				if(title != "")
				{
					var tsrc =  $chapter.parent().parent().attr('src');
					var html = '<li><a>' + title + '?' + tsrc + '</a></li>';
					$('#myList').append($(html));
				}	
			}
		});
        
		indexOrder();

		$('#myList').listnav({showCounts: false, includeOther: true,includeAll: false,noMatchText: ''});
       

       /*book data*/	
		
       $('#book').append('<ul id="index_level1" class="index_level1">');
        
	   $(d).children('chapter').each(function(index){
        
    	      var title = $(this).attr('title');	     
    	      var html  = '<li><a>'+ title +'</a></li>';
    	      var src   = $(this).attr('src');	
              
    	      if(src)
    	      {
    	          html = '<li><a>'+ title +'</a><p>'+ src +'</p></li>';
    	      }
    	      $('#index_level1').append(html);
    	                    
    	      if($(this).children('diversities').children('diversity').length > 0 && diver != 'none')
    	      {	   
                  var diversity = new Array();	      
    	          $(this).children('diversities').children('diversity').each(function(i){
    	                diversity[i] = $(this).text();                    	                
    	          });	
                  
                  if($.inArray(diver,diversity) == -1)
    	          {
    	             $('#index_level1').children('li').eq(index).children('a').html($('#index_level1').children('li').eq(index).children('a').html()+'Mdelete');
    	          }  	          
    	       }
    	      
    	      if($(this).children('subchapters').length > 0) 
    	      {	                   
    	          getSubchapters($(this),$('#index_level1').children('li').eq(index));
    	      }	      
	   }); 
	   
	   deleteLi();
       
	   deleteIndex();
	   
        //localStorage
        var index ={};
        var book  ={};
        var char  ={};
        index     = $('#myList').html();
        book      = $('#book').html();
        char      = $('#myList-nav').html();

        if (localStorage) 
        {
            localStorage.setItem('index', index);
            localStorage.setItem('book', book);
            localStorage.setItem('char', char);
            localStorage.setItem('fileName', file_name);
            localStorage.setItem('ctn', diver);
        }

        browser_ipc.get_edfudata_readystate();
   });
}

function getSubchapters($this,parent)
{
    var i = $this.parents('chapter').length + 2; //submenu num

	/*parents() :find all parents element that is chapter*/

    parent.append('<ul class="index_level'+ i +'"></ul>');
    
    $this.children('subchapters').children('chapter').each(function(index){
        
         var title = $(this).attr('title');
         var html  = '<li><a>'+ title +'</a></li>';
         var src   = $(this).attr('src');         
	     if(src)
	     {
	         html = '<li><a>'+ title +'</a><p>'+ src +'</p></li>';      
	     }	     
	     parent.children('ul').append(html);
         
	     diversityCompare($(this),parent);
	     
	     if($(this).children('subchapters').length > 0)
	     {
	       getSubchapters($(this),parent.children('ul').children('li').eq(index));
	     }
        
    });
}

function diversityCompare($this,parent)
{
   if($this.children('diversities').children('diversity').length > 0 && diver != 'none')
    {
        var diversity = new Array();
        $this.children('diversities').children('diversity').each(function(i){
	         diversity[i] = $(this).text();                    	                
	    });
	               
	    if($.inArray(diver,diversity) == -1)
	    {
	         parent.children('ul').children('li').eq($(this).index()).children('a').html(parent.children('ul').children('li').eq($(this).index()).children('a').html()+'Mdelete');
	    }
    }
        
}

function deleteLi()
{      
    $('#index_level1 a').each(function(index){      
        if($(this).text().indexOf('Mdelete') != -1)
        {
           $(this).parent('li').remove();
        }
    });
    
    $('#index_level1 ul').each(function(){
		if($(this).children('li').length <=0 && $(this).siblings('a').length > 0)
		{
		   $(this).parent('li').remove();  
		}		 
    });    
}

function indexOrder()
{
    var lang_index = localStorage.getItem('lang_index');
    var l          = $('#myList li').length; 
    var arr        = new Array();
    var arry       = new Array();
    var arr_t      = [];
    
    for(var i=0;i<l;i++)
    {
        arr[i]= $('#myList li').eq(i).children('a').text();//get the title
    }

    for(var i = 0; i < arr.length; i++)
    {
        arry[i] = arr[i].toLowerCase();//transfer to lower case for compare
    }

    if(lang_index == '32')// chinese
    { 
        for(var i = 0; i < arr.length;i++)
        {
            if(arry[i].indexOf('®') != -1)
            {
                arry[i] = arry[i].replace(/\®/g,'RR');
            }

            if(arry[i].indexOf('™') != -1)
            {
                arry[i] = arry[i].replace(/\™/g,'TM');
            }
        }

        for(i=0; i <arry.length; i++)
        {
            arr_t[i]=[getSpell(arry[i]), arry[i]];
        }
        
        arr_t=arr_t.sort();
        
        for(i=0;i< arry.length; i++)
        {
            arry[i] = arr_t[i][1];
        }

    }   
    else//other language
    { 
        arry.sort();
    }

    for(var i = 0; i < l; i++)
    {
        for(var n=0; n<l; n++)
        {
            if(arr[i].toLowerCase() == arry[n])
            {
                arry[n] = arr[i];
            }	 
        }
    }

    for(var i=0; i<l ; i++)
    {
        if(lang_index == '32')//chinese
        { 
            if(arry[i].indexOf('RR') != -1)
            {
                arry[i] = arry[i].replace(/\RR/g,'®');
            }
            if(arry[i].indexOf('TM') != -1)
            {
                arry[i] = arry[i].replace(/\TM/g,'™');
            }
        } 

        var text = arry[i].split('?')[0];
        var src  = arry[i].split('?')[1];
        
        $('#myList li').eq(i).children('a').text(text);
        $('#myList li').eq(i).append('<p>');
        $('#myList li').eq(i).children('p').text(src);
        
    }
    
}

function deleteIndex()
{
    if(diver != 'none')
    {
        var bookSrc =  new Array();
        
        $('#index_level1 p').each(function(index){
                bookSrc[index] = $('#index_level1 p').eq(index).text();	
            });
        
        $('#myList p').each(function(){
                if($.inArray($(this).text(),bookSrc) == -1)
                {
                    $(this).parent('li').remove();//if index item is not in book,remote it
                }
            });

        //find all class in mylist
        var listClass = new Array();
        
        listClass[0] = $('#myList').children('li').eq(0).attr('class');

        for(var i = 0,n = 0; i < $('#myList').children('li').length-1; i++)
        { 
            if($('#myList').children('li').eq(i).attr('class') != $('#myList').children('li').eq(i+1).attr('class'))
            {
                listClass[n+1] =$('#myList').children('li').eq(i+1).attr('class'); 	
                n++;
            }
        }

        for(var n=0; n<listClass.length; n++)
        {
            listClass[n] = listClass[n].split('ln-')[1];
        }
        
        //find the all class in ln-letters
        var liClass = new Array();
        
        for(var i=0; i < $('.ln-letters').children('a').length; i++)
        {
            var lClass = $('.ln-letters').children('a').eq(i).attr('class');
            
            if( lClass.indexOf('ln-last') != -1 )
            {
                lClass = lClass.split(' ')[0];//class="y ln-last" get 'y'
            }

            if(lClass.indexOf('ln-selected') !=-1)
            {
                lClass = lClass.split(' ln-selected')[0];//class="_ ln-selected" get _
            }

            liClass[i] = lClass;
        }

        for(var i = 0; i < liClass.length; i++)
        {             
            if($.inArray(liClass[i],listClass) == -1)//if the class in ln-letters but not in mylist, remote it. no use
            {            
                $('.ln-letters').find("."+ liClass[i]).remove();
                
                var first = $('.ln-letters').children('a').eq(0).attr('class');
                
                $('.ln-letters').children('a').eq(0).attr('class', $('.ln-letters').children('a').eq(0).attr('class') + ' ln-selected');

                $('.ln-letters').children('a').eq(0).attr('id','selected');

                $('#myList').children('li[class="ln-' + first + '"]').css('display','list-item');
            }
        }
    }	  
}


