
// JavaScript common function that can be used in any where.

// EventUtil register event for element.

var EventUtil = {

    addHandler: function(element, type, handler){
        if (element.addEventListener){
            element.addEventListener(type, handler, false);
        } else if (element.attachEvent){
            element.attachEvent("on" + type, handler);
        } else {
            element["on" + type] = handler;
        }
    },
    
    getButton: function(event){
        if (document.implementation.hasFeature("MouseEvents", "2.0")){
            return event.button;
        } else {
            switch(event.button){
                case 0:
                case 1:
                case 3:
                case 5:
                case 7:
                    return 0;
                case 2:
                case 6:
                    return 2;
                case 4: return 1;
            }
        }
    },
    
    getCharCode: function(event){
        if (typeof event.charCode == "number"){
            return event.charCode;
        } else {
            return event.keyCode;
        }
    },
    
    getClipboardText: function(event){
        var clipboardData =  (event.clipboardData || window.clipboardData);
        return clipboardData.getData("text");
    },
    
    getEvent: function(event){
        return event ? event : window.event;
    },
    
    getRelatedTarget: function(event){
        if (event.relatedTarget){
            return event.relatedTarget;
        } else if (event.toElement){
            return event.toElement;
        } else if (event.fromElement){
            return event.fromElement;
        } else {
            return null;
        }
    
    },
    
    getTarget: function(event){
        return event.target || event.srcElement;
    },
    
    getWheelDelta: function(event){
        if (event.wheelDelta){
            return (client.engine.opera && client.engine.opera < 9.5 ? -event.wheelDelta : event.wheelDelta);
        } else {
            return -event.detail * 40;
        }
    },
    
    preventDefault: function(event){
        if (event.preventDefault){
            event.preventDefault();
        } else {
            event.returnValue = false;
        }
    },

    removeHandler: function(element, type, handler){
        if (element.removeEventListener){
            element.removeEventListener(type, handler, false);
        } else if (element.detachEvent){
            element.detachEvent("on" + type, handler);
        } else {
            element["on" + type] = null;
        }
    },
    
    setClipboardText: function(event, value){
        if (event.clipboardData){
            event.clipboardData.setData("text/plain", value);
        } else if (window.clipboardData){
            window.clipboardData.setData("text", value);
        }
    },
    
    stopPropagation: function(event){
        if (event.stopPropagation){
            event.stopPropagation();
        } else {
            event.cancelBubble = true;
        }
    }

};



// print log to console for  debug.

function logToConsole(message)
{
    if (typeof console == "object"){
        console.log(message);
    } else if (typeof opera == "object"){
        opera.postError(message);
    } else if (typeof java == "object" && typeof java.lang == "object"){
        java.lang.System.out.println(message);
    }
}

// print log to Element for debug
function logToElement(message)
{
 return;
 
    var console = document.getElementById("debuginfo");
    if (console === null){
        console = document.createElement("div");
        console.id = "debuginfo";
        console.style.background = "#dedede";
        console.style.border = "1px solid silver";
        console.style.padding = "5px";
        console.style.width = "200px";
        console.style.position = "absolute";
        console.style.left = "400px";
        console.style.top = "0px";
        document.body.appendChild(console);

    }
    console.innerHTML += "<p>" + message + "</p>";
}

function SetElementXYWH(element,x,y,w,h)//pix value
{
    element.style.left     = x+"px";
    element.style.top      = y+"px";
    element.style.width    = w+"px";
    element.style.height   = h+"px";
}

function SetElementShow(element,bShow)
{
    if (bShow)
    {
        element.style.visibility="visible";
    }
    else
    {
        element.style.visibility="hidden";
    }
}

function PrintCurWindowXYWH()
{

	var  windowleftPos = (typeof window.screenLeft == "number") ? window.screenLeft : window.screenX,

	     windowtopPos = (typeof window.screenTop == "number") ?window.screenTop : window.screenY,

	     pageWidth = window.innerWidth,

	     pageHeight = window.innerHeight;

	    if (typeof pageWidth != "number")
	    {

	        if (document.compatMode == "CSS1Compat"){

	            pageWidth = document.documentElement.clientWidth;

	            pageHeight = document.documentElement.clientHeight;

	        }
	        else
	        {

	            pageWidth = document.body.clientWidth;

	            pageHeight = document.body.clientHeight;

	        }
	    }
	    
	    //logToElement( "X=" + windowleftPos + " Y=" + windowtopPos +" W=" + pageWidth +" H=" + pageHeight);

}



