/* (c) 2011 Netflix, Inc. Do not copy or use without prior written permission from Netflix, Inc. */
/* global nrdp, nrdjs */

function login() {
    var url = { url: "http://api-global.netflix.com/apps/nrdjs/upgrade_policy" };
    nrdp.gibbon.load(url, function(response) {
        response = JSON.parse(response.data);
        var request = {
            url: response.url,
            headers: {"X-Gibbon-Hash": "sha256=" + response.hash}
        };
        nrdp.gibbon.loadScript(request, function(result) {
            nrdjs.initialize().then(function() {
                return nrdjs.profiles.signin().then(function(result) {
                    if (!result.registered) {
                        nrdp.log.error("Failed to log in\n" + JSON.stringify(result, null, 4));
                        nrdp.exit(1);
                    } else {
                        nrdp.log.success("Logged in!");
                        nrdp.exit(0);
                    }
                });
            });
        });
    });
}

nrdp.gibbon.init(function() {
    if (!nrdp.options["user_name"] || !nrdp.options["user_password"]) {
        nrdp.log.error("\nPlease set NF_USER_NAME and NF_USER_PASSWORD\n \n");
        nrdp.exit(1);
        return;
    }
    if (!nrdp.storage.transientData.signin_reset) {
        nrdp.log.success("Didn't find reset token, factory resetting");
        nrdp.device.factoryReset(function() {
            nrdp.storage.transientData = { signin_reset: true };
            nrdp.log.success("Going back to appboot " + JSON.stringify(nrdp.options.boot_request, null, 4));
            nrdp.gibbon.location = nrdp.options.boot_request;
        });
        return;
    } else {
        nrdp.storage.transientData = {};
    }
    nrdp.log.success("Loading nrdjs");
    nrdp.gibbon.loadScript({ url: "https://nrdpbuilds.netflix.com/view/NRDJS/job/PPD-NRDJS-release/lastSuccessfulBuild/artifact/builds/nrdjs.debug.js" }, function(result) {
        if (result.statusCode != 200) {
            nrdp.log.error("Couldn't load nrdjs\n" + JSON.stringify(result, null, 4));
            nrdp.exit(1);
            return;
        }
        nrdp.log.success("Loaded nrdjs, starting login");
        login();
    });
});
