/*
 protobuf.js (c) 2013 Daniel Wirtz <dcode@dcode.io>
 Released under the Apache License, Version 2.0
 see: https://github.com/dcodeIO/protobuf.js for details
*/
(function(h,u){"function"===typeof define&&define.amd?define(["bytebuffer"],u):"function"===typeof require&&"object"===typeof module&&module&&module.exports?module.exports=u(require("bytebuffer"),!0):(h.dcodeIO=h.dcodeIO||{}).ProtoBuf=u(h.dcodeIO.ByteBuffer)})(this,function(h,u){var d={};d.ByteBuffer=h;d.Long=h.Long||null;d.VERSION="5.0.1";d.WIRE_TYPES={};d.WIRE_TYPES.VARINT=0;d.WIRE_TYPES.BITS64=1;d.WIRE_TYPES.LDELIM=2;d.WIRE_TYPES.STARTGROUP=3;d.WIRE_TYPES.ENDGROUP=4;d.WIRE_TYPES.BITS32=5;d.PACKABLE_WIRE_TYPES=
[d.WIRE_TYPES.VARINT,d.WIRE_TYPES.BITS64,d.WIRE_TYPES.BITS32];d.TYPES={int32:{name:"int32",wireType:d.WIRE_TYPES.VARINT,defaultValue:0},uint32:{name:"uint32",wireType:d.WIRE_TYPES.VARINT,defaultValue:0},sint32:{name:"sint32",wireType:d.WIRE_TYPES.VARINT,defaultValue:0},int64:{name:"int64",wireType:d.WIRE_TYPES.VARINT,defaultValue:d.Long?d.Long.ZERO:void 0},uint64:{name:"uint64",wireType:d.WIRE_TYPES.VARINT,defaultValue:d.Long?d.Long.UZERO:void 0},sint64:{name:"sint64",wireType:d.WIRE_TYPES.VARINT,
defaultValue:d.Long?d.Long.ZERO:void 0},bool:{name:"bool",wireType:d.WIRE_TYPES.VARINT,defaultValue:!1},"double":{name:"double",wireType:d.WIRE_TYPES.BITS64,defaultValue:0},string:{name:"string",wireType:d.WIRE_TYPES.LDELIM,defaultValue:""},bytes:{name:"bytes",wireType:d.WIRE_TYPES.LDELIM,defaultValue:null},fixed32:{name:"fixed32",wireType:d.WIRE_TYPES.BITS32,defaultValue:0},sfixed32:{name:"sfixed32",wireType:d.WIRE_TYPES.BITS32,defaultValue:0},fixed64:{name:"fixed64",wireType:d.WIRE_TYPES.BITS64,
defaultValue:d.Long?d.Long.UZERO:void 0},sfixed64:{name:"sfixed64",wireType:d.WIRE_TYPES.BITS64,defaultValue:d.Long?d.Long.ZERO:void 0},"float":{name:"float",wireType:d.WIRE_TYPES.BITS32,defaultValue:0},"enum":{name:"enum",wireType:d.WIRE_TYPES.VARINT,defaultValue:0},message:{name:"message",wireType:d.WIRE_TYPES.LDELIM,defaultValue:null},group:{name:"group",wireType:d.WIRE_TYPES.STARTGROUP,defaultValue:null}};d.MAP_KEY_TYPES=[d.TYPES.int32,d.TYPES.sint32,d.TYPES.sfixed32,d.TYPES.uint32,d.TYPES.fixed32,
d.TYPES.int64,d.TYPES.sint64,d.TYPES.sfixed64,d.TYPES.uint64,d.TYPES.fixed64,d.TYPES.bool,d.TYPES.string,d.TYPES.bytes];d.ID_MIN=1;d.ID_MAX=536870911;d.convertFieldsToCamelCase=!1;d.populateAccessors=!0;d.populateDefaults=!0;d.Util=function(){var b={};b.IS_NODE=!("object"!==typeof process||"[object process]"!==process+""||process.browser);b.XHR=function(){for(var b=[function(){return new XMLHttpRequest},function(){return new ActiveXObject("Msxml2.XMLHTTP")},function(){return new ActiveXObject("Msxml3.XMLHTTP")},
function(){return new ActiveXObject("Microsoft.XMLHTTP")}],d=null,h=0;h<b.length;h++){try{d=b[h]()}catch(n){continue}break}if(!d)throw Error("XMLHttpRequest is not supported");return d};b.fetch=function(d,p){p&&"function"!=typeof p&&(p=null);if(b.IS_NODE){var h=require("fs");if(p)h.readFile(d,function(b,d){b?p(null):p(""+d)});else try{return h.readFileSync(d)}catch(n){return null}}else{var k=b.XHR();k.open("GET",d,p?!0:!1);k.setRequestHeader("Accept","text/plain");"function"===typeof k.overrideMimeType&&
k.overrideMimeType("text/plain");if(p)k.onreadystatechange=function(){4==k.readyState&&(200==k.status||0==k.status&&"string"===typeof k.responseText?p(k.responseText):p(null))},4!=k.readyState&&k.send(null);else return k.send(null),200==k.status||0==k.status&&"string"===typeof k.responseText?k.responseText:null}};b.toCamelCase=function(b){return b.replace(/_([a-zA-Z])/g,function(b,d){return d.toUpperCase()})};return b}();d.Lang={DELIM:/[\s\{\}=;:\[\],'"\(\)<>]/g,RULE:/^(?:required|optional|repeated|map)$/,
TYPE:/^(?:double|float|int32|uint32|sint32|int64|uint64|sint64|fixed32|sfixed32|fixed64|sfixed64|bool|string|bytes)$/,NAME:/^[a-zA-Z_][a-zA-Z_0-9]*$/,TYPEDEF:/^[a-zA-Z][a-zA-Z_0-9]*$/,TYPEREF:/^(?:\.?[a-zA-Z_][a-zA-Z_0-9]*)+$/,FQTYPEREF:/^(?:\.[a-zA-Z][a-zA-Z_0-9]*)+$/,NUMBER:/^-?(?:[1-9][0-9]*|0|0[xX][0-9a-fA-F]+|0[0-7]+|([0-9]*(\.[0-9]*)?([Ee][+-]?[0-9]+)?)|inf|nan)$/,NUMBER_DEC:/^(?:[1-9][0-9]*|0)$/,NUMBER_HEX:/^0[xX][0-9a-fA-F]+$/,NUMBER_OCT:/^0[0-7]+$/,NUMBER_FLT:/^([0-9]*(\.[0-9]*)?([Ee][+-]?[0-9]+)?|inf|nan)$/,
BOOL:/^(?:true|false)$/i,ID:/^(?:[1-9][0-9]*|0|0[xX][0-9a-fA-F]+|0[0-7]+)$/,NEGID:/^\-?(?:[1-9][0-9]*|0|0[xX][0-9a-fA-F]+|0[0-7]+)$/,WHITESPACE:/\s/,STRING:/(?:"([^"\\]*(?:\\.[^"\\]*)*)")|(?:'([^'\\]*(?:\\.[^'\\]*)*)')/g,STRING_DQ:/(?:"([^"\\]*(?:\\.[^"\\]*)*)")/g,STRING_SQ:/(?:'([^'\\]*(?:\\.[^'\\]*)*)')/g};d.DotProto=function(b,d){function h(b,c){var a=-1,l=1;"-"==b.charAt(0)&&(l=-1,b=b.substring(1));if(d.NUMBER_DEC.test(b))a=parseInt(b);else if(d.NUMBER_HEX.test(b))a=parseInt(b.substring(2),16);
else if(d.NUMBER_OCT.test(b))a=parseInt(b.substring(1),8);else throw Error("illegal id value: "+(0>l?"-":"")+b);a=l*a|0;if(!c&&0>a)throw Error("illegal id value: "+(0>l?"-":"")+b);return a}function q(b){var c=1;"-"==b.charAt(0)&&(c=-1,b=b.substring(1));if(d.NUMBER_DEC.test(b))return c*parseInt(b,10);if(d.NUMBER_HEX.test(b))return c*parseInt(b.substring(2),16);if(d.NUMBER_OCT.test(b))return c*parseInt(b.substring(1),8);if("inf"===b)return Infinity*c;if("nan"===b)return NaN;if(d.NUMBER_FLT.test(b))return c*
parseFloat(b);throw Error("illegal number value: "+(0>c?"-":"")+b);}function n(b,c,d){"undefined"===typeof b[c]?b[c]=d:(Array.isArray(b[c])||(b[c]=[b[c]]),b[c].push(d))}var k={},a=function(b){this.source=b+"";this.index=0;this.line=1;this.stack=[];this._stringOpen=null},e=a.prototype;e._readString=function(){var b='"'===this._stringOpen?d.STRING_DQ:d.STRING_SQ;b.lastIndex=this.index-1;var c=b.exec(this.source);if(!c)throw Error("unterminated string");this.index=b.lastIndex;this.stack.push(this._stringOpen);
this._stringOpen=null;return c[1]};e.next=function(){if(0<this.stack.length)return this.stack.shift();if(this.index>=this.source.length)return null;if(null!==this._stringOpen)return this._readString();var b,c;do{for(b=!1;d.WHITESPACE.test(c=this.source.charAt(this.index));)if("\n"===c&&++this.line,++this.index===this.source.length)return null;if("/"===this.source.charAt(this.index))if(++this.index,"/"===this.source.charAt(this.index)){for(;"\n"!==this.source.charAt(++this.index);)if(this.index==this.source.length)return null;
++this.index;++this.line;b=!0}else if("*"===(c=this.source.charAt(this.index))){do{"\n"===c&&++this.line;if(++this.index===this.source.length)return null;b=c;c=this.source.charAt(this.index)}while("*"!==b||"/"!==c);++this.index;b=!0}else return"/"}while(b);if(this.index===this.source.length)return null;c=this.index;d.DELIM.lastIndex=0;if(!d.DELIM.test(this.source.charAt(c++)))for(;c<this.source.length&&!d.DELIM.test(this.source.charAt(c));)++c;c=this.source.substring(this.index,this.index=c);if('"'===
c||"'"===c)this._stringOpen=c;return c};e.peek=function(){if(0===this.stack.length){var b=this.next();if(null===b)return null;this.stack.push(b)}return this.stack[0]};e.skip=function(b){var c=this.next();if(c!==b)throw Error("illegal '"+c+"', '"+b+"' expected");};e.omit=function(b){return this.peek()===b?(this.next(),!0):!1};e.toString=function(){return"Tokenizer ("+this.index+"/"+this.source.length+" at line "+this.line+")"};k.Tokenizer=a;var f=function(b){this.tn=new a(b);this.proto3=!1},e=f.prototype;
e.parse=function(){var b={name:"[ROOT]","package":null,messages:[],enums:[],imports:[],options:{},services:[]},c,a=!0,l;try{for(;c=this.tn.next();)switch(c){case "package":if(!a||null!==b["package"])throw Error("unexpected 'package'");c=this.tn.next();if(!d.TYPEREF.test(c))throw Error("illegal package name: "+c);this.tn.skip(";");b["package"]=c;break;case "import":if(!a)throw Error("unexpected 'import'");c=this.tn.peek();("public"===c||(l="weak"===c))&&this.tn.next();c=this._readString();this.tn.skip(";");
l||b.imports.push(c);break;case "syntax":if(!a)throw Error("unexpected 'syntax'");this.tn.skip("=");"proto3"===(b.syntax=this._readString())&&(this.proto3=!0);this.tn.skip(";");break;case "message":this._parseMessage(b,null);a=!1;break;case "enum":this._parseEnum(b);a=!1;break;case "option":this._parseOption(b);break;case "service":this._parseService(b);break;case "extend":this._parseExtend(b);break;default:throw Error("unexpected '"+c+"'");}}catch(e){throw e.message="Parse error at line "+this.tn.line+
": "+e.message,e;}delete b.name;return b};f.parse=function(b){return(new f(b)).parse()};e._readString=function(){var b="",c;do{c=this.tn.next();if("'"!==c&&'"'!==c)throw Error("illegal string delimiter: "+c);b+=this.tn.next();this.tn.skip(c);c=this.tn.peek()}while('"'===c||'"'===c);return b};e._readValue=function(b){var c=this.tn.peek();if('"'===c||"'"===c)return this._readString();this.tn.next();if(d.NUMBER.test(c))return q(c);if(d.BOOL.test(c))return"true"===c.toLowerCase();if(b&&d.TYPEREF.test(c))return c;
throw Error("illegal value: "+c);};e._parseOption=function(b,c){var a=this.tn.next(),l=!1;"("===a&&(l=!0,a=this.tn.next());if(!d.TYPEREF.test(a))throw Error("illegal option name: "+a);var e=a;l&&(this.tn.skip(")"),e="("+e+")",a=this.tn.peek(),d.FQTYPEREF.test(a)&&(e+=a,this.tn.next()));this.tn.skip("=");this._parseOptionValue(b,e);c||this.tn.skip(";")};e._parseOptionValue=function(b,c){var a=this.tn.peek();if("{"!==a)n(b.options,c,this._readValue(!0));else for(this.tn.skip("{");"}"!==(a=this.tn.next());){if(!d.NAME.test(a))throw Error("illegal option name: "+
c+"."+a);this.tn.omit(":")?n(b.options,c+"."+a,this._readValue(!0)):this._parseOptionValue(b,c+"."+a)}};e._parseService=function(b){var c=this.tn.next();if(!d.NAME.test(c))throw Error("illegal service name at line "+this.tn.line+": "+c);var a={name:c,rpc:{},options:{}};for(this.tn.skip("{");"}"!==(c=this.tn.next());)if("option"===c)this._parseOption(a);else if("rpc"===c)this._parseServiceRPC(a);else throw Error("illegal service token: "+c);this.tn.omit(";");b.services.push(a)};e._parseServiceRPC=
function(b){var c=this.tn.next();if(!d.NAME.test(c))throw Error("illegal rpc service method name: "+c);var a=c,l={request:null,response:null,request_stream:!1,response_stream:!1,options:{}};this.tn.skip("(");c=this.tn.next();"stream"===c.toLowerCase()&&(l.request_stream=!0,c=this.tn.next());if(!d.TYPEREF.test(c))throw Error("illegal rpc service request type: "+c);l.request=c;this.tn.skip(")");c=this.tn.next();if("returns"!==c.toLowerCase())throw Error("illegal rpc service request type delimiter: "+
c);this.tn.skip("(");c=this.tn.next();"stream"===c.toLowerCase()&&(l.response_stream=!0,c=this.tn.next());l.response=c;this.tn.skip(")");c=this.tn.peek();if("{"===c){for(this.tn.next();"}"!==(c=this.tn.next());)if("option"===c)this._parseOption(l);else throw Error("illegal rpc service token: "+c);this.tn.omit(";")}else this.tn.skip(";");"undefined"===typeof b.rpc&&(b.rpc={});b.rpc[a]=l};e._parseMessage=function(b,c){var a=!!c,l=this.tn.next(),e={name:"",fields:[],enums:[],messages:[],options:{},services:[],
oneofs:{}};if(!d.NAME.test(l))throw Error("illegal "+(a?"group":"message")+" name: "+l);e.name=l;a&&(this.tn.skip("="),c.id=h(this.tn.next()),e.isGroup=!0);l=this.tn.peek();"["===l&&c&&this._parseFieldOptions(c);for(this.tn.skip("{");"}"!==(l=this.tn.next());)if(d.RULE.test(l))this._parseMessageField(e,l);else if("oneof"===l)this._parseMessageOneOf(e);else if("enum"===l)this._parseEnum(e);else if("message"===l)this._parseMessage(e);else if("option"===l)this._parseOption(e);else if("service"===l)this._parseService(e);
else if("extensions"===l)e.hasOwnProperty("extensions")?e.extensions=e.extensions.concat(this._parseExtensionRanges()):e.extensions=this._parseExtensionRanges();else if("reserved"===l)this._parseIgnored();else if("extend"===l)this._parseExtend(e);else if(d.TYPEREF.test(l)){if(!this.proto3)throw Error("illegal field rule: "+l);this._parseMessageField(e,"optional",l)}else throw Error("illegal message token: "+l);this.tn.omit(";");b.messages.push(e);return e};e._parseIgnored=function(){for(;";"!==this.tn.peek();)this.tn.next();
this.tn.skip(";")};e._parseMessageField=function(b,c,a){if(!d.RULE.test(c))throw Error("illegal message field rule: "+c);var e={rule:c,type:"",name:"",options:{},id:0};if("map"===c){if(a)throw Error("illegal type: "+a);this.tn.skip("<");c=this.tn.next();if(!d.TYPE.test(c)&&!d.TYPEREF.test(c))throw Error("illegal message field type: "+c);e.keytype=c;this.tn.skip(",");c=this.tn.next();if(!d.TYPE.test(c)&&!d.TYPEREF.test(c))throw Error("illegal message field: "+c);e.type=c;this.tn.skip(">");c=this.tn.next();
if(!d.NAME.test(c))throw Error("illegal message field name: "+c);e.name=c;this.tn.skip("=");e.id=h(this.tn.next());c=this.tn.peek();"["===c&&this._parseFieldOptions(e);this.tn.skip(";")}else if(a="undefined"!==typeof a?a:this.tn.next(),"group"===a){c=this._parseMessage(b,e);if(!/^[A-Z]/.test(c.name))throw Error("illegal group name: "+c.name);e.type=c.name;e.name=c.name.toLowerCase();this.tn.omit(";")}else{if(!d.TYPE.test(a)&&!d.TYPEREF.test(a))throw Error("illegal message field type: "+a);e.type=
a;c=this.tn.next();if(!d.NAME.test(c))throw Error("illegal message field name: "+c);e.name=c;this.tn.skip("=");e.id=h(this.tn.next());c=this.tn.peek();"["===c&&this._parseFieldOptions(e);this.tn.skip(";")}b.fields.push(e);return e};e._parseMessageOneOf=function(b){var c=this.tn.next();if(!d.NAME.test(c))throw Error("illegal oneof name: "+c);var a=c,e=[];for(this.tn.skip("{");"}"!==(c=this.tn.next());)c=this._parseMessageField(b,"optional",c),c.oneof=a,e.push(c.id);this.tn.omit(";");b.oneofs[a]=e};
e._parseFieldOptions=function(b){this.tn.skip("[");for(var c=!0;"]"!==this.tn.peek();)c||this.tn.skip(","),this._parseOption(b,!0),c=!1;this.tn.next()};e._parseEnum=function(b){var c={name:"",values:[],options:{}},a=this.tn.next();if(!d.NAME.test(a))throw Error("illegal name: "+a);c.name=a;for(this.tn.skip("{");"}"!==(a=this.tn.next());)if("option"===a)this._parseOption(c);else{if(!d.NAME.test(a))throw Error("illegal name: "+a);this.tn.skip("=");var e={name:a,id:h(this.tn.next(),!0)},a=this.tn.peek();
"["===a&&this._parseFieldOptions({options:{}});this.tn.skip(";");c.values.push(e)}this.tn.omit(";");b.enums.push(c)};e._parseExtensionRanges=function(){var a=[],c,d;do{for(d=[];;){c=this.tn.next();switch(c){case "min":c=b.ID_MIN;break;case "max":c=b.ID_MAX;break;default:c=q(c)}d.push(c);if(2===d.length)break;if("to"!==this.tn.peek()){d.push(c);break}this.tn.next()}a.push(d)}while(this.tn.omit(","));this.tn.skip(";");return a};e._parseExtend=function(b){var a=this.tn.next();if(!d.TYPEREF.test(a))throw Error("illegal extend reference: "+
a);var e={ref:a,fields:[]};for(this.tn.skip("{");"}"!==(a=this.tn.next());)if(d.RULE.test(a))this._parseMessageField(e,a);else if(d.TYPEREF.test(a)){if(!this.proto3)throw Error("illegal field rule: "+a);this._parseMessageField(e,"optional",a)}else throw Error("illegal extend token: "+a);this.tn.omit(";");b.messages.push(e);return e};e.toString=function(){return"Parser at line "+this.tn.line};k.Parser=f;return k}(d,d.Lang);d.Reflect=function(b){function d(g,m){if(g&&"number"===typeof g.low&&"number"===
typeof g.high&&"boolean"===typeof g.unsigned&&g.low===g.low&&g.high===g.high)return new b.Long(g.low,g.high,"undefined"===typeof m?g.unsigned:m);if("string"===typeof g)return b.Long.fromString(g,m||!1,10);if("number"===typeof g)return b.Long.fromNumber(g,m||!1);throw Error("not convertible to Long");}function p(g,m){var a=m.readVarint32(),c=a&7,a=a>>>3;switch(c){case b.WIRE_TYPES.VARINT:do a=m.readUint8();while(128===(a&128));break;case b.WIRE_TYPES.BITS64:m.offset+=8;break;case b.WIRE_TYPES.LDELIM:a=
m.readVarint32();m.offset+=a;break;case b.WIRE_TYPES.STARTGROUP:p(a,m);break;case b.WIRE_TYPES.ENDGROUP:if(a===g)return!1;throw Error("Illegal GROUPEND after unknown group: "+a+" ("+g+" expected)");case b.WIRE_TYPES.BITS32:m.offset+=4;break;default:throw Error("Illegal wire type in unknown group "+g+": "+c);}return!0}var q={},n=function(g,b,a){this.builder=g;this.parent=b;this.name=a},k=n.prototype;k.fqn=function(){var g=this.name,b=this;do{b=b.parent;if(null==b)break;g=b.name+"."+g}while(1);return g};
k.toString=function(g){return(g?this.className+" ":"")+this.fqn()};k.build=function(){throw Error(this.toString(!0)+" cannot be built directly");};q.T=n;var a=function(g,b,a,c,d){n.call(this,g,b,a);this.className="Namespace";this.children=[];this.options=c||{};this.syntax=d||"proto2"},k=a.prototype=Object.create(n.prototype);k.getChildren=function(b){b=b||null;if(null==b)return this.children.slice();for(var a=[],c=0,d=this.children.length;c<d;++c)this.children[c]instanceof b&&a.push(this.children[c]);
return a};k.addChild=function(b){var a;if(a=this.getChild(b.name))if(a instanceof s.Field&&a.name!==a.originalName&&null===this.getChild(a.originalName))a.name=a.originalName;else if(b instanceof s.Field&&b.name!==b.originalName&&null===this.getChild(b.originalName))b.name=b.originalName;else throw Error("Duplicate name in namespace "+this.toString(!0)+": "+b.name);this.children.push(b)};k.getChild=function(b){for(var a="number"===typeof b?"id":"name",c=0,d=this.children.length;c<d;++c)if(this.children[c][a]===
b)return this.children[c];return null};k.resolve=function(b,a){var c="string"===typeof b?b.split("."):b,d=this,e=0;if(""===c[e]){for(;null!==d.parent;)d=d.parent;e++}do{do{if(!(d instanceof q.Namespace)){d=null;break}d=d.getChild(c[e]);if(!(d&&d instanceof q.T)||a&&!(d instanceof q.Namespace)){d=null;break}e++}while(e<c.length);if(null!=d)break;if(null!==this.parent)return this.parent.resolve(b,a)}while(null!=d);return d};k.qn=function(b){var a=[],c=b;do a.unshift(c.name),c=c.parent;while(null!==
c);for(c=1;c<=a.length;c++){var d=a.slice(a.length-c);if(b===this.resolve(d,b instanceof q.Namespace))return d.join(".")}return b.fqn()};k.build=function(){for(var b={},c=this.children,d=0,e=c.length,l;d<e;++d)l=c[d],l instanceof a&&(b[l.name]=l.build());Object.defineProperty&&Object.defineProperty(b,"$options",{value:this.buildOpt()});return b};k.buildOpt=function(){for(var b={},a=Object.keys(this.options),c=0,d=a.length;c<d;++c)b[a[c]]=this.options[a[c]];return b};k.getOption=function(b){return"undefined"===
typeof b?this.options:"undefined"!==typeof this.options[b]?this.options[b]:null};q.Namespace=a;var e=function(g,a,c,d,e){this.type=g;this.resolvedType=a;this.isMapKey=c;this.syntax=d;this.name=e;if(c&&0>b.MAP_KEY_TYPES.indexOf(g))throw Error("Invalid map key type: "+g.name);},f=e.prototype;e.defaultFieldValue=function(g){"string"===typeof g&&(g=b.TYPES[g]);if("undefined"===typeof g.defaultValue)throw Error("default value for type "+g.name+" is not supported");return g==b.TYPES.bytes?new h(0):g.defaultValue};
f.toString=function(){return(this.name||"")+(this.isMapKey?"map":"value")+" element"};f.verifyValue=function(g){function a(b,g){throw Error("Illegal value for "+c.toString(!0)+" of type "+c.type.name+": "+b+" ("+g+")");}var c=this;switch(this.type){case b.TYPES.int32:case b.TYPES.sint32:case b.TYPES.sfixed32:return("number"!==typeof g||g===g&&0!==g%1)&&a(typeof g,"not an integer"),4294967295<g?g|0:g;case b.TYPES.uint32:case b.TYPES.fixed32:return("number"!==typeof g||g===g&&0!==g%1)&&a(typeof g,"not an integer"),
0>g?g>>>0:g;case b.TYPES.int64:case b.TYPES.sint64:case b.TYPES.sfixed64:if(b.Long)try{return d(g,!1)}catch(e){a(typeof g,e.message)}else a(typeof g,"requires Long.js");case b.TYPES.uint64:case b.TYPES.fixed64:if(b.Long)try{return d(g,!0)}catch(l){a(typeof g,l.message)}else a(typeof g,"requires Long.js");case b.TYPES.bool:return"boolean"!==typeof g&&a(typeof g,"not a boolean"),g;case b.TYPES["float"]:case b.TYPES["double"]:return"number"!==typeof g&&a(typeof g,"not a number"),g;case b.TYPES.string:return"string"===
typeof g||g&&g instanceof String||a(typeof g,"not a string"),""+g;case b.TYPES.bytes:return h.isByteBuffer(g)?g:h.wrap(g,"base64");case b.TYPES["enum"]:for(var f=this.resolvedType.getChildren(b.Reflect.Enum.Value),k=0;k<f.length;k++)if(f[k].name==g||f[k].id==g)return f[k].id;if("proto3"===this.syntax)return("number"!==typeof g||g===g&&0!==g%1)&&a(typeof g,"not an integer"),(4294967295<g||0>g)&&a(typeof g,"not in range for uint32"),g;a(g,"not a valid enum value");case b.TYPES.group:case b.TYPES.message:g&&
"object"===typeof g||a(typeof g,"object expected");if(g instanceof this.resolvedType.clazz)return g;if(g instanceof b.Builder.Message){var f={},k;for(k in g)g.hasOwnProperty(k)&&(f[k]=g[k]);g=f}return new this.resolvedType.clazz(g)}throw Error("[INTERNAL] Illegal value for "+this.toString(!0)+": "+g+" (undefined type "+this.type+")");};f.calculateLength=function(g,a){if(null===a)return 0;var c;switch(this.type){case b.TYPES.int32:return 0>a?h.calculateVarint64(a):h.calculateVarint32(a);case b.TYPES.uint32:return h.calculateVarint32(a);
case b.TYPES.sint32:return h.calculateVarint32(h.zigZagEncode32(a));case b.TYPES.fixed32:case b.TYPES.sfixed32:case b.TYPES["float"]:return 4;case b.TYPES.int64:case b.TYPES.uint64:return h.calculateVarint64(a);case b.TYPES.sint64:return h.calculateVarint64(h.zigZagEncode64(a));case b.TYPES.fixed64:case b.TYPES.sfixed64:return 8;case b.TYPES.bool:return 1;case b.TYPES["enum"]:return h.calculateVarint32(a);case b.TYPES["double"]:return 8;case b.TYPES.string:return c=h.calculateUTF8Bytes(a),h.calculateVarint32(c)+
c;case b.TYPES.bytes:if(0>a.remaining())throw Error("Illegal value for "+this.toString(!0)+": "+a.remaining()+" bytes remaining");return h.calculateVarint32(a.remaining())+a.remaining();case b.TYPES.message:return c=this.resolvedType.calculate(a),h.calculateVarint32(c)+c;case b.TYPES.group:return c=this.resolvedType.calculate(a),c+h.calculateVarint32(g<<3|b.WIRE_TYPES.ENDGROUP)}throw Error("[INTERNAL] Illegal value to encode in "+this.toString(!0)+": "+a+" (unknown type)");};f.encodeValue=function(g,
a,c){if(null===a)return c;switch(this.type){case b.TYPES.int32:0>a?c.writeVarint64(a):c.writeVarint32(a);break;case b.TYPES.uint32:c.writeVarint32(a);break;case b.TYPES.sint32:c.writeVarint32ZigZag(a);break;case b.TYPES.fixed32:c.writeUint32(a);break;case b.TYPES.sfixed32:c.writeInt32(a);break;case b.TYPES.int64:case b.TYPES.uint64:c.writeVarint64(a);break;case b.TYPES.sint64:c.writeVarint64ZigZag(a);break;case b.TYPES.fixed64:c.writeUint64(a);break;case b.TYPES.sfixed64:c.writeInt64(a);break;case b.TYPES.bool:"string"===
typeof a?c.writeVarint32("false"===a.toLowerCase()?0:!!a):c.writeVarint32(a?1:0);break;case b.TYPES["enum"]:c.writeVarint32(a);break;case b.TYPES["float"]:c.writeFloat32(a);break;case b.TYPES["double"]:c.writeFloat64(a);break;case b.TYPES.string:c.writeVString(a);break;case b.TYPES.bytes:if(0>a.remaining())throw Error("Illegal value for "+this.toString(!0)+": "+a.remaining()+" bytes remaining");g=a.offset;c.writeVarint32(a.remaining());c.append(a);a.offset=g;break;case b.TYPES.message:g=(new h).LE();
this.resolvedType.encode(a,g);c.writeVarint32(g.offset);c.append(g.flip());break;case b.TYPES.group:this.resolvedType.encode(a,c);c.writeVarint32(g<<3|b.WIRE_TYPES.ENDGROUP);break;default:throw Error("[INTERNAL] Illegal value to encode in "+this.toString(!0)+": "+a+" (unknown type)");}return c};f.decode=function(a,c,d){if(c!=this.type.wireType)throw Error("Unexpected wire type for element");switch(this.type){case b.TYPES.int32:return a.readVarint32()|0;case b.TYPES.uint32:return a.readVarint32()>>>
0;case b.TYPES.sint32:return a.readVarint32ZigZag()|0;case b.TYPES.fixed32:return a.readUint32()>>>0;case b.TYPES.sfixed32:return a.readInt32()|0;case b.TYPES.int64:return a.readVarint64();case b.TYPES.uint64:return a.readVarint64().toUnsigned();case b.TYPES.sint64:return a.readVarint64ZigZag();case b.TYPES.fixed64:return a.readUint64();case b.TYPES.sfixed64:return a.readInt64();case b.TYPES.bool:return!!a.readVarint32();case b.TYPES["enum"]:return a.readVarint32();case b.TYPES["float"]:return a.readFloat();
case b.TYPES["double"]:return a.readDouble();case b.TYPES.string:return a.readVString();case b.TYPES.bytes:d=a.readVarint32();if(a.remaining()<d)throw Error("Illegal number of bytes for "+this.toString(!0)+": "+d+" required but got only "+a.remaining());c=a.clone();c.limit=c.offset+d;a.offset+=d;return c;case b.TYPES.message:return d=a.readVarint32(),this.resolvedType.decode(a,d);case b.TYPES.group:return this.resolvedType.decode(a,-1,d)}throw Error("[INTERNAL] Illegal decode type");};f.valueFromString=
function(a){if(!this.isMapKey)throw Error("valueFromString() called on non-map-key element");switch(this.type){case b.TYPES.int32:case b.TYPES.sint32:case b.TYPES.sfixed32:case b.TYPES.uint32:case b.TYPES.fixed32:return this.verifyValue(parseInt(a));case b.TYPES.int64:case b.TYPES.sint64:case b.TYPES.sfixed64:case b.TYPES.uint64:case b.TYPES.fixed64:return this.verifyValue(a);case b.TYPES.bool:return"true"===a;case b.TYPES.string:return this.verifyValue(a);case b.TYPES.bytes:return h.fromBinary(a)}};
f.valueToString=function(a){if(!this.isMapKey)throw Error("valueToString() called on non-map-key element");return this.type===b.TYPES.bytes?a.toString("binary"):a.toString()};q.Element=e;var s=function(b,c,d,e,l,f){a.call(this,b,c,d,e,f);this.className="Message";this.extensions=void 0;this.clazz=null;this.isGroup=!!l;this._fieldsByName=this._fieldsById=this._fields=null},f=s.prototype=Object.create(a.prototype);f.build=function(a){if(this.clazz&&!a)return this.clazz;a=function(b,a){function c(a,g,
d,e){if(null===a||"object"!==typeof a){if(e&&e instanceof b.Reflect.Enum){var m=b.Reflect.Enum.getName(e.object,a);if(null!==m)return m}return a}if(h.isByteBuffer(a))return g?a.toBase64():a.toBuffer();if(b.Long && b.Long.isLong(a))return d?a.toString():b.Long.fromValue(a);var l;if(Array.isArray(a))return l=[],a.forEach(function(a,b){l[b]=c(a,g,d,e)}),l;l={};if(a instanceof b.Map){for(var m=a.entries(),f=m.next();!f.done;f=m.next())l[a.keyElem.valueToString(f.value[0])]=c(f.value[1],g,d,a.valueElem.resolvedType);
return l}var m=a.$type,f=void 0,k;for(k in a)a.hasOwnProperty(k)&&(m&&(f=m.getChild(k))?l[k]=c(a[k],g,d,f.resolvedType):l[k]=c(a[k],g,d));return l}var g=a.getChildren(b.Reflect.Message.Field),d=a.getChildren(b.Reflect.Message.OneOf),e=function(c,m){b.Builder.Message.call(this);for(var l=0,f=d.length;l<f;++l)this[d[l].name]=null;l=0;for(f=g.length;l<f;++l){var k=g[l];this[k.name]=k.repeated?[]:k.map?new b.Map(k):null;!k.required&&"proto3"!==a.syntax||null===k.defaultValue||(this[k.name]=k.defaultValue)}if(0<
arguments.length)if(1!==arguments.length||null===c||"object"!==typeof c||!("function"!==typeof c.encode||c instanceof e)||Array.isArray(c)||c instanceof b.Map||h.isByteBuffer(c)||c instanceof ArrayBuffer||b.Long&&c instanceof b.Long)for(l=0,f=arguments.length;l<f;++l)"undefined"!==typeof(k=arguments[l])&&this.$set(g[l].name,k);else this.$set(c)},m=e.prototype=Object.create(b.Builder.Message.prototype);m.add=function(c,g,d){var e=a._fieldsByName[c];if(!d){if(!e)throw Error(this+"#"+c+" is undefined");
if(!(e instanceof b.Reflect.Message.Field))throw Error(this+"#"+c+" is not a field: "+e.toString(!0));if(!e.repeated)throw Error(this+"#"+c+" is not a repeated field");g=e.verifyValue(g,!0)}null===this[c]&&(this[c]=[]);this[c].push(g);return this};m.$add=m.add;m.set=function(c,g,d){if(c&&"object"===typeof c){d=g;for(var e in c)c.hasOwnProperty(e)&&"undefined"!==typeof(g=c[e])&&this.$set(e,g,d);return this}e=a._fieldsByName[c];if(d)this[c]=g;else{if(!e)throw Error(this+"#"+c+" is not a field: undefined");
if(!(e instanceof b.Reflect.Message.Field))throw Error(this+"#"+c+" is not a field: "+e.toString(!0));this[e.name]=g=e.verifyValue(g)}e&&e.oneof&&(d=this[e.oneof.name],null!==g?(null!==d&&d!==e.name&&(this[d]=null),this[e.oneof.name]=e.name):d===c&&(this[e.oneof.name]=null));return this};m.$set=m.set;m.get=function(c,g){if(g)return this[c];var d=a._fieldsByName[c];if(!(d&&d instanceof b.Reflect.Message.Field))throw Error(this+"#"+c+" is not a field: undefined");if(!(d instanceof b.Reflect.Message.Field))throw Error(this+
"#"+c+" is not a field: "+d.toString(!0));return this[d.name]};m.$get=m.get;for(var l=0;l<g.length;l++){var f=g[l];f instanceof b.Reflect.Message.ExtensionField||a.builder.options.populateAccessors&&function(b){var c=b.originalName.replace(/(_[a-zA-Z])/g,function(a){return a.toUpperCase().replace("_","")}),c=c.substring(0,1).toUpperCase()+c.substring(1),g=b.originalName.replace(/([A-Z])/g,function(a){return"_"+a}),d=function(a,c){this[b.name]=c?a:b.verifyValue(a);return this},e=function(){return this[b.name]};
null===a.getChild("set"+c)&&(m["set"+c]=d);null===a.getChild("set_"+g)&&(m["set_"+g]=d);null===a.getChild("get"+c)&&(m["get"+c]=e);null===a.getChild("get_"+g)&&(m["get_"+g]=e)}(f)}m.encode=function(b,c){"boolean"===typeof b&&(c=b,b=void 0);var g=!1;b||(b=new h,g=!0);var d=b.littleEndian;try{return a.encode(this,b.LE(),c),(g?b.flip():b).LE(d)}catch(e){throw b.LE(d),e;}};e.encode=function(b,a,c){return(new e(b)).encode(a,c)};m.calculate=function(){return a.calculate(this)};m.encodeDelimited=function(b,
c){var g=!1;b||(b=new h,g=!0);var d=(new h).LE();a.encode(this,d,c).flip();b.writeVarint32(d.remaining());b.append(d);return g?b.flip():b};m.encodeAB=function(){try{return this.encode().toArrayBuffer()}catch(b){throw b.encoded&&(b.encoded=b.encoded.toArrayBuffer()),b;}};m.toArrayBuffer=m.encodeAB;m.encodeNB=function(){try{return this.encode().toBuffer()}catch(b){throw b.encoded&&(b.encoded=b.encoded.toBuffer()),b;}};m.toBuffer=m.encodeNB;m.encode64=function(){try{return this.encode().toBase64()}catch(b){throw b.encoded&&
(b.encoded=b.encoded.toBase64()),b;}};m.toBase64=m.encode64;m.encodeHex=function(){try{return this.encode().toHex()}catch(b){throw b.encoded&&(b.encoded=b.encoded.toHex()),b;}};m.toHex=m.encodeHex;m.toRaw=function(b,a){return c(this,!!b,!!a,this.$type)};m.encodeJSON=function(){return JSON.stringify(c(this,!0,!0,this.$type))};e.decode=function(b,c,g){"string"===typeof c&&(g=c,c=-1);"string"===typeof b?b=h.wrap(b,g?g:"base64"):h.isByteBuffer(b)||(b=h.wrap(b));g=b.littleEndian;try{var d=a.decode(b.LE(),
c);b.LE(g);return d}catch(e){throw b.LE(g),e;}};e.decodeDelimited=function(b,c){"string"===typeof b?b=h.wrap(b,c?c:"base64"):h.isByteBuffer(b)||(b=h.wrap(b));if(1>b.remaining())return null;var g=b.offset,d=b.readVarint32();if(b.remaining()<d)return b.offset=g,null;try{var e=a.decode(b.slice(b.offset,b.offset+d).LE());b.offset+=d;return e}catch(m){throw b.offset+=d,m;}};e.decode64=function(b){return e.decode(b,"base64")};e.decodeHex=function(b){return e.decode(b,"hex")};e.decodeJSON=function(b){return new e(JSON.parse(b))};
m.toString=function(){return a.toString()};Object.defineProperty&&(Object.defineProperty(e,"$options",{value:a.buildOpt()}),Object.defineProperty(m,"$options",{value:e.$options}),Object.defineProperty(e,"$type",{value:a}),Object.defineProperty(m,"$type",{value:a}));return e}(b,this);this._fields=[];this._fieldsById={};this._fieldsByName={};for(var c=0,d=this.children.length,e;c<d;c++)if(e=this.children[c],e instanceof t||e instanceof s||e instanceof w){if(a.hasOwnProperty(e.name))throw Error("Illegal reflect child of "+
this.toString(!0)+": "+e.toString(!0)+" cannot override static property '"+e.name+"'");a[e.name]=e.build()}else if(e instanceof s.Field)e.build(),this._fields.push(e),this._fieldsById[e.id]=e,this._fieldsByName[e.name]=e;else if(!(e instanceof s.OneOf||e instanceof l))throw Error("Illegal reflect child of "+this.toString(!0)+": "+this.children[c].toString(!0));return this.clazz=a};f.encode=function(b,a,c){for(var d=null,e,l=0,f=this._fields.length,k;l<f;++l)e=this._fields[l],k=b[e.name],e.required&&
null===k?null===d&&(d=e):e.encode(c?k:e.verifyValue(k),a,b);if(null!==d)throw b=Error("Missing at least one required field for "+this.toString(!0)+": "+d),b.encoded=a,b;return a};f.calculate=function(b){for(var a=0,c=0,d=this._fields.length,e,l;c<d;++c){e=this._fields[c];l=b[e.name];if(e.required&&null===l)throw Error("Missing at least one required field for "+this.toString(!0)+": "+e);a+=e.calculate(l,b)}return a};f.decode=function(a,c,d){"number"!==typeof c&&(c=-1);for(var e=a.offset,l=new this.clazz,
f,k,s;a.offset<e+c||-1===c&&0<a.remaining();){f=a.readVarint32();k=f&7;s=f>>>3;if(k===b.WIRE_TYPES.ENDGROUP){if(s!==d)throw Error("Illegal group end indicator for "+this.toString(!0)+": "+s+" ("+(d?d+" expected":"not a group")+")");break}if(f=this._fieldsById[s])f.repeated&&!f.options.packed?l[f.name].push(f.decode(k,a)):f.map?(k=f.decode(k,a),l[f.name].set(k[0],k[1])):(l[f.name]=f.decode(k,a),f.oneof&&(k=l[f.oneof.name],null!==k&&k!==f.name&&(l[k]=null),l[f.oneof.name]=f.name));else switch(k){case b.WIRE_TYPES.VARINT:a.readVarint32();
break;case b.WIRE_TYPES.BITS32:a.offset+=4;break;case b.WIRE_TYPES.BITS64:a.offset+=8;break;case b.WIRE_TYPES.LDELIM:f=a.readVarint32();a.offset+=f;break;case b.WIRE_TYPES.STARTGROUP:for(;p(s,a););break;default:throw Error("Illegal wire type for unknown field "+s+" in "+this.toString(!0)+"#decode: "+k);}}a=0;for(c=this._fields.length;a<c;++a)if(f=this._fields[a],null===l[f.name])if("proto3"===this.syntax)l[f.name]=f.defaultValue;else{if(f.required)throw a=Error("Missing at least one required field for "+
this.toString(!0)+": "+f.name),a.decoded=l,a;b.populateDefaults&&null!==f.defaultValue&&(l[f.name]=f.defaultValue)}return l};q.Message=s;var c=function(a,c,d,e,l,f,k,h,r,p){n.call(this,a,c,f);this.className="Message.Field";this.required="required"===d;this.repeated="repeated"===d;this.map="map"===d;this.keyType=e||null;this.type=l;this.resolvedType=null;this.id=k;this.options=h||{};this.defaultValue=null;this.oneof=r||null;this.syntax=p||"proto2";this.originalName=this.name;this.keyElement=this.element=
null;!this.builder.options.convertFieldsToCamelCase||this instanceof s.ExtensionField||(this.name=b.Util.toCamelCase(this.name))},f=c.prototype=Object.create(n.prototype);f.build=function(){this.element=new e(this.type,this.resolvedType,!1,this.syntax,this.name);this.map&&(this.keyElement=new e(this.keyType,void 0,!0,this.syntax,this.name));"proto3"!==this.syntax||this.repeated||this.map?"undefined"!==typeof this.options["default"]&&(this.defaultValue=this.verifyValue(this.options["default"])):this.defaultValue=
e.defaultFieldValue(this.type)};f.verifyValue=function(a,c){function d(b,a){throw Error("Illegal value for "+e.toString(!0)+" of type "+e.type.name+": "+b+" ("+a+")");}c=c||!1;var e=this;if(null===a)return this.required&&d(typeof a,"required"),"proto3"===this.syntax&&this.type!==b.TYPES.message&&d(typeof a,"proto3 field without field presence cannot be null"),null;var l;if(this.repeated&&!c){Array.isArray(a)||(a=[a]);var f=[];for(l=0;l<a.length;l++)f.push(this.element.verifyValue(a[l]));return f}if(this.map&&
!c){if(a instanceof b.Map)return a;a instanceof Object||d(typeof a,"expected ProtoBuf.Map or raw object for map field");return new b.Map(this,a)}!this.repeated&&Array.isArray(a)&&d(typeof a,"no array expected");return this.element.verifyValue(a)};f.hasWirePresence=function(a,c){if("proto3"!==this.syntax)return null!==a;if(this.oneof&&c[this.oneof.name]===this.name)return!0;switch(this.type){case b.TYPES.int32:case b.TYPES.sint32:case b.TYPES.sfixed32:case b.TYPES.uint32:case b.TYPES.fixed32:return 0!==
a;case b.TYPES.int64:case b.TYPES.sint64:case b.TYPES.sfixed64:case b.TYPES.uint64:case b.TYPES.fixed64:return 0!==a.low||0!==a.high;case b.TYPES.bool:return a;case b.TYPES["float"]:case b.TYPES["double"]:return 0!==a;case b.TYPES.string:return 0<a.length;case b.TYPES.bytes:return 0<a.remaining();case b.TYPES["enum"]:return 0!==a;case b.TYPES.message:return null!==a;default:return!0}};f.encode=function(a,c,d){if(null===this.type||"object"!==typeof this.type)throw Error("[INTERNAL] Unresolved type in "+
this.toString(!0)+": "+this.type);if(null===a||this.repeated&&0==a.length)return c;try{if(this.repeated){var e;if(this.options.packed&&0<=b.PACKABLE_WIRE_TYPES.indexOf(this.type.wireType)){c.writeVarint32(this.id<<3|b.WIRE_TYPES.LDELIM);c.ensureCapacity(c.offset+=1);var l=c.offset;for(e=0;e<a.length;e++)this.element.encodeValue(this.id,a[e],c);var f=c.offset-l,k=h.calculateVarint32(f);if(1<k){var s=c.slice(l,c.offset),l=l+(k-1);c.offset=l;c.append(s)}c.writeVarint32(f,l-k)}else for(e=0;e<a.length;e++)c.writeVarint32(this.id<<
3|this.type.wireType),this.element.encodeValue(this.id,a[e],c)}else this.map?a.forEach(function(a,d,e){e=h.calculateVarint32(8|this.keyType.wireType)+this.keyElement.calculateLength(1,d)+h.calculateVarint32(16|this.type.wireType)+this.element.calculateLength(2,a);c.writeVarint32(this.id<<3|b.WIRE_TYPES.LDELIM);c.writeVarint32(e);c.writeVarint32(8|this.keyType.wireType);this.keyElement.encodeValue(1,d,c);c.writeVarint32(16|this.type.wireType);this.element.encodeValue(2,a,c)},this):this.hasWirePresence(a,
d)&&(c.writeVarint32(this.id<<3|this.type.wireType),this.element.encodeValue(this.id,a,c))}catch(r){throw Error("Illegal value for "+this.toString(!0)+": "+a+" ("+r+")");}return c};f.calculate=function(a,c){a=this.verifyValue(a);if(null===this.type||"object"!==typeof this.type)throw Error("[INTERNAL] Unresolved type in "+this.toString(!0)+": "+this.type);if(null===a||this.repeated&&0==a.length)return 0;var d=0;try{if(this.repeated){var e,l;if(this.options.packed&&0<=b.PACKABLE_WIRE_TYPES.indexOf(this.type.wireType)){d+=
h.calculateVarint32(this.id<<3|b.WIRE_TYPES.LDELIM);for(e=l=0;e<a.length;e++)l+=this.element.calculateLength(this.id,a[e]);d+=h.calculateVarint32(l);d+=l}else for(e=0;e<a.length;e++)d+=h.calculateVarint32(this.id<<3|this.type.wireType),d+=this.element.calculateLength(this.id,a[e])}else this.map?a.forEach(function(a,c,e){a=h.calculateVarint32(8|this.keyType.wireType)+this.keyElement.calculateLength(1,c)+h.calculateVarint32(16|this.type.wireType)+this.element.calculateLength(2,a);d+=h.calculateVarint32(this.id<<
3|b.WIRE_TYPES.LDELIM);d+=h.calculateVarint32(a);d+=a},this):this.hasWirePresence(a,c)&&(d+=h.calculateVarint32(this.id<<3|this.type.wireType),d+=this.element.calculateLength(this.id,a))}catch(f){throw Error("Illegal value for "+this.toString(!0)+": "+a+" ("+f+")");}return d};f.decode=function(a,c,d){if(!(!this.map&&a==this.type.wireType||!d&&this.repeated&&this.options.packed&&a==b.WIRE_TYPES.LDELIM||this.map&&a==b.WIRE_TYPES.LDELIM))throw Error("Illegal wire type for field "+this.toString(!0)+": "+
a+" ("+this.type.wireType+" expected)");if(a==b.WIRE_TYPES.LDELIM&&this.repeated&&this.options.packed&&0<=b.PACKABLE_WIRE_TYPES.indexOf(this.type.wireType)&&!d){a=c.readVarint32();a=c.offset+a;for(d=[];c.offset<a;)d.push(this.decode(this.type.wireType,c,!0));return d}if(this.map){var l=e.defaultFieldValue(this.keyType);d=e.defaultFieldValue(this.type);a=c.readVarint32();if(c.remaining()<a)throw Error("Illegal number of bytes for "+this.toString(!0)+": "+a+" required but got only "+c.remaining());
var f=c.clone();f.limit=f.offset+a;for(c.offset+=a;0<f.remaining();)if(c=f.readVarint32(),a=c&7,c>>>=3,1===c)l=this.keyElement.decode(f,a,c);else if(2===c)d=this.element.decode(f,a,c);else throw Error("Unexpected tag in map field key/value submessage");return[l,d]}return this.element.decode(c,a,this.id)};q.Message.Field=c;f=function(a,b,d,e,l,f,k){c.call(this,a,b,d,null,e,l,f,k)};f.prototype=Object.create(c.prototype);q.Message.ExtensionField=f;q.Message.OneOf=function(a,b,c){n.call(this,a,b,c);this.fields=
[]};var t=function(b,c,d,e,l){a.call(this,b,c,d,e,l);this.className="Enum";this.object=null};t.getName=function(a,b){for(var c=Object.keys(a),d=0,e;d<c.length;++d)if(a[e=c[d]]===b)return e;return null};(t.prototype=Object.create(a.prototype)).build=function(a){if(this.object&&!a)return this.object;a=new b.Builder.Enum;for(var c=this.getChildren(t.Value),d=0,e=c.length;d<e;++d)a[c[d].name]=c[d].id;Object.defineProperty&&Object.defineProperty(a,"$options",{value:this.buildOpt(),enumerable:!1});return this.object=
a};q.Enum=t;f=function(a,b,c,d){n.call(this,a,b,c);this.className="Enum.Value";this.id=d};f.prototype=Object.create(n.prototype);q.Enum.Value=f;var l=function(a,b,c,d){n.call(this,a,b,c);this.field=d};l.prototype=Object.create(n.prototype);q.Extension=l;var w=function(b,c,d,e){a.call(this,b,c,d,e);this.className="Service";this.clazz=null};(w.prototype=Object.create(a.prototype)).build=function(a){return this.clazz&&!a?this.clazz:this.clazz=function(a,b){for(var c=function(b){a.Builder.Service.call(this);
this.rpcImpl=b||function(a,b,c){setTimeout(c.bind(this,Error("Not implemented, see: https://github.com/dcodeIO/ProtoBuf.js/wiki/Services")),0)}},d=c.prototype=Object.create(a.Builder.Service.prototype),e=b.getChildren(a.Reflect.Service.RPCMethod),l=0;l<e.length;l++)(function(a){d[a.name]=function(c,d){try{try{c=a.resolvedRequestType.clazz.decode(h.wrap(c))}catch(e){if(!(e instanceof TypeError))throw e;}if(null===c||"object"!==typeof c)throw Error("Illegal arguments");c instanceof a.resolvedRequestType.clazz||
(c=new a.resolvedRequestType.clazz(c));this.rpcImpl(a.fqn(),c,function(c,e){if(c)d(c);else{null===e&&(e="");try{e=a.resolvedResponseType.clazz.decode(e)}catch(l){}e&&e instanceof a.resolvedResponseType.clazz?d(null,e):d(Error("Illegal response type received in service method "+b.name+"#"+a.name))}})}catch(l){setTimeout(d.bind(this,l),0)}};c[a.name]=function(b,d,e){(new c(b))[a.name](d,e)};Object.defineProperty&&(Object.defineProperty(c[a.name],"$options",{value:a.buildOpt()}),Object.defineProperty(d[a.name],
"$options",{value:c[a.name].$options}))})(e[l]);Object.defineProperty&&(Object.defineProperty(c,"$options",{value:b.buildOpt()}),Object.defineProperty(d,"$options",{value:c.$options}),Object.defineProperty(c,"$type",{value:b}),Object.defineProperty(d,"$type",{value:b}));return c}(b,this)};q.Service=w;var v=function(a,b,c,d){n.call(this,a,b,c);this.className="Service.Method";this.options=d||{}};(v.prototype=Object.create(n.prototype)).buildOpt=k.buildOpt;q.Service.Method=v;k=function(a,b,c,d,e,l,f,
k){v.call(this,a,b,c,k);this.className="Service.RPCMethod";this.requestName=d;this.responseName=e;this.requestStream=l;this.responseStream=f;this.resolvedResponseType=this.resolvedRequestType=null};k.prototype=Object.create(v.prototype);q.Service.RPCMethod=k;return q}(d);d.Builder=function(b,d,h){function q(a){a.messages&&a.messages.forEach(function(b){b.syntax=a.syntax;q(b)});a.enums&&a.enums.forEach(function(b){b.syntax=a.syntax})}var n=function(a){this.ptr=this.ns=new h.Namespace(this,null,"");
this.resolved=!1;this.result=null;this.files={};this.importRoot=null;this.options=a||{}},k=n.prototype;n.isMessage=function(a){return"string"!==typeof a.name||"undefined"!==typeof a.values||"undefined"!==typeof a.rpc?!1:!0};n.isMessageField=function(a){return"string"!==typeof a.rule||"string"!==typeof a.name||"string"!==typeof a.type||"undefined"===typeof a.id?!1:!0};n.isEnum=function(a){return"string"===typeof a.name&&"undefined"!==typeof a.values&&Array.isArray(a.values)&&0!==a.values.length?!0:
!1};n.isService=function(a){return"string"===typeof a.name&&"object"===typeof a.rpc&&a.rpc?!0:!1};n.isExtend=function(a){return"string"!==typeof a.ref?!1:!0};k.reset=function(){this.ptr=this.ns;return this};k.define=function(a){if("string"!==typeof a||!d.TYPEREF.test(a))throw Error("illegal namespace: "+a);a.split(".").forEach(function(a){var b=this.ptr.getChild(a);null===b&&this.ptr.addChild(b=new h.Namespace(this,this.ptr,a));this.ptr=b},this);return this};k.create=function(a){if(!a)return this;
if(Array.isArray(a)){if(0===a.length)return this;a=a.slice()}else a=[a];for(var d=[a];0<d.length;){a=d.pop();if(!Array.isArray(a))throw Error("not a valid namespace: "+JSON.stringify(a));for(;0<a.length;){var f=a.shift();if(n.isMessage(f)){var k=new h.Message(this,this.ptr,f.name,f.options,f.isGroup,f.syntax),c={};f.oneofs&&Object.keys(f.oneofs).forEach(function(a){k.addChild(c[a]=new h.Message.OneOf(this,k,a))},this);f.fields&&f.fields.forEach(function(a){if(null!==k.getChild(a.id|0))throw Error("duplicate or invalid field id in "+
k.name+": "+a.id);if(a.options&&"object"!==typeof a.options)throw Error("illegal field options in "+k.name+"#"+a.name);var b=null;if("string"===typeof a.oneof&&!(b=c[a.oneof]))throw Error("illegal oneof in "+k.name+"#"+a.name+": "+a.oneof);a=new h.Message.Field(this,k,a.rule,a.keytype,a.type,a.name,a.id,a.options,b,f.syntax);b&&b.fields.push(a);k.addChild(a)},this);var r=[];f.enums&&f.enums.forEach(function(a){r.push(a)});f.messages&&f.messages.forEach(function(a){r.push(a)});f.services&&f.services.forEach(function(a){r.push(a)});
f.extensions&&(k.extensions="number"===typeof f.extensions[0]?[f.extensions]:f.extensions);this.ptr.addChild(k);if(0<r.length){d.push(a);a=r;r=null;this.ptr=k;k=null;continue}r=null}else if(n.isEnum(f))k=new h.Enum(this,this.ptr,f.name,f.options,f.syntax),f.values.forEach(function(a){k.addChild(new h.Enum.Value(this,k,a.name,a.id))},this),this.ptr.addChild(k);else if(n.isService(f))k=new h.Service(this,this.ptr,f.name,f.options),Object.keys(f.rpc).forEach(function(a){var b=f.rpc[a];k.addChild(new h.Service.RPCMethod(this,
k,a,b.request,b.response,!!b.request_stream,!!b.response_stream,b.options))},this),this.ptr.addChild(k);else if(n.isExtend(f))if(k=this.ptr.resolve(f.ref,!0))f.fields.forEach(function(a){if(null!==k.getChild(a.id|0))throw Error("duplicate extended field id in "+k.name+": "+a.id);if(k.extensions){var c=!1;k.extensions.forEach(function(b){a.id>=b[0]&&a.id<=b[1]&&(c=!0)});if(!c)throw Error("illegal extended field id in "+k.name+": "+a.id+" (not within valid ranges)");}var d=a.name;this.options.convertFieldsToCamelCase&&
(d=b.Util.toCamelCase(d));var d=new h.Message.ExtensionField(this,k,a.rule,a.type,this.ptr.fqn()+"."+d,a.id,a.options),e=new h.Extension(this,this.ptr,a.name,d);d.extension=e;this.ptr.addChild(e);k.addChild(d)},this);else{if(!/\.?google\.protobuf\./.test(f.ref))throw Error("extended message "+f.ref+" is not defined");}else throw Error("not a valid definition: "+JSON.stringify(f));k=f=null}a=null;this.ptr=this.ptr.parent}this.resolved=!1;this.result=null;return this};k["import"]=function(a,d){var k=
"/";if("string"===typeof d){b.Util.IS_NODE&&(d=require("path").resolve(d));if(!0===this.files[d])return this.reset();this.files[d]=!0}else if("object"===typeof d){var h=d.root;b.Util.IS_NODE&&(h=require("path").resolve(h));if(0<=h.indexOf("\\")||0<=d.file.indexOf("\\"))k="\\";h=h+k+d.file;if(!0===this.files[h])return this.reset();this.files[h]=!0}if(a.imports&&0<a.imports.length){var c=!1;if("object"===typeof d){if(this.importRoot=d.root,c=!0,h=this.importRoot,d=d.file,0<=h.indexOf("\\")||0<=d.indexOf("\\"))k=
"\\"}else"string"===typeof d?this.importRoot?h=this.importRoot:0<=d.indexOf("/")?(h=d.replace(/\/[^\/]*$/,""),""===h&&(h="/")):0<=d.indexOf("\\")?(h=d.replace(/\\[^\\]*$/,""),k="\\"):h=".":h=null;for(var r=0;r<a.imports.length;r++)if("string"===typeof a.imports[r]){if(!h)throw Error("cannot determine import root");var l=a.imports[r];if("google/protobuf/descriptor.proto"!==l&&(l=h+k+l,!0!==this.files[l])){/\.proto$/i.test(l)&&!b.DotProto&&(l=l.replace(/\.proto$/,".json"));var n=b.Util.fetch(l);if(null===
n)throw Error("failed to import '"+l+"' in '"+d+"': file not found");if(/\.json$/i.test(l))this["import"](JSON.parse(n+""),l);else this["import"](b.DotProto.Parser.parse(n),l)}}else if(d)if(/\.(\w+)$/.test(d))this["import"](a.imports[r],d.replace(/^(.+)\.(\w+)$/,function(a,b,c){return b+"_import"+r+"."+c}));else this["import"](a.imports[r],d+"_import"+r);else this["import"](a.imports[r]);c&&(this.importRoot=null)}a["package"]&&this.define(a["package"]);a.syntax&&q(a);var p=this.ptr;a.options&&Object.keys(a.options).forEach(function(b){p.options[b]=
a.options[b]});a.messages&&(this.create(a.messages),this.ptr=p);a.enums&&(this.create(a.enums),this.ptr=p);a.services&&(this.create(a.services),this.ptr=p);a["extends"]&&this.create(a["extends"]);return this.reset()};k.resolveAll=function(){var a;if(null==this.ptr||"object"===typeof this.ptr.type)return this;if(this.ptr instanceof h.Namespace)this.ptr.children.forEach(function(a){this.ptr=a;this.resolveAll()},this);else if(this.ptr instanceof h.Message.Field){if(d.TYPE.test(this.ptr.type))this.ptr.type=
b.TYPES[this.ptr.type];else{if(!d.TYPEREF.test(this.ptr.type))throw Error("illegal type reference in "+this.ptr.toString(!0)+": "+this.ptr.type);a=(this.ptr instanceof h.Message.ExtensionField?this.ptr.extension.parent:this.ptr.parent).resolve(this.ptr.type,!0);if(!a)throw Error("unresolvable type reference in "+this.ptr.toString(!0)+": "+this.ptr.type);this.ptr.resolvedType=a;if(a instanceof h.Enum){if(this.ptr.type=b.TYPES["enum"],"proto3"===this.ptr.syntax&&"proto3"!==a.syntax)throw Error("proto3 message cannot reference proto2 enum");
}else if(a instanceof h.Message)this.ptr.type=a.isGroup?b.TYPES.group:b.TYPES.message;else throw Error("illegal type reference in "+this.ptr.toString(!0)+": "+this.ptr.type);}if(this.ptr.map){if(!d.TYPE.test(this.ptr.keyType))throw Error("illegal key type for map field in "+this.ptr.toString(!0)+": "+this.ptr.keyType);this.ptr.keyType=b.TYPES[this.ptr.keyType]}}else if(this.ptr instanceof b.Reflect.Service.Method)if(this.ptr instanceof b.Reflect.Service.RPCMethod){a=this.ptr.parent.resolve(this.ptr.requestName,
!0);if(!(a&&a instanceof b.Reflect.Message))throw Error("Illegal type reference in "+this.ptr.toString(!0)+": "+this.ptr.requestName);this.ptr.resolvedRequestType=a;a=this.ptr.parent.resolve(this.ptr.responseName,!0);if(!(a&&a instanceof b.Reflect.Message))throw Error("Illegal type reference in "+this.ptr.toString(!0)+": "+this.ptr.responseName);this.ptr.resolvedResponseType=a}else throw Error("illegal service type in "+this.ptr.toString(!0));else if(!(this.ptr instanceof b.Reflect.Message.OneOf||
this.ptr instanceof b.Reflect.Extension||this.ptr instanceof b.Reflect.Enum.Value))throw Error("illegal object in namespace: "+typeof this.ptr+": "+this.ptr);return this.reset()};k.build=function(a){this.reset();this.resolved||(this.resolveAll(),this.resolved=!0,this.result=null);null===this.result&&(this.result=this.ns.build());if(!a)return this.result;a="string"===typeof a?a.split("."):a;for(var b=this.result,d=0;d<a.length;d++)if(b[a[d]])b=b[a[d]];else{b=null;break}return b};k.lookup=function(a,
b){return a?this.ns.resolve(a,b):this.ns};k.toString=function(){return"Builder"};n.Message=function(){};n.Enum=function(){};n.Service=function(){};return n}(d,d.Lang,d.Reflect);d.Map=function(b,d){function h(b){var a=0;return{next:function(){return a<b.length?{done:!1,value:b[a++]}:{done:!0}}}}var q=function(b,a){if(!b.map)throw Error("field is not a map");this.field=b;this.keyElem=new d.Element(b.keyType,null,!0,b.syntax);this.valueElem=new d.Element(b.type,b.resolvedType,!1,b.syntax);this.map={};
Object.defineProperty(this,"size",{get:function(){return Object.keys(this.map).length}});if(a)for(var e=Object.keys(a),f=0;f<e.length;f++){var h=this.keyElem.valueFromString(e[f]),c=this.valueElem.verifyValue(a[e[f]]);this.map[this.keyElem.valueToString(h)]={key:h,value:c}}},n=q.prototype;n.clear=function(){this.map={}};n["delete"]=function(b){b=this.keyElem.valueToString(this.keyElem.verifyValue(b));var a=b in this.map;delete this.map[b];return a};n.entries=function(){for(var b=[],a=Object.keys(this.map),
d=0,f;d<a.length;d++)b.push([(f=this.map[a[d]]).key,f.value]);return h(b)};n.keys=function(){for(var b=[],a=Object.keys(this.map),d=0;d<a.length;d++)b.push(this.map[a[d]].key);return h(b)};n.values=function(){for(var b=[],a=Object.keys(this.map),d=0;d<a.length;d++)b.push(this.map[a[d]].value);return h(b)};n.forEach=function(b,a){for(var d=Object.keys(this.map),f=0,h;f<d.length;f++)b.call(a,(h=this.map[d[f]]).value,h.key,this)};n.set=function(b,a){var d=this.keyElem.verifyValue(b),f=this.valueElem.verifyValue(a);
this.map[this.keyElem.valueToString(d)]={key:d,value:f};return this};n.get=function(b){b=this.keyElem.valueToString(this.keyElem.verifyValue(b));return b in this.map?this.map[b].value:void 0};n.has=function(b){return this.keyElem.valueToString(this.keyElem.verifyValue(b))in this.map};return q}(d,d.Reflect);d.loadProto=function(b,h,p){if("string"===typeof h||h&&"string"===typeof h.file&&"string"===typeof h.root)p=h,h=void 0;return d.loadJson(d.DotProto.Parser.parse(b),h,p)};d.protoFromString=d.loadProto;
d.loadProtoFile=function(b,h,p){h&&"object"===typeof h?(p=h,h=null):h&&"function"===typeof h||(h=null);if(h)return d.Util.fetch("string"===typeof b?b:b.root+"/"+b.file,function(n){if(null===n)h(Error("Failed to fetch file"));else try{h(null,d.loadProto(n,p,b))}catch(k){h(k)}});var q=d.Util.fetch("object"===typeof b?b.root+"/"+b.file:b);return null===q?null:d.loadProto(q,p,b)};d.protoFromFile=d.loadProtoFile;d.newBuilder=function(b){b=b||{};"undefined"===typeof b.convertFieldsToCamelCase&&(b.convertFieldsToCamelCase=
d.convertFieldsToCamelCase);"undefined"===typeof b.populateAccessors&&(b.populateAccessors=d.populateAccessors);return new d.Builder(b)};d.loadJson=function(b,h,p){if("string"===typeof h||h&&"string"===typeof h.file&&"string"===typeof h.root)p=h,h=null;h&&"object"===typeof h||(h=d.newBuilder());"string"===typeof b&&(b=JSON.parse(b));h["import"](b,p);h.resolveAll();return h};d.loadJsonFile=function(b,h,p){h&&"object"===typeof h?(p=h,h=null):h&&"function"===typeof h||(h=null);if(h)return d.Util.fetch("string"===
typeof b?b:b.root+"/"+b.file,function(n){if(null===n)h(Error("Failed to fetch file"));else try{h(null,d.loadJson(JSON.parse(n),p,b))}catch(k){h(k)}});var q=d.Util.fetch("object"===typeof b?b.root+"/"+b.file:b);return null===q?null:d.loadJson(JSON.parse(q),p,b)};return d});
