/* (c) 2011 Netflix, Inc. Do not copy or use without prior written permission from Netflix, Inc. */
/*global nrdp */

// to use:
// ./netflix --inject-js replace-url -J "replace-url=^https:// http://"
// or
// ./netflix --inject-js replace-url -J "replace-url=http://art.*.nflximg.net/.*.jpg http://art-2.nflximg.net/8e3b9/957b9315e77304d2dab6c0a6a0b8fd6bc7f8e3b9.jpg"

if (!nrdp.gibbon._resolveUrlOld) {
    nrdp.gibbon._resolveUrlOld = nrdp.gibbon._resolveUrl;
    nrdp.gibbon._resolveUrl = function(url) {
        if (!nrdp.gibbon._replaceUrls) {
            nrdp.gibbon._replaceUrls = [];
            var replacements = nrdp.js_options["replace-url"];
            if (replacements && replacements.length) {
                replacements.split(',').forEach(function(r) {
                    var split = r.split(' ');
                    nrdp.gibbon._replaceUrls.push({ rx: new RegExp(split[0], 'g'), with: split[1] });
                });
            }
        }
        url = nrdp.gibbon._resolveUrlOld(url);
        if (nrdp.gibbon._replaceUrls.length && url) {
            var replaced = url;
            nrdp.gibbon._replaceUrls.forEach(function(r) {
                replaced = replaced.replace(r.rx, r.with);
            });
            if (replaced != url) {
                nrdp.l("Replaced url: " + url + " with " + replaced);
                return replaced;
            }
        }
        return url;
    };
}
