/* (c) 2011 Netflix, Inc. Do not copy or use without prior written permission from Netflix, Inc. */
var _crt = { enabled: false };
function _setCRT(c) {
    _crt.enabled = c;
    if(c) {
        if(nrdp.js_options.images)
            nrdp.gibbon._runConsole("/set debug testSurfaceLoadCRT=true");
        if(nrdp.gibbon.scene.root) {
            _crt.effect = nrdp.gibbon.scene.root.addEffect("shader" );
            _crt.effect.params = {
                draw: "TRIANGLE_STRIP",
                vertex: {
                    buffer: {
                        value: [ -1.0, -1.0, 1.0, -1.0, 1.0, 1.0, -1.0, 1.0 ],
                        attributes: [ 
                            { name:"a_vertex", type: "float", count: 2 },
                        ]
                    },
                    indices: {
                        type: "INT",
                        value: [0, 1, 3, 2]
                    },
                    uniforms: [
                        { name: "u_modelViewMatrix", type: "modelview" },
                        { name: "u_projectionMatrix", type: "projection" }
                    ],
                    shader: "#ifdef GL_ES\n" +
                            "precision mediump float;\n" +
                            "#endif\n" +
                            "uniform mat4 u_modelViewMatrix; " +
                            "uniform mat4 u_projectionMatrix; " +
                            "attribute vec2 a_vertex; " +
                            "varying vec2 v_texCoord; " +
                            "void main(void) { " +
                            "    vec4 p = vec4(a_vertex, 0.0, 1.0); " +
                            "    vec2 texCoord = (a_vertex * 0.5 + 0.5); " +
                            "    texCoord.y = 1.0 - texCoord.y; " +
                            "    v_texCoord = texCoord; " +
                            "    gl_Position = u_projectionMatrix * u_modelViewMatrix * p; " +
                            "}"
                },
                fragment: {
                    uniforms: [
                        { name: "u_time", type: "random" },
                        { name: "s_texture", type: "widget" }
                    ],
                    shader: "#ifdef GL_ES\n" +
                        "precision highp float;\n" +
                        "#endif\n" +
                        "uniform sampler2D s_texture;\n" +
                        "uniform float u_time;\n" +
                        "varying vec2 v_texCoord;\n" +
                        "void main(void)\n" +
                        "{\n" +
                        "    float f  = sin(v_texCoord.y * 320.0 * 3.14);\n" +
                        "    // scale to per pixel\n" +
                        "    float o  = f * (0.35 / 320.0);\n" +
                        "    // scale for subtle effect\n" +
                        "    float s  = f * .03 + 0.97;\n" +
                        "    // scan line fading\n" +
                        "    float l  = sin(u_time * 32.0) * .03 + 0.97;\n" +
                        "    // sample in 3 colour offset\n" +
                        "    float r = texture2D(s_texture, vec2(v_texCoord.x + o, v_texCoord.y + o)).r;\n" +
                        "    float g = texture2D(s_texture, vec2(v_texCoord.x - o, v_texCoord.y + o)).g;\n" +
                        "    float b = texture2D(s_texture, vec2(v_texCoord.x    , v_texCoord.y - o)).b;\n" +
                        "    // combine as\n" +
                        "    gl_FragColor = vec4(r * 0.7 * l, g * l, b * 0.9 * l, 1) * s;\n" +
                        "}\n"
                }
            };
            if(!_crt.overlay) {
                _crt.overlay = nrdp.gibbon.makeWidget({name: "crt", width: 1280, height: 720, smoothScale: true });
                _crt.overlay.addEffect("blur", {radius:3});
                _crt.overlay.refresh = nrdp.gibbon.makeWidget({name: "crt_refresh", parent: _crt.overlay, width: 1280, height: 2, opacity: 0.20, color: "gray" });
                _crt.overlay.snow = nrdp.gibbon.makeWidget({name: "crt_snow", parent: _crt.overlay, width: 1280, height: 720, color: { a: 1 } });
                _crt.overlay.snow.effect = _crt.overlay.snow.addEffect("shader");
                _crt.overlay.snow.effect.params = {
                    draw: "TRIANGLE_STRIP",
                    vertex: {
                        buffer: {
                            value: [ -1.0, -1.0, 1.0, -1.0, 1.0, 1.0, -1.0, 1.0 ],
                            attributes: [ 
                                { name:"a_vertex", type: "float", count: 2 },
                            ]
                        },
                        indices: {
                            type: "INT",
                            value: [0, 1, 3, 2]
                        },
                        uniforms: [
                            { name: "u_modelViewMatrix", type: "modelview" },
                            { name: "u_projectionMatrix", type: "projection" }
                        ],
                        shader: "#ifdef GL_ES\n" +
                            "precision mediump float;\n" +
                            "#endif\n" +
                            "uniform mat4 u_modelViewMatrix; " +
                            "uniform mat4 u_projectionMatrix; " +
                            "attribute vec2 a_vertex; " +
                            "varying vec2 v_texCoord; " +
                            "void main(void) { " +
                            "    vec4 p = vec4(a_vertex, 0.0, 1.0); " +
                            "    vec2 texCoord = (a_vertex * 0.5 + 0.5); " +
                            "    texCoord.y = 1.0 - texCoord.y; " +
                            "    v_texCoord = texCoord; " +
                            "    gl_Position = u_projectionMatrix * u_modelViewMatrix * p; " +
                            "}"
                    },
                    fragment: {
                        uniforms: [
                            { name: "randomInput", type: "random" }
                        ],
                        shader: "#ifdef GL_ES\n" +
                            "precision highp float;\n" +
                            "#endif\n" +
                            "varying vec2 v_texCoord;\n" +
                            "uniform float randomInput;\n" +
                            "float rand(vec2 co)\n" +
                            "{\n" +
      	                    "    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);\n" +
                            "}\n" +
                            "void main()\n" +
                            "{\n" +
	                    "    float grayComponent = rand(vec2(v_texCoord.x + randomInput, v_texCoord.y + randomInput));\n" +
                            "    gl_FragColor = vec4(grayComponent, grayComponent, grayComponent, 1.0);\n" +
                            "}\n"
                    },
                    cache: false
                };
                _crt.overlay.gloss = nrdp.gibbon.makeWidget({name: "crt_glare", parent: _crt.overlay, width: 1280, opacity: 0.45, height: 720 });
                _crt.overlay.gloss.image.halign = _crt.overlay.gloss.image.valign = "stretch";
                _crt.overlay.gloss.image.url = "http://localcontrol.netflix.com/img/gloss.png";

                nrdp.gibbon.scene.overlay = _crt.overlay;
                function startRefreshTimer() {
                    var t = 5000;
                    _crt.overlay.refresh.startAnimation("y", 0, 720, t, "linear");
                    _crt.overlay.refresh.timer = nrdp.gibbon.setTimeout(function() {
                        startRefreshTimer();
                    }, t);
                }
                startRefreshTimer();
                function startSnowTimer() {
                    var t = _crt.overlay.snow.visible ? 1500 : 15000;
                    _crt.overlay.snow.timer = nrdp.gibbon.setTimeout(function() {
                        _crt.overlay.snow.visible = !_crt.overlay.snow.visible;
                        startSnowTimer();
                    }, t);
                }
                startSnowTimer();
            }
        }
    } else {
        if(nrdp.js_options.images)
            nrdp.gibbon._runConsole("/set debug testSurfaceLoadCRT=false");
        if(_crt.refresh.timer) {
            nrdp.gibbon.clearTimeout(_crt.refresh.timer);
            _crt.refresh.timer = 0;
        }
        if(_crt.snow.timer) {
            nrdp.gibbon.clearTimeout(_crt.snow.timer);
            _crt.snow.timer = 0;
        }
        if(_crt.effect) {
            nrdp.gibbon.scene.root.removeEffect(_crt.effect);
            _crt.effect = undefined;
        }
        if(_crt.overlay) {
            nrdp.gibbon.scene.removeOverlay(_crt.overlay);
            _crt.overlay = undefined;
        }
    }
}
nrdp.gibbon._hookProperty(nrdp.gibbon.scene, 'root', function(widget, old) {
    old.call(nrdp.gibbon.scene, widget);
    if(_crt.enabled)
        _setCRT(true);
});
nrdp.addEventListener("init", function() { _setCRT(true); });
if(nrdp.isReady)
    _setCRT(true);
