/* (c) 2011 Netflix, Inc. Do not copy or use without prior written permission from Netflix, Inc. */
nrdp.gibbon._hookProperty(nrdp.gibbon.Image.prototype, 'url', function(_url, old) {
    var image = this;

    var set_image_url, image_url;
    if(_url instanceof Object) {
        image_url = _url.url;
        set_image_url = _url;
    } else {
        image_url = _url;
        set_image_url = { url: _url };
    }
    if(image._attempt || !image_url || !image_url.length || !image_url.match("http://art.*.nflximg.net/.*.jpg")) {
        old.call(image, _url);
        return;
    }


    function old_call(translation) {
        set_image_url.url = translation.url;
        set_image_url.format = translation.format;
        old.call(image, set_image_url);
    }

    if(!nrdp.gibbon.Image._compressedTranslation)
        nrdp.gibbon.Image._compressedTranslation = {};
    if(!nrdp.gibbon.Image._compressedFormats) {
        nrdp.gibbon.Image._compressedFormats = [];
        for(var l in nrdp.device.SDKVersion.uiLibraries) {
            var lib = nrdp.device.SDKVersion.uiLibraries[l];
            if(lib.name == "opengl") {
                // if(lib.options.extensions.indexOf("GL_EXT_texture_compression_s3tc") != -1)
                //     nrdp.gibbon.Image._compressedFormats.push({ type: "s3tc", alpha: true });
                if(lib.options.extensions.indexOf("GL_EXT_texture_compression_dxt1") != -1)
                    nrdp.gibbon.Image._compressedFormats.push({ type: "dxt1", alpha: true });
                // if(lib.options.extensions.indexOf("GL_ARB_texture_compression_rgtc") != -1)
                //     nrdp.gibbon.Image._compressedFormats.push({ type: "rgtc", alpha: true });
                if(lib.options.extensions.indexOf("GL_OES_compressed_ETC1_RGB8_texture") != -1)
                    nrdp.gibbon.Image._compressedFormats.push({ type: "etc1", alpha: false });
            }
        }
    }
    var translation = nrdp.gibbon.Image._compressedTranslation[image_url];
    if(translation) {
        old_call(translation);
    } else {
        var attempt = 0;
        var attemptimage = image._widget.addBackgroundImage();
        attemptimage._attempt = true;
        function tryFormat(a) {
            attempt = a;
            if(attempt >= nrdp.gibbon.Image._compressedFormats.length) {
                //nrdp.log.error("Oh well: " + image_url);
                var failed = { url: image_url };
                nrdp.gibbon.Image._compressedTranslation[image_url] = failed;
                old_call(failed);
            } else {
                set_image_url.url = "http://lgux-smagnuson.corp.netflix.com/smagnuson/compressed" + "." + nrdp.gibbon.Image._compressedFormats[attempt].type + "?" + image_url;
                set_image_url.format = nrdp.gibbon.Image._compressedFormats[attempt].format;
                //nrdp.log.error("Trying:" + attempt + ": " + set_image_url.url);
                attemptimage.url = set_image_url;
            }
        }
        attemptimage.addEventListener("imageLoaded", function(data) {
            if(data.data.success) {
                var success = { url: attemptimage.url.url, format: attemptimage.url.format };
                //nrdp.log.error("Success: " + JSON.stringify(success));
                nrdp.gibbon.Image._compressedTranslation[image_url] = success;
                old_call(success);
            } else {
                //nrdp.log.error("Tried: " + JSON.stringify(data));
                tryFormat(attempt+1);
            }
        });
        tryFormat(0);
    }
});

