var RightDashBoard = function() {

    var debug_log = false;

    var RDBDataObj;
    var ItemData;
    var DataId;
    
    var HoverIndexName="hoverIndex";
    var HoverIndexImg="items_icon_gray";
    var Itemboard=".items_board";
    var scrollBar = $(Itemboard);

    
    var printVariable = function() {
        if (debug_log == true) {
            console.log("================================================================");
            console.log("ShowItemsNum="+ItemData.ShowItemsNum);
            console.log("TotalItems="+ItemData.TotalItems);
            console.log("ShowIndexItem="+ItemData.ShowIndexItem);
            console.log("IndexItem="+ItemData.IndexItem);
            console.log("OffsetItem="+ItemData.OffsetItem);
            console.log("================================================================");
        }
    }
    
    var circle_offset_board = function() {
        /* Circle offset */
        if ((ItemData.TotalItems - 3) < ItemData.IndexItem) {
            $(".footer_board").css('top','667px').css("height",'53px');
            $(Itemboard).css("height",'561px');
        } else {
            $(".footer_board").css('top','661px').css("height",'59px');
            $(Itemboard).css("height",'555px');
        }
    }
    
    var ListMenuInit = function(dataObj) {
        if (debug_log == true) {
            console.log("ListMenuInit");
        }
        RDBDataObj = dataObj;
        RDBDataObj.Init();
        
        ItemData = RDBDataObj.GetItemData();
        DataId = RDBDataObj.GetDataID();
        
        //show page item
        document.querySelector(Itemboard).innerHTML=RDBDataObj.GetHTMLList();
        

        if (ItemData.IndexItem < ItemData.ShowItemsNum) {
            ItemData.OffsetItem = 0; 
            if (ItemData.ShowItemsNum < ItemData.TotalItems) {
                ShowArrowDown(true);
            }
        } else {
            if (ItemData.IndexItem == ItemData.TotalItems) {
                if ((ItemData.TotalItems - ItemData.ShowItemsNum) > 0) {
                    ItemData.OffsetItem = ItemData.TotalItems - ItemData.ShowItemsNum;
                    ShowArrowUp(true);
                } else {
                    ItemData.OffsetItem = 0;
                }
                
            } else {
                ItemData.OffsetItem = ItemData.IndexItem - ItemData.ShowItemsNum + 1;
                
                if (ItemData.IndexItem < (ItemData.TotalItems -1)) {
                    ShowArrowDown(true);
                }
                
                ShowArrowUp(true);
            }
        }

        if (ItemData.ShowItemsNum > ItemData.IndexItem) {
            ItemData.ShowIndexItem = ItemData.IndexItem;
        } else {
            ItemData.ShowIndexItem = ItemData.ShowItemsNum - 1;
        }
        setScrollBarPos();
        circle_offset_board();
        setHoverItem(ItemData.IndexItem);

        RDBDataObj.ShowColorBar(ItemData.IndexItem);
    }

    var setScrollBarPos = function() {
        if (debug_log == true) {
            console.log("setScrollBarPos");
        }
        var scrollBarHeight = scrollBar.outerHeight(); /* 555 */
        var objItem = scrollBar.find(".item");
        var objItemHeight = objItem.outerHeight();     /* 64 */
        var objItemNum = objItem.length;               /* Input Source Item:11*/
        
        $(Itemboard).scrollTop(ItemData.OffsetItem*objItemHeight);
        
    }
    
    var ListMainMenuKeyHandler = function(kc) {
        var key = kc.keyCode || kc.which;

        if (debug_log == true) {
            console.log("ListMainMenuKeyHandler key="+key);
        }

        var ShowIndexItem_tmp = ItemData.ShowIndexItem;
        var OffsetItem_tmp = ItemData.OffsetItem;
        switch (key) {
            /*VK_RIGHT IS FOR TESTING ONLY!!! REMOVE IT LATER!!!*/
            /*case KeyEvent.DOM_VK_RIGHT:*/
            case KeyEvent.DOM_VK_GREEN:
                if (RDBDataObj.GetGreenKeyStatus() == 1) {
                    RDBDataObj.ExecuteGreen(ItemData.IndexItem, ItemData.ShowIndexItem, ItemData.OffsetItem);
                    /*setScrollBarPos();
                    handleHoverItem();*/
				}
            break;
            case KeyEvent.DOM_VK_RETURN:
            case KeyEvent.DOM_VK_ENTER:
                if (RDBDataObj.GetRedScanStatus() == 1) {
                    /*RDBDataObj.ExecuteRed(ItemData.IndexItem);*/
                    document.location.reload();
                } else {
                    RDBDataObj.ExecuteEnter(ItemData.IndexItem);
                }
            break;
			
            case KeyEvent.DOM_VK_DOWN:
				if (RDBDataObj.GetRedScanStatus() != 1) {
                    if (ItemData.ShowIndexItem < (ItemData.ShowItemsNum - 1) && ItemData.ShowItemsNum < ItemData.TotalItems) {
                        ShowIndexItem_tmp++;
			if ((ItemData.OffsetItem + ItemData.ShowItemsNum) < ItemData.TotalItems) {
                        ShowArrowDown(true);
			}
                    } else if((ItemData.ShowIndexItem + ItemData.OffsetItem) > (ItemData.TotalItems - 3)) {
                        if (ShowIndexItem_tmp < ItemData.ShowItemsNum) {
                            ShowIndexItem_tmp++;
                        }
                        ShowArrowDown(false);
                        circle_offset_board();
                    }
                
                    if (ItemData.ShowIndexItem == (ItemData.ShowItemsNum - 1) && (ItemData.ShowIndexItem + ItemData.OffsetItem) < (ItemData.TotalItems -1)) {
                        OffsetItem_tmp++;
                    }
                    ItemData.ShowIndexItem = ShowIndexItem_tmp;
                    ItemData.OffsetItem = OffsetItem_tmp;
                    if (ItemData.TotalItems > ItemData.IndexItem) {
                        ItemData.IndexItem++;
                    }
                
                    setScrollBarPos();
                    handleHoverItem();
				} else {
					RDBDataObj.SetScanIcon(ItemData.IndexItem, scrollBar);
					setScrollBarPos();
                    handleHoverItem();
				}
            break;
			
            case KeyEvent.DOM_VK_UP:
				if (RDBDataObj.GetRedScanStatus() != 1) {
				    if (ItemData.IndexItem != 1) {
                        if (ItemData.OffsetItem > 0 && ItemData.ShowIndexItem == 2) {
                            OffsetItem_tmp--;
                            ShowArrowDown(true);
                            circle_offset_board();
                        } else if(ItemData.ShowIndexItem > 1) {
                            ShowIndexItem_tmp--;
                        }
                        ItemData.ShowIndexItem = ShowIndexItem_tmp;
                        ItemData.OffsetItem = OffsetItem_tmp;
                        if (ItemData.IndexItem > 1) {
                            ItemData.IndexItem--;
                        }
				        setScrollBarPos();
                        handleHoverItem();
				    } else {
					    RDBDataObj.SetScanIcon(ItemData.IndexItem, scrollBar);
					    setScrollBarPos();
                        handleHoverItem();
				    }
				}
            break;
            default:
			    console.log("RightDashBoard key handler unsupported key: "+key);
                return true;
            break;
        }

        if (ItemData.OffsetItem > 0) {
            ShowArrowUp(true);
        } else {
            ShowArrowUp(false);
        }
        return false;
    }
    
    var removeHoverItemToEdit = function(indexItem) {
        if (debug_log == true) {
            console.log("removeHoverItemToEdit indexItem:"+indexItem);
        }
        
         var objItem = scrollBar.find(".items_icon");
         $(objItem).removeClass(HoverIndexImg);
         $(objItem).addClass(HoverIndexImg);
         
         
        objItem = scrollBar.find(".item");
        $(objItem).removeClass(HoverIndexName);
    }
    
    var setHoverItemIcon = function(indexItem) {
        if (debug_log == true) {
            console.log("setHoverItemIcon indexItem:"+indexItem);
        }
        
         var objItem = scrollBar.find(".items_icon");
         $(objItem).removeClass(HoverIndexImg);
         $(objItem).addClass(HoverIndexImg);
         
         var yyy = 1;
         var new_icon_src = "";
         
         // MichaelWang 20161125: Fix the wrong highlight icon which is a side effect caused from Dash
         for (yyy = 1; yyy <= ItemData.TotalItems; yyy++) {
             objItem = scrollBar.find("#"+DataId[yyy]+" div.items_icon_board img");
             if ($(objItem).attr("src").search("_hl_") != -1) {
                 new_icon_src = $(objItem).attr("src").replace("_hl_", "_n_");
                 $(objItem).attr("src", new_icon_src);
             }
         }
         objItem = scrollBar.find("#"+DataId[indexItem]+" div.items_icon_board img");
         $(objItem).removeClass(HoverIndexImg);
         new_icon_src = $(objItem).attr("src").replace("_n_", "_hl_");
         $(objItem).attr("src", new_icon_src);
         
    }
    

    var handleHoverItem = function() {
        if (debug_log == true) {
            console.log("handleHoverItem");
        }
		if (RDBDataObj.GetRedScanStatus() == 1) {
            removeHoverItemToEdit(ItemData.IndexItem);
        } else {
            setHoverItem(ItemData.IndexItem);
        }
    }
    
    var setHoverItem = function(indexItem) {
        if (debug_log == true) {
            console.log("setHoverItem indexItem:"+indexItem);
        }
        var objItem = scrollBar.find(".item");
        $(objItem).removeClass(HoverIndexName);
        $(objItem).removeClass("active"); //MichaelWang 20161220
        objItem = scrollBar.find("#"+DataId[indexItem]);
        $(objItem).addClass(HoverIndexName);
        $(objItem).addClass("active"); //MichaelWang 20161220 Empty class for marquee
        RDBDataObj.ShowColorBar(indexItem);
        setHoverItemIcon(indexItem);
        mtvuiUtil.makeMarquee($(".items_board .items_title")); // MichaelWang 20161220
    }
    

    var ShowArrowUp = function(enable) {
        if (debug_log == true) {
            console.log("ShowArrowUp enable:"+enable);
        }
        if (enable == true) {
            $('.arrow_up_bg').css('display', 'block');
        } else {
            $('.arrow_up_bg').css('display', 'none');
        }
        
    }
    var ShowArrowDown = function(enable) {
        if (debug_log == true) {
            console.log("ShowArrowDown enable:"+enable);
        }
        
        if (enable == true) {
            $('.arrow_down_bg').css('display', 'block');
        } else {
            $('.arrow_down_bg').css('display', 'none');
        }
        
    }

    
    return {
        ListMenuInit:ListMenuInit,
        ListMainMenuKeyHandler:ListMainMenuKeyHandler,
        ShowArrowUp:ShowArrowUp,
        ShowArrowDown:ShowArrowDown
    };
};
