
var g_epg_msg_box_is_showing = false;
var g_epg_msg_box_btn_count = 0;
var g_epg_msg_box_btn_focus_idx = 0;
var g_epg_msg_box_type_id = 0;

function epg_msg_box_is_showing() {
    return g_epg_msg_box_is_showing;
}

var g_epg_msgbox_content;
var g_epg_msgbox_btn1_text;
var g_epg_msgbox_btn2_text;
var g_epg_msgbox_btn3_text;

var EPG_MSG_TYPE_CLEAR_RECORD               = 1; // Yes or No
var EPG_MSG_TYPE_CLEAR_REMINDER             = 2; // Yes or No
var EPG_MSG_TYPE_STOP_RECORD                = 3; // Yes or No
var EPG_MSG_TYPE_DELETE_RECORD              = 4; // Yes or No
var EPG_MSG_TYPE_RECORD_CANCEL_ONE          = 5; // Yes or No, for conflict type is 3 or 4 to display msgbox while pressed "Confirm" button in epg_schedule.js
var EPG_MSG_TYPE_RECORD_OVERLAP_ADJUST_TIME = 6; // Yes or No
var EPG_MSG_TYPE_RECORD_NOT_SCHEDULE        = 7; // Cancel
var EPG_MSG_TYPE_RECORD_SCHEDULED_START     = 8; // Close

var EPG_MSG_TYPE_RECORD_PART_ADJUST_TIME    = 9; // Close, for conflict_type = 1/2
var EPG_MSG_TYPE_RECORD_CANCEL_ONE_EX       = 10;// Close, for conflict_type = 3/4

var EPG_MSG_TYPE_RECORD_PART_ADJUST_TIME_SCHEDULE = 11; // Close, for ongoing conflict

function epg_msg_box_get_button_num_by_msg_id(msg_id)
{
    var btn_number = 0;

    switch (msg_id)
    {
    case EPG_MSG_TYPE_CLEAR_RECORD:
        btn_number = 2;
        // PPG.js
        // "MSG_CLEAR_RECORD": "Are you sure you want to cancel this scheduled recording?",
        g_epg_msgbox_content  = PPG_GetStringByID("MSG_CLEAR_RECORD");;
        g_epg_msgbox_btn1_text= PPG_GetStringByID("BTN_NO");  // 1: No
        g_epg_msgbox_btn2_text= PPG_GetStringByID("BTN_YES"); // 2: Yes
        g_epg_msgbox_btn3_text= "";
        break;

    case EPG_MSG_TYPE_CLEAR_REMINDER:
        btn_number = 2;
        // PPG.js
        // "MSG_CLEAR_REMINDER": "Are you sure you want to cancel this reminder?",
        g_epg_msgbox_content  = PPG_GetStringByID("MSG_CLEAR_REMINDER");;
        g_epg_msgbox_btn1_text= PPG_GetStringByID("BTN_NO");
        g_epg_msgbox_btn2_text= PPG_GetStringByID("BTN_YES");;
        g_epg_msgbox_btn3_text= "";
        break;

    case EPG_MSG_TYPE_STOP_RECORD:
        btn_number = 2;
        // PPG.js
        // "MSG_STOP_RECORD": "Are you sure you want to stop the recording?",
        g_epg_msgbox_content  = PPG_GetStringByID("MSG_STOP_RECORD");;
        g_epg_msgbox_btn1_text= PPG_GetStringByID("BTN_NO");
        g_epg_msgbox_btn2_text= PPG_GetStringByID("BTN_YES");;
        g_epg_msgbox_btn3_text= "";
        break;

    case EPG_MSG_TYPE_DELETE_RECORD:
        btn_number = 2;
        // PPG.js
        // "MY_RECORDING_DELETE_RECORD": "Are you sure you want to delete this recording?",
        g_epg_msgbox_content  = PPG_GetStringByID("MY_RECORDING_DELETE_RECORD");;
        g_epg_msgbox_btn1_text= PPG_GetStringByID("BTN_NO");
        g_epg_msgbox_btn2_text= PPG_GetStringByID("BTN_YES");;
        g_epg_msgbox_btn3_text= "";
        break;

    case EPG_MSG_TYPE_RECORD_CANCEL_ONE:
        btn_number = 2;
        // PHM.js
        // "QT_RECORD_CANCEL_ONE": "You have to cancel one of the scheduled recordings in Recordings.",
        g_epg_msgbox_content  = PPG_GetStringByID("QT_RECORD_CANCEL_ONE");;
        g_epg_msgbox_btn1_text= PPG_GetStringByID("BTN_NO");
        g_epg_msgbox_btn2_text= PPG_GetStringByID("BTN_YES");;
        g_epg_msgbox_btn3_text= "";
        break;

    case EPG_MSG_TYPE_RECORD_OVERLAP_ADJUST_TIME:
        btn_number = 2;
        // PHM.js
        // "QT_RECORD_OVERLAP_ADJUST_TIME": "This recording time overlaps with another scheduled recording. Adjust the recording time in Recordings.",
        g_epg_msgbox_content  = PPG_GetStringByID("QT_RECORD_OVERLAP_ADJUST_TIME");;
        g_epg_msgbox_btn1_text= PPG_GetStringByID("BTN_NO");
        g_epg_msgbox_btn2_text= PPG_GetStringByID("BTN_YES");;
        g_epg_msgbox_btn3_text= "";
        break;

    case EPG_MSG_TYPE_RECORD_NOT_SCHEDULE:
        btn_number = 1;
        // PHM.js
        // "QT_RECORD_NOT_SCHEDULE": "Recording is not scheduled successfully.",
        // "QT_RECORD_CANCEL_ONE": "You have to cancel one of the scheduled recordings in Recordings.",
        g_epg_msgbox_content  = PPG_GetStringByID("QT_RECORD_NOT_SCHEDULE");
        g_epg_msgbox_content += "<br>";
        g_epg_msgbox_content += PPG_GetStringByID("QT_RECORD_CANCEL_ONE");
        g_epg_msgbox_btn1_text= PPG_GetStringByID("DLG_CANCEL");
        g_epg_msgbox_btn2_text= "";
        g_epg_msgbox_btn3_text= "";
        break;

    case EPG_MSG_TYPE_RECORD_SCHEDULED_START:
        btn_number = 1;
        // PHM.js
        // "QT_RECORD_SCHEDULED_START": "Recording is scheduled. This recording will start after current recording has ended.",
        g_epg_msgbox_content  = PPG_GetStringByID("QT_RECORD_SCHEDULED_START");
        g_epg_msgbox_btn1_text= PPG_GetStringByID("EVT_BTN_CLOSE");
        g_epg_msgbox_btn2_text= "";
        g_epg_msgbox_btn3_text= "";
        break;

    case EPG_MSG_TYPE_RECORD_PART_ADJUST_TIME:
        btn_number = 1;
        // PHM.js
        //"QT_RECORD_PART_ADJUST_TIME": "To avoid a partial recording, you can adjust the recording times in Recordings.",
        g_epg_msgbox_content  = PPG_GetStringByID("QT_RECORD_PART_ADJUST_TIME");
        g_epg_msgbox_btn1_text= PPG_GetStringByID("EVT_BTN_CLOSE");
        g_epg_msgbox_btn2_text= "";
        g_epg_msgbox_btn3_text= "";
        break;

    case EPG_MSG_TYPE_RECORD_CANCEL_ONE_EX:
        btn_number = 1;
        // PHM.js
        // "QT_RECORD_CANCEL_ONE": "You have to cancel one of the scheduled recordings in Recordings.",
        g_epg_msgbox_content  = PPG_GetStringByID("QT_RECORD_CANCEL_ONE");
        g_epg_msgbox_btn1_text= PPG_GetStringByID("EVT_BTN_CLOSE");
        g_epg_msgbox_btn2_text= "";
        g_epg_msgbox_btn3_text= "";
        break;

    case EPG_MSG_TYPE_RECORD_PART_ADJUST_TIME_SCHEDULE: // For ongoing conflict
        btn_number = 1;
        // PHM.js
        // "QT_RECORD_PART_ADJUST_TIME_SCHEDULE": "To avoid a partial recording of the programme you scheduled, you can stop the ongoing recording and adjust the recording times in Recordings.",
        g_epg_msgbox_content  = PPG_GetStringByID("QT_RECORD_PART_ADJUST_TIME_SCHEDULE");
        g_epg_msgbox_btn1_text= PPG_GetStringByID("EVT_BTN_CLOSE");
        g_epg_msgbox_btn2_text= "";
        g_epg_msgbox_btn3_text= "";
        break;



    default:
        break;
    }

    return btn_number;
}

function epg_msg_box_show(msg_id) {

    var btn_number;

    if (g_epg_msg_box_is_showing)
    {
        epg_msg_box_hide();
    }


    g_epg_msg_box_is_showing = true;
    btn_number               = epg_msg_box_get_button_num_by_msg_id(msg_id);
    g_epg_msg_box_btn_count  = btn_number;
    g_epg_msg_box_type_id    = msg_id;

    switch (btn_number)
    {
    case 0:
        $("#epg_2line_dlg").show();
        $("#epg_2line_dlg_text").show();

        $("#epg_2line_dlg_btn_1").hide();
        $("#epg_2line_dlg_btn_2").hide();
        $("#epg_2line_dlg_btn_3").hide();
        $("#epg_2line_dlg_btn_hl").hide();
        g_epg_msg_box_btn_focus_idx = 0;

        $("#epg_2line_dlg_text").html(g_epg_msgbox_content);

        break;

    case 1:
        $("#epg_2line_dlg").show();
        $("#epg_2line_dlg_text").show();

        $("#epg_2line_dlg_btn_1").show();
        $("#epg_2line_dlg_btn_2").hide();
        $("#epg_2line_dlg_btn_3").hide();
        $("#epg_2line_dlg_btn_hl").show();
        g_epg_msg_box_btn_focus_idx = 1; //NO
        $("#epg_2line_dlg_btn_focus").offset({left:850,top:400});

        $("#epg_2line_dlg_text").html(g_epg_msgbox_content);
        $("#epg_2line_dlg_btn1_text").html(g_epg_msgbox_btn1_text);
		$("#epg_2line_dlg_btn1_text").css("color","black");
        break;

    case 2:
        $("#epg_2line_dlg").show();
        $("#epg_2line_dlg_text").show();

        $("#epg_2line_dlg_btn_1").show();
        $("#epg_2line_dlg_btn_2").show();
        $("#epg_2line_dlg_btn_3").hide();
        $("#epg_2line_dlg_btn_hl").show();
        g_epg_msg_box_btn_focus_idx = 1;// default:focus btn 1 is No
		$("#epg_2line_dlg_btn_focus").offset({left:850,top:400});// focus to No button

        $("#epg_2line_dlg_text").html(g_epg_msgbox_content);
        $("#epg_2line_dlg_btn1_text").html(g_epg_msgbox_btn1_text);
        $("#epg_2line_dlg_btn2_text").html(g_epg_msgbox_btn2_text);
		$("#epg_2line_dlg_btn1_text").css("color","black");// default:focus btn 1 is No
		$("#epg_2line_dlg_btn2_text").css("color","white");
        break;

    case 3:
        $("#epg_2line_dlg").show();
        $("#epg_2line_dlg_text").show();

        $("#epg_2line_dlg_btn_1").show();
        $("#epg_2line_dlg_btn_2").show();
        $("#epg_2line_dlg_btn_3").show();
        $("#epg_2line_dlg_btn_hl").show();
        g_epg_msg_box_btn_focus_idx = 1;
        $("#epg_2line_dlg_btn_hl").offset({left:0,top:0});

        $("#epg_2line_dlg_text").html(g_epg_msgbox_content);
        $("#epg_2line_dlg_btn1_text").html(g_epg_msgbox_btn1_text);
        $("#epg_2line_dlg_btn2_text").html(g_epg_msgbox_btn2_text);
        $("#epg_2line_dlg_btn3_text").html(g_epg_msgbox_btn3_text);
        break;

    default:
        g_epg_msg_box_is_showing = false;
        break;
    }
}

function epg_msg_box_hide() {
    $("#epg_2line_dlg").hide();
    $("#epg_2line_dlg_text").hide();

    $("#epg_2line_dlg_btn_1").hide();
    $("#epg_2line_dlg_btn_2").hide();
    $("#epg_2line_dlg_btn_3").hide();
    $("#epg_2line_dlg_btn_hl").hide();

    g_epg_msg_box_is_showing = false;
    g_epg_msg_box_btn_count  = 0;
    g_epg_msg_box_btn_focus_idx = 0;
}

function epg_msg_box_key_handler(kc) {

    var btn_number = g_epg_msg_box_btn_count;

    switch (btn_number)
    {
    case 0:
        epg_msg_box_none_button_key_handler(kc);
        break;

    case 1:
        epg_msg_box_one_button_key_handler(kc);
        break;

    case 2:
        epg_msg_box_two_button_key_handler(kc);
        break;

    case 3:
        epg_msg_box_three_button_key_handler(kc);
        break;

    default:
        break;
    }

    return true;
}

function epg_msg_box_none_button_key_handler(kc){

    switch (kc)
    {
    case KeyEvent.DOM_VK_LEFT:
        break;

    case KeyEvent.DOM_VK_RIGHT:
        break;

    case KeyEvent.DOM_VK_UP:
        break;

    case KeyEvent.DOM_VK_DOWN:
        break;

    case KeyEvent.DOM_VK_ENTER:
    case KeyEvent.DOM_VK_RETURN:
        break;

    case KeyEvent.DOM_VK_BACK:
        epg_msg_box_hide();
        break;

    default:
        break;
    }

    return true;
}

function epg_msg_box_one_button_key_handler(kc){

    switch (kc)
    {
    case KeyEvent.DOM_VK_LEFT:
        break;

    case KeyEvent.DOM_VK_RIGHT:
        break;

    case KeyEvent.DOM_VK_UP:
        break;

    case KeyEvent.DOM_VK_DOWN:
        break;

    case KeyEvent.DOM_VK_ENTER:
    case KeyEvent.DOM_VK_RETURN:
        epg_msg_box_one_button_enter();
        break;

    case KeyEvent.DOM_VK_BACK:
		$("#epg_2line_dlg_btn1_text").css("color","white");
        epg_msg_box_hide();
        break;

    default:
        break;
    }

    return true;
}

function epg_msg_box_two_button_key_handler(kc){

    switch (kc)
    {
    case KeyEvent.DOM_VK_LEFT:
        if (g_epg_msg_box_btn_focus_idx == 1)
        {
            g_epg_msg_box_btn_focus_idx = 2; // btn Yes
            $("#epg_2line_dlg_btn_focus").offset({left:651,top:400});
			$("#epg_2line_dlg_btn1_text").css("color","white");
			$("#epg_2line_dlg_btn2_text").css("color","black");
        }
        else if (g_epg_msg_box_btn_focus_idx == 2)
        {
            g_epg_msg_box_btn_focus_idx = 1;//btn No
            $("#epg_2line_dlg_btn_focus").offset({left:850,top:400});
			$("#epg_2line_dlg_btn1_text").css("color","black");
			$("#epg_2line_dlg_btn2_text").css("color","white");
        }
        break;

    case KeyEvent.DOM_VK_RIGHT:
        if (g_epg_msg_box_btn_focus_idx == 2)
        {
            g_epg_msg_box_btn_focus_idx = 1;
            $("#epg_2line_dlg_btn_focus").offset({left:850,top:400});
			$("#epg_2line_dlg_btn1_text").css("color","black");
			$("#epg_2line_dlg_btn2_text").css("color","white");
        }
        else if (g_epg_msg_box_btn_focus_idx == 1)
        {
            g_epg_msg_box_btn_focus_idx = 2;
            $("#epg_2line_dlg_btn_focus").offset({left:650,top:400});
			$("#epg_2line_dlg_btn1_text").css("color","white");
			$("#epg_2line_dlg_btn2_text").css("color","black");
        }
        break;

    case KeyEvent.DOM_VK_UP:
        break;

    case KeyEvent.DOM_VK_DOWN:
        break;

    case KeyEvent.DOM_VK_ENTER:
    case KeyEvent.DOM_VK_RETURN:
        epg_msg_box_two_button_enter();
        break;

    case KeyEvent.DOM_VK_BACK:
        epg_msg_box_hide();
        break;

    default:
        break;
    }

    return true;
}

function epg_msg_box_three_button_key_handler(kc){

    switch (kc)
    {
    case KeyEvent.DOM_VK_LEFT:
        if (g_epg_msg_box_btn_focus_idx == 1)
        {
            g_epg_msg_box_btn_focus_idx = 2;
            $("#epg_2line_dlg_btn_focus").offset({left:651,top:400});
        }
        else if (g_epg_msg_box_btn_focus_idx == 2)
        {
            g_epg_msg_box_btn_focus_idx = 3;
            $("#epg_2line_dlg_btn_focus").offset({left:451,top:400});
        }
        else if (g_epg_msg_box_btn_focus_idx == 3)
        {
            g_epg_msg_box_btn_focus_idx = 1;
            $("#epg_2line_dlg_btn_focus").offset({left:850,top:400});
        }
        break;

    case KeyEvent.DOM_VK_RIGHT:
        if (g_epg_msg_box_btn_focus_idx == 3)
        {
            g_epg_msg_box_btn_focus_idx = 2;
            $("#epg_2line_dlg_btn_focus").offset({left:651,top:400});
        }
        else if (g_epg_msg_box_btn_focus_idx == 2)
        {
            g_epg_msg_box_btn_focus_idx = 1;
            $("#epg_2line_dlg_btn_focus").offset({left:850,top:400});
        }
        else if (g_epg_msg_box_btn_focus_idx == 1)
        {
            g_epg_msg_box_btn_focus_idx = 3;
            $("#epg_2line_dlg_btn_focus").offset({left:451,top:400});
        }
        break;

    case KeyEvent.DOM_VK_UP:
        break;

    case KeyEvent.DOM_VK_DOWN:
        break;

    case KeyEvent.DOM_VK_ENTER:
    case KeyEvent.DOM_VK_RETURN:
        epg_msg_box_three_button_enter();
        break;

    case KeyEvent.DOM_VK_BACK:
        epg_msg_box_hide();
        break;

    default:
        break;
    }

    return true;
}

function epg_msg_box_one_button_enter() {

    if (g_epg_msg_box_btn_focus_idx == 1)
    {
        // TODO:
		$("#epg_2line_dlg_btn1_text").css("color","white");
        epg_msg_box_hide();

    }
}

function epg_record_stop() {
    g_mtvObj.setStopRecord();
    epgInfoPageRecordingOnGoingIconUpdate(false);
    epgColorKeyTextUpdate();
}

function epg_record_clear(need_fresh_epg_event_list) {

    console.log("[epg_record_clear] enter");

    var channel_id = g_channelList[g_channelFocusIdx].CHANNEL_ID;
    var event_id   = epgGetFoucsEventID();
    var evtItem    = g_mtvObj.getEpgEventInfoById(channel_id, event_id);

    var start_time = evtItem.START_TIME;
    var duration   = evtItem.DURATION;
    var event_title= evtItem.EVENT_NAME;
    var event_genre= 0;

    if (evtItem.CATEGORY_NUM > 0) {
        event_genre = evtItem.CATEGORY[0];
    }

    var rec_start_time    = start_time;
    var rec_duration_time = duration;

    if (need_fresh_epg_event_list)
    {
        console.log("[epg_record_clear] conflict event, need fresh whole epg event list");

        epgEventGetReminderRecordStatus(channel_id, evtItem);
        if (evtItem.isConflict) {

            // Fresh Whole EPG Event List UI
            epgFreshCurrentPageUI();
        }
    }
    else
    {
        console.log("[epg_record_clear] not conflict event");

        epgEventGetReminderRecordStatus(channel_id, evtItem);

        var ch_svl_id = epgGetFoucsChannelSvlID();
        g_mtvObj.setOrClearReminder(2, ch_svl_id, channel_id, event_id, start_time, duration, rec_start_time, rec_duration_time, event_title, event_genre);

        // Only Fresh focus event item
        epgInfoPageRecordIconUpdate(false);
        epgColorKeyTextUpdate();

        if (evtItem.isConflict) {
            console.log("[epg_record_clear] fresh whole epg event list");
            // Fresh Whole EPG Event List UI
            epgFreshCurrentPageUI();
        }

    }
}

function epg_reminder_clear() {
}

function epg_msg_box_two_button_enter() {

    if (g_epg_msg_box_btn_focus_idx == 1)
    {
        // 1: Button - No
        switch (g_epg_msg_box_type_id)
        {
        case EPG_MSG_TYPE_STOP_RECORD:
            break;

        case EPG_MSG_TYPE_RECORD_CANCEL_ONE:
            epg_scheduled_cancel_one(false);
            break;

        case EPG_MSG_TYPE_CLEAR_RECORD:
            epg_record_clear(true);
            break;

        default:
            break;
        }
    }
    else if (g_epg_msg_box_btn_focus_idx == 2)
    {
        // 2: Button - Yes
        switch (g_epg_msg_box_type_id)
        {
        case EPG_MSG_TYPE_STOP_RECORD:
            epg_record_stop();
            break;

        case EPG_MSG_TYPE_RECORD_CANCEL_ONE:
            epg_scheduled_cancel_one(true);
            break;

        case EPG_MSG_TYPE_CLEAR_RECORD:
            epg_record_clear(false);
            break;

        default:
            break;
        }
    }

    epg_msg_box_hide();
}

function epg_msg_box_three_button_enter() {

    if (g_epg_msg_box_btn_focus_idx == 1)
    {
        // TODO:
    }
    else if (g_epg_msg_box_btn_focus_idx == 2)
    {
        // TODO:
    }
    else if (g_epg_msg_box_btn_focus_idx == 3)
    {
        // TODO:
    }

    epg_msg_box_hide();
}