//: 720P Layout
//: http://172.16.112.77:8090/display/ENTRY/11-6.+Layout+720P
//: Username: guest_dev_tpe
//: Password: 6vlZJaHDur8g
var local_mtvObj = new MtvObj();

var flags=[
//: rename -v 's/Flag_of_//' *.png,
//: ls -1
'Albania.png',
'Algeria.png',
'Argentina.png',
'Armenia.png',
'Australia.png',
'Austria.png',
'Azerbaijan.png',
'Bahrain.png',
'Belarus.png',
'Belgium.png',
'Bosnia_and_Herzegovina.png',
'Brazil.png',
'Bulgaria.png',
'Chile.png',  //LT
'Colombia.png',
'Costa_Rica.png',
'Croatia.png',
'Czech_Republic.png',
'Denmark.png',
'Ecuador.png', //LT
'Egypt.png',
'El_Salvador.png',//LT
'England.png',
'Estonia.png',
'Finland.png',
'France.png',
'Georgia.png',
'Germany.png',
'Greece.png',
'Guatemala.png', //LT
'Honduras.png', //LT
'Hungary.png',
'Iceland.png',
'India.png',
'Indonesia.png',
//'Iran.png',
'Ireland.png',
'Israel.png',
'Italy.png',
'Japan.png',
'Kazakhstan.png',
'Kuwait.png',
'Kyrgyzstan.png',
'Latvia.png',
'Lithuania.png',
'Luxembourg.png',
'Macedonia.png',
'Malaysia.png',
'Mauritius.png', //AP
'Mexico.png',
'Moldova.png',
'Montenegro.png',
'Morocco.png',
'Myanmar.png',
'New_Zealand.png',
'Nicaragua.png',  //LT
'Nigeria.png',
'Northern_Ireland.png',
'Norway.png',
'Oman.png',  //AP
'Panama.png',
'Paraguay.png',
'Peru.png',
'Poland.png',
'Portugal.png',
'Romania.png',
'Russia.png',
'Saudi_Arabia.png',
'Scotland.png',
'Senegal.png',
'Serbia.png',
'Singapore.png',
'Slovakia.png',
'Slovenia.png',
'South_Africa.png',
'South_Korea.png',
'Spain.png',
'Sweden.png',
'Switzerland.png',
'Tajikistan.png',
'Thailand.png',
'the_Netherlands.png',
'the_PRC_China.png',
'the_Philippines.png',
'the_United_Arab_Emirates.png',
'the_United_Kingdom.png',
'Tunisia.png',
'Turkey.png',
'Turkmenistan.png',
'Ukraine.png',
'Uruguay.png',
'Uzbekistan.png',
'Vietnam.png',
'Wales.png'
];

var flags_translate_key=[
//: rename -v 's/Flag_of_//' *.png,
//: ls -1
'COUNT_0',//'Albania.png',
'COUNT_MEA_1',//'Algeria.png',
'COUNT_LT_1',//'Argentina.png',
'COUNT_0_1',//'Armenia.png',
'COUNT_36',//'Australia.png',
'COUNT_1',//'Austria.png',
'COUNT_1_1',//'Azerbaijan.png',
'COUNT_MEA_2',//'Bahrain.png',
'COUNT_1_2',//'Belarus.png',
'COUNT_2',//'Belgium.png',
'COUNT_2_1',//'Bosnia_and_Herzegovina.png',
'COUNT_LT_2',//'Brazil.png',
'COUNT_3',//'Bulgaria.png',
'COUNT_LT_2K18_5_1',//'Chile.png',
'MAIN_COLOMBIA', //: 'Colombia.png',
'MAIN_COSTA_RICA', //: 'Costa_Rica.png',
'COUNT_4',//'Croatia.png',
'COUNT_5',//'Czech_Republic.png',
'COUNT_6',//'Denmark.png',
'COUNT_LT_2K18_4_2',//'Ecuador.png',
'COUNT_MEA_3',//'Egypt.png',
'COUNT_LT_2K18_4_3',//El_Salvador.png',
'MAIN_ENGLAND',   //:England.png
'COUNT_7',//'Estonia.png',
'COUNT_8',//'Finland.png',
'COUNT_9',//'France.png',
'COUNT_9_1',//'Georgia.png',
'COUNT_10',//'Germany.png',
'COUNT_11', //: Greece.png
'COUNT_LT_2K18_4_4',//'Guatemala.png', 
'COUNT_LT_2K18_4_5',//'Honduras.png', 
'COUNT_12',//'Hungary.png',
'COUNT_13',//'Iceland.png',
'COUNT_AP_IND',//'India.png',
'COUNT_40',//'Indonesia.png',
//'MAIN_IRAN', // 'Iran.png',
'COUNT_13',//'Ireland.png',
'COUNT_38',//'Israel.png',
'COUNT_14',//'Italy.png',
'MAIN_JAPAN',//'Japan.png'
'COUNT_15',//'Kazakhstan.png',
'COUNT_MEA_4',//'Kuwait.png',
'MAIN_KYRGYZSTAN',//'Kyrgyzstan.png',
'COUNT_16',//'Latvia.png',
'COUNT_17',//'Lithuania.png',
'COUNT_18',//'Luxembourg.png',
'COUNT_18_1',//'Macedonia.png',
'COUNT_42',//'Malaysia.png',
'COUNT_MEA_6_2K18',//'Mauritius.png',
'MAIN_MEXICO',//'Mexico.png',
'MAIN_MOLDOVA',//'Moldova.png',
'COUNT_18_2',//'Montenegro.png',
'MAIN_MOROCCO',//'Morocco.png'
'MAIN_MYANMAR',//'Myanmar.png',                      no translation
'COUNT_37',//'New_Zealand.png',
'COUNT_LT_2K18_4_6',//'Nicaragua.png',  
'MAIN_NIGERIA',//'Nigeria.png'
'MAIN_NORTHERN_IRELAND',//Northern_Ireland.png',  no translation
'COUNT_21',//'Norway.png',
'COUNT_MEA_8_2K18',//'Oman.png',
'MAIN_PANAMA',//'Panama.png'
'COUNT_LT_5',//'Paraguay.png',
'MAIN_PERU',//'Peru.png'
'COUNT_22',//'Poland.png',
'COUNT_23',//'Portugal.png',
'COUNT_24',//'Romania.png',
'COUNT_25',//'Russia.png',
'MAIN_SAUDI_ARABIA',//'Saudi_Arabia.png',            no translation
'MAIN_SCOTLAND', //: SCOTLAND.png
'MAIN_SENEGAL',//'Senegal.png'
'COUNT_26',//'Serbia.png',
'COUNT_39',//'Singapore.png',
'COUNT_27',//'Slovakia.png',
'COUNT_28',//'Slovenia.png',
'MAIN_SOUTH_AFRICA',//'South_Africa.png',            no translation
'MAIN_SOUTH_KOREA',//'South_Korea.png',             no translation
'COUNT_29',//'Spain.png',
'COUNT_30',//'Sweden.png',
'COUNT_31',//'Switzerland.png',
'MAIN_TAJIKISTAN',//'Tajikistan.png',
'COUNT_41',//'Thailand.png',
'COUNT_20',//'the_Netherlands.png',
'MAIN_PEOPLE_REPUBLIC_CHINA',// 'the_People's_Republic_of_China.png',
'COUNT_LT_6',//'the_Philippines.png',
'COUNT_MEA_5',//'the_United_Arab_Emirates.png',
'COUNT_33',//'the_United_Kingdom.png',    
'MAIN_TUNISIA',//'Tunisia.png'
'COUNT_32',//'Turkey.png',
'MAIN_TURKMENISTAN',//'Turkmenistan.png',
'COUNT_34',//'Ukraine.png',
'COUNT_LT_4',//'Uruguay.png'
'MAIN_UZBEKISTAN',//'Uzbekistan.png',
'COUNT_AP_7',//'Vietnam.png'
'MAIN_WALES',//: Wales.png
];

var total_flags=flags.length;
var flags_cur_highlight_item=0;
var flags_cur_selected_item=-1;

//: read grid binary data from file
//: print to console for C code use in ambi-lib
function print_grid_data_for_c_code() {
var flag_num=flags.length;
var i,j,k,r,g,b,pixel;

var grid_str="";
grid_str=grid_str+'typedef struct {\n    char flag_name[64]; \n    UINT32 flag_grid_data[32*20];\n   }  FLAG_GRID_DATA;\n\n';
grid_str=grid_str+'#define TOTAL_FLAGS ('+flag_num+')\n';
grid_str=grid_str+'const FLAG_GRID_DATA flags_grid_data[TOTAL_FLAGS]={'+'\n\n';
for(i=0;i<flag_num;i++)
	{
	var cur_flag=flags[i];
	var url='images/flags-grid-data/'+cur_flag.substring(0,cur_flag.length-4)+'.ppm';

	var byteArray = [];
	var req = new XMLHttpRequest();
	req.open('GET', url, false);
	req.overrideMimeType('text\/plain; charset=x-user-defined');
	req.send(null);
	if (req.status != 200){
		grid_str=grid_str+'//:cant find file '+url;
		continue;
		}

	grid_str=grid_str+'//:grid data from file: '+url+'\n';
	
	grid_str=grid_str+'{\n    "'+cur_flag+'",  //:flag name \n    {\n    ';
	for (j = 13; j < req.responseText.length; j+=3) {
		r=req.responseText.charCodeAt(j);
		g=req.responseText.charCodeAt(j+1);
		b=req.responseText.charCodeAt(j+2);
		if(((j-13)%24)==0 && (j>13)) {
			grid_str=grid_str+'  //:line end pos:'+(j-13)/3+'\n    ';
			}
		grid_str=grid_str+'0x00'+("000" + b.toString(16)).slice(-2) +("000" + g.toString(16)).slice(-2) +("000" + r.toString(16)).slice(-2)+ ',';		
		}
	grid_str=grid_str+'\n    } \n';
	if(i<(flag_num-1)) {
		grid_str=grid_str+'}, \n\n';
		}
	else {
		grid_str=grid_str+'}\n\n';
		}
	}

	grid_str=grid_str+'};\n';
	console.log(grid_str);
}

//:print the index map of grid ppm data file name
function print_grid_file_list()
{
var flag_num=flags.length;
var i;
var FLAG_DATA_DASH_BASE_DIR= mtvuiUtil.getBrandUrl() + "dash/AmbiFlag/images/flags-grid-data/";
var cur_flag;
var ppm_file;

var grid_str="#this file should less than 3KB to be easy read in kernel buffer\r\n";
grid_str=grid_str+"#[base_dir]="+FLAG_DATA_DASH_BASE_DIR+"  just as comment, fixed inside mamb.o\r\n";
for(i=0;i<flag_num;i++)
	{
	cur_flag=flags[i];
	ppm_file=cur_flag.substring(0,cur_flag.length-4)+'.ppm'+'\r\n';
	grid_str=grid_str+'['+i+']='+ppm_file;
       }

	console.log(grid_str);
}

//: read grid binary data from file
function get_grid_data(url) {
  var byteArray = [];
  var req = new XMLHttpRequest();
  req.open('GET', url, false);
  req.overrideMimeType('text\/plain; charset=x-user-defined');
  req.send(null);
  if (req.status != 200) return byteArray;
  for (var i = 0; i < req.responseText.length; ++i) {
    byteArray.push(req.responseText.charCodeAt(i) & 0xff)
  }
  return byteArray;
}

/*************************************************************************************
shui 2017-07-25	flags-grid-data is 32x20 grid data 
   1) (R G B, each 8 bit, start from byte 14 of the file, front 13 bytes is header) --> "P6 32 20 255 "
   2) data is from top-left to bottom-right, total 639 points, so need 1 extra points? (may copy from last)
   3) the data will send to ambilight by TV internel message (plugin+message)

   file put the name as :  images/flags-grid-data/*.ppm
****************************************************************************************/
function send_flags_grid_data(idx)
{
var cur_flag=flags[idx];
var file_name='images/flags-grid-data/'+cur_flag.substring(0,cur_flag.length-4)+'.ppm';
var file_ppm=cur_flag.substring(0,cur_flag.length-4)+'.ppm';

//var grid_data=get_grid_data(file_name);
//console.log('grid_data len='+grid_data.length);
if (!window.tvJspService) {
     window.tvJspService = new TV_JSP();
    }

//: data is string command like
//:   { "function":"try_ambiflag","flag":"Albania.png","idx":0}
//:   { "function":"confirm_ambiflag"}
//:   { "function":"cancel_ambiflag"}
  window.tvJspService.tvServices.AmbiSet(6,'{ "function":"try_ambiflag","flag":"'+file_ppm+'","idx":'+idx+'}');//: 6 for IMxtvR_xtv_post_to_ambi(func_idx=AMBI_FUNC_IDX_WAVE_YOUR_FLAG,...)

}

function select_flag_item(idx)
{
	 if(idx>total_flags || idx<0) return;	

	 unselect_flag_item(flags_cur_selected_item);
	 flags_cur_selected_item=idx;
	
       var items = $("#flags-shelf").children();

	if (!$(items[idx]).hasClass("selected")) {
	        items[idx].classList.add("selected");
	        }	

	send_flags_grid_data(idx);
}

function unselect_flag_item(idx)
{
	if(idx>total_flags || idx<0) return;	
	
       var items = $("#flags-shelf").children();

	if ($(items[idx]).hasClass("selected")) {
	        items[idx].classList.remove("selected");
	        }		
}

function isOverflowed(element) {
    return element.scrollWidth > element.clientWidth;
}

	
function highlight_flag_item(idx)
{
	 if(idx>total_flags || idx<0) return;	
        var items = $("#flags-shelf").children();

	if (!$(items[idx]).hasClass("active")) {
	        items[idx].classList.add("active");
	        }

	items = $("#flags-shelf li:eq("+idx+") .flag-name");
	if(isOverflowed(items[0]))
		{
		if (!$(items[0]).hasClass("scroll")) {
		        items[0].classList.add("scroll");
		        }
		}
		
}

function lowlight_flag_item(idx)
{
	 if(idx>total_flags || idx<0) return;	
        var items = $("#flags-shelf").children();

	    if ($(items[idx]).hasClass("active")) {
	        items[idx].classList.remove("active");
	        }		

	items = $("#flags-shelf li:eq("+idx+") .flag-name");
	if ($(items[0]).hasClass("scroll")) {
	        items[0].classList.remove("scroll");
	        }
}

//: only highlight for row 0 and 1, or else need to shift up/down
function check_for_shift(idx)
{
	 var cur_col=idx%4;
	 var cur_row=	(idx-cur_col)/4;
	 var last_row=Math.floor((total_flags+3)/4);
	 var win_h=window.innerHeight;

	 var flag_row_height=194;
	 var last_row_shift=60;
	 if(win_h==1080) {
	 	flag_row_height*=1.5;
		last_row_shift*=1.5;
	 	}

	if(cur_row>1) {
		if((cur_row+1)<last_row) {
	        	$("#flags-shelf")[0].style.transform = 'translateY(-'+flag_row_height*(cur_row-1) + 'px)';
			}
		else {
			//:last row, not shift so much
			if(cur_row>2) {
	        		$("#flags-shelf")[0].style.transform = 'translateY(-'+(flag_row_height*(cur_row-2)+last_row_shift)+ 'px)';
				}
			}
		$("#ScrollUp")[0].style.display='block';
		}
	else {
        	$("#flags-shelf")[0].style.transform = 'translateY(0px)';
		$("#ScrollUp")[0].style.display='none';		
		}

	if((cur_row+1)<last_row) {
		$("#ScrollDown")[0].style.display='block';		
		}
	else {
		$("#ScrollDown")[0].style.display='none';		
		}


}

var is_screen2_display=0;
var screen2_highlight_item=0;  //:0 for cancel 1 for apply

function screen2_highligh_update(idx)
{
        var item_cancel = $("#screen2 .cancel-button");
        var item_apply = $("#screen2 .apply-button");

        if(idx==0) // for cancel selection
        	{
		    if (!$(item_cancel[0]).hasClass("active")) {
		        item_cancel[0].classList.add("active");
		        }	
			
		    if ($(item_apply[0]).hasClass("active")) {
		        item_apply[0].classList.remove("active");
		        }	
        	}	
	else   // for apply selection
        	{
		    if ($(item_cancel[0]).hasClass("active")) {
		        item_cancel[0].classList.remove("active");
		        }	
			
		    if (!$(item_apply[0]).hasClass("active")) {
		        item_apply[0].classList.add("active");
		        }	
        	}	
	

}

function display_screen2()
{
        var items = $("#screen2");

	    if (!$("#screen2").hasClass("active")) {
	        items[0].classList.add("active");
	        }	
	    is_screen2_display=1;	
	    screen2_highligh_update(screen2_highlight_item);	
}

function hide_screen2()
{
        var items = $("#screen2");

	    if ($("#screen2").hasClass("active")) {
	        items[0].classList.remove("active");
	        }	

    var current_url = document.URL;
    var find_idx=current_url.indexOf("localhost");

if(0) {
     if(find_idx<0)
              {//: run_from_local_TV
                  if (!window.tvJspService) {
		     window.tvJspService = new TV_JSP();
		    }
	      window.tvJspService.tvServices.advMsg('largeAdv','adv exit user_press_return');
          	}
}
else {
	//:iframe send back to parent
	//: otherWindow.postMessage(message, targetOrigin, [transfer]);
	//:  message={{"messageFrom":"file:///mnt/usb/sda/html5/dash/Amb�tml","messageData":"exitAmbiFlag","ExitAction":1}

//:shui 2017-08-21 move wave flag to 'general setting'
	var cur_url=document.URL;
	var message_str='{"messageFrom":"'+cur_url+'","messageData":"exitAmbiFlag","ExitAction":'+screen2_highlight_item+'}';
	window.parent.postMessage(message_str,cur_url);
	mtvuiUtil.gotoSysPage("sys_index");
}

    is_screen2_display=0;	
    screen2_highlight_item=0;
}

function update_field_with_trans_str(field,str_key)
{
   var tmp_str=local_mtvObj.getLangString(str_key);
   if(tmp_str !== undefined && tmp_str !== "")
   	{
   	$(field).html(tmp_str);
   	}
}

$(document).ready(function () {
//: init flag list
        var items = $("#flags-shelf")
        var cur_flag,flag_name,tmp_str;
        var new_data="";

	try {
	       //:get last highlight
		if (!window.tvJspService) {
		     window.tvJspService = new TV_JSP();
		    }
		 var last_selection=window.tvJspService.tvServices.AmbiGet(6,'{ "function":"get_ambiflag"}');//: 6 for IMxtvR_xtv_get_from_ambi(func_idx=AMBI_FUNC_IDX_WAVE_YOUR_FLAG,...)
		}
	catch(e) {
		}

	/***************************************************************************************	
	//: still waiting for translate
	$('#TitleText').html(local_mtvObj.getLangString('MAIN_FOLLOW_FLAG'));//: replace 'Follow Flag'
	$('#select_text').html(local_mtvObj.getLangString('MAIN_SELECT_FLAG'));//: replace 'Select Flag'
	$('#hint_text').html(local_mtvObj.getLangString('MAIN_CH_SELECT_FLAG'));//: replace help hint
	$('#WaveFlag_Scr2_CountryFlag').html(local_mtvObj.getLangString('MAIN_COUNTRY_FLAG'));//: replace 'Country Flagg'
	$('#WaveFlag_Scr2_HintSaving').html(local_mtvObj.getLangString('MAIN_CH_COUNTRY_FLAG'));//: replace 'Saving your choice'
	$('#WaveFlag_Scr2_HintPrompt').html(local_mtvObj.getLangString('MAIN_DI_COUNTRY_FLAG'));//: replace 'do you ...
	$('#WaveFlag_Scr2_NoBtn').html(local_mtvObj.getLangString('No'));//: replace 'No'
	$('#WaveFlag_Scr2_ApplyBtn').html(local_mtvObj.getLangString('No'));//: replace 'Apply'
	**************************************************************************************/

	update_field_with_trans_str('#TitleText','MAIN_FOLLOW_FLAG');//: replace 'Follow Flag'
	update_field_with_trans_str('#select_text','MAIN_SELECT_FLAG');//: replace 'Select Flag'
	update_field_with_trans_str('#hint_text','MAIN_CH_SELECT_FLAG');//: replace help hint
	update_field_with_trans_str('#WaveFlag_Scr2_CountryFlag','MAIN_COUNTRY_FLAG');//: replace 'Country Flagg'
	update_field_with_trans_str('#WaveFlag_Scr2_HintSaving','MAIN_CH_COUNTRY_FLAG');//: replace 'Saving your choice'
	update_field_with_trans_str('#WaveFlag_Scr2_HintPrompt','MAIN_DI_COUNTRY_FLAG');//: replace 'do you ...
	update_field_with_trans_str('#WaveFlag_Scr2_NoBtn','CHM_DLG_CANCEL_NO');//: replace 'No'
	update_field_with_trans_str('#WaveFlag_Scr2_ApplyBtn','CHM_DLG_CANCEL_YES');//: replace 'Yes'
	
	//items.empty();
	for (var index = 0; index < total_flags; ++index) {
		  cur_flag=flags[index];
		  flag_name=flags_translate_key[index];
		  //:check if 'no translation', COUNT_xxx will be translated
		  	tmp_str=local_mtvObj.getLangString(flag_name);
			if(tmp_str !== undefined && tmp_str !== "")
				{
				flag_name=tmp_str;
				}
			else {
				//: use default name??
				flag_name=cur_flag.substring(0,cur_flag.length-4);
				}
		  
                new_data=new_data+'<li class="flag-item"> <div class="flag-block"> <div class="flag-top-gap"></div> '
					+'<div class="flag-thumbnail"><img  class="thumbnail-flag-icon" src="images/flags/'+cur_flag +'" alt=""></div> '
					+'<div class="flag-name">'+flag_name+'</div>'
					+'</div> </li>';
	    }

	 items.append( new_data);	 
//	 shui 2017-09-20 to overcome the enter flicker problem, display as none before load
//	 highlight_flag_item(flags_cur_highlight_item);
	 var selected_flag;
	 try {//: get_ambiflag:{"saved_flag":6,"ambiFlagOnOff":0}
	        selected_flag= JSON.parse(last_selection);
		 //var init_flag_idx=find_selected_flag_by_name(selected_flag.saved_flag);	
		 var init_flag_idx=selected_flag.saved_flag;
		 if(init_flag_idx>=0 && init_flag_idx<total_flags)
		 	{
		 	select_flag_item(init_flag_idx);
			lowlight_flag_item(flags_cur_highlight_item);
			flags_cur_highlight_item=init_flag_idx;
			highlight_flag_item(flags_cur_highlight_item);
			check_for_shift(flags_cur_highlight_item);
		 	}
		 console.log('get_ambiflag:'+last_selection+ 'idx='+init_flag_idx);
	    } catch (e) {
		 console.log('get_ambiflag="'+last_selection+'" error:'+e);
		  highlight_flag_item(flags_cur_highlight_item);
	    }

});

function find_selected_flag_by_name(flagName)
{
  var i;
   console.log('init flagName:'+flagName);
   for(i=0;i<total_flags;i++)
   	{
   	if(flagName===flags[i])
   		{
		   console.log('init flagidx:'+i);
		   return i;
   		}
   	}
   
   console.log('cant find init flag idx,default to 0');
   return 0;
}

$(window).load(function() { 
	//: data is string command like
	//:   { "function":"try_ambiflag","flag":"Albania.png"}
	//:   { "function":"confirm_ambiflag","flag":"Albania.png"}
	//:   { "function":"cancel_ambiflag"}
//	 shui 2017-09-20 to overcome the enter flicker problem, display after load
	$("#flags-shelf")[0].style.display="block";
	});

document.addEventListener("keydown",key_handle);

function screen2_key_handle(key) {
  
   switch(key) {
	   	
	case 13://enter/ok
   	case 462://:Home
   	case 461://:return
//: data is string command like
//:   { "function":"try_ambiflag","flag":"Albania.png"}
//:   { "function":"confirm_ambiflag","flag":"Albania.png"}
//:   { "function":"cancel_ambiflag"}
		if (!window.tvJspService) {
		     window.tvJspService = new TV_JSP();
		    }
		//: 6 for IMxtvR_xtv_post_to_ambi(func_idx=AMBI_FUNC_IDX_WAVE_YOUR_FLAG,...)
		if(screen2_highlight_item==0)
			{
			  window.tvJspService.tvServices.AmbiSet(6,'{ "function":"cancel_ambiflag"}');			
			}
		else {
			  window.tvJspService.tvServices.AmbiSet(6,'{ "function":"confirm_ambiflag"}');						
			}

   	       hide_screen2();
		//event.preventDefault();   //:allow return key to system handle?
		return true;
		
	case 38:  /* Up arrow was pressed */
	case 40:  /* Down arrow was pressed */
	case 37:  /* Left arrow was pressed */
	case 39:  /* Right arrow was pressed */
		if(screen2_highlight_item==0)
			{
			screen2_highlight_item=1;
			}
		else {
			screen2_highlight_item=0;
			}
	       screen2_highligh_update(screen2_highlight_item);	
	      event.preventDefault();		   
		break;				
     }

   //event.preventDefault();
   return true;
}

function key_handle(event) {
   var key = event.which || event.keyCode;
   var cur_url=document.URL;

  if(key==802) //: shui 2017-11-30 power key, force exit
  	{
  	hide_screen2();
  	return true;
  	}
  
  if(is_screen2_display)
  	{
  	screen2_key_handle(key);
  	return true;
  	}
  
   switch(key) {
       case 48: //:key 0
   	//window.history.back();
	 //event.preventDefault();
   	break;

       case 27: //: windows ESC=27
       case 8:  //: windows BackSpace
           display_screen2();
           break;
	   	
	case 13://enter/ok
	    select_flag_item(flags_cur_highlight_item);
	    break;

	case 56: //: key 8, generate C code grid data
		//print_grid_data_for_c_code();	
		//print_grid_file_list();
		break;
		
   	case 462://:Home
   	case 461://:return
             display_screen2();
	      break;
         
	case 38:  /* Up arrow was pressed */
		if(flags_cur_highlight_item>=4)
			{
			lowlight_flag_item(flags_cur_highlight_item);
			flags_cur_highlight_item-=4;
			highlight_flag_item(flags_cur_highlight_item);
			check_for_shift(flags_cur_highlight_item);
			}
		break;
	case 40:  /* Down arrow was pressed */
		if((flags_cur_highlight_item+4)<total_flags)
			{
			lowlight_flag_item(flags_cur_highlight_item);
			flags_cur_highlight_item+=4;
			highlight_flag_item(flags_cur_highlight_item);
			check_for_shift(flags_cur_highlight_item);
			}
		break;
	case 37:  /* Left arrow was pressed */
		if((flags_cur_highlight_item%4)>0)
			{
			lowlight_flag_item(flags_cur_highlight_item);
			flags_cur_highlight_item--;
			highlight_flag_item(flags_cur_highlight_item);
			check_for_shift(flags_cur_highlight_item);
			}
		break;
	case 39:  /* Right arrow was pressed */
		if((flags_cur_highlight_item+1)<total_flags && ((flags_cur_highlight_item%4)+1)<4)
			{
			lowlight_flag_item(flags_cur_highlight_item);
			flags_cur_highlight_item++;
			highlight_flag_item(flags_cur_highlight_item);
			check_for_shift(flags_cur_highlight_item);
			}
		break;				
     }

   event.preventDefault();
   return true;
}

