var VideoPlayObj = function() {
    this.handle;
    this.hidebar_t = null;
    this.hideBottombar_t;
    this.playBtnLenth = 1000;
    this.mediaSeek_t = null;
    this.startSeekTime = -1;
    this.mediaDuration = 0;
    this.currentPos = 0;
    this.mediaInfo;
    this.isPlayAll = false;
    this.shuffle = false;
    this.playObj;
    this.isPlayDone;
    this.curPlayInfo;
    this.activeContent;
    this.curSpeed;
    this.isInfoShow = false;
    this.dmrSpeed = -1;
    this.timeSeekCount = 0;
    this.iscamcardmissing = false;
	this.refreshOption = false;
	this.errorMsgTimeout = null;
};

VideoPlayObj.prototype.getRepeat = function() {
    var repeat = Repeat;
    if (repeat.curValue == 0) {
        return false;
    } else {
        return true;
    }
};

VideoPlayObj.prototype.hidebar = function() {
    console.log("hidebar id = ");
    if (playStatus != MmpPlayStatus.Speed) {
        if (document.activeElement.tagName != "BODY" && document.activeElement.tagName != "IFRAME") {
            this.activeContent = document.activeElement;
        }
        $('#video_player_bg').fadeOut();
    }
};

VideoPlayObj.prototype.timeout = function(isStop) {
    if (null != this.hidebar_t) {
        clearTimeout(this.hidebar_t);
        this.hidebar_t = null;
    }
    if (!isStop) {
        if(!this.isInfoShow){
            this.hidebar_t = setTimeout("videoPlayObj.hidebar()", 5000);
        }
    }
}

VideoPlayObj.prototype.showBottombar = function() {
    console.log("showBottombar");
    $('#video_play_footer').fadeIn();
    if (null != this.hideBottombar_t) {
        clearTimeout(this.hideBottombar_t);
    }
    this.hideBottombar_t = setTimeout("videoPlayObj.hideBottombar()", 2000);
}

VideoPlayObj.prototype.hideBottombar = function() {
    console.log("hideBottombar = ");
    $('#video_play_footer').fadeOut();
}

VideoPlayObj.prototype.showMediaBar = function() {
    if (isStopInfoDialogShow() || this.playObj.curSourceType == SourceType.SuperShop) {
        console.log("showMediaBar return");
        return;
    }
	if ($("#nownext_info_page").is(':visible'))  $('#video_progress').hide(); /*20180131 fix [TF518PHIEUMTK01-4246] [AP] Partial process bar shows in Channel info during PVR playback*/
    $('#video_player_bg').show();
    videoPlayObj.timeout();
    videoPlayObj.timeupdate();
    if (!this.isVideoDialogShow()) {
        if (this.activeContent && $(this.activeContent).is(':visible')) {
            $(this.activeContent).focus();
        } else {
            $('#video_play_ctrl_bar div:nth-child(3)').focus();
        }
    }
}

function video_play_key_up_dispatch(event) {
    var key = event.which || event.keyCode;
    switch (key) {
        case KeyEvent.DOM_VK_RETURN:
            if (isDialogShow()) {
                if (isOptionDialogShow()) {
                    option_key_dispatch(event);
                } else {
                    color_bar_list_key_dispatch(true, event);
                }
                return;
            } else if (pvrDialog && pvrDialog != null) {
                pvr_rating_blocked_key_dispatch(true, event);
                return;
            } else if (stopInfoDialog && stopInfoDialog != null) {
                dms_wakeup_key_dispatch(true, event);
                return;
            }
            videoPlayObj.key_dispatch(true, event);
            break;
    }
}

function video_play_key_dispatch(event, isUp) {
    console.log("video_play_key_dispatch");
    var keynum = event.which || event.keyCode;
    switch (keynum) {
        case KeyEvent.DOM_VK_LIST:
            if (videoPlayObj.playObj.curSourceType == SourceType.Dmr) {
                mtvuiUtil.procSysKey(KeyEvent.DOM_VK_LIST);
                return true;
            }
			else
				videoPlayObj.handleCommonKey(event);
			break;
        case KeyEvent.DOM_VK_UP:
        case KeyEvent.DOM_VK_DOWN:
        case KeyEvent.DOM_VK_LEFT:
        case KeyEvent.DOM_VK_RIGHT:
        case KeyEvent.DOM_VK_RETURN:
            if (isDialogShow()) {
                if (isOptionDialogShow()) {
                    option_key_dispatch(event);
                } else {
                    color_bar_list_key_dispatch(true, event);
                }
                return;
            } else if (pvrDialog && pvrDialog != null) {
                pvr_rating_blocked_key_dispatch(true, event);
                return;
            } else if (stopInfoDialog && stopInfoDialog != null) {
                dms_wakeup_key_dispatch(true, event);
                return;
            }
			//20171002 [TF518PHIEUMTK02-51] EIT information shall be part of any recorded event or available in the review buffer
			else if ($("#nownext_info_page").is(':visible')) {
				return;
			}
			// end
            videoPlayObj.key_dispatch(KeyEvent.DOM_VK_RETURN == keynum ? false : true, event);
            break;
        case KeyEvent.DOM_VK_0:
        case KeyEvent.DOM_VK_1:
        case KeyEvent.DOM_VK_2:
        case KeyEvent.DOM_VK_3:
        case KeyEvent.DOM_VK_4:
        case KeyEvent.DOM_VK_5:
        case KeyEvent.DOM_VK_6:
        case KeyEvent.DOM_VK_7:
        case KeyEvent.DOM_VK_8:
        case KeyEvent.DOM_VK_9:
            if (pvrDialog && pvrDialog != null) {
                pvr_rating_blocked_key_dispatch(true, event);
            }
            break;
        case KeyEvent.DOM_VK_TRACK_PREV:
        case KeyEvent.DOM_VK_TRACK_NEXT:
        case KeyEvent.DOM_VK_OPTION:
        case KeyEvent.DOM_VK_SUBTITLE:
        case KeyEvent.DOM_VK_INFO:
        case KeyEvent.DOM_VK_BACK:
        case KeyEvent.DOM_VK_STOP:
        case KeyEvent.DOM_VK_PLAY:
        case KeyEvent.DOM_VK_PAUSE:
        case KeyEvent.DOM_VK_FAST_FWD:
        case KeyEvent.DOM_VK_REWIND:
        case KeyEvent.DOM_VK_CH_INCREASE: //CH+
        case KeyEvent.DOM_VK_CH_DECREASE:
            videoPlayObj.handleCommonKey(event);
            break;
        case KeyEvent.DOM_VK_RED: // cann't receive red key up event,so modify receive key down event
        case KeyEvent.DOM_VK_GREEN:
        case KeyEvent.DOM_VK_YELLOW:
        case KeyEvent.DOM_VK_BLUE:
            // 20171121 [TF518PHILTMTK04-177] EIT - Color key should be no action under PVR playback
            if (videoPlayObj.playObj.curSourceType == SourceType.Pvr) {
	            return true;
            }
            // end
            videoPlayObj.handleCommonKey(event);
            break;
		/*20171212 [TF518PHIEUMTK05-1873]PRE All_During playback press info key can't close info bar*/
		case KeyEvent.DOM_VK_EXIT:
			if (videoPlayObj.playObj.curSourceType == SourceType.Pvr){
            	if ( $("#nownext_info_page").is(':visible')) {
                    $( "#nownext_info_page" ).hide();
					return false;
            	}
            }
        	break;
        /*20171212 [TF518PHIEUMTK05-1873]End*/
				return false;
			break;
		// 20171211 [TF518PHIEUMTK05-1806] [PRE Antenna Ready] Task C2. Audio selection by audio type
		case KeyEvent.DOM_VK_MENU:
		case KeyEvent.GQUICKSETTINGS:
			if (videoPlayObj.playObj.curSourceType == SourceType.Pvr)
			    this.refreshOption = true;
			break;
		case KeyEvent.DOM_VK_EPG_PAGE_SHOW:
			if (videoPlayObj.playObj.curSourceType == SourceType.Pvr && this.refreshOption == true)
			{
			    this.refreshOption = false;
                videoPlayObj.mediaInfo = videoPlayObj.getMedia();
                videoPlayObj.getSubLanguage();
                videoPlayObj.getAudLanguage();
				if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR || get_RegionCode() == eRegionCode.PLF_OPT_REGION_LATAM)
                    videoPlayObj.swtichSub(Closed_Captions.curValue);
                else
                    videoPlayObj.swtichSub(Subtitles.curValue);
                var isAudioDescriptionMode = mtvObj.acfgGetConfigValue('g_custom_base__audio_description');
                if (isAudioDescriptionMode){
        		    if (Audio_Language.value.length > 0)
        		        Audio_Language.curValue = Audio_Language.value.length - 1;
        		    }else{
        			    Audio_Language.curValue = 0;
        		}
                playbackOperator(videoPlayObj.handle, playbackCommand.selectAud, Audio_Language.value[Audio_Language.curValue].index, Audio_Language.value[Audio_Language.curValue].dmxidx);
			}
			break;
		    // 20171211 [TF518PHIEUMTK05-1806] end
    }
    if (keynum == KeyEvent.DOM_VK_OPTION || keynum == KeyEvent.DOM_VK_LIST) {
        return false;
    }
    return true;
}

VideoPlayObj.prototype.key_dispatch = function(isup, e) {
    var keynum = e.which || e.keyCode;
    if ($('#video_player_bg').css('display') == 'none') {
        if (keynum != KeyEvent.DOM_VK_INFO) {
	    if ((keynum == KeyEvent.DOM_VK_DOWN || keynum == KeyEvent.DOM_VK_UP) && (videoPlayObj.playObj.curSourceType == SourceType.Dmr))
            {
               ;//nothing
            }
            else
            {
                videoPlayObj.showMediaBar();
	    }
        }
    } else {
        videoPlayObj.timeout();
    }

    var id = e.target.className;
    if (!id) {
        id = $(':focus').attr('class');
    }
    switch (keynum) {
        case KeyEvent.DOM_VK_RETURN:
            if (isup) {
                var fun_str = $('#video_play_ctrl_bar div[class="' + id + '"]').attr('data-key-enter');
                eval(fun_str);
            } else {
                if ($("#video_play_ctrl_bar div:nth-child(4)").is(':focus')) {
                    this.doMediaSeek(false);
                } else if ($("#video_play_ctrl_bar div:nth-child(2)").is(':focus')) {
                    this.doMediaSeek(true);
                }
            }
            break;
        case KeyEvent.DOM_VK_LEFT:
            // (videoPlayObj.playObj.curSourceType != SourceType.MultiRoom) {
            //    this.doMediaSeek(true);
            //}
            //[TF518PHILTMTK04-176] Playback PVR then press RC cursor "left" or "right" key, no response
            if (videoPlayObj.playObj.curSourceType == SourceType.Pvr) {
				if (id == "icon_fr_bg"){
					this.doMediaSeek(true);
					}
				}
			//end 
            var content = null;
            do {
                if (content)
                    id = content.attr('class');
                content = $("#video_play_ctrl_bar div[class='" + id + "']").prev();
            } while (content.length > 0 && (content.attr('tabindex') == undefined || content.css('opacity') == 0));
            if (content.length > 0) {
                content.focus();
            }
            break;
        case KeyEvent.DOM_VK_RIGHT:
            //if (videoPlayObj.playObj.curSourceType != SourceType.MultiRoom) {
            //    this.doMediaSeek(false);
            //}
            //[TF518PHILTMTK04-176] Playback PVR then press RC cursor "left" or "right" key, no response
            if (videoPlayObj.playObj.curSourceType == SourceType.Pvr) {
				if (id == "icon_ff_bg"){
					this.doMediaSeek(false);
					}
				}
			//end 
            var content = null;
            do {
                if (content)
                    id = content.attr('class');
                content = $("#video_play_ctrl_bar div[class='" + id + "']").next();
            } while (content.length > 0 && (content.attr('tabindex') == undefined || content.css('opacity') == 0));
            if (content.length > 0) {
                content.focus();
            }
            break;
        // 2K18 EAT 
	    case KeyEvent.DOM_VK_DOWN:
			if( videoPlayObj.playObj.curSourceType == SourceType.Pvr){
                //playbackOperator(this.handle, playbackCommand.seekTime, 0);
			    videoPlayObj.timeSeek(0);
                this.playpause(true);
            }
            break;
    }

}

VideoPlayObj.prototype.ctrlPlayIconStatus = function(speed) {
    var focus_idx = -1;
    switch (speed) {
        case cmpbCtrlSpeedType.Play:
            $("#video_play_ctrl_bar div:nth-child(2)").attr('class', 'icon_fr_bg');
            $("#video_play_ctrl_bar div:nth-child(4)").attr('class', 'icon_ff_bg');
            $("#video_play_ctrl_bar div:nth-child(3)").attr('class', 'icon_play_bg');
            focus_idx = 3;
            break;
        case cmpbCtrlSpeedType.Pause:
            $("#video_play_ctrl_bar div:nth-child(2)").attr('class', 'icon_fr_bg');
            $("#video_play_ctrl_bar div:nth-child(4)").attr('class', 'icon_ff_bg');
            $("#video_play_ctrl_bar div:nth-child(3)").attr('class', 'icon_play_bg pause');
            focus_idx = 3;
            break;
        case cmpbCtrlSpeedType.FF_2X:
        case cmpbCtrlSpeedType.FF_4X:
        case cmpbCtrlSpeedType.FF_8X:
        case cmpbCtrlSpeedType.FF_16X:
        case cmpbCtrlSpeedType.FF_32X:
        case cmpbCtrlSpeedType.SF_1_2X:
        case cmpbCtrlSpeedType.SF_1_4x:
            $("#video_play_ctrl_bar div:nth-child(2)").attr('class', 'icon_fr_bg');
            $("#video_play_ctrl_bar div:nth-child(3)").attr('class', 'icon_play_bg pause');
            $("#video_play_ctrl_bar div:nth-child(4)").attr('class', PlaySleep[speed]);
            focus_idx = 4;
            break;
        case cmpbCtrlSpeedType.FR_2X:
        case cmpbCtrlSpeedType.FR_4X:
        case cmpbCtrlSpeedType.FR_8X:
        case cmpbCtrlSpeedType.FR_16X:
        case cmpbCtrlSpeedType.FR_32X:
        case cmpbCtrlSpeedType.SR_1_2X:
        case cmpbCtrlSpeedType.SR_1_4x:
            $("#video_play_ctrl_bar div:nth-child(4)").attr('class', 'icon_ff_bg');
            $("#video_play_ctrl_bar div:nth-child(3)").attr('class', 'icon_play_bg pause');
            $("#video_play_ctrl_bar div:nth-child(2)").attr('class', PlaySleep[speed]);
            focus_idx = 2;
            break;
    }
    if (!this.isVideoDialogShow() && focus_idx >= 0) {
        $("#video_play_ctrl_bar div:nth-child(" + focus_idx + ")").focus();
    }
}

var TIME_SEEK_LONG = 10000;
VideoPlayObj.prototype.doMediaSeek = function(isBack) {
    if (playStatus == MmpPlayStatus.Speed) {
        console.log("doMediaSeek playStatus == MmpPlayStatus.Speed return");
        return;
    }
    if (this.startSeekTime == -1) {
        this.startSeekTime = this.currentPos;
    }
    if (isBack) {
        if (this.startSeekTime > TIME_SEEK_LONG) {
            this.startSeekTime -= TIME_SEEK_LONG;
        } else {
            this.startSeekTime = 0;
        }
    } else {
        if (this.mediaDuration - this.startSeekTime > TIME_SEEK_LONG) {
            this.startSeekTime += TIME_SEEK_LONG;
        } else {
            this.startSeekTime = this.mediaDuration;
        }
    }
    if (this.mediaSeek_t) {
        clearTimeout(this.mediaSeek_t);
        this.mediaSeek_t = null;
    }
    this.mediaSeek_t = setTimeout("videoPlayObj.timeSeek()", 500);
}

VideoPlayObj.prototype.timeSeek = function(time) {
    console.log("startSeekTime time = " + this.startSeekTime);
    if(typeof time == 'undefined'){
        time = this.startSeekTime;
    }
    var ret = playbackOperator(this.handle, playbackCommand.seekTime, time);
    if(ret == 0){
        this.timeSeekCount++;
    } else if(videoPlayObj.playObj.curSourceType == SourceType.Dmr){
        //sync status
        dmrCmpbStateNotify({"TYPE": MmpEventType.timeseek_done,"TAG": videoPlayObj.pvTag,"ARG1": 100000,"ARG2": 0,"ARG3": 0,"ARG4": 0});
    }
    console.info("DMR timeSeek ret ="+ret+"videoPlayObj.timeSeekCount = "+ this.timeSeekCount); //fix [TF3B18PHIKRMTK01-927] [MT5802_KR][OLED] The progress bar of PVR display abnormal
    this.startSeekTime = -1;
    this.mediaSeek_t = null;
}

var slowBarDispearTimeOutResult = null;
/*Deal with Color key */
VideoPlayObj.prototype.handleCommonKey = function(e) {
    console.log("VideoPlayObj this.handleCommonKey");
    if (isStopInfoDialogShow()) {
        return;
    }
    var keynum = e.which || e.keyCode;
    if (isDialogShow()) {
        if (isOptionDialogShow()) {
            option_key_dispatch(event);
        } else {
            switch (keynum) {
            case KeyEvent.DOM_VK_BACK:
                closeDialog();
                break;
            case KeyEvent.DOM_VK_INFO:
                if(videoPlayObj.playObj.curSourceType == SourceType.Dmr){
                    closeDialog();
                }
				//20171002 [TF518PHIEUMTK02-51] EIT information shall be part of any recorded event or available in the review buffer
				
				else if (videoPlayObj.playObj.curSourceType == SourceType.Pvr){
		    		if ( $("#nownext_info_page").is(':visible'))
                	{
                    	$( "#nownext_info_page" ).hide();
						 //nownextInfo_hide();
                	}
                }
		        //20171002 End		
                break;
            }
        }
        return;
    }
    if (videoPlayObj.playObj.curSourceType == SourceType.Dmr && DmrKeyList.indexOf(keynum) < 0) {
        console.log("videoPlayObj.playObj.curSourceType == SourceType.Dmr && DmrKeyList.indexOf(keynum) < 0");
        return true;
    } else if(videoPlayObj.playObj.curSourceType == SourceType.SuperShop && SuperShopKeyList.indexOf(keynum) < 0){
        return;
    }

    if ($('#video_player_bg').css('display') == 'none') {
        if (keynum != KeyEvent.DOM_VK_INFO && keynum != KeyEvent.DOM_VK_OPTION && !this.isVideoDialogShow()) {
            videoPlayObj.showMediaBar();
        }
    } else {
        videoPlayObj.timeout();
    }
    if (bottomBarKeyList.indexOf(keynum) !== -1 && keynum != KeyEvent.DOM_VK_INFO && keynum != KeyEvent.DOM_VK_OPTION) {
        this.showBottombar();
    }
    switch (keynum) {
        case KeyEvent.DOM_VK_INFO:
            if (videoPlayObj.playObj.curSourceType == SourceType.Dmr) {
                if (isDialogShowById('metedata_dialog')) {
                    closeDialog();
                    return;
                } else {
                    var content = '<tr><td><p>' + getTranslate("Title") + '</p>&nbsp' + videoPlayObj.curPlayInfo.mediaName + '</td></tr>\
                        <tr><td><p>' + getTranslate("Size") + '</p>&nbsp' + bytesToMb(videoPlayObj.curPlayInfo.mediaSize) + '</td></tr>\
                        <tr><td><p>' + getTranslate("Date") + '</p>&nbsp' + getFormatDlnaDate(videoPlayObj.curPlayInfo.mediaDate) + '</td></tr>';
                    showMetedataDialog("Movie", content);
                }
                return;
            }
            //20171002 [TF518PHIEUMTK02-51] EIT information shall be part of any recorded event or available in the review buffer
            else if (videoPlayObj.playObj.curSourceType == SourceType.Pvr)
            {
              if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR || get_RegionCode() == eRegionCode.PLF_OPT_REGION_LATAM) /*[TF518PHILTMTK02-168]2K18 LT EAT table*/
						return;
              if ( $("#nownext_info_page").is(':visible'))
                {
                    $( "#nownext_info_page" ).hide();
                    return;
                }
                else
                {
                	this.isInfoShow = !($('#video_player_bg').css('display') != 'none');
                    if (!this.isInfoShow)  {
                        this.hidebar();
                        this.hideBottombar();
                    }
                    $( "#nownext_info_page" ).show();
				    nownextInfoInit();
                }
                return;
            }
            //End
            this.isInfoShow = !($('#video_player_bg').css('display') != 'none');
            if (this.isInfoShow)  {
                this.showMediaBar();
                this.showBottombar();
            } else {
                this.hidebar();
                this.hideBottombar();
            }
            break;
        case KeyEvent.DOM_VK_RED:
            content = $('#video_play_footer').find('li')[0];
            var info = getColorKeyItemTxt(content);
            console.log("DOM_VK_RED info = " + info);
            if (info == '') {
                return;
            }
            if (this.isPlayAll) {
                setItemColorKey(content, PlayAll[1]);
                this.isPlayAll = false;
            } else {
                setItemColorKey(content, PlayAll[0]);
                this.isPlayAll = true;
            }
            break;
        case KeyEvent.DOM_VK_GREEN:
            //sort
            content = $('#video_play_footer').find('li')[1];
            var info = getColorKeyItemTxt(content);
            console.log("DOM_VK_GREEN info = " + info);
            if (info == '') {
                return;
            }
            if (!this.shuffle) {
                Shuffle.curValue = 1;
                this.shuffle = true;
                setItemColorKey(content, Shuffle.value[0]);
            } else {
                Shuffle.curValue = 0;
                this.shuffle = false;
                setItemColorKey(content, Shuffle.value[1]);
            }
            localStorage.setItem(Shuffle.name, Shuffle.curValue);
            break;
        case KeyEvent.DOM_VK_YELLOW:
            break;
        case KeyEvent.DOM_VK_BLUE:
            var text = getColorKeyItemTxt($('#video_play_footer').find('li')[3]);
            console.log('text = ' + text);
            if (text == '') {
                return;
            }
            goToHelpPage();
            break;
        case KeyEvent.DOM_VK_SUBTITLE:
            if (videoPlayObj.playObj.curSourceType != SourceType.SuperShop
            && videoPlayObj.playObj.curSourceType != SourceType.MultiRoom) {
                showOption(0);
                return __optionMenuDialog._handleKeyCode(event, true);
            }
            break;
        case KeyEvent.DOM_VK_OPTION:
            showOption(0);
            break;
        case KeyEvent.DOM_VK_BACK:
            if (isOptionDialogShow() || isDialogShow()) {
                closeDialog();
                return;
            } else if (videoPlayObj.playObj.curSourceType == SourceType.MultiRoom){
                closeDialog_MultiRoom();
                return;
            }
            if (videoPlayObj.playObj.curSourceType == SourceType.SuperShop) {
                mtvuiUtil.gotoSysPage("sys_index");
            /*20171212 [TF518PHIEUMTK05-1873]PRE All_During playback press info key can't close info bar*/
            } else if (videoPlayObj.playObj.curSourceType == SourceType.Pvr) {
            	 if ( $("#nownext_info_page").is(':visible'))
                    $( "#nownext_info_page" ).hide();
                 else
                     this.playStop();
            /*20171212 [TF518PHIEUMTK05-1873] End*/
            } else if (videoPlayObj.playObj.curSourceType != SourceType.Dmr
            && videoPlayObj.playObj.curSourceType != SourceType.MultiRoom) {
                this.playStop();
            }
            break;
        case KeyEvent.DOM_VK_STOP:
            this.playStop();
            break;
        case KeyEvent.DOM_VK_PAUSE:
            this.playpause(false);
            break;
        case KeyEvent.DOM_VK_FAST_FWD:
        case KeyEvent.DOM_VK_REWIND:
            videoPlayObj.keyOperator(keynum);

            break;
        case KeyEvent.DOM_VK_PLAY:
            if (MmpPlayStatus.Play != playStatus) {
                this.playpause(true);
            }
            break;
        case KeyEvent.DOM_VK_TRACK_NEXT:
        //case KeyEvent.DOM_VK_CH_INCREASE: //CH+
            if (videoPlayObj.playObj.curSourceType == SourceType.Usb || videoPlayObj.playObj.curSourceType == SourceType.Dmp
            || videoPlayObj.playObj.curSourceType == SourceType.MultiRoom) {
                this.playMode('next');
            }
            break;
        case KeyEvent.DOM_VK_TRACK_PREV:
            if (videoPlayObj.playObj.curSourceType == SourceType.Pvr) {
                //playbackOperator(this.handle, playbackCommand.seekTime, 0);
                videoPlayObj.timeSeek(0);
                this.playpause(true);
            } else if (videoPlayObj.playObj.curSourceType == SourceType.Usb || videoPlayObj.playObj.curSourceType == SourceType.Dmp) {
                if (videoPlayObj.currentPos > 4000) {
                    //playbackOperator(this.handle, playbackCommand.seekTime, 0);
                    videoPlayObj.timeSeek(0);
                } else {
                    this.playMode('prev');
                }
            } else if (videoPlayObj.playObj.curSourceType == SourceType.MultiRoom) {
                this.playMode('prev');
            }
            break;
		// [TF518PHILTMTK02-167] 2K18 EAT: PVR playback press RC_P- jump to start of playback
        case KeyEvent.DOM_VK_CH_DECREASE: //CH-
            if (videoPlayObj.playObj.curSourceType == SourceType.Pvr) {
                videoPlayObj.timeSeek(0);
                this.playpause(true);
            }
            break;
        case KeyEvent.DOM_VK_LIST:
            if (videoPlayObj.playObj.curSourceType == SourceType.Usb || videoPlayObj.playObj.curSourceType == SourceType.Dmp || videoPlayObj.playObj.curSourceType == SourceType.Pvr) {
                this.playStop();
            }
            break;
    }
};

VideoPlayObj.prototype.keyOperator = function(key){
/* Stephen, [TF518PHIEUMTK01-1984], Play USB video, quickly press FF key, the progress bar keeps at 0:00 and paly and pause key out of function 
					when curSpeed isn't ready yet(1 ~ 2 sec), dont receive FF or FB to avoid UI display error */
if( ((key == KeyEvent.DOM_VK_REWIND) || (key == KeyEvent.DOM_VK_FAST_FWD)) && (this.curSpeed == -1) )
{
	return;
}
    if(key == KeyEvent.DOM_VK_REWIND){
        if (this.playObj.curSourceType == SourceType.Dmp
        || this.playObj.curSourceType == SourceType.Dmr) {
            if (MmpPlayStatus.Pause == playStatus || MmpPlayStatus.SlowSpeed == playStatus) {
                playbackOperator(this.handle, playbackCommand.sr);
            } else {
                playbackOperator(this.handle, playbackCommand.fr);
            }
        } else {
            playbackOperator(this.handle, playbackCommand.fr);
        }
    } else if(key == KeyEvent.DOM_VK_FAST_FWD) {
        if (this.playObj.curSourceType == SourceType.Dmp
        || this.playObj.curSourceType == SourceType.Dmr) {
            if (MmpPlayStatus.Pause == playStatus || MmpPlayStatus.SlowSpeed == playStatus) {
                playbackOperator(this.handle, playbackCommand.sf);
            } else {
                playbackOperator(this.handle, playbackCommand.ff);
            }
        } else {
            playbackOperator(this.handle, playbackCommand.ff);
        }
    }
}

VideoPlayObj.prototype.videoPlayOperator = function(operator, isBack) {
    console.log("videoPlayOperator operator = " + operator);
    playbackOperator(this.handle, operator); // 2017013 [TF518PHIEUMTK01-1084]
};

function showOption(index) {
    closeDialog();
    // 20171211 [TF518PHIEUMTK05-1806][PRE Antenna Ready] Task C2. Audio selection by audio type
	if (videoPlayObj.playObj.curSourceType == SourceType.Pvr && this.refreshOption == true)
    {
        this.refreshOption = false;
        videoPlayObj.mediaInfo = videoPlayObj.getMedia();
        videoPlayObj.getSubLanguage();
        videoPlayObj.getAudLanguage();
        if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR || get_RegionCode() == eRegionCode.PLF_OPT_REGION_LATAM)
            videoPlayObj.swtichSub(Closed_Captions.curValue);
        else
            videoPlayObj.swtichSub(Subtitles.curValue);
    }
    // 20171211 [TF518PHIEUMTK05-1806] end
    var data;
    if (videoPlayObj.playObj.curSourceType == SourceType.Pvr
    || videoPlayObj.playObj.curSourceType == SourceType.Pus) { 
        if(get_RegionCode() == eRegionCode.PLF_OPT_REGION_LATAM) {
            Closed_Captions.value[2] = Automatic[1];
            data = PVR_LT_OPTTION_VALUE;
        } else if(get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR){ /*fix [TF3B18PHIKRMTK01-171] pvr playback option menu*/
			Closed_Captions.value[2] = Automatic[1];
            data = PVR_KR_OPTTION_VALUE;
        } else {
            Subtitles.value[2] = Automatic[0];
			data = PVR_OPTTION_VALUE;
        }
    } else if (videoPlayObj.playObj.curSourceType == SourceType.Dmp
    || videoPlayObj.playObj.curSourceType == SourceType.MultiRoom
    || videoPlayObj.playObj.curSourceType == SourceType.Dmr) {
        Subtitles.value[2] = Automatic[1];
        data = DLNA_OPTTION_VALUE;
    } else {
        Subtitles.value[2] = Automatic[1];
        if (Subtitles_Language.value.length > 0) {
            var subItem = Subtitles_Language.value[Subtitles_Language.curValue];
            if(subItem && subItem.needSetting) {
                Subtitle_Setting.value = [Font_Size, Subtitles_Color, Subtitles_Display];
                if (subItem.external) {
                    if (Subtitle_Setting.value.length < 4) {
                        Subtitle_Setting.value.push(Time_Offset);
                    }
                } else {
                    if (Subtitle_Setting.value.length >= 4) {
                        Subtitle_Setting.value.splice(3, 1);
                    }
                }
            } else {
                Subtitle_Setting.value = [];
            }

        } else {
            Subtitle_Setting.value = [];
        }
        data = MOVIE_PLAYER_OPTION_VALUE;
    }

    OPTION_DATA.value = videoPlayObj.filterOptionData(data);
    var arg = $.extend({}, {
        data: OPTION_DATA,
        callback: videoOptionNotify
    });
    showOptionDialog(arg);
}

VideoPlayObj.prototype.dmrCmdOperator = function(type, value) {
    console.log("dmrCmdOperator type = " + type + ";value = " + value);
    switch (type) {
        case DmrNotifyCmdType.pause:
            this.playpause(false);
            break;
        case DmrNotifyCmdType.resume:
            this.playpause(true);
            break;
        case DmrNotifyCmdType.stop:
            this.videoDelInit();
            //$('#btnVideoPlay')[0].className = 'music_stop_btn';
            this.closeVideoDialog();
            break;
        case DmrNotifyCmdType.seekTime:
            //playbackOperator(this.handle, playbackCommand.seekTime, value);
            videoPlayObj.timeSeek(value);
            break;
        case DmrNotifyCmdType.playSpeed:
            if(this.timeSeekCount > 0){
                console.info("DMR this.dmrSpeed = " +this.dmrSpeed +";this.timeSeekCount = " +this.timeSeekCount);
                this.dmrSpeed = value;
            } else {
                playbackOperator(this.handle, playbackCommand.setSpeed, value);
            }
            break;
        case DmrNotifyCmdType.subtitle_track:
            if (value == 0xFFFF) {
                if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR || get_RegionCode() == eRegionCode.PLF_OPT_REGION_LATAM) {
				    Closed_Captions.curValue = 0;
                    this.swtichSub(Closed_Captions.curValue);
                } else {
                    Subtitles.curValue = 0;
                    this.swtichSub(Subtitles.curValue);
                }
            } else {
                if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_LATAM) {
                    Closed_Captions.curValue = 1;
                    if (value < Caption_Service.value.length) {
                        Caption_Service.curValue = value;
                    }
                    this.swtichSub(Closed_Captions.curValue);
                } else if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR){
                    Closed_Captions.curValue = 1;
                    if (value < Caption_Service_ATSC.value.length) {
                        Caption_Service_ATSC.curValue = value;
                    }
                    this.swtichSub(Closed_Captions.curValue);
                } else {
                    Subtitles.curValue = 1;
                    if (value < Subtitles_Language.value.length) {
                        Subtitles_Language.curValue = value;
                    }
                    this.swtichSub(Subtitles.curValue);
                }
            }
            break;
    }
};

VideoPlayObj.prototype.playpause = function(isPlay) {
    console.log("playpause isPlay = " + typeof (isPlay) + ";playStatus = " + playStatus);
    if (!this.isPlayDone) {
        console.log("!this.isPlayDone return");
        return;
    }
    if (typeof (isPlay) == 'undefined') {
        if (MmpPlayStatus.Play == playStatus) {
            playbackOperator(this.handle, playbackCommand.pause);
        } else {
            playbackOperator(this.handle, playbackCommand.play);
        }
    } else if (isPlay) {
        if (MmpPlayStatus.Play != playStatus) {
            playbackOperator(this.handle, playbackCommand.play);
        }
    } else {
        if (MmpPlayStatus.Pause != playStatus) {
            playbackOperator(this.handle, playbackCommand.pause);
        }
    }
};

function playErrorVideo(playEnd) {
    if (videoPlayObj.playObj.curSourceType == SourceType.Pus || videoPlayObj.playObj.curSourceType == SourceType.Pvr) {
        videoPlayObj.playStop(playEnd);
    } else if (videoPlayObj.playObj.curSourceType == SourceType.Dmr) {
        videoPlayObj.videoDelInit();
    } else {
        if (playEnd) {
            videoPlayObj.playMode('end');
        } else {
            videoPlayObj.playMode('error');
        }

    }
}

VideoPlayObj.prototype.playStop = function(playEnd) {
    console.log("VideoPlayObj playStop");
    if (isStopInfoDialogShow()) {
        console.log("isStopInfoDialogShow() return");
        return;
    }
    removeTvServerListener(EventListenerName.volumeNotify, volumeNotifyFunc);
    if (this.playObj.curSourceType == SourceType.Pvr || this.playObj.curSourceType == SourceType.Pus
    || this.playObj.curSourceType == SourceType.Dmr || this.playObj.curSourceType == SourceType.SuperShop) {

        this.videoDelInit();
        if (this.playObj.curSourceType == SourceType.Dmr) {
            dmrPlayStop();
        } else if (this.playObj.curSourceType == SourceType.Pvr) {
            if (typeof (playEnd) == 'undefined') {
                playEnd = false;
            }
            this.setPvrFileInfo(playEnd);
            try {
                var arg = {"PARAMETER": {"VALUE": JSON.stringify({"PageID": "HTML5_UI_PAGE_PVR","Status": "Show"}),"REQUEST": "MODIFY"}};
                mtvuiUtil.setHtmlUIStatus(arg);
            } catch (err) {
                console.log(err);
            }
            /* 20180528 fix [TF3B18PHIKRMTK01-1527] Play recording video , TV don't show subtitle when set CC= on*/
            mtvObj.acfgSetConfigValue('g_custom_base__closed_captions', Closed_Captions.curValue);
		    mtvObj.acfgSetConfigValue('g_custom_base__subtitles', 0);
			/* 20180528 End */
        }
        history.go(-1);
        return;
    }
	/* Stephen ,TF518PHIEUMTK05-1995 */
	if(mtvObj.acfgGetConfigValue('g_custom_base__is_screen_mode') == 1)
	{
		mtvObj.acfgSetConfigValue('g_custom_base__exit_picture_format_adv', 0);
	}
	mtvObj.acfgSetConfigValue("g_custom_base__show_darkground",1); /* Stephen 180328,TF518PHIEUMTK01-5371 */
	localStorage.setItem("showDarkground", 1);
    this.isInfoShow = false;
    this.videoDelInit();
    this.timeout(true);
    this.timeReset();
    this.closeVideoDialog();
    contentBrowserObj.showBrowser();
};

VideoPlayObj.prototype.isVideoDialogShow = function() {
    if (isDialogShow() || isStopInfoDialogShow() || isPvrDialogShow() || isOptionDialogShow() || mtvuiUtil.isMenuShow()) {
        return true;
    } else {
        return false;
    }
};

VideoPlayObj.prototype.closeVideoDialog = function() {
    closeDialog();
    closePlaybackErrorDialog();
    closeStopInfoDialog();
    closePvrDialog();
};

VideoPlayObj.prototype.setPvrFileInfo = function(playEnd) {
    try {
        if (typeof (this.curPlayInfo.fileid) != 'undefined' && this.curPlayInfo.fileid != null) {
            mtvObj.setPvrFileInfo(this.curPlayInfo.fileid, playEnd, (playEnd ? this.mediaDuration : this.currentPos));
        }
    } catch (err) {
        console.log(err);
    }
};

VideoPlayObj.prototype.setBtnPlayClass = function() {
    console.log("setBtnPlayClass playStatus = " + playStatus);
    if (MmpPlayStatus.Play == playStatus) {
        videoPlayObj.ctrlPlayIconStatus(cmpbCtrlSpeedType.Play);
    } else {
        videoPlayObj.ctrlPlayIconStatus(cmpbCtrlSpeedType.Pause);
    }
};

VideoPlayObj.prototype.timeupdate = function() {
    var maxduration = this.mediaDuration;
    var perc;
    if (videoPlayObj.playObj.curSourceType == SourceType.MultiRoom && maxduration == 0) {
        $('#video_player_current_time').text(timeFormat(this.currentPos));
        $('#video_player_total_time').text("");
        return;
    }
    if (this.mediaSeek_t) {
        perc = 100 * this.startSeekTime / maxduration;
    } else {
        perc = 100 * this.currentPos / maxduration;
    }
    $('#video_progress').css('width', perc + '%');
    $('#video_player_current_time').text(timeFormat(this.currentPos));
    $('#video_player_total_time').text(timeFormat(maxduration));
};

VideoPlayObj.prototype.timeReset = function() {
    this.currentPos = 0;
    this.mediaDuration = 0;
    this.startSeekTime = -1;
    this.curSpeed = -1;
    this.mediaSeek_t = null;
    $('#video_player_current_time').text(timeFormat(0));
    $('#video_player_total_time').text(timeFormat(0));
    $('#video_progress').css('width', '0px');
    $('#video_player_bg').hide();
};

function videoOptionNotify(itemObj) {
    if(Subtitles == itemObj &&
        (videoPlayObj.playObj.curSourceType == SourceType.Pus || videoPlayObj.playObj.curSourceType == SourceType.Pvr)) {
        closeOptionDialog();
        mtvObj.acfgSetConfigValue('g_custom_base__subtitles', itemObj.curValue);
    /* for LT & KOR CC */
	} else if (Closed_Captions == itemObj &&
        (videoPlayObj.playObj.curSourceType == SourceType.Pus || videoPlayObj.playObj.curSourceType == SourceType.Pvr)) {
        closeOptionDialog();
        Closed_Captions.curValue = itemObj.curValue;
    } else {
        baseOptionNotify(itemObj, Time_Offset != itemObj);
    }
    videoPlayObj.switchValue(itemObj);
}

VideoPlayObj.prototype.switchValue = function(itemObj) {
    switch (itemObj.name.replace(new RegExp(" ", "g"), '_')) {
        case Subtitles.name:
        case Closed_Captions.name.replace(new RegExp(" ", "g"), '_'):
            this.swtichSub(itemObj.curValue);
            this.setDmrSubtitleInfo();
            break;
        case Character_set.name.replace(new RegExp(" ", "g"), '_'):
            playbackOperator(this.handle, playbackCommand.setSubEnc, itemObj.value[itemObj.curValue]);
            break;
        case Font_Size.name.replace(new RegExp(" ", "g"), '_'):
            playbackOperator(this.handle, playbackCommand.setSubFontSize, itemObj.value[itemObj.curValue]);
            playbackOperator(this.handle, playbackCommand.setSubEdgWidth);
            break;
        case Subtitles_Color.name.replace(new RegExp(" ", "g"), '_'):
            videoPlayObj.setSubtxtColor();
            break;
        /* LT & KR CC*/
        case Caption_Service_ATSC.name.replace(new RegExp(" ", "g"), '_'):
        case Caption_Service.name.replace(new RegExp(" ", "g"), '_'):
        case Subtitles_Language.name.replace(new RegExp(" ", "g"), '_'):
		/* Stephen TF518PHIEUMTK01-2824 */
        	if(Subtitles.curValue == 2 || Closed_Captions.curValue == 2/*LT&KR CC*/ )
        	{
				if( (lastMuteStatus) || (lastVolume == 0) )
				{
                    this.selectSub();
                    this.setDmrSubtitleInfo();
				}
				else if(  (!lastMuteStatus  && lastVolume != 0))
				{
					console.log("on during mute, but sound output, no subtitle show");
				}
        	}
	        else
	        {
	        	this.selectSub();
	        	this.setDmrSubtitleInfo();
	        }
            if(mtvObj.getCurrentCountry() == 'FRA')
            {
                videoPlayObj.swtichSub(Subtitles.curValue);
            }            
            break;
        case "Audio_language":
            //mtvObj.acfgSetConfigItemString("70516781", itemObj.value[valueIndex]);
            playbackOperator(this.handle, playbackCommand.selectAud, itemObj.value[itemObj.curValue].index, itemObj.value[itemObj.curValue].dmxidx);
            if(mtvObj.getCurrentCountry() == 'FRA')
            {
                videoPlayObj.swtichSub(Subtitles.curValue);
            }  
            break;
        case Time_Offset.name.replace(new RegExp(" ", "g"), '_'):
            playbackOperator(this.handle, playbackCommand.setSubTimeOffset, itemObj.curValue * 1000);
            break;
        case Subtitles_Display.name.replace(new RegExp(" ", "g"), '_'):
            playbackOperator(this.handle, playbackCommand.setSubDisplayRect, itemObj.value[itemObj.curValue]);
            break;
        case "Options":
            if (itemObj.value[itemObj.curValue] == "Status") {
                closeDialog();
                this.showMovieStatusDialog(Audio_Language.curValue);
            }
            break;
    }
};

VideoPlayObj.prototype.swtichSub = function(valueIndex) {
    console.log("swtichSub valueIndex = " + valueIndex);
    if (typeof (valueIndex) == 'undefined' || valueIndex == 0) {
        playbackOperator(this.handle, playbackCommand.setStopSub);
    } else if (valueIndex == 2) {
        var volValue = mtvObj.getVolumeValue();
        var mute = mtvObj.getVolumeMute();
        console.log("volValue = " + volValue + ";mute = " + mute);
        this.subAutomatic(volValue, mute);
    } else {
        this.selectSub();
    }
};

VideoPlayObj.prototype.subAutomatic = function(volValue, muteStatus) {
            var AudLanCur = Audio_Language.curValue;
            var AudLanName = Audio_Language.value[AudLanCur].name;
            var SubLangCur = Subtitles_Language.curValue;
            var SubLangName = '';
            if (Subtitles_Language.value.length > 0)
                SubLangName = Subtitles_Language.value[SubLangCur].name;
		
            if((mtvObj.getCurrentCountry() == 'FRA') && ((AudLanName != 'French')) && ((SubLangName == 'French')))
            {
                this.selectSub();
            }
            else
            {
	            if (muteStatus || (!muteStatus && volValue == 0)) {
	                this.selectSub();
	            } else {
	                playbackOperator(this.handle, playbackCommand.setStopSub);
                }
            }
};

VideoPlayObj.prototype.selectSub = function() {
    // 20171227 add for LT & KR CC
	if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR && videoPlayObj.playObj.curSourceType == SourceType.Pvr) {
        if (Closed_Captions.curValue < 0 || Caption_Service_ATSC.value.length <= 0) {
            console.info("selectCC Caption_Service_ATSC is close return");
            return;
        }
        if (Caption_Service_ATSC.value.length <= Caption_Service_ATSC.curValue) {
            Caption_Service_ATSC.curValue = 0;
        }
        console.log("selectCC curValue = " + Caption_Service_ATSC.curValue);
        if(Closed_Captions.curValue == 0){ 
            playbackOperator(this.handle, playbackCommand.setStopSub);
            return;
        }
        if(Caption_Service_ATSC.value[Caption_Service_ATSC.curValue].name == "none" || (Closed_Captions.curValue == 0)){ 
            playbackOperator(this.handle, playbackCommand.setStopSub);
            return;
        }
        //Time_Offset.curValue = 1;
        playbackOperator(this.handle, playbackCommand.selectSub, Caption_Service_ATSC.curValue);
    } else if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_LATAM && videoPlayObj.playObj.curSourceType == SourceType.Pvr){
        if (Closed_Captions.curValue < 0 || Caption_Service.value.length <= 0) {
            console.info("selectCC Caption_Service is close return");
            return;
        }
        if (Caption_Service.value.length <= Caption_Service.curValue) {
            Caption_Service.curValue = 0;
        }
        console.log("selectCC curValue = " + Caption_Service.curValue);
        if(Closed_Captions.curValue == 0){ 
            playbackOperator(this.handle, playbackCommand.setStopSub);
            return;
        }
        if(Caption_Service.value[Caption_Service.curValue].name == "none" || (Closed_Captions.curValue == 0)){ 
            playbackOperator(this.handle, playbackCommand.setStopSub);
            return;
        }
		//Time_Offset.curValue = 1;
        playbackOperator(this.handle, playbackCommand.selectSub, Caption_Service.curValue);
    } else {
    // end
        if (Subtitles.curValue < 0 || Subtitles_Language.value.length <= 0) {
            console.info("selectSub subtitle is close return");
            return;
        }
        if (Subtitles_Language.value.length <= Subtitles_Language.curValue) {
            Subtitles_Language.curValue = 0;
        }
        console.log("selectSub curValue = " + Subtitles_Language.curValue);
        /* Stephen add condition : Subtitles_Language.curValue for TF518PHIEUMTK05-724-171023 */
        if(Subtitles_Language.value[Subtitles_Language.curValue].name == "none" || (Subtitles.curValue == 0)){ 
            playbackOperator(this.handle, playbackCommand.setStopSub);
            return;
        }
        playbackOperator(this.handle, playbackCommand.selectSub, Subtitles_Language.curValue);
    }
    //Time_Offset.curValue = 0;
    this.setSubtxtColor();
    playbackOperator(this.handle, playbackCommand.setSubFontSize, Font_Size.value[Font_Size.curValue]);
    playbackOperator(this.handle, playbackCommand.setSubDisplayRect, Subtitles_Display.value[Subtitles_Display.curValue]);
    playbackOperator(this.handle, playbackCommand.setSubEdgWidth);
    playbackOperator(this.handle, playbackCommand.setSubTimeOffset, Time_Offset.curValue * 1000);

    /* Stephen 180306 TF518PHILTMTK02-1041, only happen on LT platform */
	if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_LATAM && videoPlayObj.playObj.curSourceType == SourceType.Usb)
	{
		mtvObj.acfgSetConfigValue("g_custom_base__refresh_osd3",true);
	}
};

var ConfigItem_MMP_LanguageString = 119799813;
var subPriority = {none:0,menuLang:1,secondaryLang:2,primaryLang:3};
VideoPlayObj.prototype.getSubLanguage = function() {
    Subtitles_Language.value = [];
    Subtitles_Language.curValue = -1;
    var primaryLang = mtvObj.getPrimarySubtitleLanguage();
    if (primaryLang) {
        primaryLang = mtvObj.acfgGetConfigItemString(ConfigItem_MMP_LanguageString, primaryLang);
    }
    var secondaryLang = mtvObj.getSecondarySubtitleLanguage();
    if (secondaryLang) {
        secondaryLang = mtvObj.acfgGetConfigItemString(ConfigItem_MMP_LanguageString, secondaryLang);
    }
    var menuLang = mtvObj.getGuiLanguage();
    if(menuLang){
        menuLang = mtvObj.acfgGetConfigItemString(ConfigItem_MMP_LanguageString, menuLang.ITEMS[0].TEXT);
    }
    console.log("primaryLang = " + primaryLang + ";secondaryLang = " + secondaryLang);
    if (!this.mediaInfo) {
        this.mediaInfo = this.getMedia();
    }
    if (this.mediaInfo) {
        console.log("this.mediaInfo.mediaSubTrackNum = " + this.mediaInfo.mediaSubTrackNum);
        //console.log("Number(this.mediaInfo.mediaSubTrackNum) = " + Number(this.mediaInfo.mediaSubTrackNum));
        //{value:'undefined'},{value:'undefined',icon:'../Assets/_Icons/List_Icons/subtitle_dvb_N_S.png'}
        if (Number(this.mediaInfo.mediaSubTrackNum) > 0) {
            for (var i = 0; i < Number(this.mediaInfo.mediaSubTrackNum); i++) {
                var subInfo = playbackOperator(this.handle, playbackCommand.getSubinfo, i);
                var subItem = {};
                if (subInfo) {
                    subInfo = JSON.parse(subInfo);
                    var lang = subInfo.ITEMS[0].sublang;
                    if (primaryLang == lang) {
                        subItem.priority = subPriority.primaryLang;
                    } else if (secondaryLang == lang) {
                        subItem.priority = subPriority.secondaryLang;
                    } else if(menuLang == lang){
                        subItem.priority = subPriority.menuLang;
                    } else {
                        subItem.priority = subPriority.none;
                    }
                    subItem.index = i;
                    subItem.name = lang;
                    subItem.external = subInfo.ITEMS[0].external;
                    subItem.needSetting = 1;
                    var sub_type = subInfo.ITEMS[0].subtype;
                    console.log("sub_type = " + sub_type);
                    //var isHearingImpair = mtvObj.acfgGetConfigValue('g_misc__hearing_impaired_status');
                    //[TF518PHIEUMTK01-3710] [Regression] PRE Telenet_Playback subtitles different live mode
                    var isHearingImpair = mtvObj.acfgGetConfigValue('g_custom_base__hearing_impaired');
                    var typePriority = 1;


                    switch (sub_type) {
                        case video_sub_type.dvb:
                            typePriority = 4;
                            subItem.icon = '../2K16_4K_UX_Asset/option_subtitle_language/icon_17_DVB_Text_n_24x24_px.png';
                            break;
                        case video_sub_type.ttx:
                            typePriority = 3;
                            subItem.icon = '../2K16_4K_UX_Asset/option_subtitle_language/icon_16_Text_Teletext_n_24x24_px.png';
                            break;
                        case video_sub_type.ass:
                        case video_sub_type.srt:
                            subItem.external = 1;
                            break;
                        case video_sub_type.vobsub:
                        case video_sub_type.blueray:
                        case video_sub_type.pgs:
                        case video_sub_type.sup:
                            subItem.needSetting = 0;
                            break;
                    }

                    if (subInfo.ITEMS[0].hearingImpair) {
                        subItem.icon = '../2K16_4K_UX_Asset/option_audio_language/icon_Hearing_Impaired.png';
                        if(isHearingImpair){
                            typePriority = 5;
                        } else {
                            typePriority = 2;
                        }
                    }
                    subItem.priority *= typePriority;
                    if (lang == '' || lang.toLowerCase() == 'undefined') {
                        if (this.playObj.curSourceType == SourceType.Pvr || this.playObj.curSourceType == SourceType.Pus) {
                            subItem.name = 'Undefined';
                        } else {
                            subItem.name = 'Subtitles ' + (i + 1);
                        }
                    }
                } else {
                    subItem.needSetting = 0;
                    if (this.playObj.curSourceType == SourceType.Pvr || this.playObj.curSourceType == SourceType.Pus) {
                        subItem.name = 'Undefined';
                    } else {
                        subItem.name = 'Subtitles ' + (i + 1);
                    }
                }
                Subtitles_Language.value.push(subItem);
            }
        }
    }
    if(Subtitles_Language.value.length > 0) {
        Subtitles_Language.value.sort(function(a,b){
            return b.priority-a.priority});
        if (this.playObj.curSourceType == SourceType.Pvr || this.playObj.curSourceType == SourceType.Pus) {
            Subtitles_Language.showIcon = 1;
            if(Subtitles_Language.value[0].priority > 0){
                Subtitles_Language.curValue = Subtitles_Language.value[0].index;
                Subtitles_Language.value.push({name:'none',index:Subtitles_Language.value.length,external:0,needSetting:0});
            } else {
                if(mtvObj.getCurrentCountry() != 'GBR'){
                    Subtitles_Language.curValue = Subtitles_Language.value.length;
                }
                Subtitles_Language.value.push({name:'none',index:Subtitles_Language.value.length,external:0,needSetting:0});
            }
        } else {
            Subtitles_Language.curValue = Subtitles_Language.value[0].index;
        }
        Subtitles_Language.value.sort(function(a,b){
            return a.index-b.index});
    }

    if (Subtitles_Language.curValue == -1) {
        Subtitles_Language.curValue = 0;
    }

};

VideoPlayObj.prototype.setDmrSubtitleInfo = function() {
    if (videoPlayObj.playObj.curSourceType != SourceType.Dmr) {
        return;
    }
    this.dmrSubtitleStr = null;
    for (var index in Subtitles_Language.value) {
        var expandStr = '';
        var subItem = Subtitles_Language.value[index];
        if (0 != Subtitles.curValue) {
            if (index == Subtitles_Language.curValue) {
                expandStr = '*';
            }
        }
        if (this.dmrSubtitleStr) {
            this.dmrSubtitleStr += ";" + expandStr + subItem.name;
        } else {
            this.dmrSubtitleStr = expandStr + subItem.name;
        }
    }
    if (this.dmrSubtitleStr) {
        dlnaDmrSyncPlayState(DmrStateNfyType.subtitle_info, videoPlayObj.dmrSubtitleStr);
    }
};

VideoPlayObj.prototype.showMovieStatusDialog = function(index) {
    var path = this.curPlayInfo.MEDIA_PATH;
    var type = this.curPlayInfo.MEDIA_TYPE;
    var media_info = usbObj.getContentInfoByPath(type, path);
    var title;
    var size;
    var date;
    var sound_mode;
    if (media_info.TITLE) {
        title = media_info.TITLE;
    } else {
        title = media_info.MEDIA_PATH.substring(media_info.MEDIA_PATH.lastIndexOf("/") + 1);
        title = title.substring(0, title.lastIndexOf('.'));
    }
    date = getFormatDateVideo(media_info);

    if (!this.mediaInfo) {
        this.mediaInfo = this.getMedia();
    }
    size = bytesToMb(this.mediaInfo.mediaFileSize);
    if (this.mediaInfo) {
        var audInfo = playbackOperator(this.handle, playbackCommand.getAudInfo, index);
        if (audInfo) {
            audInfo = JSON.parse(audInfo);
            sound_mode = audInfo.ITEMS[0].audenctype;
            if (sound_mode) {
                sound_mode = video_aud_full_name[sound_mode];
            } else {
                sound_mode = '';
            }
        } else {
            sound_mode = '';
        }
    }
    console.log("sound_mode = " + sound_mode);
    var content = '<tr><td style="text-overflow:ellipsis;white-space:nowrap;  overflow:hidden;"><p>' + getTranslate("Title") + '</p>&nbsp' + title + '</td></tr>\
            <tr><td><p>' + getTranslate("Size") + '</p>&nbsp' + size + '</td></tr>\
            <tr><td><p>' + getTranslate("Date") + '</p>&nbsp' + date + '</td></tr>\
            <tr><td><p>' + getTranslate("Sound mode") + '</p>' + ":&nbsp" + sound_mode + '</td></tr>'
    showMetedataDialog('Movie', content);
}

VideoPlayObj.prototype.getAudLanguage = function() {
    Audio_Language.value = [];
    if (!this.mediaInfo) {
        this.mediaInfo = this.getMedia();
    }

    if (this.mediaInfo) {
        console.log("this.mediaInfo.mediaAudTrackNum = " + this.mediaInfo.mediaAudTrackNum);
        if (Number(this.mediaInfo.mediaAudTrackNum) > 0) {
            for (var i = 0; i < Number(this.mediaInfo.mediaAudTrackNum); i++) {
                var audInfo = playbackOperator(this.handle, playbackCommand.getAudInfo, i);
                console.log("audInfo = " + audInfo);
                var audItem = {};
                if (audInfo) {
                    audInfo = JSON.parse(audInfo);
                    lang = audInfo.ITEMS[0].audlang;
                    if (this.playObj.curSourceType == SourceType.Pvr || this.playObj.curSourceType == SourceType.Pus) {
                        Audio_Language.showIcon = 1;
                        var adv_enc_first = mtvObj.acfgGetConfigValue('g_custom_base__adv_enc_first')
                        var isAudioDescriptionMode = mtvObj.acfgGetConfigValue('g_custom_base__audio_description');
                        switch (audInfo.ITEMS[0].audenctype) {
                            case video_aud_type.he_aac:
                                if(adv_enc_first){
                                   audItem.sortIndex = 1;
                                } else {
                                    audItem.sortIndex = 5;
                                }
                                break;
                            case video_aud_type.ddp: //e-ac3
                                audItem.icon = '../2K16_4K_UX_Asset/option_audio_language/icon_ac3_plus.png';
                                if(adv_enc_first){
                                   audItem.sortIndex = 2;
                                } else {
                                    audItem.sortIndex = 3;
                                }
                                break;
                            case video_aud_type.dd: //ac3
                                if(adv_enc_first){
                                   audItem.sortIndex = 3;
                                } else {
                                    audItem.sortIndex = 4;
                                }
                                audItem.icon = '../2K16_4K_UX_Asset/option_audio_language/icon_Dolby.png';
                                break;
                            case video_aud_type.aac:
                                audItem.icon = '../2K16_4K_UX_Asset/option_audio_language/icon_AAC.png';
                                if(!adv_enc_first){
                                    audItem.sortIndex = 5;
                                    break;
                                }
                            case video_aud_type.he_aac_v2:
                                if(adv_enc_first){
                                   audItem.sortIndex = 4;
                                } else {
                                    audItem.sortIndex = 2;
                                }
                                break;
                            case video_aud_type.mpeg:
                            case video_aud_type.mpeg1:
                            case video_aud_type.mpeg2:
                                if(adv_enc_first){
                                   audItem.sortIndex = 5;
                                } else {
                                   audItem.sortIndex = 1;
                                }
                                break;
                        }
                        switch (audInfo.ITEMS[0].impairtype) {
                            case video_aud_impared_type.hearing:
                                audItem.icon = '../2K16_4K_UX_Asset/option_audio_language/icon_Hearing_Impaired.png';
                                break;
                            case video_aud_impared_type.visual:
                            	if (isAudioDescriptionMode && mtvObj.getCurrentCountry() != 'FIN')
                            		audItem.icon = '../2K16_4K_UX_Asset/option_audio_language/icon_visualmixed.png';
                            	else
                                    audItem.icon = '../2K16_4K_UX_Asset/option_audio_language/icon_Visually_Impaired.png';
                                break;
                            case video_aud_impared_type.mixed:
                                audItem.icon = '../2K16_4K_UX_Asset/option_audio_language/icon_visualmixed.png';
                                break;
                            default:

                                break;
                        }

                        if (!lang) {
                            if (audInfo.ITEMS[0].reflang && audInfo.ITEMS[0].reflang > 0) {
                                audItem.reflang = audInfo.ITEMS[0].reflang;
                            }
                        }
                    } else {
                        audItem.isDualMono = this.isAudDualMono(audInfo.ITEMS[0]);
                    }
                    if (lang) {
                        lang = mtvObj.acfgGetConfigItemString(ConfigItem_MMP_LanguageString, lang);
                    }
                    if (lang == '' || lang.toLowerCase() == 'undefined' || lang.toLowerCase() == 'und') {
                        if (this.playObj.curSourceType == SourceType.Pvr || this.playObj.curSourceType == SourceType.Pus) {
                            console.log("audItem.name = 'Undefined';");
                            audItem.name = 'Undefined';
                        } else {
                            audItem.name = 'Audio language ' + (i + 1);
                        }
                    } else {
                        audItem.name = lang;
                    }


                } else {
                    if (this.playObj.curSourceType == SourceType.Pvr || this.playObj.curSourceType == SourceType.Pus) {
                        audItem.name = 'Undefined';
                    } else {
                        audItem.name = 'Audio language ' + (i + 1);
                    }
                }
                if (this.playObj.curSourceType == SourceType.Pvr
                    && isAudioDescriptionMode 
                    && mtvObj.getCurrentCountry() != 'FIN' 
                    && audInfo.ITEMS[0].impairtype == 0
                    && this.mediaInfo.mediaSubTrackNum > 0/*[TF518PHIEUMTK05-2071] Radio playback should show all audlang while AD on*/)
                {
                    //do nothing
                }
                else
				{	
                    audItem.index = i;
                    if (this.mediaInfo.mediaCurAudTrackIdx == i) {
                        Audio_Language.curValue = Audio_Language.value.length;
                    }
                    audItem.listIndex = Audio_Language.value.length;
                    Audio_Language.value.push(audItem);
                }
                if (audItem.isDualMono) {
                    audItem.dmxidx = 3;
                    audChannel1 = clone(audItem);
                    audChannel1.name += ' left';
                    audChannel1.dmxidx = 1;
                    audChannel1.listIndex = Audio_Language.value.length;
                    audChannel2 = clone(audItem);
                    audChannel2.name += ' right';
                    audChannel2.dmxidx = 2;
                    audChannel2.listIndex = Audio_Language.value.length+1;
                    Audio_Language.value.push(audChannel1);
                    Audio_Language.value.push(audChannel2);
                } else {
                    audItem.dmxidx = 0;
                }
            }
        }
    }
    if (this.playObj.curSourceType == SourceType.Pvr || this.playObj.curSourceType == SourceType.Pus) {
        for (var index in Audio_Language.value) {
            if (Audio_Language.value[index].reflang) {
                var ref1 = Audio_Language.value[index].reflang & 0xFF;
                var ref2 = (Audio_Language.value[index].reflang & 0xFF00) >> 8;
                console.log("index" + index + ";ref1 = " + ref1 + ";ref2 = " + ref2);
                Audio_Language.value[index].value = Audio_Language.value[ref1].value + "+" + Audio_Language.value[ref2].value;
            }

        }
        /*
        Audio_Language.value.sort(function(a,b){
            return a.sortIndex-b.sortIndex});
        Audio_Language.curValue = Audio_Language.value[0].listIndex;
        Audio_Language.value.sort(function(a,b){
            return a.listIndex-b.listIndex});
            */
    }
    if (Audio_Language.curValue >= Audio_Language.value.length) {
        Audio_Language.curValue = 0;
    }
};

VideoPlayObj.prototype.isAudDualMono = function(audObj) {
    if (audObj.audenctype == video_aud_type.dd ||
    audObj.audenctype == video_aud_type.ddp ||
    audObj.audenctype == video_aud_type.he_aac ||
    audObj.audenctype == video_aud_type.he_aac_v2 ||
    audObj.audenctype == video_aud_type.aac) {
        if (audObj.audchnum == 'DUAL_MONO') {
            return true;
        }
    }
    return false;
};

VideoPlayObj.prototype.getMedia = function() {
    var itemInfo = playbackOperator(this.handle, playbackCommand.getMediaInfo);
    if (itemInfo) {
        return JSON.parse(itemInfo).ITEMS[0];
    } else {
        return null;
    }
};

VideoPlayObj.prototype.getMediaDuration = function() {
    if (this.mediaInfo) {
        return this.mediaInfo.mediaDuration;
    }
}

VideoPlayObj.prototype.filterOptionData = function(option_attr) {
    var data = [];
    for (index in option_attr) {
        if (typeof option_attr[index] == 'string') {
            data.push(option_attr[index]);
        } else if (option_attr[index].value.length > 0) {
            data.push(option_attr[index]);
        }
    }
    return data;
}

VideoPlayObj.prototype.initOption = function(option_attr) {
    for (index in option_attr) {
        if (typeof option_attr[index] == 'string') {
            continue;
        }
        if (option_attr[index].hasSubmenu) {
            this.initOption(option_attr[index].value);
        } else {
            var curValue;
            var id = option_attr[index].name.replace(' ', '_');
            curValue = localStorage.getItem(id);
            console.log("id = " + id + ";curValue =" + curValue);
            if (curValue) {
                if (curValue >= option_attr[index].value.length) {
                    curValue = 0;
                    localStorage.setItem(id, curValue);
                } else if (curValue < 0) {
                    curValue = 0;
                    localStorage.setItem(id, curValue);
                }
                option_attr[index].curValue = parseInt(curValue);
            } else {
                curValue = option_attr[index].curValue;
            }
        }
    //switchValue(id, curValue, index);
    }
    if (this.playObj.curSourceType == SourceType.Pus || this.playObj.curSourceType == SourceType.Pvr) {
        if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_LATAM || get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR) {
            Closed_Captions.curValue = mtvObj.acfgGetConfigValue('g_custom_base__closed_captions');
        } else {
        	// 20180103 fix [TF518PHIEUMTK05-2119] start
            if (this.curPlayInfo.subtitleStatus !=  mtvObj.acfgGetConfigValue('g_custom_base__subtitles'))
            	 mtvObj.acfgSetConfigValue('g_custom_base__subtitles', this.curPlayInfo.subtitleStatus);
            // 20180103 end
            Subtitles.curValue = mtvObj.acfgGetConfigValue('g_custom_base__subtitles');
        }
    }
};

VideoPlayObj.prototype.initBottombar = function() {
    var data = playerColorKeyData;
    if (this.playObj.curSourceType == SourceType.Pus || this.playObj.curSourceType == SourceType.Pvr) {
        playerColorKeyData[0] = "";
        playerColorKeyData[1] = "";
        playerColorKeyData[3] = "";
    } else if (this.playObj.curSourceType == SourceType.MultiRoom) {
        playerColorKeyData[0] = "";
        playerColorKeyData[1] = "";
    } else {
        if (!this.isPlayAll) {
            playerColorKeyData[0] = PlayAll[1];
        } else {
            playerColorKeyData[0] = PlayAll[0];
        }
        if (!this.shuffle) {
            playerColorKeyData[1] = Shuffle.value[1];
        } else {
            playerColorKeyData[1] = Shuffle.value[0];
        }
    }
    var children = $('#video_play_footer').find('li');
    for (var i = 0; i < children.length; i++) {
        $(children[i]).find('span').html(getTranslate(data[i]));
    }
}

VideoPlayObj.prototype.videoPlayNotify = function(videoNotify) {
    if (this.pvTag != videoNotify.TAG) {
        return;
    }
    var arg1 = Number(videoNotify.ARG1);
    switch (Number(videoNotify.TYPE)) {
        case MmpEventType.total_time_update:
            this.mediaDuration = arg1;
            break;
        case MmpEventType.icur_time_update:
            videoPlayObj.currentPos = arg1;
            try {
                this.timeupdate(arg1);
            } catch (e) {
            }
            break;
        case MmpEventType.eos:
            console.log("MmpEventType.eos");
            if (this.currentPos < this.mediaDuration) {
                this.currentPos = this.mediaDuration;
                try {
                    this.timeupdate(this.currentPos);
                } catch (e) {
                }
            }
            setTimeout(function() {
                playErrorVideo(true);
            });
            break;
        case MmpEventType.play_done:
            mtvuiUtil.doPageMute(false);//20180213 TV no audio output when close pvr by other function
            videoPlayObj.isPlayDone = true;
            setTimeout(function() {
                videoPlayObj.mediaInfo = videoPlayObj.getMedia();
                videoPlayObj.getSubLanguage();
                videoPlayObj.getAudLanguage();
                if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR || get_RegionCode() == eRegionCode.PLF_OPT_REGION_LATAM)
                {
			/* Stephen 180111 TF3B18PHIKRMTK01-275 USB Mode play with subtitle video, DUT without subtitles shown */
	                if(videoPlayObj.playObj.curSourceType == SourceType.Pvr)
			        {
		        	    mtvObj.acfgSetConfigValue('g_custom_base__closed_captions', 0);
		        	    mtvObj.acfgSetConfigValue('g_custom_base__subtitles', Closed_Captions.curValue);
		        	    videoPlayObj.swtichSub(Closed_Captions.curValue);
	                }
	                else if (get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR)
			        {
			        	var curValue = localStorage.getItem('Character_set');
			        	if(!curValue)
			        	{
			        		playbackOperator(videoPlayObj.handle, playbackCommand.setSubEnc, "Korean"); /* 180517 [TF518PHIAPMTK02-16] CCR-22_2018 Korea MMP ANSI code */
							localStorage.setItem('Character_set', Character_set.curValue);
			        	}
						else
			        	{
							playbackOperator(videoPlayObj.handle, playbackCommand.setSubEnc, Character_set.value[Character_set.curValue]);
			        	}
				        videoPlayObj.swtichSub(Subtitles.curValue);
	            	}
	            	 else
			        {
				        videoPlayObj.swtichSub(Subtitles.curValue);
	            	}
            	
                }
                else
                    videoPlayObj.swtichSub(Subtitles.curValue);
                videoPlayObj.setDmrSubtitleInfo();
                var eotfValue = mtvObj.acfgGetConfigValue('g_misc__mmp_hdr_eotf');
                if(eotfValue == 16 || eotfValue == 18){
                	if (mtvObj.acfgGetConfigValue("g_custom_base_opt__is_hdr_support")) /* 20180316 Louis.Chiang fix [TF518PHIEUMTK01_QPL-76] [CZ]HDR signal notification message appears when played USB video file with HDR but this TV doesn't support HDR */
                	{
                    	showPlaybackErrorDialog('MAIN_MSG_HDR_SIGNAL_DETECTED');
                	}
                }
                if (playStatus != MmpPlayStatus.Play) {
                    videoPlayObj.videoPlayNotify({"TYPE": MmpEventType.speed_update,"TAG": videoPlayObj.pvTag,"ARG1": 100000,"ARG2": 0,"ARG3": 0,"ARG4": 0});
                } else {
                    videoPlayObj.curSpeed = 100000;
                }
            });
            break;
        case MmpEventType.timeseek_done:
            if(videoPlayObj.timeSeekCount > 0){
                videoPlayObj.timeSeekCount--;
            }
            console.info("DMR videoPlayObj.timeSeekCount = " + videoPlayObj.timeSeekCount +";videoPlayObj.dmrSpeed = " +videoPlayObj.dmrSpeed);
            if(videoPlayObj.playObj.curSourceType == SourceType.Dmr && videoPlayObj.dmrSpeed != -1){
                if(videoPlayObj.timeSeekCount == 0){
                    console.info("DMR videoPlayObj.timeSeekCount == 0 && videoPlayObj.dmrSpeed != 0");
                    playbackOperator(videoPlayObj.handle, playbackCommand.setSpeed, videoPlayObj.dmrSpeed);
                }
            }
            break;
        case MmpEventType.speed_update:
            if (100000 == arg1) {
                playStatus = MmpPlayStatus.Play;
            } else if (0 == arg1) {
                playStatus = MmpPlayStatus.Pause;
            } else if (400 == arg1 || 200 == arg1 || -400 == arg1 || -200 == arg1) {
                playStatus = MmpPlayStatus.SlowSpeed;
            } else {
                playStatus = MmpPlayStatus.Speed;
            }
            if (videoPlayObj.curSpeed != arg1) {
                videoPlayObj.ctrlPlayIconStatus(arg1);
            }
            videoPlayObj.curSpeed = arg1;
            break;
        case MmpEventType.playback_error:
            if (this.iscamcardmissing == true)
        	{
        		this.iscamcardmissing = false;
        		return;
        	}
            if (arg1 == PlaybackErrorType.video_unplayable) {
                arg1 = PlaybackErrorType.video_codec_not_support;
            }

            if(videoPlayObj.playObj.curSourceType == SourceType.SuperShop && arg1 == PlaybackErrorType.video_codec_not_support){
                showPlaybackErrorDialog(PlaybackErrorInfo[arg1], playErrorVideo);
            } else if (arg1 == PlaybackErrorType.drm_not_support || arg1 == PlaybackErrorType.no_audio_video_svc
                || arg1 == PlaybackErrorType.file_not_support || arg1 == PlaybackErrorType.media_lost || arg1 == PlaybackErrorType.cam_card_miss ) {
                if (videoPlayObj.playObj.curSourceType == SourceType.Dmr) {
                    showPlaybackErrorDialog(PlaybackErrorInfo[arg1], null);
                    videoPlayObj.videoDelInit();
                } else if (this.isPlayAll == false && (arg1 == PlaybackErrorType.no_audio_video_svc || arg1 == PlaybackErrorType.media_lost) && videoPlayObj.playObj.curSourceType == SourceType.Usb)
                  {	/* Stephen 180220 add for user play unplayable file will jump to root after 3sec */
					if(this.g_errorMsgTimeout)
                	{
                		clearTimeout(this.g_errorMsgTimeout);
                		this.g_errorMsgTimeout = null;
                	}
					showPlaybackErrorDialog(PlaybackErrorInfo[arg1], null);
					this.g_errorMsgTimeout = setTimeout(function(){
						videoPlayObj.playStop();
						videoPlayObj.videoDelInit();
						},3000)
                  }
                 else {
                    showPlaybackErrorDialog(PlaybackErrorInfo[arg1], playErrorVideo);
                }
            } else {
                showPlaybackErrorDialog(PlaybackErrorInfo[arg1], null);
                return;
            }
            break;
        case MmpEventType.rating_blocked:
            console.log("MmpEventType.rating_blocked");
        case MmpEventType.channel_blocked:
            console.log("MmpEventType.channel_blocked");
            showPvrChannelBlockedDialog('pvrRatingBlockedBtnNotify');
            break;
        case MmpEventType.prepare_done:
            console.log("prepare_done");
            mtvuiUtil.doPageMute(false);//20180213 TV no audio output when close pvr by other function
            this.mediaInfo = this.getMedia();
            this.mediaDuration = this.getMediaDuration();

            if (this.playObj.curSourceType == SourceType.MultiRoom) {
                var ratingInfo = playbackOperator(this.handle, playbackCommand.getRatingInfo);
                if (ratingInfo) {
                    showPvrChannelBlockedDialog('multiRoomRatingBtnNotify');
                } else {
                    this.cmdPlay();
                }
                return;
            }

            var stopinfo = playbackStopInfo(this.handle);
            if (1 == stopinfo) {
                if (this.playObj.curSourceType == SourceType.SuperShop
                || this.playObj.curSourceType == SourceType.Pus) {
                    stopInfoBtnNotify(1);
                } else {
                    showStopInfoDialog('stopInfoBtnNotify');
                }
            } else {
                this.cmdPlay();
            }
            break;
        // 20171127 fix TF518PHIEUMTK01-3283
        case MmpEventType.cam_card_missing:
            console.log("cam_card_missing");
            this.iscamcardmissing = true;
            arg1 = PlaybackErrorType.cam_card_miss;
            showPlaybackErrorDialog(PlaybackErrorInfo[arg1], null);
            break;
    }
    if (this.playObj.curSourceType == SourceType.Dmr) {
        dmrCmpbStateNotify(videoNotify);
    } else if (this.playObj.curSourceType == SourceType.Pus) {
        pusCmpbStateNotify(videoNotify);
    }
};

VideoPlayObj.prototype.setSubtxtColor = function() {
    playbackOperator(videoPlayObj.handle, playbackCommand.setSubtxtColor, Subtitles_Color.value[Subtitles_Color.curValue]);
    if (Subtitles_Color.curValue == 5) {
        playbackOperator(videoPlayObj.handle, playbackCommand.setSubEdgColor, 1);
    } else {
        playbackOperator(videoPlayObj.handle, playbackCommand.setSubEdgColor);
    }
}

function pvrRatingBlockedBtnNotify(btn_content) {
    console.log('pvrRatingBlockedBtnNotify btn_content = ' + btn_content);
    switch (btn_content) {
        case 1:
            console.log('pvrRatingBlockedPinText = ' + pvrRatingBlockedPinText);
            if (pvrRatingBlockedPinText == getPinCode()) {
                closePvrDialog();
                playbackOperator(videoPlayObj.handle, playbackCommand.setUnlockRating);
            } else {
                $('#pin_code_error').show();
                clearPvrRatingBlockedPin();
            }
            break;
        case 2:
        case 3:
            videoPlayObj.playStop();
            break;
        case 4:
            clearPvrRatingBlockedPin();
            break;
        case 5:
            if (pvrRatingBlockedPinText == getPinCode()) {
                closePvrDialog();
                playbackOperator(videoPlayObj.handle, playbackCommand.setUnlockRating);
            } else {
                $('#pvr_enter_pincode_title').html(getTranslate('PWD_STATE_2'));
                clearPvrRatingBlockedPin();
            }
            break;
    }
}
;

function multiRoomRatingBtnNotify(btn_content) {
    console.log('multiRoomRatingBtnNotify btn_content = ' + btn_content);
    switch (btn_content) {
        case 3:
            videoPlayObj.playStop();
            break;
        case 4:
            clearPvrRatingBlockedPin();
            break;
        case 5:
            if (pvrRatingBlockedPinText == getPinCode()) {
                closePvrDialog();
                videoPlayObj.cmdPlay();
                playbackOperator(videoPlayObj.handle, playbackCommand.setUnlockRating);
            } else {
                $('#pvr_enter_pincode_title').html(getTranslate('PWD_STATE_2'));
                clearPvrRatingBlockedPin();
            }
            break;
    }
}

VideoPlayObj.prototype.videoDelInit = function() {
    if (this.handle) {
        playbackOperator(this.handle, playbackCommand.stop);
        playbackDeinit(this.handle);
        this.handle = undefined;
        this.pvTag = null;
        this.dmrSpeed = -1;
        this.timeSeekCount = 0;
    }
}

VideoPlayObj.prototype.playback = function(isAuto) {
    try {
        var infoObj;
        var fileName;
        this.timeReset();
        this.isPlayDone = false;
        switch (this.playObj.curSourceType) {
            case SourceType.Pvr:
            case SourceType.Pus:
                infoObj = {mediaPath: this.curPlayInfo.mediaPath,bMode: 1};
                if (this.curPlayInfo.title) {
                    fileName = this.curPlayInfo.title;
                } else {
                    path = this.curPlayInfo.mediaPath;
                    fileName = path.substring(path.lastIndexOf('/') + 1);
                }
                break;
            case SourceType.Dmp:
                if(this.curPlayInfo.mediaType != 3) {
                    this.closeVideoDialog();
                    this.isInfoShow = false;
                    contentBrowserObj.startPlayback(this.playObj, this.curPlayInfo, this.isPlayAll);
                    return;
                }
            case SourceType.MultiRoom:
                infoObj = {mediaPath: this.curPlayInfo.mediaInfo.fileObjId,bMode: 2,info: this.curPlayInfo.devId};
                fileName = this.curPlayInfo.mediaInfo.mediaName;
                break;
            case SourceType.Dmr:
                infoObj = {mediaPath: this.curPlayInfo.URL,bMode: 2,protocal: this.curPlayInfo.PROTOCOL_INFO};
                fileName = this.curPlayInfo.mediaName;
                break;
            default:
                path = this.curPlayInfo.MEDIA_PATH;
                infoObj = {mediaPath: path,bMode: 1};
                fileName = path.substring(path.lastIndexOf('/') + 1);
                break;
        }
        playStatus = MmpPlayStatus.Pause;
        $('#video_player_title').html(fileName);
        var ret = playbackInitWithPath(infoObj);
        if (ret == null || ret.STATUS != 0) {
            if (ret) {
                this.handle = ret.HANDLE;
                this.pvTag = ret.PVTAG;
            } else {
                this.pvTag = -1;
            }
            this.videoPlayNotify({"TYPE": MmpEventType.playback_error,"TAG": this.pvTag,"ARG1": 109,"ARG2": 0,"ARG3": 0,"ARG4": 0});
            return;
        }
        this.handle = ret.HANDLE;
        this.pvTag = ret.PVTAG;
        /*
        this.mediaInfo = this.getMedia();
        this.mediaDuration = this.getMediaDuration();

        if (this.playObj.curSourceType == SourceType.MultiRoom) {
            var ratingInfo = playbackOperator(this.handle, playbackCommand.getRatingInfo);
            if (ratingInfo) {
                showPvrChannelBlockedDialog('multiRoomRatingBtnNotify');
            } else {
                this.cmdPlay();
            }
            return;
        }

        var stopinfo = playbackStopInfo(this.handle);
        if (1 == stopinfo) {
            if (this.playObj.curSourceType == SourceType.SuperShop
            || this.playObj.curSourceType == SourceType.Pus
            || (isAuto && this.isPlayAll)) {
                stopInfoBtnNotify(1);
            } else {
                showStopInfoDialog('stopInfoBtnNotify');
            }
        } else {
            this.cmdPlay();
        }
        */
    } catch (e) {
        console.log(e);
    }
};

VideoPlayObj.prototype.cmdPlay = function() {
    mtvObj.acfgSetConfigValue("g_custom_base__show_darkground",0);/* Stephen 180328,TF518PHIEUMTK01-5371 */
	localStorage.setItem("showDarkground", 0);
    waitLoading(false);
    this.showMediaBar();
    playbackOperator(this.handle, playbackCommand.setDisplayRect);
    var ret = playbackOperator(this.handle, playbackCommand.play);
    if (ret != 0) {
        playStatus = MmpPlayStatus.Pause;
        this.videoPlayNotify({"TYPE": MmpEventType.playback_error,"TAG": this.pvTag,"ARG1": 109,"ARG2": 0,"ARG3": 0,"ARG4": 0});
    } else {
        this.setBtnPlayClass();
    }
}

function stopInfoBtnNotify(btn_index) {
    console.log('stopInfoBtnNotify btn_index = ' + btn_index);
    closeStopInfoDialog();
    playbackOperator(videoPlayObj.handle, playbackCommand.setStopInfo, (btn_index == 1) ? 0 : 1);
    videoPlayObj.cmdPlay();
}

var lastVolume = -1;
var lastMuteStatus = -1;

var volumeNotifyFunc = function(jsonStr) {
    if (Subtitles.curValue != 2 && Closed_Captions.curValue !=2) {
        return;
    }
    var volumeNotifyObj = JSON.parse(jsonStr);
    for (index in volumeNotifyObj.ITEMS) {
        var volumeNotifyItem = volumeNotifyObj.ITEMS[index];

        if ((volumeNotifyItem.volValue > 0 && lastVolume <= 0) || (volumeNotifyItem.volValue <= 0 && lastVolume > 0) || (lastMuteStatus !== volumeNotifyItem.muteStatus)) {
            videoPlayObj.subAutomatic(volumeNotifyItem.volValue, volumeNotifyItem.muteStatus);
        }
        lastVolume = volumeNotifyItem.volValue;
        lastMuteStatus = volumeNotifyItem.muteStatus;
    }
};

VideoPlayObj.prototype.init = function(obj, sourceType, isPlayAll) {
    var subTemp = 0;
    try {
        addTvServerListener(EventListenerName.volumeNotify, volumeNotifyFunc);
        mtvObj.acfgSetConfigItemValue(stvapi_config.mmp_play_state, icl_mmp_play_status.video);
        mtvObj.addEventListener('ConfigUpdateNotify', function(status)
        {
            var obj = JSON.parse(status);
            if(obj.ITEMS[0].ID == 13 ) /*ACFG_MSG_ENTER_EDFU  (13) */
            {   
                if(obj.ITEMS[0].ARG1 == "1")
                {
                    subTemp = Subtitles.curValue;
                    Subtitles.curValue = 0;
                    playbackOperator(videoPlayObj.handle, playbackCommand.setStopSub);
                }
                else if(obj.ITEMS[0].ARG1 == "0")
                {
                    Subtitles.curValue = subTemp;
                    videoPlayObj.swtichSub(Subtitles.curValue);
                }
               
            }
           
        });

        this.timeReset();
        if (sourceType == SourceType.MultiRoom || (typeof (isPlayAll) == 'undefined')) {
            this.isPlayAll = false;
        } else {
            this.isPlayAll = isPlayAll;
        }
        var curValue = localStorage.getItem('Shuffle');
        if (sourceType == SourceType.MultiRoom || !parseInt(curValue)) {
            this.shuffle = false;
        } else {
            this.shuffle = true;
        }
        if (sourceType == SourceType.Dmr || sourceType == SourceType.Pvr || sourceType == SourceType.Pus) {
            $('#video_play_ctrl_bar .icon_prev_bg').css('opacity', 0);
            $('#video_play_ctrl_bar .icon_next_bg').css('opacity', 0);
            this.playObj = {curSourceType: sourceType};
            this.curPlayInfo = obj;
        } else {
            this.playObj = obj;
            this.curPlayInfo = this.playObj.getPlayInfo({mediaType: 3});
		if (curBrowserType == BrowserType.Usb) { // Randy.xiao add for CUL event id 8
			var media_type_path_of_video = this.curPlayInfo.MEDIA_TYPE+"_0_"+this.curPlayInfo.MEDIA_PATH; // Randy.xiao add for CUL event id 8
			mtvObj.acfgSetConfigString("g_content_browser",media_type_path_of_video); // Randy.xiao add for CUL event id 8
		}
		else
		{
			var media_type_path_of_video = this.curPlayInfo.mediaType+"_1_"+this.curPlayInfo.mediaInfo.thumbnailLocalPath; // Randy.xiao add for CUL event id 8
			mtvObj.acfgSetConfigString("g_content_browser",media_type_path_of_video); // Randy.xiao add for CUL event id 8
		}
        }
        this.initOption(MOVIE_PLAYER_OPTION_VALUE);
        this.initBottombar();
        waitLoading(true);
        setTimeout(function() {
            videoPlayObj.playback();
        }, 100);
    } catch (e) {
        console.log(e.message);
    }

};

VideoPlayObj.prototype.playMode = function(action) {
    console.log("VideoPlayObj playMode");
    var temp;
    if (action == 'prev') {
        temp = this.playObj.getPlayInfo({isNext: false,isRepeat: this.getRepeat(),isShuffle: false,isPlayAll: this.isPlayAll,mediaType: 3});
        if (this.isPlayAll || !this.getRepeat() || temp) {
            this.curPlayInfo = temp;
        }
    } else if (action == 'next') {
        this.curPlayInfo = this.playObj.getPlayInfo({isNext: true,isRepeat: this.getRepeat(),isShuffle: this.shuffle,mediaType: 3});
    } else if (action == 'end' || action == 'error') {
        if (this.playObj.curSourceType == SourceType.SuperShop) {
            temp = this.playObj.getPlayInfo({isNext: true,isRepeat: true,mediaType: 3});
            if(action == 'error' && this.curPlayInfo == temp){
                this.curPlayInfo = null;
            } else {
                this.curPlayInfo = temp;
            }
        } else {
            console.log("this.isPlayAll = " + this.isPlayAll + ";this.getRepeat() = " + this.getRepeat());
            if (this.isPlayAll) {
                temp = this.playObj.getPlayInfo({isNext: true,isRepeat: this.getRepeat(),isShuffle: this.shuffle,mediaType: 3});
                if (action == 'error' && this.getRepeat() && this.curPlayInfo == temp) {
                    this.curPlayInfo = null;
                } else {
                    this.curPlayInfo = temp;
                }
            } else if (!this.getRepeat()) {
                this.curPlayInfo = null;
            } else {
                if (action == 'error') {
                    this.curPlayInfo = null;
                }
            }
        }
    }
    console.log("this.curPlayInfo = " + JSON.stringify(this.curPlayInfo));
    if (!this.curPlayInfo) {
        this.playStop();
        return;
    }
    this.videoDelInit();
    this.timeReset();
    this.closeVideoDialog();
    setTimeout("videoPlayObj.playback(" + (action == 'end' || action == 'error') + ")", 100);
};

VideoPlayObj.prototype.setSubtitleShowHide = function(){
    if(this.handle){
        var isShow = mtvObj.acfgGetConfigValue('g_misc__dvb_subtitle_enabled');
        playbackOperator(this.handle, playbackCommand.setSubtitleShowHide, (isShow == 0) ? 0 : 1);
    }
};

var videoPlayObj = new VideoPlayObj();
