var MusicPlayObj = function() {
    this.curDisplayMode = musicDisplayMode.none;
    this.startSeekTime = -1;
    this.mediaSeek_t = null ;
    this.currentPos;
    this.mediaDuration;
    this.musicHandle;
    this.isPlayAll = false;
    this.shuffle = false;
    this.playObj;
    this.curPlayInfo;
    this.isPlayDone;
    this.activeContent;
    this.curSpeed;
    this.isInfoShow = false;
}
;
MusicPlayObj.prototype.getRepeat = function() {
    var repeat = Repeat;
    if (repeat.curValue == 0) {
        return false;
    } else {
        return true;
    }
}
;
MusicPlayObj.prototype.audioPlayNotify = function(itemObj) {
    if (this.pvTag != itemObj.TAG) {
        console.log("this.pvTag = " + this.pvTag + ";itemObj = " + JSON.stringify(itemObj));
        return;
    }
    var arg1 = Number(itemObj.ARG1);
    switch (Number(itemObj.TYPE)) {
    case MmpEventType.total_time_update:
        this.mediaDuration = Number(itemObj.ARG1);
        break;
    case MmpEventType.icur_time_update:
        /*if(this.curSpeed >= cmpbCtrlSpeedType.Play){
                if(musicPlayObj.currentPos <= itemObj.ARG1)
                    musicPlayObj.currentPos = Number(itemObj.ARG1);
            } else {
                if(musicPlayObj.currentPos >= itemObj.ARG1)
                    musicPlayObj.currentPos = Number(itemObj.ARG1);
            }*/
        musicPlayObj.currentPos = Number(itemObj.ARG1);
        try {
            this.timeupdate();
        } catch (e) {}
        break;
    case MmpEventType.eos:
        if (musicPlayObj.playObj.curSourceType == SourceType.Dmr) {
            this.stopPlay();
        } else {
            console.log("eos true ");
            this.playMusicMode('ended');
        }
        break;
    case MmpEventType.play_done:
        musicPlayObj.isPlayDone = true;
        if (playStatus != MmpPlayStatus.Play) {
            musicPlayObj.audioPlayNotify({
                "TYPE": MmpEventType.speed_update,
                "TAG": musicPlayObj.pvTag,
                "ARG1": 100000,
                "ARG2": 0,
                "ARG3": 0,
                "ARG4": 0
            });
        } else {
            musicPlayObj.curSpeed = 100000;
        }
        break;
    case MmpEventType.speed_update:
        //document.querySelector('#music_play_btn').className = PlaySleep[arg1];
        if (100000 == arg1) {
            playStatus = MmpPlayStatus.Play;
        } else if (0 == arg1) {
            playStatus = MmpPlayStatus.Pause;
        } else if (400 == arg1 || 200 == arg1 || -400 == arg1 || -200 == arg1) {
            playStatus = MmpPlayStatus.SlowSpeed;
        } else {
            playStatus = MmpPlayStatus.Speed;
        }
        var needRet = true;
        if (musicPlayObj.curSpeed != arg1) {
            needRet = false;
            musicPlayObj.ctrlPlayIconStatus(Number(itemObj.ARG1));
        }
        musicPlayObj.curSpeed = arg1;
        if (needRet) {
            return;
        }
        break;
    case MmpEventType.playback_error:
        if (arg1 == PlaybackErrorType.video_unplayable) {
            arg1 = PlaybackErrorType.video_codec_not_support;
        }
        if (arg1 == PlaybackErrorType.drm_not_support || arg1 == PlaybackErrorType.audio_unplayable || arg1 == PlaybackErrorType.no_audio_video_svc || arg1 == PlaybackErrorType.file_not_support || arg1 == PlaybackErrorType.media_lost) {
            if (musicPlayObj.playObj.curSourceType == SourceType.Dmr) {
                showPlaybackErrorDialog(PlaybackErrorInfo[Number(itemObj.ARG1)], null );
                musicPlayObj.stopPlay();
            } else {
                showPlaybackErrorDialog(PlaybackErrorInfo[arg1], playErrorAudio);
            }
        } else {
            showPlaybackErrorDialog(PlaybackErrorInfo[arg1], null );
            return;
        }
        break;
    case MmpEventType.thumbnail_ready:
        $('#music_play_thumbnail').css('width', '100%').css('height', '100%').attr('src', encodeURI("file://" + itemObj.ARG1));
        break;
    case MmpEventType.mp3cover_eeror:
    case MmpEventType.thumbnail_error:
        $('#music_play_thumbnail').css('width', '100%').css('height', '100%').attr('src', "");
        break;
    case MmpEventType.prepare_done:
        if (this.playObj.curSourceType == SourceType.Usb) {
            playbackOperator(this.musicHandle, playbackCommand.getMp3CoverAsync, {
                width: 480,
                height: 480
            });
        }
        this.cmdPlay();
        if (this.curDisplayMode >= musicDisplayMode.simplePlay) {
            $('#music_play_ctrl_bar .icon_play_bg').focus();
        }
        break;
    }
    if (musicPlayObj.playObj.curSourceType == SourceType.Dmr) {
        dmrCmpbStateNotify(itemObj);
    }
}
;
function playErrorAudio() {
    if (musicPlayObj.playObj.curSourceType == SourceType.Dmr) {
        musicPlayObj.stopPlay();
    } else {
        musicPlayObj.playMusicMode('error');
    }
}
MusicPlayObj.prototype.isMusicDialogShow = function() {
    if (isDialogShow() || isOptionDialogShow() || mtvuiUtil.isMenuShow()) {
        return true;
    } else {
        return false;
    }
}
;
MusicPlayObj.prototype.closeMusicDialog = function() {
    closePlaybackErrorDialog();
    closeDialog();
}
;
MusicPlayObj.prototype.stopMusic = function(notFocus) {
    if (musicPlayObj.curDisplayMode != musicDisplayMode.none) {
        if (musicPlayObj.playObj.curSourceType == SourceType.Dmr) {
            this.stopPlay();
            dmrPlayStop();
            history.go(-1);
            return;
        }
        this.isInfoShow = false;
        this.timeout(true);
        musicPlayObj.timeReset();
        this.closeMusicDialog();
        musicPlayObj.switchDisMusicplayerMode(musicDisplayMode.none, notFocus);
        if (contentBrowserObj.curShowMode == contentBrowserObj.ShowMode.MusicPlay) {
            //contentBrowserObj.curShowMode = contentBrowserObj.ShowMode.Browser;
            contentBrowserObj.showBrowser();
        } else if (contentBrowserObj.curShowMode == contentBrowserObj.ShowMode.MusicAndPhotoPlay) {
            contentBrowserObj.curShowMode = contentBrowserObj.ShowMode.PhotoPlay;
            contentBrowserObj.clearStopMusic();
        }
    }
}
;
MusicPlayObj.prototype.playOrPauseClick = function(isplay) {
    console.log("playOrPauseClick isplay = " + typeof (isplay));
    if (!this.isPlayDone) {
        console.log("playOrPauseClick !this.isPlayDone return");
        return;
    }
    if (typeof (isplay) == 'undefined') {
        if (playStatus == MmpPlayStatus.Play) {
            this.toPlay('pause');
        } else {
            this.toPlay('play');
        }
    } else if (isplay) {
        if (playStatus != MmpPlayStatus.Play) {
            this.toPlay('play');
        }
    } else {
        if (playStatus != MmpPlayStatus.Pause) {
            this.toPlay('pause');
        }
    }
}
;
MusicPlayObj.prototype.musicTrickPlay = function(operator) {
    if (musicPlayObj.playObj.curSourceType == SourceType.Usb || musicPlayObj.playObj.curSourceType == SourceType.Dmr) {
        this.musicPlayOperator(operator);
    }
}
;
MusicPlayObj.prototype.musicPlayOperator = function(operator, isBack) {
    console.log("musicPlayOperator operator = " + operator);
    if (operator == 'timeSeek') {
        this.doMediaSeek(isBack);
    } else {
        playbackOperator(this.musicHandle, operator);
    }
}
;
MusicPlayObj.prototype.ctrlPlayIconStatus = function(speed) {
    switch (speed) {
    case cmpbCtrlSpeedType.Play:
        $("#music_play_ctrl_bar div:nth-child(2)").attr('class', 'icon_fr_bg');
        $("#music_play_ctrl_bar div:nth-child(4)").attr('class', 'icon_ff_bg');
        $("#music_play_ctrl_bar div:nth-child(3)").attr('class', 'icon_play_bg').focus();
        break;
    case cmpbCtrlSpeedType.Pause:
        $("#music_play_ctrl_bar div:nth-child(2)").attr('class', 'icon_fr_bg');
        $("#music_play_ctrl_bar div:nth-child(4)").attr('class', 'icon_ff_bg');
        $("#music_play_ctrl_bar div:nth-child(3)").attr('class', 'icon_play_bg pause').focus();
        break;
    case cmpbCtrlSpeedType.FF_2X:
    case cmpbCtrlSpeedType.FF_4X:
    case cmpbCtrlSpeedType.FF_8X:
    case cmpbCtrlSpeedType.FF_16X:
    case cmpbCtrlSpeedType.FF_32X:
        $("#music_play_ctrl_bar div:nth-child(2)").attr('class', 'icon_fr_bg');
        $("#music_play_ctrl_bar div:nth-child(3)").attr('class', 'icon_play_bg pause');
        $("#music_play_ctrl_bar div:nth-child(4)").attr('class', PlaySleep[speed]).focus();
        break;
    case cmpbCtrlSpeedType.FR_2X:
    case cmpbCtrlSpeedType.FR_4X:
    case cmpbCtrlSpeedType.FR_8X:
    case cmpbCtrlSpeedType.FR_16X:
    case cmpbCtrlSpeedType.FR_32X:
        $("#music_play_ctrl_bar div:nth-child(4)").attr('class', 'icon_ff_bg');
        $("#music_play_ctrl_bar div:nth-child(3)").attr('class', 'icon_play_bg pause');
        $("#music_play_ctrl_bar div:nth-child(2)").attr('class', PlaySleep[speed]).focus();
        break;
    }
}
MusicPlayObj.prototype.cmdPlay = function() {
    var ret = playbackOperator(this.musicHandle, playbackCommand.play);
    if (ret != 0) {
        playStatus = MmpPlayStatus.Pause;
        this.audioPlayNotify({
            "TYPE": MmpEventType.playback_error,
            "TAG": this.pvTag,
            "ARG1": 109,
            "ARG2": 0,
            "ARG3": 0,
            "ARG4": 0
        });
    } else {
        this.ctrlPlayIconStatus(cmpbCtrlSpeedType.Play);
    }
}
var MUSIC_SEEK_LONG = 20000;
MusicPlayObj.prototype.doMediaSeek = function(isBack) {
    var SEEK_LONG;
    if (musicPlayObj.playObj.curSourceType == SourceType.Dmp || musicPlayObj.playObj.curSourceType == SourceType.Dmr) {
        SEEK_LONG = MUSIC_SEEK_LONG;
    } else {
        SEEK_LONG = 10000;
    }
    if (playStatus == MmpPlayStatus.Speed) {
        console.log("doMediaSeek playStatus == MmpPlayStatus.Speed return");
        return;
    }
    if (this.startSeekTime == -1) {
        this.startSeekTime = this.currentPos;
    }
    if (isBack) {
        if (this.startSeekTime > SEEK_LONG) {
            this.startSeekTime -= SEEK_LONG;
        } else {
            this.startSeekTime = 0;
        }
    } else {
        if (this.mediaDuration - this.startSeekTime > SEEK_LONG) {
            this.startSeekTime += SEEK_LONG;
        } else {
            this.startSeekTime = this.mediaDuration;
        }
    }
    if (this.mediaSeek_t) {
        clearTimeout(this.mediaSeek_t);
        this.mediaSeek_t = null ;
    }
    this.mediaSeek_t = setTimeout("musicPlayObj.timeSeek()", 500);
}
MusicPlayObj.prototype.timeSeek = function() {
    console.log("startSeekTime time = " + this.startSeekTime);
    playbackOperator(this.musicHandle, playbackCommand.seekTime, this.startSeekTime);
    this.startSeekTime = -1;
    this.mediaSeek_t = null ;
}
MusicPlayObj.prototype.stopPlay = function() {
    if (this.musicHandle) {
        //removeCmpbEventListener(audioPlayNotifyName, audioPlayNotify);
        playbackOperator(this.musicHandle, playbackCommand.stop);
        playbackDeinit(this.musicHandle);
        this.musicHandle = null ;
        this.pvTag = null ;
    }
}
;
MusicPlayObj.prototype.previousClick = function() {
    toPlay('prev');
}
;
MusicPlayObj.prototype.nextClick = function() {
    toPlay('next');
}
;
MusicPlayObj.prototype.toPlay = function(action) {
    console.log("toPlay action = " + action);
    if (action == 'play') {
        this.cmdPlay();
    } else if (action == 'pause') {
        this.musicPlayOperator(playbackCommand.pause);
        this.ctrlPlayIconStatus(cmpbCtrlSpeedType.Pause);
    } else if (action == 'prev') {
        this.playMusicMode(action);
    } else if (action == 'next') {
        this.playMusicMode(action);
    }
    ;
}
;
MusicPlayObj.prototype.playMusicMode = function(action) {
    console.log("playMusicMode");
    if (!this.playObj) {
        console.log("playMusicMode !this.playObj return");
        return;
    }
    var temp;
    if (action == 'prev') {
        temp = this.playObj.getPlayInfo({
            isNext: false,
            isRepeat: this.getRepeat(),
            isShuffle: false,
            isPlayAll: this.isPlayAll,
            mediaType: 2
        });
        if (this.isPlayAll || !this.getRepeat() || temp) {
            this.curPlayInfo = temp;
        }
    } else if (action == 'next') {
        this.curPlayInfo = this.playObj.getPlayInfo({
            isNext: true,
            isRepeat: this.getRepeat(),
            isShuffle: this.shuffle,
            mediaType: 2
        });
    } else if (action == 'ended' || action == 'error') {
        console.log("this.isPlayAll = " + this.isPlayAll + ";this.getRepeat() = " + this.getRepeat());
        if (this.isPlayAll) {
            temp = this.playObj.getPlayInfo({
                isNext: true,
                isRepeat: this.getRepeat(),
                isShuffle: this.shuffle,
                mediaType: 2
            });
            if (action == 'error' && this.getRepeat() && this.curPlayInfo == temp) {
                this.curPlayInfo = null ;
            } else {
                this.curPlayInfo = temp;
            }
        } else if (!this.getRepeat()) {
            this.curPlayInfo = null ;
        } else {
            if (action == 'error') {
                this.curPlayInfo = null ;
            }
        }
    }
    console.log("this.curPlayInfo = " + JSON.stringify(this.curPlayInfo));
    if (!this.curPlayInfo) {
        this.stopMusic();
        return;
    }
    setTimeout(function() {
        musicPlayObj.initPlayer();
    }, 100);
}
;
MusicPlayObj.prototype.initPlayer = function() {
    console.log("initPlayer this.curPlayInfo = " + JSON.stringify(this.curPlayInfo));
    this.stopPlay();
    this.timeReset();
    var paramObj;
    var fileName;
    this.isPlayDone = false;
    switch (this.playObj.curSourceType) {
    case SourceType.Dmp:
        paramObj = {
            mediaPath: this.curPlayInfo.mediaInfo.fileObjId,
            bMode: 2,
            info: this.curPlayInfo.devId
        };
        fileName = this.curPlayInfo.mediaInfo.mediaName;
        if (this.curPlayInfo.mediaType != 2) {
            this.closeMusicDialog();
            this.curDisplayMode = musicDisplayMode.none;
            this.isInfoShow = false;
            contentBrowserObj.curShowMode = contentBrowserObj.ShowMode.Browser;
            contentBrowserObj.startPlayback(this.playObj, this.curPlayInfo, this.isPlayAll);
            return;
        }
        break;
    case SourceType.Dmr:
        paramObj = {
            mediaPath: this.curPlayInfo.URL,
            bMode: 2,
            protocal: this.curPlayInfo.PROTOCOL_INFO
        };
        fileName = this.curPlayInfo.mediaName;
        break;
    default:
        paramObj = {
            mediaPath: this.curPlayInfo.MEDIA_PATH
        };
        var pathName = this.curPlayInfo.MEDIA_PATH;
        fileName = pathName.substring(pathName.lastIndexOf('/') + 1);
        break;
    }
    if (this.playObj.curSourceType != SourceType.Dmr) {
        refreshBgPlay();
        music_content_focus(this.curDisplayMode != musicDisplayMode.simplePlay);
    }
    $('#music_player_title_1').html(fileName);
    var ret = playbackInitWithPath(paramObj);
    if (ret == null || ret.STATUS != 0) {
        if (ret) {
            this.musicHandle = ret.HANDLE;
            this.pvTag = ret.PVTAG;
        } else {
            this.pvTag = -1;
        }
        this.audioPlayNotify({
            "TYPE": MmpEventType.playback_error,
            "TAG": this.pvTag,
            "ARG1": 109,
            "ARG2": 0,
            "ARG3": 0,
            "ARG4": 0
        });
        return;
    }
    this.musicHandle = ret.HANDLE;
    this.pvTag = ret.PVTAG;
    playStatus = MmpPlayStatus.Pause;
    /*
    if (this.playObj.curSourceType == SourceType.Usb) {
        playbackOperator(this.musicHandle, playbackCommand.getMp3CoverAsync, {width: 480,height: 480});
    }
    this.cmdPlay();
    if (this.curDisplayMode >= musicDisplayMode.simplePlay) {
        $('#music_play_ctrl_bar .icon_play_bg').focus();
    }
    */
}
;
MusicPlayObj.prototype.init = function(obj, sourceType, isPlayAll) {
    try {
        mtvObj.acfgSetConfigItemValue(stvapi_config.mmp_play_state, icl_mmp_play_status.audio);
        this.initOption(MUSIC_PLAYER_OPTION_DATA.value);
        if (typeof (isPlayAll) != 'undefined') {
            this.isPlayAll = isPlayAll;
        } else {
            this.isPlayAll = false;
        }
        var curValue = localStorage.getItem('Shuffle');
        if (parseInt(curValue)) {
            this.shuffle = true;
        } else {
            this.shuffle = false;
        }
        this.initMusicBottombar();
        this.showMediaBar();
        if (sourceType == SourceType.Dmr) {
            $('#music_play_ctrl_bar .icon_prev_bg').css('opacity', 0);
            $('#music_play_ctrl_bar .icon_next_bg').css('opacity', 0);
            //$('#music_play_ctrl_bar .icon_ff_bg').hide();
            //$('#music_play_ctrl_bar .icon_fr_bg').hide();
            this.playObj = {
                curSourceType: sourceType
            };
            this.curPlayInfo = obj;
            this.timeReset();
            this.switchDisMusicplayerMode(musicDisplayMode.simplePlay);
            setTimeout(function() {
                musicPlayObj.initPlayer();
            }, 100);
        } else {
            var tmpPlayObj = obj.getPlayInfo({
                mediaType: 2
            });
		if (curBrowserType == BrowserType.Usb) { // Randy.xiao add for CUL event id 8
			var media_type_path_of_audio = tmpPlayObj.MEDIA_TYPE+"_0_"+tmpPlayObj.MEDIA_PATH; // Randy.xiao add for CUL event id 8
			mtvObj.acfgSetConfigString("g_content_browser",media_type_path_of_audio); // Randy.xiao add for CUL event id 8
		}
		else 
		{
			var media_type_path_of_audio = tmpPlayObj.mediaType+"_1_"+tmpPlayObj.mediaInfo.thumbnailLocalPath; // Randy.xiao add for CUL event id 8
			mtvObj.acfgSetConfigString("g_content_browser",media_type_path_of_audio); // Randy.xiao add for CUL event id 8
		}
            var isSame = false;
            if (obj.curSourceType == SourceType.Dmp) {
                isSame = (this.curPlayInfo && this.curPlayInfo.objectId == tmpPlayObj.objectId);
                $('#music_play_ctrl_bar .icon_ff_bg').hide();
                $('#music_play_ctrl_bar .icon_fr_bg').hide();
                $('#music_play_ctrl_bar').css('width', '168px');
            } else {
                isSame = (this.curPlayInfo && this.curPlayInfo.MEDIA_PATH == tmpPlayObj.MEDIA_PATH);
            }
            if (!this.musicHandle || !isSame) {
                this.timeReset();
                this.playObj = obj;
                this.curPlayInfo = tmpPlayObj;
                this.switchDisMusicplayerMode(musicDisplayMode.simplePlay);
                setTimeout(function() {
                    musicPlayObj.initPlayer();
                }, 100);
            } else {
                this.switchDisMusicplayerMode(musicDisplayMode.simplePlay);
                this.playOrPauseClick(true);
                $('#music_play_ctrl_bar .icon_play_bg').focus();
            }
        }
    } catch (e) {
        console.log(e.msg);
    } finally {
        waitLoading(false);
    }
}
;
MusicPlayObj.prototype.timeupdate = function(currentTime) {
    var curTime = timeFormat(this.currentPos);
    var totalTime = timeFormat(this.mediaDuration);
    $('#music_player_current_time').html(curTime);
    $('#music_player_total_time').html(totalTime);
    var surpos = this.currentPos / this.mediaDuration;
    var perc;
    if (this.mediaSeek_t) {
        perc = 100 * this.startSeekTime / this.mediaDuration;
    } else {
        perc = 100 * surpos;
    }
    $('#music_progress').css('width', perc + '%');
    if ($('#music_bg_play_layout').is(":visible")) {
        $('#bg_music_cur_time').html(curTime);
        //$('#bg_music_time').html(totalTime);
        $('#bg_music_progress').css('width', perc + '%');
    }
}
;
MusicPlayObj.prototype.timeReset = function() {
    this.currentPos = 0;
    this.mediaDuration = 0;
    this.startSeekTime = -1;
    this.mediaSeek_t = null ;
    this.curSpeed = -1;
    $('#music_player_current_time').html(timeFormat(0));
    $('#music_player_total_time').html(timeFormat(0));
    $('#music_player_title_1').html('');
    $('#music_player_title_2').html('');
    $('#music_progress').css('width', '0px');
    $('#music_play_thumbnail').css('width', '').css('height', '').attr('src', '');
}
;
MusicPlayObj.prototype.music_player_key_dispatch = function(isup, e) {
    console.log("music_player_key_dispatch className = " + e.target.className);
    var keynum = e.which || e.keyCode;
    var id = e.target.className;
    if (musicPlayObj.playObj.curSourceType == SourceType.Dmr && DmrKeyList.indexOf(keynum) < 0) {
        console.log("musicPlayObj.playObj.curSourceType == SourceType.Dmr && DmrKeyList.indexOf(keynum) < 0");
        return;
    }
    if ($('#music_player_ctrl_bg').css('display') == 'none') {
        if (keynum != KeyEvent.DOM_VK_INFO && keynum != KeyEvent.DOM_VK_OPTION && !this.isMusicDialogShow()) {
            if ((keynum == KeyEvent.DOM_VK_DOWN || keynum == KeyEvent.DOM_VK_UP) && (musicPlayObj.playObj.curSourceType == SourceType.Dmr))
            {
               ;//nothing
            }
            else
            {
                musicPlayObj.showMediaBar();
            }
        }
    } else {
        musicPlayObj.timeout();
    }
    var focus_id;
    switch (keynum) {
    case KeyEvent.DOM_VK_LEFT:
        if (isup) {
            //this.musicPlayOperator(playbackCommand.seekTime, true);
            var content = null ;
            do {
                if (content)
                    id = content.attr('class');
                content = $("#music_play_ctrl_bar div[class='" + id + "']").prev();
            } while (content.length > 0 && (!content.is(":visible") || content.attr('tabindex') == undefined || content.css('opacity') == 0));if (content.length > 0) {
                content.focus();
            }
        }
        break;
    case KeyEvent.DOM_VK_RIGHT:
        if (isup) {
            //this.musicPlayOperator(playbackCommand.seekTime, false);
            var content = null ;
            do {
                if (content)
                    id = content.attr('class');
                content = $("#music_play_ctrl_bar div[class='" + id + "']").next();
            } while (content.length > 0 && (!content.is(":visible") || content.attr('tabindex') == undefined || content.css('opacity') == 0));if (content.length > 0) {
                content.focus();
            }
        }
        break;
    case KeyEvent.DOM_VK_RETURN:
        if (!isup && id != "") {
            if (musicPlayObj.playObj.curSourceType == SourceType.Dmr){
              if ($("#music_play_ctrl_bar div:nth-child(4)").is(':focus')) {
                    this.musicPlayOperator(playbackCommand.ff);
              } else if ($("#music_play_ctrl_bar div:nth-child(2)").is(':focus')) {
                    this.musicPlayOperator(playbackCommand.fr);
              }
            }else{
              if ($("#music_play_ctrl_bar div:nth-child(4)").is(':focus')) {
                if (playStatus != MmpPlayStatus.Speed) {
                    this.musicPlayOperator(playbackCommand.seekTime, false);
                }
            } else if ($("#music_play_ctrl_bar div:nth-child(2)").is(':focus')) {
                if (playStatus != MmpPlayStatus.Speed) {
                    this.musicPlayOperator(playbackCommand.seekTime, true);
                }
              }
            }
        } else if (isup && id != "") {
            var fun_str = $("#music_play_ctrl_bar div[class='" + id + "']").attr('data-key-enter');
            eval(fun_str);
        }
        break;
    case KeyEvent.DOM_VK_UP:
        break;
    case KeyEvent.DOM_VK_DOWN:
        break;
    case KeyEvent.DOM_VK_PLAY:
        this.playOrPauseClick(true);
        break;
    }
}
MusicPlayObj.prototype.initMusicPlayerMode = function(mode, notFocus) {
    console.log("initMusicPlayerMode mode = " + mode);
    switch (mode) {
    case musicDisplayMode.none:
        this.stopPlay();
        //setMusicPlayerModeTimer(0);
        $('#music_player_bg').css('display', 'none');
        $('#music_bg_play_layout').hide();
        if (typeof (notFocus) == 'undefined') {//music_content_focus(true);
        }
        break;
    case musicDisplayMode.backgroundPlay:
        $('#music_player_bg').hide();
        $(".content_box").fadeIn();
        music_content_focus(true);
        break;
    case musicDisplayMode.simplePlay:
        if (this.playObj.curSourceType != SourceType.Dmr) {//music_content_focus(false);
        }
        $('#music_player_bg').show();
        $('#music_play_ctrl_bar .icon_play_bg').focus();
        break;
    case musicDisplayMode.hidePlay:
        console.log("musicDisplayMode.hidePlay");
        break;
    case musicDisplayMode.minimised:
        break;
    }
}
;
var musicPlayerModeTimer;
function setMusicPlayerModeTimer(time, mode) {/*
    console.log("setMusicPlayerModeTimer time = " + time +";mode = " + mode);

    if (null  != musicPlayerModeTimer) {
        console.log("clearTimeout");
        clearTimeout(musicPlayerModeTimer);
        musicPlayerModeTimer = null ;
    }
    if (time > 0) {
        musicPlayerModeTimer = setTimeout('doSwitchModeTimer(' + mode + ');', time);
    }
    */
}
function doSwitchModeTimer(mode) {
    if (contentBrowserObj.curShowMode == contentBrowserObj.ShowMode.MusicPlay) {
        musicPlayObj.switchDisMusicplayerMode(mode);
    }
}
MusicPlayObj.prototype.switchDisMusicplayerMode = function(mode, notFocus) {
    console.log("switchDisMusicplayerMode curDisplayMode = " + this.curDisplayMode + ";mode = " + mode);
    if (this.curDisplayMode != mode) {
        this.curDisplayMode = mode;
        this.initMusicPlayerMode(mode, notFocus);
        console.log("this.curDisplayMode = " + this.curDisplayMode);
    }
}
;
MusicPlayObj.prototype.showMediaBar = function() {
    $('#music_player_ctrl_bg').css('display', '');
    this.timeout();
    if (!this.isMusicDialogShow()) {
        if (this.activeContent && $(this.activeContent).is(':visible')) {
            $(this.activeContent).focus();
        } else {
            $('#music_player_ctrl_bg .icon_play_bg').focus();
        }
    }
}
;
MusicPlayObj.prototype.hideMediaBar = function() {
    console.log("hideMediaBar");
    if(this.curDisplayMode == musicDisplayMode.simplePlay){
        if (document.activeElement.tagName != "BODY" && document.activeElement.tagName != "IFRAME") {
            this.activeContent = document.activeElement;
        }
        $('#music_player_ctrl_bg').css('display', 'none');       
    }
}
;
MusicPlayObj.prototype.timeout = function(isStop) {
    if (null != this.hidebar_t) {
        clearTimeout(this.hidebar_t);
        this.hidebar_t = null ;
    }
    if (!isStop) {
        if (!this.isInfoShow) {
            this.hidebar_t = setTimeout("musicPlayObj.hideMediaBar()", 5000);
        }
    }
}
;
function showMusicBottombar() {
    $('#music_player_footer').fadeIn();
    setTimeout("hideMusicBottombar()", 2000);
}
MusicPlayObj.prototype.initMusicBottombar = function() {
    var data = playerColorKeyData;
    if (!this.isPlayAll) {
        playerColorKeyData[0] = PlayAll[1];
    } else {
        playerColorKeyData[0] = PlayAll[0];
    }
    if (!this.shuffle) {
        playerColorKeyData[1] = Shuffle.value[1];
    } else {
        playerColorKeyData[1] = Shuffle.value[0];
    }
    var children = $('#music_player_footer').find('li');
    for (var i = 0; i < children.length; i++) {
        $(children[i]).find('span').html(getTranslate(data[i]));
    }
}
function hideMusicBottombar() {
    console.log("hideMusicBottombar = ");
    $('#music_player_footer').fadeOut();
}
MusicPlayObj.prototype.handleMusicPlayerKey = function(e) {
    console.log("handleMusicPlayerKey");
    var keynum = e.which || e.keyCode;
    if (isDialogShow()) {
        if (isOptionDialogShow()) {
            option_key_dispatch(event);
        } else {
            switch (keynum) {
            case KeyEvent.DOM_VK_BACK:
            case KeyEvent.DOM_VK_INFO:
                closeDialog();
                break;
            }
        }
        return;
    }
    if (musicPlayObj.playObj.curSourceType == SourceType.Dmr && DmrKeyList.indexOf(keynum) < 0) {
        console.log("musicPlayObj.playObj.curSourceType == SourceType.Dmr && DmrKeyList.indexOf(keynum) < 0");
        return;
    }
    if ($('#music_player_ctrl_bg').css('display') == 'none') {
        if (keynum != KeyEvent.DOM_VK_INFO) {
            musicPlayObj.showMediaBar();
        }
    } else {
        musicPlayObj.timeout();
    }
    if (bottomBarKeyList.indexOf(keynum) !== -1 && musicPlayObj.playObj.curSourceType != SourceType.Dmr) {
        showMusicBottombar();
    }
    switch (keynum) {
    case KeyEvent.DOM_VK_INFO:
        if (musicPlayObj.playObj.curSourceType == SourceType.Dmr) {
            if (isDialogShowById('metedata_dialog')) {
                closeDialog();
                return;
            } else {
                showDlnaMusicMetedataDialog(musicPlayObj.curPlayInfo);
            }
            return;
        } else {
            this.isInfoShow = !($('#music_player_ctrl_bg').css('display') != 'none');
            if (this.isInfoShow) {
                showMusicBottombar();
                this.showMediaBar();
            } else {
                this.hideMediaBar();
                hideMusicBottombar();
            }
        }
        break;
    case KeyEvent.DOM_VK_BACK:
        handleBackKey();
        break;
    case KeyEvent.DOM_VK_RED:
        content = $('#music_player_footer').find('li')[0];
        var info = getColorKeyItemTxt(content);
        console.log("DOM_VK_RED info = " + info);
        if (this.isPlayAll) {
            setItemColorKey(content, PlayAll[1]);
            this.isPlayAll = false;
        } else {
            setItemColorKey(content, PlayAll[0]);
            this.isPlayAll = true;
        }
        break;
    case KeyEvent.DOM_VK_GREEN:
        //sort
        content = $('#music_player_footer').find('li')[1];
        var info = getColorKeyItemTxt(content);
        console.log("DOM_VK_GREEN info = " + info);
        if (!this.shuffle) {
            Shuffle.curValue = 1;
            this.shuffle = true;
            setItemColorKey(content, Shuffle.value[0]);
        } else {
            Shuffle.curValue = 0;
            this.shuffle = false;
            setItemColorKey(content, Shuffle.value[1]);
        }
        localStorage.setItem(Shuffle.name, Shuffle.curValue);
        break;
    case KeyEvent.DOM_VK_YELLOW:
        if (isDialogShow()) {
            closeDialog();
            return;
        }
        break;
    case KeyEvent.DOM_VK_BLUE:
        // 跳转到help界面
        goToHelpPage();
        break;
    case KeyEvent.DOM_VK_OPTION:
        closeDialog();
        //showOptionDialog("Music Player", musicOptionNotify);
        var arg = $.extend({}, {
            data: MUSIC_PLAYER_OPTION_DATA,
            callback: baseOptionNotify
        });
        showOptionDialog(arg);
        break;
    case KeyEvent.DOM_VK_STOP:
        this.stopMusic();
        break;
    case KeyEvent.DOM_VK_PAUSE:
        this.playOrPauseClick(false);
        break;
    case KeyEvent.DOM_VK_FAST_FWD:
        if (musicPlayObj.playObj.curSourceType == SourceType.Usb || musicPlayObj.playObj.curSourceType == SourceType.Dmr) {
            this.musicPlayOperator(playbackCommand.ff);
        }
        break;
    case KeyEvent.DOM_VK_REWIND:
        if (musicPlayObj.playObj.curSourceType == SourceType.Usb || musicPlayObj.playObj.curSourceType == SourceType.Dmr) {
            this.musicPlayOperator(playbackCommand.fr);
        }
        break;
    case KeyEvent.DOM_VK_TRACK_NEXT:
        //case KeyEvent.DOM_VK_CH_INCREASE: //CH+
        if (musicPlayObj.playObj.curSourceType != SourceType.Dmr) {
            this.playMusicMode('next');
        }
        break;
    case KeyEvent.DOM_VK_TRACK_PREV:
        //case KeyEvent.DOM_VK_CH_DECREASE: //Ch-
        if (musicPlayObj.playObj.curSourceType != SourceType.Dmr) {
            if (musicPlayObj.currentPos > 3000) {
                playbackOperator(this.musicHandle, playbackCommand.seekTime, 0);
            } else {
                this.playMusicMode('prev');
            }
        }
        break;
    case KeyEvent.DOM_VK_LIST:
        if (musicPlayObj.playObj.curSourceType == SourceType.Dmr) {
            mtvuiUtil.procSysKey(keynum);
	    break;
        }
        if (this.curDisplayMode == musicDisplayMode.minimised) {
            this.switchDisMusicplayerMode(musicDisplayMode.simplePlay);
        } else if (this.curDisplayMode == musicDisplayMode.hidePlay || this.curDisplayMode == musicDisplayMode.simplePlay) {
            this.switchDisMusicplayerMode(musicDisplayMode.backgroundPlay);
        }
        break;
    }
}
;
MusicPlayObj.prototype.initOption = function(option_data_attr) {
    for (index in option_data_attr) {
        if (typeof option_data_attr[index] == 'string') {
            continue;
        }
        var curValue;
        var id = option_data_attr[index].name.replace(' ', '_');
        console.log("initOption id = " + id);
        curValue = localStorage.getItem(id);
        if (curValue) {
            if (curValue >= option_data_attr[index].value.length) {
                curValue = 0;
                localStorage.setItem(id, curValue);
            } else if (curValue < 0) {
                curValue = 0;
                localStorage.setItem(id, curValue);
            }
            option_data_attr[index].curValue = parseInt(curValue);
        }
    }
}
;
MusicPlayObj.prototype.switchValue = function(key, valueIndex, itemObj) {}
;
MusicPlayObj.prototype.dmrCmdOperator = function(type, value) {
    console.log("MusicPlayObj dmrCmdOperator type = " + type + ";value = " + value);
    switch (type) {
    case DmrNotifyCmdType.pause:
        this.playOrPauseClick(false);
        break;
    case DmrNotifyCmdType.resume:
        this.playOrPauseClick(true);
        break;
    case DmrNotifyCmdType.stop:
        this.stopPlay();
        this.closeMusicDialog();
        //$('#music_play_btn')[0].className = 'music_stop_btn';
        break;
    case DmrNotifyCmdType.seekTime:
        playbackOperator(this.musicHandle, playbackCommand.seekTime, value);
        break;
    case DmrNotifyCmdType.playSpeed:
        playbackOperator(this.musicHandle, playbackCommand.setSpeed, value);
        break;
    }
}
;
MusicPlayObj.prototype.isPlaying = function() {
    if (this.musicHandle) {
        return true;
    }
    return false;
}
MusicPlayObj.prototype.plugoutUsb = function(usbPath) {
    if (this.curPlayInfo && this.curPlayInfo.MEDIA_PATH && this.curPlayInfo.MEDIA_PATH.indexOf(usbPath) == 0) {
        this.stopMusic(true);
    }
}
MusicPlayObj.prototype.dmsLost = function(devId) {
    if (this.playObj && this.playObj.dlnaMusicPlayObj && this.playObj.dlnaMusicPlayObj.DEV_ID == devId) {
        this.stopMusic(true);
    }
}
MusicPlayObj.prototype.getCurPlayPath = function() {
    if (this.curDisplayMode != musicDisplayMode.none) {
        switch (this.playObj.curSourceType) {
        case SourceType.Usb:
            return this.curPlayInfo.MEDIA_PATH;
            break;
        }
    }
}
var musicPlayObj = new MusicPlayObj();