var RegionCode = get_RegionCode();

function color_bar_list_key_dispatch(isup, e) {
    console.log("color_bar_list_key_dispatch id = " + e.target.id);
    var id = e.target.id;

    var keynum = e.which || e.keyCode;
    var content;

    switch (keynum) {
    case KeyEvent.DOM_VK_UP:
        if (id == "") {
            return;
        }
        content = $(e.target).prev();
        if (content.length > 0) {
            content.focus();
        }

        break;
    case KeyEvent.DOM_VK_RETURN:
        if (id == "") {
            return;
        }
        if (isup) {
            var command = $(e.target).attr('data-key-enter');
            closeDialog();
            eval(command);
        }

        break;
    case KeyEvent.DOM_VK_DOWN:
        if (id == "") {
            return;
        }
        content = $(e.target).next();
        if (content.length > 0) {
            content.focus();
        }
        break;

    }
}

function color_bar_item_focus(isfocus, id) {
    if (isfocus) {
        $('#' + id).addClass('focus');
        startMarqueeScroll($('#' + id + ' span'));
    } else {
        $('#' + id).removeClass('focus');
        stopMarqueeScroll();
    }
}

var contentDialog = null ;

function closeDialog() {
    if (isDialogShow()) {
        contentDialog.close().remove();
        contentDialog = null ;
    }
    closeOptionDialog();
}

function closeDialog_MultiRoom() {
    videoPlayObj.playStop();
}

function closeAllDialog() {
    closeDialog();
    closePlaybackErrorDialog();
    closeStopInfoDialog();
    closePvrDialog();
}

function isDialogShow() {
    if (contentDialog && contentDialog != null ) {
        return true;
    } else {
        return false;
    }
}

function isDialogShowById(id) {
    var frag = false;
    if(isDialogShow()){
        console.log('isDialogShowById dialog.get(\'' + id + '\') = ' + dialog.get(id));
        if (dialog.get(id)) {
            frag = true;
        } else {
            frag = false;
        }
    }
    console.log('isDialogShowById dialog.get(\'' + id + '\') = ');
    return frag;

}

function showColorKeyDialog(index, title, colorListContent, itemNum, focusIndex) {
    contentDialog = dialog({
        id: 'colorkey_dialog_' + index,
        align: 'bottom',
        modal:true,
        content: '<div style="height: auto;width: 491px;position: relative;background: #1d1f21;">\
                    <div style="height:85px;width:491px;position:relative;border-top-left-radius: 6px;border-top-right-radius: 6px;margin-bottom: 29px;">\
                        <p class="dialog_title">' + getTranslate(title) + '</p>\
                        <div style="height:1px;width:100%;background-color: #ffffff;opacity: 0.1;position: absolute;bottom: 0px;"></div>\
                    </div>\
                    <div style="width: 100%;padding-left: 40px;padding-right: 40px;overflow: hidden;margin:0 auto;display:black;padding-bottom:27px;height:' + (27+40 * (Number(itemNum) > 10 ? 10 : Number(itemNum))) + 'px;">\
                        <ul id ="color_bar_list" style=\'margin:0px;list-style:none;color:white;\'>'
                            + colorListContent +
                        '</ul>\
                    </div>\
                  </div>',

    });

    contentDialog.show();
    if(typeof(focusIndex) == 'undefined'){
        focusIndex = 0;
    }
    $('#color_bar_list_' + focusIndex).focus();
}

function showMusicMetedataDialog(content) {
    var pathName = content.MEDIA_PATH;
    var title = pathName.substring(pathName.lastIndexOf('/') + 1);
    var artist = "Others";
    var album  = "Others";
    if (content.TITLE){
        title = content.TITLE;
    }
    if (content.ARTIST){
        artist = content.ARTIST;
    }
    if (content.ALBUM){
        album = content.ALBUM;
    }
    var date = content.DATE.YEAR + "/" + content.DATE.MONTH + "/" + content.DATE.DAY;
    contentDialog = dialog({
        id: 'metedata_dialog',
        modal:true,
        content: '<div style="height: auto;width: 859px;position: relative;background: #1d1f21;">\
                    <div style="height:85px;width:859px;position:relative;border-top-left-radius: 6px;border-top-right-radius: 6px;margin-bottom: 29px;">\
                        <p class="dialog_title">'+getTranslate('Metedata')+'</p>\
                        <div style="height:1px;width:100%;background-color: #ffffff;opacity: 0.1;position: absolute;bottom: 0px;"></div>\
                    </div>\
                    <table class="metadata_table">\
                        <tbody><tr><td><p>' + getTranslate("Title") + '<p>&nbsp' + title + '</td></tr>\
                        <tr><td><p>' + getTranslate("SB_ARTIST") + '<p>&nbsp' + artist + '</td></tr>\
                        <tr><td><p>' + getTranslate("DP_ALBUM") + '<p>&nbsp' + album + '</td></tr>\
                        <tr><td><p>' + getTranslate("DP_DURATION") + '<p>&nbsp' + timeFormat(content.DURATION) + '</td></tr>\
                        <tr><td><p>' + getTranslate("Date") + '</p>&nbsp' + date + '</td></tr>\
                    </tbody></table>\
                    <div style="position: relative;height: 75px;width: 100%;margin-top: 27px;z-index:3;margin-right: 40px;">\
                        <div style="position: relative;height: 75px;width: 200px;float: right;margin-right: 40px;">\
                            <div id="btn_left" tabindex="0" class="btn_all" data-key-enter="" style="width: 200px;">\
                                <p>'+getTranslate("RC_OPT_CLOSE")+'</p>\
                            </div>\
                        </div>\
                    </div>\
                </div>',

    });

    contentDialog.show();
    $('#btn_left').focus();
}

function showDlnaMusicMetedataDialog(content) {
    var pathName = content.MEDIA_PATH;
    var title = content.mediaName;
    var artist = "Others";
    var album  = "Others";
    if (content.mediaArtist != "N/A"){
        artist = content.mediaArtist;
    }
    if (content.mediaAlbum != "N/A"){
        album = content.mediaAlbum;
    }
    var date = getFormatDlnaDate(content.mediaDate);
    contentDialog = dialog({
        id: 'metedata_dialog',
        modal:true,
        content: '<div style="height: auto;width: 859px;position: relative;background: #1d1f21;">\
                    <div style="height:85px;width:859px;position:relative;border-top-left-radius: 6px;border-top-right-radius: 6px;margin-bottom: 29px;">\
                        <p class="dialog_title">'+getTranslate('Metedata')+'</p>\
                        <div style="height:1px;width:100%;background-color: #ffffff;opacity: 0.1;position: absolute;bottom: 0px;"></div>\
                    </div>\
                    <table class="metadata_table">\
                        <tr><td><p>' + getTranslate("Title") + '</p>&nbsp' + title + '</td></tr>\
                        <tr><td><p>'+ getTranslate("SB_ARTIST") + '</p>&nbsp' + artist + '</td></tr>\
                        <tr><td><p>'+ getTranslate("DP_ALBUM") + '</p>&nbsp' + album + '</td></tr>\
                        <tr><td><p>' + getTranslate("DP_DURATION") + '</p>&nbsp' + content.mediaDuration + '</td></tr>\
                        <tr><td><p>' + getTranslate("Date") + '</p>&nbsp' + date + '</td></tr>\
                    </table>\
                    <div style="position: relative;height: 75px;width: 100%;margin-top: 27px;z-index:3;margin-right: 40px;">\
                        <div style="position: relative;height: 75px;width: 200px;float: right;margin-right: 40px;">\
                            <div id="btn_left" tabindex="0" class="btn_all" data-key-enter="" style="width: 200px;">\
                                <p>'+getTranslate("RC_OPT_CLOSE")+'</p>\
                            </div>\
                        </div>\
                    </div>\
            </div>',

    });

    contentDialog.show();
    $('#btn_left').focus();

}

function showMetedataDialog(title, content) {
    contentDialog = dialog({
        id: 'metedata_dialog',
        modal:true,
        content: '<div style="height: auto;width: 859px;position: relative;background: #1d1f21;">\
                    <div style="height:85px;width:859px;position:relative;border-top-left-radius: 6px;border-top-right-radius: 6px;margin-bottom: 29px;">\
                        <p class="dialog_title">'+getTranslate("MAIN_METADATA")+'</p>\
                        <div style="height:1px;width:100%;background-color: #ffffff;opacity: 0.1;position: absolute;bottom: 0px;"></div>\
                    </div>\
                    <table class="metadata_table">'
                        + content +
                    '</table>\
                    <div style="position: relative;height: 75px;width: 100%;margin-top: 27px;z-index:3;margin-right: 40px;">\
                        <div style="position: relative;height: 75px;width: 200px;float: right;margin-right: 40px;">\
                            <div id="btn_left" tabindex="0" class="btn_all" data-key-enter="" style="width: 200px;">\
                                <p>'+getTranslate("RC_OPT_CLOSE")+'</p>\
                            </div>\
                        </div>\
                    </div>\
                </div>',

    });

    contentDialog.show();
    $('#btn_left').focus();
}

function isOptionDialogShow() {
    var frag;
    if ($('#optionMenuid').length > 0) {
        frag = true;
    } else {
        frag = false;
    }
    return frag;
}

function showOptionDialog(arg){
    var arg = $.extend({}, arg, {
        translateData: translateBeforewords
    });
    $("body").OptionMenuDialog(arg);
    $("body").OptionMenuDialog('show');
}

function closeOptionDialog(){
    if(isOptionDialogShow()){
        $("body").OptionMenuDialog('close');
    }
}

var pvrRatingBlockedPinText ='';
var pvrPinNotiftyFunc;

function pvr_rating_blocked_key_dispatch(isup, e){
    var id = e.target.id;
    var keynum = e.which || e.keyCode;
    var keyValue = '';
    switch(keynum){
    case KeyEvent.DOM_VK_0:
    case KeyEvent.DOM_VK_1:
    case KeyEvent.DOM_VK_2:
    case KeyEvent.DOM_VK_3:
    case KeyEvent.DOM_VK_4:
    case KeyEvent.DOM_VK_5:
    case KeyEvent.DOM_VK_6:
    case KeyEvent.DOM_VK_7:
    case KeyEvent.DOM_VK_8:
    case KeyEvent.DOM_VK_9:
    //TODO deal with number key
    keyValue = keynum - KeyEvent.DOM_VK_0;
    if(pvrRatingBlockedPinText.length < 4){
        pvrRatingBlockedPinText += keyValue;
    }
    console.log("pvrRatingBlockedPinText = " + pvrRatingBlockedPinText);
    if(pvrRatingBlockedPinText.length == 4){
        if (RegionCode == eRegionCode.PLF_OPT_REGION_RUSSIA) /*20180323 [TF518AOCRUSMTK01-321] AOC style*/
			$($('#pin_star_layout').find('div')[pvrRatingBlockedPinText.length - 1]).css({"background": "url(textfield_formatted_dot_highlighted.png)","background-repeat":"no-repeat", 'background-color':'#2BB8C2'});
        else
            $($('#pin_star_layout').find('div')[pvrRatingBlockedPinText.length - 1]).css('background-color','#76D7D6');
        if(pvrPinNotiftyFunc){
            setTimeout(function(){
                eval(pvrPinNotiftyFunc+'(5);');
            });
        } else {
            doFocus('btn_left');
        }
    } else {
        if (RegionCode == eRegionCode.PLF_OPT_REGION_RUSSIA)
            $($('#pin_star_layout').find('div')[pvrRatingBlockedPinText.length - 1]).css({"background": "url(textfield_formatted_dot_highlighted.png)","background-repeat":"no-repeat", 'background-color':'#2BB8C2'});
        else
			$($('#pin_star_layout').find('div')[pvrRatingBlockedPinText.length - 1]).css('background-color','#76D7D6');
    }
    break;
    case KeyEvent.DOM_VK_LEFT:
        if (id == "") {
            return;
        }
        content = $(e.target).prev();
        if (content.length > 0) {
            content.focus();
        }

        break;
    case KeyEvent.DOM_VK_RETURN:
        if (id == "") {
            return;
        }
        if (isup) {
            var command = $(e.target).attr('data-key-enter');
            console.log("command = " + command);
            eval(command);
        }

        break;
    case KeyEvent.DOM_VK_RIGHT:
        if (id == "") {
            return;
        }
        content = $(e.target).next();
        if (content.length > 0) {
            content.focus();
        }
        break;
    default:
    break;
    }
}

function closePvrDialog() {
    if (pvrDialog && pvrDialog != null ) {
        pvrDialog.close().remove();
        pvrDialog = null ;
    }
}

function isPvrDialogShow() {
    if (pvrDialog && pvrDialog != null ) {
        return true;
    } else {
        return false;
    }
}

function clearPvrRatingBlockedPin(){
    pvrRatingBlockedPinText = '';
    if (RegionCode == eRegionCode.PLF_OPT_REGION_RUSSIA) /*20180323 [TF518AOCRUSMTK01-321] AOC style*/
		$('#pin_star_layout').find('div').css({"background":"" });
    else
        $('#pin_star_layout').find('div').css('background-color', 'white');

}

var pvrDialog = null;

function showPvrChannelBlockedDialog(btnClickNotify){
    console.log("showPvrRatingBlockedDialog btnClickNotify = " + btnClickNotify);
    pvrRatingBlockedPinText = '';
    pvrPinNotiftyFunc = btnClickNotify;
    /*20180323 [TF518AOCRUSMTK01-321] AOC style*/
    if (RegionCode == eRegionCode.PLF_OPT_REGION_RUSSIA){
		pvrDialog = dialog({
        id: 'pvr_rating_blocked_dialog',
        modal:true,
        content: '<div style="height: 368px;width: 859px;margin: 0 auto;position: relative;background-color: #1d1f21;">\
        <div style="height:103px;width:859px;position:relative;border-top-left-radius: 6px;border-top-right-radius: 6px;z-index:2;">\
            <p id="pvr_enter_pincode_title" class="dialog_title">'+getTranslate('QT_ENTER_PIN')+'</p>\
            <div style="height:1px;width:100%;background-color: #ffffff;opacity: 0.1;position: absolute;bottom: 0px;"></div>\
        </div>\
        <div id="pin_star_layout" style="position:relative;height: 48px;margin: 0 auto;margin-top: 70px;width: 455px;z-index:3;border-radius: 0px; padding-top:14px;padding-left: 24px;background-color:#2BB8C2;">\
            <div class="dialog_pin_dot"></div>\
            <div class="dialog_pin_dot" style="margin-left: 0px;"></div>\
            <div class="dialog_pin_dot" style="margin-left: 0px;""></div>\
            <div class="dialog_pin_dot" style="margin-left: 0px;"></div>\
        </div>\
        <div style="position:relative;height: 48px;width:447px;margin-top:72px;float:right;margin-right:40px;">\
        <div id="btn_right" tabindex="0" class="btn_all" data-key-enter="'+btnClickNotify+'(3);" style="margin-right:21px;">\
            <p >'+getTranslate("cancel")+'</p>\
        </div>\
        <div id="btn_left" tabindex="0" class="btn_all" data-key-enter="'+btnClickNotify+'(4);">\
            <p >'+getTranslate("clear")+'</p>\
        </div>\
        </div>\
        </div>'
        });
    }else{
        pvrDialog = dialog({
        id: 'pvr_rating_blocked_dialog',
        modal:true,
        content: '<div style="height: 368px;width: 859px;margin: 0 auto;position: relative;background-color: #1d1f21;">\
        <div style="height:103px;width:859px;position:relative;border-top-left-radius: 6px;border-top-right-radius: 6px;z-index:2;">\
            <p id="pvr_enter_pincode_title" class="dialog_title">'+getTranslate('QT_ENTER_PIN')+'</p>\
            <div style="height:1px;width:100%;background-color: #ffffff;opacity: 0.1;position: absolute;bottom: 0px;"></div>\
        </div>\
        <div id="pin_star_layout" style="position:relative;height: 48px;margin: 0 auto;margin-top: 70px;width: 455px;z-index:3;border-radius: 24px;border: 2px solid #76D7D6;padding-top:14px;padding-left: 24px;">\
            <div class="dialog_pin_dot"></div>\
            <div class="dialog_pin_dot" style="margin-left: 7px;"></div>\
            <div class="dialog_pin_dot" style="margin-left: 7px;""></div>\
            <div class="dialog_pin_dot" style="margin-left: 7px;"></div>\
        </div>\
        <div style="position:relative;height: 48px;width:447px;margin-top:72px;float:right;margin-right:40px;">\
        <div id="btn_right" tabindex="0" class="btn_all" data-key-enter="'+btnClickNotify+'(3);" style="margin-right:21px;">\
            <p >'+getTranslate("cancel")+'</p>\
        </div>\
        <div id="btn_left" tabindex="0" class="btn_all" data-key-enter="'+btnClickNotify+'(4);">\
            <p >'+getTranslate("clear")+'</p>\
        </div>\
        </div>\
        </div>'
        });
    }

    pvrDialog.show();
    $('#btn_left').focus();
}

playbackErrorDialog = null;
autoCloseplaybackErrorDialog_t = null;
function closePlaybackErrorDialog(){
    if(playbackErrorDialog && playbackErrorDialog != null){
        playbackErrorDialog.close().remove();
        playbackErrorDialog = null;
        if(autoCloseplaybackErrorDialog_t){
            clearTimeout(autoCloseplaybackErrorDialog_t);
        }
        return true;
    }
    return false;
}

function showPlaybackErrorDialog(errorInfo, closeNotify){
    console.log("showPlaybackErrorDialog errorInfo = " + errorInfo);
    if (errorInfo == "MAIN_MSG_HDR_SIGNAL_DETECTED")
    {
    	playbackErrorDialog = dialog({
	        id: 'playback_error_dialog',
	        height: 720,
	        width:1280,
	        autofocus:false,
	        content:'<div style="height: 59px;width: auto;float:right;margin-right:27px;padding-right: 30px;position: relative;margin-top:616px;border-radius: 29px;background-color: rgb(65,65,65);">\
	                          <div style="position:relative;float:left;height: 59px;width: auto;border-radius: 29px;padding-left: 29px;">\
	                            <span style="float:left;height: 59px;width: auto;position:relative;line-height:59px;margin:0px;color:white;font-size:23px;text-align:left;">'+getTranslate(errorInfo)+'</span>\
	                        </div>\
	                    </div>',

	    });
    }
	else
	{
	    playbackErrorDialog = dialog({
	        id: 'playback_error_dialog',
	        height: 720,
	        width:1280,
	        autofocus:false,
	        content:'<div style="height: 59px;width: auto;float:right;margin-right:27px;padding-right: 30px;position: relative;margin-top:616px;border-radius: 29px;background-color: rgb(65,65,65);">\
	                          <div style="position:relative;float:left;height: 59px;width: auto;border-radius: 29px;padding-left: 29px;">\
	                            <span style="float:left;height: 59px;width: auto;position:relative;line-height:59px;margin:0px;color:white;font-size:23px;text-align:left;">'+getTranslate(errorInfo)+'</span>\
	                        </div>\
	                            <img style="float:left;position:relative;left:20px;right:20px;top: 6px;" src="../2K16_4K_UX_Asset/Icons/icon_punched_127_Warning_Recording_Failed_n_48x48_px.png">\
	                    </div>',

	    });
	}
	if(autoCloseplaybackErrorDialog_t)		/* Stephen 180222 add for avoiding user play unplayable file repeatly and msg disapear suddenly */
    {
	    clearTimeout(autoCloseplaybackErrorDialog_t);
	    autoCloseplaybackErrorDialog_t = null;      
    }

    playbackErrorDialog.show();
    autoCloseplaybackErrorDialog_t = setTimeout(function () {
        if(closePlaybackErrorDialog()){
            if(closeNotify){
                closeNotify();
            }
           autoCloseplaybackErrorDialog_t = null; /* Stephen, 180409 , need reset avoid wrong case happen. EX: press back but music stop(should be keep play) */
        }

    }, 6000);

}

var noUsbDialog = null;
function showNoUsbDialog(){
    noUsbDialog = dialog({
        id: 'no_usb_dialog',
        height: 720,
        width:1280,
        content: '<div style="height: 59px;width: auto;float:right;margin-right:27px;padding-right: 30px;position: relative;margin-top:616px;border-radius: 29px;background-color: rgb(65,65,65);">\
                          <div style="position:relative;float:left;height: 59px;width: auto;border-radius: 29px;padding-left: 29px;">\
                            <span style="float:left;height: 59px;width: auto;position:relative;line-height:59px;margin:0px;color:white;font-size:23px;text-align:left;">'+getTranslate("No USB device connected")+'</span>\
                        </div>\
                            <img style="float:left;position:relative;left:20px;right:20px;top: 6px;" src="../2K16_4K_UX_Asset/Icons/icon_punched_127_Warning_Recording_Failed_n_48x48_px.png">\
                    </div>',

    });

    noUsbDialog.show();
}

function dms_wakeup_key_dispatch(isup, e){
    var id = e.target.id;
    var keynum = e.which || e.keyCode;
    var keyValue = '';
    switch(keynum){
        case KeyEvent.DOM_VK_LEFT:
        if (id == "") {
            return;
        }
        content = $(e.target).prev();
        if (content.length > 0) {
            content.focus();
        }

        break;
    case KeyEvent.DOM_VK_RETURN:
        if (id == "") {
            return;
        }
        if (isup) {
            var command = $(e.target).attr('data-key-enter');
            console.log("command = " + command);
            eval(command);
        }

        break;
    case KeyEvent.DOM_VK_RIGHT:
        if (id == "") {
            return;
        }
        content = $(e.target).next();
        if (content.length > 0) {
            content.focus();
        }
        break;
    default:
    break;
    }
}

var dmsWakeupDialog = null;
function showDMSWakeupDialog(){
    dmsWakeupDialog = dialog({
        id: 'dms_wakeup_dialog',
        modal:true,
        content: '<div style="height: auto;width: 859px;margin: 0 auto;position: relative;background-color: #1d1f21;">\
        <div style="height:85px;width:859px;position:relative;margin-bottom: 29px;">\
            <p class="dialog_title">DMS Wakeup Dialogue</p>\
            <div style="height:1px;width:100%;background-color: #ffffff;opacity: 0.1;position: absolute;bottom: 0px;"></div>\
        </div>\
        <div style="position: relative;width: 100%;z-index:2;">\
            <p class="dialog_content" style="width: 100%;position:relative;padding-left: 40px;margin:0px;text-align:left;">do you want to wakeup the dms</p>\
        </div>\
        <div style="position: relative;height: 75px;width: 100%;margin-top: 27px;margin-right: 40px;">\
            <div style="position: relative;height: 75px;width: 420px;float: right;margin-right: 40px;">\
                <div id="btn_left" tabindex="0" class="btn_all" data-key-enter="dmsWakeupBtnClick(1);" style="margin-right: 20px;width: 200px;">\
                    <p>'+getTranslate("ok")+'</p>\
                </div>\
                <div id="btn_right" tabindex="0" class="btn_all" data-key-enter="dmsWakeupBtnClick(2);" style="width: 200px;">\
                    <p>'+getTranslate("cancel")+'</p>\
                </div>\
            </div>\
        </div>\
    </div>',

    });

    dmsWakeupDialog.show();
    $('#btn_left').focus();
}

var stopInfoDialog = null;

function closeStopInfoDialog() {
    if (stopInfoDialog && stopInfoDialog != null ) {
        stopInfoDialog.close().remove();
        stopInfoDialog = null ;
    }
}

function isStopInfoDialogShow() {
    if (stopInfoDialog && stopInfoDialog != null ) {
        return true;
    } else {
        return false;
    }
}

function showStopInfoDialog(btnNotify){
    stopInfoDialog = dialog({
        id: 'playback_stop_info_dialog',
        modal:true,
        content: '<div style="height: auto;width: 859px;margin: 0 auto;position: relative;background-color: #1d1f21;">\
                    <div style="height:85px;width:859px;position:relative;margin-bottom: 29px;">\
                        <p class="dialog_title">'+getTranslate("MAIN_TI_VIDEO_RESUME_RESTART")+'</p>\
                        <div style="height:1px;width:100%;background-color: #ffffff;opacity: 0.1;position: absolute;bottom: 0px;"></div>\
                    </div>\
                    <div style="position: relative;display: inline-flex;height: auto;width: 100%;">\
                        <p class="dialog_content" style="width: 100%;position:relative;padding-left: 40px;margin:0px;text-align:left;">'+getTranslate("qt_playback_begining")+'</p>\
                    </div>\
                    <div style="position: relative;height: 75px;width: 100%;margin-top: 27px;margin-right: 40px;">\
                        <div style="position: relative;height: 75px;width: 420px;float: right;margin-right: 40px;">\
                            <div id="btn_left" tabindex="0" class="btn_all" data-key-enter="'+btnNotify+'(1);" style="margin-right: 20px;width: 200px;">\
                                <p>'+getTranslate("ok")+'</p>\
                            </div>\
                            <div id="btn_right" tabindex="0" class="btn_all" data-key-enter="'+btnNotify+'(2);" style="width: 200px;">\
                                <p>'+getTranslate("qt_resume")+'</p>\
                            </div>\
                        </div>\
                    </div>\
                </div>',

    });

    stopInfoDialog.show();
    $('#btn_left').focus();
}