var GlobalContentBrowserObj = function() {
    this.ShowMode = {Browser: 0,MusicPlay: 1,PhotoPlay: 2,VideoPlay: 3,MusicAndPhotoPlay: 4};
    this.curShowMode = this.ShowMode.Browser;

};

GlobalContentBrowserObj.prototype.getPlayObject = function() {
    var obj = null;
    switch (this.curShowMode) {
        case this.ShowMode.MusicPlay:
            obj = musicPlayObj;
            break;
        case this.ShowMode.PhotoPlay:
            obj = photoPlayObj;
            break;
        case this.ShowMode.VideoPlay:
            obj = videoPlayObj;
            break;

    }
    return obj;
};

GlobalContentBrowserObj.prototype.stopPlay = function() {
    console.log("stopPlay");
    var obj = null;
    switch (this.curShowMode) {
        case this.ShowMode.MusicPlay:
            musicPlayObj.stopMusic();
            break;
        case this.ShowMode.PhotoPlay:
            photoPlayObj.playStop();
            break;
        case this.ShowMode.VideoPlay:
            videoPlayObj.playStop();
            break;
        case this.ShowMode.MusicAndPhotoPlay:
            musicPlayObj.stopMusic();
            photoPlayObj.playStop();
            break;

    }
    if (musicPlayObj.curDisplayMode != musicDisplayMode.none) {
        musicPlayObj.stopMusic();
    }
};

GlobalContentBrowserObj.prototype.dmrPlayExit = function() {
    window.dmrUtil.removeListener();
    history.go(-1);
};

GlobalContentBrowserObj.prototype.doStop = function() {
    var obj = null;
    switch (this.curShowMode) {
        case this.ShowMode.MusicPlay:
            musicPlayObj.stopPlay();
            break;
        case this.ShowMode.PhotoPlay:
            photoPlayObj.imgDeinit();
            break;
        case this.ShowMode.VideoPlay:
            videoPlayObj.videoDelInit();
            break;
        case this.ShowMode.MusicAndPhotoPlay:
            musicPlayObj.stopPlay();
            photoPlayObj.imgDeinit();
            break;

    }
};

GlobalContentBrowserObj.prototype.refreshCbUi = function(refType) {
    switch (refType) {
        case 1: //no usb -> usb
            if (noUsbDialog) {
                noUsbDialog.close().remove();
                noUsbDialog = null;
            }
            waitLoading(true);
            setTimeout(function() {
                initUsb();
            }, 100);
            break;
        case 2:
            mtvuiUtil.exitMenu();
            fileObj = new File_obj();
            var children = $('#footer').find('li');
            for (var i = 0; i < children.length; i++) {
                var text = $(children[i]).text();
                var htmltext = $(children[i]).html();
                var html = htmltext.substring(0, htmltext.lastIndexOf(text));
                $(children[i]).html(html);
            }
            $('#list_nav_next').hide();
            $('#list_nav_prev').hide();
            $('#video_play_content').hide();
            $('#photo_play_layout').hide();
            $('#music_player_bg').hide();
            $('#browser_and_audio_play').show();
            keyUpNotify = keyUpDispath;
            keyDownNotify = keyDownDispath;
            change_folder_nav();
            initUsb();
            closeAllDialog();
            break;
    }
};

GlobalContentBrowserObj.prototype.showBrowser = function() {
    if (this.curShowMode == this.ShowMode.Browser && $('browser_and_audio_play').is(':visible')) {
        console.log("this.curShowMode == this.ShowMode.Browser");
        return;
    }
    if (this.curShowMode == this.ShowMode.MusicAndPhotoPlay) {
        this.curShowMode = this.ShowMode.MusicPlay;
        mtvObj.acfgSetConfigItemValue(stvapi_config.mmp_play_state, icl_mmp_play_status.audio);
        console.log("musicPlayObj.curDisplayMode = " + musicPlayObj.curDisplayMode);
        if (musicPlayObj.curDisplayMode == musicDisplayMode.hidePlay) {
            setMusicPlayerModeTimer(6000, musicDisplayMode.simplePlay);
        } else {
            setMusicPlayerModeTimer(0);
        }
    } else {
        this.curShowMode = this.ShowMode.Browser;
    }
    mtvObj.acfgSetConfigItemValue(stvapi_config.mmp_play_state, icl_mmp_play_status.on);
    closeDialog();
    $('#video_play_content').hide();
    $('#photo_play_layout').hide();
    $('#music_player_bg').hide();
    $('#browser_and_audio_play').show();
    keyUpNotify = keyUpDispath;
    keyDownNotify = keyDownDispath;

    if ($('#video_album_container').is(":visible")) {
        $('#video_album_container').focus();
    } else if (fileObj.infoList[fileObj.focusIndex].MEDIA_TYPE == MEDIA_TYPE.photoObj || $('#photo_album_container').is(":visible")) {
        $('#photo_album_container').focus();
    } else {
        cur_focus_id = -1;
        doRefreshLayout();
    }

    if (mtvuiUtil.isMenuShow()) {
        mtvuiUtil.storeFocus();
        mtvuiUtil._menuFrame.focus();
    }
};

GlobalContentBrowserObj.prototype.startPlayback = function(obj, curPlayObj, isPlayAll) {
    if (obj.curSourceType == SourceType.Dmp) {
        var mediaType = curPlayObj.mediaType;
        switch (mediaType) {
            case 1:
                this.playPhoto(obj, isPlayAll);
                break;
            case 2:
                this.playMusic(obj, SourceType.Dmp, isPlayAll);
                break;
            case 3:
                this.playVideo(obj, SourceType.Dmp, isPlayAll);
                break;
            default:
                this.showBrowser();
                break;
        }

    }
};

GlobalContentBrowserObj.prototype.playMusic = function(obj, sourceType, isPlayAll) {
    try {
        if (this.curShowMode != this.ShowMode.MusicPlay) {
            this.curShowMode = this.ShowMode.MusicPlay;
            $('#browser_and_audio_play').hide();
            $('#video_play_content').hide();
            $('#photo_play_layout').hide();
            $('#music_player_bg').show();
            closeDialog();
            clearThumbnail();
            keyUpNotify = keyUpDispath;
            keyDownNotify = keyDownDispath;
        }
        cur_focus_id = -1;
        musicPlayObj.init(obj, sourceType, isPlayAll);
    } catch (e) {
        console.log(e);
        waitLoading(false);
    }
};

GlobalContentBrowserObj.prototype.playPhoto = function(playObj, isPlayAll) {
    if (this.curShowMode != this.ShowMode.PhotoPlay) {
        if (this.curShowMode == this.ShowMode.MusicPlay) {
            this.curShowMode = this.ShowMode.MusicAndPhotoPlay;
        } else {
            this.curShowMode = this.ShowMode.PhotoPlay;
        }
        clearThumbnail();
        closeDialog();
        $('#browser_and_audio_play').hide();
        $('#music_player_bg').hide();
        $('#video_play_content').hide();
        $('#photo_play_layout').show();
        keyDownNotify = photo_player_key_dispatch;
        keyUpNotify = photo_play_key_up_dispatch;
    }
    photoPlayObj.init(playObj, isPlayAll);
    //mtvObj.acfgSetConfigValue("g_custom_base__osd3_enable",false); /* Stephen 180111 TF518PHILTMTK02-358 picture shake*/ 
	mtvObj.acfgGetConfigValue("g_video__letterbox_status_check");  /* Stephen 180206 TF3B18PHIKRMTK01-1346,letterbox won't be active on ICL_MMP_MEDIA_PLAY_STATUS_PHOTO */
};

GlobalContentBrowserObj.prototype.playVideo = function(obj, sourceType, isPlayAll) {
    try {
        if (this.curShowMode != this.ShowMode.VideoPlay) {
            clearThumbnail();
            closeDialog();
            this.curShowMode = this.ShowMode.VideoPlay;
            $('#browser_and_audio_play').hide();
            $('#music_player_bg').hide();
            $('#photo_play_layout').hide();
            $('#video_play_content').show();
            keyDownNotify = video_play_key_dispatch;
            keyUpNotify = video_play_key_up_dispatch;
        }
        videoPlayObj.init(obj, sourceType, isPlayAll);
    } catch (e) {
        console.log(e);
        waitLoading(false);
    }
};

GlobalContentBrowserObj.prototype.usbAddDetect = function() {
    console.log("usbAddDetect");
    switch (this.curShowMode) {
        case this.ShowMode.MusicPlay:
            musicPlayObj.switchDisMusicplayerMode(musicDisplayMode.backgroundPlay);
            break;
        case this.ShowMode.PhotoPlay:
            photoPlayObj.playStop();
            break;
        case this.ShowMode.VideoPlay:
            videoPlayObj.playStop();
            break;
        case this.ShowMode.MusicAndPhotoPlay:
            photoPlayObj.playStop();
            break;
        default:
            initUsb();
            break;

    }
};

GlobalContentBrowserObj.prototype.updateData = function() {
    videoObj.isinit = false;
    if (this.curShowMode == this.ShowMode.Browser || this.curShowMode == this.ShowMode.MusicPlay) {
        switch (curObjectType) {
            case "musicObj":
                cur_focus_id = -1;
                musicObj.sortMode = null;
                doRefreshLayout();
                break;
            case "photoObj":
                cur_focus_id = -1;
                var temp = photoObj.sortMode;
                photoObj.sortMode = null;
                doPhotoSort(temp);
                break;
            case "videoObj":
                cur_focus_id = -1;
                curObjectType = null;
                doRefreshLayout();
                break;
            case "top_menu_3":

                break;
        }
    }

};

GlobalContentBrowserObj.prototype.clearStopMusic = function() {
    switch (this.curShowMode) {
        case this.ShowMode.Browser:

            break;
        case this.ShowMode.PhotoPlay:
            setItemColorKey($('#photo_play_footer li:nth-child(3)'), '', false);
            break;

    }
}

var contentBrowserObj = new GlobalContentBrowserObj();