var BrowserType = {Usb: 0,Dlna: 1};
var curBrowserType = BrowserType.Usb;

var SourceType = {Usb: 0,Pvr: 1,Dmp: 2,Dmr: 3,SuperShop: 4,Pus: 5,MultiRoom: 6};

var NotifyURI = {
    Cmpb: '/tv/ws/notify/cbrowser_playback',
    Dms: '/tv/ws/notify/dlna_dms',
    Dmr: '/tv/ws/notify/dlna_dmr',
    Usb: '/tv/ws/notify/usb_detect',
    Volume: '/tv/ws/notify/volume_ctrl'
};

var stvapi_config = {
    mmp_play_state: 120717316,	/* 180402: old:118620164 */
    mmp_source_type: 120717315 	/* 180402: old:118620163 */
};

var icl_mmp_play_status = {
    off: 0,
    on: 1,
    photo: 2,
    audio: 3,
    video: 4
};

var icl_mmp_source_type = {
    off: 0,
    usb: 1,
    dmp: 2,
    dmr: 3,
    pvr: 4,
    multiroom: 5
};

var otherColorKeyData = [{"show": true,"name": ""}, {"show": true,"name": ""}, {"show": true,"name": ""}, {"show": true,"name": "Help"}, {"show": true,"name": ""}, {"show": false,"name": "Info"}];
var photoColorKeyData = [{"show": true,"name": "Slide Show"}, {"show": true,"name": "Sort"}, {"show": true,"name": ""}, {"show": true,"name": "Help"}, {"show": true,"name": ""}, {"show": true,"name": "Info"}];
var videoColorKeyData = [{"show": true,"name": "Play All"}, {"show": true,"name": ""}, {"show": true,"name": "USB Device"}, {"show": true,"name": "Help"}, {"show": true,"name": ""}, {"show": true,"name": "Info"}];
var musicColorKeyData = [{"show": true,"name": "Play All"}, {"show": true,"name": ""}, {"show": true,"name": "USB Device"}, {"show": true,"name": "Help"}, {"show": true,"name": ""}, {"show": true,"name": "Info"}];
var usbColorKeyData = [{"show": true,"name": ""}, {"show": true,"name": ""}, {"show": true,"name": "USB Device"}, {"show": true,"name": "Help"}, {"show": true,"name": ""}, {"show": false,"name": "Info"}];
var dlnaColorKeyData = [{"show": true,"name": ""}, {"show": true,"name": ""}, {"show": true,"name": "Media Server"}, {"show": true,"name": "Help"}, {"show": true,"name": ""}, {"show": false,"name": "Info"}];

var playerColorKeyData = ["Play All", "Shuffle On", "", "Help", "", "Info"];
var musicPlayerColorKeyData = ["Play All", "Shuffle On", "", "Help", "", ""];
var photoPlayerColorKeyData = ["Slide Show", "Rotate", "", "Help", "", ""];

var DmrKeyList = [KeyEvent.DOM_VK_INFO, KeyEvent.DOM_VK_OPTION, KeyEvent.DOM_VK_RETURN, KeyEvent.DOM_VK_SUBTITLE, KeyEvent.DOM_VK_FAST_FWD, KeyEvent.DOM_VK_REWIND, KeyEvent.DOM_VK_LEFT, KeyEvent.DOM_VK_RIGHT,
    KeyEvent.DOM_VK_BLUE, KeyEvent.DOM_VK_PLAY, KeyEvent.DOM_VK_PAUSE, KeyEvent.DOM_VK_STOP, KeyEvent.DOM_VK_DOWN, KeyEvent.DOM_VK_UP, KeyEvent.DOM_VK_OK, KeyEvent.DOM_VK_LIST];
var SuperShopKeyList = [KeyEvent.DOM_VK_OPTION, KeyEvent.DOM_VK_RETURN, KeyEvent.DOM_VK_LEFT, KeyEvent.DOM_VK_RIGHT, KeyEvent.DOM_VK_DOWN, KeyEvent.DOM_VK_UP, KeyEvent.DOM_VK_BACK];

var bottomBarKeyList = [KeyEvent.DOM_VK_RED, KeyEvent.DOM_VK_GREEN, KeyEvent.DOM_VK_YELLOW, KeyEvent.DOM_VK_BLUE, KeyEvent.DOM_VK_OPTION];

var SlideshowTime = {
    Short: 3000,
    Medium: 5000,
    Long: 7000
};

var CLEAR_OFF_DMS = "Clear offline servers";
var STOP_MUSIC = 'Stop music';

var PlayAll = ["Play One", "Play All"];
var SlideShow = ["Start Slide Show", "Stop Slide Show"];
var Automatic = ["Automatic", "On during mute"];
var Shuffle = {"name": "Shuffle",'needSelected': true,"curValue": 0,"value": ["Shuffle Off", "Shuffle On"],"showValue": []};
var Repeat = {"name": "Repeat",'needSelected': true,"curValue": 0,"value": ["Play Once", "Repeat"]};
if(get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR)	/*  Follow 180308 2k18 Philips 5802 KR _ OOB*/
{
	var Subtitles = {"name": "Subtitles",'needSelected': true,"curValue": 1,"value": ["Subtitles Off", "Subtitles On", "On during mute"]};
	var Character_set = {"name": "Character set",'needSelected': true,"curValue": 6,"value": ['Western Europe', 'Turkish', 'Central Europe', 'Cyrillic', 'Greek', 'UTF-8 (Unicode)', 'Korean']};
}
else
{

	var Subtitles = {"name": "Subtitles",'needSelected': true,"curValue": 0,"value": ["Subtitles Off", "Subtitles On", "On during mute"]};
	var Character_set = {"name": "Character set",'needSelected': true,"curValue": 0,"value": ['Western Europe', 'Turkish', 'Central Europe', 'Cyrillic', 'Greek', 'UTF-8 (Unicode)']};

}
var Slideshow_Time = {"name": "Slideshow Time",'needSelected': true,"curValue": 0,"value": ["Short", "Medium", "Long"]};
var Slideshow_Transition = {"name": "Slideshow Transition",'needSelected': true,"curValue": 0,"value": ["None", "Dissolve", "Wipe left", "Wipe right", "Wipe up", "Wipe down", "Box in", "Box out"]};
//var Character_set = {"name": "Character set",'needSelected': true,"curValue": 0,"value": ['Western Europe', 'Turkish', 'Central Europe', 'Cyrillic', 'Greek', 'UTF-8 (Unicode)']};
var Font_Size = {"name": "Font Size",'needSelected': true,"curValue": 1,"value": ['Small', 'Standard', 'Big']};
var Subtitles_Language = {"name": "Subtitles Language",'needSelected': true,"curValue": 0,"storage": 0,"value": []};
var Subtitles_Color = {"name": "Subtitle Color",'needSelected': true,"curValue": 0,"value": ['White', 'Blue', 'Red', 'Green', 'Yellow', 'Black']};
var Subtitles_Display = {"name": "Subtitle Position",'needSelected': true,"curValue": 2,"storage": 0,"value": ['-2', '-1', '0', '1', '2']};
var Time_Offset = {"name": "Time sync offset",showMode:1,'needSelected': true,"curValue": 0,"storage": 1,"value": {'minValue':-5, 'maxValue':5, 'stepValue':0.5,}};
var Status = {"name": "Status","curValue": 0,"value": []};
var Audio_Language = {"name": "Audio language",'needSelected': true,"storage": 0,"curValue": 0,"value": []};
var Subtitle_Setting = {"name": "Subtitle Setting",'hasSubmenu': true,"storage": -1,"curValue": 0,"value": [Font_Size, Subtitles_Color, Subtitles_Display]};
var VideoShowMode = {"name": "List/Thumbnails","storage": -1,'needSelected': true,"curValue": 1,"value": ['List', 'Thumbnails']};
var PhotoShowMode = {"name": "List/Thumbnails","storage": -1,'needSelected': true,"curValue": 1,"value": ['List', 'Thumbnails']};
var Closed_Captions = {"name": "Closed captions",'needSelected': true,"curValue": 0,"value": ["Off", "On", "On during mute"]};
var Caption_Service ={"name":"Caption service",'needSelected': true,"curValue": 0,"value": ["CC1", "CC2", "CC3","CC4","CC5","CC6","CC7","CC8"]};
var Caption_Service_ATSC ={"name":"Caption service",'needSelected': true,"curValue": 0,"value": ["CS-1", "CS-2", "CS-3","CS-4","CS-5","CS-6"]};

var ALL_OPTION_DATA = {"name": "Options","value": [Shuffle, Repeat, Subtitles, Slideshow_Time, Slideshow_Transition]};
var MUSIC_OPTION_DATA = {"name": "Options","value": [Shuffle, Repeat]};
var MOVIE_OPTION_DATA = {"name": "Options","value": [VideoShowMode, Subtitles, Shuffle, Repeat]};
var PHOTO_OPTION_DATA = {"name": "Options","value": [PhotoShowMode, Shuffle, Repeat, Slideshow_Time, Slideshow_Transition]};
var PHOTO_MUSIC_OPTION_DATA = {"name": "Options","value": [PhotoShowMode, Shuffle, Repeat, STOP_MUSIC, Slideshow_Time, Slideshow_Transition]};
var FOLDER_OPTION_DATA = {"name": "Options","value": [Subtitles, Shuffle, Repeat, Slideshow_Time, Slideshow_Transition]};
var PHOTO_PLAYER_OPTION_DATA = {"name": "Options","value": [Shuffle, Repeat, Slideshow_Time, Slideshow_Transition]};
var PHOTO_PLAYER_MUSIC_OPTION_DATA = {"name": "Options","value": [Shuffle, Repeat, STOP_MUSIC, Slideshow_Time, Slideshow_Transition]};
var MUSIC_PLAYER_OPTION_DATA = {"name": "Options","value": [Repeat]};
var OPTION_DATA = {"name": "Options","value": []};
var MOVIE_PLAYER_OPTION_VALUE = [Subtitles
        , Subtitles_Language
        , Character_set
        , Audio_Language
        , "Status"
        , Repeat
        , Subtitle_Setting];

var PVR_OPTTION_VALUE = [
        Subtitles
        , Subtitles_Language
        , Audio_Language
    ];

var PVR_KR_OPTTION_VALUE = [
		Closed_Captions
		, Caption_Service_ATSC
		, Audio_Language
	];

var PVR_LT_OPTTION_VALUE = [
		Closed_Captions
		, Caption_Service
		, Audio_Language
	];
	
var DLNA_OPTTION_VALUE = [
        Subtitles
        , Subtitles_Language
        , Character_set
        , Audio_Language
    ];

var ALL_SORT_DATA = {
    "Music": ["Artist", "Album", "Genre", "Track"],
    "Photo": ["Day", "Month", "Year", "A-Z", "Z-A"],
};

var MUSIC_TRACK_SORT = 'Track';

var MEDIA_TYPE = {
    NULL: 0,
    Photo: 1,
    Music: 2,
    Video: 3,
    Folder: 4,
    PlayList: 5,
    SuperShop: 6,
    rootObj: 100,
    photoObj: 101,
    musicObj: 102,
    videoObj: 103,
    folderObj: 104,
    musicList: 120,
    musicArtist: 121,
    musicAlbum: 122,
    musicGenre: 123,
    musicTrack: 124,
    photoList: 110
};

var usb_object = [
    {LABEL: 'Folder','MEDIA_TYPE': MEDIA_TYPE.folderObj,MEDIA_INDEX: 0},
    {LABEL: 'Video','MEDIA_TYPE': MEDIA_TYPE.videoObj,MEDIA_INDEX: 1},
    {LABEL: 'Photo','MEDIA_TYPE': MEDIA_TYPE.photoObj,MEDIA_INDEX: 2},
    {LABEL: 'Music','MEDIA_TYPE': MEDIA_TYPE.musicObj,MEDIA_INDEX: 3}
];
var MUSIC_SORT_TYPE = {
    Artist: 3,
    Album: 5,
    Genre: 7,
    Track: 9
};

var musicSortObj = [
    {LABEL: "Artist",'MEDIA_TYPE': MEDIA_TYPE.musicArtist,MEDIA_INDEX: 0},
    {LABEL: "Album",'MEDIA_TYPE': MEDIA_TYPE.musicAlbum,MEDIA_INDEX: 1},
    {LABEL: "Genre",'MEDIA_TYPE': MEDIA_TYPE.musicGenre,MEDIA_INDEX: 2},
    {LABEL: "Track",'MEDIA_TYPE': MEDIA_TYPE.musicTrack,MEDIA_INDEX: 3}
];

var PHOTO_SORT_TYPE = {
    'A-Z': 1,
    'Z-A': 2,
    Year: 6,
    Month: 8,
    Day: 10
};

var VIDEO_SORT_TYPE = 1;

var ALL_PAGE_NUM = {
    Music: 13,
    Music_List: 13,
    Video: 9,
    VideoList:13,
    Photo: 12,
    PhotoList: 13
};

var ALL_PAGE_ROW_NUM = {
    Music: 3,
    Video: 3,
    Photo: 4
};

var SHOW_MODE = {
    Thumbnails: 1,
    List: 2
};

var musicDisplayMode = {none: 0,backgroundPlay: 1,hidePlay: 2,simplePlay: 3,minimised: 4};

var SuperShopObj = function() {
    this.totalNum;
    this.infoList;
    this.mediatype = MEDIA_TYPE.SuperShop;
    this.focusIndex = 0;
    this.curSourceType = SourceType.SuperShop;
};

SuperShopObj.prototype.init = function() {
    this.totalNum = usbObj.getCbDbCount(this.mediatype);
    this.getOnePageInfo();
};

SuperShopObj.prototype.getOnePageInfo = function() {
    console.log("SuperShopObj getOnePageInfo");
    if (!this.infoList) {
        this.infoList = [];
    }
    if (this.infoList.length >= this.totalNum) {
        console.log("this.infoList.length >= this.totalNum return");
        return;
    }
    var count = (this.totalNum - this.infoList.length > 10) ? 10 : (this.totalNum - this.infoList.length);
    this.infoList = this.infoList.concat(usbObj.getContentBrowserPageData(this.infoList.length, count, this.mediatype, usbObj.USB_PATH));
};

SuperShopObj.prototype.getPlayInfo = function(paramObj) {
    var isNext = paramObj.isNext;
    var isRepeat = paramObj.isRepeat;
    console.log("SuperShopObj getPlayInfo isNext = " + isNext + ";isRepeat = " + isRepeat);
    ret = null;
    console.log("this.focusIndex = " + this.focusIndex);
    if (typeof (isNext) == 'undefined') {
        ret = this.infoList[this.focusIndex];
    } else {
        if (isNext) {
            tempNum = this.focusIndex + 1;
            if (tempNum < this.totalNum) {
                if (tempNum >= this.infoList.length) {
                    this.getOnePageInfo();
                }
                this.focusIndex++;
                ret = this.infoList[this.focusIndex];
            } else if (isRepeat) {
                this.focusIndex = 0;
                ret = this.infoList[0];
            }
        } else {
            if (this.focusIndex > 0) {
                this.focusIndex--;
                ret = this.infoList[this.focusIndex];
            }
        }
    }
    return ret;
};
var superShopObj;

var Music_page = function() {
    this.submenuData = [];
    this.allNum;
    this.needAllOpt = true;
    this.submenuInfo;
}

Music_page.prototype.init = function(mode) {
    this.allNum = usbObj.getCbDbCount(MEDIA_TYPE.Music);
    this.submenuData = [];
    this.submenuInfo = {total_num:0, noData:false, hasOther:false, objectType:MEDIA_TYPE.musicList};
    if (this.allNum > 0) {
        if (MUSIC_SORT_TYPE.Track == MUSIC_SORT_TYPE[mode]) {
            this.submenuData = usbObj.getSubmenuStr(MEDIA_TYPE.Music, MUSIC_SORT_TYPE[mode], this.needAllOpt);
        } else {
            if(this.needAllOpt){
                this.submenuData.push({LABEL: 'All', MEDIA_TYPE: this.submenuInfo.objectType});
            }
            var temp = usbObj.getSubmenuList(MEDIA_TYPE.Music, MUSIC_SORT_TYPE[mode], this.submenuInfo);
            this.submenuData = this.submenuData.concat(temp);
        }
    }
};

Music_page.prototype.tryGetSubmenu = function(mode) {
    if (MUSIC_SORT_TYPE.Track == MUSIC_SORT_TYPE[mode]) {
        return;
    }
    if (this.allNum > 0 && !this.submenuInfo.noData) {
        var temp = usbObj.getSubmenuList(MEDIA_TYPE.Music, MUSIC_SORT_TYPE[mode], this.submenuInfo);
        this.submenuData = this.submenuData.concat(temp);
    }
};

var Music_obj = function() {
    this.usbPath;
    this.totalNum;
    this.sortObj = musicSortObj;
    this.sortMode;
    this.infoList;
    this.submenuSelectedIdx;
    this.pageIndex;
    this.focusIndex;
    this.pageIndicatorNum;
    this.curSourceType = SourceType.Usb;
    this.pageInfo = new Music_page();
};

Music_obj.prototype.setTotalNum = function(num) {
    this.totalNum = num;
};

Music_obj.prototype.setSortMode = function(mode) {
    this.sortMode = mode;
};

Music_obj.prototype.setInfoList = function(list) {
    this.infoList = list;
};

Music_obj.prototype.setSubmenuSelectedIdx = function(index) {
    this.submenuSelectedIdx = index;
};

Music_obj.prototype.setPageIndex = function(index) {
    this.pageIndex = index;
    this.needRefresh = true;
};

Music_obj.prototype.setPageIndicatorNum = function(num) {
    this.pageIndicatorNum = num;
};

Music_obj.prototype.switchMode = function(mode) {

}

Music_obj.prototype.init = function(mode) {
    this.usbPath = usbObj.USB_PATH;
    if (mode) {
        this.setSortMode(mode);
    }
    this.pageInfo.init(this.sortMode);
    this.initBySubmenu(0);
};

Music_obj.prototype.initBySubmenu = function(index) {
    if (this.pageInfo.needAllOpt && index == 0) {
        this.setTotalNum(this.pageInfo.allNum);
    } else {
        this.totalNum = usbObj.getUsbTopListDbCount(MEDIA_TYPE.Music, MUSIC_SORT_TYPE[this.sortMode], this.pageInfo.submenuData[index].LABEL, this.usbPath);
    }
    this.infoList = [];
    this.setSubmenuSelectedIdx(index);
    this.setPageIndex(0);
    if (MUSIC_TRACK_SORT == this.sortMode) {
        this.setPageIndicatorNum(Math.ceil(this.totalNum / ALL_PAGE_NUM.Music));
    } else {
        this.setPageIndicatorNum(this.pageInfo.submenuData.length);
    }
    this.getOnePageInfo();
};
Music_obj.prototype.getOnePageInfo = function() {
    console.log("Music_obj getOnePageInfo");
    if (!this.infoList) {
        this.infoList = [];
    }
    if (this.infoList.length >= this.totalNum) {
        console.log("this.infoList.length >= this.totalNum return");
        return;
    }
    var onePageNum = (MUSIC_TRACK_SORT == this.sortMode) ? ALL_PAGE_NUM.Music : ALL_PAGE_NUM.Music_List;
    var count = (this.totalNum - this.infoList.length > onePageNum) ? onePageNum : (this.totalNum - this.infoList.length);
    if (this.pageInfo.needAllOpt && this.submenuSelectedIdx == 0) {
        this.infoList = this.infoList.concat(usbObj.getContentBrowserPageData(this.infoList.length, count, MEDIA_TYPE.Music, MUSIC_SORT_TYPE[this.sortMode], this.usbPath));
    //this.setInfoList(this.pageInfo.allInfoData);
    } else {
        this.infoList = this.infoList.concat(usbObj.getPagetDataBySubmenu(this.infoList.length, count, MEDIA_TYPE.Music, MUSIC_SORT_TYPE[this.sortMode], this.pageInfo.submenuData[this.submenuSelectedIdx].LABEL, this.usbPath));
    }

};
Music_obj.prototype.getContentInfo = function(reqCount) {
    console.log("Music_obj getContentInfoByType");
    if (this.infoList.length >= this.totalNum) {
        console.log("this.infoList.length >= this.totalNum return");
        return;
    }
    if (typeof (reqCount) == 'undefined') {
        reqCount = (this.totalNum - this.infoList.length);
    }
    if (reqCount > (this.totalNum - this.infoList.length)) {
        reqCount = (this.totalNum - this.infoList.length);
    }
    if (this.pageInfo.needAllOpt && this.submenuSelectedIdx == 0) {
        this.infoList = this.infoList.concat(usbObj.getContentBrowserPageData(this.infoList.length, reqCount, MEDIA_TYPE.Music, MUSIC_SORT_TYPE[this.sortMode], this.usbPath));
    //this.setInfoList(this.pageInfo.allInfoData);
    } else {
        this.infoList = this.infoList.concat(usbObj.getPagetDataBySubmenu(this.infoList.length, reqCount, MEDIA_TYPE.Music, MUSIC_SORT_TYPE[this.sortMode], this.pageInfo.submenuData[this.submenuSelectedIdx].LABEL, this.usbPath));
    }
};
Music_obj.prototype.getShuffleItemInfo = function(startIndex) {
    var ret = null;
    if (typeof (startIndex) == 'undefined') {
        startIndex = getRandom(0, this.totalNum - 1);
    }
    console.log("getShuffleItemInfo startIndex = " + startIndex);
    if (startIndex >= this.infoList.length) {
        this.getContentInfo(startIndex - this.infoList.length + 1);
    }
    if (this.pageInfo.needAllOpt && this.submenuSelectedIdx == 0) {
        ret = usbObj.getContentBrowserPageData(startIndex, 1, MEDIA_TYPE.Music, MUSIC_SORT_TYPE[this.sortMode], this.usbPath);
    } else {
        ret = usbObj.getPagetDataBySubmenu(startIndex, 1, MEDIA_TYPE.Music, MUSIC_SORT_TYPE[this.sortMode], this.pageInfo.submenuData[this.submenuSelectedIdx].LABEL, this.usbPath);
    }
    if (ret) {
        return ret[0];
    } else {
        return null;
    }
};
Music_obj.prototype.getPlayIndex = function() {
    return this.focusIndex;
};
Music_obj.prototype.getPlayInfo = function(paramObj) {
    var isNext = paramObj.isNext;
    var isRepeat = paramObj.isRepeat;
    var isShuffle = paramObj.isShuffle;
    var isPlayAll = paramObj.isPlayAll;
    console.log("Music_obj getPlayInfo isNext = " + isNext + ";isRepeat = " + isRepeat + ";isShuffle = " + isShuffle);
    ret = null;
    var listIndex = Number(this.playIndex);
    console.log("listIndex = " + listIndex);
    if (typeof (isNext) == 'undefined') {
        this.playIndex = this.focusIndex;
        listIndex = this.playIndex;
        this.sortIndexArr = [];
        for (var i = 0; i < this.totalNum; i++) {
            this.sortIndexArr[i] = i;
        }
        this.sortIndexArr.splice(listIndex, 1);
        ret = this.infoList[listIndex];
    } else if (isShuffle) {
        if (isRepeat) {
            var startIndex = getRandom(0, this.totalNum - 1);
            ret = this.getShuffleItemInfo(startIndex);
            this.playIndex = startIndex;
        } else {
            if (this.sortIndexArr.length > 0) {
                var startIndex = getRandom(0, this.sortIndexArr.length - 1);
                ret = this.getShuffleItemInfo(this.sortIndexArr[startIndex]);
                this.playIndex = this.sortIndexArr[startIndex];
                this.sortIndexArr.splice(startIndex, 1);
            }
        }
    } else {
        if (isNext) {
            tempNum = listIndex + 1;
            if (tempNum < this.totalNum) {
                if (tempNum >= this.infoList.length) {
                    this.getOnePageInfo();
                }
                this.playIndex++;
                ret = this.infoList[this.playIndex];
            } else if (isRepeat) {
                this.playIndex = 0;
                ret = this.infoList[0];
            }
        } else {
            if (this.playIndex > 0) {
                this.playIndex--;
                ret = this.infoList[this.playIndex];
            } else if (isPlayAll && isRepeat) {
                this.playIndex = this.totalNum - 1;
                if (this.playIndex >= this.infoList.length) {
                    ret = this.getShuffleItemInfo(this.playIndex);
                } else {
                    ret = this.infoList[this.playIndex];
                }
            }

        }
    }
    this.focusIndex = this.playIndex;
    return ret;
};

var Video_page = function() {
    this.submenuData = [];
    this.allNum;
    this.allInfoData;
    this.allPageListData;
    this.needAllOpt = true;
}
Video_page.prototype.init = function() {
    this.allNum = usbObj.getCbDbCount(MEDIA_TYPE.Video);
    this.submenuData = [];
    if (this.allNum > 0) {
        this.submenuData = usbObj.getSubmenuStr(MEDIA_TYPE.Video, VIDEO_SORT_TYPE, this.needAllOpt);
    }
//this.allInfoData = getContentBrowserData(MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[mode]);

};
var Video_obj = function() {
    this.totalNum;
    this.infoList;
    this.pageIndex;
    this.pageIndicatorNum;
    this.submenuSelectedIdx;
    this.focusIndex;
    this.curSourceType = SourceType.Usb;
    this.pageInfo = new Video_page();
    this.needRefresh = true;
    //this.isinit = false;
    this.showMode = this.getShowMode();
};
Video_obj.prototype.getShowMode = function() {
    return mtvObj.acfgGetConfigValue('g_misc__cb_vid_view_mode') ? SHOW_MODE.List : SHOW_MODE.Thumbnails;
};
Video_obj.prototype.setShowMode = function(value) {
    this.showMode = value;
    mtvObj.acfgSetConfigValue('g_misc__cb_vid_view_mode', (this.showMode == SHOW_MODE.List ? 1 : 0));
};
Video_obj.prototype.setTotalNum = function(num) {
    this.totalNum = num;
};
Video_obj.prototype.setInfoList = function(list) {
    this.infoList = list;
};
Video_obj.prototype.setPageIndex = function(index) {
    this.pageIndex = index;
    this.needRefresh = true;
};
Video_obj.prototype.setPageIndicatorNum = function(num) {
    this.pageIndicatorNum = num;
};
Video_obj.prototype.setSubmenuSelectedIdx = function(index) {
    this.submenuSelectedIdx = index;
};
Video_obj.prototype.init = function() {
    this.pageInfo.init();
    this.initBySubmenu(0);
    this.isinit = true;
};
Video_obj.prototype.initBySubmenu = function(index) {
    if (this.pageInfo.needAllOpt && index == 0) {
        this.setTotalNum(this.pageInfo.allNum);
    } else {
        this.totalNum = usbObj.getUsbTopListDbCount(MEDIA_TYPE.Video, VIDEO_SORT_TYPE, this.pageInfo.submenuData[index].LABEL);
    }
    this.infoList = [];
    this.setSubmenuSelectedIdx(index);
    this.setPageIndex(0);
    this.setPageIndicatorNum(Math.ceil(this.totalNum / ALL_PAGE_NUM.Video));
    this.getOnePageInfo();
};
Video_obj.prototype.getOnePageInfo = function(reqCount) {
    console.log("Video_obj getOnePageInfo");
    if (!this.infoList) {
        this.infoList = [];
    }
    if (this.infoList.length >= this.totalNum) {
        console.log("this.infoList.length >= this.totalNum return");
        return;
    }
    if (typeof reqCount == 'undefined') {
        if(this.showMode == SHOW_MODE.Thumbnails){
            reqCount = ALL_PAGE_NUM.Video;
        } else {
            reqCount = ALL_PAGE_NUM.VideoList;
        }
    }
    var count = (this.totalNum - this.infoList.length > reqCount) ? reqCount : (this.totalNum - this.infoList.length);
    if (this.pageInfo.needAllOpt && this.submenuSelectedIdx == 0) {
        this.infoList = this.infoList.concat(usbObj.getContentBrowserPageData(this.infoList.length, count, MEDIA_TYPE.Video, VIDEO_SORT_TYPE));
    //this.setInfoList(this.pageInfo.allInfoData);
    } else {
        this.infoList = this.infoList.concat(usbObj.getPagetDataBySubmenu(this.infoList.length, count, MEDIA_TYPE.Video, VIDEO_SORT_TYPE, this.pageInfo.submenuData[this.submenuSelectedIdx].LABEL));
    }

};
Video_obj.prototype.getContentInfo = function(reqCount) {
    console.log("Music_obj getContentInfoByType");
    if (this.infoList.length >= this.totalNum) {
        console.log("this.infoList.length >= this.totalNum return");
        return;
    }
    if (typeof (reqCount) == 'undefined') {
        reqCount = (this.totalNum - this.infoList.length);
    }
    if (reqCount > (this.totalNum - this.infoList.length)) {
        reqCount = (this.totalNum - this.infoList.length);
    }
    if (this.pageInfo.needAllOpt && this.submenuSelectedIdx == 0) {
        this.infoList = this.infoList.concat(usbObj.getContentBrowserPageData(this.infoList.length, reqCount, MEDIA_TYPE.Video, VIDEO_SORT_TYPE));
    } else {
        this.infoList = this.infoList.concat(usbObj.getPagetDataBySubmenu(this.infoList.length, reqCount, MEDIA_TYPE.Video, VIDEO_SORT_TYPE, this.pageInfo.submenuData[this.submenuSelectedIdx].LABEL));
    }
};
Video_obj.prototype.getShuffleItemInfo = function(startIndex) {
    var ret = null;
    if (typeof (startIndex) == 'undefined') {
        startIndex = getRandom(0, this.totalNum - 1);
    }
    console.log("Video_obj getShuffleItemInfo startIndex = " + startIndex);
    if (startIndex >= this.infoList.length) {
        this.getContentInfo(startIndex - this.infoList.length + 1);
    }
    if (this.pageInfo.needAllOpt && this.submenuSelectedIdx == 0) {
        ret = usbObj.getContentBrowserPageData(startIndex, 1, MEDIA_TYPE.Video, VIDEO_SORT_TYPE);
    } else {
        ret = usbObj.getPagetDataBySubmenu(startIndex, 1, MEDIA_TYPE.Video, VIDEO_SORT_TYPE, this.pageInfo.submenuData[this.submenuSelectedIdx].LABEL);
    }
    if (ret) {
        return ret[0];
    } else {
        return null;
    }
};
Video_obj.prototype.getPlayIndex = function() {
    return ALL_PAGE_NUM.Video * this.pageIndex + Number(this.focusIndex);
};
Video_obj.prototype.getPlayInfo = function(paramObj) {
    var isNext = paramObj.isNext;
    var isRepeat = paramObj.isRepeat;
    var isShuffle = paramObj.isShuffle;
    var isPlayAll = paramObj.isPlayAll;
    console.log("Video_obj getPlayInfo isNext = " + isNext + ";isRepeat = " + isRepeat + ";isShuffle = " + isShuffle);
    ret = null;
    var listIndex = Number(this.playIndex);
    console.log("listIndex = " + listIndex);
    if (typeof (isNext) == 'undefined') {
        listIndex = Number(this.focusIndex);
        this.sortIndexArr = [];
        for (var i = 0; i < this.totalNum; i++) {
            this.sortIndexArr[i] = i;
        }
        this.sortIndexArr.splice(listIndex, 1);
        ret = this.infoList[listIndex];
        this.playIndex = listIndex;
    } else if (isShuffle) {
        if (isRepeat) {
            var startIndex = getRandom(0, this.totalNum - 1);
            ret = this.getShuffleItemInfo(startIndex);
            //this.focusIndex = startIndex;
            this.playIndex = startIndex;
        } else {
            if (this.sortIndexArr.length > 0) {
                var startIndex = getRandom(0, this.sortIndexArr.length - 1);
                ret = this.getShuffleItemInfo(this.sortIndexArr[startIndex]);
                //this.focusIndex = this.sortIndexArr[startIndex];
                this.playIndex = this.sortIndexArr[startIndex];
                this.sortIndexArr.splice(startIndex, 1);
            }
        }
    } else {
        if (isNext) {
            tempNum = listIndex + 1;
            if (tempNum < this.totalNum) {
                if (tempNum >= this.infoList.length) {
                    this.getOnePageInfo();
                    this.playIndex++;
                } else {
                    this.playIndex++;
                }
                ret = this.infoList[this.playIndex];
            } else if (isRepeat) {
                this.playIndex = 0;
                ret = this.infoList[0];
            }
        } else {
            var needGet = false;
            if (this.playIndex <= 0) {
                if (isPlayAll && isRepeat) {
                    this.playIndex = this.totalNum - 1;
                    needGet = true;
                }
            } else {
                this.playIndex--;
                needGet = true;
            }
            if (needGet) {
                listIndex = Number(this.playIndex);
                console.log("false listIndex = " + listIndex);
                if (listIndex >= this.infoList.length) {
                    ret = this.getShuffleItemInfo(listIndex);
                } else {
                    ret = this.infoList[listIndex];
                }
            }
        }
    }
    return ret;
};

var Photo_page = function() {
    this.submenuData = [];
    this.allNum;
    this.allInfoData;
    this.allPageListData;
    this.needAllOpt = false;
    this.submenuInfo;
};
Photo_page.prototype.init = function(mode) {
    this.allNum = usbObj.getCbDbCount(MEDIA_TYPE.Photo);
    this.submenuData = [];
    if (this.allNum > 0) {
        switch (PHOTO_SORT_TYPE[mode]) {
            case PHOTO_SORT_TYPE['A-Z']:
            case PHOTO_SORT_TYPE['Z-A']:
                this.submenuData = usbObj.getSubmenuStr(MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[mode]);
                break;
            default:
                this.submenuInfo = {total_num:0, noData:false, hasOther:false, objectType:MEDIA_TYPE.photoList};
                if(this.needAllOpt){
                    this.submenuData.push({LABEL: 'All',MEDIA_TYPE: MEDIA_TYPE.photoList});
                }
                var temp = usbObj.getSubmenuList(MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[mode], this.submenuInfo);
                this.submenuData = this.submenuData.concat(temp);
                break;
        }
    }
//this.allInfoData = getContentBrowserData(MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[mode]);
};
Photo_page.prototype.tryGetSubmenu = function(mode) {
    if(PHOTO_SORT_TYPE[mode] == PHOTO_SORT_TYPE['A-Z'] || PHOTO_SORT_TYPE[mode] == PHOTO_SORT_TYPE['Z-A']) {
        return;
    }

    if (this.allNum > 0 && !this.submenuInfo.noData) {
        var temp = usbObj.getSubmenuList(MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[mode], this.submenuInfo);
        this.submenuData = this.submenuData.concat(temp);
    }
};
var Photo_obj = function() {
    this.totalNum;
    this.sortMode = 'Year';
    this.infoList;
    this.pageIndicatorNum;
    this.submenuSelectedIdx = 0;
    this.focusIndex = 0;
    this.pageInfo = new Photo_page();
    this.needRefresh = true;
    this.showMode = this.getShowMode();
};
Photo_obj.prototype.getShowMode = function() {
    return mtvObj.acfgGetConfigValue('g_misc__cb_photo_view_mode') ? SHOW_MODE.List : SHOW_MODE.Thumbnails;
};
Photo_obj.prototype.setShowMode = function(value) {
    this.showMode = value;
    mtvObj.acfgSetConfigValue('g_misc__cb_photo_view_mode', this.showMode == SHOW_MODE.List ? 1 : 0);
};
Photo_obj.prototype.setSubmenuData = function(data) {
    this.submenuData = data;
};
Photo_obj.prototype.setTotalNum = function(num) {
    this.totalNum = num;
};
Photo_obj.prototype.setSortMode = function(mode) {
    this.sortMode = mode;
};
Photo_obj.prototype.setInfoList = function(list) {
    this.infoList = list;
};
Photo_obj.prototype.setPageIndicatorNum = function(num) {
    this.pageIndicatorNum = num;
};
Photo_obj.prototype.setSubmenuSelectedIdx = function(index) {
    this.submenuSelectedIdx = index;
};
Photo_obj.prototype.init = function(mode) {
    if (mode) {
        this.setSortMode(mode);
    }
    this.pageInfo.init(this.sortMode);
    this.initBySubmenu(0);
};
Photo_obj.prototype.initBySubmenu = function(index) {
    this.infoList = [];
    this.totalNum = 0;
    this.setSubmenuSelectedIdx(index);
    if(this.pageInfo.submenuData.length <= 0 || this.pageInfo.submenuData.length <= index){
        return;
    }
    if (this.pageInfo.needAllOpt && index == 0) {
        //this.setInfoList(this.pageInfo.allInfoData);
        this.setTotalNum(this.pageInfo.allNum);
    } else {
        this.totalNum = usbObj.getUsbTopListDbCount(MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[this.sortMode], this.pageInfo.submenuData[index].LABEL);
    //var dataBySubmenu = getDataBySubmenu(MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[this.sortMode], this.pageInfo.submenuData[index]);
    //this.setInfoList(dataBySubmenu.data);
    }
    this.setPageIndicatorNum(Math.ceil(this.totalNum / ALL_PAGE_NUM.Photo));
    this.getOnePageInfo();
};
Photo_obj.prototype.getOnePageInfo = function(reqCount) {
    console.log("getOnePageInfo");
    if (!this.infoList) {
        this.infoList = [];
    }
    if (this.infoList.length >= this.totalNum) {
        console.log("this.infoList.length >= this.totalNum return");
        return;
    }
    if (typeof reqCount == 'undefined') {
        if(this.showMode == SHOW_MODE.Thumbnails){
            reqCount = ALL_PAGE_NUM.Photo;
        } else {
            reqCount = ALL_PAGE_NUM.PhotoList;
        }
    }
    var count = (this.totalNum - this.infoList.length > reqCount) ? reqCount : (this.totalNum - this.infoList.length);
    if (this.pageInfo.needAllOpt && this.submenuSelectedIdx == 0) {
        this.infoList = this.infoList.concat(usbObj.getContentBrowserPageData(this.infoList.length, count, MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[this.sortMode]));
    //this.setInfoList(this.pageInfo.allInfoData);
    } else {
        this.infoList = this.infoList.concat(usbObj.getPagetDataBySubmenu(this.infoList.length, count, MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[this.sortMode], this.pageInfo.submenuData[this.submenuSelectedIdx].LABEL));
    }

};
Photo_obj.prototype.getContentInfo = function(reqCount) {
    console.log("Music_obj getContentInfoByType");
    if (this.infoList.length >= this.totalNum) {
        console.log("this.infoList.length >= this.totalNum return");
        return;
    }
    if (typeof (reqCount) == 'undefined') {
        reqCount = (this.totalNum - this.infoList.length);
    }
    if (reqCount > (this.totalNum - this.infoList.length)) {
        reqCount = (this.totalNum - this.infoList.length);
    }
    if (this.pageInfo.needAllOpt && this.submenuSelectedIdx == 0) {
        this.infoList = this.infoList.concat(usbObj.getContentBrowserPageData(this.infoList.length, reqCount, MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[this.sortMode]));
    } else {
        this.infoList = this.infoList.concat(usbObj.getPagetDataBySubmenu(this.infoList.length, reqCount, MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[this.sortMode], this.pageInfo.submenuData[this.submenuSelectedIdx].LABEL));
    }
};
Photo_obj.prototype.getShuffleItemInfo = function(startIndex) {
    var ret = null;
    if (typeof (startIndex) == 'undefined') {
        startIndex = getRandom(0, this.totalNum - 1);
    }
    console.log("Photo_obj getShuffleItemInfo startIndex = " + startIndex);
    //if (startIndex >= this.infoList.length) {
    //    this.getContentInfo(startIndex - this.infoList.length + 1);
    //}
    if (this.pageInfo.needAllOpt && this.submenuSelectedIdx == 0) {
        ret = usbObj.getContentBrowserPageData(startIndex, 1, MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[this.sortMode]);
    } else {
        ret = usbObj.getPagetDataBySubmenu(startIndex, 1, MEDIA_TYPE.Photo, PHOTO_SORT_TYPE[this.sortMode], this.pageInfo.submenuData[this.submenuSelectedIdx].LABEL);
    }
    if (ret) {
        return ret[0];
    } else {
        return null;
    }
};
Photo_obj.prototype.getPlayIndex = function() {
    return Number(this.focusIndex);
};
Photo_obj.prototype.getPlayInfo = function(paramObj) {
    var isNext = paramObj.isNext;
    var isRepeat = paramObj.isRepeat;
    var isShuffle = paramObj.isShuffle;
    var isPlayAll = paramObj.isPlayAll;
    console.log("Photo_obj getPlayInfo isNext = " + isNext + ";isRepeat = " + isRepeat + ";isShuffle = " + isShuffle);
    ret = null;
    var listIndex = Number(this.playIndex);
    console.log("listIndex = " + listIndex);
    if (typeof (isNext) == 'undefined') {
        listIndex = Number(this.focusIndex);
        this.sortIndexArr = [];
        for (var i = 0; i < this.totalNum; i++) {
            this.sortIndexArr[i] = i;
        }
        this.sortIndexArr.splice(listIndex, 1);
        ret = this.infoList[listIndex];
        this.playIndex = listIndex;
    } else if (isShuffle) {
        if (isRepeat) {
            var startIndex = getRandom(0, this.totalNum - 1);
            ret = this.getShuffleItemInfo(startIndex);
            //this.focusIndex = startIndex;
            this.playIndex = startIndex;
        } else {
            if (this.sortIndexArr.length > 0) {
                var startIndex = getRandom(0, this.sortIndexArr.length - 1);
                ret = this.getShuffleItemInfo(this.sortIndexArr[startIndex]);
                //this.focusIndex = this.sortIndexArr[startIndex];
                this.playIndex = this.sortIndexArr[startIndex];
                this.sortIndexArr.splice(startIndex, 1);
            }
        }
    } else {
        if (isNext) {
            tempNum = listIndex + 1;
            if (tempNum < this.totalNum) {
                if (tempNum >= this.infoList.length) {
                    this.getOnePageInfo();
                    this.playIndex++;
                } else {
                    this.playIndex++;
                }
                ret = this.infoList[this.playIndex];
            } else if (isRepeat) {
                this.playIndex = 0;
                ret = this.infoList[0];
            }
        } else {
            var needGet = false;
            if (this.playIndex <= 0) {
                if (isPlayAll && isRepeat) {
                    this.playIndex = this.totalNum - 1;
                    needGet = true;
                }
            } else {
                this.playIndex--;
                needGet = true;
            }
            if (needGet) {
                listIndex = Number(this.playIndex);
                console.log("false listIndex = " + listIndex);
                if (listIndex >= this.infoList.length) {
                    ret = this.getShuffleItemInfo(listIndex);
                } else {
                    ret = this.infoList[listIndex];
                }
            }
        }
    }
    if(ret){
        ret.processTxt = (this.playIndex + 1) + "/" + this.totalNum;
    }
    return ret;
};

function getQueryString(name) {
    var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i');
    var r = decodeURI(window.location.href.substring(window.location.href.indexOf('?'))).substr(1).match(reg);
    if (r != null)
        return r[2];
    return null;
}

function goToHelpPage() {
    console.log("goToHelpPage");
    var arg = {"PARAMETER": {"appMode": "EDFU",
            "edfuUrl": "/usr/opera/opera_dir/pages/edfu/index.html",
            "REQUEST": "SET"}};
    mtvObj.startNetTV(JSON.stringify(arg));
}

var mtvObj = new MtvObj();
var UsbObj = function() {
    this.USB_PATH = "";
};

//TPV@Vinson(20171014)_SN0008 - start
var CFG_CUSTOM_BASE_REGION_CODE	= "g_custom_base__region_code";
var eRegionCode = {
	PLF_OPT_REGION_EU: 0x00,
	PLF_OPT_REGION_LATAM: 0x01,
	PLF_OPT_REGION_AP: 0x02,
	PLF_OPT_REGION_RUSSIA: 0x03,
	PLF_OPT_REGION_MEA: 0x04,
	PLF_OPT_REGION_KR: 0x05
};
var g_RegionCode = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_REGION_CODE);
//TPV@Vinson(20171014)_SN0008 - end

UsbObj.prototype.init = function(path) {
    console.log("UsbObj.prototype.init path = " + path);
    var lastStr = path.substring(path.length - 1);
    console.log("lastStr = " + lastStr);
    if (lastStr == "/") {
        path = path.substring(0, path.length - 1);
    }
    this.USB_PATH = path;
}

UsbObj.prototype.getSubmenuList = function(type, sort, infoObj) {
    var usbPath = this.USB_PATH;
    var ObjectType = infoObj.objectType;
    var ret = [];
    var i;
    //var total_num = 0;
    var COUNT = Number_Each_Time;
    do {
        i = 0;
        var arg = '{"PARAMETER":{"PATH":"' + usbPath + '","TYPE":"' + type + '","SORT":"' + sort + '","INDEX":"' + infoObj.total_num + '","COUNT":"' + COUNT + '","REQUEST":"QUERY"}}';
        var res = mtvObj.getUsbTopList(arg);
        if (!res)
            break;

        ch = JSON.parse(res);

        if (ch.ITEMS.length <= 1 && ch.ITEMS[0].hasOwnProperty('COUNT'))
            break;

        for (var index in ch.ITEMS) {
            var itemMenu;
            switch (type) {
                case MEDIA_TYPE.Music:
                    itemMenu = getMusicSubmenuItem(ch.ITEMS[index], sort);
                    break;
                case MEDIA_TYPE.Photo:
                    itemMenu = getPhotoSubmenuItem(ch.ITEMS[index], sort);
                    break;
            }
            if (itemMenu == "" || itemMenu == "Other") {
                infoObj.hasOther = true;
            } else {
                ret.push({LABEL: itemMenu,MEDIA_TYPE: ObjectType});
            }
            i++;
            infoObj.total_num++;
        }
    } while (0);

    if(i < COUNT){
       infoObj.noData = true;
       if(infoObj.hasOther)
            ret.push({LABEL: 'Other', MEDIA_TYPE: ObjectType});
    }

    return ret;
};

UsbObj.prototype.getSubmenuStr = function(type, sort, needAll) {
    var usbPath = this.USB_PATH;
    var ObjectType;
    if (type == 1) {
        ObjectType = MEDIA_TYPE.photoList;
    } else if (type == 2) {
        ObjectType = MEDIA_TYPE.musicList;
    }
    if (needAll) {
        ret = [{LABEL: 'All',MEDIA_TYPE: ObjectType}];
    } else {
        ret = [];
    }
    var arg = '{"PARAMETER":{"PATH":"' + usbPath + '","TYPE":"' + type + '","SORT":"' + sort + '","INDEX":"0","COUNT":"10","REQUEST":"QUERY"}}';
    res = mtvObj.getUsbTopList(arg);
    if (res) {
        ch = JSON.parse(res);
        if (ch.ITEMS.length >= 1 && !ch.ITEMS[0].hasOwnProperty('COUNT')) {
            var menuArray = ch.ITEMS[0].MEDIA_PATH.split("")
            for (var index in menuArray) {
                if ('#' == menuArray[index]) {
                    ret.push({LABEL: 'Other',MEDIA_TYPE: ObjectType});
                } else {
                    ret.push({LABEL: menuArray[index],MEDIA_TYPE: ObjectType});
                }
            }
        }

    }

    return ret;
};

function getMusicSubmenuItem(item, sort, otherString) {
    var itemMenu = "";
    switch (sort) {
        case MUSIC_SORT_TYPE.Artist:
            itemMenu = item.ARTIST;
            break;
        case MUSIC_SORT_TYPE.Album:
            itemMenu = item.ALBUM;
            break;
        case MUSIC_SORT_TYPE.Genre:
            itemMenu = item.GENER;
            break;
        case MUSIC_SORT_TYPE.Track:
            itemMenu = item.TRACK;
            break;
    }
    if ($.trim(itemMenu) == "") {
        itemMenu = "";
        /*
        if (otherString.length > 0) {
            otherString = ALL_SORT_DATA.Music[sort] + '\'' + itemMenu + '\'';
        } else {
            otherString = "or" + ALL_SORT_DATA.Music[sort] + '\'' + itemMenu + '\'';
        }*/
    }
    return itemMenu;
}

function getPhotoSubmenuItem(item, sort) {
    var itemMenu = "";
    switch (sort) {
        case PHOTO_SORT_TYPE.Year:
            itemMenu = item.DATE.YEAR;
            break;
        case PHOTO_SORT_TYPE.Month:
            itemMenu = item.DATE.YEAR + '/' + item.DATE.MONTH;
            break;
        case PHOTO_SORT_TYPE.Day:
            itemMenu = item.DATE.YEAR + '/' + item.DATE.MONTH + '/' + item.DATE.DAY;
            break;
    }
    return itemMenu;
}

UsbObj.prototype.getDataBySubmenu = function(type, sort, reserved, usbPath) {
    if (typeof (usbPath) == 'undefined') {
        usbPath = this.USB_PATH;
    }
    console.log("type = " + type + ";sort = " + sort + ";reserved = " + reserved);
    if (reserved == "Other") {
        reserved = getOtherReserved(type, sort);
    }
    ret = [];
    var i;
    var total_num = 0;
    var COUNT = Number_Each_Time;
    do {
        i = 0;
        var paramObj = {'PATH': usbPath,'TYPE': type,'SORT': sort,'INDEX': total_num,'COUNT': COUNT,'RESERVED': "" + reserved,'REQUEST': 'QUERY'};
        var arg = {};
        arg.PARAMETER = paramObj;
        //var arg = '{"PARAMETER":{"PATH":"'+this.USB_PATH+'","TYPE":"'+type+'","SORT":"'+sort+'","INDEX":"'+total_num+'","COUNT":"'+COUNT+'","RESERVED":"'+reserved+'","REQUEST":"QUERY"}}';
        res = mtvObj.getUsbRec(JSON.stringify(arg));
        if (!res)
            break;
        ch = JSON.parse(res);
        for (var index in ch.ITEMS) {
            ret.push(ch.ITEMS[index]);
            i++;
            total_num++;
        }
    } while (i >= COUNT);

    var request = {};
    request.num = total_num;
    request.data = ret;

    return request;
};

var Number_Each_Time = 13;

UsbObj.prototype.getPagetDataBySubmenu = function(startIndex, totalCount, type, sort, reserved, usbPath) {
    if (typeof (usbPath) == 'undefined') {
        usbPath = this.USB_PATH;
    }
    console.log("startIndex = " + startIndex + ";count= " + totalCount + ";type = " + type + ";sort = " + sort + ";reserved = " + reserved);
    if (reserved == "Other") {
        reserved = getOtherReserved(type, sort);
    }
    ret = [];

    var total_num = 0;
    var i = 0;
    var count = 0;
    while (total_num < totalCount && i >= count) {
        console.log("getPagetDataBySubmenu total_num " + total_num);
        i = 0
        count = (totalCount - total_num >= Number_Each_Time) ? Number_Each_Time : (totalCount - total_num);
        var paramObj = {'PATH': usbPath,'TYPE': type,'SORT': sort,'INDEX': startIndex,'COUNT': count,'RESERVED': "" + reserved,'REQUEST': 'QUERY'};
        var arg = {};
        arg.PARAMETER = paramObj;
        //var arg = '{"PARAMETER":{"PATH":"' + this.USB_PATH + '","TYPE":"' + type + '","SORT":"' + sort + '","INDEX":"' + startIndex + '","COUNT":"' + count + '","RESERVED":"' + reserved + '","REQUEST":"QUERY"}}';
        console.log("arg = " + JSON.stringify(arg));
        res = mtvObj.getUsbRec(JSON.stringify(arg));
        if (!res)
            break;
        ch = JSON.parse(res);
        for (var index in ch.ITEMS) {
            ret.push(ch.ITEMS[index]);
            i++;
            total_num++;
        }

    }
    ;

    return ret;
};

UsbObj.prototype.getUsbTopListDbCount = function(type, sort, reserved) {
    if (reserved == "Other") {
        reserved = getOtherReserved(type, sort);
    }
    var ret = 0;
    var paramObj = {'SORT': sort,'TYPE': type,'RESERVED': "" + reserved,'REQUEST': 'QUERY'};
    var arg = {};
    arg.PARAMETER = paramObj;
    //var arg = '{"PARAMETER":{"TYPE":"'+type+'","SORT":"'+sort+'","RESERVED":"'+reserved+'","REQUEST":"QUERY"}}';
    res = mtvObj.getUsbTopListDbCount(JSON.stringify(arg));
    if (res) {
        var countInfo = JSON.parse(res);
        ret = parseInt(countInfo.ITEMS[0].COUNT);
    }
    return ret;
};

function getOtherReserved(type, sort) {
    var other = "";
    switch (type) {
        case MEDIA_TYPE.Music:
            if (MUSIC_SORT_TYPE.Track == sort) {
                other = "#";
            } else {
                other = "";
            }
            break;
        case MEDIA_TYPE.Photo:
            if (PHOTO_SORT_TYPE['A-Z'] == sort || PHOTO_SORT_TYPE['Z-A'] == sort) {
                other = "#";
            } else {
                other = "";
            }
            break;
        case MEDIA_TYPE.Video:
            other = "#";
            break;
    }
    return other;
}

UsbObj.prototype.getCbDbCount = function(mediaType, path) {
    if (typeof (path) == 'undefined') {
        path = this.USB_PATH;
    }
    var ret = 0;
    var paramObj = {'PATH': path,'TYPE': mediaType,'REQUEST': 'QUERY'};
    var arg = {};
    arg.PARAMETER = paramObj;
    //var arg = '{"PARAMETER":{"PATH":"'+path+'","TYPE":"'+mediaType+'","REQUEST":"QUERY"}}';
    res = mtvObj.getUsbScanDbCount(JSON.stringify(arg));
    if (res) {
        var countInfo = JSON.parse(res);
        ret = parseInt(countInfo.ITEMS[0].COUNT);
    }
    return ret;
};

UsbObj.prototype.getContentBrowserPageData = function(startIndex, totalCount, mediaType, sortTypeOrPath, usbPath) {
    if (typeof (usbPath) == 'undefined') {
        usbPath = this.USB_PATH;
    }
    console.log("startIndex = " + startIndex + ";mediaType = " + mediaType + ";sortTypeOrPath = " + sortTypeOrPath);
    var path;
    var sortType;
    if (MEDIA_TYPE.Folder <= mediaType) {
        path = sortTypeOrPath;
    } else {
        sortType = sortTypeOrPath;
        mtvObj.setContentSortType(mediaType, sortType);
        path = usbPath;
    }

    var ret = [];
    var total_num = 0;
    var i = 0;
    var count = 0;
    while (total_num < totalCount) {
        i = 0;
        count = (totalCount - total_num >= Number_Each_Time) ? Number_Each_Time : (totalCount - total_num);
        var paramObj = {'PATH': path,'TYPE': mediaType,'INDEX': (startIndex + total_num),'COUNT': count,'REQUEST': 'QUERY'};
        var arg = {};
        arg.PARAMETER = paramObj;
        //var arg = '{"PARAMETER":{"PATH":"' + path + '","TYPE":"'+ mediaType + '","INDEX":"' + (startIndex+total_num) + '","COUNT":"'+count+'","REQUEST":"QUERY"}}';
        console.log("arg = " + JSON.stringify(arg));
        res = mtvObj.getUsbContentInfo(JSON.stringify(arg));
        if (!res)
            break;
        ch = JSON.parse(res);
        for (var index in ch.ITEMS) {
            ret.push(ch.ITEMS[index]);
            i++;
            total_num++;
        }

    }
    ;

    return ret;
};

UsbObj.prototype.getFolderPageData = function(startIndex, totalCount, sortTypeOrPath, allMediaData, mediaType) {
    console.log("startIndex = " + startIndex + ";sortTypeOrPath = " + sortTypeOrPath);
    var ret = [];
    var total_num = 0;
    var i = 0;
    var count = 0;
    if (typeof mediaType == 'undefined') {
        mediaType = MEDIA_TYPE.Folder;
    }
    while (total_num < totalCount && i >= count) {
        i = 0;
        count = (totalCount - total_num >= Number_Each_Time) ? Number_Each_Time : (totalCount - total_num);
        var paramObj = {'PATH': sortTypeOrPath,'TYPE': mediaType,'INDEX': (startIndex + total_num),'COUNT': count,'REQUEST': 'QUERY'};
        var arg = {};
        arg.PARAMETER = paramObj;
        //var arg = '{"PARAMETER":{"PATH":"' + path + '","TYPE":"'+ mediaType + '","INDEX":"' + (startIndex+total_num) + '","COUNT":"'+count+'","REQUEST":"QUERY"}}';
        console.log("arg = " + JSON.stringify(arg));
        res = mtvObj.getUsbContentInfo(JSON.stringify(arg));
        if (!res)
            break;
        ch = JSON.parse(res);
        for (var index in ch.ITEMS) {
            var item = ch.ITEMS[index];
            item.MEDIA_INDEX = startIndex + total_num;
            ret.push(item);
            switch (item.MEDIA_TYPE) {
                case 1:
                case 2:
                case 3:
                    if (!allMediaData[item.MEDIA_TYPE]) {
                        allMediaData[item.MEDIA_TYPE] = [];
                        item.PLAY_INDEX = 0;
                    } else {
                        item.PLAY_INDEX = allMediaData[item.MEDIA_TYPE].length;
                    }

                    allMediaData[item.MEDIA_TYPE].push(item);
                    break;
            }
            i++;
            total_num++;
        }

    }
    ;

    return ret;
};

UsbObj.prototype.getContentInfoByPath = function(type, filePath, usbPath) {
    if (typeof (usbPath) == 'undefined') {
        usbPath = this.USB_PATH;
    }
    var ret = null;
    var paramObj = {'PATH': usbPath,'TYPE': type,'RESERVED': filePath,'REQUEST': 'QUERY'};
    var arg = {};
    arg.PARAMETER = paramObj;
    //var arg = '{"PARAMETER":{"PATH":"'+this.USB_PATH+'","TYPE":"'+type+'","RESERVED":"'+filePath+'","REQUEST":"QUERY"}}';
    var res = mtvObj.getUsbContentInfoByPath(JSON.stringify(arg));
    if (res) {
        res = JSON.parse(res);
        ret = res.ITEMS[0];
    }
    return ret;
};

UsbObj.prototype.usbScanStatus = function(usbPath) {
    if (typeof (usbPath) == 'undefined') {
        usbPath = this.USB_PATH;
    }
    var ret = -1;
    res = mtvObj.getUsbScanStatus('{"PARAMETER":{"PATH":"' + usbPath + '","REQUEST":"QUERY"}}');
    if (res) {
        var countInfo = JSON.parse(res);
        ret = parseInt(countInfo.STATUS);
    }
    return ret;
};

UsbObj.prototype.startUsbScan = function(usbPath) {
    if (typeof (usbPath) == 'undefined') {
        usbPath = this.USB_PATH;
    }
    return mtvObj.startUsbScan(usbPath);
};

UsbObj.prototype.importDatabase = function(usbPath) {
    if (typeof (usbPath) == 'undefined') {
        usbPath = this.USB_PATH;
    }
    return mtvObj.importDatabase(usbPath);
};

UsbObj.prototype.deleteDatabase = function(usbPath) {
    console.log("deleteDatabase usbPath = " + usbPath);
    var lastStr = usbPath.substring(usbPath.length - 1);
    console.log("lastStr = " + lastStr);
    if (lastStr == "/") {
        usbPath = usbPath.substring(0, usbPath.length - 1);
    }
    return mtvObj.deleteDatabase(usbPath);
};

UsbObj.prototype.getUsbMountList = function() {
    var ret = [];
    var res = mtvObj.getMountPointList('');
    if (res) {
        res = JSON.parse(res);
        for (index in res.ITEMS) {
            ret.push(res.ITEMS[index]);
        }
    }
    return ret;
};

UsbObj.prototype.getMountPointDevDesc = function(devName) {
    var arg = '{"PARAMETER":{"VALUE":"' + devName + '","REQUEST":"QUERY"}}';
    var res = mtvObj.getMountPointDevDesc(arg);
    if (res) {

    }
    return null;
};

UsbObj.prototype.getJumpSuperShopDemo = function(usbPath) {
    if (typeof (usbPath) == 'undefined') {
        usbPath = this.USB_PATH;
    }
    var ret = 0;
    var arg = '{"PARAMETER":{"path":"' + usbPath + '","REQUEST":"QUERY"}}';
    var res = mtvObj.getJumpSuperShopDemo(arg);
    if (res) {
        res = JSON.parse(res);
        ret = res.ITEMS[0].TYPE;
    }
    return ret;
};
UsbObj.prototype.getUsbProductInfo = function(dev) {
    if (dev) {
        var arg = '{"PARAMETER":{"VALUE":"' + dev + '","REQUEST":"QUERY"}}';
        return mtvObj.getMountPointDevDesc(arg);
    }
    console.log("UsbObj.prototype.getUsbProductInfo dev is empty [ " + dev + "]")

}
var usbObj = new UsbObj();

var EventListenerName = {
    cmpbNotify: 'CBCmpbNotify',
    dmsNotify: 'DlnaDmsNotify',
    dmrNotify: 'DlnaDmrNotify',
    usbDetectNotify: 'UsbDetectNotify',
    networkNotify: 'NetworkNotify',
    volumeNotify: 'VolumeNotify',
    pusNotify: 'PusNotify'
}

function addCBEventListener(name, notifyFunc) {
    if (name && notifyFunc) {
        mtvObj.addMmpEventListener(name, notifyFunc);
    }
}
;

function removeCBEventListener(name, notifyFunc) {
    if (name && notifyFunc) {
        mtvObj.removeMmpEventListener(name, notifyFunc);
    }
}
;

function addTvServerListener(name, notifyFunc) {
    if (name && notifyFunc) {
        mtvObj.addTvServerListener(name, notifyFunc);
    }
}

function removeTvServerListener(name, notifyFunc) {
    if (name && notifyFunc) {
        mtvObj.removeTvServerListener(name, notifyFunc);
    }
}

var usbMountList = [];
var noPvrUsbMountList = [];
var curUsbPathInfo = null;

function setCurUsbPathInfo(usbInfo, scanNotifyFunc) {
    console.log("setCurUsbPathInfo");
    if (!curUsbPathInfo || curUsbPathInfo.PATH != usbInfo.PATH) {
        curUsbPathInfo = usbInfo;
        usbObj.init(curUsbPathInfo.PATH);
        musicObj.sortMode = null;
        videoObj.isinit = false;
        var importRet = usbObj.importDatabase();
        console.log("importRet = " + importRet);
        if (importRet != 0) {
            waitUsbScan();
            usbInfo.scanDone = false;
            return;
        }
        if(usbObj.usbScanStatus() == 0){
            usbInfo.scanDone = true;
        } else {
            usbInfo.scanDone = false;
        }

    }
}

function addOrUpdateUsbPath(usbInfo) {
    console.log("addOrUpdateUsbPath usbInfo = " + JSON.stringify(usbInfo));
    for (usbPathIndex in usbMountList) {
        if (usbMountList[usbPathIndex].PATH == usbInfo.PATH) {
            console.log("usbMountList[usbPathIndex].PATH == usbInfo.PATH");
            usbMountList[usbPathIndex] = usbInfo;
            return;
        }
    }
    var path = usbInfo.PATH;
    var lastStr=path.substring(path.length-1);
    if(lastStr == "/"){
        path = path.substring(0,path.length-1);
    }
    if(window.dmrUtil.getSuperShopDemoCount(path)){
        var param = "action=usb_mount&path=" + path;
        mtvuiUtil.gotoSysPage("sys_content_browser", param);
        return;
    }
    mtvuiUtil.exitMenu();
    usbObj.deleteDatabase(usbInfo.PATH);
    if (usbMountList.length <= 0) {
        usbMountList.push(usbInfo);
        contentBrowserObj.refreshCbUi(1);
    } else {
        usbMountList.push(usbInfo);
        refreshRootList();
    }
    console.log("usbMountList = " + JSON.stringify(usbMountList));
}

function removeUsbPath(usbInfo) {
    var needRemove = false;
    for (usbPathIndex in usbMountList) {
        if (usbMountList[usbPathIndex].PATH == usbInfo.PATH) {
            needRemove = true;
            break;
        }
    }
    console.log("usbPathIndex = " + usbPathIndex + ";needRemove = " + needRemove);
    if (needRemove) {
        usbMountList.splice(usbPathIndex, 1);
        musicPlayObj.plugoutUsb(usbInfo.PATH);
        if(curUsbPathInfo && curUsbPathInfo.PATH == usbInfo.PATH){
            //TODO:
            console.log("history.go(-1)");
            curUsbPathInfo = null;
            if(usbMountList.length <= 0){
                contentBrowserObj.refreshCbUi(2);
                contentBrowserObj.stopPlay();
            } else {
                contentBrowserObj.stopPlay();
                initFile();
            }
        } else {
            if(usbMountList.length <= 0){
				curUsbPathInfo = null;
                contentBrowserObj.refreshCbUi(2);
            } else {
                refreshRootList();
            }
        }
    }
    console.log("usbMountList = " + JSON.stringify(usbMountList));
}

function waitUsbScan(scanDonFunc) {
    console.log("waitUsbScan");
    usbObj.startUsbScan();
    usbScanStatus = usbObj.usbScanStatus();
    console.log("usbScanStatus = " + usbScanStatus);
    if (usbScanStatus == 0) {
        if (scanDonFunc)
            scanDonFunc(true);
    } else {
        if (scanDonFunc)
            scanDonFunc(false);
    }

}

function usbDetect() {
    usbDetectNotifyFunc = usbDetectItemNotifyFunc;
    usbMountList = usbObj.getUsbMountList();
    console.log("usbMountList = " + JSON.stringify(usbMountList));
    if (usbMountList.length <= 0) {
        return false;
    }
    return true;
}

var USB_DETECT_NOTIFY_TYPE = {
    Plugin: 0,
    Plugout: 1,
    ScanDone: 1000
}

function usbDetectItemNotifyFunc(usbItem) {
    console.log("usbDetectItemNotifyFunc");
    switch (Number(usbItem.TYPE)) {
        case USB_DETECT_NOTIFY_TYPE.Plugin:
            addOrUpdateUsbPath(usbItem);
            contentBrowserObj.usbAddDetect();
            break;
        case USB_DETECT_NOTIFY_TYPE.Plugout:
			if(mtvObj.acfgGetConfigValue('g_custom_base__is_screen_mode') == 1)
			{
				mtvObj.acfgSetConfigValue('g_custom_base__exit_picture_format_adv', 0);
			}	

			/* 
			Stephen 180326, [GZ-ORT] TV hangs up after reconnect USB memory,
			curObjectType need to be reset. Otherwise, there will be wrong code flow make fileObj.childNode to be clear to null;
			*/
			if( curObjectType == "photoObj")	
			{
			    curObjectType = null;
			}
			
            removeUsbPath(usbItem);
            break;
        case USB_DETECT_NOTIFY_TYPE.ScanDone:
            curUsbPathInfo.scanDone = true;
            contentBrowserObj.updateData();
            break;
    }
}

function superShopUsbDetectNotifyFunc(usbItem) {
    console.log("superShopUsbDetectNotifyFunc");
    switch (Number(usbItem.TYPE)) {
        case USB_DETECT_NOTIFY_TYPE.Plugin:
            /*var path = usbItem.PATH;
            var lastStr = path.substring(path.length - 1);
            if (lastStr == "/") {
                path = path.substring(0, path.length - 1);
            }
            var param = "action=usb_mount&path=" + path;
            mtvuiUtil.gotoSysPage("sys_content_browser", param);*/
            break;
        case USB_DETECT_NOTIFY_TYPE.Plugout:
            if (usbItem.PATH.indexOf(usbObj.USB_PATH) == 0) {
                mtvuiUtil.gotoSysPage("sys_index");
            }
            break;
    }
}

function playbackInitWithPath(paramObj) {
    console.log("paramObj = " + JSON.stringify(paramObj));
    if (typeof (paramObj.bMode) == 'undefined' || !paramObj.bMode) {
        paramObj.bMode = 1;
    }
    if (typeof (paramObj.info) == 'undefined' || !paramObj.info) {
        paramObj.info = '';
    }
    if (typeof (paramObj.oMode) == 'undefined' || !paramObj.oMode) {
        paramObj.oMode = 2;
    }
    if (typeof (paramObj.protocal) == 'undefined' || !paramObj.protocal) {
        paramObj.protocal = '';
    }
    if (typeof (paramObj.REQUEST) == 'undefined' || !paramObj.REQUEST) {
        paramObj.REQUEST = 'QUERY';
    }
    if (typeof (paramObj.asyncOpen) == 'undefined') {
        paramObj.asyncOpen = 1;
    }
    paramObj.pvTag = parseInt(Math.random() * (0xffff) + 1);
    var arg = {};
    arg.PARAMETER = paramObj;
    //var arg = '{"PARAMETER":{"bMode":' + bufferingModel + ',"oMode":2,"profile":"","info":'+playbackDevId+',"protocal":"","mediaPath":"' + path + '","REQUEST":"QUERY"}}';
    console.log("playbackInitWithPath arg = " + JSON.stringify(arg));
    var res = mtvObj.playbackInitWithPath(JSON.stringify(arg));
    if (res) {
        ch = JSON.parse(res);
        return {STATUS: ch.STATUS,HANDLE: ch.ITEMS[0].handle,PVTAG: ch.ITEMS[0].pvTag};
    }
    return null;

}
;

function playbackDeinit(handle) {
    if (typeof (handle) != 'undefined' && handle) {
        var arg = '{"PARAMETER":{"handle":' + handle + ',"REQUEST":"SET"}}';
        console.log("playbackDeinit arg = " + arg);
        mtvObj.playbackDeinit(arg);
    }
}

var PlaybackErrorType = {
    error_unknown: 100,
    audio_unplayable: 101,
    audio_codec_not_support: 102,
    video_unplayable: 103,
    video_codec_not_support: 104,
    resolution_not_support: 105,
    drm_not_support: 106,
    hd_not_support: 107,
    no_audio_video_svc: 108,
    file_not_support: 109,
    media_lost: 110,
    license_expired: 111,
    cam_card_miss: 112	//for pvr palyback without cam card insert
};

var PlaybackErrorInfo = {
    '100': 'NFY_PHOTO',
    '101': 'Audio unplayable',
    '102': 'NFY_AUDIO_NOT_SUP', //'Audio format not supported',
    '103': 'Video unplayable',
    '104': 'WFD_VIEW_MSG_VIDEO_NOT_SUPPORTED', //'Video format not supported',
    '105': 'QT_MEDIA_RESOLUTION_UNSUPPORT', //'Resolution not supported',
    '106': 'QT_DRM_NOT_SUPPORT', //'Drm not supported',
    '107': 'HD not supported',
    '108': 'NFY_AV_NOT_SUP', //'No audio video svc',
    '109': 'NFY_PHOTO', //'File not supported',
    '110': 'Media lost',
    '111': 'License expired',
    '112': 'MAIN_MSG_CAM_INVALID_CICAM'
};

var MmpEventType = {
    unknown: 0,
    total_time_update: 1,
    icur_time_update: 2,
    icur_pos_update: 3,
    buffer_underflow: 4,
    buffer_high: 5,
    buffer_low: 6,
    playback_error: 7,
    eos: 8,
    ceof: 9,
    play_done: 10,
    step_done: 11,
    timeseek_done: 12,
    get_buf_ready: 13,
    replay: 14,
    speed_update: 15,
    video_num_ready: 16,
    mp3cover_ready: 17,
    mp3cover_eeror: 18,
    thumbnail_ready: 19,
    thumbnail_error: 20,
    rating_blocked: 21,
    channel_blocked: 22,
    prepare_done: 23,
    pvr_tricj_reach_valid_end: 24,
    cam_card_missing: 25	//for pvr palyback without cam card insert
};

var playbackCommand = {
    play: 'Play',
    pause: 'Pause',
    stop: 'Stop',
    ff: 'FF',
    fr: 'FR',
    sf: 'SF',
    sr: 'SR',
    step: 'Step',
    seekTime: 'timeSeek',
    seekByte: 'byteSeek',
    getMediaInfo: 'getmediainfo',
    repeat: 'repeat',
    getSubinfo: 'getsubinfo',
    getCurPos: 'getcurpos',
    getSpeed: 'getspeed',
    getZoomStatus: 'getzoomstatus',
    getPlayType: 'getplaytype',
    getAudInfo: 'getaudinfo',
    getMetaData: 'getmetadata',
    getThumbnailAsync: 'getthumbnailasync',
    getMp3CoverAsync: 'getmp3coverasync',
    getThumbnailData: 'getthumbnaildata',
    getStopInfo: 'getstopinfo',
    setStopInfo: 'setstopinfo',
    setSpeed: 'SetSpeed',
    selectSub: 'selectsub',
    selectAud: 'selectaud',
    setStopSub: 'setstopsub',
    setSubEnc: 'setsubenc',
    setSubDisplayRect: 'setsubdisplayrect',
    setDisplayRect: 'setdisplayrect',
    setSubFontSize: 'setsubfontsize',
    setSubtxtColor: 'setsubtxtcolor',
    setSubTimeOffset: 'setsubtimeoffset',
    setSubEdgColor: 'setsubedgcolor',
    setSubBkgColor: 'setsubbkgcolor',
    setZoom: 'setzoom',
    selectcc: 'selectcc',
    setSubEdgWidth: 'setsubedgwidth',
    setUnlockRating: 'setunlockrating',
    getRatingInfo: 'getRatingInfo',
    setSubtitleShowHide: 'setsubtitleshowhide'
};

var VideoSubCharacter = {
    'Central Europe': 'codepage1250',
    Cyrillic: 'codepage1251',
    'Western Europe': 'codepage1252',
    Greek: 'codepage1253',
    Turkish: 'iso8859_9',
    'UTF-8(Unicode)': 'utf8',
    Korean: 'korean'

};

var VideoSubDisplayRect = {
    '-2': ['0', '100'],
    '-1': ['0', '75'],
    '0': ['0', '50'],
    '1': ['0', '25'],
    '2': ['0', '0']
}

var VideoSubFontSize = {
    Small: '30',
    Standard: '40',
    Big: '50'
};

var VideoSubTextColor = {
    White: ['255', '255', '255', '255'],
    Blue: ['255', '0', '0', '255'],
    Red: ['255', '255', '0', '0'],
    Green: ['255', '0', '255', '0'],
    Yellow: ['255', '255', '255', '0'],
    Black: ['255', '0', '0', '0']
};

var VideoSubTimeOffset = {
    '-5': '-2500',
    '-4': '-2000',
    '-3': '-1500',
    '-2': '-1000',
    '-1': '-500',
    '0': '0',
    '1': '500',
    '2': '1000',
    '3': '1500',
    '4': '2000',
    '5': '2500'
};

var MmpPlayStatus = {
    Play: 0,
    Pause: 1,
    Speed: 2,
    SlowSpeed: 3
};

var cmpbCtrlSpeedType = {
    FR_64X: -6400000,
    FR_32X: -3200000,
    FR_16X: -1600000,
    FR_8X: -800000,
    FR_4X: -400000,
    FR_2X: -200000,
    Pause: 0,
    Play: 100000,
    FF_2X: 200000,
    FF_4X: 400000,
    FF_8X: 800000,
    FF_16X: 1600000,
    FF_32X: 3200000,
    FF_64X: 6400000,
    SF_1_2X: 200,
    SF_1_4x: 400,
    SF_1_8x: 800,
    SF_1_16x: 1600,
    SF_1_32x: 3200,
    SR_1_2X: -200,
    SR_1_4x: -400,
    SR_1_8x: -800,
    SR_1_16x: -1600,
    SR_1_32x: -3200
}

var playStatus = MmpPlayStatus.Pause;

var PlaySleep = {
    FF0: 'icon_play_bg pause',
    FF1: 'icon_play_bg',
    FF2: 'icon_ff_bg x2',
    FF4: 'icon_ff_bg x4',
    FF8: 'icon_ff_bg x8',
    FF16: 'icon_ff_bg x16',
    FF32: 'icon_ff_bg x32',
    FR0: 'icon_play_bg pause',
    'FR-2': 'icon_fr_bg x2',
    'FR-4': 'icon_fr_bg x4',
    'FR-8': 'icon_fr_bg x8',
    'FR-16': 'icon_fr_bg x16',
    'FR-32': 'icon_fr_bg x32',
    SR0: 'icon_play_bg pause',
    SF0: 'icon_play_bg pause',
    SF2: 'icon_sf_bg x2',
    SF4: 'icon_sf_bg x4',
    '-200': 'icon_sr_bg x2',
    '-400': 'icon_sr_bg x4',
    //'-6400000':,
    '-3200000': 'icon_fr_bg x32',
    '-1600000': 'icon_fr_bg x16',
    '-800000': 'icon_fr_bg x8',
    '-400000': 'icon_fr_bg x4',
    '-200000': 'icon_fr_bg x2',
    '0': 'icon_play_bg pause',
    '100000': 'icon_play_bg',
    '200000': 'icon_ff_bg x2',
    '400000': 'icon_ff_bg x4',
    '800000': 'icon_ff_bg x8',
    '1600000': 'icon_ff_bg x16',
    '3200000': 'icon_ff_bg x32',
    //'6400000':,
    '200': 'icon_sf_bg x2',
    '400': 'icon_sf_bg x4',
    //'800':800,
    //'1600':1600,
    //'3200':3200,
    SR_1_2X: 'icon_sr_bg x2',
    SR_1_4x: 'icon_sr_bg x4'
//SR_1_8x:-800,
//SR_1_16x:-1600,
//SR_1_32x:-3200

};

var video_sub_type = {
    none: 0,
    ttml: 1,
    divx: 2,
    ass: 3,
    srt: 4,
    cc: 5,
    dvb: 6,
    ttx: 7,
    isdb_cc: 8,
    isdb_txt: 9,
    ssa: 10,
    sami: 11,
    text: 12,
    vobsub: 13,
    blueray: 14,
    pgs: 15,
    sup: 16
};
/*
var video_aud_type = {
    none:0,
    mpeg:1,
    mp3:2,
    aac:3,
    dd:4,
    truehd:5,
    pcm:6,
    dts:7,
    dts_hd_hr:8,
    dts_hd_ma:9,
    wma:10,
    cook:11,
    vorbis:12,
    flac:13,
    monkey:14,
    ddp:15,
    he-aac:16,
    he-aac-v2:17,
    wma_pro:18,
    amr:19,
    awb:20,
    mpeg1:21,
    mpeg2:22
};
*/
var video_aud_type = {
    none: 'UNKNOWN',
    mpeg: 'MPEG',
    mp3: 'MP3',
    aac: 'AAC',
    dd: 'DD',
    truehd: 'TRUEHD',
    pcm: 'PCM',
    dts: 'DTS',
    dts_hd_hr: 'DTS_HD_HR',
    dts_hd_ma: 'DTS_HD_MA',
    wma: 'WMA',
    cook: 'COOK',
    vorbis: 'VORBIS',
    flac: 'FLAC',
    monkey: 'MONKEY',
    ddp: 'DDP',
    he_aac: 'HE-AAC',
    he_aac_v2: 'HE-ACC-V2',
    wma_pro: 'WMA_PRO',
    amr: 'AMR',
    awb: 'AWB',
    mpeg1: 'MPEG1',
    mpeg2: 'MPEG2'
};

var video_aud_full_name = {
    'UNKNOWN': 'UNKNOWN',
    'MPEG': 'Mpeg Audio',
    'MP3': 'MP3',
    'AAC': 'AAC',
    'DD': 'Dolby Digital',
    'TRUEHD': 'Dolby TrueHD',
    'PCM': 'PCM',
    'DTS': 'DTS',
    'DTS_HD_HR': 'DTS-HD High Resolution',
    'DTS_HD_MA': 'DTS-HD Master Audio',
    'WMA': 'WMA',
    'COOK': 'COOK',
    'VORBIS': 'VORBIS',
    'FLAC': 'FLAC',
    'MONKEY': 'MONKEY',
    'DDP': 'Dolby Digital Plus',
    'HE-AAC': 'HE-AAC',
    'HE-ACC-V2': 'HE-ACC-V2',
    'WMA_PRO': 'WMA Pro',
    'AMR': 'AMR',
    'AWB': 'AWB',
    'MPEG1': 'MPEG1',
    'MPEG2': 'MPEG2',
    'AC4': 'AC4'
};

var playback_media_type = {
    INVAL: 0,
    TITLE: 1,
    DIRECTOR: 2,
    COPYRIGHT: 3,
    YEAR: 4,
    DATE: 5,
    GENRE: 6,
    DURATION: 7,
    SIZE: 8,
    ARTIST: 9,
    ALBUM: 10,
    TRACK: 11,
    BITRATE: 12,
    PROTECT: 13,
    CREATE_TIME: 14,
    ACCESS_TIME: 15,
    MODIFY_TIME: 16,
}

var video_aud_impared_type = {
    none: 0,
    hearing: 1,
    visual: 2,
    mixed: 3
}

function playbackStopInfo(inst) {
    ret = -1;
    var res = playbackOperator(inst, playbackCommand.getStopInfo);
    if (res) {
        res = JSON.parse(res);
        ret = res.ITEMS[0].bgethasstopinfo;
    }
    return ret;
}

function playbackOperator(handle, Operator, value, extendValue) {
    console.log("playbackOperator Operator = " + Operator + ";value = " + value);
    if (typeof (handle) == 'undefined' || !handle) {
        return;
    }
    var isGet = false;
    if (Operator == playbackCommand.play) {
        playStatus = MmpPlayStatus.Play;
    } else if (Operator == playbackCommand.pause) {
        playStatus = MmpPlayStatus.Pause;
    } else if (Operator == playbackCommand.ff || Operator == playbackCommand.fr) {
    	// 20170918 [TF518PHIEUMTK01-1429]
		var arg = '{"PARAMETER":{"handle":' + handle + ',"operator":"' + Operator + '"' + parameter + ',"REQUEST":"SET"}}';
        var isSuccess = mtvObj.playbackOperator(arg);
		if (isSuccess != -1) // end
        	playStatus = MmpPlayStatus.Speed;
    }
    var parameter = '';
    switch (Operator) {
        case playbackCommand.seekTime:
            parameter = ',"seek_time":' + value;
            break;
        case playbackCommand.selectSub:
            parameter = ',"select_sub_idx":"' + value + '"';
            break;
		case playbackCommand.selectcc:
            parameter = ',"select_cc_idx":"' + value + '"';
            break;
        case playbackCommand.selectAud:
            parameter = ',"select_aud_idx":"' + value + '","select_aud_dmxidx":' + extendValue;
            break;
        case playbackCommand.setSubEnc:
            parameter = ',"setsubencinfo":"' + VideoSubCharacter[value] + '"';
            break;
        case playbackCommand.setSubDisplayRect:
            parameter = ',"setsubdisplayrect_u4X":"' + VideoSubDisplayRect[value][0] + '","setsubdisplayrect_u4Y":"' + VideoSubDisplayRect[value][1] + '","setsubdisplayrect_u4W":1280,"setsubdisplayrect_u4H":620';
            break;
        case playbackCommand.setDisplayRect:
            parameter = ',"setdisplayrect_u4X":0,"setdisplayrect_u4Y":0,"setdisplayrect_u4W":1000,"setdisplayrect_u4H":1000';
            break;
        case playbackCommand.setSubFontSize:
            parameter = ',"setsubfontsizetype":"custom","setsubfontsizevalue":"' + VideoSubFontSize[value] + '"';
            break;
        case playbackCommand.setSubtxtColor:
            parameter = ',"setsubtxtclr_alpha":"' + VideoSubTextColor[value][0] + '","setsubtxtclr_r":"' + VideoSubTextColor[value][1] + '","setsubtxtclr_g":"' + VideoSubTextColor[value][2] + '","setsubtxtclr_b":"' + VideoSubTextColor[value][3] + '"';
            break;
        case playbackCommand.setSubTimeOffset:
            parameter = ',"setsubtimeoffset_type":"userdef","setsubtimeoffset_value":"' + value + '"';
            break;
        case playbackCommand.setSubEdgWidth:
            parameter = ',"setsubedgwidth":"2"';
            break;
        case playbackCommand.setSubEdgColor:
            if (value == 1) {
                parameter = ',"setsubedgclr_alpha":"255","setsubedgclr_r":"255","setsubedgclr_g":"255","setsubedgclr_b":"255"';
            } else {
                parameter = ',"setsubedgclr_alpha":"255","setsubedgclr_r":"0","setsubedgclr_g":"0","setsubedgclr_b":"0"';
            }
            break;
        case playbackCommand.getSubinfo:
            parameter = ',"getsubinfoidx":"' + value + '"';
            isGet = true;
            break;
        case playbackCommand.getAudInfo:
            parameter = ',"getaudinfoidx":"' + value + '"';
            isGet = true;
            break;
        case playbackCommand.getThumbnailAsync:
            parameter = ',"getthumbnailasyncwidth":"' + value.width + '","getthumbnailasyncheight":"' + value.height + '"';
            isGet = true;
            break;
        case playbackCommand.getMp3CoverAsync:
            parameter = ',"getmp3coverasyncwidth":"' + value.width + '","getmp3coverasyncheight":"' + value.height + '"';
            isGet = true;
            break;
        case playbackCommand.setSpeed:
            parameter = ',"SetSpeedValue":' + value;
            break;
        case playbackCommand.setStopInfo:
            parameter = ',"bsethasstopinfo":' + value;
            break;
        case playbackCommand.setSubtitleShowHide:
            parameter = ',"bsethasstopinfo":' + value;
            break;
        case playbackCommand.getMetaData:
            parameter = ',"getmetaType":' + value;
            isGet = true;
            break;
        case playbackCommand.getThumbnailData:
        case playbackCommand.getMediaInfo:
        case playbackCommand.getCurPos:
        case playbackCommand.getSpeed:
        case playbackCommand.getZoomStatus:
        case playbackCommand.getPlayType:
        case playbackCommand.getThumbnail:
        case playbackCommand.getMp3Cover:
        case playbackCommand.getStopInfo:
        case playbackCommand.getRatingInfo:
            isGet = true;
            break;

    }

    if (isGet) {
        var arg = '{"PARAMETER":{"handle":' + handle + ',"operator":"' + Operator + '"' + parameter + ',"REQUEST":"QUERY"}}';
        return mtvObj.playbackGetInfo(arg);
    } else {
        var arg = '{"PARAMETER":{"handle":' + handle + ',"operator":"' + Operator + '"' + parameter + ',"REQUEST":"SET"}}';
        return mtvObj.playbackOperator(arg);
    }
}
;

function playbackImgOpen(path) {
    var paramObj = {'path': path,'REQUEST': 'SET'};
    var arg = {};
    arg.PARAMETER = paramObj;
    return mtvObj.imgOpen(JSON.stringify(arg));
}

function playbackImgClose() {
    mtvObj.imgClose('');
}

function playbackImgInit() {
    mtvObj.imgInit('');
}

function playbackImgDeinit() {
    mtvObj.imgDeinit('');
}

function playbackImgGetThumbnail(path, width, height) {
    var paramObj = {'path': path,'width': width,'height': height,'REQUEST': 'QUERY'};
    var arg = {};
    arg.PARAMETER = paramObj;
    //var arg = '{"PARAMETER":{"path":"' + path + '","width":'+width+',"height":'+height+',"REQUEST":"QUERY"}}';
    var res = mtvObj.imgGetThumbnailPath(JSON.stringify(arg));
    if (res) {
        res = JSON.parse(res);
        if (res.STATUS == 0)
            return res.ITEMS[0].thumbnailPath;
    }
    return null;
}

var imgPlaybackCommand = {
    rotate: 'Rotate',
    zoom: 'Zoom',
    display: 'Display',
    tfx_effect_play: 'Tfx_Effect_Play',
    tfx_effect_stop: 'Tfx_Effect_Stop'
};

var imgPlaybackRotateType = {
    rotate_0: 0,
    rotate_0_with_flip: 1,
    rotate_180: 2,
    rotate_180_with_flip: 3,
    rotate_270_with_flip: 4,
    rotate_90: 5,
    rotate_90_with_flip: 6,
    rotate_270: 7
};

var imgPlaybackTransitionType = {
    'Wipe left': 0,
    'Wipe right': 1,
    'Wipe up': 2,
    'Wipe down': 3,
    'Box in': 4,
    'Box out': 5,
    blending: 6,
    Dissolve: 7,
    interlace_h: 8,
    interlace_v: 9,
    split_in_h: 10,
    split_out_h: 11,
    split_in_v: 12,
    split_out_v: 13,
    osd_blending: 14
};

function playbackImgOperator(action, value) {
    var parameter = '';
    switch (action) {
        case imgPlaybackCommand.rotate:
            parameter = ',"rotate":' + value;
            break;
        case imgPlaybackCommand.zoom:
            parameter = ',"zoom":' + value;
            break;
        case imgPlaybackCommand.tfx_effect_play:
            parameter = ',"effect":' + value;
            break;
        case imgPlaybackCommand.tfx_effect_stop:
            parameter = '';
            break;
    }
    var arg = '{"PARAMETER":{"operator":"' + action + '"' + parameter + ',"REQUEST":"SET"}}';
    mtvObj.imgOperator(arg);
}

function stopContentBrowser(isExitPlayer) {
    if (typeof (isExitPlayer) == 'undefined' || !isExitPlayer) {
        removeCBEventListener(EventListenerName.cmpbNotify, contentBrowserCmpbNotify);
        contentBrowserObj.doStop();
        if (typeof (isExitPlayer) != 'undefined') {
            dmrPlayStop();
        }
        clearThumbnail();
        if (curBrowserType == BrowserType.Dlna) {
            stopMediaServer();
            stopDlnaDmr();
        }
    } else {
        videoPlayObj.videoDelInit();
    }
    mtvObj.acfgSetConfigValue('g_custom_base__supershopdemo_status', 0);
    mtvObj.acfgSetConfigItemValue(stvapi_config.mmp_play_state, icl_mmp_play_status.off);
    mtvObj.acfgSetConfigItemValue(stvapi_config.mmp_source_type, icl_mmp_source_type.off);
    
    if (mtvObj)	
    {
	mtvObj.acfgSetConfigValue("g_custom_base__cb_option_show", 0);
    }
	
    startDtvService();
}

function getPinCode() {
    return mtvObj.getPassword();
}

function doFocus(id) {
    console.log("doFocus id = " + id);
    if (id) {
        var children = $('#' + id).children().length;

        if (children > 0 && ($('#' + id).children(':eq(0)').attr('tabindex'))) {
            $('#' + id).children(':eq(0)').focus();
        } else {
            $('#' + id).focus();
        }
    }

}

function setItemColorKey(content, value) {
    console.log("setItemColorKey value = " + value);
    var text = $(content).text();
    console.log("text = " + text);
    var htmltext = $(content).html();
    var html = htmltext.substring(0, htmltext.lastIndexOf(text));
    $(content).html(html + getTranslate(value));
}

function getFormatDate(dateObj) {
    return dateObj.year + '/' + dateObj.month + '/' + dateObj.day;
}

function baseOptionNotify(itemObj, needClose) {
    if(typeof needClose == 'undefined' || needClose){
       /* Stephen TF518PHIEUMTK01_QPL-57, follow 2018_UIS_UI_0.1.pdf 
			page: 10. Options 
		*/
	   //closeOptionDialog();
    }

    if (!itemObj.hasOwnProperty("storage") || itemObj.storage == 1) {
        localStorage.setItem(itemObj.name.replace(new RegExp(" ", "g"), '_'), itemObj.curValue);
    }
}

function getRandom(min, max) {
    var r = Math.random() * (max - min);
    var re = Math.round(r + min);
    re = Math.max(Math.min(re, max), min);
    return re;
}

var MarqueeObj = function() {
    this.marqueeClass;
    this.lastMarqueeId;
    this.marqueeContent;
}

MarqueeObj.prototype.stopScroll = function() {
    console.log("stopScroll");
    if (this.lastMarqueeId && this.marqueeContent) {
        $('#' + this.lastMarqueeId).text(this.marqueeContent).removeClass(this.marqueeClass).removeClass('srcoll');
    }
    this.marqueeClass = '';
    this.lastMarqueeId = null;
    this.marqueeContent = null;
}


MarqueeObj.prototype.startScroll = function(id) {
    if (id) {
        console.log("scroll_id:" + id)
    } else {
        return;
    }
    if (this.marqueeClass) {
        this.stopScroll();
    }
    var obj = document.getElementById(id);
    var tempWidth = obj.scrollWidth - obj.offsetWidth; // length of can scroll
    if (tempWidth > 0) {
        this.marqueeWidth = tempWidth;
        this.lastMarqueeId = id;
        this.marqueeContent = $("#" + id).text();
        console.log("scroll_txt:" + this.marqueeContent);
        obj.innerHTML += ("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.marqueeContent + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        var num = Math.floor(obj.scrollWidth / 100);
        if (num > 13)
            num = 13;
        this.marqueeClass = 'srcoll marquee' + num;
        $(obj).addClass(this.marqueeClass);
    }
}

var marqueeObj = new MarqueeObj();

function clone(myObj) {
    if (typeof (myObj) != 'object')
        return myObj;
    if (myObj == null)
        return myObj;

    var myNewObj = new Object();

    for (var i in myObj)
        myNewObj[i] = clone(myObj[i]);

    return myNewObj;
}

function waitLoading(isShow) {
    if (isShow) {
        if ($("#scan_loading").css('display') == 'none') {
            $("#scan_loading").show();
        }
    } else {
        if ($("#scan_loading").css('display') != 'none') {
            $("#scan_loading").hide();
        }
    }
}

function startDtvService() {
    //1 msgconvert(netflix);2 nettv;0 other app
    var appStatus = mtvObj.acfgGetConfigValue('g_misc__next_app_status');
    if (appStatus == 0) {
        mtvuiUtil.dtvServiceAction(true);
    }
}

function messageCmdListener(data) {
    obj = JSON.parse(data);
    if (obj.type == "command" && obj.action == "selectSource") {
        contentBrowserObj.doStop();
    }
}
mtvuiUtil.messageListener = messageCmdListener;
