/*
Event trigger:

"ArrowUpClick"
"ArrowDownClick"

*/

var g_MaxValue = 0, g_MinValue = 0, g_total_value = 0;


/* initial function */
function Create_slider(body,slider_index, Current_Value, Max_Value, Min_Value)
{
	var index = slider_index;
	$(body).append("<div id=slider_root_"+index+" tabindex=0 class=slider_root onfocus=root_onfocus(slider_root_"+index+") onblur=root_onblur(slider_root_"+index+") ></div>");
	$("#slider_root_"+index+"").append("<div id=slider_title_"+index+" tabindex=0 class=slider_title>Brightness</div>");
	
	$("#slider_root_"+index+"").append("<p id=slider_max_value_"+index+" tabindex=0 class=slider_value style=top:60px>"+ Max_Value +"</p>");
	$("#slider_root_"+index+"").append("<p id=slider_min_value_"+index+" tabindex=0 class=slider_value style=top:337px>"+ Min_Value +"</p>");
	$("#slider_root_"+index+"").append("<p id=slider_med_value_"+index+" tabindex=0 class=slider_value style=top:200px>"+ parseInt((Max_Value + Min_Value + 1) / 2) +"</p>");
	
	$("#slider_root_"+index+"").append("<img id=img_arrow_up_"+index+" class=img_arrow_up  src=../2K16_4K_UX_Asset/gcc/slider_arrow_up_normal.png>");
	$("#slider_root_"+index+"").append("<img id=img_arrow_down_"+index+" class=img_arrow_down src=../2K16_4K_UX_Asset/gcc/slider_arrow_down_normal.png>");
	
	$("#slider_root_"+index+"").append("<div id=slider_foreground_"+index+" tabindex=0 class=slider_foreground></div>");
	$("#slider_root_"+index+"").append("<div id=slider_background_"+index+" tabindex=0 class=slider_background></div>");
	$("#slider_root_"+index+"").append("<div id=slider_content_"+index+" class=wrapper></div>");
        /* TF517PHIEUMTK05-451*/
	$("#slider_root_"+index+"").append("<div id=slider_txt_"+index+" tabindex=0 class=slider_txt></div>");
	$("#slider_content_"+index+"").append("<p id=slider_value_"+index+" tabindex=0 class=center>"+ Current_Value +"</p>");
	
	/* initial value*/
	g_total_value = $( "#slider_background_"+index+"" ).height();
	var value = g_total_value - (g_total_value / (Max_Value - Min_Value) * (Current_Value - Min_Value));	
	$( "#slider_background_"+index+"").height(value);
	
	
	g_MaxValue = Max_Value;
	g_MinValue = Min_Value;
}

/* focus style */
function root_onfocus(obj) 
{	
	/*
	$("#slider_value_"+index+"").css('color', 'rgba(0%,0%,0%,1)');		
	$("#slider_background_"+index+"").css('background-color', '#464749');
	$("#slider_foreground_"+index+"").css('background-color', '#76d7d6');
	$("#img_arrow_up_"+index+"").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_up_highlighted.png");
	$("#img_arrow_down_"+index+"").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_down_highlighted.png");
	*/
	var name_array = obj.id.split('_');
	var focus_index = parseInt(name_array[2]);
	$("#slider_value_"+focus_index+"").css('color', 'rgba(0%,0%,0%,1)');		
	$("#slider_background_"+focus_index+"").css('background-color', '#464749');
	$("#slider_foreground_"+focus_index+"").css('background-color', '#76d7d6');
	$("#img_arrow_up_"+focus_index+"").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_up_highlighted.png");
	$("#img_arrow_down_"+focus_index+"").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_down_highlighted.png");
}

/* lossfocus style */
function root_onblur(obj)
{
	var name_array = obj.id.split('_');
	var blur_index = parseInt(name_array[2]);	
	$("#slider_value_"+blur_index+"").css('color', 'rgba(0%,0%,0%,0.45)');
	$("#slider_background_"+blur_index+"").css('background-color', '#292B2D');
	$("#slider_foreground_"+blur_index+"").css('background-color', '#676768');
	$("#img_arrow_up_"+blur_index+"").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_up_normal.png");
	$("#img_arrow_down_"+blur_index+"").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_down_normal.png");
}

function _calculate_background_height(current_value)
{	
	return g_total_value - ( g_total_value / (g_MaxValue - g_MinValue) * (current_value - g_MinValue) );
}

$(document).on('keydown', function (evt) {
	
	var obj = document.activeElement;
	var name_array = obj.id.split('_');
	var obj_index = parseInt(name_array[2]);	
	/*
	if($("#slider_root_"+index+"").attr('id') != obj.id)
	{
		return;
	}*/
	
	var value = parseInt($("#slider_value_"+obj_index+"").text());
	
	if (evt.keyCode == KeyEvent.DOM_VK_UP) 
	{
		$("#img_arrow_up_"+obj_index+"").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_up_pressed.png");			

		if(CurrentList.name == "SleepTimer")
			value += 5;
		else
			value++;
		if (value > g_MaxValue)
		{
			value = g_MaxValue;
		}
		else if (value < g_MinValue)
		{
			value = g_MinValue;
		}
		$( "#slider_background_"+obj_index+"").height(_calculate_background_height(value));
		$("#slider_value_"+obj_index+"").text(value);
		
		$("#slider_root_"+obj_index+"").trigger({
			type: "ArrowUpClick",
			message: $("#slider_value_"+obj_index+"").text(),		
		});
	}
	
	if (evt.keyCode == KeyEvent.DOM_VK_DOWN) 
	{
		$("#img_arrow_down_"+obj_index+"").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_down_pressed.png");

		if(CurrentList.name == "SleepTimer")
			value -= 5;
		else
			value--;
		if (value > g_MaxValue)
		{
			value = g_MaxValue;
		}
		else if (value < g_MinValue)
		{
			value = g_MinValue;
		}
		$( "#slider_background_"+obj_index+"").height(_calculate_background_height(value));
		$("#slider_value_"+obj_index+"").text(value);
		
		$("#slider_root_"+obj_index+"").trigger({
			type: "ArrowDownClick",
			message: $("#slider_value_"+obj_index+"").text(),		
		});
	}
});

$(document).on('keyup', function (evt) {
	
	var obj = document.activeElement;
	var name_array = obj.id.split('_');
	var obj_index = parseInt(name_array[2]);
	/*
	if($("#slider_root_"+index+"").attr('id') != obj.id)
	{
		return;
	}*/
	
	if (evt.keyCode == KeyEvent.DOM_VK_UP) 
	{
		$("#img_arrow_up_"+obj_index+"").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_up_highlighted.png");
		
		$("#slider_root_"+obj_index+"").trigger({
			type: "ArrowUpClick",
			message: $("#slider_value_"+obj_index+"").text(),		
		});
		
		
	}
	if (evt.keyCode == KeyEvent.DOM_VK_DOWN) 
	{
		$("#img_arrow_down_"+obj_index+"").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_down_highlighted.png");
		
		$("#slider_root_"+obj_index+"").trigger({
			type: "ArrowDownClick",
			message: $("#slider_value_"+obj_index+"").text(),		
		});			
	}	
});