/*
Event trigger:

"ArrowUpClick"
"ArrowDownClick"

*/

var g_MaxValue = 0, g_MinValue = 0, g_total_value = 0;


/* initial function */
function Create_slider(body, Current_Value, Max_Value, Min_Value)
{
	$(body).append("<div id=slider_root tabindex=0 onfocus=root_onfocus() onblur=root_onblur() ></div>");
	$("#slider_root").append("<div id=slider_title tabindex=0>Brightness</div>");
	
	$("#slider_root").append("<p id=slider_max_value tabindex=0 class=slider_value style=top:40px>"+ Max_Value +"</p>");
	$("#slider_root").append("<p id=slider_min_value tabindex=0 class=slider_value style=top:317px>"+ Min_Value +"</p>");
	$("#slider_root").append("<p id=slider_med_value tabindex=0 class=slider_value style=top:180px>"+ ((Max_Value + Min_Value) / 2) +"</p>");
	
	$("#slider_root").append("<img id=img_arrow_up src=../2K16_4K_UX_Asset/gcc/slider_arrow_up_normal.png>");
	$("#slider_root").append("<img id=img_arrow_down src=../2K16_4K_UX_Asset/gcc/slider_arrow_down_normal.png>");
	
	$("#slider_root").append("<div id=slider_foreground tabindex=0></div>");
	$("#slider_root").append("<div id=slider_background tabindex=0></div>");
	$("#slider_root").append("<div id=slider_content class=wrapper></div>");
        /* TF517PHIEUMTK05-451*/
	$("#slider_root").append("<div id=slider_txt tabindex=0></div>");
	$("#slider_content").append("<p id=slider_value tabindex=0 class=center>"+ Current_Value +"</p>");
	
	/* initial value*/
	g_total_value = $( "#slider_background" ).height();
	var value = g_total_value - (g_total_value / (Max_Value - Min_Value) * (Current_Value - Min_Value));	
	$( "#slider_background" ).height(value);
	
	
	g_MaxValue = Max_Value;
	g_MinValue = Min_Value;
}

/* focus style */
function root_onfocus() 
{	
	$( "#slider_value" ).css('color', 'rgba(0%,0%,0%,1)');		
	$('#slider_background').css('background-color', '#464749');
	$('#slider_foreground').css('background-color', '#76d7d6');
	$("#img_arrow_up").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_up_highlighted.png");
	$("#img_arrow_down").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_down_highlighted.png");
}

/* lossfocus style */
function root_onblur()
{	
	$( "#slider_value" ).css('color', 'rgba(0%,0%,0%,0.45)');
	$('#slider_background').css('background-color', '#292B2D');
	$('#slider_foreground').css('background-color', '#676768');
	$("#img_arrow_up").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_up_normal.png");
	$("#img_arrow_down").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_down_normal.png");
}

function _calculate_background_height(current_value)
{	
	return g_total_value - ( g_total_value / (g_MaxValue - g_MinValue) * (current_value - g_MinValue) );
}

$(document).on('keydown', function (evt) {
	
	var obj = document.activeElement;
	if($('#slider_root').attr('id') != obj.id)
	{
		//console.log($( '#slider_root' ).id);
		//console.log( obj.id);
		//console.log("if($( '#slider_root' ) != obj)");
		return;
	}
	
	var value = parseInt($("#slider_value").text());
	
	if (evt.keyCode == KeyEvent.DOM_VK_UP) 
	{
		$("#img_arrow_up").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_up_pressed.png");			

		if(CurrentList.name == "SleepTimer")
			value += 5;
		else
			value++;
		if (value > g_MaxValue)
		{
			value = g_MaxValue;
		}
		else if (value < g_MinValue)
		{
			value = g_MinValue;
		}
		$( "#slider_background" ).height(_calculate_background_height(value));
		$("#slider_value").text(value);
		
		$("#slider_root").trigger({
			type: "ArrowUpClick",
			message: $("#slider_value").text(),		
		});
	}
	
	if (evt.keyCode == KeyEvent.DOM_VK_DOWN) 
	{
		$("#img_arrow_down").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_down_pressed.png");

		if(CurrentList.name == "SleepTimer")
			value -= 5;
		else
			value--;
		if (value > g_MaxValue)
		{
			value = g_MaxValue;
		}
		else if (value < g_MinValue)
		{
			value = g_MinValue;
		}
		$( "#slider_background" ).height(_calculate_background_height(value));
		$("#slider_value").text(value);
		
		$("#slider_root").trigger({
			type: "ArrowDownClick",
			message: $("#slider_value").text(),		
		});
	}
});

$(document).on('keyup', function (evt) {
	
	var obj = document.activeElement;
	if($('#slider_root').attr('id') != obj.id)
	{
		//console.log($( '#slider_root' ).id);
		//console.log( obj.id);
		//console.log("if($( '#slider_root' ) != obj)");
		return;
	}
	
	if (evt.keyCode == KeyEvent.DOM_VK_UP) 
	{
		$("#img_arrow_up").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_up_highlighted.png");
		
		$("#slider_root").trigger({
			type: "ArrowUpClick",
			message: $("#slider_value").text(),		
		});
		
		
	}
	if (evt.keyCode == KeyEvent.DOM_VK_DOWN) 
	{
		$("#img_arrow_down").attr('src',"../2K16_4K_UX_Asset/gcc/slider_arrow_down_highlighted.png");
		
		$("#slider_root").trigger({
			type: "ArrowDownClick",
			message: $("#slider_value").text(),		
		});			
	}	
});