function getChannelLogo(name) {
    if (!getChannelLogo.prototype.mtvObj) {
        getChannelLogo.prototype.mtvObj = new MtvObj();
        getChannelLogo.prototype.country = getChannelLogo.prototype.mtvObj.getCurrentCountry();
        getChannelLogo.prototype.iconPath = (function () {
            if (window.location.href.match(/EU\/html5/))
                return "../../Slice/res/ChLogo_EU/PreDef/";
            else if (window.location.href.match(/\/html-ui/))
                return "./ChLogo/PreDef/";
            else
                return "/3rd_rw/ChLogo/PreDef/";
        })();
    }

    if (getChannelLogo.prototype.mtvObj && 0 == getChannelLogo.prototype.mtvObj.getChLogoStatus()){
        /* channel logo switch is off */
        return null;
    }
    var iObj = null;
    var country = getChannelLogo.prototype.country;
    name = name.replace(/^\d+_\d+ +/, ''); // remove satellite prefix
    //name = name.replace(/\/.*$/, '');      // remove postfix begin with "/"
    name = name.replace(/ /g, '').toLowerCase();
    var iList = mtvuichLogoDB[name];
    if (iList && iList.length > 0) {
        iObj = iList[0];
        for (var i in iList)
            if (iList[i][0] == country)
                iObj = iList[i];
    }
    if (iObj) {
        var pImg = getChannelLogo.prototype.iconPath + iObj[1] + ".png";
        if (pImg.substr(0, 1) != '/') // relative path
            pImg = get_base_url() + pImg;
        return pImg;
    } else
        return null;
}

var mtvuichLogoDB = {"humor24/nostnet": [["NLD", 1165]], "": [["CHE", 2268]], "kinderkanal": [["DEU", 815]], "rtv1": [["SRB", 1776]], "hse24extrahd": [["DEU", 802]], "davejavu": [["GBR", 2413]], "rtlliving": [["DEU", 849]], "skynews": [["SVN", 1927], ["GBR", 2468]], "eurosport_hd": [["DNK", 466]], "rrokum": [["HRV", 314], ["SRB", 1772]], "rtv7": [["NLD", 1180]], "ndrfsshhd": [["DEU", 904]], "edusat": [["POL", 1335]], "sporttv3hd": [["SVN", 2033], ["SVN", 2033]], "foxmovies": [["SVN", 1967]], "maxxi": [["UKR", 2514]], "rtlplus": [["HRV", 324]], "lalocale": [["FRA", 579]], "bbconehd": [["NLD", 1267]], "mcmtop": [["FRA", 596], ["SVN", 1894]], "antenabahia": [["ESP", 2068]], "zdf_neohd": [["DEU", 900]], "digifilm": [["ROU", 1523], ["ROU", 1577]], "bibel": [["DEU", 754]], "comedycentralhd": [["INT", 2786]], "365dnei": [["RUS", 1607]], "planettv": [["SVN", 2043]], "bayerischesfss\u00ef\u00bf\u00bdd": [["DEU", 762]], "humor24": [["NLD", 1165]], "tvbiznes": [["POL", 1359]], "beurtv": [["FRA", 504]], "renbaltija": [["LVA", 1049]], "espansionetv": [["ITA", 995]], "ekkanaal": [["NLD", 1252]], "bbcfood": [["GBR", 2390]], "discoveryid": [["INT", 2739]], "24sterren": [["NLD", 1170]], "tvvalentino": [["BGR", 280]], "l`equipe21": [["FRA", 718]], "grandlilletv": [["FRA", 697]], "nosjournaal24": [["NLD", 1171]], "axnspin": [["POL", 1447]], "dwtv": [["DEU", 777]], "3+viasat": [["LVA", 1030]], "ntvplusnashekino": [["RUS", 1699]], "ultrablue": [["FRA", 667]], "cmc": [["HRV", 302], ["SVN", 1841], ["SVN", 1961]], "puntdosrtvv": [["ESP", 2136]], "natgeowild": [["NLD", 1149], ["SVN", 1998], ["INT", 2718]], "red": [["GBR", 2459]], "passiexxx": [["NLD", 1264]], "myzen": [["SVN", 1996]], "zdf": [["DEU", 902], ["DEU", 902], ["NLD", 1262]], "vaskanal": [["SVN", 1946]], "mediashop-meineeinkaufswelt": [["AUT", 61]], "7tv": [["RUS", 1605]], "rtbfhd2": [["BEL", 185]], "cbbcchannel": [["GBR", 2493]], "histoire": [["FRA", 567]], "viastoria": [["FRA", 670]], "bluemoviehd": [["AUT", 72]], "tvpinfo": [["POL", 1424]], "skyaction": [["DEU", 854]], "bbcparliament": [["GBR", 2381]], "panda": [["ESP", 2106]], "\u043a\u043e\u0434\u0438\u043d": [["UKR", 2533]], "fr2": [["FRA", 688]], "dr1": [["DNK", 434], ["DNK", 456]], "o2tv": [["RUS", 1710]], "dr2": [["DNK", 435]], "njam!": [["BEL", 166]], "24sport": [["NLD", 1169]], "litetv": [["NLD", 1259]], "jojhd": [["SVK", 1788]], "herostv": [["BGR", 248]], "bbc2wales": [["GBR", 2386]], "zivatv": [["SVK", 1807]], "itvhd": [["GBR", 2495]], "disney": [["SVN", 1848], ["INT", 2680], ["INT", 2742]], "ndrfsmvhd": [["DEU", 904]], "mdrsachsen": [["AUT", 59], ["DEU", 912]], "hdanimalplanet": [["SVN", 1830], ["SVN", 1971]], "rtlklub": [["HUN", 967], ["ROU", 1594]], "skysporthdnews": [["INT", 2777]], "investigationdisc": [["NLD", 1254]], "disneychannelhd": [["DEU", 772]], "tgrthaber": [["TUR", 2615]], "mtvshows": [["INT", 2712]], "astrotv": [["DEU", 752]], "vijftv": [["BEL", 172]], "cinenova2nl": [["NLD", 1112]], "bbccbeebies": [["POL", 1429]], "stylenetwork": [["ROU", 1597]], "puls2": [["POL", 1408]], "alsat_m": [["MKD", 1079]], "101": [["NLD", 1105]], "puls4": [["AUT", 22]], "1\u0434\u0456\u043b\u043e\u0432\u0438\u0439": [["UKR", 2506]], "bbcworld": [["GBR", 2399]], "qtom": [["DEU", 836]], "tvdrenthe": [["NLD", 1181]], "drk": [["DNK", 436]], "moviesmart": [["TUR", 2630]], "goldstartv": [["DEU", 792]], "bbcone": [["GBR", 2496]], "zenderoverzichthd": [["NLD", 1238]], "bashkirtv": [["RUS", 1615]], "rtvinashekino": [["RUS", 1729]], "zapadoslovenskatelevizia": [["SVK", 1800]], "canalplus": [["FRA", 710], ["FRA", 710]], "svt2hd": [["DNK", 470]], "skyturk360": [["TUR", 2606]], "hdhistorytv": [["SVN", 1882]], "bnsat": [["SVN", 1958]], "dr_hd": [["DNK", 455]], "gtrkirkutsk": [["RUS", 1637]], "e!entertainmenthd": [["NLD", 1312]], "cinepolar": [["FRA", 730]], "dmax": [["INT", 2743]], "hrfernsehenhd": [["CHE", 2367]], "eurosporthddut": [["NLD", 1130]], "mediatv": [["SVN", 1896], ["SVN", 1896]], "skykrimi": [["DEU", 864]], "kinowelt": [["DEU", 816]], "tvnasa": [["SVK", 1806]], "rheinneckarfernsehen": [["DEU", 843]], "goltelevision": [["ESP", 2197]], "viasatnature": [["BGR", 288], ["SVN", 1936]], "ned3hd": [["NLD", 1207]], "m6": [["FRA", 708]], "m1": [["HUN", 957]], "3puls_01": [["DNK", 458]], "m2": [["HUN", 958]], "kabeldeutschlandinfo": [["DEU", 811]], "sport1livehd": [["NLD", 1230]], "e2": [["TUR", 2570]], "ondajerez": [["ESP", 2131]], "historyhddut": [["NLD", 1220]], "canvashd": [["BEL", 167]], "kanalaustral": [["FRA", 576]], "gtrkvolgograd": [["RUS", 1648]], "hse24trend": [["DEU", 930]], "ndrfshh": [["DEU", 826]], "ndrfshd": [["CHE", 2282]], "hdcinemax2": [["SVN", 1972]], "sporttv2": [["SVN", 2032], ["SVN", 2032]], "sporttv3": [["SVN", 2034], ["SVN", 2034]], "ntvplusnashenovoekino": [["RUS", 1700]], "adult": [["SVN", 1829], ["SVN", 1952]], "jml": [["DEU", 807]], "trvmuzhi": [["RUS", 1741]], "norwichunion": [["GBR", 2450]], "rtltelekids": [["NLD", 1279]], "tnv": [["RUS", 1736]], "telegrenoble": [["FRA", 636]], "challengetv": [["GBR", 2403]], "yelotv-channel": [["BEL", 198]], "joiz": [["CHE", 2252]], "mgmmoviechannel": [["NLD", 1222]], "sinematvaile": [["TUR", 2605]], "espnamerica": [["INT", 2685]], "bbc1": [["GBR", 2496]], "eurosportsd": [["POL", 1337]], "bbc3": [["NLD", 1244]], "bbc2": [["GBR", 2383]], "m6ch": [["CHE", 2256]], "bbc4": [["GBR", 2387]], "\u0432\u0438\u043d\u0442\u0430\u0436": [["UKR", 2547]], "bbconescotland": [["GBR", 2395]], "\u043c2": [["UKR", 2513]], "\u043c1": [["UKR", 2536]], "tv2film": [["DNK", 448]], "e!entertainment": [["NLD", 1312], ["INT", 2765]], "extasitv": [["FRA", 556]], "tvsutel": [["MKD", 1083]], "kcn1": [["SVN", 1992]], "mtvlivehd": [["NLD", 1258], ["CHE", 2299], ["CHE", 2300]], "dolcesporthd": [["ROU", 1584]], "la8": [["ITA", 1007]], "la9": [["ITA", 1008]], "la5": [["ITA", 1004]], "la7": [["ITA", 1005]], "rtvoost": [["NLD", 1185]], "la1": [["ESP", 2176]], "primestarhd": [["BEL", 143]], "13thstreetuniversal": [["INT", 2762]], "eredivisielive2": [["NLD", 1211]], "eredivisielive3": [["NLD", 1211]], "cielo": [["ITA", 990]], "foxsports1eredivisiehd": [["NLD", 1284]], "rtv-7": [["NLD", 1180]], "eredivisielive4": [["NLD", 1211]], "polsatnews": [["POL", 1395]], "tracetropical": [["FRA", 652]], "cinestaraction": [["SVN", 1839]], "rtl8hd": [["NLD", 1276], ["NLD", 1276]], "w24": [["AUT", 1]], "swrfernsehenbw": [["DEU", 876]], "pinkzabava": [["SVN", 2009]], "aljazeeraenglish": [["NLD", 1260], ["CHE", 2305]], "daring!tv": [["CHE", 2263]], "tvpinfopoznan": [["POL", 1420]], "ardrb": [["DEU", 749]], "bktv": [["SVN", 1835], ["SVN", 1957]], "danceconnectiontv": [["NLD", 1119]], "akta": [["ROU", 1501]], "stv1hd": [["SVK", 1782]], "muenchen.tv": [["DEU", 922]], "telma": [["MKD", 1082]], "directstar": [["FRA", 684]], "dusk!deluxe": [["NLD", 1263]], "sitel3": [["MKD", 1097]], "kindernet/comedycentral": [["NLD", 1221]], "bbc2ni": [["GBR", 2384]], "\u0431\u0456\u0437\u043d\u0435\u0441": [["UKR", 2527]], "telezuerihd": [["CHE", 2359]], "fenixkino": [["RUS", 1629]], "passietv": [["NLD", 1223]], "sat1": [["SVN", 1925]], "13thstreet(tc)": [["CHE", 2352]], "journaal24/best24": [["NLD", 1166]], "playboy": [["INT", 2724]], "canal4leon": [["ESP", 2081]], "dk4_hd_75x40": [["DNK", 465]], "digisport3": [["ROU", 1580]], "digisport2": [["ROU", 1579]], "nick/ccaut": [["AUT", 66]], "premiumextra": [["ITA", 1015]], "wewellchannel": [["CHE", 2241]], "htv2": [["HRV", 308]], "htv3": [["HRV", 327]], "versatel": [["NLD", 1198]], "htv1": [["HRV", 307]], "servustvhd": [["CHE", 2274], ["INT", 2774]], "canal29valladolid": [["ESP", 2090]], "htv4": [["HRV", 328]], "rtvc": [["ESP", 2141]], "upczenderoverzicht": [["NLD", 1252]], "chartshow": [["GBR", 2410]], "rtsdeuxhd": [["CHE", 2243]], "telecinco": [["ESP", 2155]], "autoplus": [["RUS", 1613]], "tvrmeducational": [["ROU", 1568]], "omropfryslan": [["NLD", 1274]], "cnbc-e": [["TUR", 2567]], "clermont1ere": [["FRA", 545]], "televize24": [["CZE", 359]], "s4c": [["GBR", 2460]], "tishk": [["FRA", 646]], "k-15music": [["MKD", 1090]], "rtvi": [["RUS", 1727]], "bebegim": [["TUR", 2561]], "sporttvhd": [["SVN", 2028]], "extremadura": [["ESP", 2117]], "bntsat": [["BGR", 229]], "\u0442\u043e\u043d\u0456\u0441": [["UKR", 2545]], "discovery_investigation_id": [["DNK", 461]], "rnn7": [["NLD", 1176]], "rbtv": [["DEU", 749]], "zdfinfo": [["DEU", 892]], "tvnoord": [["NLD", 1183]], "rtkosovo": [["SVN", 1919]], "dieneuezeittv": [["CHE", 2218]], "rtlde": [["DEU", 844], ["CHE", 2287]], "tvsud": [["FRA", 711], ["FRA", 711]], "net5": [["NLD", 1154]], "silver": [["LVA", 1051]], "1-2-3.tv": [["DEU", 927]], "akillitv": [["TUR", 2556], ["TUR", 2647]], "besport3": [["BEL", 123]], "besport2": [["BEL", 122]], "hiphoptv": [["BGR", 249]], "debut": [["RUS", 1623]], "setantasports1": [["IRL", 979]], "evenementenkanaal": [["NLD", 1252]], "tv6_at": [["AUT", 27]], "im1": [["DEU", 805]], "atvhd": [["AUT", 32], ["TUR", 2628]], "hbobox": [["SVN", 1877]], "7ltv": [["FRA", 489]], "luch": [["RUS", 1678]], "canal49delaspalmas": [["ESP", 2094]], "aljazeeraeng.": [["INT", 2800]], "glitzhd": [["INT", 2767]], "btvcinema": [["BGR", 231], ["BGR", 284], ["BGR", 293]], "vh-1": [["NLD", 1199]], "kanalsporthd_01": [["DNK", 468]], "otohd": [["SVN", 2048]], "cnbceurope": [["INT", 2738]], "bluemovie": [["AUT", 72], ["DEU", 855]], "24\u0442\u0435\u043b\u0435\u043a\u0430\u043d\u0430\u043b\u043d\u043e\u0432\u0438\u043d": [["UKR", 2502]], "mdr": [["DEU", 747]], "foxtv": [["TUR", 2577]], "lcpan": [["FRA", 582]], "bayerischesfsnord": [["DEU", 762]], "erf1": [["AUT", 110]], "mrezazg": [["HRV", 330]], "open": [["GBR", 2454]], "tv24hd": [["CHE", 2361], ["CHE", 2361], ["CHE", 2361]], "veo7": [["ESP", 2183]], "polsatcrime": [["POL", 1444]], "at5": [["NLD", 1104]], "france2hd": [["FRA", 685], ["CHE", 2257]], "rb": [["DEU", 749], ["DEU", 837]], "dsf": [["DEU", 776], ["SVN", 1852]], "orf1hd": [["AUT", 16], ["CHE", 2280]], "folxtv": [["AUT", 50]], "rbbbrandenburg": [["AUT", 79], ["DEU", 750]], "sat1comedy": [["DEU", 853]], "n24hdaustria": [["INT", 2768]], "shaber": [["TUR", 2599], ["TUR", 2633]], "nollywoodmovies": [["GBR", 2448]], "ntv": [["RUS", 1707], ["RUS", 1756], ["SVN", 2001], ["TUR", 2594]], "canalsat_guide": [["FRA", 532]], "freeboxtv": [["FRA", 561]], "wdrfernsehenhd": [["CHE", 2283]], "canal4burgos": [["ESP", 2078]], "zapp": [["NLD", 1203]], "ontv": [["DEU", 830]], "bloombergeuropetv": [["DEU", 756]], "foxcrime": [["SVN", 1869], ["INT", 2696]], "motorvisiontv": [["DEU", 820]], "polsathd": [["POL", 1353]], "startv": [["CHE", 2229], ["TUR", 2614]], "ftvhd": [["SVN", 2049]], "atv": [["AUT", 3], ["TUR", 2557]], "omroepbrabanttv": [["NLD", 1173]], "canalbaeza": [["ESP", 2100]], "viasattv3": [["DNK", 451], ["EST", 482], ["SVN", 1810]], "extremaduratv": [["ESP", 2117]], "qvcplus": [["DEU", 918]], "viasattv6": [["EST", 484]], "123tv": [["DEU", 737]], "ndrfernsehen": [["DEU", 826]], "pinkkids": [["SVN", 2005]], "channelm": [["GBR", 2409]], "sport1voetbal": [["NLD", 1270]], "tv5mondeafrique": [["FRA", 654]], "galatasaraytv": [["TUR", 2579]], "novacinema": [["CZE", 382]], "scifiuniversal": [["POL", 1432]], "gameland": [["RUS", 1631]], "40tv": [["ESP", 2063]], "portocanal": [["PRT", 1476]], "smartcocuk": [["TUR", 2608]], "gtrkvyatka": [["RUS", 1650]], "cultura24": [["NLD", 1161]], "top": [["CHE", 2230]], "cine5": [["TUR", 2566]], "afnex": [["FRA", 497]], "tvphistoria": [["POL", 1375]], "canalextremadura": [["ESP", 2103]], "canalsurandalucia": [["ESP", 2108]], "sportklub1hd": [["SVN", 2037], ["SVN", 2037]], "terredinfos": [["FRA", 640]], "sponkatv": [["SVN", 1821], ["SVN", 1928]], "leotv": [["CZE", 379]], "sky1hd": [["GBR", 2463]], "mtvhits": [["INT", 2707]], "tv7bg": [["BGR", 277]], "perviy_kanal_md": [["RUS", 1718]], "bbcknowledge": [["POL", 1450]], "trk7": [["RUS", 1738]], "\u0431\u0442\u0431\u0442\u0431": [["UKR", 2526]], "durangotb": [["ESP", 2113]], "channel5": [["CHE", 2303]], "jimtv": [["BEL", 160]], "kinoreys3": [["RUS", 1670]], "teleplaisance": [["FRA", 637]], "kinoreys1": [["RUS", 1670]], "\u043a\u0443\u043b\u044c\u0442\u0443\u0440\u0430": [["UKR", 2512]], "agrotv": [["RUS", 1610]], "wdrhdm\u00fcnster": [["DEU", 914]], "golfklub": [["SVN", 2026]], "ktv": [["AUT", 11]], "disc.science": [["GBR", 2414]], "idealniymir": [["RUS", 1651]], "estrellas": [["CHE", 2325]], "kto": [["FRA", 577]], "folketinget": [["DNK", 443]], "pinkfilm": [["SVN", 1909]], "canal+sport": [["FRA", 518]], "romancetv": [["POL", 1356], ["CHE", 2347]], "sorozatplusz": [["HUN", 968]], "bestofshopping": [["FRA", 503]], "tvn7hd": [["POL", 1373]], "daserste": [["DEU", 739]], "nba": [["LVA", 1044]], "rtlii(d)": [["NLD", 1297]], "tpsfoot": [["FRA", 648]], "ictv": [["UKR", 2531]], "d-tvoss": [["NLD", 1300]], "alsatictv": [["FRA", 498]], "nickelodeonjr": [["INT", 2720]], "oglindatv": [["ROU", 1544]], "superrtlch": [["CHE", 2267]], "discovery(tc)": [["CHE", 2346]], "tv1bosna": [["SVN", 2018]], "kabeleins": [["DEU", 812], ["SVN", 1889]], "mediaset": [["SVN", 1995]], "aone": [["RUS", 1608]], "factoryoutlet": [["GBR", 2418]], "tgnthaiglobal": [["CHE", 2342]], "krimi": [["CHE", 2345]], "\u043a\u0438\u0457\u0432": [["UKR", 2519]], "hse24": [["DEU", 801]], "boomsportthree": [["ROU", 1516]], "skyfussballbundesliga": [["DEU", 863]], "alfatelevizija": [["BIH", 207]], "aktahd": [["ROU", 1501]], "24satatv": [["HRV", 317]], "vh1classic": [["ROU", 1600], ["INT", 2756]], "zdf_neo": [["DEU", 893]], "tvnturbo": [["POL", 1372]], "visatnaturehd": [["SVN", 1988]], "nvksakha": [["RUS", 1709]], "orfiii": [["AUT", 30]], "itv3plus1": [["GBR", 2432]], "romantica": [["ROU", 1553]], "tf1hd": [["FRA", 642], ["CHE", 2258]], "lasexta": [["ESP", 2127]], "ativi": [["NLD", 1103]], "doq": [["HUN", 942]], "l\u00e9manbleut\u00e9l\u00e9vision": [["CHE", 2221]], "canalplusfamily": [["FRA", 516]], "tv5r\u00eega": [["LVA", 1060]], "hbohd": [["NLD", 1217], ["POL", 1387], ["SVN", 1982], ["INT", 2748]], "nicktoonsters": [["GBR", 2446]], "mooztv": [["ROU", 1590]], "bbc2northernireland": [["GBR", 2384]], "probg": [["BGR", 265]], "channel21shop": [["DEU", 766], ["CHE", 2217]], "puntotv": [["ESP", 2137]], "neptuntv": [["ROU", 1542]], "3tvoltenia": [["ROU", 1498]], "liberty": [["FRA", 583]], "d8": [["FRA", 712]], "skycomedy": [["DEU", 861]], "bbclifestyle": [["POL", 1446]], "tv5mondefbs": [["FRA", 653]], "rtltvihd": [["BEL", 186]], "divinity": [["ESP", 2198]], "2behd": [["BEL", 204]], "dateline": [["DEU", 768]], "rtlcrimehd": [["CHE", 2372]], "polsat2": [["POL", 1437]], "dancetrippin": [["GBR", 2485]], "erotiekpakket": [["NLD", 1238]], "hrfernsehen": [["DEU", 800]], "prosiebenaustria": [["AUT", 21], ["AUT", 73]], "movies24": [["HUN", 959]], "thomsontv": [["GBR", 2483]], "tvmetropol": [["CZE", 418]], "mrezaplus": [["BIH", 214]], "sport24": [["NLD", 1169]], "npo101": [["NLD", 1314]], "utvhd": [["ROU", 1599]], "dw": [["DEU", 741], ["ROU", 1586]], "cooltv": [["CZE", 360], ["HUN", 939]], "oiktv": [["CZE", 387]], "interchannel": [["ITA", 996]], "bbctwohd(28)": [["NLD", 1291]], "cinemax": [["INT", 2672]], "tvdemorrazo": [["ESP", 2167]], "trt-6": [["TUR", 2618]], "disco": [["NLD", 1121], ["INT", 2734]], "comedyc./kindernethd": [["NLD", 1221]], "sky1": [["GBR", 2462]], "sky3": [["GBR", 2465]], "tvgustopremium": [["DEU", 887]], "fbtv": [["TUR", 2575]], "classtv": [["ITA", 992]], "msat": [["BGR", 257]], "nostalgienet(06-18uma-vr)": [["NLD", 1172]], "nat.geo.wild": [["NLD", 1149]], "chtvhd": [["CHE", 2366]], "foxmovieshd": [["SVN", 1979]], "viasattv3plushd": [["DNK", 453]], "tvbrussel": [["BEL", 201]], "w9": [["FRA", 675]], "voyage": [["FRA", 674]], "wdrhddortmund": [["DEU", 914]], "comedycentral/kindernet(23)": [["NLD", 1117]], "tv6latvija": [["LVA", 1057]], "balkanika": [["BIH", 223]], "blulinetv": [["RUS", 1618]], "l-tv/tvm": [["AUT", 57]], "tv20_terrassa": [["ESP", 2162]], "wdrhdbonn": [["DEU", 914]], "zooparktv": [["RUS", 1750]], "xitemusic": [["NLD", 1201]], "4hd": [["GBR", 2490]], "showturk": [["CHE", 2315], ["TUR", 2634]], "wtv": [["BEL", 170]], "trt6": [["TUR", 2618]], "rtlii": [["SVN", 2056], ["CHE", 2363], ["CHE", 2363]], "espnamerica(engl)": [["INT", 2685]], "trt3": [["TUR", 2641]], "foxchannel": [["INT", 2695]], "tvpinfobydgoszcz": [["POL", 1410]], "kp": [["SVN", 2052]], "televize4": [["CZE", 357]], "tgrteu": [["TUR", 2616]], "televize1": [["CZE", 353]], "beinsport2hd": [["FRA", 725]], "televize2": [["CZE", 355]], "hdplanettv": [["SVN", 2042]], "beyaztv": [["TUR", 2562]], "cctvnews": [["ROU", 1576]], "axnhd": [["AUT", 40], ["POL", 1460]], "cinemar": [["ROU", 1518]], "deutschesmusikfernsehen": [["AUT", 48]], "\u043c\u0435\u0433\u0430": [["UKR", 2537]], "polonia1": [["POL", 1352]], "tvwest": [["NLD", 1188]], "frtv": [["DEU", 788]], "ngc(19mp4)": [["NLD", 1295]], "1musicchannel": [["HUN", 937], ["ROU", 1497]], "nick/comedycentral": [["CHE", 2288]], "egetv": [["TUR", 2644]], "itv1hd(28)": [["NLD", 1293]], "kanala": [["SVN", 1818], ["TUR", 2582]], "6ter": [["FRA", 714]], "xite": [["NLD", 1280]], "kanald": [["ROU", 1539], ["SRB", 1769], ["TUR", 2584]], "credotv": [["ROU", 1522]], "ondaseismadrid": [["ESP", 2134]], "offrebis.tv": [["FRA", 726], ["FRA", 726]], "canal8lemans": [["FRA", 510]], "bnt": [["BGR", 228]], "kanalturkntv": [["TUR", 2586]], "mobilatv": [["CZE", 380]], "boomaction": [["ROU", 1509]], "eurosport": [["DNK", 439], ["NLD", 1127], ["INT", 2689]], "rtl2hd": [["DEU", 897]], "foxnext": [["INT", 2697]], "hdhbo": [["SVN", 1880], ["SVN", 1982]], "acasahd": [["ROU", 1499]], "historytm": [["NLD", 1220]], "rtvdrenthe": [["NLD", 1181]], "notele": [["BEL", 173]], "3eie": [["IRL", 977]], "gtrkghita": [["RUS", 1635]], "tv5mondefrbesu": [["FRA", 658]], "tvnoe": [["CZE", 400]], "mcm": [["BEL", 130], ["FRA", 594]], "voofoot": [["BEL", 192]], "voxde": [["INT", 2655]], "onyx": [["DEU", 831]], "fem3": [["HUN", 947]], "kanal3": [["BGR", 252], ["TUR", 2649]], "bravanl": [["NLD", 1107]], "kanal5": [["HRV", 310], ["DNK", 445], ["MKD", 1092], ["TUR", 2650]], "kanal4": [["DNK", 444]], "tvjoj": [["CZE", 408], ["SVK", 1788]], "televizijaslavonijeibaranje": [["HRV", 339]], "gtrktyumen": [["RUS", 1643]], "kanal8": [["BGR", 253]], "sanjuantv": [["ESP", 2143]], "xxl": [["FRA", 677], ["SVN", 1904]], "film1family": [["NLD", 1213]], "nsporthd": [["POL", 1348]], "fr3": [["FRA", 689]], "ardrbb": [["DEU", 750]], "planethd": [["CHE", 2294]], "fr5": [["FRA", 692]], "fr4": [["FRA", 691]], "zueriplus": [["CHE", 2253]], "extremesports": [["NLD", 1132], ["TUR", 2574], ["INT", 2744]], "playhousedisney": [["INT", 2725]], "tv5mondeeurope": [["FRA", 657]], "telebielingue": [["CHE", 2260]], "a24": [["FRA", 490]], "kcnmusic": [["SVN", 1991]], "interaz": [["RUS", 1653]], "supertv": [["SRB", 1780]], "mtvidol": [["FRA", 600], ["INT", 2708]], "canv": [["BEL", 169]], "rai1": [["ITA", 1027], ["SVN", 1915]], "rai2": [["ITA", 1020], ["SVN", 1916]], "rai3": [["ITA", 1026], ["SVN", 1917]], "rai4": [["ITA", 1018]], "rai5": [["ITA", 1019]], "sporttv1hd": [["SVN", 2027], ["SVN", 2027]], "sport10hd": [["BEL", 181]], "id": [["NLD", 1255]], "mediashop": [["AUT", 61], ["CHE", 2222]], "adultchannel": [["CHE", 2265]], "toondisney": [["INT", 2731]], "wdr": [["DEU", 751], ["CHE", 2380]], "rtvturnhout": [["BEL", 195]], "quali+": [["FRA", 626]], "noortv": [["GBR", 2449]], "ard-daserste": [["NLD", 1261]], "kinonova": [["BGR", 296]], "latinaf": [["BGR", 256]], "omroepgelderland": [["NLD", 1182]], "hdgolfklub": [["SVN", 2026], ["SVN", 2026]], "stv2hd": [["SVK", 1783]], "telez\u00fcrihd": [["CHE", 2359]], "itv1-hd": [["GBR", 2495]], "\u0433\u0430\u043c\u043c\u0430\u043a\u0430\u043d\u0430\u043b": [["UKR", 2508]], "polsatfilm": [["POL", 1393]], "bloomberg": [["FRA", 506], ["DEU", 756]], "sport1selecthd": [["NLD", 1278]], "sixxhd": [["INT", 2790]], "\u0442\u0432i": [["UKR", 2520]], "tv5mondeetats-unis": [["FRA", 656]], "n24": [["DEU", 825], ["ROU", 1541]], "filmboxhd": [["CZE", 372], ["POL", 1339]], "nationalgeographicwild": [["INT", 2718]], "clubrtlhd": [["BEL", 187]], "cmtcastillalamancha": [["ESP", 2111]], "br_s\u00fcd_hd": [["DEU", 911]], "sport1hdselect": [["NLD", 1278]], "tntseriehd": [["INT", 2784]], "sportklubhd": [["SVN", 2041], ["SVN", 2041]], "prosiebenmaxx": [["AUT", 75]], "skycinema+1": [["DEU", 859]], "myzen.tvhd": [["NLD", 1269]], "disneychannel": [["DNK", 431], ["DEU", 772], ["POL", 1333], ["INT", 2680], ["INT", 2742]], "nationalgeographicchannelhd": [["NLD", 1148]], "protvinternational": [["ROU", 1551]], "tele5hd": [["INT", 2782]], "hse24extra": [["AUT", 53], ["DEU", 802]], "hdftv": [["SVN", 2049]], "man-x": [["NLD", 1144]], "moozhits": [["ROU", 1590]], "mediaspartv": [["DEU", 916]], "hdkanala": [["SVN", 2046]], "avsoudenaar.": [["BEL", 193]], "mtvaustria": [["AUT", 63]], "barcatv": [["ESP", 2070]], "antena3noticias": [["ESP", 2066]], "ntvplussport": [["RUS", 1702]], "vinkovacka_tv": [["HRV", 343]], "24_vesti": [["MKD", 1077]], "hr-fernsehen": [["DEU", 800]], "sportdigitaltv": [["DEU", 874]], "foot+": [["FRA", 531]], "raigulp": [["ITA", 1022]], "sporttv2hd": [["SVN", 2031], ["SVN", 2031]], "horse&countrytv": [["NLD", 1292]], "lcp": [["FRA", 582]], "rtliihd": [["DEU", 897]], "sbs6hd": [["NLD", 1236], ["NLD", 1236]], "rnf": [["DEU", 843]], "cnninternational": [["INT", 2791]], "eltatv": [["SVN", 1964]], "orangecinechoc": [["FRA", 615]], "canal4valladolid": [["ESP", 2084]], "absat_passions": [["FRA", 495]], "rtl5hd": [["NLD", 1275], ["NLD", 1275]], "bebetvhd": [["CZE", 350]], "lcm": [["FRA", 578]], "bbc2hd": [["NLD", 1291], ["GBR", 2497]], "lci": [["FRA", 706]], "skycinema+24": [["DEU", 860]], "tvveseljak": [["SVN", 1945]], "hdsporttv": [["SVN", 2028]], "melodyzen": [["SVN", 1897], ["SVN", 1996]], "alice": [["AUT", 36]], "tvrioja": [["ESP", 2172]], "vitaltv": [["HUN", 975]], "rbbberlin": [["AUT", 79], ["DEU", 750]], "nickjunior": [["INT", 2720]], "canalsat_cine_plus": [["FRA", 527]], "dokucs": [["CZE", 364]], "hdhbocomedy": [["SVN", 1981]], "plan\u00e8te+": [["FRA", 707]], "skyhitshd": [["DEU", 858]], "aktivdirekttv": [["AUT", 2]], "orf2n": [["DEU", 917]], "orf2o": [["DEU", 917]], "sixx": [["CHE", 2272], ["CHE", 2273]], "canalpluspolynesie": [["FRA", 523]], "orf2e": [["DEU", 917]], "tv1000action": [["LTU", 1073]], "ushua\u00efa": [["FRA", 669]], "orf2b": [["DEU", 917]], "beatone": [["AUT", 5]], "discoverymax": [["ESP", 2199]], "orf2t": [["DEU", 917]], "film4plus1": [["GBR", 2420]], "orf2v": [["DEU", 917]], "orf2w": [["DEU", 917]], "rtlfs": [["AUT", 83]], "ushuaiatv": [["FRA", 669]], "24h": [["ESP", 2178]], "toondisney+1": [["INT", 2732]], "nick/comedy": [["DEU", 906]], "canal40": [["FRA", 511]], "nponieuws": [["NLD", 1318]], "goldberry": [["UKR", 2530]], "fox": [["CHE", 2351], ["TUR", 2577], ["INT", 2695]], "canal49": [["ESP", 2095]], "planettvhd": [["SVN", 2042]], "tvbratislava": [["SVK", 1798]], "eenhd": [["BEL", 163], ["NLD", 1277]], "cnn": [["DNK", 428], ["NLD", 1115], ["INT", 2791]], "ozonenetwork": [["HUN", 963]], "ring-tv": [["BEL", 196]], "tvromaniamaine": [["ROU", 1569]], "bbcworldnews": [["GBR", 2399]], "tvri": [["CHE", 2333]], "comedycentral/kindernet": [["NLD", 1221]], "nederland2hd": [["NLD", 1206]], "\u043a\u0430\u0434\u0432\u0430": [["UKR", 2534]], "jojplus": [["CZE", 409], ["SVK", 1789]], "mtvclassic": [["INT", 2705]], "vitaya": [["BEL", 162]], "tvlospalacios": [["ESP", 2170]], "einsfestival": [["DEU", 743]], "orangecinegeants": [["FRA", 616]], "super": [["CHE", 2267]], "rdsinfosports": [["FRA", 627]], "russianworld": [["RUS", 1734]], "sat.1gold": [["DEU", 932]], "voxhdaustria": [["INT", 2761]], "polskieradio": [["POL", 1465]], "obe": [["GBR", 2452]], "3+": [["CHE", 2215]], "disney+1": [["INT", 2679]], "premiumdigital": [["BGR", 264]], "cannes_tv": [["FRA", 538]], "primesport2": [["BEL", 140]], "538": [["NLD", 1233]], "mtvtrax": [["INT", 2713]], "espnamericahd": [["NLD", 1126]], "gtrkorenburg": [["RUS", 1641]], "primeseries": [["BEL", 139]], "mdrt\u00fchringen": [["AUT", 59]], "sport1plushd": [["INT", 2779]], "\u043c\u0435\u043d\u044e\u0442\u0432": [["UKR", 2516]], "primefamily": [["BEL", 136]], "chtv": [["CHE", 2366]], "thebox": [["NLD", 1195]], "pinkworld": [["SVN", 2008]], "orf2k": [["DEU", 917]], "rtcg": [["MNE", 1100], ["SVN", 1918]], "film1comedy&kidshd": [["NLD", 1310]], "toptelevize": [["CZE", 398]], "machainesport": [["FRA", 591]], "d:sf": [["DEU", 776]], "golfchannel": [["CZE", 406]], "openaccess2": [["GBR", 2456]], "ntvplustennis": [["RUS", 1706]], "\u00f8\u00f8nhd": [["NLD", 1277]], "samanyolutv": [["TUR", 2598]], "tpsstar": [["FRA", 649]], "canal+antilles": [["FRA", 519]], "rtpinternacional": [["PRT", 1483]], "natgeofr": [["INT", 2716]], "tvpika": [["SVN", 1825]], "cartoonnetwork(s)": [["AUT", 44]], "rtltv": [["HRV", 315]], "disneyjunior_01": [["DNK", 464]], "zoom": [["UKR", 2549]], "cfi_tv": [["FRA", 542]], "fightchannel": [["SVN", 1965]], "sonnenklartv": [["DEU", 872]], "becinehd": [["BEL", 190]], "hbodigital": [["CZE", 374]], "z@ppelin/z@pp24": [["NLD", 1203]], "npocultura": [["NLD", 1315]], "hdkino": [["SVN", 2047]], "bbc3/cbbc": [["NLD", 1244], ["GBR", 2398], ["GBR", 2498]], "mtv": [["DNK", 446], ["INT", 2703]], "mtt": [["SVK", 1809]], "meintvshop": [["DEU", 931]], "dorcelxxxhd(xotix)": [["NLD", 1309]], "telessonne": [["FRA", 638]], "hdsportklub": [["SVN", 2041], ["SVN", 2041]], "boomerang": [["SVN", 1836], ["INT", 2735]], "cinestaractionandtriller": [["SVN", 1839]], "telez\u00fcri": [["CHE", 2238]], "nederland3hd": [["NLD", 1207]], "alfaomegatv": [["ROU", 1502]], "hdnickelodeon": [["SVN", 1987]], "ndrfsmv": [["DEU", 826]], "orfhd": [["AUT", 19], ["DEU", 923]], "tv538": [["NLD", 1233]], "history": [["POL", 1389]], "ngwilddut": [["NLD", 1149]], "sperantatv": [["ROU", 1556]], "discoveryhdshowcase": [["INT", 2676]], "khl": [["LVA", 1039], ["RUS", 1664]], "nsat": [["GBR", 2451]], "canalsur": [["ESP", 2108]], "zdfkulturhd": [["DEU", 895]], "cordobainttv": [["ESP", 2209]], "onda6": [["ESP", 2134]], "ktvaustria": [["AUT", 11]], "redbulltv": [["AUT", 23]], "cctv-kitajska": [["SVN", 1838]], "tiroltv": [["AUT", 25]], "rtrplaneta": [["LVA", 1050], ["RUS", 1726], ["SVN", 1922]], "tvpetelin": [["SVN", 1824]], "communitychannel": [["GBR", 2411]], "televize2hd": [["CZE", 356]], "orf2s": [["DEU", 917]], "eroxtv": [["CZE", 365], ["HUN", 946]], "bbconehd(28)": [["NLD", 1267]], "worldfashionchannel": [["RUS", 1745], ["CHE", 2213]], "phoenix": [["DEU", 835], ["SVN", 1908]], "radiobrementv": [["DEU", 837]], "debuttv": [["RUS", 1623]], "sporttv1": [["SVN", 2030], ["SVN", 2030]], "s1hd": [["CHE", 2362], ["CHE", 2362]], "sat.1ch": [["DEU", 903]], "mtvrocks": [["INT", 2711]], "tele_d": [["CHE", 2368]], "klasiktv": [["SVN", 1993]], "\u043a\u0430\u043e\u0434\u0438\u043d": [["UKR", 2533]], "lunaparkinteractive": [["NLD", 1142]], "startvhd": [["CHE", 2360], ["CHE", 2360]], "uefa": [["GBR", 2487]], "rtlhbnds": [["AUT", 82]], "bibeltv": [["DEU", 754]], "virgin1": [["GBR", 2489]], "rforegionaloberbayern": [["DEU", 925]], "oltv": [["FRA", 613]], "tiankovtv": [["BGR", 275]], "natgeohd": [["NLD", 1245], ["SVN", 1986], ["INT", 2717]], "x-passion": [["BEL", 158]], "canal55marinabaixa": [["ESP", 2099]], "axnaction": [["AUT", 111]], "euronews": [["INT", 2688]], "rob": [["BEL", 194]], "focus": [["BEL", 170]], "zendervandemaand": [["NLD", 1251]], "\u043c\u0435\u0433\u0433\u0430": [["UKR", 2537]], "themex": [["GBR", 2481]], "zdfinfokanal": [["CHE", 2277]], "telemadridhd": [["ESP", 2158]], "mdrth\u00fcringen": [["DEU", 912]], "pinkbh": [["BIH", 221]], "tnt": [["TUR", 2617]], "skyselecthd": [["DEU", 935]], "eurosportfr": [["INT", 2795]], "deluxemusichd": [["DEU", 908]], "sportklub4": [["SVN", 2023], ["SVN", 2023]], "sportklub5": [["SVN", 2024], ["SVN", 2024]], "skyactionhd": [["AUT", 93]], "eeurope": [["SVN", 1854], ["SVN", 1854]], "sportklub1": [["SVN", 2035], ["SVN", 2035]], "sportklub2": [["SVN", 2036], ["SVN", 2036]], "sportklub3": [["SVN", 2040], ["SVN", 2040]], "yumurcaktv": [["TUR", 2587]], "primafamily": [["CZE", 414]], "discovery": [["INT", 2734], ["INT", 2792]], "spiegelg": [["DEU", 873]], "\u00f8\u00f8n": [["BEL", 164], ["NLD", 1277]], "ewtn": [["SVN", 1861]], "1\u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0456\u043b\u044c\u043d\u0438\u0439": [["UKR", 2499]], "mach6": [["NLD", 1143]], "populartv": [["ESP", 2135]], "kitaytelekanal": [["RUS", 1671]], "telesport": [["ROU", 1561]], "fishingandhunting": [["SVN", 1866], ["SVN", 1941]], "kabelkioskinfokanal": [["DEU", 814]], "protvhd": [["ROU", 1592]], "france24(inenglish)": [["FRA", 560]], "bebetv": [["CZE", 349]], "superrtl": [["DEU", 875], ["SVN", 1929], ["CHE", 2267]], "nrk2": [["NOR", 1324]], "nicke": [["NLD", 1158]], "sportklub3hd": [["SVN", 2039], ["SVN", 2039]], "rentv": [["RUS", 1755]], "pmu": [["FRA", 625]], "tvsa": [["BIH", 205]], "onetv": [["ROU", 1545]], "brava": [["NLD", 1107]], "planetatv": [["BGR", 262]], "canalsat_reunion": [["FRA", 536]], "tvsh": [["CHE", 2331]], "lt1-ooe": [["AUT", 58]], "teleclubsport3": [["CHE", 2235]], "tectimetv": [["AUT", 104]], "skysportshd3": [["GBR", 2475]], "skysportshd1": [["GBR", 2473]], "mcmpop": [["FRA", 595], ["SVN", 1895]], "skysportshd4": [["GBR", 2476]], "kraltv": [["TUR", 2589]], "novasport": [["CZE", 383]], "boomsporttwo": [["ROU", 1517]], "bulvartv": [["RUS", 1622]], "br-alpha": [["DEU", 910]], "tve1": [["ESP", 2176]], "mtvch": [["INT", 2703]], "kanalr-logo": [["HRV", 333]], "dreamtv": [["TUR", 2643]], "vacantatv": [["ROU", 1573]], "cap24": [["FRA", 539]], "trtbelgesel": [["TUR", 2638]], "oxotairibalka": [["LVA", 1047]], "penthousehd": [["INT", 2798]], "e8television": [["AUT", 49]], "klik": [["SVN", 1892], ["SVN", 1994]], "qmusic": [["BEL", 178]], "musicboxru": [["RUS", 1686]], "raiuno": [["ITA", 1027]], "cinefx": [["FRA", 729]], "oceantv": [["RUS", 1669]], "cinemax2": [["INT", 2671]], "skycinemaplus24": [["DEU", 860]], "equipetv": [["FRA", 553]], "polsatfilmhd": [["POL", 1458]], "paramountchannel": [["ESP", 2201]], "fashiontvhd": [["NLD", 1268]], "canal32": [["FRA", 696]], "hbo": [["INT", 2700]], "q-music": [["BEL", 178]], "be1plus1h": [["BEL", 120]], "bosnatv1": [["SVN", 2018]], "voofoot4": [["BEL", 192]], "voofoot5": [["BEL", 192]], "iddiscovery": [["INT", 2739]], "miziktropical": [["FRA", 598]], "voofoot2": [["BEL", 192]], "voofoot3": [["BEL", 192]], "\u0435\u043c\u043e\u0434\u0438\u043d": [["UKR", 2536]], "vtmkzoom+": [["BEL", 157]], "hbo3hd": [["NLD", 1219]], "super7tv": [["BGR", 298]], "prva": [["SRB", 1759]], "telem1": [["CHE", 2261]], "kanalahd": [["SVN", 2046]], "samanyolu.tv": [["TUR", 2598]], "love": [["POL", 1451], ["POL", 1455]], "axnspinhd": [["POL", 1461]], "showtv": [["TUR", 2602]], "aquitv": [["FRA", 500]], "cbseuropa": [["POL", 1445]], "npobest": [["NLD", 1322]], "nrj12": [["FRA", 607]], "scdiscovery": [["INT", 2740]], "girondins": [["FRA", 564]], "mesajtv": [["TUR", 2591]], "sky": [["GBR", 2467]], "juwelohd": [["DEU", 809]], "tvsonce": [["MKD", 1099]], "createandcraft": [["GBR", 2412]], "disneychannel+1": [["INT", 2679]], "hdeurosport": [["SVN", 1860], ["SVN", 1977]], "discoverychannel": [["POL", 1332], ["INT", 2734]], "\u0435\u043d\u0442\u0435\u0440film": [["UKR", 2529]], "zdf.kultur": [["CHE", 2276]], "natgeoi": [["CHE", 2309]], "bbconenorthernireland": [["GBR", 2394]], "primestar": [["BEL", 142]], "ib3": [["ESP", 2124]], "skysportshd2": [["GBR", 2474]], "laune": [["BEL", 147]], "obn": [["BIH", 217], ["SVN", 1907]], "investigationdiscovery": [["NLD", 1254]], "tnthd": [["INT", 2793]], "animaux": [["FRA", 499], ["SVN", 1831], ["SVN", 1955]], "rtliiaustria": [["AUT", 86]], "clubrtl": [["BEL", 128]], "rtrs": [["BIH", 218]], "euarmeniatv": [["FRA", 555]], "ardeinsplus": [["DEU", 745]], "channel4+1": [["GBR", 2408]], "raiyoyo": [["ITA", 1028]], "kanal4ru": [["RUS", 1657]], "bbcthree(28)": [["NLD", 1289]], "wdrhdessen": [["DEU", 914]], "film+": [["CZE", 405], ["SRB", 1767]], "schautv": [["AUT", 90]], "oriontv": [["DEU", 832]], "c47": [["ESP", 2073]], "arddaserstehd": [["DEU", 740], ["CHE", 2270]], "sport5": [["CZE", 396]], "intereconomia": [["ESP", 2193]], "sport1": [["HRV", 325], ["CZE", 395], ["DEU", 898], ["HUN", 970], ["ROU", 1596]], "sport2": [["HUN", 971]], "comedycentralfamily": [["NLD", 1116]], "tvpseriale": [["POL", 1378]], "guysentv": [["FRA", 566]], "sport+": [["FRA", 633]], "24familie": [["NLD", 1162]], "film4": [["GBR", 2419]], "musiqlub": [["NLD", 1147]], "film1action": [["NLD", 1212]], "artehd": [["FRA", 679], ["INT", 2662]], "\u043f\u0435\u0440\u0448\u0438\u0439": [["UKR", 2541]], "foxsports1hderedivisie": [["NLD", 1281]], "boschtiontv": [["NLD", 1303]], "muzsikatv": [["HUN", 962]], "mdrs-anhalt": [["AUT", 33]], "fashiontv": [["POL", 1473], ["SVK", 1796], ["SVN", 1864], ["INT", 2694]], "k-plus": [["RUS", 1656]], "tvnorge": [["NOR", 1328]], "pink": [["INT", 2723]], "mmcr": [["SVN", 2053]], "cinquestellenetwork": [["ITA", 991]], "vitay": [["BEL", 162]], "avrasya": [["TUR", 2558]], "tvberlin": [["DEU", 885]], "kplus": [["RUS", 1656]], "sundance": [["POL", 1435]], "la2": [["ESP", 2177]], "canal4navarra": [["ESP", 2082]], "disoverychannel": [["DNK", 429]], "bbctwo": [["GBR", 2383]], "stv1": [["SVK", 1782]], "mango24": [["POL", 1474]], "explorer": [["CZE", 420], ["SVN", 1862]], "c&i": [["NLD", 1256]], "teleb\u00e4rn": [["CHE", 2231]], "bnmusic": [["BIH", 209]], "numberonetv": [["TUR", 2632]], "eredivisielive1": [["NLD", 1211]], "mktvsat": [["MKD", 1094]], "tvpkultura": [["POL", 1376]], "sporza": [["BEL", 154]], "sportskatelevizija": [["HRV", 326]], "mittelrhein": [["DEU", 888]], "\u043a\u0443\u0439\u0442\u0431": [["UKR", 2518]], "schweiz5": [["CHE", 2251], ["CHE", 2251]], "evrokom": [["BGR", 240]], "dicoverywold": [["DNK", 430]], "tv8mont-blanc": [["FRA", 703]], "centertv": [["DEU", 764]], "favorit": [["ROU", 1530], ["ROU", 1587]], "boomindian": [["ROU", 1512]], "kinohd": [["SVN", 2047]], "mango": [["POL", 1342]], "markizahd": [["SVK", 1786]], "nantes7": [["FRA", 604], ["FRA", 604]], "travel": [["POL", 1452], ["SVN", 1932]], "ziggoxite": [["NLD", 1253]], "ahaber": [["TUR", 2555]], "e4plus1": [["GBR", 2415]], "hdpoptv": [["SVN", 2044]], "vitaliteit": [["BEL", 153]], "tlc/animalplanet": [["NLD", 1250]], "ttv": [["POL", 1358]], "npohumortv": [["NLD", 1317]], "ginxtv": [["ROU", 1536]], "ttc": [["RUS", 1742]], "foxsports2": [["NLD", 1282], ["NLD", 1285]], "zdftheaterkanal": [["DEU", 877]], "foxsports4": [["NLD", 1285], ["NLD", 1285]], "familie24": [["NLD", 1162]], "omropfryslantelevis": [["NLD", 1274]], "rtlregionalnrw": [["AUT", 85]], "ssf": [["CHE", 2228]], "dolceinfo": [["ROU", 1581]], "rtvcdos": [["ESP", 2142]], "jim": [["BEL", 160]], "vtm": [["BEL", 155]], "6_hd_01": [["DNK", 457]], "csmuzika": [["CZE", 363]], "discoveryrealtime": [["INT", 2677]], "rtl8hd(06u-00uhiernak.290)": [["NLD", 1276]], "rsila1hd": [["CHE", 2247]], "foxretro": [["INT", 2698]], "gtv": [["CHE", 2337]], "vtv": [["BGR", 224], ["ROU", 1574], ["SVN", 1940]], "sportklubplus": [["ROU", 1558]], "antenainternational": [["ROU", 1507]], "stylenet": [["SVN", 2014]], "rtl2de": [["DEU", 845]], "tvubeda": [["ESP", 2173]], "foxsports1hdere.": [["NLD", 1283]], "znanie": [["RUS", 1749]], "foxsports5hdere.": [["NLD", 1283]], "bulgariatv": [["BGR", 233]], "babytv": [["TUR", 2560]], "tvaugsburg": [["DEU", 883]], "dafneu": [["AUT", 46]], "\u0442\u0435\u0442": [["UKR", 2544]], "asbaikal": [["RUS", 1612]], "teleshkola": [["RUS", 1735]], "redlighthd": [["POL", 1464]], "nlm_tv": [["FRA", 605]], "petka_tv": [["CZE", 422]], "rtvnoord-holland": [["NLD", 1183], ["NLD", 1184]], "7murcia": [["ESP", 2061]], "2pink": [["SVN", 1947]], "vt4": [["BEL", 171]], "vivatv": [["TUR", 2625]], "teleasturias": [["ESP", 2149]], "canal53madrid": [["ESP", 2097]], "kral": [["TUR", 2589]], "voofoothd": [["BEL", 192]], "siteltv": [["MKD", 1098]], "tv1000": [["HRV", 320], ["LTU", 1074], ["SVN", 1934]], "kanal44": [["RUS", 1660]], "perviy2domkino": [["RUS", 1716]], "free-xtv1": [["SVN", 1872]], "itvchanneltv": [["GBR", 2434]], "teletoon+1": [["FRA", 639]], "nrksuper3": [["NOR", 1327]], "rheinmain.tv": [["AUT", 80]], "canvas": [["BEL", 169]], "brnordhd": [["AUT", 43], ["DEU", 911]], "eurosport2hd_01": [["DNK", 467]], "\u0434\u0432\u0430+\u0434\u0432\u0430": [["UKR", 2501], ["UKR", 2524]], "24politiek": [["NLD", 1167]], "l1limburg": [["NLD", 1140], ["NLD", 1140]], "partenertv": [["ROU", 1546]], "disne": [["INT", 2742]], "\u0443\u043a\u0440\u0430\u0456\u043d\u0430": [["UKR", 2546]], "blm": [["DEU", 755]], "beateuhsesexysat": [["DEU", 753]], "ib3tv": [["ESP", 2124]], "rougetv": [["CHE", 2223]], "privatespice": [["BGR", 271]], "artebelgique": [["BEL", 118]], "hrt2": [["HRV", 308], ["SVN", 1884]], "hrt3": [["HRV", 327]], "ort": [["RUS", 1715]], "hrt1": [["HRV", 307], ["SVN", 1883]], "e!": [["FRA", 549], ["INT", 2765]], "100%nltv": [["NLD", 1313]], "hrt4": [["HRV", 328]], "tallinnatv": [["EST", 486]], "oglinda": [["ROU", 1544]], "raisport1": [["CHE", 2307]], "sat.1bayern": [["DEU", 903]], "gotv": [["AUT", 7]], "shortstvhd": [["NLD", 1246], ["INT", 2797]], "hystorychannel": [["SVN", 1881]], "bralpha": [["DEU", 761]], "cctv4": [["CHE", 2341]], "primorkatv": [["SVN", 2019]], "21": [["MKD", 1080]], "kcn2": [["SVN", 1991]], "kcn3": [["SVN", 1990], ["SVN", 1990]], "cemtv": [["TUR", 2565]], "canal24horas": [["CHE", 2324]], "wdrhdsiegen": [["DEU", 914]], "mirovojekino": [["RUS", 1682]], "bvntv": [["CHE", 2340]], "sundancenl": [["BEL", 175], ["NLD", 1249]], "happyxx": [["AUT", 8]], "npozapp(06-20u)/npohumortv": [["NLD", 1320]], "skyhits": [["DEU", 858]], "recordtvint.": [["CHE", 2321]], "omtv": [["FRA", 614]], "ladeux": [["BEL", 145]], "haberturktv": [["TUR", 2580], ["TUR", 2580]], "hdsporttv2": [["SVN", 2031], ["SVN", 2031]], "hdsporttv3": [["SVN", 2033], ["SVN", 2033]], "polsatfutbol": [["POL", 1394]], "tvp2": [["POL", 1381]], "sixxaustria": [["AUT", 91]], "tvp1": [["POL", 1380]], "citytv": [["BGR", 234]], "galaxiatv": [["ROU", 1535]], "dancetrippintv": [["NLD", 1120]], "samanyolu": [["TUR", 2598]], "tmflivehd": [["BEL", 150]], "openaccess3": [["GBR", 2457]], "gtrkkuzbass": [["RUS", 1639]], "hbo2hd": [["NLD", 1218], ["POL", 1388]], "realitateatv": [["ROU", 1552]], "tvrijnmond": [["NLD", 1186]], "goienatelebista": [["ESP", 2120]], "lnt": [["LVA", 1040]], "lachainemeteo": [["FRA", 580]], "teleclubprime": [["CHE", 2379]], "\u0431\u0442\u0431\u0442\u0432": [["UKR", 2526]], "ntvplusnashfutbol": [["RUS", 1698]], "tvpi": [["FRA", 666]], "varazdinska_televizija": [["HRV", 344]], "rts2": [["SRB", 1775]], "rts1": [["SRB", 1774]], "kanaldhd": [["TUR", 2585]], "fiveusa": [["GBR", 2422]], "orangesport": [["FRA", 620], ["POL", 1350]], "biptv": [["FRA", 695]], "pvtv": [["HUN", 965], ["ROU", 1593]], "taraftv": [["ROU", 1560]], "sat.1emotions": [["CHE", 2344]], "ardhd": [["CHE", 2270]], "\u0442\u043e\u043d\u0438\u0441": [["UKR", 2545]], "ethnictv": [["CZE", 366]], "kawaiitv": [["RUS", 1663]], "ardhr": [["DEU", 746]], "filmboxextra": [["BGR", 245], ["HRV", 304], ["CZE", 370], ["HUN", 951], ["POL", 1383], ["ROU", 1533]], "rbbbrandenburghd": [["AUT", 78]], "barcelonatv": [["ESP", 2071]], "24horas": [["SVN", 1827], ["SVN", 1948]], "bravanlklassiek": [["NLD", 1107]], "7ltvmontpellier": [["FRA", 489], ["FRA", 489]], "wdrhdd\u00fcsseldorf": [["DEU", 914]], "canal50valles": [["ESP", 2096]], "foxcrimehd": [["SVN", 1978]], "vijf": [["BEL", 172]], "ana": [["MKD", 1087]], "canal9valenciana": [["ESP", 2089]], "supermax": [["CZE", 397]], "nickhits": [["NLD", 1155], ["INT", 2719]], "herzschlag69": [["DEU", 796]], "13tv": [["ESP", 2189]], "echotv": [["HUN", 945]], "rtltelevizija": [["BIH", 222]], "kikahd": [["CHE", 2285]], "kanalt\u00fcrk": [["TUR", 2553]], "skysports1": [["GBR", 2469]], "npozappxtra": [["NLD", 1320]], "paprikatv": [["SVN", 1823]], "\u043f\u0435\u0440\u0448\u0438\u0439\u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0456\u043b\u044c\u043d\u0438\u0439": [["UKR", 2499]], "mangas": [["FRA", 592], ["SVN", 1893]], "skysporthd2": [["INT", 2785]], "sensotv": [["ROU", 1555]], "menttv": [["BEL", 177]], "sachsentv": [["DEU", 852]], "skysports3": [["GBR", 2471]], "rtvgeel": [["BEL", 195]], "24geschiedenis": [["NLD", 1163]], "rtpmemoria": [["PRT", 1485]], "canalmaritima": [["FRA", 513]], "atv2": [["AUT", 31]], "24techno": [["RUS", 1606]], "kliktv": [["SVN", 1994]], "s\u00fdnematvhd": [["TUR", 2635]], "gdeikto": [["RUS", 1632]], "trace": [["BEL", 151], ["FRA", 650], ["SVN", 1931]], "secretstory": [["FRA", 629]], "hamburg1": [["DEU", 794]], "blagovest": [["RUS", 1617]], "vtmhd": [["BEL", 156]], "rtlaustria": [["AUT", 83]], "primestar+1": [["BEL", 144]], "flirtline": [["DEU", 786]], "rete4": [["ITA", 1029]], "\u0435\u043c\u0434\u0432\u0430": [["UKR", 2513]], "24consumenten": [["NLD", 1160]], "buguntv": [["TUR", 2629]], "mrt": [["MKD", 1078]], "france3nordpicardie": [["FRA", 559]], "vivaplus": [["SVN", 1938], ["INT", 2758]], "kahkeshantv": [["CHE", 2220]], "skysporthd1": [["INT", 2775]], "axn": [["AUT", 111], ["SVN", 1833], ["INT", 2663]], "c9tv": [["FRA", 508]], "e\u00e9n": [["BEL", 164]], "latrois": [["BEL", 146]], "\u043f\u0435\u0440\u0448\u0438\u0439\u0434\u0456\u043b\u043e\u0432\u0438\u0439": [["UKR", 2506]], "matiditya": [["RUS", 1679]], "cinemax2hd": [["POL", 1443], ["SVN", 1972]], "rtlhd": [["DEU", 848], ["INT", 2772]], "aljazeeratv": [["SVN", 1954]], "hema": [["SVN", 1989]], "s\u00fdnematvhd2": [["TUR", 2636]], "rtvusk": [["BIH", 220]], "nlm": [["FRA", 605]], "hustler": [["POL", 1463], ["SVN", 1885]], "fantv": [["DEU", 785], ["NLD", 1134]], "xmo": [["NLD", 1202]], "telemadrid": [["ESP", 2158]], "travelhd": [["SVN", 1933]], "otik": [["RUS", 1712]], "chasseetpeche": [["FRA", 543]], "avstrija2": [["SVN", 2055]], "rtlcrime": [["DEU", 846], ["NLD", 1224]], "eredivisielive1hd": [["NLD", 1211]], "vh-1classic": [["NLD", 1109]], "ubr": [["UKR", 2521]], "kanaalz": [["BEL", 161]], "boingtv": [["ITA", 987]], "mainfranken": [["AUT", 51]], "feny": [["ROU", 1531]], "bloombergtelevision": [["DEU", 756]], "viva": [["POL", 1403], ["POL", 1472], ["SVN", 1937], ["INT", 2757]], "tonustv": [["RUS", 1737]], "24humor": [["NLD", 1165]], "ringbg": [["BGR", 267]], "tvnet": [["TUR", 2642]], "\u0437\u0443\u043c": [["UKR", 2549]], "foxhd": [["SVN", 1980], ["INT", 2766]], "film1premierehd": [["NLD", 1215]], "discoverychannel(23)": [["NLD", 1121]], "kohavision": [["SRB", 1771]], "minikidstv": [["FRA", 597]], "balkanikamusictelevision": [["BGR", 285], ["BGR", 290]], "kika": [["DEU", 815], ["SVN", 1891]], "ntvpluskinoplus": [["RUS", 1695]], "ntvplussportplus": [["RUS", 1705]], "hmm-tv": [["DEU", 798]], "slo1": [["SVN", 2058]], "slo2": [["SVN", 2059]], "myzen.tv": [["FRA", 603]], "sachsenfernsehen": [["DEU", 852]], "nettv": [["SVN", 1819], ["SVN", 1903]], "ideatv": [["SVN", 1816]], "medias": [["SVN", 2020]], "tlchd": [["NLD", 1298], ["POL", 1434]], "komirtk": [["RUS", 1673]], "tvgelderland": [["NLD", 1182]], "tvrtimisoara": [["ROU", 1567]], "tv2hd_01": [["DNK", 472]], "antena3": [["ROU", 1506], ["ROU", 1602], ["ESP", 2065]], "tvncnbc": [["POL", 1365]], "telenantes": [["FRA", 701]], "rheinneckar": [["DEU", 843]], "espn": [["SVN", 1857], ["INT", 2687]], "4+hd": [["CHE", 2354], ["CHE", 2354]], "m6boutiquelachaine": [["FRA", 586]], "onzetv": [["BEL", 197]], "tvgalicia": [["ESP", 2168]], "televize1hd": [["CZE", 354]], "bbconesouth": [["GBR", 2396]], "encyclo": [["SVN", 1855]], "\u00e7ocuksmart": [["TUR", 2608]], "lnk": [["LTU", 1064]], "weotv": [["FRA", 705]], "localtvmadrid": [["ESP", 2074]], "skysports2": [["GBR", 2470]], "paprika": [["SVN", 1823]], "skysports4": [["GBR", 2458]], "dmaxhdaustria": [["INT", 2764]], "bloomberght": [["TUR", 2564]], "dk4": [["DNK", 433]], "kinowelttv": [["DEU", 816]], "rada": [["UKR", 2551]], "rtvnoordholland": [["NLD", 1184]], "skybundesliga1": [["DEU", 863]], "wdrhdbielefeld": [["DEU", 914]], "canalsur2": [["ESP", 2107]], "cuatrohd": [["ESP", 2210]], "btvcomedy": [["BGR", 232]], "tagesschau24": [["CHE", 2279]], "x-dreamtv": [["SVN", 1942]], "nntv": [["RUS", 1690]], "klankosova": [["SRB", 1770]], "cinenovanl": [["NLD", 1113]], "sat.1nrw": [["DEU", 903]], "canallatino": [["ESP", 2104]], "24": [["TUR", 2554]], "beseries": [["BEL", 191]], "doma": [["HRV", 316], ["SVK", 1787]], "thevoice": [["BGR", 274], ["GBR", 2480]], "boomsportone": [["ROU", 1515]], "eurosporthd": [["NLD", 1130], ["POL", 1338], ["SVN", 1860], ["SVN", 1977], ["INT", 2692]], "eurokino": [["RUS", 1627]], "swrbwhd": [["DEU", 915]], "rtllounge": [["NLD", 1179]], "aljazeera": [["SVN", 1954], ["INT", 2800]], "comedie": [["FRA", 546]], "tv1lithuania": [["LTU", 1069]], "infosport": [["FRA", 573]], "galatv": [["TUR", 2578]], "manx": [["NLD", 1144]], "multimania": [["RUS", 1685]], "\u043c\u043e\u0434\u0438\u043d": [["UKR", 2536]], "lmtvsarthe": [["FRA", 585]], "nikatv": [["RUS", 1689]], "sbs6": [["NLD", 1189]], "cosmostv": [["ROU", 1521]], "nick/cchdaustria": [["AUT", 67]], "interesnoetv": [["RUS", 1654]], "tvp2hd": [["POL", 1406]], "channel21express": [["DEU", 765], ["CHE", 2216]], "servustvoesterreich": [["DEU", 926]], "tvalmansa": [["ESP", 2164]], "film1spotlighthd": [["NLD", 1311]], "hrttv1": [["CHE", 2334]], "satisfaction": [["SVN", 2011]], "skysportsactive": [["GBR", 2472]], "italia7toscana": [["ITA", 999]], "foxsports4hd": [["NLD", 1285]], "foxsports5ere.": [["NLD", 1283]], "erfeins": [["DEU", 778]], "sport1+hd": [["INT", 2779]], "ketnethd": [["BEL", 168]], "mezzo": [["INT", 2750]], "siete": [["ESP", 2192]], "m\u00fcnchen.tv": [["AUT", 64]], "omroepzeelandtelevi": [["NLD", 1174]], "hd1": [["FRA", 715]], "bostel": [["BIH", 211]], "sport1+": [["INT", 2778]], "arte": [["INT", 2661]], "sport10": [["BEL", 199]], "disneyjunior": [["SVN", 1849], ["INT", 2683]], "pratech": [["ROU", 1548]], "7dnitv": [["BGR", 225]], "calle13": [["ESP", 2075]], "wantv": [["NLD", 1299]], "more4": [["GBR", 2437]], "dasvierte": [["DEU", 767]], "sport1extra3": [["NLD", 1227]], "rtatv": [["CZE", 394]], "comedycentralhd/kindernet": [["NLD", 1221]], "rtpafrica": [["PRT", 1481]], "soriavision": [["ESP", 2147]], "3+hd": [["CHE", 2281], ["CHE", 2281]], "premiumenergy": [["ITA", 1014]], "foxsports2hd": [["NLD", 1285]], "d!citv": [["FRA", 731]], "cinemania": [["SRB", 1766]], "\u0444\u0443\u0442\u0431\u043e\u043b": [["UKR", 2507], ["UKR", 2507]], "orf1": [["AUT", 15], ["DEU", 920], ["SVN", 2054], ["CHE", 2375]], "orf3": [["AUT", 30]], "orf2": [["AUT", 17], ["SVN", 2055]], "smart\u00e7ocuk": [["TUR", 2608]], "eredivisielivehd": [["NLD", 1211]], "lastminutetv": [["DEU", 818]], "wildtv": [["SVN", 1941]], "sinematv2": [["TUR", 2604]], "tvcg": [["CHE", 2328]], "residence": [["SVK", 1799]], "polsatsport": [["POL", 1397]], "anixesd": [["AUT", 37]], "planetafolk": [["BGR", 261]], "penthouse": [["NLD", 1296]], "puls4hdaustria": [["DEU", 934]], "hit24": [["DEU", 797]], "canal7madrid": [["ESP", 2088]], "pophd": [["SVN", 2044]], "tvpinfolodz": [["POL", 1416]], "pinkx": [["FRA", 623]], "primekidz": [["BEL", 138]], "launehd": [["BEL", 184]], "\u0440\u0430\u0434\u0430": [["UKR", 2551]], "hddiscoveryscience": [["SVN", 1974]], "bbcalba": [["GBR", 2491]], "ntvworld": [["RUS", 1708]], "d17": [["FRA", 713]], "skyemotion": [["DEU", 862]], "jetix": [["RUS", 1655], ["SVN", 1826]], "rtpn": [["PRT", 1486]], "disneycinemagichd": [["DEU", 773], ["DEU", 933]], "3kanal": [["RUS", 1604]], "pinkextra": [["CHE", 2330]], "telebaern": [["CHE", 2231]], "elcezireturk": [["TUR", 2571]], "dmaxhd": [["INT", 2764], ["INT", 2787]], "besport1hd": [["BEL", 121]], "otto": [["DEU", 833]], "comedycentral": [["NLD", 1117], ["INT", 2673]], "localiatv": [["ESP", 2129]], "antenna3nordest": [["ITA", 986]], "ushua\u00efatv": [["FRA", 669]], "frankensat": [["DEU", 790]], "hollanddoc24": [["NLD", 1164]], "culture7hd": [["BEL", 183]], "\u043d\u043b\u043e\u0442\u0431": [["UKR", 2538]], "nickpremium": [["DEU", 784]], "tvecanal24horas": [["ESP", 2178]], "geschiedenis24": [["NLD", 1163]], "teleticino": [["CHE", 2254]], "crimeandinvestigation": [["SVN", 1962]], "telecincohd": [["ESP", 2191]], "orfsportplus": [["AUT", 20]], "directdigitaltv": [["ROU", 1526]], "servustv": [["AUT", 24], ["CHE", 2271]], "investigationdiscove": [["NLD", 1254]], "heimatkanal": [["DEU", 795]], "dw-tv": [["DEU", 777]], "rtp2": [["PRT", 1480]], "tlm": [["FRA", 702]], "rtp1": [["PRT", 1479]], "boomsportfour": [["ROU", 1514]], "filmbox": [["BGR", 244], ["HRV", 303], ["CZE", 369], ["HUN", 950], ["POL", 1385], ["ROU", 1532]], "swrrphd": [["DEU", 915]], "film1actionhd": [["NLD", 1247]], "be1+1h": [["BEL", 120]], "kabeleinsclassics": [["DEU", 813]], "tv2lorry_01": [["DNK", 471]], "teletoledo": [["ESP", 2153]], "\u0435\u043d\u0442\u0435\u0440\u0444\u0456\u043b\u044c\u043c": [["UKR", 2529]], "grandlille.tv": [["FRA", 697]], "croatianmusicchannel": [["HRV", 302]], "neox": [["ESP", 2194]], "rossiya1": [["RUS", 1723]], "angers7": [["FRA", 694], ["FRA", 694]], "rtlch": [["DEU", 844], ["CHE", 2287]], "mrezast": [["HRV", 334]], "animalplanethd": [["NLD", 1210], ["POL", 1330], ["INT", 2658]], "nick": [["INT", 2721]], "foxlife": [["INT", 2804]], "stv1_hd": [["DNK", 469]], "rtpmadeira": [["PRT", 1484]], "mdrt\u00fchringenhd": [["AUT", 60]], "popoto": [["SVN", 2022]], "rtviplus": [["RUS", 1730]], "eurod": [["CHE", 2314]], "tiji": [["FRA", 645], ["SVN", 1930], ["SVN", 2016]], "russiatoday": [["RUS", 1733], ["SVN", 2010]], "idealworld": [["GBR", 2426]], "orf2st": [["DEU", 917]], "robtv": [["BEL", 194]], "wdrhdwuppertal": [["DEU", 914]], "music1.cz": [["CZE", 381]], "hdnatgeo": [["SVN", 1986]], "nationalgeographicchannel": [["NLD", 1148]], "avala": [["SRB", 1763]], "opaltv": [["FRA", 700]], "andaluciatv": [["ESP", 2064]], "tvpinfokrak\u00f3w": [["POL", 1415]], "tvcastillayleon": [["ESP", 2166]], "galaxiesport": [["CZE", 373]], "klasik": [["SVN", 1993]], "canal+caraibes": [["FRA", 526]], "pop": [["SVN", 1820]], "italiachannel": [["ITA", 1000]], "film4+1": [["GBR", 2420]], "religiatv": [["POL", 1355]], "foxsports3hderedivisie": [["NLD", 1281]], "boomsecrets": [["ROU", 1513]], "tntfilmhd": [["INT", 2783]], "clan": [["ESP", 2179]], "euro6": [["DEU", 783]], "tvoranje": [["NLD", 1197]], "ntvplusinfokanal": [["RUS", 1694]], "ntvneovisnetelevizijehayat": [["BIH", 216]], "domashniy": [["RUS", 1624]], "planet_hd": [["INT", 2769]], "eurochannel": [["ROU", 1529]], "24cultura": [["NLD", 1161]], "ros-kabel": [["NLD", 1301]], "illusionplus": [["RUS", 1652]], "tvnstyle": [["POL", 1371]], "pro7de": [["CHE", 2269], ["INT", 2771]], "gtrktula": [["RUS", 1646]], "rtvmechelen": [["BEL", 195]], "superstacja": [["POL", 1400]], "tmfpure": [["INT", 2729]], "natgeo(hd)": [["INT", 2717]], "uniprix": [["FRA", 668]], "tvp": [["CHE", 2339]], "tvs": [["POL", 1360], ["ROU", 1570]], "tvr": [["FRA", 704], ["ESP", 2139]], "tvo": [["CHE", 2364]], "tvn": [["POL", 1369]], "tvi": [["PRT", 1495]], "tve": [["ESP", 2180]], "novatvhd": [["CZE", 386]], "discoverytravel&living": [["LVA", 1033], ["INT", 2803]], "akanalhd": [["SVN", 2046]], "e4+1": [["GBR", 2415]], "flirtlinetv": [["DEU", 786]], "frankentv": [["DEU", 791]], "meidenvanhollandhard": [["NLD", 1294]], "kosmica_tv": [["DEU", 817]], "telecastro": [["ESP", 2150]], "publictv": [["CZE", 392]], "tvpinfogorzowwielkopolski": [["POL", 1412]], "onyx.tv": [["DEU", 831]], "e\u00e9nhd": [["NLD", 1277]], "duna2autonomia": [["HUN", 943]], "bbcentertaiment": [["DNK", 426]], "videowerk": [["AUT", 29]], "erostv": [["DEU", 780]], "otvprimorje": [["RUS", 1714]], "traveltvint": [["BGR", 276]], "bbcthree/cbbc": [["CHE", 2291]], "tv8": [["FRA", 703], ["SVK", 1802], ["TUR", 2654]], "business": [["UKR", 2527]], "tv5": [["SRB", 1781], ["TUR", 2623]], "tv4": [["POL", 1401], ["TUR", 2653]], "tv7": [["BGR", 300], ["CZE", 399]], "tv6": [["EST", 484], ["POL", 1361]], "tv1": [["SVN", 2018]], "tv3": [["EST", 482], ["LVA", 1056], ["RUS", 1753], ["SVN", 2020], ["ESP", 2161]], "tv2": [["DNK", 447], ["TUR", 2652]], "tiertv": [["DEU", 879]], "bug\u00fcntv": [["TUR", 2629]], "sport1tennis": [["NLD", 1231]], "kdginfo": [["DEU", 811]], "mvhhard(xotix)": [["NLD", 1294]], "skfolk": [["BGR", 269]], "eventkanaal": [["NLD", 1241]], "ardmdr": [["DEU", 747]], "re:tv": [["BGR", 266]], "polsatviasathistory": [["POL", 1438]], "oe": [["LVA", 1046]], "bbc4/cbeebies": [["NLD", 1243]], "phoenixhd": [["DEU", 905]], "hbocomedyhd": [["POL", 1386], ["SVN", 1981]], "riojatv": [["ESP", 2139]], "nrjparis": [["FRA", 699]], "gradskatv": [["HRV", 332]], "hdhustler": [["SVN", 1984]], "smart3d": [["TUR", 2607]], "daserstehd": [["DEU", 740], ["CHE", 2270]], "cnn(engl)": [["INT", 2791]], "politiek24(6-18u.)/best24": [["NLD", 1167]], "beskydtv": [["CZE", 351]], "ntvplussportonline": [["RUS", 1704]], "procinema": [["ROU", 1549]], "film1series": [["NLD", 1216]], "kabeleinshd": [["INT", 2788]], "raistoria": [["ITA", 1025]], "polsatsportextrahd": [["POL", 1449]], "actuatv": [["BEL", 116]], "tracesports": [["INT", 2802]], "bntelevizija": [["BIH", 210]], "consumenten24": [["NLD", 1160]], "vh1": [["SVN", 1935], ["INT", 2755]], "pratechtv": [["ROU", 1548]], "nt1": [["FRA", 611]], "nickcomedycentral": [["CHE", 2292]], "gemstv": [["GBR", 2424]], "nicktoons": [["NLD", 1157], ["INT", 2722]], "disneycinemagic": [["INT", 2681]], "eurotransmed": [["NLD", 1131]], "b92info": [["SRB", 1764]], "ttstv": [["RUS", 1742]], "tvpinfolublin": [["POL", 1417]], "ketnet/op12": [["BEL", 168]], "axnscifi": [["INT", 2665]], "cash_tv": [["FRA", 540]], "ned2hd": [["NLD", 1206]], "primalove": [["CZE", 413]], "goltelevisi\u00f3n": [["ESP", 2197]], "ddtv": [["ROU", 1526]], "oberpfalztv": [["DEU", 829]], "culture7": [["BEL", 183]], "mtvnl": [["NLD", 1146]], "cnbc": [["SVN", 1843], ["INT", 2738]], "tvn7": [["POL", 1370]], "nrjpure": [["FRA", 610]], "dolcesport2": [["ROU", 1583]], "tvooststnik.": [["BEL", 202]], "arddw": [["DEU", 741]], "tvnturbohd": [["POL", 1363]], "nederland3": [["NLD", 1152]], "nederland2": [["NLD", 1151]], "nederland1": [["NLD", 1150]], "pohodatv": [["CZE", 389]], "pohoda": [["CZE", 389]], "dorceltv": [["FRA", 548], ["SVN", 1851], ["SVN", 1963], ["CHE", 2262]], "tele5": [["DEU", 878], ["POL", 1357]], "tele7": [["ESP", 2148]], "nova": [["BGR", 297], ["ESP", 2195]], "tele1": [["CHE", 2259]], "tmfdance": [["INT", 2728]], "enterfilm": [["UKR", 2529]], "nationaltv": [["ROU", 1543]], "npodoc": [["NLD", 1316]], "theboxcomedy": [["NLD", 1195]], "hddiscovery": [["SVN", 1975]], "polsatcafe": [["POL", 1392]], "diemafamily": [["BGR", 237]], "\u0434\u043e\u0431\u0440\u043e": [["UKR", 2528]], "\u043a\u0434\u0432\u0430": [["UKR", 2534]], "13thstreethd": [["CHE", 2297]], "trtturk": [["CHE", 2312], ["TUR", 2622]], "carchannel": [["NLD", 1110]], "boing": [["ITA", 987], ["ESP", 2190], ["INT", 2666]], "lagranadatv": [["ESP", 2125]], "hdbrio": [["SVN", 2045]], "zdfneohd": [["DEU", 900]], "a1": [["MKD", 1084]], "zoneromantica": [["INT", 2752]], "a2": [["MKD", 1085]], "veronica/disneyxdhd": [["NLD", 1208]], "tv10angers": [["FRA", 661]], "discoverysciencehd": [["SVN", 1974]], "bugun": [["TUR", 2629]], "tv5turk": [["TUR", 2623]], "sportrohd": [["ROU", 1559]], "maxsmart": [["TUR", 2612]], "equidia": [["FRA", 551]], "bravahd": [["NLD", 1106]], "telem": [["SVN", 2015], ["SVN", 2057]], "actionstar": [["ROU", 1500]], "\u0433\u0443\u043c\u043e\u0440": [["UKR", 2510]], "euronews(frz)": [["INT", 2688]], "scn": [["PRT", 1487]], "kinopolskamuzyka": [["POL", 1391]], "foxsportsere1": [["NLD", 1281]], "erotik24": [["DEU", 781]], "polsat": [["POL", 1404]], "regiotv": [["DEU", 839]], "rtl4": [["NLD", 1308], ["NLD", 1308], ["NLD", 1308]], "voxch": [["INT", 2655]], "sct": [["SVN", 1926], ["SVN", 2011]], "foxsportsinformatie": [["NLD", 1282]], "sportklub2hd": [["SVN", 2038], ["SVN", 2038]], "8madrid": [["ESP", 2212]], "eurosporti": [["CHE", 2308]], "muztv": [["RUS", 1688]], "tvrennes35": [["FRA", 664]], "canal+reunion": [["FRA", 524]], "tvfestival": [["FRA", 663]], "dusk!": [["NLD", 1125], ["NLD", 1263]], "canalplushd": [["FRA", 517]], "pink.si": [["SVN", 1912]], "discoveryfr": [["INT", 2792]], "bbc1hd": [["NLD", 1267]], "nederland_e": [["NLD", 1153]], "deko": [["HUN", 940]], "ct2": [["CZE", 355]], "boyets": [["RUS", 1620]], "best24": [["NLD", 1159]], "zdfhd": [["DEU", 899]], "r1televize": [["CZE", 393]], "4funtv": [["POL", 1470]], "imessage": [["FRA", 569]], "sportdigital": [["DEU", 874]], "foxsports5eredivisie": [["NLD", 1284]], "bestdirect": [["GBR", 2401]], "dsfsport1": [["SVN", 1852]], "1+1": [["UKR", 2523]], "nederland1hd": [["NLD", 1205]], "br_nord_hd": [["DEU", 911]], "dolcesport": [["ROU", 1582]], "tv1000premium": [["LTU", 1075]], "rainews": [["CHE", 2310]], "drramasjang": [["DNK", 437]], "mtvc": [["INT", 2703]], "bbctwohd": [["CHE", 2373]], "omroepzeeland": [["NLD", 1174]], "brsuedhd": [["CHE", 2371]], "discoverychannelhd": [["NLD", 1121]], "etalagekanaal": [["NLD", 1240]], "mdrs-anhalthd": [["AUT", 33]], "eurosport2": [["DNK", 440], ["NLD", 1128], ["INT", 2690]], "hogarutil": [["ESP", 2123]], "rtssat": [["CHE", 2327]], "bidtv": [["GBR", 2402]], "durangotelebista": [["ESP", 2113]], "blmlokalsat": [["DEU", 755]], "mirabelletv": [["FRA", 698]], "tvklik": [["SVN", 1994]], "brnotv": [["CZE", 352]], "kinoreys2": [["RUS", 1670]], "omroepwalraven": [["NLD", 1302]], "tishktv": [["FRA", 646]], "journaal24": [["NLD", 1166]], "videoclick": [["FRA", 671]], "siptv": [["SVN", 2013]], "mtvnhd": [["BEL", 133], ["POL", 1343]], "ltvworld": [["LTU", 1067]], "obnbosna": [["SVN", 1907]], "rotana": [["NLD", 1177]], "bnn101": [["NLD", 1105]], "polsatfood": [["POL", 1430]], "channel4plus1": [["GBR", 2408]], "tv5monde": [["FRA", 653]], "hematv": [["BIH", 213], ["SVN", 1989]], "bbcone(28)": [["NLD", 1288]], "duna": [["ROU", 1585], ["SVN", 1853]], "tdphd": [["ESP", 2208]], "virgin17": [["FRA", 672]], "musicbox": [["CZE", 412], ["SVK", 1790]], "ndrfssh": [["DEU", 826]], "vaughantv": [["ESP", 2202]], "canal+caledonie": [["FRA", 521], ["FRA", 525]], "\u043f\u0456\u043a\u0441\u0435\u043b\u044c\u0442\u0431": [["UKR", 2542]], "cnnt\u00fcrk": [["TUR", 2568], ["TUR", 2568]], "bgtv": [["BGR", 233]], "kinocs": [["BGR", 255], ["HRV", 311], ["CZE", 378]], "canal4avila": [["ESP", 2077]], "1-2-3.tvhd": [["AUT", 34]], "freextv": [["NLD", 1135]], "equidiapro": [["FRA", 552]], "bbttv": [["BGR", 227]], "nrksuper": [["NOR", 1326]], "canale5": [["ITA", 988]], "ntk": [["RUS", 1691]], "lietuvosrytastv": [["LTU", 1063]], "xsport": [["UKR", 2548]], "ab1": [["BEL", 112], ["FRA", 491]], "nickreplay": [["GBR", 2445]], "ab3": [["BEL", 113], ["BEL", 165], ["FRA", 492]], "ab4": [["BEL", 114], ["FRA", 493]], "ahaberhd": [["TUR", 2627]], "tvpolitika": [["SRB", 1760]], "action": [["FRA", 496]], "mtventertainment": [["DEU", 822]], "tvrepublika": [["POL", 1436]], "joizhd": [["CHE", 2370], ["CHE", 2370]], "hdmtv": [["SVN", 1985]], "wdrkoln": [["DEU", 751]], "lachainemarseille": [["FRA", 578]], "trthaber": [["TUR", 2620]], "kinomaniatv": [["RUS", 1667]], "film1serieshd": [["NLD", 1216]], "mtvpulse": [["FRA", 601], ["INT", 2710]], "musicmixsuperone": [["HUN", 961]], "premiumemotion": [["ITA", 1013]], "rtltele": [["BEL", 189]], "ekids": [["BGR", 238]], "mtvmusic24": [["NLD", 1146]], "nauticalchannel": [["CHE", 2302]], "setanta": [["IRL", 980]], "foxsports1ere.": [["NLD", 1283]], "canalpluscaledonie": [["FRA", 521]], "pinkplus": [["CHE", 2329]], "kanal5petersburg": [["RUS", 1658]], "hobbytv": [["BGR", 250]], "net5hd": [["NLD", 1234], ["NLD", 1234]], "fratv": [["DEU", 789]], "6": [["DNK", 424]], "teletoonplus1": [["FRA", 639]], "myphonetv": [["GBR", 2442]], "topshoptv": [["SVN", 1822]], "grtk": [["RUS", 1634]], "rtlfranken": [["DEU", 847]], "zenderoverzicht": [["NLD", 1238]], "telezueri": [["CHE", 2238]], "antena3noticias24horas": [["ESP", 2067]], "canal2andalucia": [["ESP", 2076]], "rtvslo1": [["SVN", 2058]], "localia": [["ESP", 2129]], "viertv": [["BEL", 171]], "r1": [["RUS", 1720]], "discoverysci": [["INT", 2794]], "rtvmostar": [["BIH", 219]], "ladya": [["RUS", 1677]], "novatv": [["BGR", 260], ["BGR", 297], ["HRV", 312], ["CZE", 385]], "idnes.tv": [["CZE", 376]], "tw1": [["AUT", 28]], "primatv": [["CZE", 391], ["ROU", 1496]], "4+": [["CHE", 2376]], "cartoon/tcm": [["NLD", 1111]], "dreamturk": [["TUR", 2569], ["TUR", 2569]], "doku/kika": [["DEU", 936]], "fightbox": [["POL", 1456]], "101tv": [["NLD", 1105]], "telelugo": [["ESP", 2157]], "beshoptv": [["BEL", 182]], "srf1hd": [["CHE", 2356]], "6_eren": [["DNK", 424]], "privatespice(xotix)": [["NLD", 1191]], "antena2": [["ROU", 1601]], "tvrt1": [["CZE", 401]], "antena1": [["ROU", 1505]], "senso": [["ROU", 1555]], "tv2_sport_hd": [["DNK", 473]], "film1comedy&kids": [["NLD", 1310]], "kisstv": [["ESP", 2211]], "nickjr": [["DEU", 827]], "animalplanet_tlc": [["NLD", 1250]], "\u043d\u043b\u043etv": [["UKR", 2538]], "kanal11": [["EST", 477]], "scifi": [["INT", 2726]], "kanal12": [["EST", 487], ["RUS", 1659]], "canalnortetv": [["ESP", 2105]], "tvsoradea": [["ROU", 1570]], "nasatv": [["MKD", 1095]], "hdsportklub2": [["SVN", 2038], ["SVN", 2038]], "hdsportklub3": [["SVN", 2039], ["SVN", 2039]], "bloombergtv": [["CHE", 2306]], "hdsportklub1": [["SVN", 2037], ["SVN", 2037]], "fx": [["IRL", 978], ["INT", 2747]], "cctv": [["INT", 2801]], "natgeoadventure": [["INT", 2714]], "sinematvhd": [["TUR", 2635]], "ondacadiz": [["ESP", 2130]], "arttv": [["TUR", 2558]], "folklortv": [["BGR", 247]], "\u043f\u0456\u043a\u0441\u0435\u043b\u044ctv": [["UKR", 2542]], "tvppolonia": [["POL", 1377]], "itv1meridian": [["GBR", 2428]], "canal44zaragoza": [["ESP", 2093]], "comedyc./kindernet": [["NLD", 1221]], "telesuedostschweiz": [["CHE", 2268]], "mktv": [["SVN", 1899]], "goitb": [["ESP", 2120]], "geatv": [["SVN", 1968]], "ntvplusfutbol": [["RUS", 1693]], "tvas": [["SVN", 1812]], "investigationdisc.": [["NLD", 1254]], "sportklub6": [["SVN", 2025], ["SVN", 2025]], "canalsat_rugby_plus": [["FRA", 537]], "1stforextv": [["CHE", 2214]], "sportklub": [["HUN", 972], ["ROU", 1557], ["SRB", 1778]], "cnnturk": [["TUR", 2568]], "zhivi": [["RUS", 1748]], "tvpolonia": [["CHE", 2339]], "dream": [["TUR", 2643]], "ege": [["TUR", 2644]], "canalnorte": [["ESP", 2105]], "garudatv": [["NLD", 1137]], "avstrija1": [["SVN", 2054]], "vivaaut": [["DEU", 909]], "marcdorcel": [["FRA", 593]], "mediasparttvhomeshopping": [["DEU", 921]], "40latino": [["ESP", 2062]], "itv": [["POL", 1340]], "premiumcinema": [["ITA", 1012]], "\u0447\u043finfo": [["UKR", 2504]], "hdakanal": [["SVN", 2046]], "musiq1": [["SVK", 1791]], "gsptv": [["ROU", 1537]], "bbconewales": [["GBR", 2397]], "style": [["ROU", 1597]], "tv_vox_logo": [["HRV", 340]], "9live": [["DEU", 736]], "\u0441\u0442\u0431": [["UKR", 2505], ["UKR", 2543]], "e!tv": [["CHE", 2296]], "novatvpula": [["HRV", 313]], "beinsport1hd": [["FRA", 724]], "bbcthree": [["GBR", 2498]], "sicmulher": [["PRT", 1490]], "flymusic": [["ESP", 2119]], "tntru": [["RUS", 1758]], "npremium": [["POL", 1344]], "tvc33": [["ESP", 2174]], "beinsport": [["FRA", 723]], "srcetv": [["HRV", 338]], "animauxtv": [["SVN", 1831]], "skybluemovie": [["DEU", 855]], "cem": [["TUR", 2565]], "tvriasi": [["ROU", 1566]], "powerturktv": [["TUR", 2597]], "party": [["ROU", 1547]], "syfyhd": [["INT", 2781]], "cleartv": [["NLD", 1114]], "diema": [["BGR", 295]], "skycinema": [["DEU", 856]], "bbcentertainment": [["GBR", 2389], ["GBR", 2389]], "7gold": [["ITA", 983]], "orleanstv": [["FRA", 622]], "trt-1": [["TUR", 2645]], "channel21": [["DEU", 928]], "nickelodeontv": [["SVN", 2000]], "parispremiere": [["FRA", 709], ["FRA", 709]], "tvistra": [["HRV", 342]], "pyatiykanal": [["RUS", 1658]], "erffernsehen": [["DEU", 779]], "tntfilm(tcm)": [["AUT", 106]], "nauticaltv": [["SVN", 1944]], "energy": [["ESP", 2186]], "mtvmusic": [["DEU", 824], ["INT", 2709]], "idea": [["SVN", 1816]], "ketnetop12": [["BEL", 168]], "la3tv": [["ITA", 1003]], "gtrktomsk": [["RUS", 1645]], "canal9_hd_01": [["DNK", 459]], "skyatlantic": [["AUT", 92]], "kuhniatv": [["RUS", 1676]], "somos": [["ESP", 2146]], "rtl8": [["NLD", 1276]], "rtl9": [["FRA", 732]], "tvgusto": [["DEU", 886]], "rtl2": [["HRV", 323], ["DEU", 845], ["DEU", 845], ["SVN", 1921], ["SVN", 2056], ["CHE", 2363], ["CHE", 2363]], "ntvamna": [["BIH", 215]], "cartoonnetwork": [["NLD", 1111], ["INT", 2667]], "alfatv": [["MKD", 1086]], "rtl7": [["NLD", 1178]], "servustvhdoesterreich": [["DEU", 926]], "rtl5": [["NLD", 1275]], "24cz": [["CZE", 346]], "tv6lietuva": [["LTU", 1071]], "canal4castillayleon": [["ESP", 2079]], "canalplusbleureunion": [["FRA", 520]], "tvprozrywka": [["POL", 1433]], "etnotv": [["ROU", 1527]], "ntvrussia": [["RUS", 1756]], "sportkanaal": [["NLD", 1193]], "magyartv2": [["HUN", 958]], "france3corseviastella": [["FRA", 558]], "tvcastellon": [["ESP", 2165]], "skyxmashd": [["AUT", 95]], "djazztv": [["NLD", 1272]], "sonnenklar": [["DEU", 872]], "saartv": [["DEU", 851]], "mmc": [["SVN", 2053]], "zonefantasy": [["INT", 2760]], "amica9": [["ITA", 984]], "hdeurosport2": [["SVN", 1859]], "goldtv": [["GBR", 2425]], "nickleodeon": [["SVN", 1905]], "sicradical": [["PRT", 1492]], "crime&investigationnetwork": [["NLD", 1256]], "vh1-classic": [["CHE", 2301]], "move_on_tv": [["BEL", 131]], "bbconenortheastcumbria": [["GBR", 2393]], "\u043d\u043b\u043e\u0442\u0432": [["UKR", 2538]], "superrtlhd": [["INT", 2780]], "vitayatv": [["BEL", 162]], "escales": [["FRA", 554], ["SVN", 1856]], "hdpop": [["SVN", 2044]], "universalchannel": [["INT", 2733]], "foxserie": [["DEU", 787]], "telegenil": [["ESP", 2156]], "cherie25": [["FRA", 719]], "astelevizija": [["SVN", 1812]], "myfamilytv": [["GBR", 2441]], "lachainetheatres": [["FRA", 727]], "fransatinfohd": [["FRA", 721]], "tele5hdaustria": [["AUT", 105]], "tf6": [["FRA", 643]], "tf1": [["FRA", 641]], "cinestraaction": [["HRV", 322]], "eurosport2liga": [["DNK", 441]], "itv4": [["GBR", 2433]], "becine": [["BEL", 190]], "lasextahd": [["ESP", 2185]], "itv1": [["GBR", 2427], ["GBR", 2492]], "itv3": [["GBR", 2431]], "mediatsettv": [["SVN", 1995]], "beinsportactu": [["FRA", 723]], "wojnaipokoj": [["POL", 1382]], "tv3lietuva": [["LTU", 1070]], "k-15tv": [["MKD", 1091]], "cartoon": [["SVN", 1837]], "family7": [["NLD", 1133]], "wdrhdk\u00f6ln": [["DEU", 914]], "orfeinshd": [["CHE", 2280]], "tvn24": [["POL", 1364]], "hopechannel": [["DEU", 799]], "dizismart": [["TUR", 2609]], "sat.1hd": [["CHE", 2286], ["INT", 2773]], "tvnstylehd": [["POL", 1362]], "tvpinfogdansk": [["POL", 1411]], "filmmuzeum": [["HUN", 953]], "gutelaunetv": [["DEU", 793]], "showmax": [["TUR", 2600]], "jmlshop": [["AUT", 54]], "tvbreizh": [["FRA", 662]], "npopolitiek": [["NLD", 1319]], "rtl102.5": [["ITA", 1017]], "center": [["DEU", 764]], "viasathistory": [["BGR", 287], ["HRV", 319], ["CZE", 403]], "ardwdr": [["DEU", 751]], "hdoto": [["SVN", 2048]], "kino": [["SVN", 2021]], "biographychannel": [["CHE", 2293]], "show-turk": [["CHE", 2315]], "teva": [["FRA", 733]], "\u043f\u0435\u0440\u0448\u0438\u0439\u043d\u0430\u0446\u0456\u043e\u043d\u0430\u043b\u044c\u043d\u0438\u0439": [["UKR", 2541]], "kanal5plus": [["MKD", 1093]], "24best": [["NLD", 1159]], "ntvplussportklassika": [["RUS", 1703]], "djtv": [["NLD", 1124]], "mgmmoviech.": [["INT", 2702]], "nextdirectory": [["GBR", 2444]], "eurofutbol": [["TUR", 2572]], "7l": [["FRA", 489]], "ka2": [["BEL", 204]], "\u043f\u0456\u043a\u0441\u0435\u043b\u044c\u0442\u0432": [["UKR", 2542]], "outtv": [["NLD", 1175]], "gtrkkostroma": [["RUS", 1638]], "freextv2": [["NLD", 1136]], "discoveryscience": [["LVA", 1032], ["SVN", 2012], ["ESP", 2203], ["INT", 2740]], "einsplushd": [["AUT", 39]], "polsatplay": [["POL", 1396]], "alicedeutschland": [["AUT", 36]], "hdtv1.cz": [["CZE", 375]], "netxxl": [["SVN", 1904]], "dizismarthd": [["TUR", 2610]], "k3": [["DEU", 810]], "k2": [["ITA", 1002]], "spiceprivate": [["FRA", 632]], "sciencediscovery": [["SVN", 2012]], "slam!tv": [["NLD", 1190], ["NLD", 1190]], "veronicahd/disneyxd": [["NLD", 1237], ["NLD", 1237]], "sat.1ns/bremen": [["DEU", 903]], "galaxytv": [["RUS", 1630]], "rtv21popullore": [["SRB", 1777]], "nova+": [["BGR", 259]], "canal4digital": [["ESP", 2080]], "clermontpremi\u00e8re": [["FRA", 545]], "barrandov": [["CZE", 348]], "seasons": [["FRA", 628]], "filmplus": [["BGR", 243], ["CZE", 368], ["CZE", 405], ["HUN", 948]], "stv2": [["SVK", 1783]], "tvmittelrhein": [["DEU", 888]], "tveuropa": [["BGR", 278]], "imedtv": [["FRA", 572]], "passietv/dusk!": [["NLD", 1223]], "cinquestelle": [["ITA", 991]], "somostv": [["ESP", 2146]], "sicnoticias": [["PRT", 1491]], "newmediatv": [["AUT", 13]], "rtlpassion": [["DEU", 850]], "tvlux": [["BEL", 152], ["SVK", 1793]], "rusiyaalyaum": [["RUS", 1732]], "amica9tv": [["ITA", 984]], "m6musichits": [["FRA", 590]], "bwfamilytv": [["DEU", 763]], "sbtv": [["HRV", 337]], "happytv": [["SRB", 1768]], "libelletv": [["BEL", 203]], "canalplusantilles": [["FRA", 519]], "perviy4vremya": [["RUS", 1717]], "gold": [["GBR", 2425]], "rtl": [["HRV", 315], ["DEU", 844], ["SVN", 1920], ["CHE", 2287]], "channel4": [["GBR", 2404]], "rti": [["ESP", 2138]], "mtvhd": [["DEU", 823], ["SVN", 1985]], "rtv": [["ROU", 1595]], "rtp": [["ESP", 2140]], "rts": [["ROU", 1554], ["SVN", 1923]], "sport1hd": [["DEU", 896], ["NLD", 1192], ["NLD", 1229]], "b92tv": [["SRB", 1765]], "moozro": [["ROU", 1589]], "discoveryvl": [["INT", 2792]], "canal+cinema": [["FRA", 514]], "cnnint.": [["CHE", 2304]], "tvvychod": [["SVK", 1808]], "sontse": [["UKR", 2552]], "tracesportshd": [["FRA", 651]], "paxtv": [["HUN", 964]], "raiextra": [["ITA", 1021]], "okto": [["AUT", 14]], "tvlimburg": [["NLD", 1140]], "srf1": [["CHE", 2377], ["CHE", 2377]], "\u00e9\u00e9nhd": [["BEL", 163]], "rtpint.": [["CHE", 2319]], "srf2": [["CHE", 2378]], "teleclubcinema": [["CHE", 2232]], "wojnaipokojhd": [["POL", 1428]], "politiek24": [["NLD", 1167]], "foxsports2hd(inter.)": [["NLD", 1282]], "tvgloboint.": [["CHE", 2322]], "aztv": [["RUS", 1614]], "i>tele": [["FRA", 686]], "viasattv3puls": [["DNK", 454]], "playboytv": [["INT", 2724]], "rbbberlinhd": [["AUT", 78]], "polsatviasatexplorer": [["POL", 1454]], "eurostar": [["CHE", 2313]], "nautik": [["SVK", 1807]], "hse24hd": [["DEU", 929]], "alexandratv": [["BGR", 226]], "nat24plus": [["ROU", 1591]], "ndrfshhhd": [["DEU", 904]], "trinitastv": [["ROU", 1563]], "davincilearning": [["SVN", 1844], ["INT", 2674]], "tcm": [["INT", 2727]], "rossiyakultura": [["RUS", 1725]], "moozhitshd": [["ROU", 1588]], "rfo": [["DEU", 841]], "rfl": [["DEU", 840]], "1/carlitv": [["SVN", 1813]], "art": [["TUR", 2558]], "qvchd": [["DEU", 924]], "hdfoxcrime": [["SVN", 1978]], "slo2hd": [["SVN", 2051]], "radiobremen": [["DEU", 837]], "\u0433\u0430\u043c\u0430\u0442\u0435\u043b\u0435\u043a\u0430\u043d\u0430\u043b": [["UKR", 2508]], "channel4music": [["GBR", 2406]], "ard": [["DEU", 739], ["NLD", 1261], ["SVN", 1832]], "cultura": [["NLD", 1161]], "normandietv": [["FRA", 606]], "drupdate": [["DNK", 438]], "cinestartv": [["HRV", 321], ["SVN", 1840]], "disneyxd": [["DNK", 432], ["POL", 1334], ["CHE", 2350], ["INT", 2684]], "sport1golf": [["NLD", 1228]], "goedtv": [["NLD", 1138]], "canalsat_foot_plus": [["FRA", 531]], "ritv": [["HRV", 336]], "regi\u00e3onortetv": [["PRT", 1478]], "ewtntv": [["SVN", 1861]], "kabel1": [["SVN", 1889]], "motorstv": [["LVA", 1043], ["SVN", 1900]], "golicatv": [["SVN", 1814]], "hustlertv": [["DEU", 803], ["LVA", 1036], ["CHE", 2264]], "hdfoxmovies": [["SVN", 1979]], "inxtc": [["AUT", 10]], "sat1ch": [["CHE", 2227]], "x-mo": [["NLD", 1202]], "bbci": [["GBR", 2391]], "hbo3": [["NLD", 1265]], "hbo2": [["SVN", 1878], ["INT", 2699]], "etno": [["ROU", 1527]], "sport1ushd": [["CHE", 2374], ["CHE", 2374]], "pinkfolk": [["SVN", 1910], ["SVN", 2004]], "beautytv": [["AUT", 35]], "sporttv": [["SVN", 2029]], "brs\u00fcdhd": [["DEU", 911], ["CHE", 2371]], "axnsci-fi": [["POL", 1431]], "mega": [["UKR", 2537]], "polsatviasatnature": [["POL", 1448]], "televeronika": [["CHE", 2237]], "canalz": [["BEL", 127]], "hmmtv": [["DEU", 798]], "buzz": [["ESP", 2072]], "federalnatv": [["BIH", 212]], "tevesur": [["NLD", 1194]], "mtvtwo": [["FRA", 602]], "disneyvl": [["INT", 2742]], "foodnetwork": [["INT", 2796]], "\u0433\u0430\u043c\u043c\u0430\u0442\u0435\u043b\u0435\u043a\u0430\u043d\u0430\u043b": [["UKR", 2508]], "hustlerhd": [["SVN", 1984]], "godchannel": [["AUT", 52]], "ertworld": [["CHE", 2338]], "france24(enfrance)": [["FRA", 560]], "tv56": [["SVK", 1805]], "live1": [["FRA", 584]], "tekshoptv": [["FRA", 635]], "tgi": [["FRA", 644]], "openaccess": [["GBR", 2455]], "historytmhd": [["NLD", 1220]], "sinematvhd2": [["TUR", 2636]], "cbbc": [["GBR", 2388], ["GBR", 2493]], "wdrhdduisburg": [["DEU", 914]], "retv": [["BGR", 266]], "hrtplus:htvplus": [["HRV", 309]], "swr": [["DEU", 876]], "drdishtv": [["DEU", 775]], "tvplus": [["BGR", 279]], "r.contactvision": [["BEL", 188]], "tg4": [["IRL", 981]], "spiegelgeschichte": [["CHE", 2349]], "voenentvkanal": [["BGR", 282]], "tv2zulu": [["DNK", 450]], "foxsports3eredivisie": [["NLD", 1284]], "skysporthdextra": [["INT", 2776]], "nrw": [["DEU", 889]], "rsila2": [["CHE", 2225], ["CHE", 2248]], "artehd(d)": [["NLD", 1286]], "mychannel": [["GBR", 2440]], "trtt\u00fcrk": [["TUR", 2622]], "briohd": [["SVN", 2045]], "france3centre": [["FRA", 557]], "teleutrera": [["ESP", 2159]], "itv1hd": [["GBR", 2495]], "tvsudmontpellier": [["FRA", 711]], "canal39": [["ESP", 2092]], "comingsoon": [["ITA", 993]], "slo1hd": [["SVN", 2050]], "ohotnikirybolov": [["RUS", 1711]], "motors": [["SVN", 1900]], "nickelodeon/teennick": [["NLD", 1158]], "superrtlaustria": [["AUT", 102]], "ushuaia": [["FRA", 669]], "vox": [["SVN", 1939], ["INT", 2655]], "ric": [["AUT", 81]], "pebbletv": [["NLD", 1257]], "polsat_jim_jam": [["POL", 1457]], "orf2hd": [["AUT", 18]], "free-xtv2": [["SVN", 1873]], "rutv": [["RUS", 1731]], "bibel.tvhd": [["AUT", 41]], "canalplussport": [["FRA", 518]], "tvrostock": [["DEU", 890]], "bnt1": [["BGR", 228]], "lastminute": [["DEU", 818]], "tv5mondeorient": [["FRA", 659]], "tvtours": [["FRA", 665]], "omroepdommelland": [["NLD", 1306]], "beserieshd": [["BEL", 191]], "bom": [["MKD", 1088]], "travelchannelhdwe": [["GBR", 2484]], "rtl4hd": [["NLD", 1308], ["NLD", 1308]], "bon": [["FRA", 507]], "france3corse": [["FRA", 690]], "veronica/disneyxd": [["NLD", 1208], ["NLD", 1237]], "sterren24": [["NLD", 1170]], "citizentv": [["FRA", 544]], "canalpanda": [["ESP", 2106]], "rtliihdaustria": [["AUT", 87]], "sportacentrs": [["LVA", 1053]], "viasattv1000": [["EST", 485]], "hdviasatnature": [["SVN", 1988]], "tvnhd": [["POL", 1366]], "\u043d\u043e\u0432\u0438\u0439\u043a\u0430\u043d\u0430\u043b": [["UKR", 2539]], "hbocomedy": [["SVN", 1879], ["INT", 2701]], "l1tv": [["NLD", 1140]], "pg24": [["CZE", 388]], "bntv": [["SVN", 1959], ["SVN", 1959]], "ringtv": [["BGR", 267], ["SVK", 1794]], "servustvdeutschland": [["DEU", 926]], "deejaytv": [["ITA", 994]], "ltv7": [["LVA", 1042]], "ltv2": [["LTU", 1066]], "ltv1": [["LVA", 1041], ["LTU", 1065]], "cbsdrama": [["INT", 2669]], "infochannel": [["CHE", 2275]], "servustvhddeutschland": [["DEU", 926]], "rtlhdaustria": [["AUT", 84]], "skat": [["BGR", 270]], "tvpinfoolsztyn": [["POL", 1418]], "rtviinfo": [["RUS", 1728]], "ntvpluspremiera": [["RUS", 1701]], "tvphd": [["POL", 1374]], "jednotka": [["SVK", 1782]], "bgtrk": [["RUS", 1616]], "laotra": [["ESP", 2126]], "jimjam": [["CZE", 407], ["LVA", 1038], ["SVN", 1888]], "channel4hd": [["GBR", 2405]], "n24austria": [["AUT", 65]], "prosiebenhd": [["INT", 2770]], "regionalfernsehenlandshut": [["DEU", 840]], "gtrksamara": [["RUS", 1644]], "sonnenklar.tvhd": [["AUT", 100]], "bio": [["AUT", 42]], "kabeleinshdaustria": [["AUT", 56]], "swrfernsehen": [["DEU", 876]], "domatv": [["HRV", 316]], "trt4-cocuk": [["TUR", 2619]], "polsatsportextra": [["POL", 1398], ["POL", 1439]], "tginteractif": [["FRA", 644]], "tvm3": [["CHE", 2240], ["CHE", 2255]], "omroepflevoland": [["NLD", 1102]], "hayat": [["SVN", 1876]], "vosgestv": [["FRA", 722], ["FRA", 722]], "trthd": [["TUR", 2621]], "besport1": [["BEL", 121]], "orbistv": [["MKD", 1096]], "\u00e9\u00e9n": [["BEL", 164]], "natgeo(kd)": [["INT", 2717]], "tvoostdend.": [["BEL", 202]], "k3kulturkanal": [["DEU", 810]], "l1mburg": [["NLD", 1140]], "pinkmusic": [["SVN", 1911], ["SVN", 2007]], "\u0441\u0456\u0442\u0456": [["UKR", 2503]], "melodyzentv": [["SVN", 1996]], "film1spotlight": [["NLD", 1311]], "een": [["BEL", 164]], "\u0443\u043d\u0456\u0430\u043d": [["UKR", 2500]], "dvojka": [["SVK", 1783]], "kurdsattv": [["CHE", 2336]], "viasatsporteast": [["EST", 481]], "braba": [["NLD", 1173]], "cbsaction": [["INT", 2668]], "protv": [["ROU", 1550]], "hallmark": [["SVN", 1815]], "ctrltv": [["NLD", 1118]], "hdsporttv1": [["SVN", 2027], ["SVN", 2027]], "poptv": [["SVN", 1820], ["SVN", 1914]], "puls4austria": [["DEU", 934]], "3sat": [["DEU", 734]], "pali": [["DEU", 834]], "antenna3": [["ITA", 985]], "24journaal": [["NLD", 1166]], "frtvsudbaden": [["DEU", 788]], "teleclubstar": [["CHE", 2236]], "showplus": [["TUR", 2601]], "girondinstv": [["FRA", 564]], "joitv": [["ITA", 1001]], "disneycinemagic+1": [["INT", 2682]], "espnhd": [["SVN", 1976]], "minimax": [["SVN", 1898], ["INT", 2751]], "gtrkvologda": [["RUS", 1649]], "foxsp.3/at5/cart.nw.": [["NLD", 1282]], "bridgetv": [["RUS", 1621]], "popkino": [["SVN", 2021]], "parispremi\u00e8re": [["FRA", 709]], "anne": [["BEL", 117]], "nrk1": [["NOR", 1323]], "superrtlde": [["CHE", 2267]], "nrk3": [["NOR", 1325]], "weerenverkeer": [["NLD", 1200]], "zzip": [["CZE", 345]], "polsatsporthd": [["POL", 1399]], "swrhd": [["CHE", 2284]], "acht": [["BEL", 115]], "bn": [["CHE", 2335]], "13streethd": [["CHE", 2297]], "bbchd": [["POL", 1331], ["GBR", 2497]], "televize4hd": [["CZE", 358]], "tvjojhd": [["SVK", 1788]], "br": [["DEU", 738]], "polartv": [["CZE", 390]], "nueve": [["ESP", 2200]], "discoverywo": [["INT", 2678]], "bfmbusinessparis": [["FRA", 681]], "mediashopping": [["ITA", 1016]], "tv8montblanc": [["FRA", 703]], "nationalgeographic": [["INT", 2716]], "libertaddigital": [["ESP", 2128]], "pro7": [["CHE", 2269]], "classica": [["INT", 2763]], "enisej": [["RUS", 1625]], "tvnmeteo": [["POL", 1368]], "sportplus": [["FRA", 633]], "juwelotv": [["DEU", 809]], "tv2_hu": [["HUN", 973]], "tvrcraiova": [["ROU", 1565]], "sport1voetbalhd": [["NLD", 1270]], "gamma": [["UKR", 2508]], "jimmy": [["FRA", 574]], "canal33madrid": [["ESP", 2091]], "mediasetitalia": [["ITA", 1009]], "cfoot": [["FRA", 682]], "tv7bordeaux": [["FRA", 660]], "solmusica": [["ESP", 2145]], "intv": [["DEU", 919]], "hdslo2": [["SVN", 2051]], "\u0447\u043f\u0456\u043d\u0444\u043e": [["UKR", 2504]], "starparadiesat": [["AUT", 101]], "hdslo1": [["SVN", 2050]], "hdanimal": [["SVN", 1830], ["SVN", 1971]], "qvcdeutschland": [["AUT", 77]], "npopolitiek(06-18u)/npobest(18-06u)": [["NLD", 1319]], "orion.tv": [["DEU", 832]], "k-tv": [["AUT", 11], ["CHE", 2278]], "pinkfamily": [["SVN", 2003]], "kanalb": [["TUR", 2583]], "fiver": [["GBR", 2423]], "planetartr": [["SVN", 1922]], "katun24": [["RUS", 1662]], "rtvherentho.": [["BEL", 195]], "canal4salamanca": [["ESP", 2083]], "canalsat_horizons": [["FRA", 533]], "france\u00f4": [["FRA", 693]], "\u0433\u043b\u0430\u0441": [["UKR", 2509]], "canalterrassa": [["ESP", 2109]], "tv21": [["CHE", 2332]], "nostalgienet": [["NLD", 1172]], "canal7delatlantico": [["ESP", 2087]], "nrj12hd": [["FRA", 608]], "weltderwunder": [["AUT", 109]], "junior": [["CHE", 2298]], "raitre": [["ITA", 1026]], "info": [["SVN", 1887]], "ch\u00e9rie25": [["FRA", 719]], "canalsat_de_foot": [["FRA", 529]], "canalpluscinema": [["FRA", 514]], "hdfood": [["SVN", 1868]], "fan.tv": [["NLD", 1134]], "planet": [["CHE", 2294]], "utv": [["ROU", 1572]], "arenasport1": [["SRB", 1761]], "arenasport2": [["SRB", 1762]], "gtrkperm": [["RUS", 1642]], "m6musicblack": [["FRA", 588]], "eusp": [["NLD", 1127]], "france4": [["FRA", 691]], "france5": [["FRA", 692]], "sinematv": [["TUR", 2603]], "skybundesligahd1": [["DEU", 863]], "france2": [["FRA", 688], ["SVN", 1870]], "france3": [["FRA", 689]], "veselinatv": [["BGR", 281]], "nr1turk": [["TUR", 2631]], "3fm": [["NLD", 1266]], "nautical": [["SVN", 1944]], "nickelodeon/comedycentralch": [["CHE", 2288]], "sonyentertainmenttelevision": [["LVA", 1052]], "ardndr": [["DEU", 748]], "stvavrupa": [["CHE", 2318]], "akanal": [["SVN", 1818]], "plugrtl": [["BEL", 134]], "mtvbrandnew": [["NLD", 1145]], "sat.1hh/sh": [["DEU", 903]], "tv2news": [["DNK", 449]], "tva": [["SVK", 1792]], "bfmtv": [["FRA", 505]], "gtrkdalnevostochnaya": [["RUS", 1634]], "rossiya2": [["RUS", 1724]], "theisraelinetwork": [["ISR", 982]], "ct1hd": [["CZE", 354]], "baltijostelevizija": [["LTU", 1062]], "geomania": [["RUS", 1633]], "rtltvi": [["BEL", 149]], "tagesschau24hd": [["AUT", 103]], "foxsports3ere.": [["NLD", 1283]], "clubtv": [["ROU", 1519]], "karusel-tv": [["RUS", 1754]], "tvbayern": [["DEU", 884]], "reflektortv": [["HUN", 966]], "artchannel": [["FRA", 501]], "constantatv": [["ROU", 1520]], "natgeo": [["INT", 2716]], "rossiya24": [["RUS", 1757]], "franceo": [["FRA", 693]], "acasa": [["ROU", 1499]], "m6musicclub": [["FRA", 589]], "kosmostv": [["RUS", 1674]], "teleclubsport1": [["CHE", 2233]], "digisportplus": [["ROU", 1524]], "rtl7hd": [["NLD", 1178], ["NLD", 1235], ["NLD", 1235]], "teleclubsport2": [["CHE", 2234]], "itv2plus1": [["GBR", 2430]], "disneychannelhd_01": [["DNK", 463]], "disneychannel(tc)": [["CHE", 2343]], "ziggotv": [["NLD", 1239]], "ikonotv": [["DEU", 804]], "ct2hd": [["CZE", 356]], "rtsun": [["CHE", 2250]], "life!tv": [["BEL", 180]], "thomascook": [["GBR", 2482]], "nasn": [["GBR", 2443]], "skysportnewshd": [["AUT", 99]], "sicint.": [["CHE", 2320]], "24spirit": [["NLD", 1168]], "\u043a\u0456\u043d\u043e\u0442\u043e\u0447\u043a\u0430": [["UKR", 2535]], "planeteplus": [["FRA", 707]], "rainews24": [["ITA", 1024]], "xstream": [["FRA", 676]], "bebe\u00f0imtv": [["TUR", 2561]], "mtvgermany": [["INT", 2703]], "cinestar": [["SVN", 1840]], "bvn": [["NLD", 1108]], "tvc300": [["ESP", 2175]], "topmusicchannel": [["AUT", 26]], "prosieben": [["INT", 2771]], "skysporthd": [["DEU", 870]], "jabukatv": [["HRV", 329]], "regio.tv": [["DEU", 839]], "itv2": [["GBR", 2429]], "24hollanddoc": [["NLD", 1164]], "perviymeteo": [["RUS", 1719]], "internationaltv": [["DEU", 806]], "bbc2scotland": [["GBR", 2385]], "cocuksmart": [["TUR", 2608]], "tmf": [["INT", 2730]], "kinopokaz": [["RUS", 1668]], "ndrfernsehenhh": [["DEU", 826]], "kcn": [["SVN", 1992]], "comedycentralextra": [["NLD", 1117]], "golica": [["SVN", 1814], ["SVN", 1874]], "stvdvojka": [["CZE", 416]], "ginx": [["SVN", 1969]], "trt-turk": [["CHE", 2312]], "sat.1": [["DEU", 903], ["CHE", 2227]], "tvliptov": [["SVK", 1804]], "magazineshowcase": [["GBR", 2435]], "vivolta": [["FRA", 673]], "abmoteurs": [["FRA", 494], ["SVN", 1828], ["SVN", 1951]], "ntvmir": [["LVA", 1045], ["SVN", 1906], ["SVN", 2001]], "france24(inarabic)": [["FRA", 560]], "magic": [["GBR", 2436]], "tro": [["RUS", 1740]], "ngchd": [["NLD", 1245]], "trknadym": [["RUS", 1739]], "trt": [["TUR", 2646]], "discoveryworld": [["INT", 2678]], "sport7bg": [["BGR", 272]], "canal+": [["FRA", 710]], "magyartv1": [["HUN", 957]], "cfi": [["FRA", 541]], "fbtvfenerbahce": [["TUR", 2575]], "gtrkural": [["RUS", 1647]], "djazz.tv": [["NLD", 1272]], "canal9": [["DNK", 427]], "canal8": [["FRA", 510]], "tccinema": [["CHE", 2232]], "tvrmaine": [["ROU", 1569]], "tvpinfokatowice": [["POL", 1413]], "ct4": [["CZE", 357]], "not\u00e9l\u00e9": [["BEL", 173]], "ct1": [["CZE", 353]], "pearl.tvhd": [["AUT", 71]], "bdm": [["FRA", 680]], "glitz*hd": [["INT", 2767]], "qualiplus": [["FRA", 626]], "beyaz": [["TUR", 2562]], "orangecinenovo": [["FRA", 619]], "cicrime&investigation": [["NLD", 1256]], "ndrfsndshd": [["DEU", 904]], "ketnet": [["BEL", 168]], "cbsreality": [["INT", 2670]], "ardeinsextra": [["DEU", 742]], "tvnhd+1": [["POL", 1367]], "foxsports1eredivisie": [["NLD", 1284]], "tvpinfoopole": [["POL", 1419]], "canalj": [["FRA", 512]], "tv3ireland": [["IRL", 976]], "fln": [["SVN", 1867], ["SVN", 1966]], "mgmhd": [["POL", 1466]], "telebasel": [["CHE", 2242]], "fox(tc)": [["CHE", 2351]], "meteotv": [["CZE", 411]], "atvba": [["BIH", 206]], "deluxemusichdaustria": [["AUT", 47]], "bbctwo(28)": [["NLD", 1290]], "z1": [["HRV", 301], ["CZE", 402]], "extreme": [["SVN", 1863]], "alphatvploiesti": [["ROU", 1504]], "doku-kika": [["DEU", 936]], "rsila1": [["CHE", 2224], ["CHE", 2245]], "dreamt\u00fcrk": [["TUR", 2569]], "primeaction": [["BEL", 135]], "sinema_tv2": [["TUR", 2637]], "imagesplus": [["FRA", 571]], "rtlkockica": [["HRV", 331]], "zappelin/zapp24": [["NLD", 1203]], "popcore": [["BGR", 263]], "teletop": [["CHE", 2230]], "nt1remix": [["FRA", 612]], "hr-fernsehenhd": [["CHE", 2367]], "mdrsachsenhd": [["AUT", 60]], "ctn": [["BGR", 235]], "nmetv": [["GBR", 2447]], "sundancefr": [["BEL", 175], ["NLD", 1249]], "omusic": [["GBR", 2453]], "tv1volvograd": [["RUS", 1744]], "\u0434\u043e\u0431\u0440\u043e\u0442\u0431": [["UKR", 2528]], "\u0434\u043e\u0431\u0440\u043e\u0442\u0432": [["UKR", 2528]], "rtkp": [["SVN", 1919]], "wdrwuppertal": [["DEU", 751]], "wdrhdaachen": [["DEU", 914]], "gameone": [["FRA", 562]], "tdp": [["ESP", 2181]], "eurotictv": [["AUT", 6]], "canalsat_cine_plus_rose": [["FRA", 528]], "tv4r_logo": [["HRV", 341]], "canal+horizons": [["FRA", 522]], "atvbanjaluka": [["BIH", 206]], "animalplanet(tc)": [["CHE", 2348]], "omroepbrabanttelevi": [["NLD", 1173]], "mtvadria": [["SVN", 1997]], "disney_xd": [["DNK", 462]], "polsatsportnews": [["POL", 1354]], "tcstar": [["CHE", 2236]], "ftvba": [["BIH", 212]], "wdrhd": [["CHE", 2283]], "skycinemahd": [["DEU", 857]], "rtk1": [["SVN", 1919]], "sportstv": [["TUR", 2613]], "videoitalia": [["CHE", 2311]], "tvpaprika": [["CZE", 419], ["HUN", 974], ["SVN", 1823]], "baby": [["SVN", 1834], ["TUR", 2560]], "skycinemaplus1": [["DEU", 859]], "rtllivinghd": [["CHE", 2369]], "shortstv": [["FRA", 631]], "kanalturk": [["TUR", 2553], ["TUR", 2553], ["TUR", 2586]], "acasatv": [["ROU", 1499]], "csmini": [["CZE", 362]], "klassika": [["RUS", 1672]], "challenge": [["GBR", 2403]], "kinopolska": [["POL", 1341]], "skyatlantichd": [["AUT", 98], ["DEU", 854]], "vivagermany": [["DEU", 909]], "\u043d\u043e\u0432\u0438\u0439": [["UKR", 2539]], "sat.1ahd": [["AUT", 89]], "antena3hd": [["ESP", 2188]], "idf1": [["FRA", 570]], "rtl102.5cool": [["ITA", 1017]], "ulstertv": [["GBR", 2488]], "rtvnoord": [["NLD", 1183]], "filmboxaction": [["POL", 1442]], "brfss\u00ef\u00bf\u00bdd": [["DEU", 762]], "m6hd": [["FRA", 587], ["CHE", 2256]], "eurosportnews": [["DNK", 442], ["INT", 2693]], "n24hd": [["INT", 2768]], "juwelopur": [["DEU", 809]], "rtl2ch": [["DEU", 845]], "animax": [["INT", 2659]], "sip": [["SVN", 2013]], "canalsat_caledonie": [["FRA", 525]], "babyfirst": [["SVN", 1834], ["TUR", 2559]], "etb1": [["ESP", 2114]], "etb3": [["ESP", 2116]], "polsatjimjam": [["POL", 1453]], "sic": [["PRT", 1488]], "mgmchannel": [["INT", 2702]], "euro6tv": [["DEU", 783], ["CHE", 2219]], "tv73": [["NLD", 1307]], "samanyolutvavrupa": [["CHE", 2226]], "animal": [["SVN", 1811]], "rfoberbayern": [["DEU", 841]], "nicktoons(s)": [["AUT", 68]], "1rock": [["RUS", 1603]], "bebegimtv": [["TUR", 2561]], "aonetv": [["RUS", 1608]], "prosiebenhdaustria": [["AUT", 74]], "ta3": [["SVK", 1784]], "universalhd": [["POL", 1462]], "collection": [["AUT", 45]], "canalsat_espace_client": [["FRA", 530]], "13thstreet": [["INT", 2656]], "bug\u00fcn": [["TUR", 2629]], "mdrs-anahalt": [["DEU", 912]], "absat": [["FRA", 495]], "teledonosti": [["ESP", 2152]], "orfeins": [["CHE", 2375]], "foxsports3hdere.": [["NLD", 1283]], "hic": [["HRV", 306]], "encyclopedia": [["FRA", 550]], "disneychannel(d)": [["NLD", 1122]], "ngwild": [["SVN", 1902], ["SVN", 1998]], "tntserie": [["DEU", 881], ["CHE", 2239]], "escalestv": [["SVN", 1856]], "zoneclub": [["BEL", 159], ["INT", 2759]], "historyhd": [["NLD", 1220], ["SVN", 1983], ["INT", 2749]], "192tv": [["NLD", 1273]], "animalhd": [["SVN", 1830], ["SVN", 1971]], "cartoon_network": [["DNK", 460]], "lustpur": [["DEU", 819]], "babyfirsttv": [["FRA", 502], ["SVN", 1834], ["TUR", 2559]], "polotv": [["POL", 1351]], "dorcel": [["SVN", 1851], ["SVN", 1963]], "mutv": [["GBR", 2439]], "hdfox": [["SVN", 1980]], "hdfashion": [["SVN", 1865]], "hdespn": [["SVN", 1976]], "rtsunhd": [["CHE", 2244]], "etb2": [["ESP", 2115]], "galaxy": [["RUS", 1630]], "sport1plus": [["INT", 2778]], "sport1nlselecthd": [["NLD", 1278]], "orangesportinfo": [["FRA", 621]], "dunatv": [["HUN", 944], ["SVN", 1853]], "poptvhd": [["SVN", 2044]], "golfklubhd": [["SVN", 2026], ["SVN", 2026]], "srfzwei": [["CHE", 2378]], "tvklasik": [["SVN", 1993]], "eratv": [["MKD", 1089]], "tv-theekflash!": [["BEL", 174]], "osjeckatv": [["HRV", 335]], "jukebox": [["DEU", 808]], "daf": [["AUT", 46]], "canalplushorizons": [["FRA", 522]], "spektrum": [["CZE", 415], ["HUN", 969]], "tvalbacete": [["ESP", 2163]], "amazinglife": [["RUS", 1611]], "austria9": [["AUT", 4]], "bbcnews": [["GBR", 2392]], "avseeklo": [["BEL", 193]], "nrjhits": [["FRA", 609]], "vierhd": [["BEL", 171]], "donau_tv": [["DEU", 774]], "rbbtv": [["DEU", 750]], "ndrfsnds": [["DEU", 826]], "film1sundance": [["NLD", 1249]], "direct8": [["FRA", 547]], "orlando_kids": [["MKD", 1081]], "sportklubgolf": [["SVN", 2026]], "olaytv": [["TUR", 2596]], "arddaserste": [["DEU", 739]], "nickjr.": [["NLD", 1156]], "canal54gasteiz": [["ESP", 2098]], "tvidea": [["SVN", 1816]], "ntvavrupa": [["CHE", 2317]], "l1": [["NLD", 1140]], "s4ctwo": [["GBR", 2461]], "nationalgeographicchannels": [["INT", 2716]], "canal+hd": [["FRA", 517]], "rtbfhd1": [["BEL", 184]], "boomcomedy": [["ROU", 1510]], "mediaspartv2": [["DEU", 916]], "eskatv": [["POL", 1336]], "canaleitalia": [["ITA", 989]], "studiob": [["SRB", 1779]], "vorschau": [["CHE", 2275]], "aljazeerabalkans": [["SVN", 1953]], "tvn24hd": [["POL", 1426]], "zinfo": [["FRA", 488]], "rtbfsat": [["BEL", 148]], "lt1": [["AUT", 12]], "kinoklassika": [["RUS", 1666]], "la7d": [["ITA", 1006]], "telestartv": [["BGR", 273], ["ROU", 1562]], "ren": [["RUS", 1755]], "smartdizimax": [["TUR", 2611]], "vaughan": [["ESP", 2202]], "raidue": [["ITA", 1020]], "afontovo": [["RUS", 1609]], "liveshop": [["NLD", 1141]], "magyaratv": [["HUN", 956]], "nickelodeonhd": [["SVN", 1987], ["INT", 2789]], "bjktv": [["TUR", 2563], ["TUR", 2648]], "tvxxi": [["LVA", 1058]], "zootv": [["RUS", 1751]], "tvi24": [["PRT", 1494]], "diva": [["LVA", 1034]], "mynele": [["ROU", 1540]], "itv3+1": [["GBR", 2432]], "sport1live": [["NLD", 1230]], "passiexxx(xotix)": [["NLD", 1264]], "markiza": [["CZE", 410], ["SVK", 1785]], "hetgesprek": [["NLD", 1139]], "sky2": [["GBR", 2464]], "ltv": [["NLD", 1305]], "france24": [["FRA", 560], ["SVN", 1871]], "volksmusik": [["AUT", 108]], "viasatsportbaltic": [["EST", 480], ["LTU", 1061]], "gtrkomsk": [["RUS", 1640]], "jmldirectshop": [["DEU", 807]], "csfilm": [["CZE", 361]], "kzoom": [["BEL", 157]], "animalplanet/tlc": [["NLD", 1250]], "srfernsehen": [["DEU", 901]], "sky3dtv": [["GBR", 2466]], "bravahdtv": [["NLD", 1106]], "mtvbase": [["FRA", 599], ["INT", 2704]], "hdtravel": [["SVN", 1933]], "zonereality": [["INT", 2736]], "phoenixtv": [["SVN", 2002]], "maxxitv": [["UKR", 2514]], "npremium2": [["POL", 1345]], "npremium3": [["POL", 1346]], "rtpazores": [["PRT", 1482]], "cinaps": [["FRA", 683]], "animalplanet": [["DNK", 425], ["NLD", 1209], ["SVN", 1811], ["CHE", 2348], ["INT", 2657]], "slo3": [["SVN", 2060]], "rheinmaintv": [["DEU", 842]], "clermont_1ere": [["FRA", 545]], "vaughanradio": [["ESP", 2202]], "citizen_tv": [["FRA", 544]], "atlastv": [["CZE", 347], ["MNE", 1101]], "be1": [["BEL", 119]], "tvpinfokielce": [["POL", 1414]], "einsfestivalhd": [["AUT", 38], ["DEU", 744]], "\u0431\u0442\u0431": [["UKR", 2526]], "euronews...": [["INT", 2688]], "\u0456\u043d\u0442\u0435\u0440": [["UKR", 2532]], "nitro": [["ESP", 2187]], "canalbizkaia": [["ESP", 2101]], "bbcfour": [["CHE", 2290], ["GBR", 2387]], "musicboxtv": [["CZE", 412], ["RUS", 1687]], "htrtv": [["NLD", 1304]], "travelchannelhd": [["INT", 2754]], "skynewsint": [["AUT", 97]], "ben": [["GBR", 2400]], "rtlnitro": [["CHE", 2289]], "innsattv": [["AUT", 9]], "tv8lietuva": [["LTU", 1072]], "\u043c\u0435\u0433\u0430\u0441\u043f\u043e\u0440\u0442": [["UKR", 2515]], "cbeebies": [["GBR", 2388]], "canal4zamora": [["ESP", 2085]], "pohoda_tv": [["CZE", 423]], "sicinternacional": [["PRT", 1488]], "skyselect": [["DEU", 866]], "foxlifehd": [["INT", 2805]], "rtlnitrohd": [["CHE", 2365]], "4fun.tv": [["POL", 1402]], "carlitv": [["SVN", 1813]], "rtsmaribor": [["SVN", 1924]], "travelchannel": [["LVA", 1055], ["ROU", 1598], ["SVN", 1932], ["SVN", 1932], ["GBR", 2484], ["INT", 2753]], "ntvpluskinosoyuz": [["RUS", 1696]], "\u0443\u043a\u0440\u0430\u0457\u043d\u0430": [["UKR", 2522], ["UKR", 2546], ["UKR", 2546]], "tveint.": [["CHE", 2323]], "ardeinsfestival": [["DEU", 743]], "tvmaribor": [["SVN", 2057]], "jetixplay": [["BGR", 251], ["CZE", 377]], "ledeuxhd": [["BEL", 185]], "fentv": [["BGR", 241]], "cuatro": [["ESP", 2112], ["ESP", 2196]], "fishun": [["SVN", 1866]], "mir": [["RUS", 1681]], "peretz": [["RUS", 1752]], "ahbr": [["TUR", 2555]], "akilli.tv": [["TUR", 2556]], "deluxeloungehd": [["DEU", 769]], "haberturk": [["TUR", 2580]], "4storytv": [["HUN", 938]], "karusel": [["RUS", 1754]], "zinfos": [["FRA", 488]], "sfr": [["FRA", 630]], "tvt89": [["ROU", 1571]], "syfyuniversal": [["FRA", 634], ["NLD", 1232]], "tvoberfranken": [["AUT", 107]], "idnestv": [["CZE", 376]], "fdf": [["ESP", 2118]], "yaban": [["TUR", 2626]], "humortv/nostalgienet": [["NLD", 1172]], "trp1": [["DEU", 882]], "brftv": [["BEL", 125]], "hdhistory": [["SVN", 1983]], "valenciateve": [["ESP", 2182]], "landscapehd": [["FRA", 581]], "skysportinfo": [["DEU", 871]], "canal+familyhd": [["POL", 1468]], "\u0432\u0456\u043d\u0442\u0430\u0436": [["UKR", 2547]], "tvgalicia2": [["ESP", 2169]], "cmore": [["BEL", 126]], "mehtaptv": [["TUR", 2590]], "daringtv": [["SVN", 1943]], "orangecinemax": [["FRA", 618]], "trt-1hd": [["TUR", 2640]], "eurosport2hd": [["SVN", 1859], ["INT", 2691]], "skysport1": [["DEU", 867]], "skysport2": [["DEU", 868]], "ned1hd": [["NLD", 1205]], "novaplus": [["BGR", 259]], "e4": [["GBR", 2416]], "\u043a2": [["UKR", 2534]], "mtvdance": [["DEU", 821], ["INT", 2706]], "ngc": [["SVN", 1901], ["SVN", 1999]], "canalplusessentiel": [["FRA", 515]], "tntfilm": [["DEU", 880]], "bfmbusiness": [["FRA", 720]], "jimjampolsat": [["POL", 1390]], "gtrkgroznyi": [["RUS", 1636]], "2be": [["BEL", 204]], "discoverytravel": [["INT", 2741]], "pulstv": [["POL", 1407]], "\u043f\u044f\u0442\u0438\u0439\u043a\u0430\u043d\u0430\u043b": [["UKR", 2525]], "ermaktv": [["RUS", 1626]], "kanal7": [["TUR", 2581]], "thevault": [["GBR", 2479]], "tsr1": [["CHE", 2250]], "aragon_tv": [["ESP", 2069]], "tsr2": [["CHE", 2249]], "telebocal": [["FRA", 687]], "npremium4": [["POL", 1347]], "bbcfour/cbeebies": [["CHE", 2290]], "hdtv1cz": [["CZE", 375]], "srfzweihd": [["CHE", 2355]], "sport1select": [["NLD", 1271]], "canal+family": [["FRA", 516], ["POL", 1467]], "cinemaxhd": [["POL", 1459], ["SVN", 1973]], "bibeltvhd": [["AUT", 41]], "canalcordoba": [["ESP", 2102]], "davinciuniversitas": [["SVN", 1845]], "infotv": [["SVN", 1817], ["SVN", 1887]], "vier": [["BEL", 171]], "tvpinfowroclaw": [["POL", 1423]], "voxhd": [["DEU", 891], ["INT", 2761]], "qtv": [["UKR", 2517]], "lifetv": [["BEL", 129], ["EST", 478]], "btv": [["BGR", 230], ["CZE", 404]], "flashtv": [["TUR", 2576]], "avsgent": [["BEL", 193]], "anixehd": [["INT", 2660]], "more4plus1": [["GBR", 2438]], "mnogotv": [["RUS", 1683]], "orbyttv": [["ESP", 2204]], "dmsat": [["SVN", 1850]], "schweizersportfernsehen": [["CHE", 2228]], "worldmusicchannel": [["RUS", 1746]], "itv2+1": [["GBR", 2430]], "worlddiscovery": [["SVN", 1846]], "ulke": [["TUR", 2624]], "\u043e\u0434\u0438\u043d+\u043e\u0434\u0438\u043d": [["UKR", 2523]], "vtmkzoom": [["BEL", 157]], "canalsat_caraibes": [["FRA", 526]], "ondamezquita": [["ESP", 2132]], "fashionhd": [["INT", 2745]], "natgeomusic": [["INT", 2715]], "latiendaencasa": [["ESP", 2205]], "rtsdeux": [["CHE", 2249]], "dusk!(xotix)": [["NLD", 1263]], "metropol": [["CZE", 418]], "cmusictvplus": [["FRA", 509]], "zdfneo": [["DEU", 893]], "viasattv3plus": [["DNK", 452], ["EST", 483]], "f1digital+": [["GBR", 2417]], "joi": [["ITA", 1001]], "joj": [["CZE", 408]], "trt1": [["TUR", 2645]], "btvlady": [["BGR", 283], ["BGR", 294]], "sport1extra1": [["NLD", 1225]], "ct4hd": [["CZE", 358]], "sport1extra2": [["NLD", 1226]], "etv": [["BGR", 239], ["EST", 475], ["SVN", 1858], ["SVN", 1858]], "tlt": [["FRA", 647]], "swrbrhd": [["CHE", 2284]], "tlc": [["BGR", 299], ["MKD", 1076], ["SVN", 1847], ["SVN", 2017]], "tlb": [["BEL", 200]], "omroepbrabant": [["NLD", 1173]], "\u0434\u0432\u0430\u043f\u043b\u044e\u0441\u0434\u0432\u0430": [["UKR", 2501], ["UKR", 2524]], "btvaction": [["BGR", 292]], "super7": [["BGR", 298]], "sachsen": [["DEU", 852]], "skysportaustria": [["DEU", 869]], "l\u2019equipe21": [["FRA", 718]], "ardbr": [["DEU", 738]], "tv5mondeasie": [["FRA", 655]], "\u043a\u0456\u043d\u043e": [["UKR", 2511]], "ardeinsfestivalhd": [["DEU", 744]], "sevillatv": [["ESP", 2144]], "lokaleomroep": [["NLD", 1239]], "ucb": [["GBR", 2486]], "teles\u00fcdostschweiz": [["CHE", 2268]], "tvpsport": [["POL", 1379]], "primefezztival": [["BEL", 137]], "ct24": [["CZE", 359]], "einsextra": [["DEU", 742]], "bbc": [["GBR", 2496]], "skycinemahits": [["DEU", 858]], "rsila2hd": [["CHE", 2246]], "ntstelekanal": [["RUS", 1692]], "ssf-t": [["CHE", 2228]], "filmplus2": [["HUN", 949]], "bbt": [["BGR", 227], ["BGR", 291]], "diema2": [["BGR", 236]], "zendervdmaand": [["NLD", 1240]], "karuseltv": [["RUS", 1754]], "oto": [["SVN", 2022]], "musicmix": [["HUN", 960]], "alphatvbucuresti": [["ROU", 1503]], "skysportsnews": [["GBR", 2477], ["GBR", 2478]], "nbatv": [["TUR", 2593]], "5\u043a\u0430\u043d\u0430\u043b": [["UKR", 2525]], "c9": [["ESP", 2089]], "tv3medias": [["SVN", 2020]], "disneyxd(tc)": [["CHE", 2350]], "spirit24": [["NLD", 1168]], "polsatbiznes": [["POL", 1440]], "more4+1": [["GBR", 2438]], "ots": [["RUS", 1713]], "cmusictv+": [["FRA", 509]], "hdsportklubhd": [["SVN", 2041], ["SVN", 2041]], "orfsport+": [["AUT", 70]], "yabantv": [["TUR", 2626]], "sundancehd": [["NLD", 1249]], "trtmuzik": [["TUR", 2639]], "film1hdpremiere": [["NLD", 1215]], "24sata": [["HRV", 317], ["SVN", 1950]], "tvprimorka": [["SVN", 2019]], "tvpinfoszczecin": [["POL", 1422]], "perviy1kanal": [["RUS", 1715]], "tvrcluj": [["ROU", 1564]], "prosiebenmaxxhd": [["AUT", 76]], "rbc": [["RUS", 1722]], "rbb": [["DEU", 750], ["DEU", 838]], "vijfhd": [["BEL", 172]], "fiestatv": [["BGR", 242]], "euronewsturkce": [["TUR", 2573]], "7d9b_sportacentrs_logo_istais": [["LVA", 1031]], "avs": [["BEL", 193]], "pirmaisbaltijaskanals": [["LVA", 1048]], "myzentv": [["FRA", 603], ["SVN", 1996]], "ducktv": [["SVK", 1795]], "lifenetwork": [["HUN", 955]], "avago": [["GBR", 2382]], "westtelevision": [["ROU", 1575]], "be92": [["SRB", 1765]], "vintage": [["UKR", 2547]], "zdf.kulturhd": [["DEU", 907]], "puntdos": [["ESP", 2136]], "discoveryhd": [["SVN", 1975], ["INT", 2675]], "noe": [["SVK", 1801]], "piwi": [["FRA", 624]], "fashionone": [["NLD", 1268]], "axatv": [["ROU", 1508]], "humortv24": [["NLD", 1165]], "experttv": [["RUS", 1628]], "fanda_tv": [["CZE", 421]], "tvcinehd": [["PRT", 1493]], "net_tv": [["SVN", 1819]], "nickhd/comedyhd": [["CHE", 2292]], "peretztv": [["RUS", 1752]], "digisport": [["HUN", 941], ["ROU", 1525], ["ROU", 1578]], "koper": [["SVN", 2052]], "canal+polynesie": [["FRA", 523]], "v8": [["NLD", 1237]], "fr2hd": [["FRA", 685]], "iftv": [["ROU", 1538]], "arenatv": [["SVN", 1956]], "iconcerts": [["LVA", 1037], ["SVN", 1886]], "hdcinemax": [["SVN", 1973]], "kanal2001": [["BGR", 254]], "bluemovie2": [["DEU", 759]], "bluemovie3": [["DEU", 760]], "film1festival": [["NLD", 1214]], "bluemovie1": [["DEU", 758]], "24\u043a\u0430\u043d\u0430\u043b\u043d\u043e\u0432\u0438\u043d": [["UKR", 2502]], "3kanalmoskovia": [["RUS", 1604]], "5+hd": [["CHE", 2358], ["CHE", 2358]], "kinoreys": [["RUS", 1670]], "kidsco": [["SVN", 1890], ["TUR", 2588]], "hirtv": [["HUN", 954]], "\u043e\u0434\u0438\u043d\u043f\u043b\u044e\u0441\u043e\u0434\u0438\u043d": [["UKR", 2523]], "ned3": [["NLD", 1152]], "ned2": [["NLD", 1151]], "ned1": [["NLD", 1150]], "hogar10": [["ESP", 2122]], "ermak": [["RUS", 1626]], "gulli": [["FRA", 565]], "tv10": [["NLD", 1196], ["TUR", 2651]], "kanal7int.": [["CHE", 2316]], "rambler": [["RUS", 1721]], "automotorsporthd": [["NLD", 1287]], "italia1": [["ITA", 998]], "nickelodeon": [["SVN", 2000], ["INT", 2721]], "brsudhd": [["AUT", 43]], "weo": [["FRA", 705]], "hd24kitchen": [["SVN", 1970]], "blucom": [["DEU", 757]], "k-2": [["ITA", 1002]], "z\u00fcriplus": [["CHE", 2253], ["CHE", 2253]], "itele": [["FRA", 686]], "domkino": [["LVA", 1035]], "rodina": [["BGR", 268]], "etv2": [["EST", 474]], "nat.geo.hd": [["NLD", 1148]], "6livetv": [["DEU", 735]], "tvnorgehd": [["NOR", 1329]], "canalsur2andalucia": [["ESP", 2107]], "stars.tv": [["POL", 1471]], "five": [["GBR", 2421]], "rmcdecouverte": [["FRA", 717]], "rtltelevision": [["DEU", 844]], "mediaspar.tv": [["AUT", 62]], "neptun": [["ROU", 1542]], "mmcturk": [["TUR", 2592]], "telecubelles": [["ESP", 2151]], "sportro": [["ROU", 1559]], "euforialifestyle": [["ROU", 1528]], "azerbaycantv": [["RUS", 1614]], "rtvutrecht": [["NLD", 1187]], "boomdrama": [["ROU", 1511]], "musicmedia": [["BGR", 258]], "bht1": [["BIH", 208]], "raimovie": [["ITA", 1023]], "canal6navarra": [["ESP", 2086]], "hitradiooe3": [["AUT", 69]], "canal+family2hd": [["POL", 1469]], "planete+": [["FRA", 707]], "belgacom11": [["BEL", 124]], "rentvbaltic": [["EST", 479], ["LTU", 1068]], "euforia": [["ROU", 1528]], "kabeleinsaustria": [["AUT", 55]], "numero23": [["FRA", 716]], "studio100tv": [["BEL", 176]], "rtbf3": [["BEL", 146]], "rtbf2": [["BEL", 145]], "rtbf1": [["BEL", 147]], "goierritelebista": [["ESP", 2121]], "turinfotv": [["RUS", 1743]], "primesport": [["BEL", 141]], "tvonil": [["ESP", 2171]], "zdftheater": [["DEU", 877]], "channel4od": [["GBR", 2407]], "112": [["UKR", 2550]], "24kitchen": [["NLD", 1242], ["SVN", 1949]], "deluxemusic": [["DEU", 770]], "mgm": [["INT", 2702]], "syfy": [["LVA", 1054]], "srfinfo": [["CHE", 2353], ["CHE", 2357]], "pinkmovies": [["SVN", 2006]], "tmc": [["FRA", 678]], "passion": [["CHE", 2295]], "utilisima": [["BGR", 289]], "zdfinfohd": [["DEU", 913]], "ntvspor": [["TUR", 2595]], "sat.1a": [["AUT", 88]], "skynostalgie": [["DEU", 865]], "swrfernsehenrp": [["DEU", 876]], "viasatexplorer": [["BGR", 286], ["HRV", 318], ["CZE", 420], ["SVN", 1862]], "televalencia": [["ESP", 2154]], "moyaplaneta": [["RUS", 1684]], "zappelin": [["NLD", 1321]], "trt1hd": [["TUR", 2640]], "pro7ch": [["CHE", 2269], ["INT", 2771]], "kinohit": [["RUS", 1665]], "iris": [["ITA", 997]], "tvpuls": [["POL", 1475]], "classcnbc": [["ITA", 992]], "t\u00e9l\u00e9grenoble": [["FRA", 636]], "imedia": [["FRA", 568]], "2+2": [["UKR", 2501]], "zaragozatv": [["ESP", 2184]], "dajto": [["SVK", 1797]], "rtk1kosovo": [["SRB", 1773]], "mvhsoft/dusk!": [["NLD", 1294]], "ndr": [["DEU", 748]], "mirbelogorya": [["RUS", 1680]], "playtv": [["SVN", 1913]], "canalcanarias": [["ESP", 2110]], "tvpinforzeszow": [["POL", 1421]], "zakontv": [["RUS", 1747]], "cetv": [["SVK", 1803]], "telenovelas": [["CHE", 2326]], "disneyxd24": [["NLD", 1123]], "mediasetplus": [["ITA", 1010]], "eurosport2hddut": [["NLD", 1129]], "be1hd": [["BEL", 119]], "familytv": [["DEU", 763]], "jojplushd": [["SVK", 1789]], "ktoestkto": [["RUS", 1675]], "berberetv": [["FRA", 728]], "kanalteleputeshestviya": [["RUS", 1661]], "n-tv": [["DEU", 828]], "espnclassic": [["DEU", 782], ["NLD", 1126], ["INT", 2686]], "politiek24/sport24": [["NLD", 1167]], "ulketv": [["TUR", 2624], ["TUR", 2624]], "zdfkultur": [["CHE", 2276]], "nick/cchd": [["DEU", 906]], "\u00fclketv": [["TUR", 2624]], "romancetv(tc)": [["CHE", 2347]], "canalsat_mosaique": [["FRA", 535]], "\u043d\u0442\u043d": [["UKR", 2540]], "hr": [["DEU", 746]], "premiumcalcio": [["ITA", 1011]], "mtvpolska": [["POL", 1441]], "\u043a1": [["UKR", 2533]], "\u043c\u0434\u0432\u0430": [["UKR", 2513]], "tsi1": [["CHE", 2245]], "tsi2": [["CHE", 2248]], "ondaluz": [["ESP", 2133]], "atmrozrywka": [["POL", 1427]], "ngctv": [["SVN", 1999]], "record": [["PRT", 1477]], "stories": [["BEL", 179]], "\u0441\u043e\u043d\u0446\u0435": [["UKR", 2552]], "canalsat_interactif": [["FRA", 534]], "canalplusreunion": [["FRA", 524]], "febiotv": [["CZE", 367]], "zazarotv": [["NLD", 1204]], "filmboxfamily": [["BGR", 246], ["HRV", 305], ["CZE", 371], ["HUN", 952], ["POL", 1384], ["ROU", 1534]], "hightv3d": [["INT", 2799]], "gameonemusichd": [["FRA", 563]], "universal": [["LVA", 1059], ["SVN", 1875], ["INT", 2733]], "libelle": [["BEL", 203]], "orangecinehappy": [["FRA", 617]], "einsplus": [["DEU", 745]], "la1hd": [["ESP", 2207]], "cartoonnetwork(06-20u)": [["NLD", 1111]], "atmrozrywkatv": [["POL", 1409]], "adriamtv": [["SVN", 1997]], "3sathd": [["DEU", 894]], "derschmuckkanal": [["DEU", 771]], "cmusictv": [["SVN", 1842], ["SVN", 1960], ["INT", 2737]], "zoopark": [["RUS", 1750]], "natgeowildhd": [["POL", 1349]], "film1comedy&kids(23)": [["NLD", 1310]], "espntv": [["SVN", 1857]], "tvcrnegore": [["MNE", 1100]], "foxsports": [["INT", 2746]], "brfsnorth": [["DEU", 762]], "24kitchenhd": [["NLD", 1242], ["SVN", 1970]], "rtvslo3": [["SVN", 2060]], "rtvslo2": [["SVN", 2059]], "sick": [["PRT", 1489]], "ntvpluskinoklub": [["RUS", 1697]], "bluehustler": [["RUS", 1619], ["CHE", 2266]], "star": [["CHE", 2229], ["TUR", 2614]], "televigo": [["ESP", 2160]], "foodhd": [["SVN", 1868]], "june": [["FRA", 575]], "beate-uhse.tv": [["DEU", 753]], "ehs.tv": [["ESP", 2206]], "skyxmas": [["AUT", 94]], "nationalgeographichd": [["INT", 2717]], "meidenvanholland": [["NLD", 1294]], "stvjednotka": [["CZE", 417]], "ndrhd": [["CHE", 2282]], "novasporthd": [["CZE", 384]], "move_x": [["BEL", 132]], "canal+essentiel": [["FRA", 515]], "dave": [["GBR", 2494]], "skysportnews": [["AUT", 96]], "kindernet": [["NLD", 1221]], "tvp1hd": [["POL", 1405]], "kanal2": [["EST", 476]], "ndrfsmvp": [["DEU", 826]], "axncrime": [["INT", 2664]], "passie/dusk!": [["NLD", 1223]], "tvpinfowarszawa": [["POL", 1425]], "film1premiere": [["NLD", 1248]]};
