var DataObj = function() {
    var debug_log = false;
    
    var gObjList = null;
    var DataId = [];
    
    var gMtvutilities = new MtvUtilities();
    
    var ItemData = {
        ShowItemsNum : 9,
        TotalItems : 0,
        ShowIndexItem : 1,       /* 1~ (ShowItemsNum-1)*/
        IndexItem : 1,           /* 1~ (TotalItems)*/
        OffsetItem: 0
    };
    
    var HTMLList = "";
    var DashBoardType = 2;    /* 0: No, 1: InputSource, 2: Utilities*/
    
    var getDashBoardType = function() {
        return DashBoardType;
    }
    
    var Init = function() {
        ShowItemUI();
    }
    
    function ShowItemUI(){
        if (debug_log == true) {
            console.log("ShowItemUI");
        }
        gObjList = gMtvutilities.getList();
        
        $.each(gObjList, function (key, v) {
            ItemData.TotalItems++;
            if (v.active == true) {
                ItemData.ShowIndexItem = ItemData.TotalItems;
                ItemData.IndexItem = ItemData.TotalItems;
            }
            HTMLList += "<div id='"+v.id+"' class='item'>";
            HTMLList += "<div class='items_icon_board'>";
            HTMLList += "<img class='items_icon items_icon_gray' src='"+v.icon+"'>";
            HTMLList += "</div>";
            HTMLList += "<div class='items_title'>"+v.name+"</div>";
            HTMLList += "</div>";
            DataId[ItemData.TotalItems]=v.id;
        });
    }

    var ShowColorBar = function(indexItem) {
        if (debug_log == true) {
            console.log("ShowColorBar");
        }
        switch (DashBoardType) {
            case 2:
                break;
            case 1:
                var activeItem = findInputObj({id:DataId[indexItem]});
                if (activeItem.isEditable) {
                    $("#color_list_bar").show();
                } else {
                    $("#color_list_bar").hide();
                }
                break;
            case 0:
            default:
                $("#color_list_bar").hide();
                break;
        }
    }
    
    var GetHTMLList = function() {
        if (debug_log == true) {
            console.log("GetHTMLList");
        }
        return HTMLList;
    }
    var GetItemData = function() {
        if (debug_log == true) {
            console.log("GetItemData");
        }
        return ItemData;
    }
    var GetDataID = function() {
        if (debug_log == true) {
            console.log("GetDataID");
        }
        return DataId;
    }
    var FindItemObj = function(arg) {
        return $.grep(gObjList , function (v) {return (!arg.id || arg.id == v.id);})[0];
    }

    var ExecuteRed = function() {
        if (debug_log == true) {
            console.log("ExecuteRed");
        }
    }

    var ExecuteGreen = function(indexItem, scrollBar) {
        if (debug_log == true) {
            console.log("ExecuteGreen");
        }
    }
    
    var ExecuteEnter = function(indexItem) {
        if (debug_log == true) {
            console.log("ExecuteEnter");
        }
        switch (DashBoardType) {
            case 2:
                return utilities_enter(indexItem);
                break;
            case 0:
            default:
                return false;
                break;
        }
    }
    
    var utilities_enter = function(indexItem) {
        if (debug_log == true) {
            console.log("utilities_enter");
        }
        var cur_ipt_id = DataId[indexItem];
        
        /* MichaelWang 20170116 Check for any WFD session existing, if yes, disconnect it */
        if (localStorage.lastwfd) {
            wfdmtvObj = new MtvObj();
            var srcmac = localStorage.getItem("lastwfd");
            if ((srcmac != "") && (srcmac != "undefined")) {
                console.log("[Miracast] Prepare to disconnect WFD mac="+srcmac);
                var arg = {"PARAMETER": {"disconnect":"g_wfd__disconnect","VALUE":srcmac,"REQUEST":"MODIFY"}};
                wfdmtvObj.setWfdAction(JSON.stringify(arg));
                arg = {"PARAMETER": {"app_leave":"g_wfd__app_leave","REQUEST":"ACTION"}};
                wfdmtvObj.setWfdAction(JSON.stringify(arg));
                localStorage.setItem("lastwfd", "");
            }
        }
        
        gMtvutilities.procItem(cur_ipt_id);
    }
    
    var GetGreenKeyStatus = function() {
        if (debug_log == true) {
            console.log("GetGreenKeyStatus");
        }
        
        return 0;
    }
	
	var GetRedScanStatus = function() {
        if (debug_log == true) {
            console.log("GetRedScanStatus");
        }
        return 0;
    }
    
    var SetEditHoverIcon = function() {
        if (debug_log == true) {
            console.log("SetEditHoverIcon");
        }
    }
    
    var ShowEditSetupIcon = function() {
        if (debug_log == true) {
            console.log("ShowEditSetupIcon");
        }
    }
	
	var SetScanIcon = function(indexItem, scrollBar) {
		if (debug_log == true) {
            console.log("SetScanIcon");
        }
	}
    
    return {
        GetHTMLList:GetHTMLList,
        GetItemData:GetItemData,
        ShowColorBar:ShowColorBar,
        GetDataID:GetDataID,
        FindItemObj:FindItemObj,
        ExecuteGreen:ExecuteGreen,
        ShowEditSetupIcon:ShowEditSetupIcon,
        ExecuteRed:ExecuteRed,
        ExecuteEnter:ExecuteEnter,
        SetEditHoverIcon:SetEditHoverIcon,
        GetGreenKeyStatus:GetGreenKeyStatus,
		GetRedScanStatus:GetRedScanStatus,
		SetScanIcon:SetScanIcon,
        Init:Init,
    }
}