var DataObj = function() {
    var debug_log = false;

    if (typeof(Storage) !== "undefined") {
        if (!localStorage.lastwfd) {
            localStorage.setItem("lastwfd", "");
            console.log("localStorage.lastwfd init as "+localStorage.getItem("lastwfd"));
        }
    }
    else {
        console.log("[miracast_monitor] Browser doesn't support localStorage...");
    }

    var g_inputSrcObj = null;
    var gObjList = null;
    var gObjListOrig = null;
    var DataId = [];

    var ItemData = {
        ShowItemsNum : 9,
        TotalItems : 0,
        ShowIndexItem : 1,       /* 1~ (ShowItemsNum-1)*/
        IndexItem : 1,           /* 1~ (TotalItems)*/
        OffsetItem: 0
    };

    var HTMLList = "";
    var DashBoardType = 1;    /* 0: No, 1: InputSource*/

    var execute_green_enable = 0;
    var execute_scan_enable = 0;

    var getDashBoardType = function() {
        return DashBoardType;
    }

    var Init = function() {
        ShowItemUI();
    }

    function checkElementNameValue(objElement, ename) {
        if (objElement.name == ename) {
            return true;
        } else {
            return false;
        }
    }

    function checkElementONameValue(objElement, eoname) {
        if (objElement.oName == eoname) {
            return true;
        } else {
            return false;
        }
    }

    function checkElementIDValue(objElement, eid) {
        if (objElement.id == eid) {
            return true;
        } else {
            return false;
        }
    }

    function ShowItemUI(){
        if (debug_log == true) {
            console.log("ShowItemUI");
        }
		if(!g_inputSrcObj)
		{
        	g_inputSrcObj = new InputSource();
		}
		gObjList = g_inputSrcObj.getInputList();

        if (Array.isArray(gObjList) == true) {

            var testidx = 0;

            /* MichaelWang 20161012: [WORKAROUND] Remove element "oName:SCART" from gObjList for 2017 platform 5802.
                                     Basically, this shoud be done by middleware and driver layer...
                                     */
            for (testidx = 0; testidx < gObjList.length; testidx++) {
                if (checkElementONameValue(gObjList[testidx], "SCART") == true) {
                    gObjList.splice(testidx, 1); /* Remove */

                    if (debug_log == true) {
                        console.log("SCART testidx = "+testidx);
                        console.log(gObjList);
                    }
                    break;
                }
            }
        }
// TF517PHIEUMTK05-1536 The source list function doesn't normal display DVD device name, when HDMI source easylink and easylink remote control set On then press RC source key.
             var devList = [];
             $.each(gObjList, function (k, v) {
                 if (v.oName && v.oName.indexOf('HDMI') == 0) {
                     devList.push($.extend({}, v, {cName:null, cIcon: null}));
                 }
             });
	     var cecList = ipsCECObj.updateDeviceList(devList);


        ItemData.TotalItems = 0; /* Reset */
        $.each(gObjList, function (key, v) {
            ItemData.TotalItems++;
            if (v.active == true) {
                ItemData.ShowIndexItem = ItemData.TotalItems;
                ItemData.IndexItem = ItemData.TotalItems;
            }
	    $.each(cecList, function (k, vv) {
  	    if(vv.id == v.id){
	    v.icon = vv.cIcon || vv.aIcon || vv.oIcon;
            }
            });
            HTMLList += "<div id='"+v.id+"' class='item'>";
            HTMLList += "<div class='items_icon_board'>";
            HTMLList += "<img class='items_icon items_icon_gray' src='"+v.icon+"'>";
            HTMLList += "</div>";


            if (v.isEditable != true) {
                HTMLList += "<div class='items_title'><span>"+v.name+"</span></div>";
                HTMLList += "<div class='items_setting_board' style='display:none;'>";
                HTMLList += "<img class='items_setting_icon' src='../2K16_4K_UX_Asset/Icons/icon_7_Settings_Setup_d_24x24_px.png'></img>";
            } else {
                /*
                HTMLList += "<div class='items_detected_device'>"+v.name+"</div>";
                HTMLList += "<div class='items_detected_title'>"+v.name+"</div>";
                */

                // TF517PHIEUMTK05-1536 The source list function doesn't normal display DVD device name, when HDMI source easylink and easylink remote control set On then press RC source key.
  	            $.each(cecList, function (k, vv) {
  	            		if(vv.id == v.id){
                		 v.name = vv.cName || vv.aName || vv.oName;
                		}
            		 });

                HTMLList += "<div class='items_title'><span>"+v.name+"</span></div>";
                HTMLList += "<div class='items_setting_board' style='display:none;'>";
                HTMLList += "<img class='items_setting_icon' src='../2K16_4K_UX_Asset/Icons/icon_7_Settings_Setup_d_24x24_px.png'></img>";
            }

            /*HTMLList += "<div class='items_setting_icon'></div>";*/
            HTMLList += "</div>";
            HTMLList += "</div>";
            DataId[ItemData.TotalItems]=v.id;
        });
    }

    var ShowColorBar = function(indexItem) {
        if (debug_log == true) {
            console.log("ShowColorBar");
        }
        execute_green_enable = 0;
        /*execute_scan_enable = 0;*/

        switch (DashBoardType) {
            case 1:
	        /* Clean up */
            $(".items_setting_board").css("background-image", "url('')");
            $(".items_setting_board").css("display", "none");

            var activeItem = FindItemObj({id:DataId[indexItem]});
            if (activeItem.isEditable) {
                $("#color_list_bar").css("display", "block");
                execute_green_enable = 1;
            } else {
                $("#color_list_bar").css("display", "none");
                execute_green_enable = 0;
            }
            break;
            case 0:
            default:
	        console.log("ShowColorBar case 0 or unknown case");
            $("#color_list_bar").css("display", "none");
            execute_green_enable = 0;
            break;
        }
    }

    var GetHTMLList = function() {
        if (debug_log == true) {
            console.log("GetHTMLList");
        }
        return HTMLList;
    }
    var GetItemData = function() {
        if (debug_log == true) {
            console.log("GetItemData");
        }
        return ItemData;
    }
    var GetDataID = function() {
        if (debug_log == true) {
            console.log("GetDataID");
        }
        return DataId;
    }
    var FindItemObj = function(arg) {
        return $.grep(gObjList , function (v) {return (!arg.id || arg.id == v.id);})[0];
    }

    function updateDeviceCard(opts) {
        if (debug_log == true) {
            console.log("updateDeviceCard");
        }
        var card = $(".card.mtvui[data-id="+opts.id+"]");
        if (opts.name == "BLU_RAY" || opts.name == "DVD" || opts.name == "HDD_DVDR" || opts.name == "RECORDER"
        || opts.name == "VCR" || opts.name == "PC" || opts.name == "GAME" || opts.name == "DIG_STB"){
            card.find(".card-content>span").text(g_mtvObj.getLangString(opts.name));
        } else {
            card.find(".card-content>span").text(opts.name);
        }
        card.find(".card-image>img").attr("src", opts.icon);
    }

    // Green Key go to the Device Editor Page on Input Source Main UI page.
    function updateDeviceAliasInfo(opts) {
        updateDeviceCard(opts);
        // Storage input source alias
        var arg = {"id":opts.id, "name": opts.name, "icon": opts.icon};
        g_inputSrcObj.setAlias(arg);
        // update the name/icon
        var obj = FindItemObj({"id":opts.id});
        if (obj) {
            obj.name = obj["aName"] = opts.name;
            obj.icon = obj["aIcon"] = opts.icon;
        }
    }

    function updateDeviceCecInfo(opts) {
        // update the name/icon
        updateDeviceCard(opts);
        var obj = FindItemObj({"id":opts.id});
        if (obj) {
            obj.name = obj["cName"] = opts.name;
            obj.icon = obj["cIcon"] = opts.icon;
        }
    }

    var GetRedScanStatus = function() {
        if (debug_log == true) {
            console.log("GetRedScanStatus");
        }
        return execute_scan_enable;
    }

    var SetScanHoverIcon = function(setenable) {
        if (debug_log == true) {
            console.log("SetScanHoverIcon enable="+setenable);
        }

        if (setenable == 1) {
            /*$(".title_icon_board").css("background-image", "url('../2K16_4K_UX_Asset/dashboard/topmenubar_app_icon_circle_highlighted.png')");*/
            $(".title_icon").css("background-image", "url('../2K16_4K_UX_Asset/Icons/icon_11_Sync_Internet_Browser_Refresh_hl_24x24_px.png')");
        } else {
        $(".title_icon_board").css("background-image", "url('')");
            $(".title_icon").css("background-image", "url('../2K16_4K_UX_Asset/Icons/icon_11_Sync_Internet_Browser_Refresh_d_24x24_px.png')");
        }
    }

    var SetScanIcon = function(indexItem, scrollBar) {
        if (debug_log == true) {
            console.log("SetScanIcon");
        }

        if (execute_scan_enable == 0) {
            execute_scan_enable = 1;
            SetScanHoverIcon(execute_scan_enable); /* Set highlight */
        } else {
            execute_scan_enable = 0;
            SetScanHoverIcon(execute_scan_enable); /* Un-Set highlight */
        }
    }

    var GetGreenKeyStatus = function() {
        if (debug_log == true) {
            console.log("GetGreenKeyStatus: "+execute_green_enable);
        }
        return execute_green_enable;
    }

    var SetEditHoverIcon = function(indexItem, scrollBar) {
        var objItem = scrollBar.find("#"+DataId[indexItem]+" div.items_setting_board");
         $(objItem).css("background-image", "url('../2K16_4K_UX_Asset/dashboard/topmenubar_app_icon_circle_highlighted.png')");

        objItem = scrollBar.find("#"+DataId[indexItem]+" div.items_setting_board img");
        $(objItem).attr("src", "../2K16_4K_UX_Asset/Icons/icon_7_Settings_Setup_hl_24x24_px.png");
    }

    var ShowEditSetupIcon = function(indexItem, scrollBar) {
        if (debug_log == true) {
            console.log("ShowEditSetupIcon");
        }
        if (execute_green_enable == 0) {
            execute_green_enable = 1;
            SetEditHoverIcon(indexItem, scrollBar);
        } else {
            execute_green_enable = 0;
        }
    }


    var ExecuteGreen = function(indexItem) {
        if (debug_log == true) {
            console.log("ExecuteGreen");
        }
        //var obj = FindItemObj({id:DataId[indexItem]});
		var obj = FindItemObj({id:indexItem});

        var args = $.extend({}, obj, {
            getDeviceList: g_inputSrcObj.getAliasMap,
            finish: function (evt, opts) { // Apply Changes
                updateDeviceAliasInfo(opts);
                setTimeout(function(){
                    refreshUI();
                    //var devList = freshList.filter(function(v) {
                    var devList = gObjList.filter(function(v) {
                        return (v.oName && v.oName.indexOf('HDMI') == 0);
                    });
                    devList = ipsCECObj.updateDeviceList(devList);
                    $.each(devList, function (k,v) {
                        v.name = v["cName"] || v["aName"] || v["oName"];
                        v.icon = v["cIcon"] || v["aIcon"] || v["oIcon"];
                        updateDeviceCecInfo(v);
                    });
                    ItemData.IndexItem = indexItem;
                    mtvuiUtil.makeMarquee($(".card-content"));
                    /* FIXME: Below code should be replaced by a better way... */
                    document.location.reload();
                    }, 110);
                }
        });
        mtvuiLoadScript("./deviceDialog.js", function () {
            $("#dialog_device_list").deviceDialog(args);
            $("#dialog_device_list").deviceDialog('open'); // make sure dialog focus
        });
    }

    var ExecuteEnter = function(indexItem) {
        if (debug_log == true) {
            console.log("ExecuteEnter");
        }
        switch (DashBoardType) {
            case 1:
                return input_source_enter(indexItem);
                break;
            case 0:
            default:
                return false;
                break;
        }
    }

    var input_source_enter = function(indexItem) {
        if (debug_log == true) {
            console.log("input_source_enter");
        }
         var cur_ipt_id = DataId[indexItem];

        if (g_inputSrcObj.checkTimeShift()) {
            return false;
        }

        if (mtvuiUtil.selectSource()){
            console.log("selectSource is TRUE, localStorage.lastwfd is: "+localStorage.getItem("lastwfd"));
            /* MichaelWang 20170116 Check for any WFD session existing, if yes, disconnect it */
            wfdmtvObj = new MtvObj();
            var srcmac = localStorage.getItem("lastwfd");
            if ((srcmac != "") && (srcmac != "undefined")) {
                console.log("[Input_source Miracast] Prepare to disconnect WFD mac="+srcmac);
                var arg = {"PARAMETER": {"disconnect":"g_wfd__disconnect","VALUE":srcmac,"REQUEST":"MODIFY"}};
                wfdmtvObj.setWfdAction(JSON.stringify(arg));
                arg = {"PARAMETER": {"app_leave":"g_wfd__app_leave","REQUEST":"ACTION"}};
                wfdmtvObj.setWfdAction(JSON.stringify(arg));
                localStorage.setItem("lastwfd", "");
            }

            setTimeout(function(){
                try {
                    g_inputSrcObj.setInputSource(cur_ipt_id);

                } catch(err) {
                    console.log("error for set input source id!");
                    console.log(err);
                }
                if (cur_ipt_id != InputSourceRaw.prototype.usbID && cur_ipt_id != InputSourceRaw.prototype.networkID) {
                    if (cur_ipt_id == InputSourceRaw.prototype.antennaID || cur_ipt_id == InputSourceRaw.prototype.cableID || cur_ipt_id == InputSourceRaw.prototype.satelliteID) {
                        $('#id_div_contain').hide(0, function () {
                            mtvuiUtil.gotoSysPage("sys_channel_zapper", true);
                        });
                    } else if (cur_ipt_id == InputSourceRaw.prototype.miracastID) {
                        $('#id_div_contain').hide(0, function () {
                            /*mtvuiUtil.gotoSysPage("sys_miracast", true);*/ /* Jacky JS modify for [TF517PHIEUMTK05-3873] 170116 */
                        });
                    } else {
                        $('#id_div_contain').hide(0, function () {
                            mtvuiUtil.gotoSysPage("sys_input_source_osd",true);/* rollback due to source list no work in MMP *//* we don't need to show osd by ourself, because html_agent will show after change source  */
                        });
                    }
                }
                return false;
            }, 200);
        } else {
            console.log("[Input_source Miracast]selectSource is FALSE, localStorage.lastwfd is: "+localStorage.getItem("lastwfd"));
            /* MichaelWang 20170116 Check for any WFD session existing, if yes, disconnect it */
            wfdmtvObj = new MtvObj();
            var srcmac = localStorage.getItem("lastwfd");
            if ((srcmac != "") && (srcmac != "undefined")) {
                console.log("[Input_source Miracast] Prepare to disconnect WFD mac="+srcmac);
                var arg = {"PARAMETER": {"disconnect":"g_wfd__disconnect","VALUE":srcmac,"REQUEST":"MODIFY"}};
                wfdmtvObj.setWfdAction(JSON.stringify(arg));
                arg = {"PARAMETER": {"app_leave":"g_wfd__app_leave","REQUEST":"ACTION"}};
                wfdmtvObj.setWfdAction(JSON.stringify(arg));
                localStorage.setItem("lastwfd", "");
            }

            try {
                g_inputSrcObj.setInputSource(cur_ipt_id);
            } catch(err) {
                console.log("error for set input source id!");
                console.log(err);
            }
            if (cur_ipt_id != InputSourceRaw.prototype.usbID && cur_ipt_id != InputSourceRaw.prototype.networkID) {
                if (cur_ipt_id == InputSourceRaw.prototype.antennaID || cur_ipt_id == InputSourceRaw.prototype.cableID || cur_ipt_id == InputSourceRaw.prototype.satelliteID) {
                    $('#id_div_contain').hide(0, function () {
                        mtvuiUtil.gotoSysPage("sys_channel_zapper", true);
                    });
                } else if (cur_ipt_id == InputSourceRaw.prototype.miracastID) {
                    $('#id_div_contain').hide(0, function () {
                        /*mtvuiUtil.gotoSysPage("sys_miracast", true);*/ /* Jacky JS modify for [TF517PHIEUMTK05-3873] 170116 */
			var appStatus = g_mtvObj.acfgGetConfigValue('g_misc__3rd_app_running_status');
			console.log(" miracastID  appstatus= "+ appStatus);
			if(appStatus == 1){
				g_mtvObj.pause3rdApp();
			}

                    });
                } else {
                    $('#id_div_contain').hide(0, function () {
                       // mtvuiUtil.gotoSysPage("sys_input_source_osd", true);
                    });
                }
            }
            return false;
        }
        return true;
    }

    return {
        GetHTMLList:GetHTMLList,
        GetItemData:GetItemData,
        ShowColorBar:ShowColorBar,
        GetDataID:GetDataID,
        FindItemObj:FindItemObj,
        ExecuteGreen:ExecuteGreen,
        ShowEditSetupIcon:ShowEditSetupIcon,
        ExecuteEnter:ExecuteEnter,
        SetEditHoverIcon:SetEditHoverIcon,
        GetGreenKeyStatus:GetGreenKeyStatus,
        GetRedScanStatus:GetRedScanStatus,
        SetScanIcon:SetScanIcon,
        SetScanHoverIcon:SetScanHoverIcon,
        Init:Init,
    }
}
