var g_fvp_handle;
function fvpGetHandle() {
    var arg = '{"PARAMETER":{"operator":"open","engine":0,"brdcst_medium":0,"type":2,"REQUEST":"QUERY"}}';
    var handleObj = g_mtvObj.epgfvpMtdtOperator(arg);
    //Object {handle: 0, condition: 0}
    if (!handleObj) {
        console.info("vindy fvp_handle handleObj is null");
        return null ;
    }
    if (handleObj.ITEMS[0].handle != 0) {
        console.info("vindy fvp_handle=" + handleObj.ITEMS[0].handle);
        return handleObj.ITEMS[0].handle;
    }
}
function fvpCloseHandle(handle) {
    var arg = '{"PARAMETER":{"operator":"close","handle":' + handle + ',"REQUEST":"QUERY"}}';
    var status = g_mtvObj.epgfvpMtdtOperator(arg);
    //fvp_evtList.ITEMS[0].main_title is event title
    console.log(status);
    if (status) {
        return status;
    } else
        return null ;
}
var g_recommend_categories_eTag = 0;
function fvpGetRecommendCategories(handle) {
    g_recommend_categories_eTag = getTagValue();
    var param = {
        "type": "ondemand"
    };
    var arg = {
        "PARAMETER": {
            "handle": handle,
            "etype": "recommend_categories",
            "recommend_categories": param,
            "REQUEST": "QUERY",
            "operator": "execute",
            "priority": 50,
            "etag": g_recommend_categories_eTag
        }
    };
    return g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
}
var g_recodel_eTag = 0;
function fvpGetRecommendDetails(handle, id, nid) {
	cancelFvpExecute(g_fvp_handle, FvpExecuteType.recomdDetails);
	cancelFvpExecute(g_fvp_handle, FvpExecuteType.playerAitx);
	cancelFvpExecute(g_fvp_handle, FvpExecuteType.icon);
    g_recodel_eTag = getTagValue();
    var param = {
        "type": "ondemand",
        "group_id": id,
        'nids': nid
    };
    var arg = {
        "PARAMETER": {
            "handle": handle,
            "etype": "recommend_details",
            "recommend_details": param,
            "REQUEST": "QUERY",
            "operator": "execute",
            "priority": 50,
            "etag": g_recodel_eTag
        }
    };
    return g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
}
var g_search_etag
function fvpGetSearchEvent(handle, keyStr, url) {
	cancelFvpExecute(g_fvp_handle, FvpExecuteType.recomdDetails);
	cancelFvpExecute(g_fvp_handle, FvpExecuteType.playerAitx);
	cancelFvpExecute(g_fvp_handle, FvpExecuteType.icon);
	cancelFvpExecute(g_fvp_handle, FvpExecuteType.search);
    g_search_etag = getTagValue();
    var param = {
        "type": "ondemand",
        "q": keyStr
    };
    if (url) {
        param.page_url = url;
    }
    var arg = {
        "PARAMETER": {
            "handle": handle,
            "etype": "search",
            "search": param,
            "REQUEST": "QUERY",
            "operator": "execute",
            "priority": 50,
            "etag": g_search_etag
        }
    };
    return g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
}
function fvpGetNetworkIds() {
    var ret = [];
    var param = {
        "operator": "get",
        "get_type": "nw_ids",
        "handle": g_fvp_handle,
        "REQUEST": "QUERY"
    };
    var arg = {
        "PARAMETER": param
    };
    var res = g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
    if (res) {
        var item = res.ITEMS;
        for (var i = 0; i < item.length; i++) {
            ret.push(item[i].VALUE);
        }
    }
    console.log("fvpGetNetworkIds ids = " + ret);
    return ret;
}
function getNetworkIdParam() {
    var ret = '';
    var param = {
        "operator": "get",
        "get_type": "nw_ids",
        "handle": g_fvp_handle,
        "REQUEST": "QUERY"
    };
    var arg = {
        "PARAMETER": param
    };
    var res = g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
    if (res) {
        var item = res.ITEMS;
        for (var i = 0; i < item.length; i++) {
            if (i == 0) {
                ret += 'nids[]=' + item[i].VALUE
            } else {
                ret += '&nids[]=' + item[i].VALUE
            }
        }
    }
    console.log("getNetworkIdParam ret = " + ret);
    return ret;
}
var g_carryServiceListCh ;
function getFvpServiceInfoByNid(ch, handle) {
    
    if(g_carryServiceListCh && g_carryServiceListCh.CHANNEL_ID == ch.CHANNEL_ID){
        return ;
    }
    var eTag = getTagValue();
    ch.serviceTag = eTag;
	//if(ch.NW_ID.length>1) if mw_id has much
    var param = {
        "nid": ch.NW_ID
    };
    var arg = {
        "PARAMETER": {
            "REQUEST": "QUERY",
            "operator": "execute",
            "handle": handle,
            "priority": 50,
            "etag": eTag,
            "etype": "service_info_by_nid",
            "service_info_by_nid": param
        }
    };
    g_carryServiceListCh = ch;
    return g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
}
function getFvpServiceInfoBySid(ch, handle) {
    var eTag = getTagValue();
    ch.serviceTag = eTag;
    var param = {
        "sid": ch.PROG_ID
    };
    var arg = {
        "PARAMETER": {
            "REQUEST": "QUERY",
            "operator": "execute",
            "handle": handle,
            "priority": 50,
            "etag": eTag,
            "etype": "service_info_signle",
            "service_info_by_sid": param
        }
    };
    return g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
}
/*
*retryFlag 2 query second slient
*retryFlag 1 query one slient
*retryFlag 0 query 
retryFlag -1 
*/
function getFvpEventInfoByChannel(ch, handle, startTime, duration, retryFlag) {
    var eTag = getTagValue();
    ch.pvTag = eTag;
    if (typeof duration == 'undefined')
        duration = 7200;
    var schedule = {
        "nid": ch.NW_ID,
        "sids": [ch.PROG_ID],
        "start_time": startTime,
        "end_time": (startTime + duration)
    };
    if (typeof retryFlag != 'undefined') {
        ch.retryFlag = retryFlag;
    } else {
        ch.retryCount = 0;
        ch.retryFlag = Math.ceil((startTime + 1) / (6 * 3600)) == Math.ceil((startTime + 7200) / (6 * 3600)) ? 1 : 0;
    }
    var arg = {
        "PARAMETER": {
            "REQUEST": "QUERY",
            "operator": "execute",
            "handle": handle,
            "priority": 50,
            "etag": eTag,
            "etype": "service_schedule",
            "schedule": schedule
        }
    };
    return g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
}
function fvpEventPlayerNotify(tag, xmlValue) {
    if (xmlValue) {
        var content = $('.eventcol[playerTag="' + tag + '"]');
        if (content.length > 0) {
            if (parsePlayerAit(xmlValue)) {
                $.each(content, function(i, item) {
                    item = $(item);
                    var row = item.parent().index();
                    var column = item.index();
                    var event = g_eventList[row][column];
                    if (event.onDemand == 2) {
                        event.onDemand = 1;
                        epgFvponDemandIconUpdate(item);
                    }
                })
            }
        }
    }
}
function parsePlayerAit(xmlValue) {
    var playerStatus = false;
    if (xmlValue) {
        $(xmlValue).find("mhp\\:Application").each(function(i, item) {
            item = $(item);
			if (item.find("mhp\\:OtherApp").text() == "application/vnd.hbbtv.xhtml+xml" 
				&&
				((parseInt(item.find("mhp\\:versionMajor").text()) < 1 )
				||
				((parseInt(item.find("mhp\\:versionMajor").text())==1
					&& parseInt(item.find("mhp\\:versionMinor").text())<4) 
					|| (parseInt(item.find("mhp\\:versionMinor").text())==4
						&& parseInt(item.find("mhp\\:versionMicro").text()) <= 1)
				)
				)) {
                playerStatus = true;
                return false;
            }
        });
    }
    return playerStatus;
}
function getFvpPlayerAitx(handle, aitxUrl, notifyFunc, eTag) {
    if (typeof eTag == 'undefined') {
        eTag = getTagValue();
    }
    if (notifyFunc) {
        callBackObj[eTag] = notifyFunc;
    }
    if(aitxUrl){
       aitxUrl = encodeURI(aitxUrl);
    }
    var arg = {
        "PARAMETER": {
            "operator": "execute",
            "handle": handle,
            "priority": 50,
            "etag": eTag,
            "etype": "player_aitx",
            "player_aitx": {
                "lloc": "epg",
                "mediauri": aitxUrl
            },
            "REQUEST": "QUERY"
        }
    };
    g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
    return eTag;
}
var FvpExecuteType = {
    program: 'program',
    recomdDetails: 'recommend_details',
    recomdCategories: 'recommend_categories',
    search: 'search',
    serviceSchedule: 'service_schedule',
    contentOwning: 'content_owning',
    playerAitx: 'player_aitx',
    icon: 'icon',
    cancelQueries: 'cancel_queries'
};
function cancelFvpExecute(handle, etype, priority) {
    var eTag = getTagValue();
    var cancelObj = {};
    if (priority) {
        cancelObj['priority'] = priority;
    }
    if (etype) {
        cancelObj['etype'] = etype;
    }
    var arg = {
        "PARAMETER": {
            "REQUEST": "QUERY",
            "operator": "execute",
            "handle": handle,
            "priority": 50,
            "etag": eTag,
            "etype": "cancel_queries",
            "cancel_queries": cancelObj
        }
    };
    var res = g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
}
var pro_eTag = "";
function getFvpEventDelInfoByPragramId(handle, praid) {
    pro_eTag = getTagValue();
    var arg = {
        "PARAMETER": {
            "REQUEST": "QUERY",
            "operator": "execute",
            "handle": handle,
            "priority": 50,
            "etag": pro_eTag,
            "etype": "program",
            "program": {
                "program_id": praid
            }
        }
    };
    var res = g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
}
var search_eTag = 0;
function getFvpSearchDelInfoByPragramId(handle, praid) {
    search_eTag = getTagValue();
    var arg = {
        "PARAMETER": {
            "REQUEST": "QUERY",
            "operator": "execute",
            "handle": handle,
            "priority": 50,
            "etag": search_eTag,
            "etype": "program",
            "program": {
                "program_id": praid
            }
        }
    };
    var res = g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
}
var callBackObj = {};
/*
????inline_url??true, ????base64??????image data.
????inline_url??false,????image??raw data.
*/
function getFvpEventIconData(url, callback, width) {
    if (typeof width != 'undefined') {
        if (url.indexOf('?') >= 0) {
            url += '&w=';
        } else {
            url += '?w=';
        }
        url += width;
    }
    var eTag = getTagValue();
    if (callback) {
        callBackObj[eTag] = callback;
    }
    if(url){
       url = encodeURI(url);
    }
    var arg = {
        "PARAMETER": {
            "operator": "execute",
            "handle": g_fvp_handle,
            "priority": 50,
            "etag": eTag,
            "etype": "icon",
            "icon": {
                "mediauri": url,
                "inline_url": true
            },
            "REQUEST": "QUERY"
        }
    };
    g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
    return eTag;
}
function fvpGetDataReadyNotify(res) {
    if (!res) {
        console.info("vindy fvpGetDataReadyNotify res is null");
        return;
    }
    var tmp = JSON.parse(res);
    for (var i = 0; i < tmp.ITEMS.length; i++) {
        var item = tmp.ITEMS[i];
        //console.info("vindy fvpGetDataReadyNotify item.reason = " + item.reason);
        switch (item.reason) {
        case 6:
        case 8:
        case 10:
            if (!g_fvpconnected) {
                g_fvpconnected = true;
				//window.sessionStorage.genreListGetData = JSON.stringify(g_fvpconnected);// store it because MTDT do not get data again if it's getted
                epgFreeviewShow();
                addFvpEvtTimerStart();
                //console.info("vindy reason 6,8,10-> g_fvpconnected=true");
            }
            break;
        case 101:
            //program info
            if (pro_eTag == item.tag) {
                var xmlObj = item.VALUE;
                if (g_fvp_recmd_is_showing) {
                    recomdInfoPageUpdate(getFvpInfo(xmlObj));
                } else {
                    fvpInfoUpdate(getFvpInfo(xmlObj));
                }
            } else if (search_eTag == item.tag) {
                fvpSearchListInfoShow(getFvpInfo(item.VALUE));
            }
            break;
        case 102:
            //recommend_details
            if (g_recodel_eTag == item.tag) {
                g_recmd_EvtList = getFvpRecmdDetal(item.VALUE);
                $("#recmd_list_info_ul li").remove();// remove old list
                g_notify_count = 0;
				g_notify_case_count =0;
                g_recmd_genreEvtList = [];
                fvpGenreListInfoFilter(g_recmd_EvtList);
            }
            break;
        case 103:
			if (g_recommend_categories_eTag == item.tag) {
				//recommend_categories
				fvpGenreListShow(getFvpRecmdList(item.VALUE));
			}
            break;
        case 104:
            // search
            if(g_search_etag==item.tag){
                g_searchEvtlist = getFvpSearchList(item.VALUE);
                if(!g_searchEvtlist[0].start_ava_time){
                    g_searchUrls = g_searchEvtlist[0];
                    g_searchEvtlist = g_searchEvtlist.slice(1);
                    if(g_searchEvtlist.length>0){
                        if(!isEmptyObject(g_searchUrls)){

                            if(!g_searchUrls.first_page_url){
                                $('#search_list li').remove();// remove old list
                                g_searchEvtShowlist = [];
                                g_notify_count = 0;
                                fvpSearchListInfoFilter(g_searchEvtlist);  
                            }else{
                                g_notify_count = 0;
                                g_searchAddEvtShowlist = [];
                                fvpSearchListInfoFilter(g_searchEvtlist);
                            }
                        }else{
                            g_searchEvtShowlist = [];
                            g_notify_count = 0;
                            fvpSearchListInfoFilter(g_searchEvtlist);
                        }
                    }else{
					     $("#preloader-wrapper").css("display","none");
						 //next page request is null,should show first page
						 if(g_next_page_request && g_searchEvtShowlist.length>0){
							fvpSearchListShow(g_searchEvtShowlist);
							g_next_page_request = false;
						 }else{
							console.info("searchEvtListDel is null");
						 }
						 
                         //$('#search_list li').remove();
                         //$("#search_list_info").hide();
                    }
                   

                    //g_cur_page_url= g_searchUrls.fvpUrl.cur_page_url;
                }
            }
            //fvpSearchListShow(getFvpSearchList(item.VALUE));
            break;
        case 106:
            
            parseServiceListXml(item.VALUE);
             epgColorKeyTextUpdate();
			break;
        case 107:
            break;
        case 108:
            //service Schedule
            var pvTag = item.tag;
            var xmlObj = item.VALUE;
            epgFvpEventUpdateUI(pvTag, $(xmlObj), isFvpEvent());
            if (!g_fvpconnected) {
                g_fvpconnected = true;
                epgFreeviewShow();
            }
            break;
        case 109:
            if (!g_fvpconnected) {
                g_fvpconnected = true;
                epgFreeviewShow();
            }
            g_eventNameList = parseContentOwningXml(item.VALUE);
            //else if(g_fvp_search_is_showing == true){
            //fvpSearchListAddName(parseContentOwningXml(item.VALUE));
            //}
            break;
        case 110:
            if (callBackObj[item.tag]) {
                callBackObj[item.tag](item.tag, item.VALUE);
				//console.info("get_item.tag:"+item.tag+'count:'+g_notify_case_count);
                delete callBackObj[item.tag];
            }
            break;
        case 111:
            //icon query
            if (callBackObj[item.tag]) {
                callBackObj[item.tag](item.tag, item.VALUE);
                delete callBackObj[item.tag];
            }
            break;
        default:
            break;
        }
    }
}
function fvpGetConnectedState() {
    var eTag = getTagValue();
    var arg = {
        "PARAMETER": {
            "REQUEST": "QUERY",
            "operator": "execute",
            "handle": g_fvp_handle,
            "priority": 50,
            "etag": eTag,
            "etype": "content_owning"
        }
    };
    var res = g_mtvObj.epgfvpMtdtOperator(JSON.stringify(arg));
}
function parseContentOwningXml(xmlStr) {
    var contentOwningObj = {};
    $(xmlStr).find('ServiceInformation').each(function(i, item) {
        item = $(item);
        var contentOwningItem = {};
        contentOwningItem.serviceId = item.attr('serviceId');
        contentOwningItem.name = item.find('Name').text();
        contentOwningItem.mediaUri = item.find('RelatedMaterial:has(HowRelated[href="urn:tva:metadata:cs:HowRelatedCS:2012:19"])>MediaLocator>MediaUri:first').text();
        //contentOwningItem.promotionalText = $(item).find('PromotionalText').text();
        //contentOwningItem.serviceGenre = $(item).find('ServiceGenre').text();
        contentOwningObj[contentOwningItem.serviceId] = contentOwningItem;
    });
    //serviceIDRef
    return contentOwningObj;
}
function parseServiceListXml(XmlStr){
	$(XmlStr).find('ServiceInformation').each(function(i,item){
		item = $(item);
		var serviceListItem = {};
		serviceListItem.serviceId = item.attr('serviceId');
		serviceListItem.name = item.find('Name').text();
		serviceListItem.linkUrl = item.find('RelatedMaterial:has(HowRelated[href="urn:tva:metadata:cs:HowRelatedCS:2012:10.5"])>MediaLocator>MediaUri:first').text();
		
		g_serviceList[serviceListItem.serviceId] = serviceListItem;
	});
	
}
function getFvpSearchList(searchXml) {
    var searchInfo = $(searchXml);
    var fvpSearchListDel = [];
    var fvpSearchList = {};
    var fvpUrl = {};
    searchInfo.find('GroupInformation RelatedMaterial').each(function(k, item) {
        item = $(item);
        var str = item.find('HowRelated').attr('href');
        //str = str.substr(str.lastIndexOf(":")).substr(1)
        if (str.match(/:first$/)) {
            fvpUrl.first_page_url = item.find('MediaUri').text();
        } else if (str.match(/:prev$/)) {
            fvpUrl.prev_page_url = item.find('MediaUri').text();
        } else if (str.match(/:next$/)) {
            fvpUrl.next_page_url = item.find('MediaUri').text();
        } else if (str.match(/:last$/)) {
            fvpUrl.last_page_url = item.find('MediaUri').text();
        }
    });
    $(searchInfo).find('ProgramInformation').each(function(k, item) {
        fvpSearchList[$(item).attr('programId')] = item;
    });
    $(searchInfo).find('OnDemandProgram').each(function(k, item) {
        item = $(item);
        var crid = item.find('Program').attr('crid');
        var info = $(fvpSearchList[crid]);
        fvpSearchListDel[k] = {};
        info.find('Title').each(function(o, titleItem) {
            titleItem = $(titleItem);
            if (titleItem.attr('type') == 'main') {
                fvpSearchListDel[k].main_title = titleItem.text();
            } else if (titleItem.attr('type') == 'secondary') {
                fvpSearchListDel[k].sub_title = titleItem.text();
            }
        });
        fvpSearchListDel[k].icon_url = $(info).find('RelatedMaterial:has(HowRelated[href="urn:tva:metadata:cs:HowRelatedCS:2012:19"])>MediaLocator>MediaUri:first').text();
        //fvpSearchListDel[k].auxil_url=
        fvpSearchListDel[k].start_ava_time = item.find('StartOfAvailability').text();
        fvpSearchListDel[k].end_ava_time = item.find('EndOfAvailability').text();
        fvpSearchListDel[k].auxiliaryURL = item.find('AuxiliaryURL').text();
        fvpSearchListDel[k].programURL = item.find('ProgramURL').text();
        fvpSearchListDel[k].serviceIdRef = item.attr('serviceIDRef');
        fvpSearchListDel[k].crid = item.find('Program').attr('crid');
        fvpSearchListDel[k].eventIdNum = getTagValue();
        fvpSearchListDel[k].index = k;
    });
    if (fvpUrl) {
        fvpSearchListDel.unshift(fvpUrl);
    }
    return fvpSearchListDel;
}
function getFvpRecmdList(recmdxml) {
    var recmdInfo = $(recmdxml);
    var fvpRecmdList = [];
    recmdInfo.find('GroupInformation:not(GroupInformation[numOfItems])').each(function(k, item) {
        item = $(item);
        fvpRecmdList[k] = {};
        fvpRecmdList[k].title = item.find('Title').eq(0).text();
        fvpRecmdList[k].groupId = item.attr('groupId');
    });
    return fvpRecmdList;
}
function getFvpRecmdDetal(xml) {
    var recmdDetal = $(xml);
    var fvprecmdDetal = [];
    var eventInfo = {};
    //var data = $(recmdDetal).find('ProgramInformation');
    recmdDetal.find('ProgramInformation').each(function(infoNum, infoItem) {
        eventInfo[$(infoItem).attr('programId')] = infoItem;
    });
    $(recmdDetal).find('OnDemandProgram').each(function(k, item) {
        item = $(item);
        var crid = item.find('Program').attr('crid');
        var info = $(eventInfo[crid]);
        fvprecmdDetal[k] = {};
        fvprecmdDetal[k].crid = crid;
        fvprecmdDetal[k].EVENT_ID = EPG_INVALID_EVENT_ID;
        info.find('Title').each(function(o, titleItem) {
            titleItem = $(titleItem);
            if (titleItem.attr('type') == 'main') {
                fvprecmdDetal[k].main_title = titleItem.text();
            } else if (titleItem.attr('type') == 'secondary') {
                fvprecmdDetal[k].sub_title = titleItem.text();
            }
        });
        fvprecmdDetal[k].MediaUri = info.find('RelatedMaterial:has(HowRelated[href="urn:tva:metadata:cs:HowRelatedCS:2012:19"])>MediaLocator>MediaUri:first').text();
        //fvprecmdDetal[k].start_ava_time = $(item).find('StartOfAvailability').text();
        //fvprecmdDetal[k].end_ava_time = $(item).find('EndOfAvailability').text();
        var startUtcTime = getFvpTime(item.find('StartOfAvailability').text());
        fvprecmdDetal[k].start_ava_time = startUtcTime;
        var duration = getFvpDuration(item.find('PublishedDuration').text());
        fvprecmdDetal[k].end_ava_time = duration + startUtcTime;
        fvprecmdDetal[k].auxiliaryURL = item.find('AuxiliaryURL').text();
        fvprecmdDetal[k].programURL = item.find('ProgramURL').text();
        fvprecmdDetal[k].serviceIdRef = item.attr('serviceIDRef');
        fvprecmdDetal[k].index = k;
        fvprecmdDetal[k].eventIdNum = getTagValue();
        //fvprecmdDetal[k].mediaAvailability = $(item).find("InstanceDescription>Genre[href^='urn:fvc:metadata:cs:MediaAvailabilityCS']").attr('href').indexOf('media_available') > 0;
        //fvprecmdDetal[k].fEPGAvailability = $(item).find("InstanceDescription>Genre[href^='urn:fvc:metadata:cs:MediaAvailabilityCS']").attr('href').indexOf('fepg_available') > 0;
    });
    return fvprecmdDetal;
}
function getFvpInfo(infoXml) {
    var fvpInfo = $(infoXml);
    var fvpInfoObj = {};
    fvpInfoObj.START_TIME = getFvpTime(fvpInfo.find('StartOfAvailability').text());
    fvpInfoObj.DURATION = getFvpDuration(fvpInfo.find('PublishedDuration').text());
    fvpInfoObj.EVENT_NAME = fvpInfo.find('Title[type=main]').eq(0).text();
    fvpInfoObj.secondaryTitle = fvpInfo.find('Title[type=secondary]').eq(0).text();
    fvpInfoObj.mediums = fvpInfo.find('Synopsis[length="medium"]').eq(0).text();
    fvpInfoObj.genre = get_genre_context(fvpInfo.find('BasicDescription Genre').attr('href'));
    var CaptionLanguage = fvpInfo.find('CaptionLanguage[closed="true"]');
    if (CaptionLanguage && CaptionLanguage.length > 0) {
        for (var i = 0; i < CaptionLanguage.length; i++) {
            if (isCaption(CaptionLanguage.eq(i).text())) {
                fvpInfoObj.CaptionLanguage = isCaption(CaptionLanguage.eq(i).text());
                break;
            }
        }
    }
    var ParentalGuidance = fvpInfo.find('ParentalGuidance:first');
    ParentalGuidance.find('mpeg7\\:ParentalRating').each(function(o, titleItem) {
        var titleItem = $(titleItem);
        var bbfc = titleItem.attr('href').match(/^urn:dtg:cs:BBFCContentRatingCS:2002:(\S*)/);
        if(bbfc && bbfc.length > 0){
            fvpInfoObj.ParentalWarning = "G";
            fvpInfoObj.ParentalRating = getBBFCContentRating(bbfc[1]);
        } else {
            var res1 = titleItem.attr('href').match(/^urn:fvc:metadata:cs:ContentRatingCS:2014-07:(\S*)/);
            if (res1 && res1.length > 0) {
                fvpInfoObj.ParentalWarning = "G";
                fvpInfoObj.ParentalRating = getFVCContentRating(res1[1]);
            } else {
                var res = titleItem.attr('href').match(/^urn:dtg:metadata:cs:DTGContentWarningCS:2011:(\S*)/);
                if (!res) {
                    res = titleItem.attr('href').match(/^urn:dtg:metadata:cs:DTGContentWarningCS:2011-1:(\S*)/);
                }
                if (res && res.length > 0) {
                    fvpInfoObj.ParentalWarning = res[1];
                }
            }
        }
    });
    fvpInfoObj.ExplanatoryText = ParentalGuidance.find('ExplanatoryText').text();

    var signLag = fvpInfo.find('SignLanguage[closed="false"]');
    if (signLag && signLag.length > 0) {
        var i;
        for (i = 0; i < signLag.length; i++) {
            if (signLag.eq(i).text() != 'invalid') {
                fvpInfoObj.signLanguage = signLag.eq(i).text();
                break;
            }
        }
    }
    var audioDescription = fvpInfo.find('AudioAttributes>AudioLanguage[purpose="urn:tva:metadata:cs:AudioPurposeCS:2007:1"]');
    fvpInfoObj.Audio = (audioDescription && audioDescription.length > 0) ? 1 : 0;
    fvpInfoObj.VerticalSize = fvpInfo.find('VerticalSize').text();
    fvpInfoObj.MediaUri = fvpInfo.find('RelatedMaterial:has(HowRelated[href="urn:tva:metadata:cs:HowRelatedCS:2012:19"])>MediaLocator>MediaUri:first').text();
    fvpInfoObj.serviceIdRef = fvpInfo.find('OnDemandProgram').attr('serviceIDRef');
    return fvpInfoObj;
}
function isCaption(str) {
    switch (str) {
    case 'eng':
        return 'English';
        break;
    case 'cym':
    case 'wel':
        return 'Weish';
        break;
    case 'gla':
        return 'Gaelic';
        break;
    case 'gle':
        return 'Irish';
        break;
    case 'und':
        return 'Undefined';
        break;
    case 'qaa':
        return 'Original language(of soundtrack)';
        break;
    default:
        return false;
        break;
    }
}
function epgFvpEventUpdateUI(pvTag, xmlObj, isBackward) {
    var rowIdx = -1;
    var needNoEventData = true;
    var scheduleObj = null ;
    for (var i = 0; i < g_channelList.length; i++) {
        if (g_channelList[i].pvTag == pvTag) {
            rowIdx = i;
            break;
        }
    }
    if (rowIdx == -1) {
        return;
    }
    var aitUrlObj = {};
    g_channelList[rowIdx].retryCount++;
    scheduleObj = xmlObj.find('Schedule');
    scheduleObj.each(function(s, schedule) {
        schedule = $(schedule);
        var startTimeStr = getFvpTime(schedule.attr('start'));
        var endTimeStr = getFvpTime(schedule.attr('end'));
        if (endTimeStr < epgGetEventStartUtcTime() || startTimeStr > (epgGetEventStartUtcTime() + 7200)) {
            return true;
        }
        var eventList = [];
        var eventObj = {};
        var eventInfo = {};
        var onDemandInfo = {};
        schedule.find('ScheduleEvent').each(function(k, item) {
            item = $(item);
            var startTime = getFvpTime(item.find('PublishedStartTime').text());
            var duration = getFvpDuration(item.find('PublishedDuration').text());
            if (startTime + duration <= epgGetEventStartUtcTime()) {
                return true;
            } else if (startTime >= (epgGetEventStartUtcTime() + 7200)) {
                return false;
            }
            var crid = item.find('Program').attr('crid');
            var info = null ;
            if (eventInfo[crid]) {
                info = eventInfo[crid];
            } else {
                info = xmlObj.find('ProgramInformation[programId="' + crid + '"]');
                eventInfo[crid] = info;
            }
            var fvpEventItem = {};
            fvpEventItem.crid = crid;
            fvpEventItem.EVENT_ID = 0;
            fvpEventItem.EVENT_NAME = info.find('Title[type=main]').eq(0).text();
            fvpEventItem.secondaryTitle = info.find('Title[type=secondary]').eq(0).text();
            fvpEventItem.MediaUri = info.find('RelatedMaterial:has(HowRelated[href="urn:tva:metadata:cs:HowRelatedCS:2012:19"])>MediaLocator>MediaUri:first').text();
            fvpEventItem.START_TIME = getFvpTime(item.find('PublishedStartTime').text());
            fvpEventItem.DURATION = getFvpDuration(item.find('PublishedDuration').text());
            var odItem = null ;
            if (onDemandInfo[crid]) {
                odItem = onDemandInfo[crid];
            } else {
                odItem = xmlObj.find('OnDemandProgram:has(Program[crid="' + crid + '"])');
                onDemandInfo[crid] = odItem;
            }
            if (odItem.length > 0) {
                var odObj = {};
                odObj.startOfAvailability = getFvpTime(odItem.find('StartOfAvailability').text());
                odObj.endOfAvailability = getFvpTime(odItem.find('EndOfAvailability').text());
                odObj.auxiliaryURL = odItem.find('AuxiliaryURL').text();
                odObj.programURL = odItem.find('ProgramURL').text();
                odObj.mediaAvailability = odItem.find("InstanceDescription>Genre[href^='urn:fvc:metadata:cs:MediaAvailabilityCS']").attr('href').indexOf('media_available') > 0;
                odObj.fEPGAvailability = odItem.find("InstanceDescription>Genre[href^='urn:fvc:metadata:cs:FEPGAvailabilityCS']").attr('href').indexOf('fepg_available') > 0;
                fvpEventItem.onDemandInfo = odObj;
            }
            fvpEventItem.onDemand = getOnDemandAvailability(epgGetBroadcastTime(), fvpEventItem);
            if (fvpEventItem.onDemand == 2) {
                if (!aitUrlObj.hasOwnProperty(fvpEventItem.onDemandInfo.auxiliaryURL)) {
                    fvpEventItem.onDemandInfo.aitxTag = getTagValue();
                    aitUrlObj[fvpEventItem.onDemandInfo.auxiliaryURL] = fvpEventItem.onDemandInfo.aitxTag;
                } else {
                    fvpEventItem.onDemandInfo.aitxTag = aitUrlObj[fvpEventItem.onDemandInfo.auxiliaryURL];
                }
            }
            if (isBackward) {
                fvpEventItem.mediums = info.find('Synopsis[length="medium"]').eq(0).text();
                fvpEventItem.genre = get_genre_context(info.find('BasicDescription Genre').attr('href'));
                var ParentalGuidance = info.find('ParentalGuidance:first');
                ParentalGuidance.find('mpeg7\\:ParentalRating').each(function(o, titleItem) {
                    var titleItem = $(titleItem);
                    var bbfc = titleItem.attr('href').match(/^urn:dtg:cs:BBFCContentRatingCS:2002:(\S*)/);
                    if(bbfc && bbfc.length > 0){
                        fvpEventItem.ParentalWarning = "G";
                        fvpEventItem.ParentalRating = getBBFCContentRating(bbfc[1]);
                    } else {
                        var res1 = titleItem.attr('href').match(/^urn:fvc:metadata:cs:ContentRatingCS:2014-07:(\S*)/);
                        if (res1 && res1.length > 0) {
                            fvpEventItem.ParentalWarning = "G";
                            fvpEventItem.ParentalRating = getFVCContentRating(res1[1]);
                        } else {
                            var res = titleItem.attr('href').match(/^urn:dtg:metadata:cs:DTGContentWarningCS:2011:(\S*)/);
                            if (!res) {
                                res = titleItem.attr('href').match(/^urn:dtg:metadata:cs:DTGContentWarningCS:2011-1:(\S*)/);
                            }
                            if (res && res.length > 0) {
                                fvpEventItem.ParentalWarning = res[1];
                            }
                        }
                    }
                });
                fvpEventItem.ExplanatoryText = ParentalGuidance.find('ExplanatoryText').text();
                var CaptionLanguage = odItem.find('CaptionLanguage[closed="true"]');
                if (CaptionLanguage && CaptionLanguage.length > 0) {
                    for (var i = 0; i < CaptionLanguage.length; i++) {
                        if (isCaption(CaptionLanguage.eq(i).text())) {
                            fvpEventItem.CaptionLanguage = isCaption(CaptionLanguage.eq(i).text());
                            break;
                        }
                    }
                }
                var signLag = odItem.find('SignLanguage[closed="false"]');
                if (signLag && signLag.length > 0) {
                    for (var i = 0; i < signLag.length; i++) {
                        if (signLag.eq(i).text() != 'invalid') {
                            fvpEventItem.signLanguage = signLag.eq(i).text();
                            break;
                        }
                    }
                }
                var audioDescription = odItem.find('AudioAttributes>AudioLanguage[purpose="urn:tva:metadata:cs:AudioPurposeCS:2007:1"]');
                fvpEventItem.Audio = (audioDescription && audioDescription.length > 0) ? 1 : 0;
                fvpEventItem.VerticalSize = odItem.find('VerticalSize').text();
                eventList.push(fvpEventItem);
            } else {
                fvpEventItem.eventId = parseInt(item.find('ProgramURL').text().match(/;(\S*)/)[1], 16);
                eventObj[fvpEventItem.eventId] = fvpEventItem;
            }
        });
        if (isBackward) {
            if(eventList.length > 0){
                if (needNoEventData) {
                    needNoEventData = false;
                }
                epgDrawFvpEventUI(rowIdx, eventList);
            }
        } else {
            mergeFvpAndEitData(rowIdx, eventObj);
        }
    });
    var firstEventTime = epgGetEventStartUtcTime() + 7200;
    if (g_eventList[rowIdx].length > 0) {
        firstEventTime = g_eventList[rowIdx][0].START_TIME;
    }
    if (xmlObj.length >= 0 && (g_channelList[rowIdx].retryFlag == 0 && g_channelList[rowIdx].retryCount == 2) && (firstEventTime > epgGetEventStartUtcTime())) {
        //get data again
        getFvpEventInfoByChannel(g_channelList[rowIdx], g_fvp_handle, epgGetEventStartUtcTime() - (6 * 3600), 1800, -1);
        return;
    } else if (xmlObj.length >= 0 && g_channelList[rowIdx].retryFlag == 1 && (firstEventTime > epgGetEventStartUtcTime())) {
        getFvpEventInfoByChannel(g_channelList[rowIdx], g_fvp_handle, epgGetEventStartUtcTime() - (6 * 3600), 1800, 2);
    } else if (xmlObj.length >= 0 && g_channelList[rowIdx].retryFlag == 2 && (firstEventTime > epgGetEventStartUtcTime())) {
        getFvpEventInfoByChannel(g_channelList[rowIdx], g_fvp_handle, epgGetEventStartUtcTime() - (12 * 3600), 1800, -1);
        return;
    } else if (needNoEventData && isBackward) {
        if(g_channelList[rowIdx].retryFlag == -1)
            epgDrawFvpEventUI(rowIdx, []);
    }
    for (var key in aitUrlObj) {
        console.log("key = " + key + ";value = " + aitUrlObj[key]);
        getFvpPlayerAitx(g_fvp_handle, key, fvpEventPlayerNotify, aitUrlObj[key]);
    }
    if (isBackward) {
        if (firstEventTime <= epgGetEventStartUtcTime() && (g_channelList[rowIdx].retryFlag == 2 || g_channelList[rowIdx].retryFlag == 1 || (g_channelList[rowIdx].retryFlag == 0 && g_channelList[rowIdx].retryCount == 2))) {
            g_channelList[rowIdx].retryFlag = -1;
        }
        if (rowIdx == g_channelFocusIdx) {
            if (g_channelList[rowIdx].retryFlag == -1){
                epgSetFocus();
            }
        }
    }
}
/*
*1:Available
*0:Coming Soon
*-1:Unavailable
*/
function getOnDemandAvailability(currentTime, fvpEventItem) {
    if (fvpEventItem.onDemandInfo) {
        if (currentTime >= (fvpEventItem.START_TIME + fvpEventItem.DURATION)) {
            if (currentTime >= fvpEventItem.onDemandInfo.startOfAvailability && currentTime < fvpEventItem.onDemandInfo.endOfAvailability) {
                if (fvpEventItem.onDemandInfo.mediaAvailability) {
                    return 2;
                } else {
                    return 0;
                }
            } else if (currentTime < fvpEventItem.onDemandInfo.startOfAvailability && fvpEventItem.onDemandInfo.startOfAvailability < (currentTime + 7200)) {
                return 0;
            }
        } else {
            if (fvpEventItem.onDemandInfo.fEPGAvailability) {
                if (currentTime >= fvpEventItem.onDemandInfo.startOfAvailability && currentTime < fvpEventItem.onDemandInfo.endOfAvailability) {
                    if (fvpEventItem.onDemandInfo.mediaAvailability) {
                        return 2;
                    } else {
                        return 0;
                    }
                } else if (currentTime < fvpEventItem.onDemandInfo.startOfAvailability && fvpEventItem.onDemandInfo.startOfAvailability < (currentTime + 7200)) {
                    return 0;
                }
            }
        }
    }
    return -1;
}
function getTagValue() {
    return parseInt((new Date().getTime()) / 100 + Math.random() * (0xffff) + 1);
}
function getFvpTime(dateStr) {
    //var offset = new Date().getTimezoneOffset()* 60 * 1000;
    //var mTime = new Date(new Date(dateStr).getTime()+offset).getTime();
    var mTime = new Date(dateStr).getTime();
    return mTime / 1000;
}
function getFvpDuration(durationStr) {
    var duration = 0;
    var res = durationStr.match(/^P((\d+)Y)?((\d)+M)?((\d)+D)?T((\d+)H)?((\d+)M)?((\d+)S)?/);
    if (res) {
        if (res[2]) {
            duration += parseInt(res[2] * 24 * 3600 * 365);
        }
        if (res[4]) {
            duration += parseInt(res[4] * 24 * 3600 * 30);
        }
        if (res[6]) {
            duration += parseInt(res[6] * 24 * 3600);
        }
        if (res[8]) {
            duration += parseInt(res[8] * 3600);
        }
        if (res[10]) {
            duration += parseInt(res[10] * 60);
        }
        if (res[12]) {
            duration += parseInt(res[12]);
        }
    }
    return duration;
}
function getVerticalSizeStr(mum) {
    if (mum < 720) {
        return "SD";
    } else if (mum >= 720 && mum < 2160) {
        return "HD";
    } else if (mum >= 2160 && mum < 4320) {
        return "4K";
    } else if (mum >= 4320) {
        return "8K";
    } else {
        return "SD";
    }
}
function get_genre_context(genreStr) {
    var context = "";
    if (!genreStr) {
        return context;
    }
    switch (genreStr.match(/^urn:fvc:metadata:cs:ContentSubjectCS:2014-07:(\S*)/)[1]) {
    case "0":
        context = "Unclassified";
        break;
    case "1":
        context = "Movie";
        break;
    case "2":
        context = "News and factual";
        break;
    case "2.1":
        context = "News/Current affairs";
        break;
    case "2.2":
        context = "Arts/Culture(without music)";
        break;
    case "2.3":
        context = "Social/Political Issues/Econnomics";
        break;
    case "3":
        context = "Entertainment";
        break;
    case "3.1":
        context = "Show/Game show";
        break;
    case "3.2":
        context = "Music/Ballet/Dance";
        break;
    case "4":
        context = "Sport";
        break;
    case "5":
        context = "Children's/Youth's programming";
        break;
    case "6":
        context = "Education/Science/Factual topics";
        break;
    case "7":
        context = "Lifestyle/Leisure hobbies";
        break;
    case "8":
        context = "Drama";
        break;
    default:
        break;
    }
    return context;
}
function getBBFCContentRating(str) {
    var context = "";
    if (!str) {
        return context;
    }
    switch (str) {
    case 'U':
    context = 'Universal';
    break;
    case 'PG':
    context = 'Parental Guidance';
    break;
    case '12':
    context = 'Suitable for 12 years and over (Video)';
    break;
    case '15':
    context = 'Suitable only for 15 years and over';
    break;
    case '18':
    context = 'Suitable only for adults';
    break;
    default:
        break;
    }
    return context;
}
function getFVCContentRating(str) {
    var context = "";
    if (!str) {
        return context;
    }
    switch (str) {
    case 'no_parental_controls':
    context = 'No parental controls';
    break;
    case 'unrated':
    context = 'Unrated';
    break;
    case 'parental_guidance':
    context = 'Parental Guidance';
    break;
    case 'twelve':
    context = 'Suitable for 12 years and over';
    break;
    case 'fifteen':
    context = 'Suitable only for 15 years and over';
    break;
    case 'sixteen':
    context = 'Suitable only for 16 years and over';
    break;
    case 'eighteen':
    context = 'Suitable only for 18 years and over';
    break;
    default:
        break;
    }
    return context;
}