window.onload = function() {
    console.log("Open Channel List.");
    //init option menu part
    var lan = mtvObj.getGuiLanguage('');
    var g_mtvObj = new MtvObj();
    g_mtvObj.acfgSetConfigValue("g_custom_base__close_nettv_oskb", 0);
    if (lan != null && lan != "") {
        lan = lan.ITEMS[0].TEXT;
        if (lan.toUpperCase() == "DUT") {
            $("#ColorKey_Yellow").parent().css("width", "360px");
        }
    }
    //Ryan chung avoid operator and channel list type incompatible.
    var ch = mtvObj.getCurrentChannelInfoForEachTuner();
    var ch_list_type = parseInt(get_channel_list_type());
    var sat_brdcster = mtvObj.getBsBsSatelliteBrdcster();
    if((ch.SVL_ID == BRDCST_DVBS) && ((ch_list_type == CUST_CH_LIST_TYPE_PACKS)&& (sat_brdcster != DVBS_OPERATOR_NAME_TELEKARTA))
        || ((ch_list_type == CUST_CH_LIST_TYPE_CAT) && (sat_brdcster != DVBS_OPERATOR_NAME_TELEKARTA))
        || ((ch_list_type == CUST_CH_LIST_TYPE_GROUPS) && (sat_brdcster != DVBS_OPERATOR_NAME_NTV_PLUS)))
    {
        set_channel_list_type(CUST_CH_LIST_TYPE_ALL);    
    }
    /* register channel notify */
    mtvObj.addChannelInfoEventListener(update_channel_notify);
    setTimeout(function(){
        var current_bs_src_type = parseInt(mtvObj.getDtvTunerBsSrc());
		var b_open_fav_lst = mtvObj.acfgGetConfigValue("g_custom_base__ch_fav_lst_open");
		// 20170918 [TF518PHIEUMTK01-1602] iHS>How_to>Sort your channel list>Favourites
        if (b_open_fav_lst)
		{
			mtvObj.acfgSetConfigValue("g_custom_base__ch_fav_lst_open", 0);
			/* select which tuner type */
    		if (current_bs_src_type == BS_TYPE_SAT) {
    			/* Satellite tuner type */
    			top_menu_item_focus(true, "top_menu_1");
    			var ch_count = mtvObj.getAllChannelCount();	 
				if (ch_count > 0)
				{	
					top_menu_bar_selected("top_menu_1", 2, "satellite_submenu_bar_0");
					//get all channel count
					if(get_favorite_length()<=0)
					{
		                Favorite_edit_create_favorite_state_layout();
		                //set active mode
		                set_active_mode(ModeList.Mode_Favorite_create_favorite);
		            }
					else
					{
						set_active_mode(ModeList.Mode_Favorite_edit_one_by_one);
						set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_default);
						Favorite_edit_one_by_one_state_layout();
					}
				}
       		}
        	else {
				/* DTV tuner type */
            	top_menu_item_focus(true, "top_menu_0");
				var ch_count = mtvObj.getAllChannelCount();
				if (ch_count > 0)
				{
					top_menu_bar_selected("top_menu_0", 2, "tv_submenu_bar_0");
					if(get_favorite_length()<=0)
					{
		                    		Favorite_edit_create_favorite_state_layout();
		                    		//set active mode
		                    		set_active_mode(ModeList.Mode_Favorite_create_favorite);
		            }
					else
					{
						set_active_mode(ModeList.Mode_Favorite_edit_one_by_one);
						set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_default);
						Favorite_edit_one_by_one_state_layout();
					}
				}
        	}
		// 20170918 [TF518PHIEUMTK01-1602] end
		} else {
			/* select which tuner type */
    		if (current_bs_src_type == BS_TYPE_SAT) {
    			/* Satellite tuner type */
    			top_menu_item_focus(true, "top_menu_1");
			}else {
				/* DTV tuner type */
            	top_menu_item_focus(true, "top_menu_0");
			}
		}
		
        $('.preloader-wrapper').hide();
        /* reset first boot up flag */
        if (is_first_boot_up == true) {
            is_first_boot_up = false;
        }
    }, 20);

};

//  fav_list.js
function get_favorite_length() {
    /* get the length of favorite list */
    return mtvObj.getFavoriteChannelCountEX(FAVORITE_TYPE_0);
}
;
function get_is_favorite_ch_by_mask(ch_mask) {

    return ((MaskList.Mask_favorite & ch_mask) == MaskList.Mask_favorite);
}
;

// option_menu_handle_key.js
/* get channel count by svl id and mask and mask value */
function get_channel_count(svl_id, nw_mask, mask_value, satlId, satlRecId, categoryMask) {
    return mtvObj.getChannelCountTemp(svl_id, nw_mask, mask_value, satlId, satlRecId, categoryMask);
}

/* use INFO/BLUE key to UP/DOWN in debug mode */
function show_up_down_info(e) {
    var keynum = e.which || e.keyCode;
    switch (keynum) {
        case KeyEvent.DOM_VK_INFO:
            sub_heigh += 300;
            break;
        case KeyEvent.DOM_VK_BLUE:
            if (sub_heigh > 300) {
                sub_heigh -= 300;
            } else {
                sub_heigh = 0;
            }
            break;
    }
}
function show_end_view() {

    var div = document.getElementById('show_log_div');

    div.scrollTop = div.scrollHeight - sub_heigh;
}
function startScanMenu() {
    mtvObj.startNativeApp({"PARAMETER":{"VALUE":"AutoTunerScan","REQUEST":"MODIFY"}});
    if(isFVP_Enable() == 1)
        localStorage.setItem("FVPLaunchPoint", "FromCHList");
    mtvuiUtil.gotoSysPage("sys_index", true);
}
function startScanMenuOfSattellite() {
    mtvObj.startNativeApp({"PARAMETER":{"VALUE":"SatelliteTunerScan","REQUEST":"MODIFY"}});
    mtvuiUtil.gotoSysPage("sys_index", true);
}


function update_channel_notify(notify_info) {
    console.log("update_channel_notify notify_info:" + notify_info);
    notify_info = JSON.parse(notify_info);
    var needRef = false;
    for (var i = 0; i < notify_info.ITEMS.length; i++) {
        if (ChannelNotifyTypeList.ChannelNotifyType_svl_updated == parseInt(notify_info.ITEMS[i].CONDITIONS)
        && 0 != notify_info.ITEMS[i].REASON) {
            needRef = true;
        }
    }
    if(needRef){
		if($("#optionMenuid").length>0){
			$("body").OptionMenuDialog('close');
		}
        update_channel_count(); //20181221 add for fix [TF518PHIEUMTK05-3126] [AP] [SGP] 3.1.3_ After update the service list, highlight can not move to the last channel.
        update_current_page_ch_list();
    }
}
function is_need_card_ch_update_notify() {
    switch (active_mode) {
        case ModeList.Mode_FindChannel_show_results:
            {
                return false;
            }
        default:
            return true;

    }
    return true;
}

function update_current_page_ch_list() {
    /* if not card channel updated notify, return */
    if (false == is_need_card_ch_update_notify()) {
        return;
    }
    var nw_mask = get_current_mask();
    var mask_value = get_current_mask_value();
    var ch_idx = $(".channel_list li.active").index();
    if(idx_from_or_to_isfirst_ch==true && idx_to<8 && active_mode==ModeList.Mode_Move_moving){
		var nw_mask = get_current_mask();
        var mask_value = get_current_mask_value();
	    var ch = mtvObj.getCurrentChannelInfoForEachTuner();
	    var ch_info = get_fav_channel_info_by_idx(ch.SVL_ID, nw_mask, mask_value, 0);
		var ch_id=ch_info.ITEMS[0].CHANNEL_ID;
		var svl_id=ch_info.ITEMS[0].SVL_ID;
		idx_from_or_to_isfirst_ch=false;
	}else if(g_sort_page_ch_index>=7 && active_mode==ModeList.Mode_Move_moving){
	    var firstItem = $(".channel_list li:eq(1)");
		var svl_id = firstItem.attr("svl_id");
		var ch_id=firstItem.attr("channel_id");
	}else if(g_sort_page_ch_index==0 && active_mode==ModeList.Mode_Move_moving){
	    var firstItem = $(".channel_list li:eq(0)");
		var svl_id = firstItem.attr("svl_id");
		var ch_id=firstItem.attr("channel_id");
		var index=firstItem.attr("channel_idx");
	    var ch_info = get_fav_channel_info_by_idx(svl_id, nw_mask, mask_value, index-1);
        var ch_id=ch_info.ITEMS[0].CHANNEL_ID;
	    var svl_id=ch_info.ITEMS[0].SVL_ID;
	}
	else{		
		var firstItem = $(".channel_list li:first");
		var svl_id = firstItem.attr("svl_id");
		var ch_id=firstItem.attr("channel_id");
	}
    if (current_tuner_type != TunerType_list.TunerType_satellite) {
        var dtv_tuner_type = mtvObj.getDtvTunerType();
        console.log("dtv_tuner_type:" + dtv_tuner_type);
        switch (parseInt(dtv_tuner_type)) {
            case 0:
                //rewrite SVL_ID to air.
                //svl_id = 1;
                if (TYPE_BRDCST == mtvObj.getBroadcastType()) {
                    svl_id = BRDCST_DVBT;
                } else {
                    svl_id = CAM_DVBT;
                }
                break;
            case 1:
                //rewrite SVL_ID to cab.
                //svl_id = 2;
                if (TYPE_BRDCST == mtvObj.getBroadcastType()) {
                    svl_id = BRDCST_DVBC;
                } else {
                    svl_id = CAM_DVBC;
                }
                break;
            default:
                //rewrite SVL_ID to air.
                svl_id = BRDCST_DVBC;
                break;
        }
    }
    else {
        /* in satellite tuner type */
        //svl_id = 3;
        if (TYPE_BRDCST == mtvObj.getBroadcastType()) {
            svl_id = BRDCST_DVBS;
        } else {
            svl_id = CAM_DVBS;
        }
    }
    var direction = DirectionList.Form_next;
       if(active_mode==ModeList.Mode_TV_normal_favorite){
    	var fav_cnt = mtvObj.getFavoriteChannelCountEX(FAVORITE_TYPE_0);
    	if(fav_cnt<2){
        	var direction = DirectionList.Direction_next;
    	}
    }
   //var functio= update_channel_count();
    /* get current channel mask and mask value */
    var get_cur_type = get_cur_ch_list_type();
    $("#channel_list_ul").html("");
    console.log("get_cur_ch_list_type:" + get_cur_type);

    switch (parseInt(get_cur_type)) {
        case ChannelListTypeList.ChannelListType_tv_favorite:
        case ChannelListTypeList.ChannelListType_satellite_favorite:
            //direction=DirectionList.Direction_next;
            carousel_add_channel_items(ModeList.Mode_TV_normal_favorite, svl_id, ch_id, direction, CAROUSEL_ITEM_CNT, FAVORITE_TYPE_0);
            break;
        case ChannelListTypeList.ChannelListType_tv_all:
        case ChannelListTypeList.ChannelListType_satellite_all:
            carousel_add_channel_items(ModeList.Mode_TV_normal_all, svl_id, ch_id, direction, CAROUSEL_ITEM_CNT);
            break;
        case ChannelListTypeList.ChannelListType_tv_radio:
        case ChannelListTypeList.ChannelListType_satellite_radio:
            carousel_add_channel_items(ModeList.Mode_TV_normal_radio, svl_id, ch_id, direction, CAROUSEL_ITEM_CNT);
            break;
        case ChannelListTypeList.ChannelListType_tv_new:
        case ChannelListTypeList.ChannelListType_satellite_new:
            TV_normal_new_state_mark_layout();
            break;
        case ChannelListTypeList.ChannelListType_satellite_tv:
            carousel_add_channel_items(ModeList.Mode_TV_normal_tv, svl_id, ch_id, direction, CAROUSEL_ITEM_CNT);
            break;
        default:
            carousel_add_channel_items(ModeList.Mode_TV_normal_all, svl_id, ch_id, direction, CAROUSEL_ITEM_CNT);
            break;
    }
    /* reload current page item cards */
    var item_cards = $(".channel_list li");
   /* set orignal channel position active */
   if (item_cards.length > 0) {
       $(item_cards).eq(ch_idx).addClass("active");
	   var active_card=$('.channel_list li.active');
       if(active_card.length<1){
		$(item_cards).eq(ch_idx-1).addClass("active");
	   }
   }

}
function update_channel_count() {
    console.log("before update_channel_count:" + g_channel_cnt);
    console.log("get_cur_ch_list_type:" + get_cur_ch_list_type());
    /* get current channel mask and mask value */
    var nw_mask = get_current_mask();
    var mask_value = get_current_mask_value();
    var ch = mtvObj.getCurrentChannelInfoForEachTuner();

    switch (parseInt(get_cur_ch_list_type())) {
        case ChannelListTypeList.ChannelListType_tv_favorite:
        case ChannelListTypeList.ChannelListType_satellite_favorite:
            g_channel_cnt = mtvObj.getFavoriteChannelCountEX(FAVORITE_TYPE_0);
            break;
        case ChannelListTypeList.ChannelListType_tv_all:
        case ChannelListTypeList.ChannelListType_satellite_all:
        case ChannelListTypeList.ChannelListType_tv_radio:
        case ChannelListTypeList.ChannelListType_satellite_radio:
        case ChannelListTypeList.ChannelListType_tv_new:
        case ChannelListTypeList.ChannelListType_satellite_new:
        case ChannelListTypeList.ChannelListType_satellite_tv:
            g_channel_cnt = get_channel_count(ch.SVL_ID, nw_mask, mask_value);
            break;
        default:
            break;
    }

}
function store_chlist_type_to_acfg() {
    console.log("store_chlist_type_to_acfg get_cur_ch_list_type:" + get_cur_ch_list_type());
    switch (parseInt(get_cur_ch_list_type())) {
        case ChannelListTypeList.ChannelListType_tv_favorite:
        case ChannelListTypeList.ChannelListType_satellite_favorite:
            set_channel_list_type(CUST_CH_LIST_TYPE_FAVORITE);
            break;
        case ChannelListTypeList.ChannelListType_tv_all:
        case ChannelListTypeList.ChannelListType_satellite_all:
            set_channel_list_type(CUST_CH_LIST_TYPE_ALL);
            break;
        case ChannelListTypeList.ChannelListType_tv_radio:
        case ChannelListTypeList.ChannelListType_satellite_radio:
            set_channel_list_type(CUST_CH_LIST_TYPE_RADIO);
            break;
        case ChannelListTypeList.ChannelListType_tv_new:
        case ChannelListTypeList.ChannelListType_satellite_new:
            set_channel_list_type(CUST_CH_LIST_TYPE_NEW);
            break;
        case ChannelListTypeList.ChannelListType_satellite_tv:
            set_channel_list_type(CUST_CH_LIST_TYPE_TV);
            break;
        case ChannelListTypeList.ChannelListType_satellite_packs:  //Ryan Add Packs/Categories for Telekarta
            //set_channel_list_type(CUST_CH_LIST_TYPE_PACKS);    //Save list type too early.
            break;
        case ChannelListTypeList.ChannelListType_satellite_cat:
            //set_channel_list_type(CUST_CH_LIST_TYPE_CAT);
            break;
	    case ChannelListTypeList.ChannelListType_satellite_groups:  //Kana add Groups for NTV+
            //set_channel_list_type(CUST_CH_LIST_TYPE_GROUPS);
            break;
        default:
            break;
    }
    console.log("after get_channel_list_type:" + get_channel_list_type());
}
function set_channel_list_type(list_type) {
    console.log("set_channel_list_type:" + list_type);
    mtvObj.setChannelListType(list_type);
}
function get_channel_list_type() {
    return mtvObj.getChannelListType();
}

/* set channel list filter type */
function set_channel_filter_type(filter_type) {
    console.log("set_channel_filter_type:" + filter_type);
    mtvObj.setChannelFilterType(filter_type);
}

/* get channel list filter type */
function get_channel_filter_type() {
    return mtvObj.getChannelFilterType();
}
var storeChannelListtimeout = null;
var flag_storeChannelList = null;
function store_channel_list_to_acfg() {

    console.log("store_channel_list_to_acfg");
    storeChannelListtimeout = true;
    /*
    if (storeChannelListtimeout == null) {
        settime_store_channel_list_to_acfg();
    } else {
        flag_storeChannelList = storeChannelListtimeout;
    }
    */
}
function settime_store_channel_list_to_acfg() {
    if (storeChannelListtimeout == null) {
        mtvObj.storeChannelList('');
        storeChannelListtimeout = setTimeout("settime_store_channel_list_to_acfg()", 3000);
    } else {
        if (null != flag_storeChannelList) {
            mtvObj.storeChannelList('');
            storeChannelListtimeout = null;
            flag_storeChannelList = null;
        }
        else {
            storeChannelListtimeout = null;
        }
    }
}

function rename_channel_name_by_svl_ch_id(svl_id, channel_id, text_value) {
    mtvObj.editChannel(svl_id, channel_id, text_value);
    /* update channel logo id */
    update_channel_logo_id(svl_id, channel_id);
    /* store to acfg */
    store_channel_list_to_acfg();
}

function update_channel_logo_id(svl_id, channel_id) {
    console.log("update_channel_logo_id() svl_id" + svl_id);
    mtvObj.updateChannelLogoId(svl_id, channel_id);
}
function set_channel_info(svl_id, ch_id, ch_mask) {
    console.log("set_channel_info(svl_id:" + svl_id + ",ch_id:" + ch_id + ",ch_mask:" + ch_mask + ")");
    mtvObj.setChannelInfo(svl_id, ch_id, ch_mask);
}

function lock_channel_by_svl_and_ch_id(svl_id, ch_id, ch_mask) {
    console.log("lock_channel..(svl_id:" + svl_id + ",ch_id:" + ch_id + ",ch_mask:" + ch_mask + ")");
    ch_mask = ch_mask | SB_VENT_BLOCKED;

    set_channel_info(svl_id, ch_id, ch_mask);
}

function unlock_channel_by_svl_and_ch_id(svl_id, ch_id, ch_mask) {
    console.log("unlock_channel..(svl_id:" + svl_id + ",ch_id:" + ch_id + ",ch_mask:" + ch_mask + ")");
    ch_mask = ch_mask & (~SB_VENT_BLOCKED);
    set_channel_info(svl_id, ch_id, ch_mask);
}

function jump_to_help_page() {
    var arg = {"PARAMETER": {
            "appMode": "EDFU",
            "edfuUrl": "/usr/opera/opera_dir/pages/edfu/index.html",
            "REQUEST": "SET"}};

    mtvObj.startNetTV(JSON.stringify(arg));
    afterurlstoreChannelList();
}


var set_active_mode = function(mode) {
    //set active mode
    if (get_is_tv_normal_card_active_mode(mode)) {
        last_active_mode = mode;
    }

    //set current active mode
    active_mode = mode;
}

var back_to_last_active_mode = function() {
    console.log("back to last active mode: " + last_active_mode);
    set_active_mode(last_active_mode);
}

var get_is_tv_normal_card_active_mode = function(mode) {
    switch (mode) {
        case ModeList.Mode_TV_normal_favorite:
        case ModeList.Mode_TV_normal_all:
        case ModeList.Mode_TV_normal_radio:
        case ModeList.Mode_TV_normal_new:
        case ModeList.Mode_TV_normal_tv:
        case ModeList.Mode_Favorite_edit_one_by_one:
            return true;
        default:
            break;
    }

    return false;
}

var set_keyboard_mode = function(mode) {
    //set keyboard mode
    keyboard_mode = mode;
}

function satellite_filter_condition_reset()
{
    satlId = 0;
    satlRecId = 0;
    categoryMask = 0;
}
/*
* show selected top menu bar.
*/
function top_menu_bar_selected(id, n, subId) {
    console.log('top_menu_bar_selected id =' + id);
            //in TV tuner
        if ('top_menu_0' ==id) {
            set_tuner_type(TunerType_list.TunerType_tv);
            satellite_filter_condition_reset();
        }
        else {
            update_dvbs_svl_id();
            set_tuner_type(TunerType_list.TunerType_satellite);
        }

    //get all channel count
    var ch_count = mtvObj.getAllChannelCount();
    //if there is no channel ,should install channel
    if (ch_count <= 0) {
        //set active mode
        set_active_mode(ModeList.Mode_TV_normal_install_channel);
        //layout install channel dialog
        $("#id_div_main_menu").hide();
        TV_normal_install_channel_state_layout();

    }
    else {
        init_ch_list_by_chlist_type(subId);
        initSubTitle();
        if (is_first_boot_up == true) {
            $('#id_div_contain').focus();
            top_menu_item_focus(false, id);
			initSubTitleByFilter(); // 20170926 [TF518PHIEUMTK01-1703]
        }
    }
}
function init_ch_list_by_chlist_type(subId) {
    var id = null;
    var cur_id=null;
    if(subId){
        id=subId;
    }else {
        ch_list_type = parseInt(get_channel_list_type());

         switch (ch_list_type) {
             case CUST_CH_LIST_TYPE_ALL:
                 if (current_tuner_type == TunerType_list.TunerType_tv) {
                     id = "tv_submenu_bar_1";
                 }
                 else {
                     id = "satellite_submenu_bar_1";
                 }
                 break;
             case CUST_CH_LIST_TYPE_RADIO:
                 if (current_tuner_type == TunerType_list.TunerType_tv) {
                     id = "tv_submenu_bar_2";
                 }
                 else {
                     id = "satellite_submenu_bar_3";
                 }
                 break;
             case CUST_CH_LIST_TYPE_FAVORITE:
                 if (current_tuner_type == TunerType_list.TunerType_tv) {
                     id = "tv_submenu_bar_0";
                 }
                 else {
                     id = "satellite_submenu_bar_0";
                 }
                 break;
             case CUST_CH_LIST_TYPE_NEW:
                 if (current_tuner_type == TunerType_list.TunerType_tv) {
                     id = "tv_submenu_bar_3";
                 }
                 else {
                     id = "satellite_submenu_bar_4";
                 }
                 break;
             case CUST_CH_LIST_TYPE_TV:
                 if (current_tuner_type == TunerType_list.TunerType_tv) {
                     id = "tv_submenu_bar_1";
                 }
                 else {
                     id = "satellite_submenu_bar_2";
                 }
                 break;
	    case CUST_CH_LIST_TYPE_PACKS:  //Ryan Add Packs/Categories for Telekarta
                id = "satellite_submenu_bar_5";
		break;
	    case CUST_CH_LIST_TYPE_CAT:
                id = "satellite_submenu_bar_6";
		break;
	    case CUST_CH_LIST_TYPE_GROUPS:    //Kana add Groups for NTV+
                id = "satellite_submenu_bar_7";
		break;
         }
    }
    //error handle
//     if ($('#' + id).length <= 0) {
//         if (current_tuner_type == TunerType_list.TunerType_tv) {
//             id = "tv_submenu_bar_1";
//         }
//         else {
//             id = "satellite_submenu_bar_1";
//         }
//     }
    submenu_item_focus(true, id);
    //show_tv_normal_items();
}
function set_tuner_type(tuner_type) {
    console.log("set_tuner_type: " + tuner_type);
    //current_tuner_type define in base.js
    current_tuner_type = tuner_type;
}

/*
* focus top menu item.
*/
 function initTitle(id) {
    if (id=="top_menu_0"||id=="tv_submenu_bar_1"||id=="tv_submenu_bar_0"||id=="tv_submenu_bar_2"||id=="tv_submenu_bar_3") {
         var dtv_tuner_type = mtvObj.getDtvTunerType();
        if(dtv_tuner_type==0){
            $('#id_div_title').text(getTranslate("MAIN_ANTENNA_TV_SELECTED"));    
        }else{
            $('#id_div_title').text(getTranslate("MAIN_CABLE_TV_SELECTED"));
        }
          
    }else {
          $('#id_div_title').text(getTranslate("MAIN_SATELLITE_SELECTED"));
    }


}

function top_menu_item_focus(isfocus, id) {
    console.log('top_menu_item_focus isfocus =' + isfocus + ' id =' + id);
    initTitle(id);
    if (isfocus) {
        //focus_level = 1;
        //content.className = "focus";
        if (top_menu_selected_id && top_menu_selected_id == id)
            return;
         top_menu_selected_id = id;
        top_menu_bar_selected(id, 2);

    } else {
        /*
        if (id == top_menu_selected_id) {
            content.className = "selected";
        } else {
            content.className = "li";
        }
    */
    }
}

var Packsfilter;
var CATEGORYfilter;
var GROUPSfilter;
//var bIsPack;
var nPackType = 0;
/*
* focus sub menu item.
*/
function submenu_item_focus(isfocus, id) {
    console.log('submenu_item_focus isfocus =' + isfocus + ' id =' + id);
    if (isfocus) {
		set_option_curval();
         submenu_selected_id = id;

        if (true == is_first_boot_up) {
            /* get current channel mask and mask value */
            var nw_mask = get_current_mask();
            var mask_value = get_current_mask_value();
            var ch = mtvObj.getCurrentChannelInfoForEachTuner();

            g_channel_cnt = get_channel_count(ch.SVL_ID, nw_mask, mask_value);

            /* if channel count < 0 under current filter type */
            if (g_channel_cnt <= 0) {
                /* set channel filter type to all */
                set_channel_filter_type(CUST_CH_FILTER_TYPE_ALL);
            }
            //focus_level = 3;
        } else {
            /* set channel filter type to all */
            set_channel_filter_type(CUST_CH_FILTER_TYPE_ALL);
            satellite_filter_condition_reset();
        }


        /* init All channel cards  */
        if (submenu_selected_id == 'tv_submenu_bar_1' || (submenu_selected_id == 'satellite_submenu_bar_1')) {
            //set active mode
            set_active_mode(ModeList.Mode_TV_normal_all);
            /* set current channel list type */
            if ((submenu_selected_id == 'tv_submenu_bar_1')) {
                set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_all);
            }
            else {
                set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_all);
            }
             //layout All channel list in TV normal mode
            TV_normal_all_state_layout();
        }  /* init Radio channel cards  */
        else if (submenu_selected_id == 'tv_submenu_bar_2' || (submenu_selected_id == 'satellite_submenu_bar_3')) {
            //set active mode
            set_active_mode(ModeList.Mode_TV_normal_radio);
            /* set current channel list type */
            if ((submenu_selected_id == 'tv_submenu_bar_2')) {
                set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_radio);
            }
            else {
                set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_radio);
            }
            //layout Radio channel list
            TV_normal_radio_state_layout();
        }
        else if ((submenu_selected_id == 'tv_submenu_bar_3') || (submenu_selected_id == 'satellite_submenu_bar_4')) {
            //set active mode
            set_active_mode(ModeList.Mode_TV_normal_new);
            /* set current channel list type */
            if ((submenu_selected_id == 'tv_submenu_bar_3')) {
                set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_new);
            }
            else {
                set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_new);
            }
            //layout New channel list
            TV_normal_new_state_layout();
        }
        else if (submenu_selected_id == 'satellite_submenu_bar_2') {
            //set active mode
            set_active_mode(ModeList.Mode_TV_normal_tv);
            /* set current channel list type */
            set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_tv);
            //layout TV channel list in satellite
            TV_normal_tv_state_layout();
        }
        else if (submenu_selected_id == 'tv_submenu_bar_0' || (submenu_selected_id == 'satellite_submenu_bar_0')) {
            //show create favorite channel list dialog.
            if (get_favorite_length() <= 0) {
                console.log("show creat favorite!");
                //no favorite channel in favorite_list
                //set active mode
                set_active_mode(ModeList.Mode_Favorite_create_favorite);
                //layout
                Favorite_edit_create_favorite_state_layout();
            }
            //show favorite channel list
            else {
                //set active mode
                set_active_mode(ModeList.Mode_TV_normal_favorite);
                /* set current channel list type */
                if ((submenu_selected_id == 'tv_submenu_bar_0')) {
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_favorite);
                }
                else {
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_favorite);
                }
                //layout
                var target = $('#channel_list_ul');
                target.html(" ");
                TV_normal_favorite_state_layout();
            
            }
        }
		else if(submenu_selected_id == 'satellite_submenu_bar_5')    //Packs //Ryan Add Packs/Categories for Telekarta
        {
			//bIsPack = 1;
			nPackType = 1;
			set_active_mode(ModeList.Mode_packs_list);
			set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_packs);
			TV_sat_packs_state_layout();
        }
		else if(submenu_selected_id == 'satellite_submenu_bar_6')    //Categories //Ryan Add Packs/Categories for Telekarta
        {
			//bIsPack = 0;
			nPackType = 2;
			set_active_mode(ModeList.Mode_category_list);
			set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_cat);
			TV_sat_categories_state_layout();
        }
		else if(submenu_selected_id == 'satellite_submenu_bar_7')    //Groups //Kana add Groups for NTV+
        {
			//bIsPack = 0;
			nPackType = 3;
			set_active_mode(ModeList.Mode_groups_list);
			set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_groups);
			TV_sat_groups_state_layout();
        }
        else {
            //clear all card
            $("#id_channel_carousel").html("");
        }

    }

    store_chlist_type_to_acfg();

}


function set_selected_channel_card_active() {
    var channel_selected_idx = 0;
    item_cards = $('#id_channel_carousel').find(".item.active .card.channel");
    if (item_cards.length <= 0) {
        return false;
    }
    switch (parseInt(get_cur_ch_list_type())) {
        case ChannelListTypeList.ChannelListType_tv_favorite:
        case ChannelListTypeList.ChannelListType_satellite_favorite:
            channel_selected_idx = fav_list_selected_idx;
            break;
        case ChannelListTypeList.ChannelListType_tv_all:
        case ChannelListTypeList.ChannelListType_satellite_all:
            channel_selected_idx = all_list_selected_idx;
            break;
        case ChannelListTypeList.ChannelListType_tv_radio:
        case ChannelListTypeList.ChannelListType_satellite_radio:
            channel_selected_idx = radio_list_selected_idx;
            break;
        case ChannelListTypeList.ChannelListType_tv_new:
        case ChannelListTypeList.ChannelListType_satellite_new:
            channel_selected_idx = new_list_selected_idx;
            break;
        case ChannelListTypeList.ChannelListType_satellite_tv:
            channel_selected_idx = tv_list_selected_idx;
            break;
        default:
            break;
    }
    /* set selected channel active */
    $(item_cards[channel_selected_idx]).attr("class", "card channel active");
    /* favorite list color key need not to change */
    if (!((submenu_selected_id == 'tv_submenu_bar_0') || (submenu_selected_id == 'satellite_submenu_bar_0'))) {
        /* change the color key list between fav's channel and not fav's channel. */
        if (get_is_favorite_ch_by_mask($(item_cards[channel_selected_idx]).attr("channel_mask"))) {
            set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);
        } else {
            //not favorite channel colourkey
            set_colourkey_list_text(ColourKeyList_TV_normal_All_not_fav_state);
        }
    }
}

function change_channel_by_channel_id(channel_id) {
    /* channge channel */
    mtvObj.setBrdcastChgChannel(channel_id);
}
//change channel of dvbc-->dvbt or dvbt-->dvbc
function change_channel_from_dvbt_to_dvbc(src_ch, target_ch) {
    //one channel list case
    if (parseInt(mtvObj.getOclStatus())) {

        /*[on ch list internal] the following steps is the channel change in one channel list case:*/
        /*step1: set ocl toggle type on*/

        /*step2: set the correct bs type according to the channel info*/

        /*step3: channel chanage by change id*/

        /*step4: set the bs type to cab*/

        /*step5: set ocl toggle type off*/


        /*[not on ch list case internal] channel change*/

        /*step3: channel chanage by change id*/
        //step 1: set one channel lsit toggle type on
        mtvObj.setOclToggleType(OCL_TOGGLE_TYPE_ON);
        //step 2:set bs type according to the channel info
        switch (parseInt(target_ch.SVL_ID)) {
            case BRDCST_DVBT:
            case CAM_DVBT:
                mtvObj.setDtvTunerBsSrc(BS_TYPE_AIR);
                break;
            case BRDCST_DVBC:
            case CAM_DVBC:
                mtvObj.setDtvTunerBsSrc(BS_TYPE_CAB);
                break;
            default:
                mtvObj.setDtvTunerBsSrc(BS_TYPE_AIR);
                break;
        }
        /* step3: channel change by channel id */
        change_channel_by_channel_id(target_ch.CHANNEL_ID);
        /* step4: set the bs type to cab due to current is one channel list */
        //mtvObj.setDtvTunerBsSrc(BS_TYPE_CAB);
        /* step5: set ocl toggle type off */
        mtvObj.setOclToggleType(OCL_TOGGLE_TYPE_OFF);
    }
    else {
        change_channel_by_channel_id(target_ch.CHANNEL_ID);
    }
}

//change channel of dvbc-->dvbs or dvbt-->dvbs
function change_channel_from_dvbct_to_dvbs(src_ch, target_ch) {
    /*DTV->DVBS*/
    /*step1: one chlist toggle  list_on*/
    /*step2: set bs src  to dvbs*/
    /*step3: one chlist toggle off*/
    /*step4: channel change by ch id*/

    //one channel list case
    if (parseInt(mtvObj.getOclStatus())) {
        //step 1: set one channel lsit toggle type on
        mtvObj.setOclToggleType(OCL_TOGGLE_TYPE_ON);
        //step 2:set bs type according to the channel info
        mtvObj.setDtvTunerBsSrc(BS_TYPE_SAT);

        /* step3: channel change by channel id */
        change_channel_by_channel_id(target_ch.CHANNEL_ID);
        /* step4: set the bs type to cab due to current is one channel list */
        //mtvObj.setDtvTunerBsSrc(BS_TYPE_CAB);
        /* step5: set ocl toggle type off */
        mtvObj.setOclToggleType(OCL_TOGGLE_TYPE_OFF);

    }
    else {
        //step 1: set one channel lsit toggle type on
        mtvObj.setOclToggleType(OCL_TOGGLE_TYPE_LIST_CH_ON);
        //step 2:set bs type according to the channel info
        mtvObj.setDtvTunerBsSrc(BS_TYPE_SAT);

        /* step3: channel change by channel id */
        change_channel_by_channel_id(target_ch.CHANNEL_ID);
        /* step4: set ocl toggle type off */
        mtvObj.setOclToggleType(OCL_TOGGLE_TYPE_OFF);
    }
}

//change channel of dvbs-->dvbt or dvbs-->dvbc
function change_channel_from_dvbs_to_dvbct(src_ch, target_ch) {

    /*DVBS --> DTV*/
    /*step1: one chlist toggle list_on*/
    /*step2: set bs src to the one that store in dtv bs type*/
    /*step3: one chlist toggle off*/
    /*step4: check whether the current condition is one chlist*/
    /*step5   1: one chlist, 2: not one chlist*/
    /*step5.1.1: [one chlist channel change]*/
    /*step5.2.1: [not one chlist channel change]*/
    //one channel list case
    if (parseInt(mtvObj.getOclStatus())) {
        /* step 1: set one channel lsit toggle type on */
        mtvObj.setOclToggleType(OCL_TOGGLE_TYPE_ON);
        /* step 2: get one channel lsit channel id */
        //var ocl_ch_id = mtvObj.getOclChannelId();
        /* step 3: get dtv tuner type */
        //var dtv_tuner_type = mtvObj.getDtvTunerType();
        switch (parseInt(target_ch.SVL_ID)) {
            case BRDCST_DVBT:
            case CAM_DVBT:
                mtvObj.setDtvTunerBsSrc(BS_TYPE_AIR);
                break;
            case BRDCST_DVBC:
            case CAM_DVBC:
                mtvObj.setDtvTunerBsSrc(BS_TYPE_CAB);
                break;
            default:
                mtvObj.setDtvTunerBsSrc(BS_TYPE_AIR);
                break;
        }
        /* step4: channel change by channel id */
        change_channel_by_channel_id(target_ch.CHANNEL_ID);
        /* step5: set the bs type to cab due to current is one channel list */
        //mtvObj.setDtvTunerBsSrc(BS_TYPE_CAB);
        /* step6: set ocl toggle type off */
        mtvObj.setOclToggleType(OCL_TOGGLE_TYPE_OFF);
    }
    else {
        /* step 1: set one channel lsit toggle type list_ch_on */
        mtvObj.setOclToggleType(OCL_TOGGLE_TYPE_LIST_CH_ON);
        /* step 2: get dtv tuner type */
        //var dtv_tuner_type = mtvObj.getDtvTunerType();
        switch (parseInt(target_ch.SVL_ID)) {
            case BRDCST_DVBT:
            case CAM_DVBT:
                mtvObj.setDtvTunerBsSrc(BS_TYPE_AIR);
                break;
            case BRDCST_DVBC:
            case CAM_DVBC:
                mtvObj.setDtvTunerBsSrc(BS_TYPE_CAB);
                break;
            default:
                mtvObj.setDtvTunerBsSrc(BS_TYPE_AIR);
                break;
        }
        /* step3: channel change by channel id */
        change_channel_by_channel_id(target_ch.CHANNEL_ID);
        /* step4: set ocl toggle type off */
        mtvObj.setOclToggleType(OCL_TOGGLE_TYPE_OFF);
    }
}
/* if DVBS SVL_ID ? */
function is_dvbs_channel_by_svl_id(svl_id) {
    if ((svl_id == BRDCST_DVBS_GEN) ||
    (svl_id == BRDCST_DVBS_PREFER) ||
    (svl_id == CAM_DVBS)) {
        return true;
    }

    return false;
}
function pause_3rd_app() {
    mtvObj.pause3rdApp();
}
function change_channel_by_channle_info(channel_info) {
    /* step 1:Pause 3rd APP */
    //1 msgconvert(netflix);2 nettv;0 other app
    var appStatus = mtvObj.acfgGetConfigValue('g_misc__next_app_status');
    if(appStatus == 1){
	   pause_3rd_app();
	}else if(appStatus == 2){
	   mtvObj.exitNetTV({"PARAMETER": {"exitReason":"CHANGE_SOURCE","REQUEST":"SET"}});
	}
    /* step 2: get current channel info */
    ch = mtvObj.getCurrentChannelInfoEx();
    /* error handle */
    if (ch.SVL_ID == 0 ||
    ch.SVL_ID == undefined) {
        /* rewrite the SVL ID by bs source type */
        var current_bs_src_type = parseInt(mtvObj.getDtvTunerBsSrc());
        /* select which tuner type */
        if (current_bs_src_type == BS_TYPE_AIR) {
            /* AIR tuner type */
            ch.SVL_ID = BRDCST_DVBT;
        }
        else if (current_bs_src_type == BS_TYPE_CAB) {
            /* CAB tuner type */
            ch.SVL_ID = BRDCST_DVBC;
        } else if (current_bs_src_type == BS_TYPE_SAT) {
            /* Satellite tuner type */
            ch.SVL_ID = BRDCST_DVBS;
        } else {
            return;
        }
    }

    /* case 1: current play channel svl_id the same as target svl_id */
    if (ch.SVL_ID == channel_info.SVL_ID) {
        change_channel_by_channel_id(channel_info.CHANNEL_ID);
    }
    /* case 2: dvbc->dvbt or dvbt->dvbc , dvbs type is 3. */
    else if (!is_dvbs_channel_by_svl_id(ch.SVL_ID) &&
    !is_dvbs_channel_by_svl_id(channel_info.SVL_ID)) {
        change_channel_from_dvbt_to_dvbc(ch, channel_info);
		mtvObj.acfgSetConfigValue("g_custom_base__ocl_channel_current", channel_info.CHANNEL_ID);
	    mtvObj.acfgSetConfigValue("g_misc__update_dt_sync_mode",0);
		mtvObj.acfgSetConfigValue("g_custom_base__ocl_channel_last",ch.CHANNEL_ID);

    }
    /* case 3: dvbc->dvbs or dvbt->dvbs , dvbs type is 3. */
    else if (!is_dvbs_channel_by_svl_id(ch.SVL_ID) && is_dvbs_channel_by_svl_id(channel_info.SVL_ID)) {
        change_channel_from_dvbct_to_dvbs(ch, channel_info);
    }
    /* case 3: dvbc->dvbs or dvbt->dvbs , dvbs type is 3. */
    else if (is_dvbs_channel_by_svl_id(ch.SVL_ID) && !is_dvbs_channel_by_svl_id(channel_info.SVL_ID)) {
        change_channel_from_dvbs_to_dvbct(ch, channel_info);
    }
    /* default */
    else {
        change_channel_by_channel_id(channel_info.CHANNEL_ID);
    }

    var is_new = (MaskList.Mask_new & channel_info.NW_MASK) == MaskList.Mask_new;
    if (true == is_new) {
        /* remove NEW channel flag after change channel. */
        var ch_mask = (channel_info.NW_MASK & (~SB_VENT_NEW_SERVICE));
        set_channel_info(channel_info.SVL_ID, channel_info.CHANNEL_ID, ch_mask);
    }

    /* save current channel list type */
    store_chlist_type_to_acfg();
    /* 20170808 [TF518PHIEUMTK01-386] [EAT table] set iHS_back default status */
    mtvObj.acfgSetConfigValue("g_custom_base__ihs_back", false);
}

var carousel_add_channel_items = function(cur_mode, svl_id, ch_id, dir, num, fav_idx, search_str,chBegin) {
    var item_count = 0;
    //var chBegin = 0;
    var args = {
        "SVL_ID": svl_id,
        "CHANNEL_ID": ch_id,
        "SATL_ID": satlId,
        "SATL_REC_ID": satlRecId,
        "CATEGORY_MASK": categoryMask,
        "NW_MASK": get_current_mask(),
        "MASK_VALUE": get_current_mask_value(),
        "DIRECTION":(dir == DirectionList.Form_next)? "FORM_NEXT": ((dir == DirectionList.Direction_pre) ? "PRE" : "NEXT"),
        "NUM": num, //get channel list number
        "FAV_IDX": fav_idx, //favorite index
        "ENABLE_CYCLE": false, //disable get channel by cycle
        "CH_LIST_TYPE": "ALL"
    };

    switch (cur_mode) {
        case ModeList.Mode_TV_normal_favorite:
            {
                args["CH_LIST_TYPE"] = "FAV";
                args["NW_MASK"] = MaskList.Mask_favorite;
                args["MASK_VALUE"] = MaskValueList.MaskValue_favorite;
                var list = mtvuiChannel.getChannelList(args);
                $.each(list, function(k, item) {

                    g_favorite_channel_list[chBegin + k] = item;
                    item_count++;
                });
                if(list.length > 0){
                  set_channel_carousel($("#id_channel_carousel"),list,dir);
              }else {
                  return true;
              }

                break;
            }
        case ModeList.Mode_FindChannel_show_results:
            {
                /* get current channel mask and mask value */

                var nw_mask = get_current_mask();
                var mask_value = get_current_mask_value();
                var list = mtvObj.getChannelListBySearchStr(svl_id, nw_mask, mask_value, chBegin, num, search_str);

                var sub_title=$('#id_div_ch_type>.type_mid');
                var str=getTranslate("SEARCH") + ": " + search_str;    
                sub_title.html(str);
				
                $.each(list, function(k, item) {

                    g_favorite_channel_list[chBegin + k] = item;
                    item_count++;
                });

                if(list.length > 0){
                    set_channel_carousel($("#id_channel_carousel"),list,dir);

                }else {
                    return true;
                }

                /* CAROUSEL_ITEM_CNT+1 will make sure the carousel show scrollbar */

                break;
            }
        case ModeList.Mode_TV_normal_all:
        case ModeList.Mode_TV_normal_radio:
        case ModeList.Mode_TV_normal_new:
        case ModeList.Mode_TV_normal_tv:
        case ModeList.Mode_category_list:    //Ryan Add Packs/Categories for Telekarta
        case ModeList.Mode_packs_list:
        default:
            {
                args["CH_LIST_TYPE"] = "ALL";
                if(active_mode == ModeList.Mode_category_list || active_mode == ModeList.Mode_packs_list)
                {
                     args["CATEGORY_MASK"] = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
                }
                var sat_brdcster = mtvObj.getBsBsSatelliteBrdcster();
                var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");     
                var current_ch_list_type = this.mtvObj.getChannelListType();   
                if((sat_brdcster == DVBS_OPERATOR_NAME_NTV_PLUS) && (BATid == DVBS_NTV_PLUS_Other_BATid) && (current_ch_list_type == CUST_CH_LIST_TYPE_GROUPS))
                {
                    var list = mtvuiChannel.getChannelListGroupOther(args);
                }
                else
                {    
                    var list = mtvuiChannel.getChannelList(args);
                }
				// 20170922 [TF518PHIEUMTK01-1309]
				var get_channel_id;
				var tmp_channel_id;
				var tmp_list = list;
                for (var i in list)
                {
                    if((i == 1) && (FirstChannelid == 0) && (ChannelNotInList == true))
                    {
                        if(get_channel_id != undefined)
                            FirstChannelid = get_channel_id;
                    }
                	get_channel_id = list[i]["CHANNEL_ID"];
                	for (var j in tmp_list)
                    {
                		tmp_channel_id = tmp_list[j]["CHANNEL_ID"];
                		if (i != j && get_channel_id == tmp_channel_id)
                		{
							tmp_list.splice(j,1);
                		}
                	}
                }
				list = tmp_list;

				//TPV@Vinson(20171027)_SN0011a - start
				//Modify the sorting rule in channel list.
				if(get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR)
				{
					//Do nothing
				}
				else
				//TPV@Vinson(20171027)_SN0011a - end
				{
					/*Jason add to sort list*/
					list.sort(function(a, b){
						return parseInt($(a).attr("MAJOR_NUM"), 10) -
							   parseInt($(b).attr("MAJOR_NUM"), 10)
					 });			
				}

				// 20170922 end
                $.each(list, function(k, item) {
                    item_count++;
                    g_all_channel_list[chBegin + k] = item;
                });
                if(list.length > 0){
                  set_channel_carousel($("#id_channel_carousel"),list,dir);
              }else {
                  return true;
              }
                break;
            }
    }


};
//is last or first channel
var is_last_or_first_channel = function(cur_mode, svl_id, ch_id, dir, num, fav_idx, search_str,chBegin) {
    var item_count = 0;
    //var chBegin = 0;
    var args = {
        "SVL_ID": svl_id,
        "CHANNEL_ID": ch_id,
        "SATL_ID": satlId,
        "SATL_REC_ID": satlRecId,
        "CATEGORY_MASK": categoryMask,
        "NW_MASK": get_current_mask(),
        "MASK_VALUE": get_current_mask_value(),
        "DIRECTION":(dir == DirectionList.Form_next)? "FORM_NEXT": ((dir == DirectionList.Direction_pre) ? "PRE" : "NEXT"),
        "NUM": num, //get channel list number
        "FAV_IDX": fav_idx, //favorite index
        "ENABLE_CYCLE": false, //disable get channel by cycle
        "CH_LIST_TYPE": "ALL"
    };

    switch (cur_mode) {
        case ModeList.Mode_TV_normal_favorite:
            {
                args["CH_LIST_TYPE"] = "FAV";
                args["NW_MASK"] = MaskList.Mask_favorite;
                args["MASK_VALUE"] = MaskValueList.MaskValue_favorite;
                var list = mtvuiChannel.getChannelList(args);
                if(list.length <=0){
                  return true;
                }else{
				  return false;
				}

                break;
            }
        case ModeList.Mode_FindChannel_show_results:
            {
                /* get current channel mask and mask value */

                var nw_mask = get_current_mask();
                var mask_value = get_current_mask_value();
                var list = mtvObj.getChannelListBySearchStr(svl_id, nw_mask, mask_value, chBegin, num, search_str);

                if(list.length <=0){
                  return true;
                }else{
				  return false;
				}

                /* CAROUSEL_ITEM_CNT+1 will make sure the carousel show scrollbar */

                break;
            }
        case ModeList.Mode_TV_normal_all:
        case ModeList.Mode_TV_normal_radio:
        case ModeList.Mode_TV_normal_new:
        case ModeList.Mode_TV_normal_tv:
        default:
            {
                args["CH_LIST_TYPE"] = "ALL";
                var list = mtvuiChannel.getChannelList(args);
                if(list.length <=0){
                  return true;
                }else{
				  return false;
				}
                break;
            }
    }
}

/*set cur option focus item*/ 
function set_option_curval(){
	var ch_filter_type = parseInt(get_channel_filter_type());
	switch (ch_filter_type) {
		case CUST_CH_FILTER_TYPE_ALL:
			DigitalAnalogue.curValue=0;
			break;
		case CUST_CH_FILTER_TYPE_DIGITAL:
			DigitalAnalogue.curValue=1;
			break;
		//case CUST_CH_FILTER_TYPE_RADIO:
		//	nw_mask = nw_mask | MaskList.Mask_radio;
		//	break;
		case CUST_CH_FILTER_TYPE_ANALOG:
			DigitalAnalogue.curValue=2;
			break;
		//case CUST_CH_FILTER_TYPE_NEW:
		//	nw_mask = nw_mask | MaskList.Mask_new;
		//	break;
		case CUST_CH_FILTER_TYPE_FREE_SCRAMBLE:
			/* free + scrambled is same as all */
			FreeScrambled.curValue=0;
			break;
		case CUST_CH_FILTER_TYPE_FREE_ONLY:
			FreeScrambled.curValue=1;
			break;
		case CUST_CH_FILTER_TYPE_SCRAMBLE:
			FreeScrambled.curValue=2;
			break;
		default:
			DigitalAnalogue.curValue=0;
			break;
	}
}
/* get current channel list mask by channel list type and channel filter type */
function get_current_mask() {
    var nw_mask = MaskList.Mask_all;
    /* get channel list type */
    var ch_list_type = parseInt(get_cur_ch_list_type());
    switch (ch_list_type) {
        case ChannelListTypeList.ChannelListType_tv_favorite:
        case ChannelListTypeList.ChannelListType_satellite_favorite:
            nw_mask = nw_mask | MaskList.Mask_favorite;
            break;
        case ChannelListTypeList.ChannelListType_tv_all:
        case ChannelListTypeList.ChannelListType_satellite_all:
            nw_mask = nw_mask | MaskList.Mask_all;
            break;
        case ChannelListTypeList.ChannelListType_tv_radio:
        case ChannelListTypeList.ChannelListType_satellite_radio:
            nw_mask = nw_mask | MaskList.Mask_radio;
            break;
        case ChannelListTypeList.ChannelListType_tv_new:
        case ChannelListTypeList.ChannelListType_satellite_new:
            nw_mask = nw_mask | MaskList.Mask_new;
            break;
        case ChannelListTypeList.ChannelListType_satellite_tv:
            nw_mask = nw_mask | MaskList.Mask_tv;
            break;
        default:
            nw_mask = nw_mask | MaskList.Mask_all;
            break;
    }
    /* get channel filter type */
    var ch_filter_type = parseInt(get_channel_filter_type());
    switch (ch_filter_type) {
        case CUST_CH_FILTER_TYPE_ALL:
            nw_mask = nw_mask | MaskList.Mask_all;
            break;
        case CUST_CH_FILTER_TYPE_DIGITAL:
            nw_mask = nw_mask | MaskList.Mask_digital;
            break;
        case CUST_CH_FILTER_TYPE_RADIO:
            nw_mask = nw_mask | MaskList.Mask_radio;
            break;
        case CUST_CH_FILTER_TYPE_ANALOG:
            nw_mask = nw_mask | MaskList.Mask_analog;
            break;
        case CUST_CH_FILTER_TYPE_NEW:
            nw_mask = nw_mask | MaskList.Mask_new;
            break;
        case CUST_CH_FILTER_TYPE_FREE_SCRAMBLE:
            /* free + scrambled is same as all */
            nw_mask = nw_mask | MaskList.Mask_all;
            break;
        case CUST_CH_FILTER_TYPE_FREE_ONLY:
            nw_mask = nw_mask | MaskList.Mask_free;
            break;
        case CUST_CH_FILTER_TYPE_SCRAMBLE:
            nw_mask = nw_mask | MaskList.Mask_scrambled;
            break;
        default:
            nw_mask = nw_mask | MaskList.Mask_all;
            break;
    }

    return nw_mask;
}

/* get current channel list mask value by channel list type and channel filter type */
function get_current_mask_value() {
    var mask_value = MaskValueList.MaskValue_all;
    /* get channel list type */
    var ch_list_type = parseInt(get_cur_ch_list_type());
    switch (ch_list_type) {
        case ChannelListTypeList.ChannelListType_tv_favorite:
        case ChannelListTypeList.ChannelListType_satellite_favorite:
            mask_value = mask_value | MaskValueList.MaskValue_favorite;
            break;
        case ChannelListTypeList.ChannelListType_tv_all:
        case ChannelListTypeList.ChannelListType_satellite_all:
            mask_value = mask_value | MaskValueList.MaskValue_all;
            break;
        case ChannelListTypeList.ChannelListType_tv_radio:
        case ChannelListTypeList.ChannelListType_satellite_radio:
            mask_value = mask_value | MaskValueList.MaskValue_radio;
            break;
        case ChannelListTypeList.ChannelListType_tv_new:
        case ChannelListTypeList.ChannelListType_satellite_new:
            mask_value = mask_value | MaskValueList.MaskValue_new;
            break;
        case ChannelListTypeList.ChannelListType_satellite_tv:
            mask_value = mask_value | MaskValueList.MaskValue_tv;
            break;
        default:
            mask_value = mask_value | MaskValueList.MaskValue_all;
            break;
    }
    /* get channel filter type */
    var ch_filter_type = parseInt(get_channel_filter_type());
    switch (ch_filter_type) {
        case CUST_CH_FILTER_TYPE_ALL:
            mask_value = mask_value | MaskValueList.MaskValue_all;
            break;
        case CUST_CH_FILTER_TYPE_DIGITAL:
            mask_value = mask_value | MaskValueList.MaskValue_digital;
            break;
        case CUST_CH_FILTER_TYPE_RADIO:
            mask_value = mask_value | MaskValueList.MaskValue_radio;
            break;
        case CUST_CH_FILTER_TYPE_ANALOG:
            mask_value = mask_value | MaskValueList.MaskValue_analog;
            break;
        case CUST_CH_FILTER_TYPE_NEW:
            mask_value = mask_value | MaskValueList.MaskValue_new;
            break;
        case CUST_CH_FILTER_TYPE_FREE_SCRAMBLE:
            /* free + scrambled is same as all */
            mask_value = mask_value | MaskValueList.MaskValue_all;
            break;
        case CUST_CH_FILTER_TYPE_FREE_ONLY:
            mask_value = mask_value | MaskValueList.MaskValue_free;
            break;
        case CUST_CH_FILTER_TYPE_SCRAMBLE:
            mask_value = mask_value | MaskValueList.MaskValue_scrambled;
            break;
        default:
            mask_value = mask_value | MaskValueList.MaskValue_all;
            break;
    }

    return mask_value;
}

var favorite_create_favorite_key_proc = function(kc) {
    var idx = -1;
    var key = kc.keyCode || kc.which;
    /* handle UP key */
    if (key == KeyEvent.DOM_VK_UP) {
        return false;
    }
    /* handle LEFT key */
    else if (key == KeyEvent.DOM_VK_RIGHT) {
        console.log("Rec DOM_VK_LEFT");

        $('#btn-ok').addClass('active_bnt');
        $('#btn-cancel').removeClass('active_bnt').addClass('btn-select-style');

        return true;
    }
    /* handle RIGHT key */
    else if (key == KeyEvent.DOM_VK_LEFT) {
        console.log("Rec DOM_VK_RIGHT");

        $('#btn-cancel').addClass('active_bnt');
        $('#btn-ok').removeClass('active_bnt').addClass('btn-select-style');

        return true;
    }
    /* handle OK key */
    else if (key == KeyEvent.DOM_VK_RETURN) {

        console.log("REC: DOM_VK_RETURN key");

        var btn_id = $("#create-fav-dialog").find('.active_bnt').attr('id');

        if (btn_id == "btn-ok") {
            /* if focus at OK button should jump to ALL menu to add favorite item */
            //set active mode
            set_active_mode(ModeList.Mode_Favorite_edit_one_by_one);
            /* set current channel list type */
            set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_default);
            Favorite_edit_one_by_one_state_layout();
            //focus_level = 3;
        }
        else {
            /* hide the favorite dialog. */
            $('#create-fav-dialog').hide();
            $("#channel_list_ul").html("");  //Ryan Chung clean channel items first
            set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_default);
            TV_normal_all_state_layout();
            set_active_mode(ModeList.Mode_TV_normal_tv);
        }
        return true;

    }
	/* handle BACK key */	/*20170727 [TF518PHIEUMTK01-386] [EAT table]*/
	if (key == KeyEvent.DOM_VK_BACK) {
		mtvuiUtil.procSysKey(key); /*20170913*/
		return true;
	}
}
var tv_normal_install_channel_key_proc = function(kc) {
    var idx = -1;
    var key = kc.keyCode || kc.which;
    console.log("Enter install_channel_key_proc");
    /* handle UP key */
    if (key == KeyEvent.DOM_VK_UP || key == KeyEvent.DOM_VK_DOWN) {
   
        return false;
    }
    /* handle LEFT key */
    else if (key == KeyEvent.DOM_VK_RIGHT) {
        console.log("Rec DOM_VK_LEFT");

        $('#btn-yes').addClass('active_bnt');
        $('#btn-no').removeClass('active_bnt').addClass('btn-select-style');

        return true;
    }
    /* handle RIGHT key */
    else if (key == KeyEvent.DOM_VK_LEFT) {
        console.log("Rec DOM_VK_RIGHT");

        $('#btn-no').addClass('active_bnt');
        $('#btn-yes').removeClass('active_bnt').addClass('btn-select-style');

        return true;
    }
    /* handle OK key */
    else if (key == KeyEvent.DOM_VK_RETURN) {

        console.log("REC: DOM_VK_RETURN key");

        var btn_id = $("#installChannel-dialog").find('.active_bnt').attr('id');
        $("#installChannel-dialog").hide();
        if (btn_id == "btn-yes") {
            console.log("InstallChannel rec OK.");

            if (current_tuner_type == TunerType_list.TunerType_satellite) {
                //jump to dvbs scan channel of native UI
                startScanMenuOfSattellite();
            } else {
                //jump to scan channel of native UI
                startScanMenu();
            }

            /* back to home UI */
             //mtvuiUtil.gotoSysPage("sys_index");
            mtvuiUtil.proSysKey(key); /*20170824*/
            return true;

        }
        else {
            console.log("No");
            /* hide the favorite dialog. */
            $("#installChannel-dialog").hide();
            /* back to home UI */ 
	     //20171027//mtvuiUtil.proSysKey(key); /*20170824*/
	     mtvuiUtil.gotoSysPage("sys_index");/*20171027  [TF518PHIEUMTK05-1097] TV source when channel locked,select satellite favourites,DUT show black screen*/
        }
        return true;
    }
	/* handle BACK key */	/*20170727 [TF518PHIEUMTK01-386] [EAT table]*/
	if (key == KeyEvent.DOM_VK_BACK) {
		mtvuiUtil.proSysKey(key);	/*20170913*/
		return true;
	}
}
var Enter_pin_code_key_proc = function(kc) {

    var key = kc.keyCode || kc.which;
    console.log("Enter favorite_create_favorite_key_proc");
    /* handle UP key */
    if (key == KeyEvent.DOM_VK_UP) {
        return false;
    }
    /* handle LEFT key */
    else if (key == KeyEvent.DOM_VK_RIGHT) {
        console.log("Rec DOM_VK_LEFT");
		if(RegionCode == eRegionCode.PLF_OPT_REGION_RUSSIA)
		{
			$('#btn-pin-code-clear').addClass('active_bnt_AOC');
			$('#btn-pin-code-clear').find('p').eq(0).removeClass('btn_all_p').addClass('btn_all_active');
			$('#btn-pin-code-no').removeClass('active_bnt_AOC').addClass('btn-select-style');
			$('#btn-pin-code-no').find('p').eq(0).removeClass('btn_all_active').addClass('btn_all_p');
		}
		else
		{
			$('#btn-pin-code-clear').addClass('active_bnt');
			$('#btn-pin-code-clear').find('p').eq(0).removeClass('btn_all_p').addClass('btn_all_active');
			$('#btn-pin-code-no').removeClass('active_bnt').addClass('btn-select-style');
			$('#btn-pin-code-no').find('p').eq(0).removeClass('btn_all_active').addClass('btn_all_p');
		}
        return false;
    }
    /* handle RIGHT key */
    else if (key == KeyEvent.DOM_VK_LEFT) {
        console.log("Rec DOM_VK_RIGHT");
		if(RegionCode == eRegionCode.PLF_OPT_REGION_RUSSIA)
		{
			$('.btn_all').css("border-radius","0px");
			$('#btn-pin-code-no').addClass('active_bnt_AOC');
			$('#btn-pin-code-no').find('p').eq(0).removeClass('btn_all_p').addClass('btn_all_active');
			$('#btn-pin-code-clear').removeClass('active_bnt_AOC').addClass('btn-select-style');
			$('#btn-pin-code-clear').find('p').eq(0).removeClass('btn_all_active').addClass('btn_all_p');
		}
		else
		{
			$('#btn-pin-code-no').addClass('active_bnt');
			$('#btn-pin-code-no').find('p').eq(0).removeClass('btn_all_p').addClass('btn_all_active');
			$('#btn-pin-code-clear').removeClass('active_bnt').addClass('btn-select-style');
			$('#btn-pin-code-clear').find('p').eq(0).removeClass('btn_all_active').addClass('btn_all_p');
		}
        return false;
    }
    /* handle OK key */
    else if (key == KeyEvent.DOM_VK_RETURN) {

        console.log("REC: DOM_VK_RETURN key");

        var btn_id = $("#pin-code-dialog").find('.active_bnt').attr('id');

        if (btn_id == "btn-pin-code-yes") {
            console.log("InstallChannel rec OK.");
            /* confirm the input pin code is correct or not? */
            update_pin_code_status();
            if (correct_pin_code == true) {
                back_to_last_active_mode();
                /* reset colour bar */
                reset_colourbar();
            }
        }
		// 20170922 add for [TF518PHIEUMTK01-1679] do channel lock, input less than four nunber then choose clear, it locks automatically and inputing any code is unable to unlock
		else if (btn_id == "btn-pin-code-clear") {
            console.log("enter clear button.");
            /* clean the input pin code */
            reset_pin_code_osd_class();
        }
		// end
        else {
            console.log("enter cancel button.");
            reset_pin_code_osd_class();
            close_pin_code_dialog();
            /* return to last mode */
            back_to_last_active_mode();

        }
        return false;
    }
    /* handle number key */
    else if ((KeyEvent.DOM_VK_0 <= key) && (key <= KeyEvent.DOM_VK_9)) {
        try {
            switch (key) {
                case KeyEvent.DOM_VK_0:
                    update_pin_code_dialog(0);
                    break;
                case KeyEvent.DOM_VK_1:
                    update_pin_code_dialog(1);
                    break;
                case KeyEvent.DOM_VK_2:
                    update_pin_code_dialog(2);
                    break;
                case KeyEvent.DOM_VK_3:
                    update_pin_code_dialog(3);
                    break;
                case KeyEvent.DOM_VK_4:
                    update_pin_code_dialog(4);
                    break;
                case KeyEvent.DOM_VK_5:
                    update_pin_code_dialog(5);
                    break;
                case KeyEvent.DOM_VK_6:
                    update_pin_code_dialog(6);
                    break;
                case KeyEvent.DOM_VK_7:
                    update_pin_code_dialog(7);
                    break;
                case KeyEvent.DOM_VK_8:
                    update_pin_code_dialog(8);
                    break;
                case KeyEvent.DOM_VK_9:
                    update_pin_code_dialog(9);
                    break;
                default:
                    break;
            }
            /* input the 4th number */

    		if(RegionCode == eRegionCode.PLF_OPT_REGION_RUSSIA)
    		{
            	if ($("#pwd_3").hasClass("pwd_done_AOC")) {
                	/* confirm the input pin code is correct or not? */
                	update_pin_code_status();
                	if (correct_pin_code == true) {
                    	back_to_last_active_mode();
                    	show_colourbar();
                    	/* confirm ok, lock/unlock the channel */
                    	lock_unlock_channel();
                		}
            	}    
    		}
			else
			{
            if ($("#pwd_3").hasClass("pwd_done")) {
                /* confirm the input pin code is correct or not? */
                update_pin_code_status();
                if (correct_pin_code == true) {
                    back_to_last_active_mode();
                    show_colourbar();
                    /* confirm ok, lock/unlock the channel */
                    lock_unlock_channel();
                }
            }
			}
        }
        catch (err) {
            console.log("error for set channel id!");
            console.log(err);
        }
        return false;
    }
}
function set_pin_code_confirm_fail() {
    /* set title */
    var str = getTranslate(option_channle_islock.QT_INCORRECT_PIN);
    set_pin_code_title(str.replace("\\n", "<br/>"));
    /* reset PIN CODE dialog */
    reset_pin_code_osd_class();
    /* notice msg: not to use default password */
    var msg = getTranslate(option_channle_islock.QT_PIN_0000);
    set_pin_code_msg(msg);
    /* reset first_enter_pin_code to default */
    first_enter_pin_code = DEFAULT_PWD;
}
function set_new_pin_code() {
    /* enter pin code is valid ? */
    if (get_pin_code_value() == DEFAULT_PWD) {
        set_pin_code_confirm_fail();
    }
    /* valid PIN CODE */
    else {
        var osd_pin_code_val = get_pin_code_value();
        /* first enter PIN CODE, show confirm again */
        if (first_enter_pin_code == DEFAULT_PWD) {
            /* save first PIN CODE */
            first_enter_pin_code = osd_pin_code_val;
            /* show confirm dialog */
            set_confirm_pin_code();
        }
        else if (first_enter_pin_code == osd_pin_code_val) {
            /* confirm ok */
            /* save password */
            set_password(first_enter_pin_code);
            /* hide pin code dialog */
            close_pin_code_dialog();
            /* save pin code status */
            correct_pin_code = true;
        }
        else {
            /* confirm fail */

            set_pin_code_confirm_fail();
        }

    } /* else */
}
function set_confirm_pin_code() {
    /* set title */
    var str = getTranslate(option_channle_islock.QT_CONFIRM_PIN);
    set_pin_code_title(str);
    /* reset PIN CODE dialog */
    reset_pin_code_osd_class();
    return;
}
function update_pin_code_status() {

    /* default password need set new pin code by user */
    if (is_default_password() == true) {
        set_new_pin_code();
        return;
    }

    if (is_pin_code_correct() == true) {
        /* hide pin code dialog */
        setTimeout(function() {
            close_pin_code_dialog();
        },
        500);
        /* save pin code status */
        correct_pin_code = true;
    }
    else {
        /* save pin code statue */
        correct_pin_code = false;
        /* confirm fail, set error msg */
        var str = getTranslate(option_channle_islock.QT_INCORRECT_PIN);
        set_pin_code_title(str.replace("\\n", "<br/>"));
        /* reset pin code dialog */
        setTimeout(function(){reset_pin_code_osd_class();
        },
        500);
    }
    return null;
}
function get_passsord() {
    var pwd = null;
    pwd = mtvObj.getPassword();
    return pwd;
}
function set_password(pwd) {
    mtvObj.setPassword(pwd);
    set_pin_mode(PIN_CODE_SET);
    return;
}
function get_pin_mode() {
    return mtvObj.getPinMode();
}
function set_pin_mode(mode) {
    return mtvObj.setPinMode(mode);
}
function is_pin_code_correct() {
    return (get_pin_code_value() == get_passsord());
}
function is_default_password() {
    if (PIN_CODE_NOT_SET == get_pin_mode()) {
        return true;
    }
    return false;
}
var t_timer = null;

var b_delay_finish = true;

function reset_delay_ch_num_osd(svl_id, ch_id, mask, mask_val, mode) {
 	b_delay_finish = false;
    if (t_timer == null) {
        t_timer = setTimeout(function() {
            delay_function(svl_id, ch_id, mask, mask_val, mode);
 			b_delay_finish = true;
        },
        3000);
    }
    else {
        clearTimeout(t_timer);
        t_timer = setTimeout(function() {
            delay_function(svl_id, ch_id, mask, mask_val, mode);
 			b_delay_finish = true;
        },
        3000);
    }
}

function delay_function(svl_id, ch_id, mask, mask_val, mode) {
    console.log("delay_function svl_id:" + svl_id + "ch_id" + ch_id + "mask:" + mask + "mask_val:" + mask_val + "mode:" + mode);

    var major_num = get_channel_num_osd_value();
    var minor_num = get_channel_num_minor_osd_value();
    var ch_id = -1;
    /* one channel list case */
    if (!is_dvbs_channel_by_svl_id(svl_id) && parseInt(mtvObj.getOclStatus())) {
        if (mode == ModeList.Mode_TV_normal_favorite && "GBR" != this.mtvObj.getCurrentCountry()) {
            idx = major_num < g_channel_cnt ? major_num - 1 : g_channel_cnt - 1;
            if (idx < 0) {
                idx = 0;
            }
            var ch_info = get_fav_channel_info_by_idx(svl_id, mask, mask_val, idx);
            ch_id = ch_info.ITEMS[0].CHANNEL_ID;
        } else {
            var idx = mtvObj.getOclNearestIdxByMajor(mask, mask_val, major_num);
            var ch_info = mtvObj.getOclChannelInfoByDbIdx(mask, mask_val, idx);
            ch_id = ch_info.ITEMS[0].CHANNEL_ID;
        }

    }
    else {
        //favorite
        if (mode == ModeList.Mode_TV_normal_favorite && "GBR" != this.mtvObj.getCurrentCountry()) {
            idx = major_num < g_channel_cnt ? major_num - 1 : g_channel_cnt - 1;
            if (idx < 0) {
                idx = 0;
            }
            var ch_info = get_fav_channel_info_by_idx(svl_id, mask, mask_val, idx);
            ch_id = ch_info.ITEMS[0].CHANNEL_ID;
        } else {
            if(_bIsSupportTwoPartChannelNumber())
            {
            	if(minor_num != 0)
            	{
                	ch_id = (((major_num & 0x3fff) << 18)|((minor_num & 0x3ff) << 8));
                }
                else
                {
                	ch_id = (((major_num & 0x3fff) << 18)|0x80);
                }
            }
            else
            {
                ch_id = get_channel_id_by_major_num(major_num);
            }
            var chObj_next = mtvObj.getChannelListEx(svl_id, ch_id, mask, mask_val, DirectionList.Direction_next, 1);
            var next_major_num = chObj_next[0].MAJOR_NUM;
            var next_ch_id = chObj_next[0].CHANNEL_ID;
            var chObj_pre = mtvObj.getChannelListEx(svl_id, ch_id, mask, mask_val, DirectionList.Direction_pre, 1);
            var pre_major_num = chObj_pre[0].MAJOR_NUM;
            var pre_ch_id = chObj_pre[0].CHANNEL_ID;
            //if(_bIsSupportTwoPartChannelNumber() == false)
                //ch_id = (Math.abs(next_major_num - major_num)) > (Math.abs(major_num - pre_major_num)) ? pre_ch_id : next_ch_id;
            if(next_major_num == major_num) {
            	ch_id = next_ch_id;
            }
            else if (pre_major_num == major_num) {
            	ch_id = pre_ch_id;
            }
            else {
            	ch_id = 0;
            }
	        
        }
    }
    if(ch_id != 0)
    {
        focus_channel_by_ch_id(svl_id, ch_id, mask, mask_val, mode);
        //adjust channel page idx
        /* hide channel num OSD */
        hide_channel_num_osd();
        reset_channel_num_osd_class();
        change_channel_by_channel_id(ch_id);
    }
    else
    {
        hide_channel_num_osd();
        reset_channel_num_osd_class();
    }
    mtvObj.setOclToggleType(OCL_TOGGLE_TYPE_OFF);
}
function get_channel_id_by_major_num(maj_num) {
    /* Bitwise Left Shift */
    var ch_id = maj_num << 18;
    return ch_id;
}
function focus_channel_by_ch_id(svl_id, ch_id, mask, mask_val, mode) {
    var index=0;
    //get from first channel
    if(mode == ModeList.Mode_TV_normal_favorite){
        var idx = get_fav_index_by_channel_id(svl_id, mask, mask_val, ch_id);
         index=idx;
         if(idx>0){
            idx--;
         }
        var ch_info = get_fav_channel_info_by_idx(svl_id, mask, mask_val, idx);
    } else {
        var idx = get_index_by_channel_id(svl_id, mask, mask_val, ch_id);
         index=idx;
         if(idx>0){
            idx--;
         }
        var ch_info = get_channel_info_by_idx(svl_id, mask, mask_val, idx);
    }
     $("#channel_list_ul").html(""); 
    
      if(index==0){
            $('.class_arrow_up').eq(0).hide();
            $('#id_div_up_bk').eq(0).hide();
       }else if(index>g_channel_cnt-8){
            $('.class_arrow_down').eq(0).hide();
            $('#id_div_down_bk').eq(0).hide();
       }else{
           $('.class_arrow_up').eq(0).show();
           $('#id_div_up_bk').eq(0).show();
           $('.class_arrow_down').eq(0).show();
           $('#id_div_down_bk').eq(0).show();
       }
       var direction = DirectionList.Form_next;


    carousel_add_channel_items(active_mode, ch_info.ITEMS[0].SVL_ID, ch_info.ITEMS[0].CHANNEL_ID, direction, CAROUSEL_ITEM_CNT);
        var item_cards = $(".channel_list li");
     if(index>0){
         $(item_cards[1]).attr("class", "active");
     }else{
         $(item_cards[0]).attr("class", "active");
     }   
    var active_card=$(".channel_list li.active");
    startScroll(active_card);

}
function focus_channel_card_by_idx(idx) {
    var item_cards = $(".channel_list li");

    if (item_cards.length <= 0)
        return;
    $(item_cards[idx]).attr("class", "active");
}

var set_channel_carousel = function(target, list, dir) {
    var target = $('#channel_list_ul');

    var channel_name = '';
	if(dir == DirectionList.Direction_pre){
        list.reverse();
    }
    $.each(list, function(k, ch) {
        var id = 'channel_list_ul'+k;
        
		mtvObj.acfgSetConfigString("g_custom_base__query_channel_logo", ch.CH_LOGO_ID);  //Felix 20170630 add for query ch logo
        var logo = mtvuiUtil.getChannelLogoSrc(ch.CH_LOGO_ID);
        
        var logo_div;
        var ch_name = ch.SERVICE_NAME;
        var ch_num = ch.MAJOR_NUM;
        var ch_mask = parseInt(ch.NW_MASK);
        var is_favorite  = (MaskList.Mask_favorite & ch_mask) == MaskList.Mask_favorite;
        var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
		var opt_mask     = parseInt(ch.OPTION_MASK);
		var is_scrambled = ((MaskList.Mask_scrambled & ch_mask) == MaskList.Mask_scrambled)/*||((SB_VOPT_CAM_SVC&opt_mask)==SB_VOPT_CAM_SVC)*//* 20171107 fix TF518PHIEUMTK05-1264*/;       
		if(is_favorite){
			var is_new   =false;
		}else{
		var is_new       = (MaskList.Mask_new & ch_mask) == MaskList.Mask_new;
		}
        if(ch.hasOwnProperty('MINOR_NUM')&&ch.MINOR_NUM){
            ch_num = ch.MAJOR_NUM+'.'+ch.MINOR_NUM;
        }
        var logoBg = 'class_logo_null';
        if (is_favorite && !is_lock) {
            logoBg = 'class_logo_fav';
        } else if (!is_favorite && is_lock) {
            logoBg = 'class_logo_lock';
        }else if(is_favorite && is_lock) {
            logoBg = 'class_logo_all';
        }else if(is_new){
            logoBg = 'class_logo_lock';
        }

            ch_num=ch_num+"&nbsp;&nbsp;";
        if(is_disable_move_fct()){
         if(logo){
            //ch_name = ch_num+"&nbsp;&nbsp;"+ch_name;
            logo_div ='<div style="width: 60px;height: 34px;top: 7px;left: 4.5px;position: absolute;/*background-color: #676767;*/"><div style="width: 60px;height: 34px;position: absolute;background:url('+logo+');background-size: 60px 34px;"></div></div>';
			}else {
				logo_div = ' <div style="width: 60px;height: 34px;top: 7px;left: 4.5px;position: absolute;/* background-clip: border-box; */background-size: 60px 34px;"></div>';
        }
         }else{
         	if(logo){
            	//ch_name = ch_num+"&nbsp;&nbsp;"+ch_name;
            	logo_div = ' <div style="width: 52px;height: 40px;top: 4px;left: 8.5px;position: absolute;background:url('+logo+');/* background-clip: border-box; */background-size: 52px 40px; /*background-color: #676767;*/"></div>';

			}else {
            	logo_div = ' <div style="width: 52px;height: 40px;top: 4px;left: 8.5px;position: absolute;/* background-clip: border-box; */background-size: 52px 40px;"></div>';
         	}
        }
        var fav_div='<div class="icon_fav_div" ></div>';
        if (is_favorite)
        {
            fav_div ='<div class="icon_fav_div fav_icon"></div>';
        }
        var lock_div='<div class="icon_lock_div"></div>';
        if(is_new){
			lock_div ='<div class="icon_lock_div new_icon_right"></div>';
		}
        if (!is_favorite && is_lock) {
            lock_div ='<div class="icon_lock_div lock_icon_right"></div>';
        }else if(is_favorite && is_lock) {
            lock_div ='<div class="icon_lock_div lock_icon_left"></div>';
        }

        var scrambled_span='<span></span>';
        if(is_scrambled){
            scrambled_span='<span class="channel_list_span"></span>';
        }
        var cur_div_id='channel_show_item'+k;
	var overlay_div = '<div class="icon_overlay_div"></div>';
        if(is_scrambled){
            var channel_item = '<li id="'+id+'" svl_id="' + ch.SVL_ID + '" channel_id="' + ch.CHANNEL_ID + '" channel_num="' + ch_num + '" channel_mask="' + ch_mask + '" channel_idx="' + ch.INDEX + '" tabindex="0" onfocus="channel_list_item_focus(true, "'+id+'")" onblur="channel_list_item_focus(false, "'+id+'")">\
            <div id="'+cur_div_id+'" class="icon_div '+logoBg+'" >'+logo_div+fav_div+lock_div+overlay_div+'</div>\
            <div style="float:left;margin-top:1px;height: 59px;display: table-cell;vertical-align: middle;">\
            <p style="font-size:21px;position: relative;top: 5px;padding:0px;margin:0px;line-height: 36px;text-overflow: ellipsis;white-space: nowrap;overflow: hidden;width: 285px;">'+ch_num+'<span id="ch_name">'+ch_name+'</span></p>'+scrambled_span+'</div>\
            </li>';
        }else{
            var channel_item = '<li id="'+id+'" svl_id="' + ch.SVL_ID + '" channel_id="' + ch.CHANNEL_ID + '" channel_num="' + ch_num + '" channel_mask="' + ch_mask + '" channel_idx="' + ch.INDEX + '" tabindex="0" onfocus="channel_list_item_focus(true, "'+id+'")" onblur="channel_list_item_focus(false, "'+id+'")">\
            <div id="'+cur_div_id+'" class="icon_div '+logoBg+'" >'+logo_div+fav_div+lock_div+overlay_div+'</div>\
            <div style="float:left;margin-top:1px;height: 59px;display: table-cell;vertical-align: middle;">\
            <p style="font-size:21px;position: relative;top: 2px;padding:0px;margin:0px;line-height: 59px;text-overflow: ellipsis;white-space: nowrap;overflow: hidden;width: 285px;">'+ch_num+'<span id="ch_name">'+ch_name+'</span></p>'+scrambled_span+'</div>\
            </li>'; 
        }
      

        if (dir == DirectionList.Direction_pre) {
          $(channel_item).prependTo(target);
        if($('#channel_list_ul li').length >8){
           $("#channel_list_ul>li:last-child").remove();
        }

        } else {
            $(channel_item).appendTo(target);
            if($('#channel_list_ul li').length >8){
                $("#channel_list_ul>li:first-child").remove();
            }

        }

    });
};

var set_find_channel_carousel = function(target, list, find_ch_name) {
    var item = null;
    var count = 0;
    target.html(""); /* clean all items */
    console.log("find_ch_name:" + find_ch_name);
    $.each(list, function(k, ch) {
        if (null == item)
            item = $('<div class="item" />');
        /* if there is no icon then use default icon. */
        var logo = mtvuiUtil.getChannelLogoSrc(ch.CH_LOGO_ID);
        var icon = '<div class="card-image">' + (logo ? '<img src="' + logo + '" />' : '') + '</div>';

        var ch_name = ch.SERVICE_NAME ? ch.SERVICE_NAME : "-----";
        var icon_favorite = "./res/ChannelList/Icon_Favorite_Small.png";
        var icon_lock = "./res/ChannelList/Icon_Lock_Small.png";
        var icon_scrambled = "./res/ChannelList/Icon_Scrambled_Small.png";
        var icon_new = "./res/ChannelList/Icon_New_Small.png";
        /* draw find channel card */
        console.log("ch_name.indexOf(find_ch_name):" + ch_name.indexOf(find_ch_name));
        if (ch_name.indexOf(find_ch_name) > -1) {
            var card = $('<div class="card channel" align="center"  channel_id="' + ch.CHANNEL_ID + '" channel_num="' + ch.MAJOR_NUM + '" channel_name="' + ch.SERVICE_NAME + '">\
            <div class="card-favorite-icon" id="favorite-show-hide"><img src="' + icon_favorite + '" /></div>\
            <div class="card-new-icon"><img src="' + icon_new + '" /></div>\
            <div class="card-content" align="left"><span>' + ch.MAJOR_NUM + '</span></div>\
            <div class="card-lock-icon"><img src="' + icon_lock + '" /></div>\
            ' + icon + '\
            <div class="card-content"><span>' + ch_name + '</span></div>\
            <div class="card-scrambled-icon"><img /></div>\
            </div>');

            var ci = $('<div class="col-md-3 col-sm-6" style="height:122px;;"></div>');
            card.appendTo(ci);
            ci.appendTo(item);
            count++;
            if (item && (0 == (count % 10))) {
                item.appendTo(target);
                item = null;
            }

        }
    });

    if (null != item)
        item.appendTo(target);
    its = target.find(".item");
    if (its.length > 0)
        $(its[0]).addClass("active");


};

function save_last_active_idx(idx) {
    switch (parseInt(get_cur_ch_list_type())) {
        case ChannelListTypeList.ChannelListType_tv_favorite:
        case ChannelListTypeList.ChannelListType_satellite_favorite:
            fav_list_selected_idx = idx;
            break;
        case ChannelListTypeList.ChannelListType_tv_all:
        case ChannelListTypeList.ChannelListType_satellite_all:
            all_list_selected_idx = idx;
            break;
        case ChannelListTypeList.ChannelListType_tv_radio:
        case ChannelListTypeList.ChannelListType_satellite_radio:
            radio_list_selected_idx = idx;
            break;
        case ChannelListTypeList.ChannelListType_tv_new:
        case ChannelListTypeList.ChannelListType_satellite_new:
            new_list_selected_idx = idx;
            break;
        case ChannelListTypeList.ChannelListType_satellite_tv:
            tv_list_selected_idx = idx;
            break;
        default:
            all_list_selected_idx = idx;
            break;
    }
}

function show_or_hide_arrow(){
        var nw_mask = get_current_mask();
        var mask_value = get_current_mask_value();
        //var svl_id= $('.channel_list li.active').eq(0).attr('svl_id');
        //var ch_id= $('.channel_list li.active').eq(0).attr('channel_id');
        var ch = mtvObj.getCurrentChannelInfoForEachTuner();
        //var chObj_next = mtvObj.getChannelListEx(ch.SVL_ID, ch.CHANNEL_ID, nw_mask, mask_value, DirectionList.Direction_next, 1);
        //var chObj_pre = mtvObj.getChannelListEx(ch.SVL_ID, ch.CHANNEL_ID, nw_mask, mask_value, DirectionList.Direction_pre, 1);

       // g_channel_cnt = get_channel_count(ch.SVL_ID, nw_mask, mask_value);
        if (g_channel_cnt<=0) {
            return false;
        }
        if (g_channel_cnt<=8) {
            $('.class_arrow_up').eq(0).hide();
            $('#id_div_up_bk').eq(0).hide();
            $('.class_arrow_down').eq(0).hide();
            $('#id_div_down_bk').eq(0).hide();
        }else {
         if (is_first_channel||is_need_hide_up) {
                $('.class_arrow_up').eq(0).hide();
                $('#id_div_up_bk').eq(0).hide();
                $('.class_arrow_down').eq(0).show();
                $('#id_div_down_bk').eq(0).show();
				is_need_hide_up=false;
            }else if (is_last_channel||is_need_hide_dowm) {
                $('.class_arrow_up').eq(0).show();
                $('#id_div_up_bk').eq(0).show();
                $('.class_arrow_down').eq(0).hide();
                $('#id_div_down_bk').eq(0).hide();
				is_need_hide_dowm=false;
            }else{             
                $('.class_arrow_up').eq(0).show();
                $('#id_div_up_bk').eq(0).show();
                $('.class_arrow_down').eq(0).show();
                $('#id_div_down_bk').eq(0).show();             
            }
        }
}
var category_list_key_proc = function(kc){	//Ryan Add Packs/Categories for Telekarta
	var CurIndex =  $('#catMenu_list').find(' .focus').index();
	li_list = $('#catMenu_list').find('li');
    if (key == KeyEvent.DOM_VK_DOWN) {
		if(CurIndex == li_list.length -1)
		{
			$('#catMenu_list li:nth-child(' + (1) + ')').focus();
		}
		else
		{
		    $('#catMenu_list li:nth-child(' + (CurIndex + 2) + ')').focus();
		}
	}
	else if(key == KeyEvent.DOM_VK_UP)
	{
		if(CurIndex == 0)
		{
			$('#catMenu_list li:nth-child(' + (li_list.length) + ')').focus();
		}
		else
		{
			$('#catMenu_list li:nth-child(' + (CurIndex) + ')').focus();
		}
	}
	else if(key == KeyEvent.DOM_VK_RETURN)
    {
        var AllCATlist = mtvObj.acfgGetConfigString("g_custom_base__category_name");
        var SelectcategoryNam;
        //var id = "catMenu_list_li_" + CurIndex;
        if(nPackType == 1)
        {
            SelectcategoryName = Packsfilter[CurIndex];
            set_channel_list_type(CUST_CH_LIST_TYPE_PACKS);
        }
        else if (nPackType == 2)
        {
            SelectcategoryName = CATEGORYfilter[CurIndex];
            set_channel_list_type(CUST_CH_LIST_TYPE_CAT);
        }
        else if (nPackType == 3)
        {
            SelectcategoryName = GROUPSfilter[CurIndex];
            set_channel_list_type(CUST_CH_LIST_TYPE_GROUPS);
        }
            
        var SearchIndex = AllCATlist.indexOf(SelectcategoryName);
        /*20180601 [TF518PHIEUMTK01-5992] [lab_NTVplus] (6) incorrect translation into Russian : group other*/
		/*HTV_APP_CATEGORY_OTHER -> FAV_NETWORK_NLD_OTHERS*/
        if(SelectcategoryName == getTranslate("FAV_NETWORK_NLD_OTHERS"))
        {
            BATID = DVBS_NTV_PLUS_Other_BATid;
            mtvObj.acfgSetConfigValue("g_custom_base__bat_id", BATID);
        }
        if (SearchIndex >= 0) {
            var BATID = AllCATlist.substr( SearchIndex + SelectcategoryName.length +1, 4 );
            if((nPackType == 3) &&(BATID.indexOf(",") != -1))
            {
                BATID = BATID.substr(0, BATID.indexOf(","));
            }
            //var b = mtvObj.acfgSetConfigValue("g_custom_base__bat_id", BATID);
            BATID = parseInt(BATID);
            mtvObj.acfgSetConfigValue("g_custom_base__bat_id", BATID);
            var index = AllCATlist.substr( AllCATlist.indexOf("_"+BATID+",")+BATID.toPrecision().length+2,3);

            index = index.match(/\d+/);
            var category_mask = 0x01 << parseInt(index);
            mtvObj.acfgSetConfigValue("g_custom_base__category_mask", category_mask);
        }

        $('#catMenuid').hide();

        init_ch_list_by_chlist_type();
        
    }
	//else if(key == KeyEvent.DOM_VK_BLUE)  //for test. Set to NVM or not?
	//{
		//var a = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
	//}
}
var dialog_choose_key_proc = function(kc) {

   var key = kc.which || kc.keyCode;
   var items = document.getElementsByClassName('choose_list');
   var item =$('#choose_content .focus');
   var len=items.length;
   // handle left, right key
   if (key == KeyEvent.DOM_VK_LEFT || key == KeyEvent.DOM_VK_RIGHT) {

       return false;
   }
   // handle enter, or back key
   if (key == KeyEvent.DOM_VK_RETURN) {
     item=$('#choose_content .focus');
     var id=item.attr("id");
     initTitle(id);
     $("#channel_list_ul").html("");
     $('#dialog_channel_list').hide();
     if(id=="tv_submenu_bar_1"||id=="tv_submenu_bar_0"||id=="tv_submenu_bar_2"||id=="tv_submenu_bar_3"){
         top_menu_bar_selected("top_menu_0",2, id);
     }
	 else if(id=="satellite_submenu_bar_5")    //Ryan Add Packs/Categories for Telekarta
	 {
		    //bIsPack = 1;
		    nPackType = 1;
            set_active_mode(ModeList.Mode_packs_list);
			set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_packs);
			$('#cat_left_title_first').html(getTranslate("MAIN_PACKS"));
			$('#catMenu_list').css('margin-left', '72px');
			$('#left_cat_menu_title').css('left', '-230px');
			$('#catMenu_list').empty().append('<div style="position: absolute;float: left;width: 1px;height: 482px;background-color: #ffffff;opacity: 0.1;" ></div>\
               <ul class="optionMenuDialog_ul"></ul>'); 
			
			var style = "tabindex='0'";
			var instructions = '';
			var icon = '';
			var index = 0;
			
			Packsfilter = filterItems('_43');

			for(index in Packsfilter)
			{
				var packsLength = Packsfilter[index].indexOf("_43");
				Packsfilter[index] = Packsfilter[index].substr( 0 , packsLength );
				var id = "catMenu_list_li_" + index;	
				$('#catMenu_list').find('ul').append('<li id="' + id + '"' + style + 'onfocus=focusCAT(true,"' + id + '");  onblur=focusCAT(false,"' + id + '");>\
				<div>' + icon + '<div style="  display: inline;overflow: hidden;max-width: 240px;text-align: left;float: left;"><span>' + Packsfilter[index] + '</span></div></div>' + instructions + '</li>');
			}			
			this.selected = 0;
		    $('#catMenuid').show();
			
			store_chlist_type_to_acfg();
			
			setTimeout(function() {
			$('#catMenu_list li:nth-child(' + (1) + ')').focus();
			}, 100);
	 }
	 else if(id=="satellite_submenu_bar_6") 
	 {
		    //bIsPack = 0;
		    nPackType = 2;
            set_active_mode(ModeList.Mode_category_list);
			set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_cat);
			$('#cat_left_title_first').html(getTranslate("MAIN_CATEGORIES"));
			$('#catMenu_list').css('margin-left', '72px');
			$('#left_cat_menu_title').css('left', '-230px');
			$('#catMenu_list').empty().append('<div style="position: absolute;float: left;width: 1px;height: 482px;background-color: #ffffff;opacity: 0.1;" ></div>\
               <ul class="optionMenuDialog_ul"></ul>'); 
			
			var style = "tabindex='0'";
			var instructions = '';
			var icon = '';
			var index = 0;
			
			CATEGORYfilter = filterItems('_84');

			for(index in CATEGORYfilter)
			{
				var categoryLength = CATEGORYfilter[index].indexOf("_84");
				CATEGORYfilter[index] = CATEGORYfilter[index].substr( 0 , categoryLength );
				var id = "catMenu_list_li_" + index;	
				$('#catMenu_list').find('ul').append('<li id="' + id + '"' + style + 'onfocus=focusCAT(true,"' + id + '");  onblur=focusCAT(false,"' + id + '");>\
				<div>' + icon + '<div style="  display: inline;overflow: hidden;max-width: 240px;text-align: left;float: left;"><span>' + CATEGORYfilter[index] + '</span></div></div>' + instructions + '</li>');
			}		
			this.selected = 0;
		    $('#catMenuid').show();
			
			store_chlist_type_to_acfg();
			
			setTimeout(function() {
			$('#catMenu_list li:nth-child(' + (1) + ')').focus();
			}, 100);
	 }
	 else if(id=="satellite_submenu_bar_7") 
	 {
		    //bIsPack = 0;
		    nPackType = 3;
            set_active_mode(ModeList.Mode_groups_list);
			set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_groups);
			$('#cat_left_title_first').html(getTranslate("MAIN_GROUPS"));
			$('#catMenu_list').css('margin-left', '72px');
			$('#left_cat_menu_title').css('left', '-230px');
			$('#catMenu_list').empty().append('<div style="position: absolute;float: left;width: 1px;height: 482px;background-color: #ffffff;opacity: 0.1;" ></div>\
               <ul class="optionMenuDialog_ul"></ul>'); 
			
			var style = "tabindex='0'";
			var instructions = '';
			var icon = '';
			var index = 0;
			
			GROUPSfilter = filterItems('_');

			for(index in GROUPSfilter)
			{
				var groupsLength = GROUPSfilter[index].lastIndexOf("_");
				GROUPSfilter[index] = GROUPSfilter[index].substr( 0 , groupsLength );
				var id = "catMenu_list_li_" + index;	
				$('#catMenu_list').find('ul').append('<li id="' + id + '"' + style + 'onfocus=focusCAT(true,"' + id + '");  onblur=focusCAT(false,"' + id + '");>\
				<div>' + icon + '<div style="  display: inline;overflow: hidden;max-width: 240px;text-align: left;float: left;"><span>' + GROUPSfilter[index] + '</span></div></div>' + instructions + '</li>');
			}		
			this.selected = 0;
		    $('#catMenuid').show();
			
			store_chlist_type_to_acfg();
			
			setTimeout(function() {
			$('#catMenu_list li:nth-child(' + (1) + ')').focus();
			}, 100);
	 }
	 else {
         top_menu_bar_selected("top_menu_1",2, id);
     }

       // goto to sys index, by the same time switch channel

   } else if (key == KeyEvent.DOM_VK_BACK) {
       // goto sys index
           $('#dialog_channel_list').hide();
   }
   if (key == KeyEvent.DOM_VK_DOWN) {
    if (item.next().length>0) {
     var active_div=$('#choose_content .focus');
     id=active_div.eq(0).attr('id');
     item.removeClass('focus');
     $('.music_content_div.active').removeClass('active');
     //$(active_div[0].getElementsByTagName('div')[1]).removeClass('choose_list_active');
     if (id=="tv_submenu_bar_1"||id=="tv_submenu_bar_2"||id=="tv_submenu_bar_3") {
             active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_267_Cable_TV_n_24x24_px.png";
         }else if(id=="satellite_submenu_bar_0"||id=="tv_submenu_bar_0"){
             active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_161_Favourites_n_24x24_px.png";
         }else {
             active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_153_Satellite_Channels_n_24x24_px.png";

         }
      item.next().addClass('focus');  
    $('#choose_content .focus .music_content_div').addClass('active');     
      active_div=$('#choose_content .focus');
     // $(active_div[0].getElementsByTagName('div')[1]).addClass('choose_list_active');
      id=active_div.eq(0).attr('id');
      if (id=="tv_submenu_bar_1"||id=="tv_submenu_bar_2"||id=="tv_submenu_bar_3") {
            active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_267_Cable_TV_hl_24x24_px.png";
        }else if(id=="satellite_submenu_bar_0"||id=="tv_submenu_bar_0"){
            active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_161_Favourites_hl_24x24_px.png";
        }else {
            active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_153_Satellite_Channels_hl_24x24_px.png";

        }
    } else{
      return false;
    }
     return false;
   }else if (key == KeyEvent.DOM_VK_UP) {
     if (item.prev().length>0) {
       var active_div=$('#choose_content .focus');
       id=active_div.eq(0).attr('id');
       item.removeClass('focus');
       $('.music_content_div.active').removeClass('active');
       //$(active_div[0].getElementsByTagName('div')[1]).removeClass('choose_list_active');
       if (id=="tv_submenu_bar_1"||id=="tv_submenu_bar_2"||id=="tv_submenu_bar_3") {
             active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_267_Cable_TV_n_24x24_px.png";
         }else if(id=="satellite_submenu_bar_0"||id=="tv_submenu_bar_0"){
             active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_161_Favourites_n_24x24_px.png";
         }else {
             active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_153_Satellite_Channels_n_24x24_px.png";

         }
       item.prev().addClass('focus')
       active_div=$('#choose_content .focus');
       $('#choose_content .focus .music_content_div').addClass('active'); 
       //$(active_div[0].getElementsByTagName('div')[1]).addClass('choose_list_active');
       id=active_div.eq(0).attr('id');
       if (id=="tv_submenu_bar_1"||id=="tv_submenu_bar_2"||id=="tv_submenu_bar_3") {
            active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_267_Cable_TV_hl_24x24_px.png";
        }else if(id=="satellite_submenu_bar_0"||id=="tv_submenu_bar_0"){
            active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_161_Favourites_hl_24x24_px.png";
        }else {
            active_div[0].getElementsByTagName('img')[0].src="./res/ChannelList/icon_153_Satellite_Channels_hl_24x24_px.png";

        }
     } else{
       return false;
     }
      return false;
  }
}
var g_focus;
function startScroll(id) {
    
        var item_focus=$(id).find("p");
    if (item_focus) {
        //console.log("id:" + id)
    } else {
        return;
    }
    if(g_focus){
        g_focus.html(g_focus.html().replace(/<marquee>/ig, ''));

    }
        //var item=$(item_focus).children("p");
        var tempWidth = item_focus[0].scrollWidth - item_focus[0].offsetWidth; // length of can scroll
        if(tempWidth>0){
            item_focus.html("<marquee>"+item_focus.html()+"</marquee>");
            g_focus=item_focus;
        }else{
            g_focus=null;;
        }
    
}
function endScroll(id){
      var item_focus=$(id).find("p");
       if (item_focus) {
        console.log("id:" + id)
    } else {
        return;
    }
    if(g_focus){
        g_focus.html(g_focus.html().replace(/<marquee>/ig, ''));

    }
}


function com_start_scroll(id) {
    
        var item_focus=$(id);
    if (item_focus) {
        //console.log("id:" + id)
    } else {
        return;
    }
    if(g_focus){
        g_focus.html(g_focus.html().replace(/<marquee>/ig, ''));

    }
        //var item=$(item_focus).children("p");
        var tempWidth = item_focus[0].scrollWidth - item_focus[0].offsetWidth; // length of can scroll
        if(tempWidth>0){
            item_focus.html("<marquee>"+item_focus.html()+"</marquee>");
            g_focus=item_focus;
        }else{
            g_focus=null;;
        }
    
}
function com_end_scroll(id){
      var item_focus=$(id);
       if (item_focus) {
        console.log("id:" + id)
    } else {
        return;
    }
    if(g_focus){
        g_focus.html(g_focus.html().replace(/<marquee>/ig, ''));

    }
}

function update_num_osd_icon(){
    ch_list_type = parseInt(get_channel_list_type());
	switch (ch_list_type) {
             case CUST_CH_LIST_TYPE_ALL:
                 if (current_tuner_type == TunerType_list.TunerType_tv) {
                     
					 if(mtvObj.getDtvTunerType()==1){
						$("#middle_icon").attr("src","./res/ChannelList/icon_267_Cable_TV_n_24x24_px.png");
					    $("#channel_type").text(getTranslate("MAIN_TI_CABLE_ALL")); 
					 }else{
						$("#middle_icon").attr("src","./res/ChannelList/icon_267_Cable_TV_n_24x24_px.png");
					    $("#channel_type").text(getTranslate("MAIN_TI_ANTENNA_ALL"));  
					 }
                 }
                 else {
                     $("#middle_icon").attr("src","./res/ChannelList/icon_153_Satellite_Channels_n_24x24_px.png");
					 $("#channel_type").text(getTranslate("MAIN_TI_SAT_ALL"));
                 }
                 break;
             case CUST_CH_LIST_TYPE_RADIO:
                 if (current_tuner_type == TunerType_list.TunerType_tv) {
                     if(mtvObj.getDtvTunerType()==1){
						$("#middle_icon").attr("src","./res/ChannelList/icon_267_Cable_TV_n_24x24_px.png");
					    $("#channel_type").text(getTranslate("MAIN_CABLE_RADIO_CHANNELS")); 
					 }else{
						$("#middle_icon").attr("src","./res/ChannelList/icon_267_Cable_TV_n_24x24_px.png");
					    $("#channel_type").text(getTranslate("MAIN_ANTENNA_RADIO_CHANNELS"));  
					 }
                 }
                 else {
                     $("#middle_icon").attr("src","./res/ChannelList/icon_153_Satellite_Channels_n_24x24_px.png");
					 $("#channel_type").text(getTranslate("MAIN_SATELLITE_RADIO_CHANNELS"));
                 }
                 break;
             case CUST_CH_LIST_TYPE_FAVORITE:
                 if (current_tuner_type == TunerType_list.TunerType_tv) {
                      if(mtvObj.getDtvTunerType()==1){
						$("#middle_icon").attr("src","./res/ChannelList/icon_161_Favourites_n_24x24_px.png");
					    $("#channel_type").text(getTranslate("MAIN_CABLE_FAVOURITES")); 
					 }else{
						$("#middle_icon").attr("src","./res/ChannelList/icon_161_Favourites_n_24x24_px.png");
					    $("#channel_type").text(getTranslate("MAIN_ANTENNA_FAVOURITES"));  
					 }
                 }
                 else {
                     $("#middle_icon").attr("src","./res/ChannelList/icon_161_Favourites_n_24x24_px.png");
					 $("#channel_type").text(getTranslate("MAIN_SATELLITE_FAVOURITES"));
					 
                 }
                 break;
             case CUST_CH_LIST_TYPE_NEW:
                 if (current_tuner_type == TunerType_list.TunerType_tv) {
                     if(mtvObj.getDtvTunerType()==1){
						$("#middle_icon").attr("src","./res/ChannelList/icon_267_Cable_TV_n_24x24_px.png");
					    $("#channel_type").text(getTranslate("MAIN_CABLE_NEW_CHANNELS")); 
					 }else{
						$("#middle_icon").attr("src","./res/ChannelList/icon_267_Cable_TV_n_24x24_px.png");
					    $("#channel_type").text(getTranslate("MAIN_ANTENNA_NEW_CHANNELS"));  
					 }
                 }
                 else {
                     $("#middle_icon").attr("src","./res/ChannelList/icon_153_Satellite_Channels_n_24x24_px.png");
					 $("#channel_type").text(getTranslate("MAIN_SATELLITE_NEW_CHANNELS"));
                 }
                 break;
             case CUST_CH_LIST_TYPE_TV:
                 if (current_tuner_type == TunerType_list.TunerType_tv) {
                    if(mtvObj.getDtvTunerType()==1){
						$("#middle_icon").attr("src","./res/ChannelList/icon_267_Cable_TV_n_24x24_px.png");
					    $("#channel_type").text(getTranslate("MAIN_TI_CABLE_ALL")); 
					 }else{
						$("#middle_icon").attr("src","./res/ChannelList/icon_267_Cable_TV_n_24x24_px.png");
					    $("#channel_type").text(getTranslate("MAIN_TI_ANTENNA_ALL"));  
					 }
                 }
                 else {
                     $("#middle_icon").attr("src","./res/ChannelList/icon_153_Satellite_Channels_n_24x24_px.png");
					 $("#channel_type").text(getTranslate("MAIN_SATELLITE_SELECTED"));
                 }
                 break;
		    case CUST_CH_LIST_TYPE_PACKS:  //Ryan Add Packs/Categories for Telekarta
                     $("#middle_icon").attr("src","./res/ChannelList/icon_153_Satellite_Channels_n_24x24_px.png");
					 $("#channel_type").text(getTranslate("MAIN_PACKS"));
			break;
		    case CUST_CH_LIST_TYPE_CAT:  //RyanChungAddCR
                     $("#middle_icon").attr("src","./res/ChannelList/icon_153_Satellite_Channels_n_24x24_px.png");
					 $("#channel_type").text(getTranslate("MAIN_CATEGORIES"));
		    case CUST_CH_LIST_TYPE_GROUPS:  //Kana
                     $("#middle_icon").attr("src","./res/ChannelList/icon_153_Satellite_Channels_n_24x24_px.png");
					 $("#channel_type").text(getTranslate("MAIN_GROUPS"));
			break;
         }	
}
 
 var idx = -1;
 var is_last_channel=false;
 var is_first_channel=false;
 var is_need_hide_up=false;
 var is_need_hide_dowm=false;
 var is_all_chFavList_del=false;	/* 20170728 [TF518PHIEUMTK01-378] remove all favorite channels still shows Unmark as favorites */
var tv_normal_all_key_proc = function(kc) {
    var item_cards = $(".channel_list li");
    var active_card = kc.target.find(".channel_list li.active");
    var next_card=active_card.next();
    var pre_card=active_card.prev();
    var key = kc.keyCode || kc.which;
    var svl_id = next_card.attr("svl_id");
    var ch_id=next_card.attr("channel_id");
    var mask=next_card.attr("channel_mask");
    var svl_id_pre = pre_card.attr("svl_id");
    var ch_id_pre=pre_card.attr("channel_id");
    var mask_pre=pre_card.attr("channel_mask");
    var index =1;
    var g_mtvObj = new MtvObj(); // Randy.xiao add for CUL event id 27
    if (active_card.length > 0)
         idx = $.inArray(active_card[0], item_cards);

          // handle left, right key
          index=idx;
    if (key == KeyEvent.DOM_VK_LEFT || key == KeyEvent.DOM_VK_RIGHT) {
              if (active_card.length <= 0) {

                  $('#id_div_ch_type').removeClass('active');
                  var active_card=item_cards.eq(idx).addClass('active');
				  var endScroll_id=$('#id_div_ch_type>.type_mid');
				  com_end_scroll(endScroll_id); 
                  startScroll(active_card);
              } else {
				  endScroll(active_card);
				  var startScroll_id=$('#id_div_ch_type>.type_mid');
				  com_start_scroll(startScroll_id);
                  item_cards.removeClass('active');
                  $('#id_div_ch_type').addClass('active');
                  $('#ColorKey_Green').html('');
              }
              reset_colourbar();
              return false;
          }
        /* handle DOWN key */
        if (key == KeyEvent.DOM_VK_DOWN) {
            if(active_card.length <= 0){
				var endScroll_id=$('#id_div_ch_type>.type_mid');
				com_end_scroll(endScroll_id); 
				$('#id_div_ch_type').removeClass('active');
				idx=-1;
            }
            if(index==7||index==g_channel_cnt-1){
                return false;
            }
            if(index<6){
                index+=1;
            }
          idx += 1;
          if (index >= (item_cards.length-2)) {
              if(item_cards.length != 1){
                  if(idx>=7){
                is_last_channel= carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_next,1);
                item_cards = kc.target.find(".channel_list li");
				var svl_id_next=item_cards.eq(7).attr("svl_id");
				var ch_id_next=item_cards.eq(7).attr("channel_id");
				var nw_mask_next=get_current_mask();
				var mask_value_next= get_current_mask_value();
				var idx_next = get_index_by_channel_id(svl_id_next, nw_mask_next, mask_value_next, ch_id_next);
                if(idx_next==g_channel_cnt-1){
					is_need_hide_dowm=true;
				}
				// var chObj_next = mtvObj.getChannelListEx(svl_id_next, ch_id_next, nw_mask_next, mask_value_next, DirectionList.Direction_next, 1);
                idx = item_cards.length - 1;
				
                show_or_hide_arrow();
                }
                if(is_last_channel){
                    index=7;
                    is_last_channel=false;
                    
                }
             }else {
                 idx -= 1;
             }
         }
        }
        /* handle UP key */
        else if (key == KeyEvent.DOM_VK_UP) {
            if (active_card.length <= 0) {
                    return false;
                }
          idx -= 1;
          if(index>1){
              index-=1;
          }
            /* save last selected idx */
            if (index <=1) {
                if(item_cards.length != 1){
                    if(index==0){
                            endScroll(active_card);
							var startScroll_id=$('#id_div_ch_type>.type_mid');
						    com_start_scroll(startScroll_id);
                            item_cards.removeClass('active');
                            $('#id_div_ch_type').addClass('active');
                            $('#ColorKey_Green').html('');
                            return false;
                    }
                       if(idx<=0){
                        is_first_channel=carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id_pre,ch_id_pre,DirectionList.Direction_pre,1);
                        item_cards = kc.target.find(".channel_list li");
						var svl_id_pre=item_cards.eq(0).attr("svl_id");
				        var ch_id_pre=item_cards.eq(0).attr("channel_id");
				        var nw_mask_pre=get_current_mask();
				        var mask_value_pre= get_current_mask_value();
				        var idx_pre = get_index_by_channel_id(svl_id_pre, nw_mask_pre, mask_value_pre, ch_id_pre);
                        if(idx_pre==0){
					         is_need_hide_up=true;
				        }
                        idx=0;
                        
                        show_or_hide_arrow();
                        }
                        if (is_first_channel) {
                            index=0;
                            is_first_channel=false;
                            //show_or_hide_arrow();

                            //item_cards.removeClass('active');
                           // $('#id_div_ch_type').addClass('active');
                            //$('#ColorKey_Green').html('');
                            //return false;
                        }
                }else {
                    item_cards.removeClass('active');
                    $('#id_div_ch_type').addClass('active');
                    $('#ColorKey_Green').html('');
                    return false;
                }
            }
        }
		else if(key == KeyEvent.DOM_VK_CH_DECREASE){
			var cur_page_last_item=item_cards.eq(7);
			if(cur_page_last_item.length>0){
				svl_id =cur_page_last_item.attr("svl_id");
				ch_id  =cur_page_last_item.attr("channel_id");
				var cur_idx = get_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
				if(cur_idx==g_channel_cnt-1){
					return false;
				}else if(cur_idx>=g_channel_cnt-9){
				    is_need_hide_dowm=true;
				}
				mun =Math.min(g_channel_cnt-cur_idx, CAROUSEL_ITEM_CNT);
			    active_card.removeClass("active");
				carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_next,mun);
				item_cards=$(".channel_list li");
				item_cards.eq(1).addClass("active");
				show_or_hide_arrow();
				startScroll($('.channel_list li.active'));
				return false;
			}else{
				return false;
			}
		}
		else if(key == KeyEvent.DOM_VK_CH_INCREASE){
			var cur_page_frist_item=item_cards.eq(0);
			if(cur_page_frist_item.length>0){
				svl_id =cur_page_frist_item.attr("svl_id");
				ch_id  =cur_page_frist_item.attr("channel_id");
				var cur_idx = get_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
				if(cur_idx==0){
					return false;
				}else if(cur_idx<=8){
                    is_need_hide_up=true;
                }
				
			    active_card.removeClass("active");
				carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_pre,CAROUSEL_ITEM_CNT);
				item_cards=$(".channel_list li");
				item_cards.eq(1).addClass("active");
				show_or_hide_arrow();
				startScroll($('.channel_list li.active'));
				
				return false;
			}else{
				return false;
			}
		}

        /* handle GREEN key */
        else if (key == KeyEvent.DOM_VK_GREEN ) {
            //DOM_VK_PAGE_UP
            console.log("REC: DOM_VK_GREEN key");

            if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
                console.log(channel_id);
                try {
                 svl_id = $(active_card[0]).attr("svl_id");
                 ch_mask = $(active_card[0]).attr("channel_mask");
                 var is_new = (MaskList.Mask_new & ch_mask) == MaskList.Mask_new;
                 var is_favorite  = (MaskList.Mask_favorite & ch_mask) == MaskList.Mask_favorite;
                 var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                 if (is_new) {
                     /* hidden new icon */
                     //$('[channel_id="' + channel_id + '"] .card-new-icon').hide();
                     $(active_card[0]).removeClass("active");
                 }
                  set_favorite_ch_id(svl_id, channel_id, ch_mask, FAVORITE_TYPE_0);
				  mtvObj.acfgSetConfigString("g_channel_matrix_of_favchannels",get_favorite_length()); // Randy.xiao add for CUL event id 19
               
                 if(is_lock){
                     if (is_favorite) {
                       $('[channel_id="'+channel_id+'"] .icon_fav_div').removeClass('fav_icon');
                       $('[channel_id="'+channel_id+'"] .icon_lock_div').removeClass('lock_icon_left').addClass('lock_icon_right');
                       $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_all').addClass('class_logo_lock');

                     }else {
                         $('[channel_id="'+channel_id+'"] .icon_lock_div').removeClass('lock_icon_right').addClass('lock_icon_left');
                         $('[channel_id="'+channel_id+'"] .icon_fav_div').addClass('fav_icon');
                         $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_lock').addClass('class_logo_all');
                     }
                 }else{
                     if(is_favorite){
                       $('[channel_id="'+channel_id+'"] .icon_fav_div').removeClass('fav_icon');
                       $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_fav').addClass('class_logo_null');

                     }else{
                         $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_null').addClass('class_logo_fav');
                         $('[channel_id="'+channel_id+'"] .icon_fav_div').addClass('fav_icon');
                     }
                 }
                ch_mask_toggle = ch_mask ^= SB_VENT_FAVORITE; /* XOR */
                $(active_card[0]).attr("channel_mask", ch_mask_toggle);

              }
                catch (err) {
                    console.log("error for set channel id!");
                    console.log(err);
                }

            }

        }

        /* handle OK key */
        else if (key == KeyEvent.DOM_VK_RETURN) {

            console.log("REC: DOM_VK_RETURN key");
            if (active_card.length<1) {
              $('#id_div_ch_type').removeClass('active');
              endScroll();
              create_dialog_layout();
             return false;
            }
            // 20170929 [TF518PHIEUMTK01-1884]
            if (b_delay_finish == false)
            {
            	b_delay_finish = true;
            	clearTimeout(t_timer);
            	t_timer = null;
            	if(_bIsSupportTwoPartChannelNumber)
            	{
            		svl_id = $(active_card[0]).attr("svl_id");
            	}
            	delay_function(svl_id, ch_id, get_current_mask(), get_current_mask_value(), ModeList.Mode_TV_normal_all);
            	active_card = kc.target.find(".channel_list li.active");
            }
			// end
            if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
                console.log(channel_id);

                try {
                    /* set new channel */
                    var chObj = {
                        "CHANNEL_ID": channel_id,
                        "SVL_ID": $(active_card[0]).attr("svl_id"),
                        "NW_MASK": $(active_card[0]).attr("channel_mask")
                    };
                    change_channel_by_channle_info(chObj);
					mtvObj.acfgSetConfigString("g_channel_matrix_switch_channel","SwitchChannelByChannelMatrix"); // Randy.xiao add for CUL event id 27
                }
                catch (err) {
                    console.log("error for set channel id!");
                    console.log(err);
                }

            }
            /* back to home UI */
            if (g_t_timer_delay_exit != null) {
                clearTimeout(g_t_timer_delay_exit);
                g_t_timer_delay_exit = null;
            }
            g_t_timer_delay_exit = setTimeout(function() {
                 console.log("Exit Channel List");
                 mtvuiUtil.gotoSysPage("sys_channel_zapper"); /* Go to root page */
            },
            1000);
            return false;
        }
        else if (key == KeyEvent.DOM_VK_CHANNEL_OSD) {
            if (g_t_timer_delay_exit != null) {
                clearTimeout(g_t_timer_delay_exit);
                g_t_timer_delay_exit = null;
            }
            console.log("Exit Channel List");
            mtvuiUtil.gotoSysPage("sys_channel_zapper"); /* Go to root page */
            return false;
        }
        /* handle BLUE key */
        else if (key == KeyEvent.DOM_VK_BLUE) {

            console.log("REC: DOM_VK_BLUE key");

            jump_to_help_page();
             mtvuiUtil.gotoSysPage("sys_index");
            return true;

        }
        else if (key == KeyEvent.DOM_VK_OPTION) {
            console.log("REC: DOM_VK_OPTION key");
            if(mtvObj.acfgGetConfigValue("g_bs__bs_sat_brdcster")==31){
                if ($('#id_div_ch_type').hasClass("active")) {
                  $('#id_div_ch_type').removeClass('active');
                  if(get_favorite_length() <= 0){
						option_show_func(on_header_option_unfav_bu);                  
                    }else {
						option_show_func(on_header_option_fav_bu);					  
                    }
            }else{
            svl_id = $(active_card[0]).attr("svl_id");
            ch_mask = $(active_card[0]).attr("channel_mask");
            var is_lock = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
            if (current_tuner_type == TunerType_list.TunerType_satellite) {

                update_list_right_satellite();
                /* Satellite tuner type */
               switch (parseInt(get_cur_ch_list_type())) {
                        case ChannelListTypeList.ChannelListType_tv_new:
                        case ChannelListTypeList.ChannelListType_satellite_new:
                        if(is_lock){
                            option_show_func(new_option_is_lock_bu);
                        }else {
                            option_show_func(new_option_is_unlock_bu);
                        }
                            break;
                        default:
                                if (is_tkgs_enable() == true) {
                                    /* TKGS option menu */
                                    update_list_right_category();

                                    if(is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()){
                                        option_show_func(SA_all_normal_option_TKGS_islock_unfav_bu);
                                    }else if (is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_TKGS_islock_unfav_UN_bu);
                                    }else if (is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_TKGS_islock_fav_bu);
                                    }else if (is_lock && get_favorite_length() > 0 && !is_enable_swap_fct()) {
                                        option_show_func(SSA_all_normal_option_TKGS_islock_fav_UN_bu);
                                    }else if (!is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_TKGS_isunlock_unfav_bu);
                                    }else if (!is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_TKGS_isunlock_unfav_UN_bu);
                                    }else if (!is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_TKGS_isunlock_fav_bu);
                                    }else {
                                        option_show_func(SA_all_normal_option_TKGS_isunlock_fav_UN_bu);
                                    }
                                }
                                else if (is_m7_enable() == true) {
                                    /* M7 option menu */
                                    if(is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()){
                                        option_show_func(SA_all_normal_option_M7_islock_unfav_bu);
                                    }else if (is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_islock_unfav_UN_bu);
                                    }else if (is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_islock_fav_bu);
                                    }else if (is_lock && get_favorite_length() > 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_islock_fav_UN_bu);
                                    }else if (!is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_isunlock_unfav_bu);
                                    }else if (!is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_isunlock_unfav_UN_bu);
                                    }else if (!is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_isunlock_fav_bu);
                                    }else {
                                        option_show_func(SA_all_normal_option_M7_isunlock_fav_UN_bu);
                                    }
                                }
                                else {
                                    /* Satellite option menu */
                                    if(is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()){
                                        option_show_func(SA_all_normal_option_islock_unfav_bu);
                                    }else if (is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_islock_unfav_UN_bu);
                                    }else if (is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_islock_fav_bu);
                                    }else if (is_lock && get_favorite_length() > 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_islock_fav_UN_bu);
                                    }else if (!is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_isunlock_unfav_bu);
                                    }else if (!is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_isunlock_unfav_UN_bu);
                                    }else if (!is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_isunlock_fav_bu);
                                    }else {
                                        option_show_func(SA_all_normal_option_isunlock_fav_UN_bu);
                                    }
                                }
                                break;
                            }
            } else {
				if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==1){
					switch (parseInt(get_cur_ch_list_type())) {
                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                        if(is_lock){
                            option_show_func(new_option_is_lock);
                        }else {
                            option_show_func(new_option_is_unlock);
                        }
                        break;
                    default:
                        if(is_lock && get_favorite_length() <= 0){
                            option_show_func(TV_all_normal_option_islock_unfav_UPC);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(TV_all_normal_option_islock_fav_UPC);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(TV_all_normal_option_isunlock_unfav_UPC);

                        }else {
                            option_show_func(TV_all_normal_option_isunlock_fav_UPC);
                        }
                        break;
                    }
				}else if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&this.mtvObj.getCurrentCountry()=="NLD"&&(mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==7)){
					switch (parseInt(get_cur_ch_list_type())) {
                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                        if(is_lock){
                            option_show_func(new_option_is_lock);
                        }else {
                            option_show_func(new_option_is_unlock);
                        }
                        break;
                    default:
                        if(is_lock && get_favorite_length() <= 0){
                            option_show_func(TV_all_normal_option_islock_unfav_NLD);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(TV_all_normal_option_islock_fav_NLD);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(TV_all_normal_option_isunlock_unfav_NLD);

                        }else {
                            option_show_func(TV_all_normal_option_isunlock_fav_NLD);
                        }
                        break;
                    }
				}else if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==23&&(this.mtvObj.getCurrentCountry()=="ROU"||this.mtvObj.getCurrentCountry()=="HUN")){
					switch (parseInt(get_cur_ch_list_type())) {
                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                        if(is_lock){
                            option_show_func(new_option_is_lock);
                        }else {
                            option_show_func(new_option_is_unlock);
                        }
                        break;
                    default:
                        if(is_lock && get_favorite_length() <= 0){
                            option_show_func(TV_all_normal_option_islock_unfav_DIGI);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(TV_all_normal_option_islock_fav_DIGI);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(TV_all_normal_option_isunlock_unfav_DIGI);

                        }else {
                            option_show_func(TV_all_normal_option_isunlock_fav_DIGI);
                        }
                        break;
                    }
				}else{
					switch (parseInt(get_cur_ch_list_type())) {
                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                        if(is_lock){
                            option_show_func(new_option_is_lock);
                        }else {
                            option_show_func(new_option_is_unlock);
                        }
                        break;
                    default:
						if(is_disable_move_fct()){
							if(is_lock && get_favorite_length() <= 0){
								option_show_func(TV_all_normal_option_islock_unfav_UK);
							}else if (is_lock && get_favorite_length() > 0) {
								option_show_func(TV_all_normal_option_islock_fav_UK);
							}else if (!is_lock && get_favorite_length() <= 0) {
								option_show_func(TV_all_normal_option_isunlock_unfav_UK);

							}else {
								option_show_func(TV_all_normal_option_isunlock_fav_UK);
							}
						}else{
							if(is_lock && get_favorite_length() <= 0){
							    option_show_func(TV_all_normal_option_islock_unfav);
							}else if (is_lock && get_favorite_length() > 0) {
							    option_show_func(TV_all_normal_option_islock_fav);
							}else if (!is_lock && get_favorite_length() <= 0) {
							    option_show_func(TV_all_normal_option_isunlock_unfav);

							}else {
							    option_show_func(TV_all_normal_option_isunlock_fav);
							}
						}
                       
                        break;
                    }
				}
          
            }
            return false;

          }
        }else{
             if ($('#id_div_ch_type').hasClass("active")) {
                  $('#id_div_ch_type').removeClass('active');
                  if(get_favorite_length() <= 0){
					  if(is_disable_move_fct()){
						option_show_func(on_header_option_unfav_UK);  
					  }else{
						option_show_func(on_header_option_unfav);
					  }
                  
                  }else {
                      if(is_disable_move_fct()){
						option_show_func(on_header_option_fav_UK);  
					  }else{
						option_show_func(on_header_option_fav);
					  }
                  }
            }else{
				svl_id = $(active_card[0]).attr("svl_id");
				ch_mask = $(active_card[0]).attr("channel_mask");
				var is_lock = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
				if (current_tuner_type == TunerType_list.TunerType_satellite) {

                update_list_right_satellite();
                /* Satellite tuner type */
                switch (parseInt(get_cur_ch_list_type())) {
                        case ChannelListTypeList.ChannelListType_tv_new:
                        case ChannelListTypeList.ChannelListType_satellite_new:
                        if(is_lock){
                            option_show_func(new_option_is_lock);
                        }else {
                            option_show_func(new_option_is_unlock);
                        }
                            break;
                        default:
                                if (is_tkgs_enable() == true) {
                                    /* TKGS option menu */
                                    update_list_right_category();

                                    if(is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()){
                                        option_show_func(SA_all_normal_option_TKGS_islock_unfav);
                                    }else if (is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_TKGS_islock_unfav_UN);
                                    }else if (is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_TKGS_islock_fav);
                                    }else if (is_lock && get_favorite_length() > 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_TKGS_islock_fav_UN);
                                    }else if (!is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_TKGS_isunlock_unfav);
                                    }else if (!is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_TKGS_isunlock_unfav_UN);
                                    }else if (!is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_TKGS_isunlock_fav);
                                    }else {
                                        option_show_func(SA_all_normal_option_TKGS_isunlock_fav_UN);
                                    }
                                }
                                else if (is_m7_enable() == true) {
                                    /* M7 option menu */
                                    if(is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()){
                                        option_show_func(SA_all_normal_option_M7_islock_unfav);
                                    }else if (is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_islock_unfav_UN);
                                    }else if (is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_islock_fav);
                                    }else if (is_lock && get_favorite_length() > 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_islock_fav_UN);
                                    }else if (!is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_isunlock_unfav);
                                    }else if (!is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_isunlock_unfav_UN);
                                    }else if (!is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_M7_isunlock_fav);
                                    }else {
                                        option_show_func(SA_all_normal_option_M7_isunlock_fav_UN);
                                    }
                                }
                                else {
                                    /* Satellite option menu */
                                    if(is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()){
                                        option_show_func(SA_all_normal_option_islock_unfav);
                                    }else if (is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_islock_unfav_UN);
                                    }else if (is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_islock_fav);
                                    }else if (is_lock && get_favorite_length() > 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_islock_fav_UN);
                                    }else if (!is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_isunlock_unfav);
                                    }else if (!is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_isunlock_unfav_UN);
                                    }else if (!is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                        option_show_func(SA_all_normal_option_isunlock_fav);
                                    }else {
                                        option_show_func(SA_all_normal_option_isunlock_fav_UN);
                                    }
                                }
                                break;
                            }
            } else {
				if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==1){
					switch (parseInt(get_cur_ch_list_type())) {
                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                        if(is_lock){
                            option_show_func(new_option_is_lock);
                        }else {
                            option_show_func(new_option_is_unlock);
                        }
                        break;
                    default:
                        if(is_lock && get_favorite_length() <= 0){
                            option_show_func(TV_all_normal_option_islock_unfav_UPC);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(TV_all_normal_option_islock_fav_UPC);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(TV_all_normal_option_isunlock_unfav_UPC);

                        }else {
                            option_show_func(TV_all_normal_option_isunlock_fav_UPC);
                        }
                        break;
                    }
				}else if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&this.mtvObj.getCurrentCountry()=="NLD"&&(mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==7)){
					switch (parseInt(get_cur_ch_list_type())) {
                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                        if(is_lock){
                            option_show_func(new_option_is_lock);
                        }else {
                            option_show_func(new_option_is_unlock);
                        }
                        break;
                    default:
                        if(is_lock && get_favorite_length() <= 0){
                            option_show_func(TV_all_normal_option_islock_unfav_NLD);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(TV_all_normal_option_islock_fav_NLD);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(TV_all_normal_option_isunlock_unfav_NLD);

                        }else {
                            option_show_func(TV_all_normal_option_isunlock_fav_NLD);
                        }
                        break;
                    }
				}else if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==23&&(this.mtvObj.getCurrentCountry()=="ROU"||this.mtvObj.getCurrentCountry()=="HUN")){
					switch (parseInt(get_cur_ch_list_type())) {
                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                        if(is_lock){
                            option_show_func(new_option_is_lock);
                        }else {
                            option_show_func(new_option_is_unlock);
                        }
                        break;
                    default:
                        if(is_lock && get_favorite_length() <= 0){
                            option_show_func(TV_all_normal_option_islock_unfav_DIGI);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(TV_all_normal_option_islock_fav_DIGI);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(TV_all_normal_option_isunlock_unfav_DIGI);

                        }else {
                            option_show_func(TV_all_normal_option_isunlock_fav_DIGI);
                        }
                        break;
                    }
				}else{
					switch (parseInt(get_cur_ch_list_type())) {
                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                        if(is_lock){
                            option_show_func(new_option_is_lock);
                        }else {
                            option_show_func(new_option_is_unlock);
                        }
                        break;
                    default:
                        if(is_disable_move_fct()){
							if(is_lock && get_favorite_length() <= 0){
								option_show_func(TV_all_normal_option_islock_unfav_UK);
							}else if (is_lock && get_favorite_length() > 0) {
								option_show_func(TV_all_normal_option_islock_fav_UK);
							}else if (!is_lock && get_favorite_length() <= 0) {
								option_show_func(TV_all_normal_option_isunlock_unfav_UK);

							}else {
								option_show_func(TV_all_normal_option_isunlock_fav_UK);
							}
						}else{
							if(is_lock && get_favorite_length() <= 0){
								option_show_func(TV_all_normal_option_islock_unfav);
							}else if (is_lock && get_favorite_length() > 0) {
								option_show_func(TV_all_normal_option_islock_fav);
							}else if (!is_lock && get_favorite_length() <= 0) {
								option_show_func(TV_all_normal_option_isunlock_unfav);

							}else {
								option_show_func(TV_all_normal_option_isunlock_fav);
							}
						}
                        break;
                    }
            }
            return false;
		}
       }
      }
     }
        
        /* handle UP key */
        else if (key == KeyEvent.DOM_VK_BACK) {
        	/*20170727 [TF518PHIEUMTK01-386] [EAT table]*/
			mtvuiUtil.procSysKey(key); /*20170824*/

            return false;
        }
        /* handle EXIT key */
        /*else if (key == KeyEvent.DOM_VK_EXIT) {
        	/*20170727 [TF518PHIEUMTK01-386] [EAT table]*/
		    /*mtvuiUtil.procSysKey(key); /*20170824*/

            /*return false;
        }*/
        /* handle Option kay*/ /*20170727 [TF518PHIEUMTK01-187] [EAT table]*/
		/*else if (key == KeyEvent.DOM_VK_EXIT) {
            return false;
        }	20170913*/					
        /* handle number key */
        else if ((KeyEvent.DOM_VK_0 <= key) && (key <= KeyEvent.DOM_VK_SEPARATOR)) {
			//if(get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR) //TPV@Vinson(20171022)_SN0011
			//{
				//return false; //Not need digit entry
			//}
            var channel_id = null;
            if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
                console.log(channel_id);
                var svl_id = $(active_card[0]).attr("svl_id");
                try {
                    show_channel_num_osd();
                    switch (key) {
                        case KeyEvent.DOM_VK_0:
                            update_channel_num_osd(0);
                            break;
                        case KeyEvent.DOM_VK_1:
                            update_channel_num_osd(1);
                            break;
                        case KeyEvent.DOM_VK_2:
                            update_channel_num_osd(2);
                            break;
                        case KeyEvent.DOM_VK_3:
                            update_channel_num_osd(3);
                            break;
                        case KeyEvent.DOM_VK_4:
                            update_channel_num_osd(4);
                            break;
                        case KeyEvent.DOM_VK_5:
                            update_channel_num_osd(5);
                            break;
                        case KeyEvent.DOM_VK_6:
                            update_channel_num_osd(6);
                            break;
                        case KeyEvent.DOM_VK_7:
                            update_channel_num_osd(7);
                            break;
                        case KeyEvent.DOM_VK_8:
                            update_channel_num_osd(8);
                            break;
                        case KeyEvent.DOM_VK_9:
                            update_channel_num_osd(9);
                            break;
                        case KeyEvent.DOM_VK_SEPARATOR:
                            update_channel_num_osd(".");
                            break;
                        default:
                            break;
                    }
                    reset_delay_ch_num_osd(svl_id, channel_id, get_current_mask(), get_current_mask_value(), ModeList.Mode_TV_normal_all);
                }
                catch (err) {
                    console.log("error for set channel id!");
                    console.log(err);
                }

            }
            return false;
        }
        active_card = $(".channel_list li.active");

        //clear all channel active class
        for(i=0;i<3;i++){
        $(active_card[i]).removeClass("active");
        }
       if (item_cards.length <= 0) {
           return false;
       }
       item_cards = $(".channel_list li");
       //set current channel active
       $(item_cards[index]).addClass("active");
           var active_card = $(".channel_list li.active");
           if(active_card.length<1){
                $(item_cards[index-1]).addClass("active");
           }
           startScroll($('.channel_list li.active'));

       reset_colourbar();
        //change the color key list between fav's channel and not fav's channel.
        if (get_is_favorite_ch_by_mask($(item_cards[idx]).attr("channel_mask"))) {
            set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);
        } else {
            //not favorite channel colourkey
            set_colourkey_list_text(ColourKeyList_TV_normal_All_not_fav_state);
        }

    return true;
};

var tv_normal_radio_key_proc = function(kc) {

    //tv normal Radio key handle process the same as All case expect for RIGHT/LEFT key
    return tv_normal_all_key_proc(kc);
}

var tv_normal_new_key_proc = function(kc) {

    //tv normal New key handle process the same as All case expect for RIGHT/LEFT key
    return tv_normal_all_key_proc(kc);
}
var tv_normal_tv_key_proc = function(kc) {

    //tv normal Radio key handle process the same as All case expect for RIGHT/LEFT key.
    return tv_normal_all_key_proc(kc);
}

/*
*Set the text of colour key list
*/
var set_colourkey_list_text = function(colourkey_state) {

    //console.log("set ColorKey list text");
    //set the text of Info key
    //$("#ColorKey_Info").html(colourkey_state[0].ColorKey_Info);
    //set the text of Red key
   // $("#ColorKey_Red").html(getTranslate(colourkey_state.ColorKey_Red));
    //set the text of Green key
    $("#ColorKey_Green").html(getTranslate(colourkey_state.ColorKey_Yellow));
    //set the text of YELLOW key
   // $("#ColorKey_Yellow").html(getTranslate(colourkey_state.ColorKey_Yellow));
    //set the text of Blue key
   // $("#ColorKey_Blue").html(getTranslate(colourkey_state.ColorKey_Blue));
    //set the text of Options key
  //  $("#ColorKey_Options").html(getTranslate(colourkey_state.ColorKey_Options));

    return true;
};


/*
*Handle key process of Find channel mode in new search mode.
*/
var find_channel_new_search_key_proc = function(kc) {

    var key = kc.keyCode || kc.which;
    switch (key) {
    	case KeyEvent.DOM_VK_UP:// 20180822 Temp solution for OSKB always can not get return key
    	case KeyEvent.DOM_VK_DOWN:// 20180822 Temp solution for OSKB always can not get return key
    	case KeyEvent.DOM_VK_RIGHT:// 20180822 Temp solution for OSKB always can not get return key
    	case KeyEvent.DOM_VK_LEFT:// 20180822 Temp solution for OSKB always can not get return key
        case KeyEvent.DOM_VK_RETURN:
            {
                var str_id = $("#new-search-dialog").find(".key-active").attr("id");

                //handle button key of Clear/Done/Cancel
                console.log(str_id);
                var channel_id = 0;
                textValue = $("#new-search-txtID").val();
                if (keyboard_mode == KyeboardModeList.KyeboardMode_tv_normal_rename) {
                    var active_card = kc.target.find(".channel_list li.active");
                    if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
                        var svl_id = $(active_card[0]).attr("svl_id");
                        //rename active channel name
                         var channel_name = textValue;
                         $(active_card[0]).find("#ch_name").html(channel_name);
//                         setchannelName(channel_name);
                        /* show/hidden favorite icon */
                        rename_channel_name_by_svl_ch_id(svl_id, channel_id, textValue);
                        //$(active_card[0]).attr("channel_name", textValue);
                        $("#new-search-dialog").hide();
                        back_to_last_active_mode();
                        show_tv_normal_items();
                    }

                } else {
                    //layout find channel results
                    Find_channel_results_state_layout(textValue);
                    //set mode
                    set_active_mode(ModeList.Mode_FindChannel_show_results);
                }
                $("#new-search-txtID").blur();
                break;
            }
        case KeyEvent.DOM_VK_ESCAPE:
            {
                $("#new-search-dialog").hide();
                back_to_last_active_mode();
                reset_colourbar();
                show_tv_normal_items();
                $("#new-search-txtID").blur();
                break;
            }
        default:
			break;
    }
    ;
    return false;
}
/*
*Handle key process of Find channel mode in search results state mode.
*/
var g_t_timer_delay_exit = null;

var find_channel_show_results_state_key_proc = function(kc,search_str) {
    $("#ColorKey_Green").html(getTranslate("CHM_TEXTE_DONE"));
     var item_cards = $(".channel_list li");
    var active_card = kc.target.find(".channel_list li.active");
    var next_card=active_card.next();
    var pre_card=active_card.prev();
    var key = kc.keyCode || kc.which;
    var svl_id = next_card.attr("svl_id");
    var ch_id=next_card.attr("channel_id");
    var mask=next_card.attr("channel_mask");
    var svl_id_pre = pre_card.attr("svl_id");
    var ch_id_pre=pre_card.attr("channel_id");
    var mask_pre=pre_card.attr("channel_mask");
    var index_pr=parseInt(active_card.attr('channel_idx'));

    var index =1;
    if (active_card.length > 0)
         idx = $.inArray(active_card[0], item_cards);

          // handle left, right key
          index=idx;
    if (key == KeyEvent.DOM_VK_LEFT || key == KeyEvent.DOM_VK_RIGHT) {
              if (active_card.length <= 0) {
                  $('#id_div_ch_type').removeClass('active');
                  var active_card=item_cards.eq(idx).addClass('active');
				  var endScroll_id=$('#id_div_ch_type>.type_mid');
				  com_end_scroll(endScroll_id); 
				  startScroll(active_card);
              } else {
				  endScroll(active_card);
				  var startScroll_id=$('#id_div_ch_type>.type_mid');
				  com_start_scroll(startScroll_id);
                  item_cards.removeClass('active');
                  $('#id_div_ch_type').addClass('active');
                  $('#ColorKey_Green').html('');
              }
              return false;
          }
        /* handle DOWN key */
        if (key == KeyEvent.DOM_VK_DOWN) {
            if(active_card.length <= 0){
				var endScroll_id=$('#id_div_ch_type>.type_mid');
				com_end_scroll(endScroll_id); 
				$('#id_div_ch_type').removeClass('active');
				idx=-1;
            }
            if(index==7||index==g_channel_cnt-1){
                return false;
            }
            if(index<6){
                index+=1;
            }
          idx += 1;
          if (index >= (item_cards.length-2)) {
              if (index_pr+2>=search_channel_count) {
                  $('.class_arrow_down').eq(0).hide();
                  $('#id_div_down_bk').eq(0).hide();
                  // 20170918 fix [TF518PHIEUMTK01-1482] cursor will disappear after do search channels and move cursor to last channel
                  if (index <= 7) 
                  	index = item_cards.length-1;
                  else
                  	index=7;
                  // end
                  active_card.removeClass("active");
                  $(item_cards[index]).addClass("active");
                  return false;
              }
              if(item_cards.length != 1){
                  if(idx>=7){
                is_last_channel=  carousel_add_channel_items(ModeList.Mode_FindChannel_show_results, svl_id, ch_id, DirectionList.Direction_next, 1,FAVORITE_TYPE_0,search_str,index_pr+2);

                //is_last_channel= carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_next,1);
                item_cards = kc.target.find(".channel_list li");
				var svl_id_next=item_cards.eq(7).attr("svl_id");
				var ch_id_next=item_cards.eq(7).attr("channel_id");
				var nw_mask_next=get_current_mask();
				var mask_value_next= get_current_mask_value();
				var idx_next = get_index_by_channel_id(svl_id_next, nw_mask_next, mask_value_next, ch_id_next);
                if(idx_next==g_channel_cnt-1){
					is_need_hide_dowm=true;
				}
                idx = item_cards.length - 1;
                show_or_hide_arrow();
                }
                if(is_last_channel){
                    index=7;
                    is_last_channel=false;
                    
                }
             }else {
                 idx -= 1;
             }


         }
        }
        /* handle UP key */
        else if (key == KeyEvent.DOM_VK_UP) {
            if (active_card.length <= 0) {
                    return false;
                }
          idx -= 1;
          if(index>1){
              index-=1;
          }
            /* save last selected idx */
            if (index <=1) {
                if (index_pr-2<0) {
                         $('.class_arrow_up').eq(0).hide();
                         $('#id_div_up_bk').eq(0).hide();
                         index=0;
                         active_card.removeClass("active");
                         $(item_cards[index]).addClass("active");
                        return false;
                    }
                if(item_cards.length != 1){
                    if(index==0){
                            endScroll(active_card);
							var startScroll_id=$('#id_div_ch_type>.type_mid');
							com_start_scroll(startScroll_id);
                            item_cards.removeClass('active');
                            $('#id_div_ch_type').addClass('active');
                            $('#ColorKey_Green').html('');
                            return false;
                    }
                       if(idx<=0){
                   is_first_channel= carousel_add_channel_items(ModeList.Mode_FindChannel_show_results, svl_id_pre, ch_id_pre, DirectionList.Direction_pre, 1,FAVORITE_TYPE_0,search_str,index_pr-2);
                       // is_first_channel=carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id_pre,ch_id_pre,DirectionList.Direction_pre,1);
                        item_cards = kc.target.find(".channel_list li");
						var svl_id_pre=item_cards.eq(0).attr("svl_id");
				        var ch_id_pre=item_cards.eq(0).attr("channel_id");
				        var nw_mask_pre=get_current_mask();
				        var mask_value_pre= get_current_mask_value();
				        var idx_pre = get_index_by_channel_id(svl_id_pre, nw_mask_pre, mask_value_pre, ch_id_pre);
                        if(idx_pre==0){
					         is_need_hide_up=true;
				        }
                        idx=0;
                        
                        show_or_hide_arrow();
                        }
                        if (is_first_channel) {
                            index=0;
                            is_first_channel=false;
                            //show_or_hide_arrow();

                            //item_cards.removeClass('active');
                           // $('#id_div_ch_type').addClass('active');
                            //$('#ColorKey_Green').html('');
                            //return false;
                        }
                }else {
                    item_cards.removeClass('active');
                    $('#id_div_ch_type').addClass('active');
                    $('#ColorKey_Green').html('');
                    return false;
                }
            }
        }
		else if(key == KeyEvent.DOM_VK_CH_DECREASE){
			var cur_page_last_item=item_cards.eq(7);
			if(cur_page_last_item.length>0){
				svl_id =cur_page_last_item.attr("svl_id");
				ch_id  =cur_page_last_item.attr("channel_id");
				var cur_idx = get_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
				if(cur_idx==g_channel_cnt-1){
					return false;
				}else if(cur_idx>=g_channel_cnt-9){
				    is_need_hide_dowm=true;
				}
				mun =Math.min(g_channel_cnt-cur_idx, CAROUSEL_ITEM_CNT);
			    active_card.removeClass("active");
				carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_next,mun);
				item_cards=$(".channel_list li");
				item_cards.eq(1).addClass("active");
				show_or_hide_arrow();
				startScroll($('.channel_list li.active'));
				return false;
			}else{
				return false;
			}
		}
		else if(key == KeyEvent.DOM_VK_CH_INCREASE){
			var cur_page_frist_item=item_cards.eq(0);
			if(cur_page_frist_item.length>0){
				svl_id =cur_page_frist_item.attr("svl_id");
				ch_id  =cur_page_frist_item.attr("channel_id");
				var cur_idx = get_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
				if(cur_idx==0){
					return false;
				}else if(cur_idx<=8){
                    is_need_hide_up=true;
                }
				
			    active_card.removeClass("active");
				carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_pre,CAROUSEL_ITEM_CNT);
				item_cards=$(".channel_list li");
				item_cards.eq(1).addClass("active");
				show_or_hide_arrow();
				startScroll($('.channel_list li.active'));
				
				return false;
			}else{
				return false;
			}
		}
        /* handle DOM_VK_RED key */
        else if (key == KeyEvent.DOM_VK_GREEN) {
            //DOM_VK_PAGE_UP
            console.log("REC: DOM_VK_RED key");
            switch (parseInt(get_cur_ch_list_type())) {
                case ChannelListTypeList.ChannelListType_tv_favorite:
                case ChannelListTypeList.ChannelListType_satellite_favorite:
                    TV_normal_favorite_state_layout();
                    var active_card=$('.channel_list li.active');
                    if (active_card.length<=0) {
                       $("#channel_list_ul>li:first-child").addClass('active');
                   }

                   if (get_is_favorite_ch_by_mask($(item_cards[idx]).attr("channel_mask"))) {
                       set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);
                    } else {
                    //not favorite channel colourkey
                        set_colourkey_list_text(ColourKeyList_TV_normal_All_not_fav_state);
                    }
                    set_active_mode(ModeList.Mode_TV_normal_favorite);
                    break;
                case ChannelListTypeList.ChannelListType_tv_radio:
                case ChannelListTypeList.ChannelListType_satellite_radio:
                    TV_normal_radio_state_layout();
                    set_active_mode(ModeList.Mode_TV_normal_radio);
                    break;
                case ChannelListTypeList.ChannelListType_tv_new:
                case ChannelListTypeList.ChannelListType_satellite_new:
                    TV_normal_new_state_layout();
                    set_active_mode(ModeList.Mode_TV_normal_new);
                    break;
                case ChannelListTypeList.ChannelListType_tv_all:
                case ChannelListTypeList.ChannelListType_satellite_all:
                    TV_normal_all_state_layout();
                    set_active_mode(ModeList.Mode_TV_normal_all);
                    break;
                case ChannelListTypeList.ChannelListType_satellite_tv:
                    TV_normal_tv_state_layout();
                    set_active_mode(ModeList.Mode_TV_normal_tv);
                    break;
                default:
                    TV_normal_all_state_layout();
                    set_active_mode(ModeList.Mode_TV_normal_all);
                    break;
            }

            return true;
        }
        /* handle OK key */
        else if (key == KeyEvent.DOM_VK_RETURN) {

    console.log("REC: DOM_VK_RETURN key");
    if (active_card.length<1) {
      $('#id_div_ch_type').removeClass('active');
      create_dialog_layout();
     return false;
    }
    if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
        console.log(channel_id);

        try {
            /* set new channel */
            var chObj = {
                "CHANNEL_ID": channel_id,
                "SVL_ID": $(active_card[0]).attr("svl_id"),
                "NW_MASK": $(active_card[0]).attr("channel_mask")
            };
            change_channel_by_channle_info(chObj);
        }
        catch (err) {
            console.log("error for set channel id!");
            console.log(err);
        }

    }
    /* back to home UI */
    if (g_t_timer_delay_exit != null) {
        clearTimeout(g_t_timer_delay_exit);
        g_t_timer_delay_exit = null;
    }
    g_t_timer_delay_exit = setTimeout(function() {
         console.log("Exit Channel List");
         mtvuiUtil.gotoSysPage("sys_channel_zapper"); /* Go to root page */
    },
    1000);
    return false;

}
        else if (key == KeyEvent.DOM_VK_CHANNEL_OSD) {
            if (g_t_timer_delay_exit != null) {
                clearTimeout(g_t_timer_delay_exit);
                g_t_timer_delay_exit = null;
            }
             console.log("Exit Channel List");
             mtvuiUtil.gotoSysPage("sys_channel_zapper"); /* Go to root page */
            return false;
        }
        else if (key == KeyEvent.DOM_VK_BLUE) {
            jump_to_help_page();
            return false;
        }
        //clear all channel active class
        //set current channel active
        active_card.removeClass("active");
        $(item_cards[index]).addClass("active");
         var active_card = kc.target.find(".channel_list li.active");
            if(active_card.length<1){
                $(item_cards[index-1]).addClass("active");
           }
        startScroll($('.channel_list li.active'));
        
     //change the color key list between fav's channel and not fav's channel.
  
};
var tv_normal_favorite_key_proc = function(kc) {
   var item_cards = $(".channel_list li");
    var active_card = kc.target.find(".channel_list li.active");
    var next_card=active_card.next();
    var pre_card=active_card.prev();
    var key = kc.keyCode || kc.which;
    var svl_id = next_card.attr("svl_id");
    var ch_id=next_card.attr("channel_id");
    var mask=next_card.attr("channel_mask");
    var svl_id_pre = pre_card.attr("svl_id");
    var ch_id_pre=pre_card.attr("channel_id");
    var mask_pre=pre_card.attr("channel_mask");
    var index =1;
    if (active_card.length > 0)
        idx = $.inArray(active_card[0], item_cards);
        index=idx;

    /* not card */
    if (item_cards.length <= 0) {
        Favorite_edit_create_favorite_state_layout();

        //set active mode
        set_active_mode(ModeList.Mode_Favorite_create_favorite);
       return false;
    }
    if (key == KeyEvent.DOM_VK_LEFT || key == KeyEvent.DOM_VK_RIGHT) {
	   if (active_card.length<1) {
		   $('#id_div_ch_type').removeClass('active');
			var active_card=item_cards.eq(idx).addClass('active');
		    var endScroll_id=$('#id_div_ch_type>.type_mid');
	        com_end_scroll(endScroll_id); 
			startScroll(active_card);
		    //reset_colourbar();
		    set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);

	    } else {
		   endScroll(active_card);
		   var startScroll_id=$('#id_div_ch_type>.type_mid');
	       com_start_scroll(startScroll_id);
		   item_cards.removeClass('active');
		   $('#id_div_ch_type').addClass('active');
		   $('#ColorKey_Green').html('');
	    }
	    return false;
    }
 
     /* handle DOWN key */
    if (key == KeyEvent.DOM_VK_DOWN) {
         if(active_card.length <= 0){
			 	var endScroll_id=$('#id_div_ch_type>.type_mid');
				com_end_scroll(endScroll_id); 
				$('#id_div_ch_type').removeClass('active');
				idx=-1;
				set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);

         }
            if(index==7||index==g_channel_cnt-1){
                return false;
            }
            if(index<6){
                index+=1;
            }
        idx += 1;
        if(index >= (item_cards.length-2)){
        if(idx>=7){
        is_last_channel= carousel_add_channel_items(ModeList.Mode_TV_normal_favorite,svl_id,ch_id,DirectionList.Direction_next,1,FAVORITE_TYPE_0);
        item_cards = kc.target.find(".channel_list li");
		var svl_id_next=item_cards.eq(7).attr("svl_id");
		var ch_id_next=item_cards.eq(7).attr("channel_id");
		var nw_mask_next=get_current_mask();
		var mask_value_next= get_current_mask_value();
		var idx_next = get_fav_index_by_channel_id(svl_id_next, nw_mask_next, mask_value_next, ch_id_next);
        if(idx_next==g_channel_cnt-1){
			is_need_hide_dowm=true;
		}
        idx = item_cards.length - 1;
        show_or_hide_arrow();
        }
        if(is_last_channel){
                    index=7;
                    is_last_channel=false;
                    
            }
        }
    }
     /* handle UP key */
    else if (key == KeyEvent.DOM_VK_UP) {
		 if (active_card.length <= 0) {
				 return false;
			 }
		 idx -= 1;
		 if(index>1){
		  index-=1;
		 }
		 if(index <=1){
			 if(item_cards.length != 1){
				  if(index==0){
						endScroll(active_card);
						var startScroll_id=$('#id_div_ch_type>.type_mid');
						com_start_scroll(startScroll_id);
						item_cards.removeClass('active');
						$('#id_div_ch_type').addClass('active');
						$('#ColorKey_Green').html('');
						return false;
				}
				if(idx<=0){
				   is_first_channel=carousel_add_channel_items(ModeList.Mode_TV_normal_favorite,svl_id_pre,ch_id_pre,DirectionList.Direction_pre,1,FAVORITE_TYPE_0);
				   item_cards = kc.target.find(".channel_list li");
				   var svl_id_pre=item_cards.eq(0).attr("svl_id");
				   var ch_id_pre=item_cards.eq(0).attr("channel_id");
				   var nw_mask_pre=get_current_mask();
				   var mask_value_pre= get_current_mask_value();
				   var idx_pre = get_fav_index_by_channel_id(svl_id_pre, nw_mask_pre, mask_value_pre, ch_id_pre);
				   if(idx_pre==0){
						 is_need_hide_up=true;
				   }
				   idx=0;
				   show_or_hide_arrow();
				   }
				   if (is_first_channel) {
					   index=0;
						is_first_channel=false;
//                            item_cards.removeClass('active');
//                            $('#id_div_ch_type').addClass('active');
//                            $('#ColorKey_Green').html('');
//                            return false;
				   }
				  
		 }else{
			 item_cards.removeClass('active');
			 endScroll(active_card);
			 var startScroll_id=$('#id_div_ch_type>.type_mid');
			com_start_scroll(startScroll_id);
			item_cards.removeClass('active');
			$('#id_div_ch_type').addClass('active');
			$('#ColorKey_Green').html('');
			return false;
		 }
	   }
    }
	else if(key == KeyEvent.DOM_VK_CH_DECREASE){
		var cur_page_last_item=item_cards.eq(7);
		if(cur_page_last_item.length>0){
			svl_id =cur_page_last_item.attr("svl_id");
			ch_id  =cur_page_last_item.attr("channel_id");
			var cur_idx = get_fav_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
			if(cur_idx==g_channel_cnt-1){
				return false;
			}else if(cur_idx>=g_channel_cnt-9){
				is_need_hide_dowm=true;
			}
			mun =Math.min(g_channel_cnt-cur_idx, CAROUSEL_ITEM_CNT);
			active_card.removeClass("active");
			carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_next,mun);
			item_cards=$(".channel_list li");
			item_cards.eq(1).addClass("active");
			show_or_hide_arrow();
			startScroll($('.channel_list li.active'));
			return false;
		}else{
			return false;
		}
	}
	else if(key == KeyEvent.DOM_VK_CH_INCREASE){
		var cur_page_frist_item=item_cards.eq(0);
		if(cur_page_frist_item.length>0){
			svl_id =cur_page_frist_item.attr("svl_id");
			ch_id  =cur_page_frist_item.attr("channel_id");
			var cur_idx = get_fav_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
			if(cur_idx==0){
				return false;
			}else if(cur_idx<=8){
				is_need_hide_up=true;
			}
			
			active_card.removeClass("active");
			carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_pre,CAROUSEL_ITEM_CNT);
			item_cards=$(".channel_list li");
			item_cards.eq(1).addClass("active");
			show_or_hide_arrow();
			startScroll($('.channel_list li.active'));
			
			return false;
		}else{
			return false;
		}
	}
       /* handle GREEN key */
    else if (key == KeyEvent.DOM_VK_GREEN ) {
            //DOM_VK_PAGE_UP
		console.log("REC: DOM_VK_GREEN key");
		var active_card = kc.target.find(".channel_list li.active");

		if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
			console.log(channel_id);
			try {    
                 svl_id = $(active_card[0]).attr("svl_id");
                 ch_mask = $(active_card[0]).attr("channel_mask");
                 set_favorite_ch_id(svl_id, channel_id, ch_mask, FAVORITE_TYPE_0);
				 mtvObj.acfgSetConfigString("g_channel_matrix_of_favchannels",get_favorite_length()); // Randy.xiao add for CUL event id 19
                 TV_normal_favorite_state_layout();
//                  var is_new = (MaskList.Mask_new & ch_mask) == MaskList.Mask_new;
//                  var is_favorite  = (MaskList.Mask_favorite & ch_mask) == MaskList.Mask_favorite;
//                  var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
//                   set_favorite_ch_id(svl_id, channel_id, ch_mask, FAVORITE_TYPE_0);
//                  if (is_new) {
//                      /* hidden new icon */
//                      $('[channel_id="' + channel_id + '"] .card-new-icon').hide();
//                  }
//                  if(is_lock){
//                      if (is_favorite) {
//                        $('[channel_id="'+channel_id+'"] .icon_fav_div').removeClass('fav_icon');
//                        $('[channel_id="'+channel_id+'"] .icon_lock_div').removeClass('lock_icon_left').addClass('lock_icon_right');
//                        $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_all').addClass('class_logo_lock');

//                      }else {
//                          $('[channel_id="'+channel_id+'"] .icon_lock_div').removeClass('lock_icon_right').addClass('lock_icon_left');
//                          $('[channel_id="'+channel_id+'"] .icon_fav_div').addClass('fav_icon');
//                          $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_lock').addClass('class_logo_all');
//                      }
//                  }else{
//                      if(is_favorite){
//                        $('[channel_id="'+channel_id+'"] .icon_fav_div').removeClass('fav_icon');
//                        $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_fav').addClass('class_logo_null');

//                      }else{
//                          $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_null').addClass('class_logo_fav');
//                          $('[channel_id="'+channel_id+'"] .icon_fav_div').addClass('fav_icon');
//                      }
//                  }
               //ch_mask_toggle = ch_mask ^= SB_VENT_FAVORITE; /* XOR */
               // $(active_card[0]).attr("channel_mask", ch_mask_toggle);
		  }
			catch (err) {
				console.log("error for set channel id!");
				console.log(err);
			}
		}
    }
       /* handle OK key */
    else if (key == KeyEvent.DOM_VK_RETURN) {

        console.log("REC: DOM_VK_RETURN key");
        if (active_card.length<1) {
            $('#id_div_ch_type').removeClass('active');
            create_dialog_layout();
            endScroll();
            return false;
        }
        // 20171011 [TF518PHIEUMTK01-2277]
        var newTimer = 0;
        if (b_delay_finish == false)
        {
        	b_delay_finish = true;
        	newTimer = 3000;
        }
        // end
        setTimeout(function() {
	        active_card = kc.target.find(".channel_list li.active");
        if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
            console.log(channel_id);

            try {
                   /* set new channel */
                var chObj = {
                    "CHANNEL_ID": channel_id,
                    "SVL_ID": $(active_card[0]).attr("svl_id"),
                    "NW_MASK": $(active_card[0]).attr("channel_mask")
                };
                change_channel_by_channle_info(chObj);
               }
               catch (err) {
                   console.log("error for set channel id!");
                   console.log(err);
                }

        }
           /* back to home UI */
		if (g_t_timer_delay_exit != null) {
		   clearTimeout(g_t_timer_delay_exit);
		   g_t_timer_delay_exit = null;
		}
		g_t_timer_delay_exit = setTimeout(function() {
                    console.log("Exit Channel List");
		    mtvuiUtil.gotoSysPage("sys_channel_zapper"); /* Go to root page */
		},
		1000);
		return false;
		},
		newTimer);
    }
    else if (key == KeyEvent.DOM_VK_CHANNEL_OSD) {
	    if (g_t_timer_delay_exit != null) {
		   clearTimeout(g_t_timer_delay_exit);
		   g_t_timer_delay_exit = null;
	    }
             console.log("Exit Channel List");
	     mtvuiUtil.gotoSysPage("sys_channel_zapper"); /* Go to root page */
	    return false;
    }
       /* handle BLUE key */
    else if (key == KeyEvent.DOM_VK_BLUE) {

	    console.log("REC: DOM_VK_BLUE key");

	    jump_to_help_page();
	     mtvuiUtil.gotoSysPage("sys_index");
	    return true;

    }
       /* handle OPTION key */
    else if (key == KeyEvent.DOM_VK_OPTION) {
        console.log("REC: DOM_VK_OPTION key");
    if(mtvObj.acfgGetConfigValue("g_bs__bs_sat_brdcster")==31){
        if ($('#id_div_ch_type').hasClass("active")) {
                $('#id_div_ch_type').removeClass('active');
		            if(get_favorite_length() <= 0){
						option_show_func(on_header_option_unfav_bu);  					  
                    }else {
						option_show_func(on_header_option_fav_bu);					  
                    }
        }else{
            if (current_tuner_type == TunerType_list.TunerType_satellite) {
             /* Satellite tuner type */
				switch (parseInt(get_cur_ch_list_type())) {

					case ChannelListTypeList.ChannelListType_tv_new:
					case ChannelListTypeList.ChannelListType_satellite_new:
					svl_id = $(active_card[0]).attr("svl_id");
					ch_mask = $(active_card[0]).attr("channel_mask");
					var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
					if(is_lock){
						option_show_func(new_option_is_lock_bu);
					}else {
						option_show_func(new_option_is_unlock_bu);
					}
						break;
					default:
					svl_id = $(active_card[0]).attr("svl_id");
					ch_mask = $(active_card[0]).attr("channel_mask");
					var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
					if(is_lock){
						option_show_func(SA_fav_normal_option_islock_bu);
					}else {
						option_show_func(SA_fav_normal_option_isunlock_bu);
					}
						break;
				}
            }else{
                if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==1){
						switch (parseInt(get_cur_ch_list_type())) {
						case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
							   option_show_func(TV_fav_normal_option_islock_UPC);
							}else {
							   option_show_func(TV_fav_normal_option_isunlock_UPC);
							}
							 break;
						} 
                
				}else if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&this.mtvObj.getCurrentCountry()=="NLD"&&(mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==7)){
						switch (parseInt(get_cur_ch_list_type())) {
						case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
							   option_show_func(TV_fav_normal_option_islock_NLD);
							}else {
							   option_show_func(TV_fav_normal_option_isunlock_NLD);
							}
							 break;
						} 
                
				}else if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==23&&(this.mtvObj.getCurrentCountry()=="ROU"||this.mtvObj.getCurrentCountry()=="HUN")){
						switch (parseInt(get_cur_ch_list_type())) {
						case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
						   svl_id = $(active_card[0]).attr("svl_id");
						   ch_mask = $(active_card[0]).attr("channel_mask");
						   var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
						   if(is_lock){
							   option_show_func(TV_fav_normal_option_islock_DIGI);
						   }else {
							   option_show_func(TV_fav_normal_option_isunlock_DIGI);
						   }
							break;
						}
				}else if(is_disable_move_fct()){
					    switch (parseInt(get_cur_ch_list_type())) {
						case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
						   svl_id = $(active_card[0]).attr("svl_id");
						   ch_mask = $(active_card[0]).attr("channel_mask");
						   var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
						   if(is_lock){
							   option_show_func(TV_fav_normal_option_islock_UK);
						   }else {
							   option_show_func(TV_fav_normal_option_isunlock_UK);
						   }
							break;
						}
				}else{
						switch (parseInt(get_cur_ch_list_type())) {

						case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
								 option_show_func(TV_fav_normal_option_islock);
							}else {
								option_show_func(TV_fav_normal_option_isunlock);
							}
					    break;
						}
			        }
            }
         return false;
        }
        }else{
            if ($('#id_div_ch_type').hasClass("active")) {
                $('#id_div_ch_type').removeClass('active');
           if(get_favorite_length() <= 0){
					  if(is_disable_move_fct()){
						option_show_func(on_header_option_unfav_UK);  
					  }else{
						option_show_func(on_header_option_unfav);
					  }
                  
                    }else {
                      if(is_disable_move_fct()){
						option_show_func(on_header_option_fav_UK);  
					  }else{
						option_show_func(on_header_option_fav);
					  }
                    }
			}else{
				if (current_tuner_type == TunerType_list.TunerType_satellite) {
                 /* Satellite tuner type */
				    if(is_disable_move_fct()){
					    switch (parseInt(get_cur_ch_list_type())) {
					    case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
								option_show_func(SA_fav_normal_option_islock_UK);
							}else {
								option_show_func(SA_fav_normal_option_isunlock_UK);
							}
							break;
						}
				    }else{
						switch (parseInt(get_cur_ch_list_type())) {

						case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
								option_show_func(SA_fav_normal_option_islock);
							}else {
								option_show_func(SA_fav_normal_option_isunlock);
							}
							break;
					    }
				    }
				
				} else {
					if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==1){
						switch (parseInt(get_cur_ch_list_type())) {
						case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
							   option_show_func(TV_fav_normal_option_islock_UPC);
							}else {
							   option_show_func(TV_fav_normal_option_isunlock_UPC);
							}
							 break;
						} 
                
				}else if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&this.mtvObj.getCurrentCountry()=="NLD"&&(mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==7)){
						switch (parseInt(get_cur_ch_list_type())) {
						case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
							   option_show_func(TV_fav_normal_option_islock_NLD);
							}else {
							   option_show_func(TV_fav_normal_option_isunlock_NLD);
							}
							 break;
						} 
                
				}else if(parseInt(mtvObj.getDtvTunerBsSrc())==BS_TYPE_CAB&&mtvObj.acfgGetConfigValue("g_bs__bs_cable_brdcster")==23&&(this.mtvObj.getCurrentCountry()=="ROU"||this.mtvObj.getCurrentCountry()=="HUN")){
						switch (parseInt(get_cur_ch_list_type())) {
						case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
						   svl_id = $(active_card[0]).attr("svl_id");
						   ch_mask = $(active_card[0]).attr("channel_mask");
						   var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
						   if(is_lock){
							   option_show_func(TV_fav_normal_option_islock_DIGI);
						   }else {
							   option_show_func(TV_fav_normal_option_isunlock_DIGI);
						   }
							break;
						}
					}else if(is_disable_move_fct()){
					    switch (parseInt(get_cur_ch_list_type())) {
						case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
						   svl_id = $(active_card[0]).attr("svl_id");
						   ch_mask = $(active_card[0]).attr("channel_mask");
						   var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
						   if(is_lock){
							   option_show_func(TV_fav_normal_option_islock_UK);
						   }else {
							   option_show_func(TV_fav_normal_option_isunlock_UK);
						   }
							break;
						}
				}else{
						switch (parseInt(get_cur_ch_list_type())) {

						case ChannelListTypeList.ChannelListType_tv_new:
						case ChannelListTypeList.ChannelListType_satellite_new:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
								option_show_func(new_option_is_lock);
							}else {
								option_show_func(new_option_is_unlock);
							}
							break;
						default:
							svl_id = $(active_card[0]).attr("svl_id");
							ch_mask = $(active_card[0]).attr("channel_mask");
							var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
							if(is_lock){
								 option_show_func(TV_fav_normal_option_islock);
							}else {
								option_show_func(TV_fav_normal_option_isunlock);
							}
					    break;
						}
			        }
                }
                return false;

            }
        }
    }else if (key == KeyEvent.DOM_VK_BACK) {
           return false;

    }
    /* handle number key */
    else if ((KeyEvent.DOM_VK_0 <= key) && (key <= KeyEvent.DOM_VK_9)) {
		if(get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR) //TPV@Vinson(20171022)_SN0011
		{
			return false; //Not need digit entry
		}
	   var channel_id = null;
	   if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
		   console.log(channel_id);
		   var svl_id = $(active_card[0]).attr("svl_id");
		   try {
			   show_channel_num_osd();
			   switch (key) {
				   case KeyEvent.DOM_VK_0:
					   update_channel_num_osd(0);
					   break;
				   case KeyEvent.DOM_VK_1:
					   update_channel_num_osd(1);
					   break;
				   case KeyEvent.DOM_VK_2:
					   update_channel_num_osd(2);
					   break;
				   case KeyEvent.DOM_VK_3:
					   update_channel_num_osd(3);
					   break;
				   case KeyEvent.DOM_VK_4:
					   update_channel_num_osd(4);
					   break;
				   case KeyEvent.DOM_VK_5:
					   update_channel_num_osd(5);
					   break;
				   case KeyEvent.DOM_VK_6:
					   update_channel_num_osd(6);
					   break;
				   case KeyEvent.DOM_VK_7:
					   update_channel_num_osd(7);
					   break;
				   case KeyEvent.DOM_VK_8:
					   update_channel_num_osd(8);
					   break;
				   case KeyEvent.DOM_VK_9:
					   update_channel_num_osd(9);
					   break;
				   default:
					   break;
			   }
			   reset_delay_ch_num_osd(svl_id, channel_id, get_current_mask(), get_current_mask_value(), ModeList.Mode_TV_normal_favorite);
		   }
		   catch (err) {
			   console.log("error for set channel id!");
			   console.log(err);
		   }

	   }
	   return false;
    }
    //clear all channel active class
    active_card.removeClass('active');
    if (item_cards.length <= 0) {
        return false;
    }
    //set current channel active
    $(item_cards[index]).addClass("active");
    var active_card=$('.channel_list li.active');
        if(active_card.length<1){
            $(item_cards[index-1]).addClass("active");
        }
    startScroll($('.channel_list li.active'));
      //reset_colourbar();
       //change the color key list between fav's channel and not fav's channel.
//        if (get_is_favorite_ch_by_mask($(item_cards[idx]).attr("channel_mask"))) {
//            set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);
//        } else {
//            //not favorite channel colourkey
//            set_colourkey_list_text(ColourKeyList_TV_normal_All_not_fav_state);
//        }
};
   

var favorite_edit_one_by_one_key_proc = function(kc) {
    var item_cards = $(".channel_list li");
    var active_card = kc.target.find(".channel_list li.active");
    var next_card=active_card.next();
    var pre_card=active_card.prev();
    var key = kc.keyCode || kc.which;
    var svl_id = next_card.attr("svl_id");
    var ch_id=next_card.attr("channel_id");
    var mask=next_card.attr("channel_mask");
    var svl_id_pre = pre_card.attr("svl_id");
    var ch_id_pre=pre_card.attr("channel_id");
    var mask_pre=pre_card.attr("channel_mask");
    var index =1;
   var idx = -1;
    /* not card */
    if (item_cards.length <= 0) {
       return false;
   }
   if (active_card.length > 0)
    idx = $.inArray(active_card[0], item_cards);
       /* handle DOWN key */
       index=idx;
       if (key == KeyEvent.DOM_VK_DOWN) {
           if(active_card.length <= 0){
			   
			var endScroll_id=$('#id_div_ch_type>.type_mid');
			com_end_scroll(endScroll_id); 
            $('#id_div_ch_type').removeClass('active');
            idx=-1;
            $('#ColorKey_Green').html(getTranslate("CHM_TEXTE_DONE"));
            }
            if(index==7||index==g_channel_cnt-1){
                return false;
            }
            if(index<6){
                index+=1;
            }
             idx+=1;
             if (index >= (item_cards.length-2)) {

              if(item_cards.length != 1){
                if(idx>=7){
                 is_last_channel=carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_next,1);
                item_cards = kc.target.find(".channel_list li");
				var svl_id_next=item_cards.eq(7).attr("svl_id");
		        var ch_id_next=item_cards.eq(7).attr("channel_id");
		        var nw_mask_next=get_current_mask();
		        var mask_value_next= get_current_mask_value();
		        var idx_next = get_index_by_channel_id(svl_id_next, nw_mask_next, mask_value_next, ch_id_next);
                if(idx_next==g_channel_cnt-1){
			       is_need_hide_dowm=true;
		        }
                idx = item_cards.length - 1;
                 show_or_hide_arrow();
                }
                if(is_last_channel){
                    index=7;
                    is_last_channel=false;
                    
                }
             }else {
                 idx -= 1;
             }
         }
       }
       /* handle UP key */
       else if (key == KeyEvent.DOM_VK_UP) {

        if (index <= 0) {
          return false;
        }
       
          idx -= 1;
           if(index>1){
              index-=1;
          }
          /* save last selected idx */
         if (index <=1) {
                if(item_cards.length != 1){
                        if(index==0){
                            endScroll(active_card);
							var startScroll_id=$('#id_div_ch_type>.type_mid');
							com_start_scroll(startScroll_id);
                            item_cards.removeClass('active');
                            $('#id_div_ch_type').addClass('active');
                            $('#ColorKey_Green').html('');
                            return false;
                         }
                        if(idx<=0){
                        is_first_channel=carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id_pre,ch_id_pre,DirectionList.Direction_pre,1);
                        item_cards = kc.target.find(".channel_list li");
						var svl_id_pre=item_cards.eq(0).attr("svl_id");
				        var ch_id_pre=item_cards.eq(0).attr("channel_id");
				        var nw_mask_pre=get_current_mask();
				        var mask_value_pre= get_current_mask_value();
				        var idx_pre = get_index_by_channel_id(svl_id_pre, nw_mask_pre, mask_value_pre, ch_id_pre);
                        if(idx_pre==0){
					         is_need_hide_up=true;
				        }
                        idx=0;
                        show_or_hide_arrow();
                        }
                        if (is_first_channel) {
                            index=0;
                            is_first_channel=false;
//                             item_cards.removeClass('active');
//                             $('#id_div_ch_type').addClass('active');
//                             $('#ColorKey_Green').html('');
//                             return false;
                        }
                }else {
                    item_cards.removeClass('active');
                    $('#id_div_ch_type').addClass('active');
                    $('#ColorKey_Green').html('');
                    return false;
                }
            }
       }
	   	else if(key == KeyEvent.DOM_VK_CH_DECREASE){
			var cur_page_last_item=item_cards.eq(7);
			if(cur_page_last_item.length>0){
				svl_id =cur_page_last_item.attr("svl_id");
				ch_id  =cur_page_last_item.attr("channel_id");
				var cur_idx = get_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
				if(cur_idx==g_channel_cnt-1){
					return false;
				}else if(cur_idx>=g_channel_cnt-9){
				    is_need_hide_dowm=true;
				}
				mun =Math.min(g_channel_cnt-cur_idx, CAROUSEL_ITEM_CNT);
			    active_card.removeClass("active");
				carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_next,mun);
				item_cards=$(".channel_list li");
				item_cards.eq(1).addClass("active");
				show_or_hide_arrow();
				startScroll($('.channel_list li.active'));
				return false;
			}else{
				return false;
			}
		}
		else if(key == KeyEvent.DOM_VK_CH_INCREASE){
			var cur_page_frist_item=item_cards.eq(0);
			if(cur_page_frist_item.length>0){
				svl_id =cur_page_frist_item.attr("svl_id");
				ch_id  =cur_page_frist_item.attr("channel_id");
				var cur_idx = get_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
				if(cur_idx==0){
					return false;
				}else if(cur_idx<=8){
                    is_need_hide_up=true;
                }
				
			    active_card.removeClass("active");
				carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_pre,CAROUSEL_ITEM_CNT);
				item_cards=$(".channel_list li");
				item_cards.eq(1).addClass("active");
				show_or_hide_arrow();
				startScroll($('.channel_list li.active'));
				
				return false;
			}else{
				return false;
			}
		}

       /* handle OK key */
       else if (key == KeyEvent.DOM_VK_RETURN ) {
           console.log("REC: DOM_VK_RETURN key");
           if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
           console.log(channel_id);
           try {
                 svl_id = $(active_card[0]).attr("svl_id");
                 ch_mask = $(active_card[0]).attr("channel_mask");
                 var is_new = (MaskList.Mask_new & ch_mask) == MaskList.Mask_new;
                 var is_favorite  = (MaskList.Mask_favorite & ch_mask) == MaskList.Mask_favorite;
                 var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                  set_favorite_ch_id(svl_id, channel_id, ch_mask, FAVORITE_TYPE_0);
                 if (is_new) {
                     /* hidden new icon */
                     $('[channel_id="' + channel_id + '"] .card-new-icon').hide();
                 }
                 if(is_lock){
                     if (is_favorite) {
                       $('[channel_id="'+channel_id+'"] .icon_fav_div').removeClass('fav_icon');
                       $('[channel_id="'+channel_id+'"] .icon_lock_div').removeClass('lock_icon_left').addClass('lock_icon_right');
                       $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_all').addClass('class_logo_lock');

                     }else {
                         $('[channel_id="'+channel_id+'"] .icon_lock_div').removeClass('lock_icon_right').addClass('lock_icon_left');
                         $('[channel_id="'+channel_id+'"] .icon_fav_div').addClass('fav_icon');
                         $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_lock').addClass('class_logo_all');
                     }
                 }else{
                     if(is_favorite){
                       $('[channel_id="'+channel_id+'"] .icon_fav_div').removeClass('fav_icon');
                       $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_fav').addClass('class_logo_null');

                     }else{
                         $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_null').addClass('class_logo_fav');
                         $('[channel_id="'+channel_id+'"] .icon_fav_div').addClass('fav_icon');
                     }
                 }

           ch_mask_toggle = ch_mask ^= SB_VENT_FAVORITE; /* XOR */
           $(active_card[0]).attr("channel_mask", ch_mask_toggle);

         }
           catch (err) {
               console.log("error for set channel id!");
               console.log(err);
           }

       }else{
            $('#id_div_ch_type').removeClass('active');
              create_dialog_layout();
             return false;
       }
       }

       /* handle GREEN key */
       else if (key == KeyEvent.DOM_VK_GREEN) {
            $("#channel_list_ul").html("");
           console.log("REC: DOM_VK_GREEN key");
           if (get_favorite_length() <= 0){
                //no favorite channel in favorite_list layout
                Favorite_edit_create_favorite_state_layout();
                //set active mode
                set_active_mode(ModeList.Mode_Favorite_create_favorite);

            }else{
                if ((submenu_selected_id == 'tv_submenu_bar_0'||submenu_selected_id == 'tv_submenu_bar_1')){
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_favorite);
                }
                else{
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_favorite);
                }

                TV_normal_favorite_state_layout();
                var active_card=$('.channel_list li.active');
                if (active_card.length<=0) {
                   $("#channel_list_ul>li:first-child").addClass('active');
               }

                if (get_is_favorite_ch_by_mask($(item_cards[idx]).attr("channel_mask"))) {
                    set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);
                } else {
                    //not favorite channel colourkey
                set_colourkey_list_text(ColourKeyList_TV_normal_All_not_fav_state);
                }
                set_active_mode(ModeList.Mode_TV_normal_favorite);
				mtvObj.acfgSetConfigString("g_channel_matrix_of_favchannels",get_favorite_length()); // Randy.xiao add for CUL event id 19
            }
            return true;

       }
       else if (key == KeyEvent.DOM_VK_CHANNEL_OSD) {
           if (g_t_timer_delay_exit != null) {
               clearTimeout(g_t_timer_delay_exit);
               g_t_timer_delay_exit = null;
           }
            console.log("Exit Channel List");
            mtvuiUtil.gotoSysPage("sys_channel_zapper"); /* Go to root page */
           return false;
       }
       /* handle OPTION key */
       else if (key == KeyEvent.DOM_VK_BLUE) {

           console.log("REC: DOM_VK_BLUE key");
           jump_to_help_page();
            mtvuiUtil.gotoSysPage("sys_index");
           return true;

       }
       /* handle OPTION key */
       else if (key == KeyEvent.DOM_VK_OPTION) {
        if(mtvObj.acfgGetConfigValue("g_bs__bs_sat_brdcster")==31){
           if ($('#id_div_ch_type').hasClass("active")) {
              $('#id_div_ch_type').removeClass('active');
              if(get_favorite_length() <= 0){
                  option_show_func(on_header_option_unfav_bu);
              }else {
                  option_show_func(on_header_option_fav_bu);
              }

        }else{
        if (current_tuner_type == TunerType_list.TunerType_satellite) {
            /* Satellite tuner type */
           switch (parseInt(get_cur_ch_list_type())) {
                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                    svl_id = $(active_card[0]).attr("svl_id");
                    ch_mask = $(active_card[0]).attr("channel_mask");
                    var is_lock = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                    if(is_lock){
                        option_show_func(new_option_is_lock_bu);
                    }else {
                        option_show_func(new_option_is_unlock_bu);
                    }
                        break;
                    default:
                        svl_id = $(active_card[0]).attr("svl_id");
                        ch_mask = $(active_card[0]).attr("channel_mask");
                        //var is_lock = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;

                        if(is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()){
                                option_show_func(SA_all_normal_option_EDIT_FAV_islock_unfav_bu);
                            }else if (is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_islock_unfav_UN_bu);
                            }else if (is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_islock_fav_bu);
                            }else if (is_lock && get_favorite_length() > 0 && !is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_islock_fav_UN_bu);
                            }else if (!is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_unfav_bu);
                            }else if (!is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_unfav_UN_bu);
                            }else if (!is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_fav_bu);
                            }else {
                                option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_fav_UN_bu);
                            }

                            break;
                        }
            } else {
                switch (parseInt(get_cur_ch_list_type())) {

                case ChannelListTypeList.ChannelListType_tv_new:
                case ChannelListTypeList.ChannelListType_satellite_new:
                svl_id = $(active_card[0]).attr("svl_id");
                ch_mask = $(active_card[0]).attr("channel_mask");
                var is_lock = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                if(is_lock){
                    option_show_func(new_option_is_lock);
                }else {
                    option_show_func(new_option_is_unlock);
                }
                    break;
                default:
                    svl_id = $(active_card[0]).attr("svl_id");
                    ch_mask = $(active_card[0]).attr("channel_mask");
                    //var is_lock = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                    if(is_lock && get_favorite_length() <= 0){
                            option_show_func(TV_all_normal_option_EDIT_FAV_islock_unfav);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(TV_all_normal_option_EDIT_FAV_islock_fav);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_unfav);

                        }else {
                            option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_fav);
                        }
                    break;
                }
            }
            return false;
       }
    }else{
        if ($('#id_div_ch_type').hasClass("active")) {
        $('#id_div_ch_type').removeClass('active');
            if(get_favorite_length() <= 0){
			    if(is_disable_move_fct()){
					option_show_func(on_header_option_unfav_UK);  
				  }else{
					option_show_func(on_header_option_unfav);
				  }
                  
                }else {
				  if(is_disable_move_fct()){
					option_show_func(on_header_option_fav_UK);  
				  }else{
					option_show_func(on_header_option_fav);
				  }
                }

        }else{
        if (current_tuner_type == TunerType_list.TunerType_satellite) {
            /* Satellite tuner type */
           switch (parseInt(get_cur_ch_list_type())) {
                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                    svl_id = $(active_card[0]).attr("svl_id");
                    ch_mask = $(active_card[0]).attr("channel_mask");
                    var is_lock = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                    if(is_lock){
                        option_show_func(new_option_is_lock);
                    }else {
                        option_show_func(new_option_is_unlock);
                    }
                        break;
                    default:
                        svl_id = $(active_card[0]).attr("svl_id");
                        ch_mask = $(active_card[0]).attr("channel_mask");
                       // var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;

                        if(is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()){
                                option_show_func(SA_all_normal_option_EDIT_FAV_islock_unfav);
                            }else if (is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_islock_unfav_UN);
                            }else if (is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_islock_fav);
                            }else if (is_lock && get_favorite_length() > 0 && !is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_islock_fav_UN);
                            }else if (!is_lock && get_favorite_length() <= 0 && is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_unfav);
                            }else if (!is_lock && get_favorite_length() <= 0 && !is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_unfav_UN);
                            }else if (!is_lock && get_favorite_length() > 0 && is_enable_swap_fct()) {
                                option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_fav);
                            }else {
                                option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_fav_UN);
                            }

                            break;
                        }
        } else {
            switch (parseInt(get_cur_ch_list_type())) {

                case ChannelListTypeList.ChannelListType_tv_new:
                case ChannelListTypeList.ChannelListType_satellite_new:
                svl_id = $(active_card[0]).attr("svl_id");
                ch_mask = $(active_card[0]).attr("channel_mask");
                var is_lock = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                if(is_lock){
                    option_show_func(new_option_is_lock);
                }else {
                    option_show_func(new_option_is_unlock);
                }
                    break;
                default:
                    svl_id = $(active_card[0]).attr("svl_id");
                    ch_mask = $(active_card[0]).attr("channel_mask");
                   // var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                    if(is_lock && get_favorite_length() <= 0){
                            option_show_func(TV_all_normal_option_EDIT_FAV_islock_unfav);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(TV_all_normal_option_EDIT_FAV_islock_fav);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_unfav);

                        }else {
                              if(RegionCode == eRegionCode.PLF_OPT_REGION_KR)
                              {
                                  option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_fav_RegionKR);
                              }
                              else
                              {
                                  option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_fav);
                              }
                        }
                    break;
                }
        }
        return false;
       }
    }
   }

       else if (key == KeyEvent.DOM_VK_BACK) {
           return false;

       }
       //clear all channel active class
       active_card.removeClass('active');
      if (item_cards.length <= 0) {
          return false;
      }
      //set current channel active
      $(item_cards[index]).addClass("active");
       var active_card = kc.target.find(".channel_list li.active");
           if(active_card.length<1){
                $(item_cards[index-1]).addClass("active");
           }
      startScroll($('.channel_list li.active'));
   return true;
};

var startRangeIndex = null;
var endRangeIndex = null;
function addOrMoveFavorite(ch_id) {

        if(start_id != ch_id){
            if($('[channel_id="'+ch_id+'"]').attr('class')=='car_range_favorite_icon active'||$('[channel_id="'+end_id+'"]').attr('class')=='active car_range_favorite_icon'){
                    $('[channel_id="'+ch_id+'"]').removeClass('car_range_favorite_icon');
            }else {
                $('[channel_id="'+ch_id+'"]').addClass('car_range_favorite_icon');
            }
      }else{
        return false;
      }
}
var favorite_edit_by_block_key_proc = function(kc) {
    var item_cards = $(".channel_list li");
   var active_card = kc.target.find(".channel_list li.active");
   var key = kc.keyCode || kc.which;
   var svl_id = active_card.attr("svl_id");
   var ch_id=active_card.attr("channel_id");
   var nw_mask=active_card.attr("channel_mask");
   var idx = -1;
    /* not card */
    if (item_cards.length <= 0) {
       return false;
   }
   if (active_card.length > 0)
    idx = $.inArray(active_card[0], item_cards);
       /* handle DOWN key */
       if (key == KeyEvent.DOM_VK_DOWN) {
         idx += 1;
         if(idx > (item_cards.length-1)){
         carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_next,1);

           item_cards = kc.target.find(".channel_list li");
		   var svl_id_next=item_cards.eq(7).attr("svl_id");
		   var ch_id_next=item_cards.eq(7).attr("channel_id");
		   var nw_mask_next=get_current_mask();
		   var mask_value_next= get_current_mask_value();
		   var idx_next = get_index_by_channel_id(svl_id_next, nw_mask_next, mask_value_next, ch_id_next);
           if(idx_next==g_channel_cnt-1){
			  is_need_hide_dowm=true;
		   }
           idx = item_cards.length - 1;
           show_or_hide_arrow();
           }
       }
       /* handle UP key */
       else if (key == KeyEvent.DOM_VK_UP) {
         idx -= 1;
           /* save last selected idx */
           if(idx <0){
             carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_pre,1);
             item_cards = kc.target.find(".channel_list li");
			 var svl_id_pre=item_cards.eq(0).attr("svl_id");
			 var ch_id_pre=item_cards.eq(0).attr("channel_id");
			 var nw_mask_pre=get_current_mask();
			 var mask_value_pre= get_current_mask_value();
			 var idx_pre = get_index_by_channel_id(svl_id_pre, nw_mask_pre, mask_value_pre, ch_id_pre);
             if(idx_pre==0){
				is_need_hide_up=true;
			 }
             idx=0;
             show_or_hide_arrow();
           }
       }
       /* handle GREEN key */
       else if (key == KeyEvent.DOM_VK_GREEN) {
            $("#channel_list_ul").html("");
           console.log("REC: DOM_VK_GREEN key");
           if (get_favorite_length() <= 0){

                //no favorite channel in favorite_list layout
                Favorite_edit_create_favorite_state_layout();
                //set active mode
                set_active_mode(ModeList.Mode_Favorite_create_favorite);

            }else{
                if ((submenu_selected_id == 'tv_submenu_bar_0' || submenu_selected_id == 'tv_submenu_bar_1')){
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_favorite);
                }
                else{
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_favorite);
                }

                TV_normal_favorite_state_layout();
                var active_card=$('.channel_list li.active');
                if (active_card.length<=0) {
                   $("#channel_list_ul>li:first-child").addClass('active');
               }

               if (get_is_favorite_ch_by_mask($(item_cards[idx]).attr("channel_mask"))) {
                   set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);
                } else {
                    //not favorite channel colourkey
                set_colourkey_list_text(ColourKeyList_TV_normal_All_not_fav_state);
                }
                set_active_mode(ModeList.Mode_TV_normal_favorite);
            }
            return true;

       }
       else if (key == KeyEvent.DOM_VK_CHANNEL_OSD) {
           if (g_t_timer_delay_exit != null) {
               clearTimeout(g_t_timer_delay_exit);
               g_t_timer_delay_exit = null;
           }
            console.log("Exit Channel List");
            mtvuiUtil.gotoSysPage("sys_channel_zapper"); /* Go to root page */
           return false;
       }
       /* handle OPTION key */
       else if (key == KeyEvent.DOM_VK_BLUE) {

           console.log("REC: DOM_VK_BLUE key");
           jump_to_help_page();
            mtvuiUtil.gotoSysPage("sys_index");
           return true;

       }
       /* handle OPTION key */
       else if (key == KeyEvent.DOM_VK_OPTION) {

           console.log("REC: DOM_VK_OPTION key");
        if(mtvObj.acfgGetConfigValue("g_bs__bs_sat_brdcster")==31){
            if ($('#id_div_ch_type').hasClass("active")) {
                $('#id_div_ch_type').removeClass('active');
            if(get_favorite_length() <= 0){
                  option_show_func(on_header_option_unfav_bu);
              }else {
                  option_show_func(on_header_option_fav_bu);
              }
            }else{
            if (current_tuner_type == TunerType_list.TunerType_satellite) {
                /* Satellite tuner type */
               switch (parseInt(get_cur_ch_list_type())) {
                        case ChannelListTypeList.ChannelListType_tv_new:
                        case ChannelListTypeList.ChannelListType_satellite_new:
                        svl_id = $(active_card[0]).attr("svl_id");
                        ch_mask = $(active_card[0]).attr("channel_mask");
                        var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                        if(is_lock){
                            option_show_func(new_option_is_lock_bu);
                        }else {
                            option_show_func(new_option_is_unlock_bu);
                        }
                            break;
                        default:
                        svl_id = $(active_card[0]).attr("svl_id");
                        ch_mask = $(active_card[0]).attr("channel_mask");
                        var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                        if(is_lock && get_favorite_length() <= 0){
                            option_show_func(SA_all_normal_option_EDIT_FAV_islock_unfav_bu);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(SA_all_normal_option_EDIT_FAV_islock_fav_bu);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_unfav_bu);

                        }else {
                            option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_fav_bu);
                        }
                                break;
                            }
            } else {
                switch (parseInt(get_cur_ch_list_type())) {

                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                    svl_id = $(active_card[0]).attr("svl_id");
                    ch_mask = $(active_card[0]).attr("channel_mask");
                    var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                    if(is_lock){
                        option_show_func(new_option_is_lock);
                    }else {
                        option_show_func(new_option_is_unlock);
                    }
                        break;
                    default:
                    svl_id = $(active_card[0]).attr("svl_id");
                    ch_mask = $(active_card[0]).attr("channel_mask");
                    var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                    if(is_lock && get_favorite_length() <= 0){
                            option_show_func(TV_all_normal_option_EDIT_FAV_islock_unfav);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(TV_all_normal_option_EDIT_FAV_islock_fav);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_unfav);

                        }else {
                            option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_fav);
                        }
                        break;
                    }
            }
            return false;

          }
        }else{
          if ($('#id_div_ch_type').hasClass("active")) {
          $('#id_div_ch_type').removeClass('active');
              if(get_favorite_length() <= 0){
			    if(is_disable_move_fct()){
					option_show_func(on_header_option_unfav_UK);  
				  }else{
					option_show_func(on_header_option_unfav);
				  }
                  
                }else {
				  if(is_disable_move_fct()){
					option_show_func(on_header_option_fav_UK);  
				  }else{
					option_show_func(on_header_option_fav);
				  }
                }
            }else{
            if (current_tuner_type == TunerType_list.TunerType_satellite) {
                /* Satellite tuner type */
               switch (parseInt(get_cur_ch_list_type())) {
                        case ChannelListTypeList.ChannelListType_tv_new:
                        case ChannelListTypeList.ChannelListType_satellite_new:
                        svl_id = $(active_card[0]).attr("svl_id");
                        ch_mask = $(active_card[0]).attr("channel_mask");
                        var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                        if(is_lock){
                            option_show_func(new_option_is_lock);
                        }else {
                            option_show_func(new_option_is_unlock);
                        }
                            break;
                        default:
                        svl_id = $(active_card[0]).attr("svl_id");
                        ch_mask = $(active_card[0]).attr("channel_mask");
                        var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                        if(is_lock && get_favorite_length() <= 0){
                            option_show_func(SA_all_normal_option_EDIT_FAV_islock_unfav);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(SA_all_normal_option_EDIT_FAV_islock_fav);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_unfav);

                        }else {
                            option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_fav);
                        }
                                break;
                            }
            } else {
                switch (parseInt(get_cur_ch_list_type())) {

                    case ChannelListTypeList.ChannelListType_tv_new:
                    case ChannelListTypeList.ChannelListType_satellite_new:
                    svl_id = $(active_card[0]).attr("svl_id");
                    ch_mask = $(active_card[0]).attr("channel_mask");
                    var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                    if(is_lock){
                        option_show_func(new_option_is_lock);
                    }else {
                        option_show_func(new_option_is_unlock);
                    }
                        break;
                    default:
                    svl_id = $(active_card[0]).attr("svl_id");
                    ch_mask = $(active_card[0]).attr("channel_mask");
                    var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                    if(is_lock && get_favorite_length() <= 0){
                            option_show_func(TV_all_normal_option_EDIT_FAV_islock_unfav);
                        }else if (is_lock && get_favorite_length() > 0) {
                            option_show_func(TV_all_normal_option_EDIT_FAV_islock_fav);
                        }else if (!is_lock && get_favorite_length() <= 0) {
                            option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_unfav);

                        }else {
                            option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_fav);
                        }
                        break;
                    }
            }
            return false;

          }
        }

       }

       /* handle UP key */
       else if (key == KeyEvent.DOM_VK_BACK) {
          // reset_submenu_focus();
           return false;

       }

       //clear all channel active class
       active_card.removeClass('active');
      if (item_cards.length <= 0) {
          return false;
      }
      //set current channel active
      $(item_cards[idx]).addClass("active");
      end_id= parseInt($(item_cards[idx]).attr('channel_id'));
      startScroll($('.channel_list li.active'));
      addOrMoveFavoriteStyle();

            /* handle OK key */
            if(key == KeyEvent.DOM_VK_RETURN){
                /* set current channel list type */
                if ((submenu_selected_id == 'tv_submenu_bar_1'||submenu_selected_id == 'tv_submenu_bar_0')) {
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_favorite);
                }
                else {
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_favorite);
                }
                    var ch = mtvObj.getCurrentChannelInfoForEachTuner();
                    var start_idx = get_index_by_channel_id (ch.SVL_ID, MaskList.Mask_all, MaskList.Mask_all, start_id);
                    var end_idx = get_index_by_channel_id (ch.SVL_ID, MaskList.Mask_all, MaskList.Mask_all, end_id);
                    if (start_idx < end_idx) {
                        for (var i = start_idx; i <= end_idx; i++) {
                            /* get channel info by idx */
                            var ch_info = get_channel_info_by_idx(ch.SVL_ID, MaskList.Mask_all, MaskList.Mask_all, i);
                            set_favorite_channel_by_svl_and_ch_id(ch_info.ITEMS[0].SVL_ID, ch_info.ITEMS[0].CHANNEL_ID, ch_info.ITEMS[0].NW_MASK, FAVORITE_TYPE_0);
                        }
                    } else {
                        for (var i = end_idx; i <=start_idx ; i++) {
                           /* get channel info by idx */
                           var ch_info = get_channel_info_by_idx(ch.SVL_ID, MaskList.Mask_all, MaskList.Mask_all, i);
                           set_favorite_channel_by_svl_and_ch_id(ch_info.ITEMS[0].SVL_ID, ch_info.ITEMS[0].CHANNEL_ID, ch_info.ITEMS[0].NW_MASK, FAVORITE_TYPE_0);
                       }
                    }

                    /* store to acfg */
                    store_channel_list_to_acfg();
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_default);
                    set_active_mode(ModeList.Mode_favorite_edit_by_range_before);
                }
    };


var start_id = 0;
var end_id = 0 ;
var windowIndex = 0;
var itemIndex = 0;
function addOrMoveFavoriteStyle() {
    var item_cards=$('.channel_list li');
    $(".channel_list li:lt(" + CAROUSEL_ITEM_CNT + ")").removeClass("car_range_favorite_icon");
    var idx=0;
    if(start_id != end_id){
    for(idx;idx<8;idx++){
        var channel_id =parseInt(item_cards.eq(idx).attr('channel_id'));

            if(start_id<end_id){
                if(channel_id>start_id && channel_id<=end_id){
                    $('[channel_id="'+start_id+'"]').addClass('car_range_favorite_icon');
                    $('[channel_id="'+channel_id+'"]').addClass('car_range_favorite_icon');
                }
            }else {
                if(channel_id>=end_id &&channel_id<start_id){
                    $('[channel_id="'+start_id+'"]').addClass('car_range_favorite_icon');
                    $('[channel_id="'+channel_id+'"]').addClass('car_range_favorite_icon');
                }
            }
      }
    }
    else{
        $('[channel_id="'+start_id+'"]').addClass('active car_range_favorite_icon');
        return false;
    }
}

function mark_all_as_favourites_key_proc(kc) {
    var idx = -1;
    var key = kc.keyCode || kc.which;
    var cards_all = kc.target.find(".channel_list li");
    /* handle UP key */
    if (key == KeyEvent.DOM_VK_UP) {
        $("#mark-all-as-fav").hide();
        $("#colour_bar").show();
        set_active_mode(ModeList.Mode_Favorite_edit_one_by_one);
        return false;
    }
    /* handle LEFT key */
    else if (key == KeyEvent.DOM_VK_RIGHT) {
        console.log("Rec DOM_VK_RIGHT");
        // mark_all_btn_yes mark_all_btn_no
        $('#mark_all_btn_yes').addClass('active_bnt');
        $('#mark_all_btn_no').removeClass('active_bnt').addClass('btn-select-style');

        return true;
    }
    /* handle RIGHT key */
    else if (key == KeyEvent.DOM_VK_LEFT) {
        console.log("Rec DOM_VK_LEFT");

        $('#mark_all_btn_no').addClass('active_bnt');
        $('#mark_all_btn_yes').removeClass('active_bnt').addClass('btn-select-style');

        return true;
    }
    /* handle OK key */
    else if (key == KeyEvent.DOM_VK_RETURN) {

        console.log("REC: DOM_VK_RETURN key");

        var btn_id = $('.btn_all.btn-select-style.unmark.active_bnt').attr('id');
        if (btn_id == "mark_all_btn_yes"||btn_id == "btn-ok") {

            var yesvalue = $("#mark_all_btn_yes").attr("value");
            var ch = mtvObj.getCurrentChannelInfoForEachTuner();

            if (yesvalue == "mark") {
                /* if focus at OK button should jump to ALL menu to add favorite item */
                var channel_id = null;
                if (cards_all.length < 0) {
                    return false;
                }

                /* add favorite style */
                for (var i = 0; i < cards_all.length; i++) {
                    if (channel_id = $(cards_all[i]).attr("channel_id")) {

                        try {
                            svl_id = $(cards_all[i]).attr("svl_id");
                            ch_mask = $(cards_all[i]).attr("channel_mask");
                            /* show/hidden favorite icon */
                            if ((MaskList.Mask_new & ch_mask) == MaskList.Mask_new) {
                                /* hide new icon first */
                                $('[channel_id="' + channel_id + '"] .card-new-icon').hide();
                            }
                            $('[channel_id="' + channel_id + '"] .icon_fav_div').show();

                        }
                        catch (err) {
                            console.log("error for set channel id!");
                            console.log(err);
                        }

                    }
                }

                /* add all channel to favourite list */
                mtvObj.chFavListAddAll(ch.SVL_ID, MaskList.Mask_all, MaskList.Mask_all, FAVORITE_TYPE_0);
          

            } else {
      
                mtvObj.chFavListDelAll(ch.SVL_ID, MaskList.Mask_all, MaskList.Mask_all, FAVORITE_TYPE_0);
                is_all_chFavList_del = true; /* 20170728 [TF518PHIEUMTK01-378] */
            }
            /* store to acfg */
            store_channel_list_to_acfg();

            /* hide the favorite dialog. */
            $("#mark-all-as-fav").hide();
           back_to_last_active_mode();
             reset_colourbar();
        }
        else {
            /* return to parent's level */
             back_to_last_active_mode();
             reset_colourbar();
            /* hide the favorite dialog. */
            $("#mark-all-as-fav").hide();
        }
        $("#colour_bar").show();
        return true;
    }
}

function get_current_active_channel_card() {
     return ($("#channel_list_ul").find(".active"));
}
function lock_unlock_channel() {
    var channel_id = null;
    var active_card = get_current_active_channel_card();
    if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
        console.log(channel_id);

        try {
            var channel_id = null;
            if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
                console.log(channel_id);

                try {
                    svl_id = $(active_card[0]).attr("svl_id");
                    ch_mask = $(active_card[0]).attr("channel_mask");
                    var is_favorite  = (MaskList.Mask_favorite & ch_mask) == MaskList.Mask_favorite;
                    var is_lock = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                    var is_new         = (MaskList.Mask_new & ch_mask) == MaskList.Mask_new;

                    if (is_lock) {
                        //unlock
                        unlock_channel_by_svl_and_ch_id(svl_id, channel_id, ch_mask);
                        $("#option_menu_2").html(getTranslate(option_channle_islock.CHM_OPTL_LOCK_CHANNEL));
                        $(active_card[0]).attr("channel_mask", (ch_mask & ~SB_VENT_BLOCKED));
                    } else {
                        lock_channel_by_svl_and_ch_id(svl_id, channel_id, ch_mask);
                        $("#option_menu_2").html(getTranslate(option_channle_islock.CHM_OPTL_UNLOCK_CHANNEL));
                        $(active_card[0]).attr("channel_mask", (ch_mask | SB_VENT_BLOCKED));
                    }

                    /* show/hide lock icon */
                   if(is_lock){
                     if (is_favorite) {
                       $('[channel_id="'+channel_id+'"] .icon_lock_div').removeClass('lock_icon_left');
                       $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_all').addClass('class_logo_fav');

                     }else {
                         $('[channel_id="'+channel_id+'"] .icon_lock_div').removeClass('lock_icon_right');
                         if(is_new){
                             $('[channel_id="'+channel_id+'"] .icon_lock_div').addClass('new_icon_right');
                         }else {
                             $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_lock').addClass('class_logo_null');
   
                         }
                     }
                   }else{
                     if(is_favorite){
                       $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_fav').addClass('class_logo_all');
                       $('[channel_id="'+channel_id+'"] .icon_lock_div').addClass('lock_icon_left');

                     }else{
                         $('[channel_id="'+channel_id+'"] .icon_div').removeClass('class_logo_null').addClass('class_logo_lock');
                         if(is_new){
                             $('[channel_id="'+channel_id+'"] .icon_lock_div').removeClass('new_icon_right');
                             $('[channel_id="'+channel_id+'"] .icon_lock_div').addClass('lock_icon_right');
                         }else {
                             $('[channel_id="'+channel_id+'"] .icon_lock_div').addClass('lock_icon_right');
   
                         }

                     }
                 }
                    setMemc_level(true);
                    back_to_last_active_mode();
                    /* reset colour bar */
                    reset_colourbar();

                }
                catch (err) {
                    console.log("error for set channel id!");
                    console.log(err);
                }
            }
        }
        catch (err) {
            console.log("error for set channel id!");
            console.log(err);
        }

    } //if
    /* store to acfg */
    store_channel_list_to_acfg();
}
function reset_colourbar() {
    switch (parseInt(get_cur_ch_list_type())) {
        case ChannelListTypeList.ChannelListType_tv_favorite:
        case ChannelListTypeList.ChannelListType_satellite_favorite:
            set_colourkey_list_text(ColourKeyList_TV_normal_Favorite_state);
            break;
        default:
            var active_card = get_current_active_channel_card();
            if (active_card.length <= 0) {
                return;
            }

            if (active_mode == ModeList.Mode_Favorite_edit_one_by_one) {
                set_colourkey_list_text(ColourKeyList_Favorite_edit_one_by_one_state);
                break;
            }
			/* 20170728 [TF518PHIEUMTK01-378] */ 
			if ((active_mode == ModeList.Mode_TV_normal_all || active_mode == ModeList.Mode_TV_normal_tv || ModeList.Mode_TV_normal_radio) && true == is_all_chFavList_del) {
                set_colourkey_list_text(ColourKeyList_TV_normal_All_not_fav_state);
                is_all_chFavList_del = false;
                break;
            }

            if (get_is_favorite_ch_by_mask($(active_card[0]).attr("channel_mask"))) {
                set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);
            } else {
                //not favorite channel colourkey
                set_colourkey_list_text(ColourKeyList_TV_normal_All_not_fav_state);
            }
            break;
    }
    /* show colour bar. */
    show_colourbar();
}

var move_state_before_move_key_proc = function(kc) {
  var item_cards = $(".channel_list li");
    var active_card = kc.target.find(".channel_list li.active");
    var next_card=active_card.next();
    var pre_card=active_card.prev();
    var key = kc.keyCode || kc.which;
    var svl_id = next_card.attr("svl_id");
    var ch_id=next_card.attr("channel_id");
    var mask=next_card.attr("channel_mask");
    var svl_id_pre = pre_card.attr("svl_id");
    var ch_id_pre=pre_card.attr("channel_id");
    var mask_pre=pre_card.attr("channel_mask");
    var index =1;
   if (active_card.length > 0)
        idx = $.inArray(active_card[0], item_cards);
        index=idx;

    /* not card */
    if (item_cards.length <= 0) {
        Favorite_edit_create_favorite_state_layout();

        //set active mode
        set_active_mode(ModeList.Mode_Favorite_create_favorite);
       return false;
   }
 if (key == KeyEvent.DOM_VK_LEFT || key == KeyEvent.DOM_VK_RIGHT) {
           if (active_card.length<1) {
               $('#id_div_ch_type').removeClass('active');
               var active_card=item_cards.eq(idx).addClass('active');
			   var endScroll_id=$('#id_div_ch_type>.type_mid');
	           com_end_scroll(endScroll_id); 
			   startScroll(active_card);
               //reset_colourbar();
               set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);

           } else {
			   endScroll(active_card);
			   var startScroll_id=$('#id_div_ch_type>.type_mid');
	           com_start_scroll(startScroll_id);
               item_cards.removeClass('active');
               $('#id_div_ch_type').addClass('active');
               $('#ColorKey_Green').html('');
           }
           return false;
       }
 else {
     /* handle DOWN key */
     if (key == KeyEvent.DOM_VK_DOWN) {
         if(active_card.length <= 0){
         $('#id_div_ch_type').removeClass('active');
		 var endScroll_id=$('#id_div_ch_type>.type_mid');
	     com_end_scroll(endScroll_id); 
         idx=-1;
          set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);

         }
         if(index==7||index==g_channel_cnt-1){
                return false;
            }
            if(index<6){
                index+=1;
            }
       idx += 1;
       if(index >= (item_cards.length-2)){
         if(idx>=7){
         is_last_channel= carousel_add_channel_items(ModeList.Mode_TV_normal_favorite,svl_id,ch_id,DirectionList.Direction_next,1,FAVORITE_TYPE_0);
         item_cards = kc.target.find(".channel_list li");
		 var svl_id_next=item_cards.eq(7).attr("svl_id");
		 var ch_id_next=item_cards.eq(7).attr("channel_id");
		 var nw_mask_next=get_current_mask();
		 var mask_value_next= get_current_mask_value();
		 var idx_next = get_index_by_channel_id(svl_id_next, nw_mask_next, mask_value_next, ch_id_next);
         if(idx_next==g_channel_cnt-1){
			is_need_hide_dowm=true;
		 }
         idx = item_cards.length - 1;
         show_or_hide_arrow();
         }
         if(is_last_channel){
                    index=7;
                    is_last_channel=false;
                    
                }
         }
     }
     /* handle UP key */
     else if (key == KeyEvent.DOM_VK_UP) {
             if (active_card.length <= 0) {
                     return false;
                 }
             idx -= 1;
             if(index>1){
              index-=1;
             }
             if(index <=1){
                 if(item_cards.length != 1){
                      if(index==0){
                            endScroll(active_card);
						    var startScroll_id=$('#id_div_ch_type>.type_mid');
							com_start_scroll(startScroll_id);
                            item_cards.removeClass('active');
                            $('#id_div_ch_type').addClass('active');
                            $('#ColorKey_Green').html('');
                            return false;
                    }
                    if(idx<=0){
                       is_first_channel=carousel_add_channel_items(ModeList.Mode_TV_normal_favorite,svl_id_pre,ch_id_pre,DirectionList.Direction_pre,1,FAVORITE_TYPE_0);
                       item_cards = kc.target.find(".channel_list li");
					   var svl_id_pre=item_cards.eq(0).attr("svl_id");
				       var ch_id_pre=item_cards.eq(0).attr("channel_id");
				       var nw_mask_pre=get_current_mask();
				       var mask_value_pre= get_current_mask_value();
				       var idx_pre = get_index_by_channel_id(svl_id_pre, nw_mask_pre, mask_value_pre, ch_id_pre);
                       if(idx_pre==0){
					        is_need_hide_up=true;
				       }
                       idx=0;
                       show_or_hide_arrow();
                       }
                       if (is_first_channel) {
                           index=0;
                            is_first_channel=false;
//                            item_cards.removeClass('active');
//                            $('#id_div_ch_type').addClass('active');
//                            $('#ColorKey_Green').html('');
//                            return false;
                       }
                      
             }else{
                 item_cards.removeClass('active');
                    $('#id_div_ch_type').addClass('active');
                    $('#ColorKey_Green').html('');
                    return false;
             }
           }
     }
	 else if(key == KeyEvent.DOM_VK_CH_DECREASE){
			var cur_page_last_item=item_cards.eq(7);
			if(cur_page_last_item.length>0){
				svl_id =cur_page_last_item.attr("svl_id");
				ch_id  =cur_page_last_item.attr("channel_id");
				var cur_idx = get_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
				if(cur_idx==g_channel_cnt-1){
					return false;
				}else if(cur_idx>=g_channel_cnt-9){
				    is_need_hide_dowm=true;
				}
				mun =Math.min(g_channel_cnt-cur_idx, CAROUSEL_ITEM_CNT);
			    active_card.removeClass("active");
				carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_next,mun);
				item_cards=$(".channel_list li");
				item_cards.eq(1).addClass("active");
				show_or_hide_arrow();
				startScroll($('.channel_list li.active'));
				return false;
			}else{
				return false;
			}
		}
		else if(key == KeyEvent.DOM_VK_CH_INCREASE){
			var cur_page_frist_item=item_cards.eq(0);
			if(cur_page_frist_item.length>0){
				svl_id =cur_page_frist_item.attr("svl_id");
				ch_id  =cur_page_frist_item.attr("channel_id");
				var cur_idx = get_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
				if(cur_idx==0){
					return false;
				}else if(cur_idx<=8){
                    is_need_hide_up=true;
                }
				
			    active_card.removeClass("active");
				carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_pre,CAROUSEL_ITEM_CNT);
				item_cards=$(".channel_list li");
				item_cards.eq(1).addClass("active");
				show_or_hide_arrow();
				startScroll($('.channel_list li.active'));
				
				return false;
			}else{
				return false;
			}
		}

    /* handle GREEN key */
    else if (key == KeyEvent.DOM_VK_GREEN) {
         $("#channel_list_ul").html("");
        console.log("REC: DOM_VK_GREEN key");
        if (get_favorite_length() <= 0){
             //no favorite channel in favorite_list
             //layout
             Favorite_edit_create_favorite_state_layout();
             //set active mode
             set_active_mode(ModeList.Mode_Favorite_create_favorite);

         }else{
             if ((submenu_selected_id == 'tv_submenu_bar_0'||submenu_selected_id == 'tv_submenu_bar_1')){
                 set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_favorite);
             }
             else{
                 set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_favorite);
             }

             TV_normal_favorite_state_layout();
             var active_card=$('.channel_list li.active');
             if (active_card.length<=0) {
                $("#channel_list_ul>li:first-child").addClass('active');
            }

             if (get_is_favorite_ch_by_mask($(item_cards[idx]).attr("channel_mask"))) {
                 set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);
             } else {
                 //not favorite channel colourkey
             set_colourkey_list_text(ColourKeyList_TV_normal_All_not_fav_state);
             }
             set_active_mode(ModeList.Mode_TV_normal_favorite);
         }
         return true;

    }

      /* handle OK key */
      else if (key == KeyEvent.DOM_VK_RETURN) {

          console.log("REC: DOM_VK_RETURN key");
          //set active mode
          set_active_mode(ModeList.Mode_Move_moving);
          return false;
      }
      else if (key == KeyEvent.DOM_VK_CHANNEL_OSD) {
          if (g_t_timer_delay_exit != null) {
              clearTimeout(g_t_timer_delay_exit);
              g_t_timer_delay_exit = null;
          }
           console.log("Exit Channel List");
           mtvuiUtil.gotoSysPage("sys_channel_zapper"); /* Go to root page */
          return false;
      }
      /* handle BLUE key */
      else if (key == KeyEvent.DOM_VK_BLUE) {

          console.log("REC: DOM_VK_BLUE key");

          jump_to_help_page();
           mtvuiUtil.gotoSysPage("sys_index");
          return true;

      }

      else if (key == KeyEvent.DOM_VK_BACK) {
          //reset_submenu_focus();
          return false;

      }
      //clear all channel active class
      active_card.removeClass('active');
     if (item_cards.length <= 0) {
         return false;
     }
     //set current channel active
     $(item_cards[index]).addClass("active");
     var active_card=$('.channel_list li.active');
         if(active_card.length<1){
                $(item_cards[index-1]).addClass("active");
           }
     startScroll($('.channel_list li.active'));

  }
  return true;
};

/*
* Swap function
*/
var swap_state_before_move_key_proc = function(kc) {
    var item_cards = $(".channel_list li");
    var active_card = kc.target.find(".channel_list li.active");
    var key = kc.keyCode || kc.which;
    var svl_id = active_card.attr("svl_id");
    var ch_id=active_card.attr("channel_id");
    var mask=active_card.attr("channel_mask");

    if (active_card.length > 0)
         idx = $.inArray(active_card[0], item_cards);
       /* handle LEFT key */
     if (key == KeyEvent.DOM_VK_LEFT ||
            key == KeyEvent.DOM_VK_DOWN||
            key == KeyEvent.DOM_VK_UP||
        key == KeyEvent.DOM_VK_RIGHT ||
        key == KeyEvent.DOM_VK_CH_DECREASE ||
        key == KeyEvent.DOM_VK_CH_INCREASE ||
        key == KeyEvent.DOM_VK_BLUE) {
            /* key follow is the same as normal favorite key */
            tv_normal_all_key_proc(kc);
            //set color key text because tv_normal_all_key_proc rewrite the color key text
            $('#ColorKey_Green').html(getTranslate("CHM_TEXTE_DONE"));
            return false;
        }
        /* handle OK key */
        else if (key == KeyEvent.DOM_VK_RETURN) {

            console.log("REC: DOM_VK_RETURN key");
            Move_moving_state_layout();
            //set active mode
            set_active_mode(ModeList.Mode_Swap_moving);
            return false;
        }else if (key == KeyEvent.DOM_VK_GREEN) {
        	//clean channel items
        	$("#channel_list_ul").html("");
        	set_active_mode(ModeList.Mode_TV_normal_all);
			TV_normal_all_state_layout();
        }
    return true;
};

function favorite_edit_by_block_before_key_proc(kc){
     var item_cards = $(".channel_list li");
    var active_card = kc.target.find(".channel_list li.active");
    var next_card=active_card.next();
    var pre_card=active_card.prev();
    var key = kc.keyCode || kc.which;
    var svl_id = next_card.attr("svl_id");
    var ch_id=next_card.attr("channel_id");
    var mask=next_card.attr("channel_mask");
    var svl_id_pre = pre_card.attr("svl_id");
    var ch_id_pre=pre_card.attr("channel_id");
    var mask_pre=pre_card.attr("channel_mask");
    var index =1;
    var idx =-1;
    if (active_card.length > 0)
         idx = $.inArray(active_card[0], item_cards);

          // handle left, right key
          index=idx;
    
        /* handle DOWN key */
        if (key == KeyEvent.DOM_VK_DOWN) {
            if(active_card.length <= 0){
			var endScroll_id=$('#id_div_ch_type>.type_mid');
			com_end_scroll(endScroll_id); 
            $('#id_div_ch_type').removeClass('active');
            idx=-1;
            }
            if(index==7||index==g_channel_cnt-1){
                return false;
            }
            if(index<6){
                index+=1;
            }
          idx += 1;
          if (index >= (item_cards.length-2)) {
              if(item_cards.length != 1){
                  if(idx>=7){
                is_last_channel= carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_next,1);
                item_cards = kc.target.find(".channel_list li");
				var svl_id_next=item_cards.eq(7).attr("svl_id");
		        var ch_id_next=item_cards.eq(7).attr("channel_id");
		        var nw_mask_next=get_current_mask();
		        var mask_value_next= get_current_mask_value();
		        var idx_next = get_index_by_channel_id(svl_id_next, nw_mask_next, mask_value_next, ch_id_next);
                if(idx_next==g_channel_cnt-1){
			      is_need_hide_dowm=true;
		        }
                idx = item_cards.length - 1;
                show_or_hide_arrow();
                }
                if(is_last_channel){
                    index=7;
                    is_last_channel=false;
                    
                }
             }else {
                 idx -= 1;
             }
         }
        }
        /* handle UP key */
        else if (key == KeyEvent.DOM_VK_UP) {
            if (index<= 0) {
                    return false;
                }
          idx -= 1;
          if(index>1){
              index-=1;
          }
            /* save last selected idx */
            if (index <=1) {
                if(item_cards.length != 1){
                    if(index==0){                         
                            return false;
                    }
                       if(idx<=0){
                        is_first_channel=carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id_pre,ch_id_pre,DirectionList.Direction_pre,1);
                        item_cards = kc.target.find(".channel_list li");
						var svl_id_pre=item_cards.eq(0).attr("svl_id");
				        var ch_id_pre=item_cards.eq(0).attr("channel_id");
				        var nw_mask_pre=get_current_mask();
				        var mask_value_pre= get_current_mask_value();
				        var idx_pre = get_index_by_channel_id(svl_id_pre, nw_mask_pre, mask_value_pre, ch_id_pre);
                        if(idx_pre==0){
					         is_need_hide_up=true;
				        }
                        idx=0;
                        
                        show_or_hide_arrow();
                        }
                        if (is_first_channel) {
                            index=0;
                            is_first_channel=false;
                            //show_or_hide_arrow();

                            //item_cards.removeClass('active');
                           // $('#id_div_ch_type').addClass('active');
                            //$('#ColorKey_Green').html('');
                            //return false;
                        }
                }else {
                    item_cards.removeClass('active');
                    $('#id_div_ch_type').addClass('active');
                    $('#ColorKey_Green').html('');
                    return false;
                }
            }
        }
		else if(key == KeyEvent.DOM_VK_CH_DECREASE){
			var cur_page_last_item=item_cards.eq(7);
			if(cur_page_last_item.length>0){
				svl_id =cur_page_last_item.attr("svl_id");
				ch_id  =cur_page_last_item.attr("channel_id");
				var cur_idx = get_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
				if(cur_idx==g_channel_cnt-1){
					return false;
				}else if(cur_idx>=g_channel_cnt-9){
				    is_need_hide_dowm=true;
				}
				mun =Math.min(g_channel_cnt-cur_idx, CAROUSEL_ITEM_CNT);
			    active_card.removeClass("active");
				carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_next,mun);
				item_cards=$(".channel_list li");
				item_cards.eq(1).addClass("active");
				show_or_hide_arrow();
				startScroll($('.channel_list li.active'));
				return false;
			}else{
				return false;
			}
		}
		else if(key == KeyEvent.DOM_VK_CH_INCREASE){
			var cur_page_frist_item=item_cards.eq(0);
			if(cur_page_frist_item.length>0){
				svl_id =cur_page_frist_item.attr("svl_id");
				ch_id  =cur_page_frist_item.attr("channel_id");
				var cur_idx = get_index_by_channel_id(svl_id, get_current_mask(), get_current_mask_value(), ch_id);
				if(cur_idx==0){
					return false;
				}else if(cur_idx<=8){
                    is_need_hide_up=true;
                }
				
			    active_card.removeClass("active");
				carousel_add_channel_items(ModeList.Mode_TV_normal_all,svl_id,ch_id,DirectionList.Direction_pre,CAROUSEL_ITEM_CNT);
				item_cards=$(".channel_list li");
				item_cards.eq(1).addClass("active");
				show_or_hide_arrow();
				startScroll($('.channel_list li.active'));
				
				return false;
			}else{
				return false;
			}
		}

        /* handle OK key */
        else if (key == KeyEvent.DOM_VK_RETURN ) {

            console.log("REC: DOM_VK_RETURN key");
            active_card.addClass('car_range_favorite_icon');
            startRangeIndex = idx;
            endRangeIndex = startRangeIndex;
           start_id=parseInt(active_card.attr('channel_id'));
            set_active_mode(ModeList.Mode_favorite_edit_by_range);
        }

        /* handle GREEN key */
        else if (key == KeyEvent.DOM_VK_GREEN) {
             $("#channel_list_ul").html("");
            console.log("REC: DOM_VK_GREEN key");
            if (get_favorite_length() <= 0){
                 //no favorite channel in favorite_list
                 //layout
                 Favorite_edit_create_favorite_state_layout();
                 //set active mode
                 set_active_mode(ModeList.Mode_Favorite_create_favorite);

             }else{
                 if ((submenu_selected_id == 'tv_submenu_bar_0'||submenu_selected_id == 'tv_submenu_bar_1')){
                     set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_favorite);
                 }
                 else{
                     set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_favorite);
                 }

                 TV_normal_favorite_state_layout();
                 var active_card=$('.channel_list li.active');
                 if (active_card.length<=0) {
                    $("#channel_list_ul>li:first-child").addClass('active');
                }

                 if (get_is_favorite_ch_by_mask($(item_cards[idx]).attr("channel_mask"))) {
                     set_colourkey_list_text(ColourKeyList_TV_normal_All_fav_state);
                 } else {
                     //not favorite channel colourkey
                 set_colourkey_list_text(ColourKeyList_TV_normal_All_not_fav_state);
                 }
                 set_active_mode(ModeList.Mode_TV_normal_favorite);
             }
             return true;

        }
        else if (key == KeyEvent.DOM_VK_CHANNEL_OSD) {
            if (g_t_timer_delay_exit != null) {
                clearTimeout(g_t_timer_delay_exit);
                g_t_timer_delay_exit = null;
            }
             console.log("Exit Channel List");
             mtvuiUtil.gotoSysPage("sys_channel_zapper"); /* Go to root page */
            return false;
        }
        /* handle OPTION key */
        else if (key == KeyEvent.DOM_VK_BLUE) {

            console.log("REC: DOM_VK_BLUE key");
            jump_to_help_page();
             mtvuiUtil.gotoSysPage("sys_index");
            return true;

        }
        /* handle OPTION key */
        else if (key == KeyEvent.DOM_VK_OPTION) {
            if(mtvObj.acfgGetConfigValue("g_bs__bs_sat_brdcster")==31){
                if ($('#id_div_ch_type').hasClass("active")) {
               $('#id_div_ch_type').removeClass('active');
               if(get_favorite_length() <= 0){
                 option_show_func(on_header_option_unfav_bu);
             }else {
                 option_show_func(on_header_option_fav_bu);
             }
         }else{
         if (current_tuner_type == TunerType_list.TunerType_satellite) {
             /* Satellite tuner type */
            switch (parseInt(get_cur_ch_list_type())) {
                     case ChannelListTypeList.ChannelListType_tv_new:
                     case ChannelListTypeList.ChannelListType_satellite_new:
                     svl_id = $(active_card[0]).attr("svl_id");
                     ch_mask = $(active_card[0]).attr("channel_mask");
                     var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                     if(is_lock){
                         option_show_func(new_option_is_lock_bu);
                     }else {
                         option_show_func(new_option_is_unlock_bu);
                     }
                         break;
                     default:
                     svl_id = $(active_card[0]).attr("svl_id");
                     ch_mask = $(active_card[0]).attr("channel_mask");
                     var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                     if(is_lock && get_favorite_length() <= 0){
                         option_show_func(SA_all_normal_option_EDIT_FAV_islock_unfav_bu);
                     }else if (is_lock && get_favorite_length() > 0) {
                         option_show_func(SA_all_normal_option_EDIT_FAV_islock_fav_bu);
                     }else if (!is_lock && get_favorite_length() <= 0) {
                         option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_unfav_bu);

                     }else {
                         option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_fav_bu);
                     }
                             break;
                         }
        } else {
             switch (parseInt(get_cur_ch_list_type())) {

                 case ChannelListTypeList.ChannelListType_tv_new:
                 case ChannelListTypeList.ChannelListType_satellite_new:
                 svl_id = $(active_card[0]).attr("svl_id");
                 ch_mask = $(active_card[0]).attr("channel_mask");
                 var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                 if(is_lock){
                     option_show_func(new_option_is_lock);
                 }else {
                     option_show_func(new_option_is_unlock);
                 }
                     break;
                 default:
                 svl_id = $(active_card[0]).attr("svl_id");
                 ch_mask = $(active_card[0]).attr("channel_mask");
                 var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                 if(is_lock && get_favorite_length() <= 0){
                         option_show_func(TV_all_normal_option_EDIT_FAV_islock_unfav);
                     }else if (is_lock && get_favorite_length() > 0) {
                         option_show_func(TV_all_normal_option_EDIT_FAV_islock_fav);
                     }else if (!is_lock && get_favorite_length() <= 0) {
                         option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_unfav);

                     }else {
                         option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_fav);
                     }
                     break;
                 }
            }
           return false;

        }
        }else{
            if ($('#id_div_ch_type').hasClass("active")) {
               $('#id_div_ch_type').removeClass('active');
              if(get_favorite_length() <= 0){
			    if(is_disable_move_fct()){
					option_show_func(on_header_option_unfav_UK);  
				  }else{
					option_show_func(on_header_option_unfav);
				  }
                  
                }else {
				  if(is_disable_move_fct()){
					option_show_func(on_header_option_fav_UK);  
				  }else{
					option_show_func(on_header_option_fav);
				  }
                }
         }else{
         if (current_tuner_type == TunerType_list.TunerType_satellite) {
             /* Satellite tuner type */
            switch (parseInt(get_cur_ch_list_type())) {
                     case ChannelListTypeList.ChannelListType_tv_new:
                     case ChannelListTypeList.ChannelListType_satellite_new:
                     svl_id = $(active_card[0]).attr("svl_id");
                     ch_mask = $(active_card[0]).attr("channel_mask");
                     var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                     if(is_lock){
                         option_show_func(new_option_is_lock);
                     }else {
                         option_show_func(new_option_is_unlock);
                     }
                         break;
                     default:
                     svl_id = $(active_card[0]).attr("svl_id");
                     ch_mask = $(active_card[0]).attr("channel_mask");
                     var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                     if(is_lock && get_favorite_length() <= 0){
                         option_show_func(SA_all_normal_option_EDIT_FAV_islock_unfav);
                     }else if (is_lock && get_favorite_length() > 0) {
                         option_show_func(SA_all_normal_option_EDIT_FAV_islock_fav);
                     }else if (!is_lock && get_favorite_length() <= 0) {
                         option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_unfav);

                     }else {
                         option_show_func(SA_all_normal_option_EDIT_FAV_isunlock_fav);
                     }
                             break;
                         }
         } else {
             switch (parseInt(get_cur_ch_list_type())) {

                 case ChannelListTypeList.ChannelListType_tv_new:
                 case ChannelListTypeList.ChannelListType_satellite_new:
                 svl_id = $(active_card[0]).attr("svl_id");
                 ch_mask = $(active_card[0]).attr("channel_mask");
                 var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                 if(is_lock){
                     option_show_func(new_option_is_lock);
                 }else {
                     option_show_func(new_option_is_unlock);
                 }
                     break;
                 default:
                 svl_id = $(active_card[0]).attr("svl_id");
                 ch_mask = $(active_card[0]).attr("channel_mask");
                 var is_lock      = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
                 if(is_lock && get_favorite_length() <= 0){
                         option_show_func(TV_all_normal_option_EDIT_FAV_islock_unfav);
                     }else if (is_lock && get_favorite_length() > 0) {
                         option_show_func(TV_all_normal_option_EDIT_FAV_islock_fav);
                     }else if (!is_lock && get_favorite_length() <= 0) {
                         option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_unfav);

                     }else {
                         option_show_func(TV_all_normal_option_EDIT_FAV_isunlock_fav);
                     }
                     break;
                 }
         }
         return false;

        }
    }

    }

        else if (key == KeyEvent.DOM_VK_BACK) {
            return false;

        }


        //clear all channel active class
        active_card.removeClass('active');
       if (item_cards.length <= 0) {
           return false;
       }
       //set current channel active
       $(item_cards[index]).addClass("active");
        var active_card = kc.target.find(".channel_list li.active");
          if(active_card.length<1){
                $(item_cards[index-1]).addClass("active");
           }
        startScroll($('.channel_list li.active'));
    return true;
 };


/*
* Dispatch submenu key .
*/
var sub_menu_key_dispatch = function(kc) {
    key = kc.keyCode || kc.which;
    //console.log("recieve key:" + key +" mode:" + active_mode);

    kc.target = $('#channel_list_layout');
    switch (active_mode) {
        case ModeList.Mode_Favorite_create_favorite:
            {
                //no favirite channel, a pop up dialog shall be displayed to invite user to create Favorites
                //so key should send to dialog.
                favorite_create_favorite_key_proc(kc);
                break;
            }
        case ModeList.Mode_FindChannel_new_serach:
            {
                //Find channel mode of new search mode key process
                find_channel_new_search_key_proc(kc);
                break;
            }
        case ModeList.Mode_FindChannel_show_results:
            {
                //Find channel mode of search results mode key process
                find_channel_show_results_state_key_proc(kc,textValue);
                break;
            }
        case ModeList.Mode_TV_normal_favorite:
            {
                //TV normal mode in Favorite list key process
                tv_normal_favorite_key_proc(kc);
                break;
            }
        case ModeList.Mode_TV_normal_all:
            {
                //TV normal mode in All list key process
                tv_normal_all_key_proc(kc);
                break;
            }
        case ModeList.Mode_TV_normal_radio:
            {
                //TV normal mode in Radio list key process
                tv_normal_radio_key_proc(kc);
                break;
            }
        case ModeList.Mode_TV_normal_new:
            {
                //TV normal mode in New list key process
                tv_normal_new_key_proc(kc);
                break;
            }
        case ModeList.Mode_TV_normal_tv:
            {
                //TV normal mode in TV list key process
                tv_normal_tv_key_proc(kc);
                break;
            }
        case ModeList.Mode_Favorite_edit_one_by_one:
            {
                //Edit favorite mode of edit one by one mode key process
                favorite_edit_one_by_one_key_proc(kc);
                break;
            }
//         case ModeList.Mode_Option_menu_TV_normal_all:
//             {
//                 //Option menu mode in TV normal All list key process
//                 option_menu_TV_normal_all_key_proc(kc);
//                 break;
//             }
//         case ModeList.Mode_Option_menu_TV_normal_fav:
//             {
//                 //Option menu mode in TV normal Favorite list key process
//                 option_menu_TV_normal_fav_key_proc(kc);
//                 break;
//             }
        case ModeList.Mode_Move_before_move:
            {
                //Move mode of before move mode key process
                //before move that is enter the move mode at the moment.
                move_state_before_move_key_proc(kc);
                break;
            }
        case ModeList.Mode_Move_moving:
            {
                //Move mode of moving mode key process
                //moving mode that is press OK key when in before move mode.
                sort_page_key_proc(kc);
                break;
            }
        case ModeList.Mode_TV_normal_install_channel:
            {
                //Install channel mode of tv normal mode key process
                tv_normal_install_channel_key_proc(kc);
                break;
            }
        case ModeList.Mode_Enter_pin_code:
            {
                //Enter PIN code key process
                Enter_pin_code_key_proc(kc);
                break;
            }
        case ModeList.Mode_favorite_mark_all:
            {

                mark_all_as_favourites_key_proc(kc);
                break;
            }
        case ModeList.Mode_favorite_edit_by_range_before:
            {
                favorite_edit_by_block_before_key_proc(kc);
                break;
            }
        case ModeList.Mode_favorite_edit_by_range:
            {
                favorite_edit_by_block_key_proc(kc);
                break;
            }
        case ModeList.Mode_Swap_before_move:
            {
                swap_state_before_move_key_proc(kc);
                break;
            }
        case ModeList.Mode_Swap_moving:
            {
                swap_page_key_proc(kc);
                break;
            }
        case ModeList.Mode_Dialog:
            {
                dialog_choose_key_proc(kc);
                break;
            }
        case ModeList.Mode_category_list:  //Ryan Add Packs/Categories for Telekarta
        case ModeList.Mode_packs_list:
        case ModeList.Mode_groups_list:
        {
	    if($('#catMenuid').is(":visible"))
	    {	
	        category_list_key_proc(kc);
	    }
	    else
	    {
	        tv_normal_all_key_proc(kc);
	    }
            break;
        }
        default:
            {
                //TV normal mode in All list key process
                tv_normal_all_key_proc(kc);
                break;
            }
    }

    return true;
};
function exitkeyChannel(){/*20170913 [TF518PHIEUMTK01-889] [EAT table]*/
	var g_chObj = new MtvObj();
	var chInfo = g_chObj.getCurrentChannelInfo();
	console.log("exit CHANNEL_ID= "+chInfo.CHANNEL_ID);
	console.log("exit SVL_ID= "+chInfo.SVL_ID);
	console.log("exit NW_MASK= "+parseInt(chInfo.NW_MASK));

	try {
		/* set new channel */
		var chObj = {
			"CHANNEL_ID": chInfo.CHANNEL_ID,
			"SVL_ID": chInfo.SVL_ID,
			"NW_MASK": parseInt(chInfo.NW_MASK)
		};
		change_channel_by_channle_info(chObj);
	}
	catch (err) {
		console.log("error for set channel id!");
		console.log(err);
	}
}

function closescroll() {
    clearInterval(timestring);
    scrollnulllength = 1;
}
function string_scroll(obj) {
    if (obj == null) {
        closescroll();
        return false;
    }
    var tmp = (obj.scrollLeft)++;
    if (obj.scrollLeft == tmp) {
        obj.innerHTML += ("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + scrollchannelname);
        scrollnulllength++;
    }
    if (scrollnulllength > 2) {
        obj.innerHTML = (scrollchannelname);
        scrollnulllength = 1;
    }
}

function afterurlstoreChannelList() {
    if (storeChannelListtimeout) {
        mtvObj.storeChannelList('');
        storeChannelListtimeout = null;
    }

}
var acfg_memc_level = 'g_misc__memc_level';
var acfg_vid_mjc_func = 'g_video__vid_mjc_func';
function setMemc_level(enable) {
    if (enable) {
        var value = mtvObj.acfgGetConfigValue(acfg_vid_mjc_func);
        mtvObj.acfgSetConfigValue(acfg_memc_level, value);
    } else {
        mtvObj.acfgSetConfigValue(acfg_memc_level, 0);
    }
}
function channel_list_item_focus(isFcous, id){
    console.log("channel_list_item_focus");
    if(isFcous){
        $('#'+id).addClass('active');
    } else {
        $('.channel_list li.active').removeClass('active');
    }
}
function initSubTitleByFilter(){
	var sub_type_left=$('#id_type_left');
    var sub_title=$('#id_div_ch_type>.type_mid');
    var dtv_tuner_type = mtvObj.getDtvTunerType();
	//dtv_tuner_type==0 is ANTENNA
	if(dtv_tuner_type==0){
		    switch (parseInt(get_cur_ch_list_type())) {
			  case ChannelListTypeList.ChannelListType_tv_favorite:
				  break;
			  case ChannelListTypeList.ChannelListType_satellite_favorite:
				  break;
			  case ChannelListTypeList.ChannelListType_tv_all:
				  switch(get_channel_filter_type()){
				  	 case CUST_CH_FILTER_TYPE_ALL:
					    var str=getTranslate("MAIN_TI_ANTENNA_ALL");    
					    sub_title.html(str);
					    sub_type_left.attr('class','tv_type_left');
					    break;
					  case CUST_CH_FILTER_TYPE_DIGITAL:
						var str=getTranslate("MAIN_ANTENNA_DIGITAL_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_ANALOG:
						var str=getTranslate("MAIN_ANTENNA_ANALOGUE_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_FREE_SCRAMBLE:
						var str=getTranslate("MAIN_TI_ANTENNA_ALL");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
					    break;
					  case CUST_CH_FILTER_TYPE_SCRAMBLE:
						var str=getTranslate("MAIN_ANTENNA_SCRAMBLED_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
					    break;
					  case CUST_CH_FILTER_TYPE_FREE_ONLY:
						var str=getTranslate("MAIN_ANTENNA_FREE_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
						break;
				  }	
				  break;
			  case ChannelListTypeList.ChannelListType_satellite_all:
				 switch(get_channel_filter_type()){
				 	 case CUST_CH_FILTER_TYPE_ALL:
					    var str=getTranslate("MAIN_TI_SAT_ALL");    
					    sub_title.html(str);
					    sub_type_left.attr('class','sa_type_left');
					    break;
					  case CUST_CH_FILTER_TYPE_DIGITAL:
						var str=getTranslate("MAIN_SATELLITE_DIGITAL_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_ANALOG:
						var str=getTranslate("MAIN_SATELLITE_ANALOGUE_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_FREE_SCRAMBLE:
						var str=getTranslate("MAIN_TI_SAT_ALL");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
					    break;
					  case CUST_CH_FILTER_TYPE_SCRAMBLE:
						var str=getTranslate("MAIN_SATELLITE_SCRAMBLED_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_FREE_ONLY:
						var str=getTranslate("MAIN_SATELLITE_FREE_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
				  }	
				  break;
			  /*case ChannelListTypeList.ChannelListType_tv_radio:
				 switch(get_channel_filter_type()){
					  case CUST_CH_FILTER_TYPE_DIGITAL:
						var str=getTranslate("Radio-Digital channels");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_ANALOG:
						var str=getTranslate("Radio-Analogue channels");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_SCRAMBLE:
						var str=getTranslate("Radio-Scrambled channels");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
					    break;
					  case CUST_CH_FILTER_TYPE_FREE_ONLY:
						var str=getTranslate("Radio-Free channels");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
						break;
				  }	
				  break;
			  case ChannelListTypeList.ChannelListType_satellite_radio:
				 switch(get_channel_filter_type()){
					  case CUST_CH_FILTER_TYPE_DIGITAL:
						var str=getTranslate("Satellite-Digital channels");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_ANALOG:
						var str=getTranslate("Satellite-Analogue channels");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_SCRAMBLE:
						var str=getTranslate("Satellite-Scrambled channels");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_FREE_ONLY:
						var str=getTranslate("Satellite-Free channels");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
				  }	
				  break;
			  case ChannelListTypeList.ChannelListType_tv_new:
					var str=getTranslate("MAIN_ANTENNA_NEW_CHANNELS");          
				  sub_title.html(str);
				  sub_type_left.attr('class','tv_type_left');
				  break;
			  case ChannelListTypeList.ChannelListType_satellite_new:
				  var str=getTranslate("MAIN_SATELLITE_NEW_CHANNELS");                
				  sub_title.html(str);
				  sub_type_left.attr('class','sa_type_left');
				  channel_selected_idx = new_list_selected_idx;
				  break;
			  case ChannelListTypeList.ChannelListType_satellite_tv:
				  var str=getTranslate("MAIN_SATELLITE_SELECTED");                
				  sub_title.html(str);
				  sub_type_left.attr('class','sa_type_left');
				  channel_selected_idx = tv_list_selected_idx;
				  break;
			 case ChannelListTypeList.ChannelListType_tv_default:
				 if (current_tuner_type == TunerType_list.TunerType_tv) {
						var str=getTranslate("MAIN_TI_ANTENNA_ALL");    
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
					 }else {
						var str=getTranslate("MAIN_TI_SAT_ALL");                
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						 }
						 break;
			  default:
				  break;*/
			}
	}else{
		switch (parseInt(get_cur_ch_list_type())) {
			 case ChannelListTypeList.ChannelListType_tv_favorite:
				  break;
			  case ChannelListTypeList.ChannelListType_satellite_favorite:
				  break;
			  case ChannelListTypeList.ChannelListType_tv_all:
				  switch(get_channel_filter_type()){
				  	 case CUST_CH_FILTER_TYPE_ALL:
					    var str=getTranslate("MAIN_TI_CABLE_ALL");    
					    sub_title.html(str);
					    sub_type_left.attr('class','tv_type_left');
					    break;
					  case CUST_CH_FILTER_TYPE_DIGITAL:
						var str=getTranslate("MAIN_CABLE_DIGITAL_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_ANALOG:
						var str=getTranslate("MAIN_CABLE_ANALOGUE_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_FREE_SCRAMBLE:
						var str=getTranslate("MAIN_TI_CABLE_ALL");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
					    break;
					  case CUST_CH_FILTER_TYPE_SCRAMBLE:
						var str=getTranslate("MAIN_CABLE_SCRAMBLED_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
					    break;
					  case CUST_CH_FILTER_TYPE_FREE_ONLY:
						var str=getTranslate("MAIN_CABLE_FREE_CHANNELS");
						sub_title.html(str);
						sub_type_left.attr('class','tv_type_left');
						break;
				  }	
				  break;
			  case ChannelListTypeList.ChannelListType_satellite_all:
				 switch(get_channel_filter_type()){
				 	  case CUST_CH_FILTER_TYPE_ALL:
					    var str=getTranslate("MAIN_TI_SAT_ALL");    
					    sub_title.html(str);
					    sub_type_left.attr('class','sa_type_left');
					    break;
					  case CUST_CH_FILTER_TYPE_DIGITAL:
						var str=getTranslate("Satellite-Digital channels");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_ANALOG:
						var str=getTranslate("Satellite-Analogue channels");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_FREE_SCRAMBLE:
						var str=getTranslate("MAIN_TI_SAT_ALL");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
					    break;
					  case CUST_CH_FILTER_TYPE_SCRAMBLE:
						var str=getTranslate("Satellite-Scrambled channels");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
					  case CUST_CH_FILTER_TYPE_FREE_ONLY:
						var str=getTranslate("Satellite-Free channels");
						sub_title.html(str);
						sub_type_left.attr('class','sa_type_left');
						break;
				  }	
				break;
				default:
				  break;
		}
	}
}
var initSubTitle=function(){
  var sub_type_left=$('#id_type_left');
  var sub_title=$('#id_div_ch_type>.type_mid');
  var dtv_tuner_type = mtvObj.getDtvTunerType();
  //dtv_tuner_type==0 is ANTENNA
  if(dtv_tuner_type==0){
    switch (parseInt(get_cur_ch_list_type())) {
      case ChannelListTypeList.ChannelListType_tv_favorite:
          var str=getTranslate("MAIN_ANTENNA_FAVOURITES");    
          sub_title.html(str);
          sub_type_left.attr('class','fav_type_left');
          break;
      case ChannelListTypeList.ChannelListType_satellite_favorite:
          var str=getTranslate("MAIN_SATELLITE_FAVOURITES");    
          sub_title.html(str);
          sub_type_left.attr('class','fav_type_left');
          break;
      case ChannelListTypeList.ChannelListType_tv_all:
            var str=getTranslate("MAIN_TI_ANTENNA_ALL");    
          sub_title.html(str);
          sub_type_left.attr('class','tv_type_left');
          break;
      case ChannelListTypeList.ChannelListType_satellite_all:
          var str=getTranslate("MAIN_TI_SAT_ALL");          
          sub_title.html(str);
          sub_type_left.attr('class','sa_type_left');
          break;
      case ChannelListTypeList.ChannelListType_tv_radio:
            var str=getTranslate("MAIN_ANTENNA_RADIO_CHANNELS");    
          sub_title.html(str);
          sub_type_left.attr('class','tv_type_left');
          break;
      case ChannelListTypeList.ChannelListType_satellite_radio:
          var str=getTranslate("MAIN_SATELLITE_RADIO_CHANNELS");                
          sub_title.html(str);
          sub_type_left.attr('class','sa_type_left');
          channel_selected_idx = radio_list_selected_idx;
          break;
      case ChannelListTypeList.ChannelListType_tv_new:
            var str=getTranslate("MAIN_ANTENNA_NEW_CHANNELS");          
          sub_title.html(str);
          sub_type_left.attr('class','tv_type_left');
          break;
      case ChannelListTypeList.ChannelListType_satellite_new:
          var str=getTranslate("MAIN_SATELLITE_NEW_CHANNELS");                
          sub_title.html(str);
          sub_type_left.attr('class','sa_type_left');
          channel_selected_idx = new_list_selected_idx;
          break;
      case ChannelListTypeList.ChannelListType_satellite_tv:
          var str=getTranslate("MAIN_SATELLITE_SELECTED");                
          sub_title.html(str);
          sub_type_left.attr('class','sa_type_left');
          channel_selected_idx = tv_list_selected_idx;
          break;
     case ChannelListTypeList.ChannelListType_tv_default:

         if (current_tuner_type == TunerType_list.TunerType_tv) {
                var str=getTranslate("MAIN_TI_ANTENNA_ALL");    
                sub_title.html(str);
                sub_type_left.attr('class','tv_type_left');
             }else {
                var str=getTranslate("MAIN_TI_SAT_ALL");                
                sub_title.html(str);
                sub_type_left.attr('class','sa_type_left');
                 }
                 break;
     case ChannelListTypeList.ChannelListType_satellite_packs:    //Ryan Add Packs/Categories for Telekarta
        var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
        BATid = BATid.toString();
        if(BATid.indexOf("43") == 0)
        {	
            var AllCATlist = mtvObj.acfgGetConfigString("g_custom_base__category_name");
            var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
            var Lastindex = AllCATlist.indexOf("_" + BATid + ",");
            var PackName = AllCATlist.substr(0,Lastindex);
            var Starindex = PackName.lastIndexOf(" || ");
            if(Starindex == -1)
            {
                Starindex=-3;
            }
            PackName = PackName.substr(Starindex+3,PackName.length);

            var str="".concat(getTranslate("MAIN_PACKS"), " - ",PackName);
        }
        else{
        var str=getTranslate("MAIN_PACKS"); 
        }		
        sub_title.html(str);
        sub_type_left.attr('class','sa_type_left');
                 break;
     case ChannelListTypeList.ChannelListType_satellite_cat:
        var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
        BATid = BATid.toString();
        if(BATid.indexOf("84") == 0)
        {	
            var AllCATlist = mtvObj.acfgGetConfigString("g_custom_base__category_name");
            var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
            var Lastindex = AllCATlist.indexOf("_" + BATid + ",");
            var CatName = AllCATlist.substr(0,Lastindex);
            var Starindex = CatName.lastIndexOf(" || ");
            if(Starindex == -1)
            {
                Starindex=-3;
            }
            CatName = CatName.substr(Starindex+3,CatName.length);

            var str="".concat(getTranslate("MAIN_CATEGORIES"), " - ",CatName);
        }
	else{
            var str=getTranslate("MAIN_CATEGORIES");
        }		
        sub_title.html(str);
        sub_type_left.attr('class','sa_type_left');
                 break;
     case ChannelListTypeList.ChannelListType_satellite_groups:
        var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
        BATid = BATid.toString();
        if(1)
        {	
            var AllCATlist = mtvObj.acfgGetConfigString("g_custom_base__category_name");
            var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
            var Lastindex = AllCATlist.indexOf("_" + BATid + ",");
            
            var GroupsName = AllCATlist.substr(0,Lastindex);
            var Starindex = GroupsName.lastIndexOf(" || ");
            if(Starindex == -1)
            {
                Starindex=-3;
            }
            GroupsName = GroupsName.substr(Starindex+3,GroupsName.length);
            if(BATid == DVBS_NTV_PLUS_Other_BATid)
            {
                /*20180601 [TF518PHIEUMTK01-5992] [lab_NTVplus] (6) incorrect translation into Russian : group other*/
		        /*HTV_APP_CATEGORY_OTHER -> FAV_NETWORK_NLD_OTHERS*/
                GroupsName = getTranslate("FAV_NETWORK_NLD_OTHERS");
            }

            var str="".concat(getTranslate("MAIN_GROUPS"), " - ",GroupsName);
        }
        else{
            var str=getTranslate("MAIN_GROUPS");
        }		
        sub_title.html(str);
        sub_type_left.attr('class','sa_type_left');
                 break;
      default:
          break;
  }

  }else{
     switch (parseInt(get_cur_ch_list_type())) {
      case ChannelListTypeList.ChannelListType_tv_favorite:
          var str=getTranslate("MAIN_CABLE_FAVOURITES");          
          sub_title.html(str);
          sub_type_left.attr('class','fav_type_left');
          break;
      case ChannelListTypeList.ChannelListType_satellite_favorite:
          var str=getTranslate("MAIN_SATELLITE_FAVOURITES");
          sub_title.html(str);
          sub_type_left.attr('class','fav_type_left');
          break;
      case ChannelListTypeList.ChannelListType_tv_all:
          var str=getTranslate("MAIN_TI_CABLE_ALL");
          sub_title.html(str);
          sub_type_left.attr('class','tv_type_left');
          break;
      case ChannelListTypeList.ChannelListType_satellite_all:
          var str=getTranslate("MAIN_TI_SAT_ALL");          
          sub_title.html(str);
          sub_type_left.attr('class','sa_type_left');
          break;
      case ChannelListTypeList.ChannelListType_tv_radio:
            var str=getTranslate("MAIN_CABLE_RADIO_CHANNELS");          
          sub_title.html(str);
          sub_type_left.attr('class','tv_type_left');
          break;
      case ChannelListTypeList.ChannelListType_satellite_radio:
          var str=getTranslate("MAIN_SATELLITE_RADIO_CHANNELS");                
          sub_title.html(str);
          sub_type_left.attr('class','sa_type_left');
          channel_selected_idx = radio_list_selected_idx;
          break;
      case ChannelListTypeList.ChannelListType_tv_new:
            var str=getTranslate("MAIN_CABLE_NEW_CHANNELS");    
          sub_title.html(str);          
          sub_type_left.attr('class','tv_type_left');
          break;
      case ChannelListTypeList.ChannelListType_satellite_new:
          var str=getTranslate("MAIN_SATELLITE_NEW_CHANNELS");                
          sub_title.html(str);
          sub_type_left.attr('class','sa_type_left');
          channel_selected_idx = new_list_selected_idx;
          break;
      case ChannelListTypeList.ChannelListType_satellite_tv:
          var str=getTranslate("MAIN_SATELLITE_SELECTED");                
          sub_title.html(str);
          sub_type_left.attr('class','sa_type_left');
          channel_selected_idx = tv_list_selected_idx;
          break;
     case ChannelListTypeList.ChannelListType_tv_default:

         if (current_tuner_type == TunerType_list.TunerType_tv) {
                 var str=getTranslate("MAIN_TI_CABLE_ALL");          
                 sub_title.html(str);
                 sub_type_left.attr('class','tv_type_left');
             }else {
                 var str=getTranslate("MAIN_TI_SAT_ALL");                
                 sub_title.html(str);
                 sub_type_left.attr('class','sa_type_left');
                 }
                 break;
     case ChannelListTypeList.ChannelListType_satellite_packs:    //Ryan Add Packs/Categories for Telekarta
        var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
        BATid = BATid.toString();
        if(BATid.indexOf("43") == 0)
        {	
            var AllCATlist = mtvObj.acfgGetConfigString("g_custom_base__category_name");
            var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
            var Lastindex = AllCATlist.indexOf("_" + BATid + ",");
            var PackName = AllCATlist.substr(0,Lastindex);
            var Starindex = PackName.lastIndexOf(" || ");
        if(Starindex == -1)
        {
            Starindex=-3;
        }
        PackName = PackName.substr(Starindex+3,PackName.length);

        var str="".concat(getTranslate("MAIN_PACKS"), " - ",PackName);
        }
        else{
        var str=getTranslate("MAIN_PACKS");  
        }		
        sub_title.html(str);
        sub_type_left.attr('class','sa_type_left');
                 break;
     case ChannelListTypeList.ChannelListType_satellite_cat:
        var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
        BATid = BATid.toString();
        if(BATid.indexOf("84") == 0)
        {	
            var AllCATlist = mtvObj.acfgGetConfigString("g_custom_base__category_name");
            var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
            var Lastindex = AllCATlist.indexOf("_" + BATid + ",");
            var CatName = AllCATlist.substr(0,Lastindex);
            var Starindex = CatName.lastIndexOf(" || ");
            if(Starindex == -1)
            {
                Starindex=-3;
            }
            CatName = CatName.substr(Starindex+3,CatName.length);

            var str="".concat(getTranslate("MAIN_CATEGORIES"), " - ",CatName);
        }
        else{
        var str=getTranslate("MAIN_CATEGORIES");    
        }
        sub_title.html(str);
        sub_type_left.attr('class','sa_type_left');
                 break;
     case ChannelListTypeList.ChannelListType_satellite_groups:
        var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
        BATid = BATid.toString();
        if(1)
        {	
            var AllCATlist = mtvObj.acfgGetConfigString("g_custom_base__category_name");
            var BATid = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
            var Lastindex = AllCATlist.indexOf(BATid)-1;
            var GroupsName = AllCATlist.substr(0,Lastindex);
            var Starindex = GroupsName.lastIndexOf(" || ");
            if(Starindex == -1)
            {
                Starindex=-3;
            }
            GroupsName = GroupsName.substr(Starindex+3,GroupsName.length);
            if(BATid == DVBS_NTV_PLUS_Other_BATid)
            {
                /*20180601 [TF518PHIEUMTK01-5992] [lab_NTVplus] (6) incorrect translation into Russian : group other*/
		        /*HTV_APP_CATEGORY_OTHER -> FAV_NETWORK_NLD_OTHERS*/
                GroupsName = getTranslate("FAV_NETWORK_NLD_OTHERS");
            }
            var str="".concat(getTranslate("MAIN_GROUPS"), " - ",GroupsName);
        }
        else{
            var str=getTranslate("MAIN_GROUPS");    
        }
        sub_title.html(str);
        sub_type_left.attr('class','sa_type_left');
        break;
      default:
          break;
  }
 
  }
  
}

function handle_item(item_content, satlId, satlRecId, categoryMask) {

    var nw_mask = MaskList.Mask_all;
    var mask_value = MaskValueList.MaskValue_all;

    //submenu_selected_id
    switch (submenu_selected_id) {
        case "tv_submenu_bar_0":
        case "satellite_submenu_bar_0":
            {
                break;
            }
        case "tv_submenu_bar_1":
        case "satellite_submenu_bar_1":
            {
                nw_mask = nw_mask | MaskList.Mask_all;
                mask_value = mask_value | MaskValueList.MaskValue_all;
                break;
            }
        case "tv_submenu_bar_2":
        case "satellite_submenu_bar_3":
            {
                nw_mask = nw_mask | MaskList.Mask_radio;
                mask_value = mask_value | MaskValueList.MaskValue_radio;
                break;
            }
        case "satellite_submenu_bar_2":
            {
                nw_mask = nw_mask | MaskList.Mask_tv;
                mask_value = mask_value | MaskValueList.MaskValue_tv;
                break;
            }
        default:
            break;
    }
    var ch_filter_type = parseInt(get_channel_filter_type());
    switch (item_content) {
        case "CHM_OPTL_FAV_ALL":
            {
                //    if (true == is_save){
                /* set channel filter type */
                set_channel_filter_type(CUST_CH_FILTER_TYPE_ALL);
				DigitalAnalogue.curValue=0;

                //    }
                break;
            }
        case "CHM_OPTL_FILTER_DIGITAL":
            {
                nw_mask = nw_mask | MaskList.Mask_digital;
                mask_value = mask_value | MaskValueList.MaskValue_digital;
				DigitalAnalogue.curValue=1;
                //    if (true == is_save){
                /* set channel filter type */
                set_channel_filter_type(CUST_CH_FILTER_TYPE_DIGITAL);
                //    }
                break;
            }
        case "CHM_OPTL_FILTER_ANALOG":
            {
                nw_mask = nw_mask | MaskList.Mask_analog;
                mask_value = mask_value | MaskValueList.MaskValue_analog;
				DigitalAnalogue.curValue=2;
                //    if (true == is_save){
                /* set channel filter type */
                set_channel_filter_type(CUST_CH_FILTER_TYPE_ANALOG);
                //    }
                break;
            }
        case "CHM_OPTL_FAV_FREE_SCRAMBLE":
            {
                //    if (true == is_save){
                /* set channel filter type */
                set_channel_filter_type(CUST_CH_FILTER_TYPE_FREE_SCRAMBLE);
				FreeScrambled.curValue=0;
                //    }
                break;
            }
        case "CHM_OPTL_FAV_FREE_ONLY":
            {
                nw_mask = nw_mask | MaskList.Mask_free;
                mask_value = mask_value | MaskValueList.MaskValue_free;
				FreeScrambled.curValue=1;
				
                //    if (true == is_save){
                /* set channel filter type */
                set_channel_filter_type(CUST_CH_FILTER_TYPE_FREE_ONLY);
                //    }
                var ch = mtvObj.getCurrentChannelInfoForEachTuner();
                if(ch.SVL_ID==5||ch.SVL_ID==6||ch.SVL_ID==7){
                   nw_mask = nw_mask | MaskList.Mask_scrambled;
    	           mask_value = mask_value | MaskValueList.MaskValue_scrambled;
                   set_channel_filter_type(CUST_CH_FILTER_TYPE_SCRAMBLE);

                }
                break;
            }
        case "CHM_OPTL_FAV_SCRAMBLE":
            {
                nw_mask = nw_mask | MaskList.Mask_scrambled;
                mask_value = mask_value | MaskValueList.MaskValue_scrambled;
				FreeScrambled.curValue=2;
		
                //    if (true == is_save){
                /* set channel filter type */
                set_channel_filter_type(CUST_CH_FILTER_TYPE_SCRAMBLE);
                //    }
                var ch = mtvObj.getCurrentChannelInfoForEachTuner();
                if(ch.SVL_ID==5||ch.SVL_ID==6||ch.SVL_ID==7){
                   nw_mask = nw_mask | MaskList.Mask_free;
                   mask_value = mask_value | MaskValueList.MaskValue_free;
                   set_channel_filter_type(CUST_CH_FILTER_TYPE_FREE_ONLY);

                }
                break;
            }
        default:
            //    if (true == is_save){
            /* set channel filter type */
            set_channel_filter_type(CUST_CH_FILTER_TYPE_ALL);
			DigitalAnalogue.curValue=0;
            //    }
            break;
    }

    var ch = mtvObj.getCurrentChannelInfoForEachTuner();
    g_channel_cnt = get_channel_count(ch.SVL_ID, nw_mask, mask_value);
    //clear all card items
    $("#channel_list_ul").html("");
    show_or_hide_arrow();
  
    if (satlId == undefined && categoryMask == undefined){
        //last channel idx, normal case
          if (g_channel_cnt <= 0) {
			  $('.class_arrow_up').eq(0).hide();
              $('#id_div_up_bk').eq(0).hide();
		      $('.class_arrow_down').eq(0).hide();
              $('#id_div_down_bk').eq(0).hide();
		      //$('#id_div_ch_type').addClass('active');
		  initSubTitleByFilter();	
              return;
    }
    
    var idx = get_index_by_channel_id(ch.SVL_ID, nw_mask, mask_value, ch.CHANNEL_ID);
  
    if (idx < 2) {
        $('.class_arrow_up').eq(0).hide();
        $('#id_div_up_bk').eq(0).hide();
    } else if (idx > g_channel_cnt - 3) {
        $('.class_arrow_down').eq(0).hide();
        $('#id_div_down_bk').eq(0).hide();
    }
    var direction = DirectionList.Direction_next;
    if (g_channel_cnt < 8) {
        idx = 0;
        direction = DirectionList.Form_next;
        if (g_channel_cnt == 1) {
            direction = DirectionList.Direction_next;
        }
    } else {
        if ((g_channel_cnt - idx) >= 7) {
            if (idx > 1) {
                idx -= 2;
            } else if (idx == 1) {
                idx -= 1;
                direction = DirectionList.Form_next;
            
            } else {
                direction = DirectionList.Form_next;
            }
        } else {
            var offset = 8 - (g_channel_cnt - idx - 1);
            idx = idx - offset;
        }
    }
    
    var ch_info = get_channel_info_by_idx(ch.SVL_ID, nw_mask, mask_value, idx);
		initSubTitleByFilter();	
        carousel_add_channel_items(ModeList.Mode_default, ch_info.ITEMS[0].SVL_ID, ch_info.ITEMS[0].CHANNEL_ID,direction, Math.min(g_channel_cnt, CAROUSEL_ITEM_CNT));
        var item_cards = $(".channel_list li");
        var idx_active;

            for (idx_active = 0; idx_active <= g_channel_cnt-1; idx_active++) {
                if (ch.CHANNEL_ID == item_cards.eq(idx_active).attr('channel_id')) {
                    item_cards.eq(idx_active).addClass('active')
                }
            }


             var active_card=$(".channel_list li.active");
             if(active_card.length<=0){
                    if(item_cards.length>1){
                        $(item_cards[1]).attr("class", "active");
                    }else{                 
                        $(item_cards[0]).attr("class", "active");
                    } 
             }else{
                  startScroll(active_card); 
             }
        } else{
             direction = DirectionList.Form_next;
             //frist channel info
             var ch_info = getChannelInfoEx(ch.SVL_ID, ch.CHANNEL_ID, nw_mask, mask_value, CHLST_ITERATE_DIR_FROM_FIRST, categoryMask, satlId, satlRecId);
             console.log("handle_right_menu_item,ch.SVL_ID:" + ch_info.ITEMS[0].SVL_ID + ",ch.CHANNEL_ID:" + ch_info.ITEMS[0].CHANNEL_ID + "");
             var idx = get_index_by_channel_id(ch_info.ITEMS[0].SVL_ID, nw_mask, mask_value, ch_info.ITEMS[0].CHANNEL_ID);
             if(idx==0){
                  $('.class_arrow_up').eq(0).hide();
                  $('#id_div_up_bk').eq(0).hide();
             }
             carousel_add_channel_items(ModeList.Mode_default, ch_info.ITEMS[0].SVL_ID, ch_info.ITEMS[0].CHANNEL_ID, direction, Math.min(g_channel_cnt, CAROUSEL_ITEM_CNT), 0, 0, satlId, satlRecId, categoryMask);
             var item_cards = $(".channel_list li");            
              var idx_active;

              for (idx_active = 0; idx_active < g_channel_cnt-1; idx_active++) {
                    if (ch.CHANNEL_ID == item_cards.eq(idx_active).attr('channel_id')) {
                        item_cards.eq(idx_active).addClass('active')
                    }
                }


             var active_card=$(".channel_list li.active");
             if(active_card.length<=0){
                    if(item_cards.length>1){
                        $(item_cards[1]).attr("class", "active");
                    }else{                 
                        $(item_cards[0]).attr("class", "active");
                    } 
             }else{
                  startScroll(active_card); 
             }
         }
     }
	 function reset_satellite(){
		Satellite={"name":"BNR_SATELLITE_TITLE",'showMode':2,'acfgKey':'g_misc__cust_sound_style',"cacheValue":2,"curValue":0,"value":["CHM_OPTL_FILTER_ALL"]};

	 }

     function funcNotify(data){
            var active_card=$('.channel_list li.active');
            svl_id = $(active_card[0]).attr("svl_id");
            ch_mask = $(active_card[0]).attr("channel_mask");
            var is_lock = (MaskList.Mask_lock & ch_mask) == MaskList.Mask_lock;
            $("body").OptionMenuDialog('close');
        switch (data.name) {
            case 'BNR_SATELLITE_TITLE':
                switch (data.value[data.curValue]) {
                    case 'CHM_OPTL_FILTER_ALL':
					satellite_filter_condition_reset();
                    handle_item(data.value[data.curValue], satlId, satlRecId, categoryMask);
                        break;
                    default:
                        satlId=satellitelist[data.curValue-1].satlId;
                        satlRecId=satellitelist[data.curValue-1].satlRecId;
                        //var satlName=satellitelist[data.curValue].satlName;
                        handle_item(data.value[data.curValue], satlId, satlRecId, categoryMask);

                        break;
                }
				reset_satellite();
				break;
            case 'Select category':
                    switch (data.value[data.curValue]) {
                        case 'CHM_OPTL_FILTER_ALL':
						satellite_filter_condition_reset();
                        handle_item(data.value[data.curValue], satlId, satlRecId, categoryMask);

                            break;
                        default:
                            //var satlId=satellitelist[data.curValue].satlId;
                            //var satlRecId=satellitelist[data.curValue].satlRecId;
                            categoryMask=categorylist[data.curValue-1].categoryMask;
                            handle_item(data.value[data.curValue], satlId, satlRecId, categoryMask);

                            break;
                    }
            default:
                //handle_item(data.value[data.curValue], satlId, satlRecId, categoryMask);
                break;

        }
        console.log("data.name:"+data.name);
        switch(data.value[data.curValue]){
            case 'CHM_OPTL_FAV_ALL':
            case 'CHM_OPTL_FILTER_DIGITAL':
            case 'CHM_OPTL_FILTER_ANALOG':
            case 'CHM_OPTL_FAV_FREE_SCRAMBLE':
            case 'CHM_OPTL_FAV_FREE_ONLY':
            case 'CHM_OPTL_FAV_SCRAMBLE':
                handle_item(data.value[data.curValue]);
                break;
            case 'CHM_OPTL_LOCK_CHANNEL':
                if (is_lock) {
                    return false;
                }else{
                    Pin_code_state_layout();
                    set_active_mode(ModeList.Mode_Enter_pin_code);
                    return ;
                }
                lock_unlock_channel();

                break;
            case 'CHM_OPTL_UNLOCK_CHANNEL':
            if (is_lock) {
                Pin_code_state_layout();
                set_active_mode(ModeList.Mode_Enter_pin_code);

                return ;
            }else{
                return false;
            }
            lock_unlock_channel();
                break;
            case 'QT_FAV_EDIT':
                set_active_mode(ModeList.Mode_Favorite_edit_one_by_one);
                /* set current channel list type */
                if ((submenu_selected_id == 'tv_submenu_bar_0'||submenu_selected_id == 'tv_submenu_bar_1')){
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_default);
                }
                else{
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_default);
                }               
				Favorite_edit_one_by_one_state_layout();
                //focus_level = 3;
                break;
            case 'MAIN_RENAME':
                if (is_disable_rename()) {
                   return false;
                }
                /*set keyboard mode*/
                set_keyboard_mode(KyeboardModeList.KyeboardMode_tv_normal_rename);
                var channel_id = null;
                if (active_card.length > 0 && (channel_id = $(active_card[0]).attr("channel_id"))) {
                    console.log(channel_id);
                    var ch_mask = $(active_card[0]).attr("channel_mask");
                    var svl_id = $(active_card[0]).attr("svl_id");
                    var channel_name = $(active_card[0]).find("#ch_name").html();

                    try {
                       //set keyboard orignal value
                       textValue = channel_name;
                       //show keyboard
                       Find_channel_new_search_state_layout();

                       set_active_mode(ModeList.Mode_FindChannel_new_serach);
                    }
                    catch (err) {
                       console.log("error for set channel id!");
                       console.log(err);
                    }

                 }
                 return false;
                 break;
            case 'MAIN_CREATE_LIST':
                if(get_favorite_length()<=0){
                    Favorite_edit_create_favorite_state_layout();
                    //set active mode
                    set_active_mode(ModeList.Mode_Favorite_create_favorite);
                }
                break;
            case 'MAIN_SELECT_LIST':
                create_dialog_layout();
                break;
            case 'MAIN_DELETE_LIST':
                mark_all_as_fav_dialog("unmark");
                set_active_mode(ModeList.Mode_favorite_mark_all);
                break;
            case 'MAIN_FILTER_REORDER_CHANNELS':
                if (is_disable_move_fct()) {
                    return false;
                }
                $("#channel_list_ul").html("");
                //var current_bs_src_type = parseInt(mtvObj.getDtvTunerBsSrc());
                if (current_tuner_type == TunerType_list.TunerType_tv) {
                    submenu_item_focus(true,"tv_submenu_bar_0");
                }else {                   
                   submenu_item_focus(true,"satellite_submenu_bar_0");
                }
                //init_ch_list_by_chlist_type();
                 $("#ColorKey_Green").html(getTranslate("CHM_TEXTE_DONE"));
                set_active_mode(ModeList.Mode_Move_before_move);
                if(get_favorite_length()<=0){
                set_active_mode(ModeList.Mode_Favorite_create_favorite);
                }
                //Move_before_move_state_layout(); /* unmark for TF518PHIEUMTK01-544 */
                Show_Reorder_Hint_String();
                return true;
                break;
            case 'MAIN_SWAP_CHANNELS':
                /* Swap channel mode */
                Move_before_move_state_layout();
                set_active_mode(ModeList.Mode_Swap_before_move);
                return false;
                break;
            case 'MAIN_SELECT_FAVOURITES_RANGE':
                set_channel_filter_type(CUST_CH_FILTER_TYPE_ALL);  //select fav range show all channel
                DigitalAnalogue.curValue=0;
                $('#channel_list_ul').html("");
				if ((submenu_selected_id == 'tv_submenu_bar_0'||submenu_selected_id == 'tv_submenu_bar_1'||submenu_selected_id=="tv_submenu_bar_3")){
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_default);
                }
                else if (submenu_selected_id == 'tv_submenu_bar_2')
                {
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_radio);
                    
                }
                else if(submenu_selected_id == 'satellite_submenu_bar_3')
                {
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_radio);
                }
                else{
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_default);
                }
				Favorite_edit_by_range_layout();
                set_active_mode(ModeList.Mode_favorite_edit_by_range_before);
                break;
            case 'MAIN_TI_SEARCH_CHANNELS':
                set_keyboard_mode(KyeboardModeList.KyeboardMode_tv_normal_find_channel);
                textValue = "";
                Find_channel_new_search_state_layout();
                set_active_mode(ModeList.Mode_FindChannel_new_serach);

                break;
            default:
            //handle_item(data.value[data.curValue]);
            break;
        }
    }

    function option_show_func(ChannelObj)
    {
        var arg = $.extend({}, {
            data: ChannelObj,
            callback:funcNotify
        });
        mtvuiLoadScript("../../libs/mtvui/com_option_widget.js", function (){
            $("body").OptionMenuDialog(arg);
            $("body").OptionMenuDialog('show');
            });
    }
    var satellitelist=[];
	var categorylist = [];
    function update_list_right_satellite() {

            var ch = mtvObj.getCurrentChannelInfoForEachTuner();
            var satlNum = mtvObj.getSatlRecNum(ch.SVL_ID);
            var satlRec;
            //var satlName = TVSubMenuList[1].name; /* All */
            var satlId;
            var satlRecId;
            satellitelist.length=0;
            var valueList=Satellite.value; 
            Satellite.value.splice(1,valueList.length-1);
            for (var i = 0; i < satlNum; i++)
            {
                satlRec = mtvObj.getSatlRecByIdx(ch.SVL_ID, i);
                satlName = satlRec.SATL_NAME;
                satlId = satlRec.SATL_ID;
                satlRecId = satlRec.SATL_REC_ID;
                satellitelist.push({satlName:satlName,satlId:satlId,satlRecId:satlRecId});
                if (satlName == "")
                {
                    continue;
                }
                Satellite.value.push(satlName);
            }
            return satellitelist;

    }

    function update_list_right_category() {
            var tkgsList = mtvObj.getDvbsTkgsCategoryList(4, 0, 11);
            var categoryName = TVSubMenuList[1].name; /* All */
            var categoryNo;
            var categoryMask;
            //categorylist=categorylist.splice(0,categorylist.length);
            categorylist.length=0;
            var valueList=Selectcategory.value; 
            Selectcategory.value.splice(1,valueList.length-1);
            /* append All item */
            for (var i = 0; i < tkgsList.ITEMS.length; i++)
            {
                categoryName = tkgsList.ITEMS[i].CATEGORY_NAME;
                categoryNo = tkgsList.ITEMS[i].CATEGORY_NO;
                categoryMask = 1 << categoryNo;
                Selectcategory.value.push(categoryName);
                categorylist.push({categoryName:categoryName,categoryNo:categoryNo,categoryMask:categoryMask});
            }
            return categorylist;
    }
    function getChannelInfoEx(svl_id, ch_id, nw_mask, mask_value, dir, ctgry_mask, satl_id, satl_rec_id) {
        return mtvObj.getChannelInfoEx(svl_id, ch_id, nw_mask, mask_value, dir, ctgry_mask, satl_id, satl_rec_id);
    }
    var getCurrentChannelInfoSvlId = function (TunerType) {
            update_dvbs_svl_id();
        if (TunerType != TunerType_list.TunerType_satellite) {
            var dtv_tuner_type = mtvObj.getDtvTunerType();
            console.log("dtv_tuner_type:" + dtv_tuner_type);
            switch (parseInt(dtv_tuner_type)) {
                case 0:
                    //rewrite SVL_ID to air.
                    //svl_id = 1;
                    if (TYPE_BRDCST == mtvObj.getBroadcastType()) {
                        svl_id = BRDCST_DVBT;
                    } else {
                        svl_id = CAM_DVBT;
                    }
                    break;
                case 1:
                    //rewrite SVL_ID to cab.
                    //svl_id = 2;
                    if (TYPE_BRDCST == mtvObj.getBroadcastType()) {
                        svl_id = BRDCST_DVBC;
                    } else {
                        svl_id = CAM_DVBC;
                    }
                    break;
                default:
                    //rewrite SVL_ID to air.
                    svl_id = BRDCST_DVBC;
                    break;
            }
        }
        else {
            /* in satellite tuner type */
            //svl_id = 3;
            if (TYPE_BRDCST == mtvObj.getBroadcastType()) {
                svl_id = BRDCST_DVBS;
            } else {
                svl_id = CAM_DVBS;
            }
        }
        return svl_id;
    };
    var g_sort_page_ch_index = 0;

    function setActiveItemInFavList() {
        $('.active').removeClass('active');
        $('#channel_list_ul>li')
        .eq(g_sort_page_ch_index)
        .addClass('active');
    }

    // load channel list
    function favListLoad() {
        var favList = get_favorite_list();
        if (favList) {
            set_channel_carousel(null, favList.slice(0, 8), null);
            setActiveItemInFavList();
        }
        $('#channel_list_ul').html("");
    }
    function setSortBoxShowstart(needShow) {
        var sort = $("#id_div_sort");
        sort.hide();
        if (needShow) {
            var offset = 229 + (g_sort_page_ch_index-1) * 62;
            sort.css("top", offset + "px");
            //$('.class_sort_line').eq(0).attr('class', 'class_sort_line_start');
            $('.class_sort_reorder').eq(0).attr('class', 'class_sort_reorder_start');
            sort.show();
        }
    }
    // set sort box show or hide
    function setSortBoxShow(needShow) {
        var sort = $("#id_div_sort");
        sort.hide();
        if (needShow) {

            var offset = 197 + (g_sort_page_ch_index-1) * 62;
            sort.css("top", offset + "px");
            //$('.class_sort_line_start').eq(0).attr('class', 'class_sort_line');
	    $('.class_sort_reorder_start').eq(0).attr('class', 'class_sort_reorder');
            sort.show();
        }
    }

    function setActiveCell(idx) {
		if(g_sort_flag){
		   $('.active').removeClass('active');
           $('#channel_list_ul>li').eq(idx).addClass('active');
		}else{
		   $('.active').removeClass('active');
           $('#channel_list_ul>li').eq(idx).addClass('active');
		}
      
    }
    // fill in the icon by channel name
    function setIconInfo() {
    	    	/*
        var icon = $('#channel_list_ul>li').eq(g_sort_page_ch_index).find('.class_logo_all div:nth-child(1)').css('background-image');
        //var icon_div = $('#channel_list_ul>li').eq(g_sort_page_ch_index).find('.class_logo_all div:nth-child(1)');
        var ch_num = $('#channel_list_ul>li').eq(g_sort_page_ch_index).attr('channel_num');
        var sortIcon = $("#id_div_sort .class_sort_logo");
        sortIcon.html('');
        if (icon == 'url()' || !icon) {
            sortIcon.css('background-image', 'url(../res/ChannelList/logo_container_n_69x48_px.png)');
            //sortIcon.css('background-color', 'white');
        } else {
            sortIcon.css('background-color', 'white');
            sortIcon.css('background-image', icon);
        }
        console.log(icon);
        */
        var icon = $('#channel_list_ul>li').eq(g_sort_page_ch_index).find('.class_logo_fav div:nth-child(1)').css('background-image');
        var ch_num = $('#channel_list_ul>li').eq(g_sort_page_ch_index).attr('channel_num');
        var sortIcon = $("#id_div_sort .class_sort_logo");
        sortIcon.html('');
        var activeItem = $('#channel_list_ul>li').eq(g_sort_page_ch_index);
	    var chId = $(activeItem).attr('channel_id');
	    var svl_id=$(activeItem).attr('svl_id');
		var nw_mask = get_current_mask();
		var mask_value = get_current_mask_value();
	    var index=get_index_by_channel_id(svl_id,nw_mask,mask_value,chId);
	    var cur_channel=get_channel_info_by_idx(svl_id, nw_mask, mask_value, index);
	    var logo = mtvuiUtil.getChannelLogoSrc(cur_channel.ITEMS[0].CH_LOGO_ID);
	  	if (logo) {
	  			obj = $('<div style="background-image: url('+logo+');background-size: 52px 40px;height: 40px;width: 52px;margin-left: 8px;margin-top: 4px;background-repeat: no-repeat;"></div>');
				obj.appendTo($('#id_div_sort .class_sort_logo').eq(0));

            } else {
            	$('.class_sort_logo').css('background','url(../res/ChannelList/logo_container_hl_69x48_px.png)');
            }
        $('#channel_list_ul>li').eq(g_sort_page_ch_index).find('.class_logo_fav div:nth-child(1)').css('visibility','hidden');
        console.log('logo='+logo+', icon='+icon);
    }
var idx_from_or_to_isfirst_ch   =false;
    function sortChannel(svl_id, idx_from, idx_to) {
        if (idx_from == idx_to) {
            return;
        }else if(idx_from==0||idx_to==0){
			idx_from_or_to_isfirst_ch=true;
		}
		insert_channel_by_ch_idx(
			svl_id,
			MaskList.Mask_favorite,
			MaskValueList.MaskValue_favorite,
			idx_from,
			idx_to,
			FAVORITE_TYPE_0);
		
		
      
        store_channel_list_to_acfg();
    }

    // key handle
    var g_sort_flag = false;
    var svl_id_from = null;
    var svl_id_to = null;
    var idx_from = null;
    var idx_to = null;
	var idx_end=null;
	var is_first_dowm_or_up=false;
	var is_up=0;
	var is_down=0;
    function sort_page_key_proc(evt) {
		
        var kc = evt.keyCode || evt.witch;
        var item_cards = $(".channel_list li");
        //var item_cards = kc.target.find(".item.active .card.channel");
        var active_card = $(".channel_list li.active");
        var idx =0;
        if (active_card.length > 0){
             idx = $.inArray(active_card[0], item_cards);
		    if(!g_sort_flag){
				g_sort_page_ch_index=idx;
			} 
			 var channel_idx = $('#channel_list_ul>li').eq(idx).attr('channel_idx');
             var svl_id = $('#channel_list_ul>li').eq(idx).attr('svl_id');
		}
       
        if (kc == KeyEvent.DOM_VK_RETURN) {
            if (g_sort_flag) {
                idx_to = channel_idx;
                svl_id_to = svl_id;
                if (svl_id_from != svl_id_to&&!parseInt(mtvObj.getOclStatus())) {
                    console.log("Error:svl_id_from=" + svl_id_from + "svl_id_to=" + svl_id_to);
                    return false;
                }
				if(is_down==0){
					is_first_dowm=false;
					idx_to=parseInt(idx_to)+1;
				}
                sortChannel(svl_id, idx_from, idx_to);
                g_sort_flag = false;
                $("#ColorKey_Green").html(getTranslate("CHM_TEXTE_DONE"));
                setSortBoxShow(g_sort_flag);
                //update_current_page_ch_list();
				setActiveCell(idx);
				$('#channel_list_ul>li').eq(g_sort_page_ch_index).find('.class_logo_fav div:nth-child(1)').css('visibility','visible');
            } else {
		        is_first_dowm_or_up=true;
                idx_from = channel_idx;
                svl_id_from = svl_id;
                setIconInfo();
				is_up=0;
				is_down=0;
                g_sort_flag = true;
                setSortBoxShowstart(g_sort_flag);
            }

            return false;
        }

        var dir = null;
        var curMode = ModeList.Mode_TV_normal_favorite;
        var ch_id = $('#channel_list_ul>li').eq(g_sort_page_ch_index).attr('channel_id');

        if (kc == KeyEvent.DOM_VK_UP) {
                setSortBoxShowstart(false);
                if (g_sort_page_ch_index == 0) {
                    dir = DirectionList.Direction_pre;
                    is_first_channel=carousel_add_channel_items(curMode, svl_id, ch_id, dir, 1,
                    FAVORITE_TYPE_0, null);
                    show_or_hide_arrow();
					
					if(is_first_channel){
						$('.class_arrow_up').eq(0).hide();
                        $('#id_div_up_bk').eq(0).hide();
						is_first_channel=false;
					}

                } else {
                    g_sort_page_ch_index--;
					idx--;
				    if(is_up==-1&&g_sort_flag){
						idx++;
						is_up=0;
					}
					if(idx<0){
						idx=0;
					}
                }
				if(g_sort_flag){
					is_down=-1;
					is_first_dowm_or_up=false;
				}
                setSortBoxShow(g_sort_flag);
                setActiveCell(idx);
                return false;
        }

        if (kc == KeyEvent.DOM_VK_DOWN) {
                
                setSortBoxShowstart(false);
            

                if (g_sort_page_ch_index >= 7&&idx_end<g_channel_cnt) {
                    dir = 'NEXT';
				
                    is_last_channel=carousel_add_channel_items(curMode, svl_id, ch_id, dir, 1,
                    FAVORITE_TYPE_0, null);
                    show_or_hide_arrow();
					if(is_last_channel){
					   g_sort_page_ch_index++;
					   idx_end=g_channel_cnt;
					   is_last_channel=false;
					   idx=$(".channel_list li").length-1;;
					}

                } else if (g_sort_page_ch_index < item_cards.length) {
			
					g_sort_page_ch_index++;
					idx++;
					if(is_down==-1&&g_sort_flag){
						idx--;
						is_down=0;
					}
					if(is_first_dowm_or_up&&g_sort_flag){
						is_first_dowm_or_up=false;
					    g_sort_page_ch_index++;
						
					}
					idx_end=g_sort_page_ch_index;
                  				
                }
				if(g_sort_page_ch_index==g_channel_cnt&&!g_sort_flag||idx>$(".channel_list li").length-1){
				    return false;
				}
                if(g_sort_flag){
					is_up=-1;
				}				
                setSortBoxShow(g_sort_flag);
                setActiveCell(idx);
                return false;
        }

        
        if (key == KeyEvent.DOM_VK_BACK) {
            //reset_submenu_focus();
           //mtvuiUtil.gotoSysPage("sys_index");
			mtvuiUtil.procSysKey(key); /*20170824*/
        }
        else if (key == KeyEvent.DOM_VK_BLUE) {

            console.log("REC: DOM_VK_BLUE key");

            jump_to_help_page();
             mtvuiUtil.gotoSysPage("sys_index");
            return true;

        }
        /* handle GREEN key */
        else if (key == KeyEvent.DOM_VK_GREEN) {
            $("#channel_list_ul").html("");
			$("#id_div_sort").hide();
            console.log("REC: DOM_VK_GREEN key");
            if (get_favorite_length() <= 0) {
                channel_matrix_log_print("show creat favorite!");
                //no favorite channel in favorite_list
                //layout
                Favorite_edit_create_favorite_state_layout();
                //set active mode
                set_active_mode(ModeList.Mode_Favorite_create_favorite);

            } else {
                if ((submenu_selected_id == 'tv_submenu_bar_0' || submenu_selected_id == 'tv_submenu_bar_1')) {
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_tv_favorite);
                }
                else {
                    set_cur_ch_list_type(ChannelListTypeList.ChannelListType_satellite_favorite);
                }

                TV_normal_favorite_state_layout();
                var active_card = $('.channel_list li.active');
                if (active_card.length <= 0) {
                    setActiveCell(idx);
                }
				mtvObj.storeChannelList('');  // for save  //Ryan Chung [TF518PHIEUMTK05-765] need to store reorder Channel List when press green key.
                              storeChannelListtimeout = null;  //test
				console.log("REC: DOM_VK_GREEN key Save fav");
				//store_channel_list_to_acfg();
                set_active_mode(ModeList.Mode_TV_normal_favorite);
            }
            return true;
        }

    }

    var g_swap_flag = false;
    var g_swap_page_ch_index = 0;

    var swap_in_showing_list = [];

    function set_swap_in_showing_list() {
        for (var i = 0; i < 8; i++) {
            return;
        }
    }

    function set_swap_in_showing_list() {
        for (var i = 0; i < 8; i++) {
            return;
        }
    }

    function set_swap_page(need_show, is_change_logo) {
        $('.swap_box').hide();
        var obj = $('#id_div_swap_info');
      
        if(need_show) {
            var topOffset = 171 + g_swap_page_ch_index * 62;
            $('.swap_box').css('top', topOffset+'px');
            if (is_change_logo){
                var activeItem = $('#channel_list_ul>li').eq(g_swap_page_ch_index);
                var chId = activeItem.attr('channel_id');
                var chSvlId=activeItem.attr('svl_id');
                fromChId=chId;
                fromChSvlId=chSvlId;
                var chId = $(activeItem).attr('channel_id');
                var svl_id=$(activeItem).attr('svl_id');
				var nw_mask = get_current_mask();
				var mask_value = get_current_mask_value();
                var index=get_index_by_channel_id(svl_id,nw_mask,mask_value,chId);
                var cur_channel=get_channel_info_by_idx(svl_id, nw_mask, mask_value, index);
                var logo = mtvuiUtil.getChannelLogoSrc(cur_channel.ITEMS[0].CH_LOGO_ID);
                if (obj.length>0){
						obj.remove();
					}
				if (logo) {
					obj = $('<div id="id_div_swap_info" style="background-image: url('+logo+');background-size: 52px 40px;height: 48px;width: 69px;margin-left: 7px;margin-top: 2px;background-repeat: no-repeat;"></div>');
					obj.appendTo($('.swap_left').eq(0));
					//$('.swap_left').css('background-color', '#4b4b4b');
                    //var logoUrl = activeItem.find('.class_logo').eq(0).css('background');
                } else {
                	//$('.swap_left').css('background-color', '#4b4b4b');
                }
            }
            $('.swap_box').show();
        }
    }

    function swap_channel(svl_id, ch_from, ch_to) {
        if (ch_from == ch_to) {
            return;
        }
        sort_channel_by_channel_id (svl_id, ch_from, ch_to, null);
        store_channel_list_to_acfg();
    }

    var fromChId = null;
    var fromChSvlId = null;
    var toChId = null;
    var toSvlId = null;

    function swap_page_key_proc(evt) {
        var kc = evt.keyCode || evt.witch;

        if (kc == KeyEvent.DOM_VK_RETURN) {
            var chId = null;
            var chSvlId = null;
            chId = $('.active').eq(0).attr('channel_id');
            chSvlId = $('.active').eq(0).attr('svl_id');
            if (!g_swap_flag) {
                fromChId = chId;
                fromChSvlId = chSvlId;
                g_swap_flag = true;
                var item_cards=$('#channel_list_ul>li');
                var active_card=$('.channel_list li.active');
                g_swap_page_ch_index = $.inArray(active_card[0], item_cards);

            } else {
                toChId = chId;
                toSvlId = chSvlId;
                if (fromChSvlId != toSvlId) {
                    return false;
                }
				if (fromChId != toChId) {
                    swap_channel(fromChSvlId, fromChId, toChId);
                    //chId = $('#channel_list_ul>li').eq(0).attr('channel_id');
                    //chSvlId = $('#channel_list_ul>li').eq(0).attr('svl_id');
                    //carousel_add_channel_items( ModeList.Mode_TV_normal_all,chSvlId,chId,DirectionList.Direction_pre,1, null, null);
                    chId = $('#channel_list_ul>li').eq(0).attr('channel_id');
                    chSvlId = $('#channel_list_ul>li').eq(0).attr('svl_id');
                    $('#channel_list_ul').html("");
                    carousel_add_channel_items(ModeList.Mode_TV_normal_all,chSvlId,chId,DirectionList.Form_next,8, null, null);
                }
                g_swap_flag = false;
            }
            set_swap_page(g_swap_flag, true);
            $('#channel_list_ul>li').eq(g_swap_page_ch_index).addClass('active');
            return false;
        }
        if (kc == KeyEvent.DOM_VK_DOWN) {
            if (g_swap_page_ch_index >= 7) {
                var chId = $('#channel_list_ul>li').eq(g_swap_page_ch_index).attr('channel_id');
                var chSvlId = $('#channel_list_ul>li').eq(g_swap_page_ch_index).attr('svl_id');
                var dir = "NEXT";
                is_last_channel=carousel_add_channel_items(
                        ModeList.Mode_TV_normal_all,
                        chSvlId,
                        chId,
                        dir,
                        1, null, null);

                set_swap_page(g_swap_flag);
                $('.active').removeClass('active');

			    $('#channel_list_ul>li').eq(g_swap_page_ch_index-1).addClass('active');
           
                var chId = $('#channel_list_ul>li').eq(g_swap_page_ch_index).attr('channel_id');
                var chSvlId = $('#channel_list_ul>li').eq(g_swap_page_ch_index).attr('svl_id');
                var is_last=is_last_or_first_channel(ModeList.Mode_TV_normal_all,
                        chSvlId,
                        chId,
                        dir,
                        1, null, null);
                if(is_last){
                	is_need_hide_dowm=true;
                	if(is_last_channel){    
						$('.active').removeClass('active');
						$('#channel_list_ul>li').eq(g_swap_page_ch_index).addClass('active');
                	}
                } 
                show_or_hide_arrow(); 
                is_last_channel=false;     
                return false;
            }
            $('.active').removeClass('active');
            g_swap_page_ch_index++;
            if(g_swap_page_ch_index <= g_channel_cnt-1){
            	set_swap_page(g_swap_flag);
            	if(g_swap_flag){
            		$('#channel_list_ul>li').eq(g_swap_page_ch_index).addClass('active');

            	}else{
					$('#channel_list_ul>li').eq(g_swap_page_ch_index-1).addClass('active');
					if(g_swap_page_ch_index==g_channel_cnt-1){
						$('.active').removeClass('active');
						$('#channel_list_ul>li').eq(g_swap_page_ch_index).addClass('active');
					}
            	}

            }

                        
            return false;
        }

        if (kc == KeyEvent.DOM_VK_UP) {
            if (g_swap_page_ch_index == 0) {
                var chId = $('#channel_list_ul>li')
                    .eq(g_swap_page_ch_index)
                    .attr('channel_id');
                var chSvlId = $('#channel_list_ul>li')
                    .eq(g_swap_page_ch_index)
                    .attr('svl_id');
                var dir = DirectionList.Direction_pre;
                is_first_channel=carousel_add_channel_items(
                        ModeList.Mode_TV_normal_all,
                        chSvlId,
                        chId,
                        dir,
                        1, null, null);
                $('.active').removeClass('active');
                set_swap_page(g_swap_flag);
                $('#channel_list_ul>li').eq(g_swap_page_ch_index+1).addClass('active');
                var chId = $('#channel_list_ul>li').eq(g_swap_page_ch_index).attr('channel_id');
                var chSvlId = $('#channel_list_ul>li').eq(g_swap_page_ch_index).attr('svl_id');
                var is_first=is_last_or_first_channel(ModeList.Mode_TV_normal_all,
                        chSvlId,
                        chId,
                        dir,
                        1, null, null);
                if(is_first){
                	is_need_hide_up=true;
                	if(is_first_channel){    
						$('.active').removeClass('active');
						$('#channel_list_ul>li').eq(g_swap_page_ch_index).addClass('active');
                	}
                }
    			show_or_hide_arrow();
    			is_first_channel=false;
     
                return false;
            }
            $('.active').removeClass('active');
            g_swap_page_ch_index--;         
            set_swap_page(g_swap_flag);
            $('#channel_list_ul>li').eq(g_swap_page_ch_index).addClass('active');
//             if(is_first_channel){
//            		$('.active').removeClass('active');
// 				$('#channel_list_ul>li').eq(g_swap_page_ch_index).addClass('active');
//            }
            return false;
        }
        // how to handle back key?
        if (kc == KeyEvent.DOM_VK_BACK) {
           mtvuiUtil.gotoSysPage("sys_index");
        }
		if (key == KeyEvent.DOM_VK_GREEN) {
        	//clean channel items
        	$("#channel_list_ul").html("");
        	$('.swap_box').hide();
        	set_active_mode(ModeList.Mode_TV_normal_all);
			TV_normal_all_state_layout();
        }
    }

	function _bIsSupportTwoPartChannelNumber() {
		var bRet = false;
		
		if(get_RegionCode() == eRegionCode.PLF_OPT_REGION_KR) //for KR project
		{
			bRet = true;
		}

		if(get_RegionCode() == eRegionCode.PLF_OPT_REGION_LATAM) //for LT
		{
			bRet = true;
		}
		
		return bRet;
	}
	
	function focusCAT(isfocus, id) {     //Ryan Add Packs/Categories for Telekarta
		if (isfocus) {
		$("#" + id).addClass("focus");
		//this.__startScroll($("#" + id + ">div>div>span"));
		} else {
		$("#" + id).removeClass("focus");
		$($("#" + id).find('div')).css('background', '');
	}
	}
	
	
	
	function filterItems(query) {   //Ryan Add Packs/Categories for Telekarta
		var AllCATlist = mtvObj.acfgGetConfigString("g_custom_base__category_name");
        if(query == "_")
        {
            /*20180601 [TF518PHIEUMTK01-5992] [lab_NTVplus] (6) incorrect translation into Russian : group other*/
		    /*HTV_APP_CATEGORY_OTHER -> FAV_NETWORK_NLD_OTHERS*/
            AllCATlist = AllCATlist + getTranslate("FAV_NETWORK_NLD_OTHERS") + "_,99 || ";
        }
		var CATListArry = [];
		CATListArry = AllCATlist.split(" || ");	
		
		return CATListArry.filter(function(el) {
		return el.toLowerCase().indexOf(query.toLowerCase()) > -1;
		})
	}

    function SwitchToFirstChannel(){
        var BATID = mtvObj.acfgGetConfigValue("g_custom_base__bat_id");
        var AllCATlist = this.mtvObj.acfgGetConfigString("g_custom_base__category_name");
        var index = AllCATlist.substr( AllCATlist.indexOf("_"+BATID+",")+3,3);
        index = index.replace(/[^\d]/g, '');
        var selectedCategory = 0x01<<index;
        var ch_list_type = parseInt(get_channel_list_type());
        if((ch_list_type == CUST_CH_LIST_TYPE_PACKS) || (ch_list_type == CUST_CH_LIST_TYPE_CAT) || (ch_list_type == CUST_CH_LIST_TYPE_GROUPS) && (ChannelNotInList == true))
        {
            return true;
        }
        else
        {
            return false;
        }
    }
