var MEDIA_FILE_TYPE = 4;
var labelName;
var focusTimeoutResult = null ;
var ChildNode = function() {
    this.parentInfo;
    this.mediaType;
    this.nodeInfo;
    this.nodeList;
    this.nodeNum;
}
;
ChildNode.prototype.clearInfo = function() {
    this.parentInfo = undefined;
    this.mediaType = undefined;
    this.nodeInfo = undefined;
    this.nodeList = [];
    this.nodeNum = 0;
}
;
ChildNode.prototype.setNodes = function(nodeList) {
    this.nodeInfo = null ;
    this.nodeList = [];
    this.nodeNum = 0;
    if (nodeList) {
        this.nodeList = nodeList;
        this.nodeNum = nodeList.length;
    }
}
;
ChildNode.prototype.getNodes = function(parent, isRootNode) {
    if (this.parentInfo == parent) {
        console.log('this.parentInfo == parent');
        return;
    }
    this.nodeInfo = null ;
    this.nodeNum = 0;
    this.nodeList = [];
    if (curBrowserType == BrowserType.Usb) {
        if (isRootNode) {
            setCurUsbPathInfo(parent);
            parent.MEDIA_TYPE = MEDIA_TYPE.rootObj;
            //parent.MEDIA_PATH = usbObj.USB_PATH;
            this.mediaType = MEDIA_TYPE.rootObj;
        } else {
            this.mediaType = parent.MEDIA_TYPE;
        }
        if (this.mediaType == MEDIA_TYPE.rootObj) {
            this.nodeNum = usb_object.length;
            this.nodeList = usb_object;
        } else if (this.mediaType == MEDIA_TYPE.folderObj) {
            parent.MEDIA_PATH = usbObj.USB_PATH;
            this.nodeNum = usbObj.getCbDbCount(MEDIA_TYPE.Folder, parent.MEDIA_PATH);
            if (this.nodeNum > 0) {
                var count = (this.nodeNum > Number_Each_Time) ? Number_Each_Time : this.nodeNum;
                this.nodeList = usbObj.getContentBrowserPageData(this.nodeList.length, count, MEDIA_TYPE.Folder, parent.MEDIA_PATH);
            }
        } else if (this.mediaType == MEDIA_TYPE.musicObj) {
            this.nodeNum = musicObj.sortObj.length;
            this.nodeList = musicObj.sortObj;
        } else if (this.mediaType == MEDIA_TYPE.photoObj) {} else if (this.mediaType >= MEDIA_TYPE.Folder) {
            this.nodeNum = usbObj.getCbDbCount(this.mediaType, parent.MEDIA_PATH);
            if (this.nodeNum > 0) {
                var count = (this.nodeNum > Number_Each_Time) ? Number_Each_Time : this.nodeNum;
                this.nodeList = usbObj.getContentBrowserPageData(this.nodeList.length, count, this.mediaType, parent.MEDIA_PATH);
            }
        } else {
            this.nodeInfo = usbObj.getContentInfoByPath(this.mediaType, parent.MEDIA_PATH);
        }
    } else {
        var parentMediaName;
        parent.dlnaInfoStartIndex = 0;
        parent.dlnaInfoEndIndex = 0;
        if (isRootNode) {
            parentMediaName = parent.SERVER_NAME;
            parent.devId = dlnaObj.dmpGetRealDevId(parent.DEV_ID);
            parent.objectId = 0;
            var instObj = dlnaObj.dmpCreateInstance(parent.devId, 0);
            parent.mediaInfo = dlnaObj.getDmpFileMediaInfo(instObj.instance);
            this.mediaType = instObj.mediaType;
            curMediaServer = parent;
        } else {
            parentMediaName = parent.mediaInfo.mediaName;
            this.mediaType = parent.mediaInfo.mediaType;
        }
        if (this.mediaType == DLNA_MEDIA_TYPE.Directory) {
            this.nodeNum = parseInt(parent.mediaInfo.subItemNum);
            if (this.nodeNum > 0) {
                var count = (this.nodeNum > Number_Each_Time) ? Number_Each_Time : this.nodeNum;
                this.nodeList = dlnaObj.getDmpFilePageData(parent, count, this.nodeNum, 0);
            }
        } else {
            this.nodeNum = 0;
            this.nodeInfo = parent.mediaInfo;
        }
    }
    this.parentInfo = parent;
}
;
var UsbPlayObj = function() {
    this.infoList;
    this.playIndex;
}
;
var DlnaPlayObj = function() {
    this.curMediaInfo;
    this.playIndex;
    this.DEV_ID;
}
;
var UsbMusicPlayObj = function() {
    this.infoList;
    this.playIndex;
}
;
var File_obj = function() {
    this.isRootNode;
    this.floderStack = [];
    this.curMediaInfo;
    this.totalNum;
    this.infoList;
    this.focusIndex;
    this.allMediaData = {};
    this.usbPlayObj = new UsbPlayObj();
    this.musicPlayObj = new UsbMusicPlayObj();
    this.dlnaMusicPlayObj = new DlnaPlayObj();
    this.childNode = new ChildNode();
    this.curFocusHighLight = 0;
}
;
File_obj.prototype.init = function(info, index) {
    if (typeof (index) != 'undefined') {
        this.focusIndex = index;
    } else {
        this.focusIndex = 0;
    }
    this.childNode.clearInfo();
    if (curBrowserType == BrowserType.Usb) {
        switch (info.MEDIA_TYPE) {
        case MEDIA_TYPE.rootObj:
            this.infoList = usb_object;
            this.totalNum = this.infoList.length;
            break;
        case MEDIA_TYPE.musicObj:
            this.infoList = musicObj.sortObj;
            this.totalNum = musicObj.sortObj.length;
            break;
        case MEDIA_TYPE.photoObj:
            this.infoList = photoObj.pageInfo.submenuData;
            this.totalNum = photoObj.pageInfo.submenuData.length;
            if (!Number.isNaN(submenu_selected_id) && submenu_selected_id > 0) {
                this.focusIndex = submenu_selected_id;
            }
            break;
        case MEDIA_TYPE.musicArtist:
        case MEDIA_TYPE.musicAlbum:
        case MEDIA_TYPE.musicGenre:
        case MEDIA_TYPE.musicTrack:
            this.infoList = musicObj.pageInfo.submenuData;
            this.totalNum = musicObj.pageInfo.submenuData.length;
            if (typeof (index) != 'undefined') {
                this.focusIndex = musicObj.submenuSelectedIdx;
            }
            break;
        case MEDIA_TYPE.photoList:
        case MEDIA_TYPE.musicList:
        case MEDIA_TYPE.videoObj:
            break;
        case MEDIA_TYPE.PlayList:
            this.totalNum = usbObj.getCbDbCount(info.MEDIA_TYPE, info.MEDIA_PATH);
            this.infoList = [];
            this.allMediaData = {};
            this.getOnePageInfo(info.MEDIA_TYPE);
            break;
        default:
            this.totalNum = usbObj.getCbDbCount(MEDIA_TYPE.Folder, info.MEDIA_PATH);
            this.infoList = [];
            this.allMediaData = {};
            this.getOnePageInfo();
            break;
        }
    } else {
        this.curMediaInfo.dlnaInfoEndIndex = 0;
        this.curMediaInfo.dlnaInfoStartIndex = 0;
        this.totalNum = parseInt(info.mediaInfo.subItemNum);
        this.infoList = [];
        this.getOnePageInfo();
    }
}
;
File_obj.prototype.initRoot = function() {
    this.isRootNode = true;
    this.focusIndex = 0;
    this.childNode.clearInfo();
    this.floderStack = [];
    this.curMediaInfo = null ;
    if (curBrowserType == BrowserType.Usb) {
        this.totalNum = usbMountList.length;
        noPvrUsbMountList = [].concat(usbMountList);
        for (var i = 0; i < noPvrUsbMountList.length; i++) {
            if (checkUsbDiskTypeByPath(noPvrUsbMountList[i])) {
                noPvrUsbMountList.splice(i, 1);
            }
        }
        this.infoList = noPvrUsbMountList;
        if (curUsbPathInfo) {
            for (idx in this.infoList) {
                if (this.infoList[idx].PATH == curUsbPathInfo.PATH) {
                    this.focusIndex = parseInt(idx);
                    return;
                }
            }
        }
        this.totalNum = this.infoList.length;
        //setCurUsbPathInfo(this.infoList[this.focusIndex], scanDoneNotify);
    } else {
        this.totalNum = mediaServerList.length;
        this.infoList = mediaServerList;
        if (curMediaServer) {
            for (idx in mediaServerList) {
                if (mediaServerList[idx].DEV_ID == curMediaServer.DEV_ID) {
                    this.focusIndex = parseInt(idx);
                    return;
                }
            }
        }
    }
}
function checkUsbDiskTypeByPath(path) {
    //step1 check disk file system.
    var macth = 0;
    var jsonobj = JSON.parse(mtvObj.checkUsbDiskTypeByPath(path.PATH));
    if (jsonobj && jsonobj.STATUS != 0) {
        // is a ext4 file system disk.
        var totalNum = usbObj.getCbDbCount(MEDIA_TYPE.Folder, path.PATH);
        if (totalNum == 0) {
            return true;
        }
        var fileList = new Array();
        while (totalNum > 0) {
            if (totalNum > 0) {
                var count = (totalNum > 10) ? 10 : totalNum;
                var getList = usbObj.getContentBrowserPageData(fileList.length, count, MEDIA_TYPE.Folder, path.PATH);
                fileList = fileList.concat(getList);
                totalNum -= count;
            }
        }
        for (var i = 0; i < fileList.length; i++) {
            var fileNameArray = fileList[i].MEDIA_PATH.split("/");
            var fileName = fileNameArray[fileNameArray.length - 1];
            if ("tshift" == fileName) {
                macth++;
            }
            if ("lost+found" == fileName) {
                macth++;
            }
        }
    }
    if (macth >= 2) {
        return true;
        // for pvr disk
    } else {
        return false;
    }
}
File_obj.prototype.setFocusIndex = function(index) {
    this.focusIndex = index;
    this.childNode.getNodes(this.infoList[index], this.isRootNode);
}
;
File_obj.prototype.setBlurIndex = function(index) {
    console.log("setBlurIndex index = " + index);
    if (this.infoList.length > index) {
        if (this.infoList[index].instObj) {
            console.log("this.infoList[index].instObj.instance = " + this.infoList[index].instObj.instance);
            dlnaObj.dmpDelInstance(this.infoList[index].instObj.instance);
        }
    }
}
File_obj.prototype.getOnePageInfo = function(mediaType) {
    if (!this.infoList) {
        this.infoList = [];
    }
    if (typeof mediaType == 'undefined') {
        mediaType = MEDIA_TYPE.Folder;
    }
    if (curBrowserType == BrowserType.Usb) {
        if (this.curMediaInfo && this.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.photoObj) {
            photoObj.pageInfo.tryGetSubmenu(photoObj.sortMode);
            this.infoList = photoObj.pageInfo.submenuData;
            this.thumbnail_info = this.infoList.length;
            return;
        }
        if (this.curMediaInfo && (this.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.musicAlbum || this.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.musicArtist || this.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.musicGenre)) {
            musicObj.pageInfo.tryGetSubmenu(musicObj.sortMode);
            this.infoList = musicObj.pageInfo.submenuData;
            this.thumbnail_info = this.infoList.length;
            return;
        }
        if (this.infoList.length >= this.totalNum) {
            console.log("this.infoList.length >= this.totalNum return");
            return;
        }
        var count = (this.totalNum - this.infoList.length > Number_Each_Time) ? Number_Each_Time : (this.totalNum - this.infoList.length);
        this.infoList = this.infoList.concat(usbObj.getFolderPageData(this.infoList.length, count, this.curMediaInfo.MEDIA_PATH, this.allMediaData, mediaType));
    } else {
        if (this.curMediaInfo.dlnaInfoEndIndex >= this.totalNum) {
            console.log("this.infoList.length >= this.totalNum return");
            return;
        }
        var count = (this.totalNum - this.curMediaInfo.dlnaInfoEndIndex > Number_Each_Time) ? Number_Each_Time : (this.totalNum - this.curMediaInfo.dlnaInfoEndIndex);
        this.infoList = this.infoList.concat(dlnaObj.getDmpFilePageData(this.curMediaInfo, count, this.totalNum, this.infoList.length));
    }
}
;
File_obj.prototype.getDlnaPrevInfo = function(reqCount) {
    console.log("File_obj getDlnaPrevInfo");
    var ret = [];
    if (curBrowserType == BrowserType.Dlna && this.curMediaInfo) {
        if (this.curMediaInfo.dlnaInfoStartIndex > 0) {
            if (reqCount > this.curMediaInfo.dlnaInfoStartIndex) {
                reqCount = this.curMediaInfo.dlnaInfoStartIndex;
                this.curMediaInfo.dlnaInfoStartIndex = 0;
            } else {
                this.curMediaInfo.dlnaInfoStartIndex -= reqCount;
            }
            ret = dlnaObj.getDmpFilePageData(this.curMediaInfo, reqCount, this.totalNum, this.infoList.length, true);
            this.infoList = ret.concat(this.infoList);
        }
    }
    return ret;
}
;
File_obj.prototype.getDlnaShuffleList = function(startIndex) {
    console.log("File_obj getDlnaShuffleList");
    if (curBrowserType == BrowserType.Dlna && this.curMediaInfo) {
        if (startIndex < this.curMediaInfo.dlnaInfoStartIndex || startIndex > this.curMediaInfo.dlnaInfoEndIndex) {
            var reqNum = 0;
            if (startIndex == 0) {
                if (this.totalNum > Number_Each_Time) {
                    reqNum = Number_Each_Time;
                } else {
                    reqNum = this.totalNum;
                }
            } else {
                if (this.totalNum - startIndex - 1 > (Number_Each_Time - 1)) {
                    this.curMediaInfo.dlnaInfoStartIndex = startIndex - 1;
                    reqNum = Number_Each_Time;
                } else {
                    var prevIdx = (Number_Each_Time - 1) - (this.totalNum - startIndex - 1);
                    if (prevIdx > startIndex) {
                        this.curMediaInfo.dlnaInfoStartIndex = 0;
                        reqNum = this.totalNum;
                    } else {
                        this.curMediaInfo.dlnaInfoStartIndex = startIndex - prevIdx;
                        reqNum = Number_Each_Time;
                    }
                }
            }
            this.curMediaInfo.dlnaInfoEndIndex = this.curMediaInfo.dlnaInfoStartIndex + reqNum - 1;
            this.infoList = dlnaObj.getDmpFilePageData(this.curMediaInfo, reqNum, this.totalNum, 0, true);
            setFileInfoList('file_folder_ul', fileObj.infoList);
            scroll1.refresh();
        }
        fileObj.focusIndex = (startIndex - this.curMediaInfo.dlnaInfoStartIndex);
        return this.infoList[(startIndex - this.curMediaInfo.dlnaInfoStartIndex)];
    }
}
;
File_obj.prototype.getContentInfoByType = function(reqCount) {
    if (curBrowserType == BrowserType.Usb) {
        if (this.infoList.length >= this.totalNum) {
            console.log("this.infoList.length >= this.totalNum return");
            return false;
        }
        if (typeof (reqCount) == 'undefined') {
            reqCount = (this.totalNum - this.infoList.length);
        }
        if (reqCount > (this.totalNum - this.infoList.length)) {
            reqCount = (this.totalNum - this.infoList.length);
        }
        this.infoList = this.infoList.concat(usbObj.getFolderPageData(this.infoList.length, reqCount, this.curMediaInfo.MEDIA_PATH, this.allMediaData));
    } else {
        if (this.curMediaInfo.dlnaInfoEndIndex >= this.totalNum) {
            console.log("this.infoList.length >= this.totalNum return");
            return false;
        }
        if (typeof (reqCount) == 'undefined') {
            reqCount = (this.totalNum - this.curMediaInfo.dlnaInfoEndIndex);
        }
        if (reqCount > (this.totalNum - this.curMediaInfo.dlnaInfoEndIndex)) {
            reqCount = (this.totalNum - this.curMediaInfo.dlnaInfoEndIndex);
        }
        this.infoList = this.infoList.concat(dlnaObj.getDmpFilePageData(this.curMediaInfo, reqCount, this.totalNum, this.infoList.length));
    }
    return true;
}
;
File_obj.prototype.changeNode = function(isNext) {
    if (curBrowserType == BrowserType.Usb) {
        if (isNext) {
            this.floderStack.push(this.infoList[this.focusIndex]);
            this.isRootNode = false;
            this.curMediaInfo = this.infoList[this.focusIndex];
            this.init(this.curMediaInfo);
        } else {
            this.curMediaInfo = this.floderStack.pop();
            if (!this.curMediaInfo) {
                return false;
            } else if (this.floderStack.length == 0) {
                this.initRoot();
            } else {
                var index = this.curMediaInfo.MEDIA_INDEX;
                if (typeof (index) == 'undefined') {
                    index = 0;
                }
                var parentInfo = this.floderStack[this.floderStack.length - 1];
                this.curMediaInfo = parentInfo;
                this.init(parentInfo, index);
            }
        }
    } else {
        if (typeof (isNext) == 'undefined') {
            //refresh current path
            if (this.curMediaInfo) {
                var instObj = dlnaObj.dmpCreateInstance(this.curMediaInfo.devId, this.curMediaInfo.objectId);
                if (instObj) {
                    this.curMediaInfo.mediaInfo = dlnaObj.getDmpFileMediaInfo(instObj.instance);
                }
                this.init(this.curMediaInfo, this.focusIndex);
                if (this.infoList.length <= 0) {
                    this.initRoot();
                    return true;
                }
            }
            return true;
        }
        if (isNext) {
            this.infoList[this.focusIndex].MEDIA_INDEX = this.focusIndex;
            this.floderStack.push(this.infoList[this.focusIndex]);
            this.curMediaInfo = this.infoList[this.focusIndex];
            this.isRootNode = false;
            this.totalNum = this.childNode.nodeNum;
            this.infoList = this.childNode.nodeList;
            this.focusIndex = 0;
            if (this.infoList.length <= 0) {
                this.init(this.curMediaInfo);
            }
        } else {
            this.curMediaInfo = this.floderStack.pop();
            if (!this.curMediaInfo) {
                return false;
            } else {
                if (this.curMediaInfo.objectId == 0) {
                    this.initRoot();
                } else {
                    var index = this.curMediaInfo.MEDIA_INDEX;
                    var parentInfo = this.floderStack[this.floderStack.length - 1];
                    var parentObjId = parentInfo.objectId;
                    var parentDevId = parentInfo.mediaInfo.parentDevId;
                    this.curMediaInfo.devId = parentDevId;
                    this.curMediaInfo.objectId = parentObjId;
                    var instObj = dlnaObj.dmpCreateInstance(parentDevId, parentObjId);
                    this.curMediaInfo.mediaInfo = dlnaObj.getDmpFileMediaInfo(instObj.instance);
                    if (this.curMediaInfo.mediaInfo && this.curMediaInfo.mediaInfo.mediaType == 0) {
                        // fix run CTT 7.2.11.4 lost focus
                        this.initRoot();
                        return true;
                    }
                    this.init(this.curMediaInfo, index);
                }
            }
        }
    }
    return true;
}
;
File_obj.prototype.getPlayIndex = function(mediaType) {
    if (curBrowserType == BrowserType.Usb) {
        if (mediaType == 2) {
            return this.musicPlayObj.playIndex;
        } else {
            return this.usbPlayObj.playIndex;
        }
    } else {
        return this.focusIndex;
    }
}
;
File_obj.prototype.getShuffleItemInfo = function(mediaType, isRepeat) {
    var ret = null ;
    var startIndex;
    if (curBrowserType == BrowserType.Usb) {
        if (mediaType == 2) {
            if (isRepeat) {
                startIndex = getRandom(0, this.musicPlayObj.infoList.length - 1);
                ret = this.musicPlayObj.infoList[startIndex];
            } else {
                if (this.musicPlayObj.sortIndexArr.length > 0) {
                    var listIndex = getRandom(0, this.musicPlayObj.sortIndexArr.length - 1);
                    startIndex = this.musicPlayObj.sortIndexArr[listIndex];
                    ret = this.musicPlayObj.infoList[startIndex];
                    this.musicPlayObj.sortIndexArr.splice(listIndex, 1);
                }
            }
        } else {
            if (isRepeat) {
                startIndex = getRandom(0, this.usbPlayObj.infoList.length - 1);
                ret = this.usbPlayObj.infoList[startIndex];
            } else {
                if (this.usbPlayObj.sortIndexArr.length > 0) {
                    var listIndex = getRandom(0, this.usbPlayObj.sortIndexArr.length - 1);
                    startIndex = this.usbPlayObj.sortIndexArr[listIndex];
                    ret = this.usbPlayObj.infoList[startIndex];
                    this.usbPlayObj.sortIndexArr.splice(listIndex, 1);
                    if (mediaType == 1) {
                        ret.processTxt = (startIndex + 1) + "/" + this.usbPlayObj.infoList.length;
                    }
                }
            }
        }
    } else {
        if (isRepeat) {
            startIndex = getRandom(0, this.totalNum - 1);
            if (startIndex < this.infoList.length) {
                ret = this.infoList[startIndex];
            } else {
                ret = dlnaObj.getPlayBackFileInfo(this.curMediaInfo, startIndex);
            }
        } else {
            if (this.sortIndexArr.length > 0) {
                var listIndex = getRandom(0, this.sortIndexArr.length - 1);
                startIndex = this.sortIndexArr[listIndex];
                if (startIndex < this.infoList.length) {
                    ret = this.infoList[startIndex];
                } else {
                    ret = dlnaObj.getPlayBackFileInfo(this.curMediaInfo, startIndex);
                }
                //ret = this.infoList[startIndex];
                this.sortIndexArr.splice(listIndex, 1);
            }
        }
        if (mediaType == 1) {
            ret.processTxt = (startIndex + 1) + "/" + this.totalNum;
        }
    }
    return ret;
}
;
File_obj.prototype.usbPlayInit = function(mediaType, playIndex) {
    if (this.infoList.length < this.totalNum) {
        fileObj.getContentInfoByType();
    }
    if (mediaType == 2) {
        this.musicPlayObj.infoList = this.allMediaData[mediaType];
        this.musicPlayObj.playIndex = playIndex;
        this.musicPlayObj.sortIndexArr = [];
        for (var i = 0; i < this.musicPlayObj.infoList.length; i++) {
            this.musicPlayObj.sortIndexArr[i] = i;
        }
        this.musicPlayObj.sortIndexArr.splice(playIndex, 1);
    } else {
        this.usbPlayObj.infoList = this.allMediaData[mediaType];
        this.usbPlayObj.playIndex = playIndex;
        this.usbPlayObj.sortIndexArr = [];
        for (var i = 0; i < this.usbPlayObj.infoList.length; i++) {
            this.usbPlayObj.sortIndexArr[i] = i;
        }
        this.usbPlayObj.sortIndexArr.splice(playIndex, 1);
    }
}
;
File_obj.prototype.getPlayInfo = function(paramObj) {
    var isNext = paramObj.isNext;
    var isRepeat = paramObj.isRepeat;
    var mediaType = paramObj.mediaType;
    var isShuffle = paramObj.isShuffle;
    var isPlayAll = paramObj.isPlayAll;
    console.log("File_obj getPlayInfo isNext = " + isNext + ";isRepeat = " + isRepeat + ";isShuffle = " + isShuffle + ";mediaType = " + mediaType);
    var ret = null ;
    if (curBrowserType == BrowserType.Usb) {
        var playInfoObject;
        if (mediaType == 2) {
            playInfoObject = this.musicPlayObj;
        } else {
            playInfoObject = this.usbPlayObj;
        }
        if (typeof (isNext) == 'undefined') {
            this.usbPlayInit(mediaType, fileObj.infoList[this.focusIndex].PLAY_INDEX);
            ret = playInfoObject.infoList[playInfoObject.playIndex];
            if (mediaType == 1)
                ret.processTxt = (playInfoObject.playIndex + 1) + "/" + playInfoObject.infoList.length;
        } else if (isShuffle) {
            ret = this.getShuffleItemInfo(mediaType, isRepeat);
        } else {
            if (isNext) {
                var tempIndex = playInfoObject.playIndex;
                if (tempIndex + 1 < playInfoObject.infoList.length) {
                    playInfoObject.playIndex++;
                    ret = playInfoObject.infoList[playInfoObject.playIndex];
                } else if (isRepeat) {
                    playInfoObject.playIndex = 0;
                    ret = playInfoObject.infoList[playInfoObject.playIndex];
                }
            } else {
                if (playInfoObject.playIndex > 0) {
                    playInfoObject.playIndex--;
                    ret = playInfoObject.infoList[playInfoObject.playIndex];
                } else if (isRepeat && isPlayAll) {
                    playInfoObject.playIndex = playInfoObject.infoList.length - 1;
                    ret = playInfoObject.infoList[playInfoObject.playIndex];
                }
            }
            if (mediaType == 1 && ret)
                ret.processTxt = (playInfoObject.playIndex + 1) + "/" + playInfoObject.infoList.length;
        }
        if (ret) {
            fileObj.focusIndex = ret.MEDIA_INDEX;
        }
    } else {
        if (mediaType == 2 && this.dlnaMusicPlayObj.curMediaInfo.objectId != this.curMediaInfo.objectId) {
            var totalNum = this.dlnaMusicPlayObj.curMediaInfo.mediaInfo.subItemNum;
            var temp;
            if (typeof (isNext) == 'undefined') {
                console.log("typeof(isNext) == 'undefined'");
            } else if (isShuffle) {
                if (isRepeat) {
                    temp = getRandom(0, totalNum - 1);
                } else {
                    if (this.sortIndexArr.length > 0) {
                        var listIndex = getRandom(0, this.sortIndexArr.length - 1);
                        temp = this.sortIndexArr[listIndex];
                        this.sortIndexArr.splice(listIndex, 1);
                    }
                }
            } else {
                if (isNext) {
                    if (this.dlnaMusicPlayObj.curMediaInfo.playIndex + 1 < totalNum) {
                        temp = this.dlnaMusicPlayObj.curMediaInfo.playIndex + 1;
                    } else if (isRepeat) {
                        temp = 0;
                    }
                } else {
                    if (this.dlnaMusicPlayObj.curMediaInfo.playIndex > 0) {
                        temp = this.dlnaMusicPlayObj.curMediaInfo.playIndex - 1;
                    }
                }
            }
            if (typeof temp != 'undefined') {
                this.dlnaMusicPlayObj.curMediaInfo.playIndex = temp;
                ret = dlnaObj.getPlayBackFileInfo(this.dlnaMusicPlayObj.curMediaInfo, temp);
            }
            return ret;
        }
        var listIndex = this.focusIndex;
        if (typeof (isNext) == 'undefined') {
            this.sortIndexArr = [];
            for (var i = 0; i < this.totalNum; i++) {
                this.sortIndexArr[i] = i;
            }
            this.sortIndexArr.splice(listIndex, 1);
            ret = this.infoList[this.focusIndex];
            if (mediaType == 1) {
                var img = $('#other_meta_icon img');
                if (img.length <= 0 || !img.attr('src')) {
                    dlnaObj.getPhotoFileInfo(ret);
                }
            }
        } else if (isShuffle) {
            var temp = this.getShuffleItemInfo(mediaType, isRepeat);
            if (temp) {
                switch (mediaType) {
                case 1:
                    dlnaObj.getPhotoFileInfo(temp);
                    break;
                }
                ret = temp;
            }
        } else {
            if (isNext) {
                if (listIndex + 1 < this.totalNum) {
                    this.focusIndex++;
                    if (this.focusIndex >= this.infoList.length) {
                        fileObj.getOnePageInfo();
                        setFileInfoList('file_folder_ul', fileObj.infoList, Number($('#file_folder_ul').find('li').length));
                    }
                    if (mediaType == 1) {
                        dlnaObj.getPhotoFileInfo(this.infoList[this.focusIndex]);
                    }
                    ret = this.infoList[this.focusIndex];
                } else if (isRepeat) {
                    this.focusIndex = 0;
                    if (mediaType == 1) {
                        dlnaObj.getPhotoFileInfo(this.infoList[this.focusIndex]);
                    }
                    ret = this.infoList[this.focusIndex];
                }
            } else {
                if (listIndex > 0) {
                    this.focusIndex--;
                    if (mediaType == 1) {
                        dlnaObj.getPhotoFileInfo(this.infoList[this.focusIndex]);
                    }
                    ret = this.infoList[this.focusIndex];
                }
            }
        }
        if (mediaType == 2) {
            this.dlnaMusicPlayObj.playIndex = this.focusIndex;
        }
        if (ret && ret.MEDIA_INDEX) {
            console.log("ret.MEDIA_INDEX = " + ret.MEDIA_INDEX);
            fileObj.focusIndex = ret.MEDIA_INDEX;
        }
    }
    return ret;
}
;
var fileObj = new File_obj();
function scanDoneNotify(isNeedRef) {
    if (isNeedRef) {
        fileObj.childNode.getNodes(fileObj.infoList[fileObj.focusIndex], fileObj.isRootNode);
        change_current_path();
    }
    waitLoading(false);
}
function initFile(refresh) {
    console.log("initFile");
    clearFocusTimeoutResult();
    if (typeof (refresh) == 'undefined') {
        fileObj.initRoot();
    }
    if (curBrowserType == BrowserType.Usb && noPvrUsbMountList.length <= 0) {
        initNoPlayableUSBDeviceLayout();
        return;
    }
    change_current_path();
    waitLoading(false);
}
function initNoPlayableUSBDeviceLayout() {
    clearFocusTimeoutResult();
    item = $('<li tabindex = "0" class="focus">\
            <div class="music_name_p">\
                <div class="usb"></div>\
                <div class="music_content_div"><span id="span_no_usb_device" >' + getTranslate("USB Device") + '</span></div>\
            </div>\
            <span></span></li>');
    $("#file_folder_ul").empty().append(item);
    scroll1.refresh();
    switch_file_layout('prompt');
    $('#file_prompt_p').html('<p style="margin-bottom:10px">' + getTranslate("USB Device") + '</p>\
                <p style="font-size:16px;white-space:pre-wrap">' + getTranslate("MAIN_INFO_USB_BROWSER") + '</p>\
                <p style="font-size:16px;margin-top:10px">' + getTranslate("MAIN_MSG_NO_FILES_FOUND") + '</p>');
    $("#file_folder_ul li:first").focus();
    waitLoading(false);
}
function initNoUSBDeviceLayout() {
    clearFocusTimeoutResult();
    item = $('<li tabindex = "0" class="focus">\
            <div class="music_name_p">\
                <div class="usb"></div>\
                <div class="music_content_div"><span id="span_no_usb_device" >' + getTranslate("USB Device") + '</span></div>\
            </div>\
            <span></span></li>');
    $("#file_folder_ul").empty().append(item);
    scroll1.refresh();
    switch_file_layout('prompt');
    $('#file_prompt_p').html('<p style="margin-bottom:10px">' + getTranslate("USB Device") + '</p>\
                <p style="font-size:16px;white-space:pre-wrap">' + getTranslate("MAIN_INFO_USB_BROWSER") + '</p>\
                <p style="font-size:16px;margin-top:10px">' + getTranslate("QT_NO_DEVICE") + '</p>');
    $("#file_folder_ul li:first").focus();
}
function refreshRootList(isChangeCurServer) {
    console.log("refreshRootList");
    if (typeof (isChangeCurServer) == 'undefined') {
        isChangeCurServer = false;
    }
    if (isChangeCurServer || fileObj.isRootNode) {
        initFile();
    }
}
function dmsFileUpdate(mediaInfo) {
    if ((fileObj.curMediaInfo && fileObj.curMediaInfo.mediaInfo.fileObjId == mediaInfo.fileObjId) || fileObj.infoList[fileObj.focusIndex].mediaInfo.fileObjId == mediaInfo.fileObjId || fileObj.infoList[fileObj.focusIndex].mediaInfo.fileObjId == mediaInfo.parentId) {
        initFile(true);
    }
}
function change_current_path(isNext) {
    if (focusTimeoutResult) {
        console.log("focusTimeoutResult is true,don't change node return");
        return;
    }
    cur_focus_id = -1;
    var needRefresh = true;
    if (typeof (isNext) != 'undefined') {
        if ((isNext && fileObj.childNode.nodeList.length > 0) || !isNext) {
            needRefresh = fileObj.changeNode(isNext);
        } else {
            needRefresh = false;
        }
    } else if (curBrowserType == BrowserType.Dlna) {
        needRefresh = fileObj.changeNode();
    }
    if (needRefresh) {
        doRefreshLayout();
    }
}
function doRefreshLayout() {
    scroll1.scrollTo(0, 0, 0);
    change_folder_nav();
    if (curBrowserType == BrowserType.Usb && fileObj.curMediaInfo) {
        switch (fileObj.curMediaInfo.MEDIA_TYPE) {
        case MEDIA_TYPE.photoObj:
            setPhotoMenuInfo("file_folder_ul", fileObj.infoList);
            break;
        case MEDIA_TYPE.musicObj:
            setMusicMenuInfo("file_folder_ul", fileObj.infoList, 'music_top_menu_focus');
            break;
        case MEDIA_TYPE.musicArtist:
        case MEDIA_TYPE.musicAlbum:
        case MEDIA_TYPE.musicGenre:
        case MEDIA_TYPE.musicTrack:
            setMusicMenuInfo("file_folder_ul", fileObj.infoList, 'music_submenu_focus');
            break;
        case MEDIA_TYPE.musicList:
            setMusicMenuInfo("file_folder_ul", musicObj.infoList, 'music_list_focus');
            break;
        case MEDIA_TYPE.photoList:
            setPhotoMenuInfo("file_folder_ul", photoObj.infoList, 'photo_list_focus');
            break;
        case MEDIA_TYPE.videoObj:
            setVideoListInfo("file_folder_ul", videoObj.infoList);
            break;
        default:
            setFileInfoList('file_folder_ul', fileObj.infoList);
            break;
        }
    } else {
        setFileInfoList('file_folder_ul', fileObj.infoList);
    }
    switch_file_layout();
    scroll1.refresh();
    if (fileObj.infoList.length > 0) {
        if (!fileObj.isRootNode && fileObj.focusIndex > (fileObj.infoList.length - 1)) {
            var refStatus = fileObj.getContentInfoByType(fileObj.focusIndex - (fileObj.infoList.length - 2));
            if (refStatus) {
                setFileInfoList('file_folder_ul', fileObj.infoList);
            }
        }
        if (fileObj.infoList.length < Number(fileObj.focusIndex) + 1) {
            console.log("fileObj.infoList.length < fileObj.focusIndex+1");
            fileObj.focusIndex = 0;
        }
        fileScrollToElement(fileObj.focusIndex, false);
        if (needFocus()) {
            $('#file_folder_ul li:nth-child(' + (Number(fileObj.focusIndex) + 1) + ')').focus();
        }
    }
}
function resetFileListFocus() {
    if (needFocus()) {
        $('#file_folder_ul li.selected').removeClass('selected');
        $('#file_folder_ul li:nth-child(' + (Number(fileObj.focusIndex) + 1) + ')').focus();
        
        if($('#video_album_container').css("display")=="block")
		{		
			/* Stephen TF518PHIEUMTK05-829, video part start */
			videoColorKeyData[0].name = "";		
			videoColorKeyData[5].name = "";
			videoColorKeyData[5].show = false;
	    	initColorKeyBar(videoColorKeyData);
	    	
	    	videoColorKeyData[0].name = "Play All";		
			videoColorKeyData[5].name = "Info";
			videoColorKeyData[5].show = true;
	    	/* Stephen TF518PHIEUMTK05-829,video part end */
		}
				
    }
}
function needFocus() {
    if (contentBrowserObj.curShowMode == contentBrowserObj.ShowMode.Browser || (contentBrowserObj.curShowMode == contentBrowserObj.ShowMode.MusicPlay)) {
        if (!isDialogShow()) {
            return true;
        }
    }
    return false;
}
function setFileInfoList(showId, fileList, startIndex) {
    if (typeof showId == 'string') {
        if (typeof (startIndex) == 'undefined') {
            $('#' + showId).html('');
            startIndex = 0;
        }
    } else {
        startIndex = 0;
    }
    for (var ints = startIndex; ints < fileList.length; ints++) {
        var ico_class = undefined;
        var class_info;
        var instructions = '';
        var type;
        if (curBrowserType == BrowserType.Usb) {
            if (fileList[ints].hasOwnProperty('MEDIA_TYPE')) {
                type = Number(fileList[ints].MEDIA_TYPE);
            } else {
                type = MEDIA_TYPE.rootObj;
            }
        } else {
            if (fileObj.isRootNode && showId == 'file_folder_ul') {
                type = 6;
            } else {
                type = Number(fileList[ints].mediaInfo.mediaType);
            }
        }
        switch (type) {
        case 1:
            ico_class = '<div class="photo"></div>';
            break;
        case 2:
            ico_class = '<div class="music"></div>';
            break;
        case 3:
            ico_class = '<div class="video"></div>';
            break;
        case 4:
            if (curBrowserType == BrowserType.Usb) {
                ico_class = '<div class="folder"></div>';
                instructions = '<span></span>';
            }
            break;
        case 6:
            if (curBrowserType == BrowserType.Dlna) {
                ico_class = '<div class="folder"></div>';
                instructions = '<span></span>';
            }
            break;
        case MEDIA_TYPE.rootObj:
            if (curBrowserType == BrowserType.Usb) {
                ico_class = '<div class="usb"></div>';
                instructions = '<span></span>';
            }
            break;
        case MEDIA_TYPE.photoObj:
            if (curBrowserType == BrowserType.Usb) {
                ico_class = '<div class="photo"></div>';
                item_name = fileList[ints].LABEL;
            }
            break;
        case MEDIA_TYPE.musicObj:
            if (curBrowserType == BrowserType.Usb) {
                ico_class = '<div class="music"></div>';
            }
            break;
        case MEDIA_TYPE.videoObj:
            if (curBrowserType == BrowserType.Usb) {
                ico_class = '<div class="video"></div>';
                item_name = fileList[ints].LABEL;
            }
            break;
        case MEDIA_TYPE.folderObj:
            if (curBrowserType == BrowserType.Usb) {
                ico_class = '<div class="folder"></div>';
                instructions = '<span></span>';
            }
            break;
        case MEDIA_TYPE.musicArtist:
        case MEDIA_TYPE.musicAlbum:
        case MEDIA_TYPE.musicGenre:
        case MEDIA_TYPE.musicTrack:
            if (curBrowserType == BrowserType.Usb) {
                ico_class = '<div class="folder"></div>';
                instructions = '<span></span>';
            }
            break;
        }
        if (type == 0) {
            return;
        }
        if (typeof (ico_class) == 'undefined') {
            ico_class = '<div class="folder"></div>';
            instructions = '<span></span>';
        }
        var item = null ;
        var id;
        if (typeof showId == 'string') {
            id = showId + ints;
        } else {
            id = showId.attr('id') + ints;
        }
        var filePath_forPlay;
        if (curBrowserType == BrowserType.Usb) {
            if (isNaN(type)) {
                type = MEDIA_TYPE.rootObj;
            }
            switch (type) {
            case MEDIA_TYPE.rootObj:
                if (fileList[ints].LABEL != "") {
                    item_name = fileList[ints].LABEL;
                } else {
                    var info = usbObj.getUsbProductInfo(fileList[ints].DEV);
                    var res = JSON.parse(info);
                    if (res && res.ITEMS[0] && res.ITEMS[0].TEXT) {
                        labelName = res.ITEMS[0].TEXT;
                        item_name = labelName;
                        fileList[ints].LABEL = getTranslate(labelName);
                    } else {
                        var path = fileList[ints].PATH;
                        var lastStr = path.substring(path.length - 1);
                        if (lastStr == "/") {
                            path = path.substring(0, path.length - 1);
                        }
                        item_name = getTranslate('USB Device') + " " + path.substring(path.lastIndexOf("/") + 1).charAt(2).toLocaleUpperCase();
                        labelName = item_name;
                        fileList[ints].LABEL = item_name;
                    }
                }
                break;
            case MEDIA_TYPE.photoObj:
            case MEDIA_TYPE.musicObj:
            case MEDIA_TYPE.videoObj:
            case MEDIA_TYPE.folderObj:
            case MEDIA_TYPE.musicArtist:
            case MEDIA_TYPE.musicAlbum:
            case MEDIA_TYPE.musicGenre:
            case MEDIA_TYPE.musicTrack:
                item_name = getTranslate(fileList[ints].LABEL);
                break
            default:
                item_name = fileList[ints].MEDIA_PATH.substring(fileList[ints].MEDIA_PATH.lastIndexOf("/") + 1);
                filePath_forPlay = fileList[ints].MEDIA_PATH;
                break;
            }
            item = $('<li id="' + id + '" filePath = "' + filePath_forPlay + '" tabindex = "0" onfocus=\'file_music_list_focus(true, "' + id + '");\' onblur=\'file_music_list_focus(false, "' + id + '");\' ><div class=\'music_name_p\'>' + ico_class + '<div class="music_content_div"><span id="span_' + id + '">' + item_name + '</span></div></div>' + instructions + '</li>');
        } else {
            if (!fileList[ints].mediaInfo || (fileObj.isRootNode && showId == 'file_folder_ul')) {
                item_name = fileList[ints].SERVER_NAME;
            } else {
                item_name = fileList[ints].mediaInfo.mediaName;
            }
            item = $('<li id="' + id + '" filePath = "' + fileList[ints].objectId + '"  tabindex = "0" onfocus=\'file_music_list_focus(true, "' + id + '");\' onblur=\'file_music_list_focus(false, "' + id + '");\' ><div class=\'music_name_p\'>' + ico_class + '<div class="music_content_div"><span id="span_' + id + '">' + item_name + '</span></div></div>' + instructions + '</li>');
        }
        if (typeof showId == 'string') {
            $("#" + showId).append(item);
        } else {
            item.insertBefore(showId);
        }
    }
}
function change_folder_nav() {
    var previous_folder_name = '';
    var before_previous_folder_name = '';
    if (curBrowserType == BrowserType.Usb) {
        if (fileObj.floderStack.length >= 2) {
            showOrHideNav(2);
            var obj1 = fileObj.floderStack[fileObj.floderStack.length - 1];
            var obj2 = fileObj.floderStack[fileObj.floderStack.length - 2];
            if (obj1.LABEL) {
                previous_folder_name = obj1.LABEL;
            } else {
                previous_folder_name = obj1.MEDIA_PATH.substring(obj1.MEDIA_PATH.lastIndexOf("/") + 1);
            }
            if (obj2.LABEL) {
                before_previous_folder_name = obj2.LABEL;
            } else {
                before_previous_folder_name = obj2.MEDIA_PATH.substring(obj2.MEDIA_PATH.lastIndexOf("/") + 1);
            }
        } else if (fileObj.floderStack.length == 1) {
            showOrHideNav(1);
            previous_folder_name = fileObj.floderStack[0].LABEL;
        } else {
            showOrHideNav(0);
        }
        $("#first_menu").html(getTranslate(previous_folder_name));
        $("#second_menu").html(getTranslate(before_previous_folder_name));
    } else {
        if (!fileObj.curMediaInfo) {
            showOrHideNav(0);
        } else {
            if (fileObj.curMediaInfo.objectId == 0) {
                showOrHideNav(1);
                previous_folder_name = curMediaServer.SERVER_NAME;
            } else {
                showOrHideNav(2);
                previous_folder_name = fileObj.curMediaInfo.mediaInfo.mediaName;
                var prevTemp = fileObj.floderStack[fileObj.floderStack.length - 2];
                if (prevTemp.objectId == 0) {
                    before_previous_folder_name = prevTemp.SERVER_NAME;
                } else {
                    before_previous_folder_name = prevTemp.mediaInfo.mediaName;
                }
            }
        }
        $("#first_menu").html(getTranslate(previous_folder_name));
        $("#second_menu").html(getTranslate(before_previous_folder_name));
    }
}
function showOrHideNav(type) {
    switch (type) {
    case 0:
        $('#file_list_one_layout').css('margin-left', '27px');
        $('.left_menu_bar').hide();
        $('#vertical_line1').hide()
        break
    case 1:
        $('#file_list_one_layout').css('margin-left', '83px');
        $('#vertical_line1').css('left', '72px');
        $('#vertical_line1').show();
        $('.left_menu_bar').css('left', '-214px');
        $('.left_menu_bar').show();
        break;
    case 2:
        $('#file_list_one_layout').css('margin-left', '128px');
        $('#vertical_line1').css('left', '117px');
        $('#vertical_line1').show();
        $('.left_menu_bar').css('left', '-168px');
        $('.left_menu_bar').show();
        break;
    }
}
function file_key_dispatch_dom_vk_return(id, playAll) {
    if (!id)
        return;
    //clearFocusTimeoutResult();
    var index = $('#' + id).index();
    if (fileObj.indexFocus) {
        if (fileObj.indexFocus != index) {
            console.log("fileObj.indexFocus : " + fileObj.indexFocus + " != index : " + index);
            index = fileObj.indexFocus;
        }
    }
    var itemInfo = fileObj.infoList[index];
    var meidaType;
    if (curBrowserType == BrowserType.Usb) {
        meidaType = itemInfo.MEDIA_TYPE;
    } else {
        meidaType = itemInfo.mediaInfo.mediaType;
    }
    console.log("[fileBrowser  file_do_return] meidaType:" + meidaType);
    playAll = (typeof (playAll) == 'undefined') ? false : playAll;
    switch (Number(meidaType)) {
    case 1:
        clearFocusTimeoutResult();
        fileObj.curSourceType = (curBrowserType == BrowserType.Usb) ? SourceType.Usb : SourceType.Dmp;
        if (curBrowserType == BrowserType.Dlna) {
            opera_omi.sendPlatformMessage("watchdog disable"); //mark0320
            fileObj.dlnaMusicPlayObj.curMediaInfo = clone(fileObj.curMediaInfo);
            fileObj.dlnaMusicPlayObj.DEV_ID = curMediaServer.DEV_ID;
        }
        waitLoading(false);
        contentBrowserObj.playPhoto(fileObj, playAll);
        break;
    case 2:
        fileObj.curSourceType = (curBrowserType == BrowserType.Usb) ? SourceType.Usb : SourceType.Dmp;
        if (curBrowserType == BrowserType.Dlna) {
            fileObj.dlnaMusicPlayObj.curMediaInfo = clone(fileObj.curMediaInfo);
            fileObj.dlnaMusicPlayObj.DEV_ID = curMediaServer.DEV_ID;
        }
        contentBrowserObj.playMusic(fileObj, null , playAll);
        break;
    case 3:
        clearFocusTimeoutResult();
        if (curBrowserType == BrowserType.Usb) {
            fileObj.curSourceType = SourceType.Usb;
        } else {
            if (curMediaServer.dmsType == DMS_TYPE.MultiRoom) {
                fileObj.curSourceType = SourceType.MultiRoom;
                playAll = false;
            } else {
                fileObj.curSourceType = SourceType.Dmp;
                fileObj.dlnaMusicPlayObj.curMediaInfo = clone(fileObj.curMediaInfo);
                fileObj.dlnaMusicPlayObj.DEV_ID = curMediaServer.DEV_ID;
            }
        }
        waitLoading(false);
        contentBrowserObj.playVideo(fileObj, fileObj.curSourceType, playAll);
        break;
    case 4:
    case 5:
    case MEDIA_TYPE.rootObj:
    case MEDIA_TYPE.folderObj:
    case MEDIA_TYPE.musicObj:
    case MEDIA_TYPE.musicList:
    case MEDIA_TYPE.musicArtist:
    case MEDIA_TYPE.musicAlbum:
    case MEDIA_TYPE.musicGenre:
    case MEDIA_TYPE.musicTrack:
    case MEDIA_TYPE.photoObj:
        if (curBrowserType == BrowserType.Usb) {
            change_current_path(true);
        }
        break;
    case MEDIA_TYPE.videoObj:
        if (videoObj.showMode == SHOW_MODE.Thumbnails) {
            do_album_focus();
        } else {
            change_current_path(true);
        }
        break;
    case MEDIA_TYPE.photoList:
        if (photoObj.showMode == SHOW_MODE.Thumbnails) {
			if(rightKeyenable) /* Stephen 180129, TF518PHILTMTK02-542 */
            {	
            	do_album_focus();
			}
        } else {
            change_current_path(true);
        }
        break;
    case 6:
        if (curBrowserType == BrowserType.Dlna) {
            change_current_path(true);
        }
    default:
        break;
    }
}
function playDLNAVideo(playAll) {
    contentBrowserObj.playVideo(fileObj, null , playAll);
}
function switch_file_layout(layout_type) {
    switch (layout_type) {
    case 'list':
        $("#file_prompt_p").empty().hide();
        $("#file_list_two_info").empty().hide();
        $('#album_container_layout').hide();
        $('#file_list_two').empty();
        $("#music_list").show();
        break;
    case 'info':
        $("#file_prompt_p").empty().hide();
        $("#music_list").hide();
        $('#album_container_layout').hide();
        $("#file_list_two_info").empty().show();
        break;
    case 'prompt':
        $("#music_list").hide();
        $('#album_container_layout').hide();
        $("#file_list_two_info").empty().hide();
        $("#file_prompt_p").empty().show();
        break;
    case 'photo':
        $("#file_prompt_p").empty().hide();
        $("#file_list_two_info").empty().hide();
        $("#music_list").hide();
        $('#album_container_layout').show();
        $('#photo_album_container').show();
        $('#video_album_container').hide();
        break;
    case 'video':
        $("#file_prompt_p").empty().hide();
        $("#file_list_two_info").empty().hide();
        $("#music_list").hide();
        $('#album_container_layout').show();
        $('#photo_album_container').hide();
        $('#video_album_container').show();
        break;
    default:
        $("#file_prompt_p").empty().hide();
        $("#music_list").hide();
        $('#album_container_layout').hide();
        $("#file_list_two_info").empty().hide();
        break;
    }
}
function show_thumbnail_info(index) {
    try {
        console.log("show_thumbnail_info index = " + index);
        focusTimeoutResult = null ;
        var itemInfo = fileObj.infoList[index];
        fileObj.setFocusIndex(index);
        if (curBrowserType == BrowserType.Usb) {
            meidaType = itemInfo.MEDIA_TYPE;
        } else {
            meidaType = itemInfo.mediaInfo.mediaType;
        }
        startMarqueeScroll($('#file_folder_ul li:nth-child(' + (Number(index) + 1) + ') .music_content_div>span'));
        switch (Number(meidaType)) {
        case 1:
            setItemColorKey($('#footer').find('li')[0], 'Play All');
            if (curBrowserType != BrowserType.Usb) {
                dlnaObj.getPhotoFileInfo(itemInfo);
            }
            show_thumbnail_info_picture(fileObj.childNode.nodeInfo);
            break;
        case 2:
            setItemColorKey($('#footer').find('li')[0], 'Play All');
            show_thumbnail_info_music(fileObj.childNode.nodeInfo);
            if (curBrowserType == BrowserType.Usb) {
                startGetShowThumbnail(fileObj.childNode.nodeInfo.MEDIA_PATH, meidaType);
            }
            break;
        case 3:
            setItemColorKey($('#footer').find('li')[0], 'Play All');
            musicPlayObj.stopMusic(true);
            //get video thumbnail,if play music need to stop music play
            show_thumbnail_info_video(fileObj.childNode.nodeInfo);
            if (curBrowserType == BrowserType.Usb) {
                startGetShowThumbnail(fileObj.childNode.nodeInfo.MEDIA_PATH, meidaType);
            }
            break;
        case MEDIA_TYPE.photoObj:
            curObjectType = 'photoObj';
            initPhotoMode(null , true);
            fileObj.childNode.nodeNum = photoObj.pageInfo.submenuData.length;
            fileObj.childNode.nodeList = photoObj.pageInfo.submenuData;
            showPhotoMenu(photoObj.pageInfo.submenuData);
            break;
        case MEDIA_TYPE.musicObj:
            curObjectType = 'musicObj';
            showMusicMenu(fileObj.childNode.nodeList);
            break;
        case MEDIA_TYPE.videoObj:
            musicPlayObj.stopMusic(true);
            switchVideoMode();
            curObjectType = 'videoObj';
            break;
        case MEDIA_TYPE.folderObj:
            clearThumbnail();
            curObjectType = 'folderObj';
        case MEDIA_TYPE.Folder:
        case MEDIA_TYPE.rootObj:
        case MEDIA_TYPE.musicArtist:
        case MEDIA_TYPE.musicAlbum:
        case MEDIA_TYPE.musicGenre:
        case MEDIA_TYPE.musicTrack:
            if (curBrowserType == BrowserType.Usb) {
                show_thumbnail_info_folder(fileObj.childNode.nodeList);
            }
            break;
        case 5:
            if (curBrowserType == BrowserType.Usb) {
                show_thumbnail_info_folder(fileObj.childNode.nodeList);
            }
            break;
        case 6:
            if (curBrowserType == BrowserType.Dlna) {
                show_thumbnail_info_folder(fileObj.childNode.nodeList);
            }
            break;
        default:
            //TODO:
            if (curBrowserType == BrowserType.Dlna && fileObj.isRootNode) {
                if (itemInfo.statusType && itemInfo.statusType == DMS_STATUS_TYPE.OfflineWakable) {
                    // TODO wakeup
                    switch_file_layout('prompt');
                    $('#file_prompt_p').html(getTranslate('QT_SERVER_OFFLINE_WAKE_UP'));
                    return;
                }
            }
            switch_file_layout();
            break;
        }
    } catch (e) {
        console.log(e.message);
        if (curBrowserType == BrowserType.Dlna){              //mark0307
            opera_omi.sendPlatformMessage("watchdog enable"); //mark0307
        }   //mark0307     
    } finally {
        if (curBrowserType == BrowserType.Dlna) {
            opera_omi.sendPlatformMessage("watchdog enable"); //mark0307

            waitLoading(false);
        }
    }
}
var getShowThumbnail_t = null ;
function startGetShowThumbnail(path, type) {
    if (getShowThumbnail_t) {
        clearTimeout(getShowThumbnail_t);
        getShowThumbnail_t = null ;
    }
    getShowThumbnail_t = setTimeout("get_show_thumbnail('" + path + "'," + type + ")", 2000);
}
function get_show_thumbnail(path, type) {
    var defImg = "";
    switch (type) {
    case 2:
        //defImg = "../Assets/Contents_Browser/_Music_Browser/MUSIC_AlbumLayout_default_icon.png";
        getThumbnail({
            MEDIA_PATH: path,
            width: 368,
            height: 368,
            MEDIA_TYPE: type,
            id: 'music_meta_icon',
            needWait: false
        });
        break;
    case 3:
        //defImg = "../Assets/Contents_Browser/_Movie_Browser/movie-icon-HL.png";
        getThumbnail({
            MEDIA_PATH: path,
            width: 240,
            height: 160,
            MEDIA_TYPE: type,
            id: 'other_meta_icon',
            needWait: false
        });
        break;
    }
    getShowThumbnail_t = null ;
}
function show_thumbnail_info_folder(listInfo) {
    switch_file_layout('list');
    if (!listInfo || listInfo.length <= 0) {
        if (curBrowserType == BrowserType.Dlna) {
            switch_file_layout('prompt');
            $('#file_prompt_p').html(getTranslate('QT_MEDIA_NO_SHARE_CONTENT'));
        } else {
            $("#music_list").hide();
            $('#file_list_two').html('');
        }
        waitLoading(false);
        return;
    }
    setFileInfoList("file_list_two", listInfo);
    waitLoading(false);
}
function show_thumbnail_info_music(thumbnail_info) {
    try {
        switch_file_layout('info');
        if (!thumbnail_info) {
            $("#file_list_two_info").hide();
            return;
        }
        var title = '';
        var subTitle = '';
        if (curBrowserType == BrowserType.Usb) {
            var htmlShow = "";
            if (thumbnail_info.TITLE) {
                title = thumbnail_info.TITLE;
            } else {
                if (thumbnail_info.MEDIA_PATH) {
                    if (thumbnail_info.MEDIA_PATH) {
                        title = thumbnail_info.MEDIA_PATH.substring(thumbnail_info.MEDIA_PATH.lastIndexOf("/") + 1);
                    }
                }
            }
            if (thumbnail_info.ALBUM) {
                subTitle = thumbnail_info.ALBUM;
                subTitle += "&nbsp;&nbsp;&nbsp;&nbsp;";
            }
            var durationTime = timeFormat(thumbnail_info.DURATION);
            //getThumbnail({MEDIA_PATH:thumbnail_info.MEDIA_PATH,width:226,height:226,MEDIA_TYPE:2,id:'music_meta_icon',needWait:false});
            $("#file_list_two_info").empty().append('<div style="width:440px;height:368px;position:relative;">\
                    <div style="float:left;width:368px;height:368px;background:url(../Assets/Contents_Browser/music_thumbnail_bg.png)">\
                        <img id="music_meta_icon" onerror="javascript:this.src=\'\'">\
                    </div>\
                    <div style="float:right;width:72px;height:368px;background:url(../Assets/Contents_Browser/music_thumbnail_right.png);"></div>\
                    <div style="padding-left:18px;position: absolute;z-index: 2;width: 332px;margin-bottom: 20px;bottom: 0px;">\
                        <p >' + title + '</p>\
                        <p class="sub_p">' + subTitle + '</p>\
                    </div>\
                    <div style="padding-left:18px;position: absolute;z-index: 2;width: 368px;margin-top: 388px;">\
                        <p class="" style="text-align: right;float: right;">' + durationTime + '</p>\
                    </div>\
                    <div id="music_bg_play_layout" style="height: 50px;width: 368px;position:absolute;margin-top:368px;display:none;">\
                        <div style="width: 368px;height: 6px;background-color: rgba(71,71,71,0.6);">\
                            <div id="bg_music_progress" class="music_progress"></div>\
                        </div>\
                        <div style="position: absolute;z-index: 2;width: 368px;top: 20px;">\
                            <p id="bg_music_cur_time" style="width: 100px;float: left;"></p>\
                        </div>\
                    </div>\
                </div>');
            $('#music_bg_play_layout').attr('filePath', thumbnail_info.MEDIA_PATH);
            if (thumbnail_info.MEDIA_PATH && thumbnail_info.MEDIA_PATH == musicPlayObj.getCurPlayPath()) {
                $('#music_bg_play_layout').show();
            }
        } else {
            $("#file_list_two_info").empty().append('<div style="width:440px;height:368px;position:relative;">\
                    <div style="float:left;width:368px;height:368px;background:url(../Assets/Contents_Browser/music_thumbnail_bg.png)">\
                        <img id="music_meta_icon" onerror="javascript:this.src=\'\'">\
                    </div>\
                    <div style="float:right;width:72px;height:368px;background:url(../Assets/Contents_Browser/music_thumbnail_right.png);"></div>\
                    <div style="padding-left:18px;position: absolute;z-index: 2;width: 332px;margin-bottom: 20px;bottom: 0px;">\
                        <p >' + thumbnail_info.mediaName + thumbnail_info.mediaExtension + '</p>\
                        <p class="sub_p">' + thumbnail_info.mediaAlbum + '</p>\
                    </div>\
                    <div style="padding-left:18px;position: absolute;z-index: 2;width: 368px;margin-top: 388px;">\
                        <p class="" style="text-align: right;float: right;">' + thumbnail_info.mediaDuration.split(".")[0] + '</p>\
                    </div>\
                    <div id="music_bg_play_layout" style="height: 50px;width: 368px;position:absolute;margin-top:368px;display:none;">\
                        <div style="width: 368px;height: 6px;background-color: rgba(71,71,71,0.6);">\
                            <div id="bg_music_progress" class="music_progress"></div>\
                        </div>\
                        <div style="position: absolute;z-index: 2;width: 368px;top: 20px;">\
                            <p id="bg_music_cur_time" style="width: 100px;float: left;"></p>\
                        </div>\
                    </div>\
                </div>');
            if (thumbnail_info.MEDIA_PATH && thumbnail_info.MEDIA_PATH == musicPlayObj.getCurPlayPath()) {
                $('#music_bg_play_layout').show();
            }
        }
    } catch (e) {
        console.log(e);
    }
}
function refreshBgPlay() {
    var path = $('#music_bg_play_layout').attr('filePath');
    if (path && path == musicPlayObj.getCurPlayPath()) {
        $('#music_bg_play_layout').show();
    } else {
        $('#music_bg_play_layout').hide();
    }
}
function show_thumbnail_info_picture(thumbnail_info) {
    try {
        switch_file_layout('info');
        if (!thumbnail_info) {
            $("#file_list_two_info").hide();
            return;
        }
        var title = '';
        var subTitle = '';
        if (curBrowserType == BrowserType.Usb) {
            getThumbnail({
                MEDIA_PATH: thumbnail_info.MEDIA_PATH,
                width: 480,
                height: 320,
                MEDIA_TYPE: 1,
                id: 'other_meta_icon',
                needWait: false
            });
            var htmlShow = "";
            if (thumbnail_info.MEDIA_PATH) {
                title = thumbnail_info.MEDIA_PATH.substring(thumbnail_info.MEDIA_PATH.lastIndexOf("/") + 1);
            }
            if (thumbnail_info.DATE) {
                if (thumbnail_info.DATE.YEAR && thumbnail_info.DATE.MONTH && thumbnail_info.DATE.DAY) {
                    subTitle = thumbnail_info.DATE.DAY + "/" + thumbnail_info.DATE.MONTH + "/" + thumbnail_info.DATE.YEAR;
                    subTitle += '&nbsp;&nbsp;&nbsp;&nbsp;';
                }
            }
            if (thumbnail_info.WIDTH && thumbnail_info.HEIGHT) {
                subTitle += thumbnail_info.WIDTH + "x" + thumbnail_info.HEIGHT;
            }
            $("#file_list_two_info").empty().append('<div id="other_meta_layout" style="width:480px;height:320px;position: relative;background:url(../Assets/Contents_Browser/photo_thumbnail_bg.png);">\
                    <img id="other_meta_icon" style="width:100%;height:100%;" onerror="javascript:this.src=\'\'">\
                    <div style="bottom:0px;width:100%;height:100%;background:url(../Assets/Contents_Browser/meta_info_bg.png);position:absolute;">\
                        <div style="padding-left:18px;position:absolute;z-index:2;width:480px;bottom: 20px;">\
                            <p >' + title + '</p>\
                            <p class="sub_p">' + subTitle + '</p>\
                        </div>\
                    </div>\
                </div>');
        } else {
            var subTitle = '';
            if (thumbnail_info.mediaDate) {
                if (thumbnail_info.mediaDate.year && thumbnail_info.mediaDate.month && thumbnail_info.mediaDate.day) {
                    subTitle = thumbnail_info.mediaDate.day + "/" + thumbnail_info.mediaDate.month + "/" + thumbnail_info.mediaDate.year;
                    subTitle += '&nbsp;&nbsp;&nbsp;&nbsp;';
                }
            }
            if (thumbnail_info.mediaResolution) {
                subTitle += thumbnail_info.mediaResolution;
            }
            getThumbnail({
                MEDIA_PATH: thumbnail_info.localPath,
                width: 480,
                height: 320,
                MEDIA_TYPE: 1,
                id: 'other_meta_icon',
                needWait: false
            });
            $("#file_list_two_info").empty().append('<div id="other_meta_layout" style="width:480px;height:320px;position: relative;background:url(../Assets/Contents_Browser/photo_thumbnail_bg.png);">\
                    <img id="other_meta_icon" style="width:100%;height:100%;" onerror="javascript:this.src=\'\'">\
                    <div style="bottom:0px;width:100%;height:100%;background:url(../Assets/Contents_Browser/meta_info_bg.png);position:absolute;">\
                        <div style="padding-left:18px;position:absolute;z-index:2;width:480px;bottom: 20px;">\
                            <p >' + thumbnail_info.mediaName + thumbnail_info.mediaExtension + '</p>\
                            <p class="sub_p">' + subTitle + '</p>\
                        </div>\
                    </div>\
                </div>');
        }
    } catch (e) {
        console.log(e);
    }
}
function show_thumbnail_info_video(thumbnail_info) {
    try {
        switch_file_layout('info');
        if (!thumbnail_info) {
            $("#file_list_two_info").hide();
            return;
        }
        var title = '';
        var subTitle = '';
        if (curBrowserType == BrowserType.Usb) {
            //getThumbnail({MEDIA_PATH:thumbnail_info.MEDIA_PATH,width:224,height:224,MEDIA_TYPE:3,id:'file_thumbnail_img',needWait:false,defaultImg:"../Assets/Contents_Browser/_Movie_Browser/movie-icon-HL.png"});
            if (thumbnail_info.TITLE) {
                title = thumbnail_info.TITLE;
            } else {
                if (thumbnail_info.MEDIA_PATH) {
                    title = thumbnail_info.MEDIA_PATH.substring(thumbnail_info.MEDIA_PATH.lastIndexOf("/") + 1);
                }
            }
            if (thumbnail_info.DATE) {
                if (thumbnail_info.DATE.YEAR && thumbnail_info.DATE.MONTH && thumbnail_info.DATE.DAY) {
                    subTitle = thumbnail_info.DATE.DAY + "/" + thumbnail_info.DATE.MONTH + "/" + thumbnail_info.DATE.YEAR;
                    subTitle += '&nbsp;&nbsp;&nbsp;&nbsp;';
                }
            }
            /*
            if (thumbnail_info.SIZE || thumbnail_info.SIZE == 0) {
                if(Math.ceil(thumbnail_info.SIZE/(1024*1024)) > 1024){
                    var sizeVideo = thumbnail_info.SIZE/(1024*1024*1024);
                    htmlShow += "<p class='metadate-style'>"+getTranslate("DP_SZ") + sizeVideo.toFixed(2) + "GB</p>";
                }
            }*/
            $("#file_list_two_info").empty().append('<div id="other_meta_layout" style="width:480px;height:320px;position: relative;background:url(../Assets/Contents_Browser/video_thumbnail_bg.png);">\
                        <img id="other_meta_icon" style="width:100%;height:100%;" onerror="javascript:this.src=\'\'">\
                        <div style="bottom:0px;width:100%;height:100%;background:url(../Assets/Contents_Browser/meta_info_bg.png);position:absolute;">\
                            <div style="padding-left:18px;position:absolute;z-index:2;width:480px;bottom: 20px;">\
                                <p >' + title + '</p>\
                                <p class="sub_p">' + subTitle + '</p>\
                            </div>\
                        </div>\
                    </div>');
        } else {
            var subTitle = "";
            if (curMediaServer.dmsType == DMS_TYPE.MultiRoom && thumbnail_info.mediaDate.year == 0 && thumbnail_info.mediaDate.month == 0 && thumbnail_info.mediaDate.day == 0 && thumbnail_info.mediaDate.hour == 0 && thumbnail_info.mediaDate.minute == 0 && thumbnail_info.mediaDate.second == 0) {
                subTitle = "";
            } else {
                subTitle = thumbnail_info.mediaDate.day + "/" + thumbnail_info.mediaDate.month + "/" + thumbnail_info.mediaDate.year;
                ;subTitle += '&nbsp;&nbsp;&nbsp;&nbsp;';
            }
            //if(curMediaServer.dmsType != DMS_TYPE.MultiRoom || thumbnail_info.mediaSize != 0){
            //  mediasize = " <p  class='metadate-style'>"+getTranslate("DP_SZ") + bytesToMb(thumbnail_info.mediaSize) + "</p>";
            //}
            var mediaduation = "";
            if (curMediaServer.dmsType != DMS_TYPE.MultiRoom || thumbnail_info.mediaDuration != "") {
                subTitle += thumbnail_info.mediaDuration;
            }
            $("#file_list_two_info").empty().append('<div id="other_meta_layout" style="width:480px;height:320px;position: relative;background:url(../Assets/Contents_Browser/video_thumbnail_bg.png);">\
                        <img id="other_meta_icon" style="width:100%;height:100%;" onerror="javascript:this.src=\'\'">\
                        <div style="bottom:0px;width:100%;height:100%;background:url(../Assets/Contents_Browser/meta_info_bg.png);position:absolute;">\
                            <div style="padding-left:18px;position:absolute;z-index:2;width:480px;bottom: 20px;">\
                                <p >' + thumbnail_info.mediaName + thumbnail_info.mediaExtension + '</p>\
                                <p class="sub_p">' + subTitle + '</p>\
                            </div>\
                        </div>\
                    </div>');
        }
    } catch (e) {
        console.log(e);
    }
}
function isShowMusiclist() {
    if (curBrowserType == BrowserType.Usb && fileObj.curMediaInfo) {
        if (fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.musicList) {
            return true;
        }
    }
    return false;
}
function isShowVideolist() {
    if (curBrowserType == BrowserType.Usb && fileObj.curMediaInfo) {
        if (fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.videoObj && videoObj.showMode == SHOW_MODE.List) {
            return true;
        }
    }
    return false;
}
function isShowPhotolist() {
    if (curBrowserType == BrowserType.Usb && fileObj.curMediaInfo) {
        if (fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.photoList) {
            return true;
        }
    }
    return false;
}
function file_key_dispatch(isup, e) {
    console.log("file_key_dispatch id= " + e.target.id);
    var id = e.target.id;
    if (id == "") {
        return;
    }
    if (dmsWakeupDialog) {
        dms_wakeup_key_dispatch(isup, event);
        return;
    }
    if (!isup) {
        return;
    }
    if (isShowMusiclist()) {
        music_list_key_dispatch(isup, e);
        return;
    } else if (isShowVideolist()) {
        video_list_key_dispatch(isup, e);
        return;
    } else if (isShowPhotolist()) {
        photo_list_key_dispatch(isup, e);
        return;
    }
    var content = document.getElementById(id);
    var focus_id;
    var keynum = e.which || e.keyCode;
    switch (keynum) {
    case KeyEvent.DOM_VK_LEFT:
        change_current_path(false);
        break;
    case KeyEvent.DOM_VK_UP:
        var content = $(e.target).prev();
        if (content.length > 0) {
            var index = $(e.target).index();
            if (curBrowserType == BrowserType.Dlna && index == 1) {
                if (fileObj.curMediaInfo && fileObj.curMediaInfo.dlnaInfoStartIndex > 0) {
                    setFileInfoList($('#file_folder_ul li:first'), fileObj.getDlnaPrevInfo(8));
                    scroll1.refresh();
                }
            }
            var down_index = content.index();
            fileScrollToElement(down_index, true);
            content.focus();
        }
        break;
    case KeyEvent.DOM_VK_DOWN:
        var index = $(e.target).index();
        if (fileObj.curMediaInfo && fileObj.infoList && fileObj.infoList.length <= (index + 2)) {
            var strIndex = fileObj.infoList.length;
            if (fileObj.curMediaInfo && fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.photoObj) {
                fileObj.getOnePageInfo();
                setPhotoMenuInfo('file_folder_ul', fileObj.infoList, null , strIndex);
                scroll1.refresh();
            } else if (fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.musicArtist || fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.musicAlbum || fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.musicGenre) {
                fileObj.getOnePageInfo();
                setMusicMenuInfo("file_folder_ul", fileObj.infoList, 'music_submenu_focus', strIndex);
                scroll1.refresh();
            } else if (fileObj.infoList.length < fileObj.totalNum) {
                fileObj.getOnePageInfo();
                setFileInfoList('file_folder_ul', fileObj.infoList, strIndex);
                scroll1.refresh();
            }
        }
        var content = $(e.target).next();
        if (content.length > 0) {
            fileScrollToElement(content.index(), false);
            content.focus();
        }
        break;
    case KeyEvent.DOM_VK_RETURN:
        if (curBrowserType == BrowserType.Dlna && fileObj.isRootNode) {
            var itemInfo = fileObj.infoList[$(e.target).index()];
            if (itemInfo.statusType && itemInfo.statusType == DMS_STATUS_TYPE.OfflineWakable) {
                // TODO wakeup
                console.log("do wake up");
                dlnaObj.dlnaDmpWakeupDms(itemInfo.DEV_ID);
                return;
            }
        }
    case KeyEvent.DOM_VK_RIGHT:
        file_key_dispatch_dom_vk_return(e.target.id);
        break;
    case KeyEvent.DOM_VK_PLAY:
        var index = $('#' + e.target.id).index();
        var itemInfo = fileObj.infoList[index];
        var meidaType;
        if (curBrowserType == BrowserType.Usb) {
            meidaType = itemInfo.MEDIA_TYPE;
        } else {
            meidaType = itemInfo.mediaInfo.mediaType;
        }
        if (meidaType == 1 || meidaType == 2 || meidaType == 3) {
            file_key_dispatch_dom_vk_return(e.target.id, true);
        } else if (musicPlayObj.curDisplayMode != musicDisplayMode.none) {
            musicPlayObj.music_player_key_dispatch(isup, e);
            return;
        }
        break;
    }
	if((keynum == KeyEvent.DOM_VK_LEFT) || (keynum == KeyEvent.DOM_VK_UP) || (keynum == KeyEvent.DOM_VK_DOWN) || (keynum == KeyEvent.DOM_VK_RIGHT)) // Randy.xiao add for CUL event id 8
	{
		if (curBrowserType == BrowserType.Usb) 
		{ 
			mtvObj.acfgSetConfigString("g_content_browser","USB"); // Randy.xiao add for CUL event id 8
		}
		else
		{
			mtvObj.acfgSetConfigString("g_content_browser","DLNA"); // Randy.xiao add for CUL event id 8
		}
	}
}
function dmsWakeupBtnClick(position) {
    if (position == 1) {
        dmsWakeupDialog.close().remove();
        dmsWakeupDialog = null ;
        dlnaObj.dlnaDmpWakeupDms(fileObj.infoList[fileObj.focusIndex].DEV_ID);
    } else {
        dmsWakeupDialog.close().remove();
        dmsWakeupDialog = null ;
    }
}
function file_music_list_focus(isFocus, id) {
    if (isFocus) {
        var index = $("#" + id).index();
        if (curBrowserType == BrowserType.Dlna){              //mark0307
            opera_omi.sendPlatformMessage("watchdog disable"); //mark0307

        }         //mark0307
        $('#' + id).addClass('focus');
        if (cur_focus_id == id) {
            return;
        }
        cur_focus_id = id;
        waitLoading(true);
        setTimeout(function() {
            if (curBrowserType == BrowserType.Usb) {
                if (usbMountList.length > 1) {
                    usbColorKeyData[2].name = "USB Device";
                } else {
                    usbColorKeyData[2].name = "";
                }
                if (fileObj.infoList[fileObj.focusIndex].MEDIA_TYPE == MEDIA_TYPE.photoObj || $('#photo_album_container').is(":visible")) {
                    usbColorKeyData[1].name = "Sort";
                } else {
                    usbColorKeyData[1].name = "";
                }
            }
            initColorKeyBar((curBrowserType == BrowserType.Usb) ? usbColorKeyData : dlnaColorKeyData);
        }, 300);
        fileObj.childNode.clearInfo();
        clearPvTag();
        clearFocusTimeoutResult();
        fileObj.focusIndex = index;
        if (curBrowserType == BrowserType.Usb && MEDIA_TYPE.videoObj == fileObj.infoList[index].MEDIA_TYPE) {//do nothing
        } else {
            switch_file_layout();
        }
        var timeout = 800;
        if (curBrowserType == BrowserType.Dlna && fileObj.isRootNode) {
            timeout = 1500;
        }
        focusTimeoutResult = setTimeout("show_thumbnail_info(" + index + ")", timeout);
    } else {
        $('#' + id).removeClass('focus');
        stopMarqueeScroll();
    }
}
function clearFocusTimeoutResult(isReset) {
    if (focusTimeoutResult) {
        clearTimeout(focusTimeoutResult);
        focusTimeoutResult = null ;
    }
    if (getShowThumbnail_t) {
        clearTimeout(getShowThumbnail_t);
        getShowThumbnail_t = null ;
    }
}
function handleFileCommonKey(e) {
    console.log("handleFileCommonKey");
    if (dmsWakeupDialog) {
        dms_wakeup_key_dispatch(true, event);
        return;
    }
    var keynum = e.which || e.keyCode;
    switch (keynum) {
    case KeyEvent.DOM_VK_BACK:
        if (isDialogShow()) {
            closeDialog();
            change_current_path();
            return;
        }
        handleBackKey();
        break;
    case KeyEvent.DOM_VK_INFO:
        handleInfoAndRedKey(true);
        break;
    case KeyEvent.DOM_VK_RED:
        handleInfoAndRedKey(false);
        break;
    case KeyEvent.DOM_VK_GREEN:
        handleGreenKey();
        //sort
        break;
    case KeyEvent.DOM_VK_YELLOW:
        var text = getColorKeyItemTxt($('#footer').find('li')[2]);
        if (text) {
            getUsbList();
        }
        break;
    /*case KeyEvent.DOM_VK_BLUE:
        goToHelpPage();
        break;*/
    case KeyEvent.DOM_VK_OPTION:
        var text = getColorKeyItemTxt($('#footer').find('li')[5]);
        if (isDialogShowById('option_dialog')) {
            closeDialog();
            change_current_path();
            return;
        }
        closeDialog();
        var data = FOLDER_OPTION_DATA;
        var opttionArray = FOLDER_OPTION_DATA.value;
        if (curBrowserType == BrowserType.Dlna) {
            if (fileObj.isRootNode) {
                if (opttionArray.length < 6) {
                    opttionArray.push(CLEAR_OFF_DMS);
                }
            } else {
                if (opttionArray.length >= 6) {
                    opttionArray.splice(5, 1);
                }
            }
        } else {
            if (usbMountList.length <= 0)
                return;
            if ((fileObj.curMediaInfo && (fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.rootObj && fileObj.focusIndex == 1)) || isShowVideolist()) {
                data = MOVIE_OPTION_DATA;
            } else if (fileObj.curMediaInfo && ((fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.rootObj && fileObj.focusIndex == 2) || fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.photoObj || fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.photoList || $('#photo_album_container').is(":visible"))) {
                if (musicPlayObj.isPlaying()) {
                    data = PHOTO_MUSIC_OPTION_DATA;
                } else {
                    data = PHOTO_OPTION_DATA;
                }
            } else if (fileObj.infoList[fileObj.focusIndex].MEDIA_TYPE == MEDIA_TYPE.musicObj || fileObj.infoList[fileObj.focusIndex].MEDIA_TYPE == MEDIA_TYPE.musicList || fileObj.infoList[fileObj.focusIndex].MEDIA_TYPE == MEDIA_TYPE.musicArtist || fileObj.infoList[fileObj.focusIndex].MEDIA_TYPE == MEDIA_TYPE.musicAlbum || fileObj.infoList[fileObj.focusIndex].MEDIA_TYPE == MEDIA_TYPE.musicGenre || fileObj.infoList[fileObj.focusIndex].MEDIA_TYPE == MEDIA_TYPE.musicTrack || isShowMusiclist()) {
                data = MUSIC_OPTION_DATA;
            }
        }
        //showOptionDialog("Folder", folderOptionNotify, opttionArray);
        var arg = $.extend({}, {
            data: data,
            callback: folderOptionNotify
        });
        showOptionDialog(arg);
        break;
    case KeyEvent.DOM_VK_STOP:
    case KeyEvent.DOM_VK_PAUSE:
    case KeyEvent.DOM_VK_FAST_FWD:
    case KeyEvent.DOM_VK_REWIND:
        if (musicPlayObj.curDisplayMode != musicDisplayMode.none) {
            musicPlayObj.handleMusicPlayerKey(event);
        }
        break;
    case KeyEvent.DOM_VK_LIST:
        if (musicPlayObj.isPlaying())
            musicPlayObj.switchDisMusicplayerMode(musicDisplayMode.simplePlay);
        break;
    }
}
function folderOptionNotify(itemObj) {
    if (itemObj === PhotoShowMode) {
        var temp = SHOW_MODE[itemObj.value[itemObj.curValue]];
        if (photoObj.showMode == temp) {
            closeOptionDialog();
            return
        }
        photoObj.setShowMode(temp);
        closeOptionDialog();
        submenu_selected_id = -1;
        cur_focus_id = -1;
        clearFocusTimeoutResult();
        if (fileObj.curMediaInfo && fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.photoList) {
            change_current_path(false);
        } else {
            doRefreshLayout();
        }
        return;
    } else if (itemObj === VideoShowMode) {
        var temp = SHOW_MODE[itemObj.value[itemObj.curValue]];
        if (videoObj.showMode == temp) {
            closeOptionDialog();
            return
        }
        videoObj.setShowMode(temp);
        closeOptionDialog();
        if (SHOW_MODE.Thumbnails == temp) {
            curObjectType = null ;
        }
        cur_focus_id = -1;
        clearFocusTimeoutResult();
        if (fileObj.curMediaInfo && fileObj.curMediaInfo.MEDIA_TYPE == MEDIA_TYPE.videoObj) {
            change_current_path(false);
        } else {
            doRefreshLayout();
        }
        return;
    } else if (itemObj.value[itemObj.curValue] == CLEAR_OFF_DMS) {
        dlnaObj.dlnaDmpClearOffDms(0);
        scanMediaServer();
        closeOptionDialog();
    }
    if (itemObj.value[itemObj.curValue] == STOP_MUSIC) {
        musicPlayObj.stopMusic(true);
    }
    baseOptionNotify(itemObj);
}
function getUsbList() {
    console.log("DOM_VK_YELLOW");
    var text = getColorKeyItemTxt($('#footer').find('li')[2]);
    var focusIdx = 0;
    if (isDialogShowById('colorkey_dialog_2')) {
        closeDialog();
        change_current_path();
        return;
    } else if (text == '') {
        return;
    }
    closeDialog();
    var listContent = "";
    if (curBrowserType == BrowserType.Usb) {
        for (var i in noPvrUsbMountList) {
            var showUsbName;
            if (noPvrUsbMountList[i].LABEL) {
                showUsbName = noPvrUsbMountList[i].LABEL;
            } else {
                showUsbName = noPvrUsbMountList[i].DEV;
            }
            if (curUsbPathInfo && noPvrUsbMountList[i].PATH == curUsbPathInfo.PATH) {
                focusIdx = i;
            }
            var id = "color_bar_list_" + i;
            listContent += '<li tabindex="1" id="' + id + '" onfocus="color_bar_item_focus(true,\'' + id + '\');" onblur="color_bar_item_focus(false,\'' + id + '\');" data-key-enter="switchMediaServer(\'' + noPvrUsbMountList[i].PATH + '\');" class=\'color_key_list_li\'><div><div><span>' + showUsbName + '</span></div></div></li>';
        }
        showColorKeyDialog(2, 'USB Device', listContent, usbMountList.length, focusIdx);
    } else {
        for (var i in mediaServerList) {
            var id = "color_bar_list_" + i;
            listContent += '<li tabindex="1" id="' + id + '" onfocus="color_bar_item_focus(true,\'' + id + '\');" onblur="color_bar_item_focus(false,\'' + id + '\');" data-key-enter="switchMediaServer(\'' + mediaServerList[i].DEV_ID + '\');" class=\'color_key_list_li\'><div><div><span>' + mediaServerList[i].SERVER_NAME + '</span></div></div></li>';
            if (mediaServerList[i].DEV_ID == curMediaServer.DEV_ID) {
                focusIdx = i;
            }
        }
        showColorKeyDialog(2, 'Media Server', listContent, mediaServerList.length, focusIdx);
    }
}
function switchMediaServer(switchDevId) {
    console.log("switchMediaServer switchDevId = " + switchDevId);
    if (curBrowserType == BrowserType.Usb) {
        for (var idx = 0 in noPvrUsbMountList) {
            if (noPvrUsbMountList[idx].PATH == switchDevId) {
                if (!fileObj.isRootNode) {
                    initFile();
                }
                doFocus('file_folder_ul' + idx);
                return;
            }
        }
    } else {
        for (idx in mediaServerList) {
            if (mediaServerList[idx].DEV_ID == switchDevId && mediaServerList[idx].DEV_ID != curMediaServer.DEV_ID) {
                curMediaServer = mediaServerList[idx];
                initFile();
                return;
            }
        }
    }
}
function fileBackKeyHandle() {
    if (!fileObj.curMediaInfo && (curBrowserType == BrowserType.Usb)) {//reset_top_menu_focus();
    } else if (fileObj.focusIndex >= 0) {
        change_current_path(false);
    }
}
function fileScrollToElement(scrollIndex, isUp) {
    //do scroll
    if (scrollIndex != undefined && !isNaN(scrollIndex)) {
        scrollIndex = parseInt(scrollIndex);
        var ret;
        if (isUp) {
            // up key
            ret = scrollStep(document.querySelector('#file_folder_ul li:nth-child(' + (Number(scrollIndex)) + ')'), scroll1, (scrollIndex && fileObj.infoList.length > 10) ? true : false);
        } else {
            // down key
            var index = Number(scrollIndex) + 2;
            if ($('#file_folder_ul li').length < index) {
                index--;
            }
            ret = scrollStep(document.querySelector('#file_folder_ul li:nth-child(' + index + ')'), scroll1);
        }
        var layout = $('#file_list_one_layout');
        var target = $("#file_folder_ul");
        if (layout.offset().top > target.offset().top) {
            $('#list_nav_prev').show();
        } else {
            $('#list_nav_prev').hide();
        }
        if (layout.offset().top + layout[0].clientHeight < target.offset().top + target[0].clientHeight) {
            $('#list_nav_next').show();
        } else {
            $('#list_nav_next').hide();
        }
    }
}
function addMusicPlayingStyle(path) {
    removeMusicPlayingStyle();
    console.log("addMusicPlayingStyle path = " + path);
    $("#file_folder_ul [filePath='" + path + "']").addClass("selected");
}
function getMusicItemIndex(path) {
    return $("#file_folder_ul [filePath='" + path + "']").index();
}
function removeMusicPlayingStyle() {
    $("#file_folder_ul li.selected").removeClass("selected");
}
