/**/
var translateBeforewords = {
                            "Restore style":"ID_STYLE_RESTORE",
                            "Help":"RC_FORMAT_HELP",                            
                            "Option":"OPTS",
                            "Info": "RC_OPT_INFO",
                            "Status":"ID_WIRE_STATUS",
                            "Settings":"SETTINGS",
                            "Yes":"USB_HID_BTN2",
                            "No":"USB_HID_BTN1",
                            "ResetPictureMsg":"MSG_PIC_RESTORE",
                            "ClearResidualImageInfo":"MAIN_DI_CLEAR_IMAGE_RESIDUAL_INFO"
 };

var translateAfterwords = {};

function getKeyWords(originalName){
    if(originalName == ""){
        return undefined;
    }
    if(translateBeforewords.hasOwnProperty(originalName)){
        return translateBeforewords[originalName];
    } else {
       return originalName;
    }

}

function getTranslate(originalName){
    var KeyWord = getKeyWords(originalName);
    if (KeyWord == undefined ){
        return originalName;
    }
    if(!translateAfterwords.hasOwnProperty(KeyWord)){
        var transText = mtvObj.getLangString(KeyWord);
        if(transText){
            translateAfterwords[KeyWord] = mtvObj.getLangString(KeyWord);
        } else {
            return originalName;
        }
    }
    return translateAfterwords[KeyWord];
}

function updateUIString(langDict) {

  for ( var p in translateBeforewords ){
      if ( typeof ( translateBeforewords[ p ]) == " function " ){

      } else {
                var result = getKeyWords(p);
                if(result != undefined){
                    if (langDict.hasOwnProperty(result))
                        translateAfterwords[result] = langDict[result];
                }
        }
    }
};

var languageChangeNotifyCallback = null;
function languageChangeNotify(jsonStr){
    var configNotify = JSON.parse(jsonStr);
    for(index in configNotify.ITEMS){
        configItem = configNotify.ITEMS[index];
        if(configItem.ID == -1){
            if(configItem.ARG2 == 'g_gui_lang__gui_language'){
                if(languageChangeNotifyCallback){
                    translateAfterwords = {};
                    languageChangeNotifyCallback();
                } else {
                    location.reload();
                }
            } else if(configItem.ARG2 == 'g_misc__dvb_subtitle_enabled'){
                if(videoPlayObj){
                    videoPlayObj.setSubtitleShowHide();
                }
            }

        }
    }
}

function translate_String(){
    try{
        var lang = mtvObj.getUILang();
        if(!lang){
            lang = "ENG";
        }
        console.log("lang = " + lang);
        src = "../i18n/" + lang + "/MMP.js";
        loadLangRes(src, updateUIString);
        src = "../i18n/" + lang + "/PHM.js";
        loadLangRes(src, updateUIString);
        src = "../i18n/" + lang + "/PPG.js";
        loadLangRes(src, updateUIString);
        src = "../i18n/" + lang + "/NAV.js";
        loadLangRes(src, updateUIString);
    }catch(error){
        console.log(error);
    }
}

(function(){
    window.dmrUtil.configUpdateNotifyCallback = languageChangeNotify;
    //translate_String();
})();