/* Data struchture hint

var Data = {
    "name": Data name.
    "translate": Data translation.
    "nodeType": Data node type
    "showMode": Data displaye type.	//0 = showl, 1 = hide
    "focusIndex": List last focus index or Data current value.
    "item": Child data. (item, range, action only used one of them)
    "range": Slider data. (item, range, action only used one of them)
    "action": Action data (item, range, action only used one of them)
    "acfgKey": Data identify key. (function call used)
    "setMode": Data setup mode.	//0 = ok key will setup, 1 = up, down and ok key will setup, 
                                                 //2 = up, down key will setup temporary and left, back key will return original value if not used ok key to setup.
};

*/


var mtvObj = new MtvObj();

/* This path for pictrue settings hintimg */
var brandPath = mtvuiUtil.getBrandUrl()+"2K16_4K_UX_Asset/All_Settings/hint/"; 

/*
	showMode: decide the node display status. 
*/
var showMode = {hide: 0, normal: 1, disabled: 2};

/*
	nodeType: also need to add "item" or "range" or "action" attribute to function link.
	list : leaf node is list type
	range : slider or progressbar type
	action : need to display dialog or go to page or set a function
*/
var nodeType = {list: 0, range: 1, action: 2}; 

/* 
	actionType: need to set actionType in attribute when nodeType is action.
	dialog : call dialog to display
	page : go to page
	func : call api to set
*/
var actionType = {dialog: 0, page: 1, func: 2};


/*
*
*
*     picture list node 
*
*
*/
var Tint = {
	"name" : "Tint",
	"translate" : "ID_TINT_L124",
	"type": nodeType.range,
	"range": {"current":0, "min":-50, "max":50},	
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_hue",
	"setMode":2,
	"hinttext":"MAIN_CH_TINT_HUE",
	"hintimg_upper":"",
	"hintimg_lower":"",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Tint:NA",
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"hintimg":""	
}

var ColourEnhancement = {
	"name" : "Colour Enhancement",
	"translate" : "ID_ENHAN_L12C",				/* From phm_tree.h*/
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_sce",
	"setMode":2,
	"hinttext":"MAIN_CH_COLOUR_ENHANCEMENT",		/* From phm_tree.c*/
	"hintimg_upper":"OFF",					/* From phm_navi.c*/
	"hintimg_lower":"ID_MAX",
	"hintimg":brandPath+"hint_images_pq_colour_enhancement.png",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Colour_enhancement:NA",
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],	
	"item" : [["Off","NM_0"],["Minimum","NM_1"],["Medium","NM_2"],["Maximum","NM_3"]]
}

var ColourGamut = {
	"name" : "Colour Gamut",
	"translate" : "MAIN_COLOUR_GAMUT",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_clr_gamut",
	"setMode":2,
	"hinttext":"MAIN_CH_COLOUR_GAMUT",
	"hintimg_upper":"", 
	"hintimg_lower":"",
	"hintimg":"",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Colour_gamut:NA",
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],	
	"item" : [["Normal","MAIN_COLOUR_GAMUT_NORMAL"],["Wide","MAIN_WIDE"]]
}


var ColourTemperature = {
	"name" : "Colour Temperature",
	"translate" : "ID_COLOR_TEMP",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_clr_temp",
	"setMode":2,
	"hinttext":"MAIN_CH_COLOUR_TEMPERATURE",
	"hintimg_upper":"COLOR_TEMP_3", 
	"hintimg_lower":"COLOR_TEMP_2",
	"hintimg":brandPath+"hint_images_pq_color_temperature.png",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Colour_temperature:NA",
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],	
	"item" : [["Normal","COLOR_TEMP_1"],["Warm","COLOR_TEMP_2"],["Cool","COLOR_TEMP_3"],["Custom","COLOR_TEMP_4"]]
}

var CustomColourTemperature = {
	"name" : "Custom Colour Temperature",
	"translate" : "ID_CUSTOM_TINT",
	"type": nodeType.range,
	"range": {"current":50, "min":0, "max":100},	
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"",
	"setMode":2,
	"hinttext":"MAIN_CH_CUSTOM_COLOUR_TEMPERATURE",
	"hintimg_upper":"",
	"hintimg_lower":"",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Custom_colour_temperature:NA",
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"hintimg":""/* customcolour has no img */
	
}

var ContrastMode = {
	"name" : "Contrast Mode",
	"translate" : "ID_DYNA_BACKL",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_dbl",
	"setMode":2,
	"hinttext":"MAIN_CH_CONTRAST_MODE",
	"hintimg_upper":"MAIN_NORMAL",
	"hintimg_lower":"MAIN_OPTMIZED_FOR_PICTURE",
	"hintimg":brandPath+"hint_images_pq_contrast_mode.png",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Contrast_modes:NA",
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"item" : [["Off","MAIN_OFF_CONTRAST"],["Normal","MAIN_NORMAL"],["Optimized for picture","MAIN_OPTMIZED_FOR_PICTURE"],["Optimized for energy savings","MAIN_OPTMIZED_FOR_ENERGY_SAVING"]]
}

var HDRPlus = {
	"name" : "HDR Plus",
	"translate" : "MAIN_HDR_PLUS",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_hdr",
	"setMode":2,
	"hinttext":"MAIN_CH_HDR_PLUS",
	"hintimg_upper":"",
	"hintimg_lower":"",
	"hintimg":"", /* no img */
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:HDR_Plus:NA",
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"item" : [["Off","NM_0"],["Minimum","NM_1"],["Medium","NM_2"],["Maximum","NM_3"]]
}

var DynamicContrast = {
	"name" : "Dynamic Contrast",
	"translate" : "ID_DYNAM_L128",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_dyn_cnt",
	"setMode":2,
	"hinttext":"MAIN_CH_DYNAMIC_CONTRAST",
	"hintimg_upper":"OFF",
	"hintimg_lower":"ID_MAX",
	"hintimg":brandPath+"hint_images_pq_dynamic_contrast.png",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Dynamic_contrast:NA",	
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"item" : [["Off","NM_0"],["Minimum","NM_1"],["Medium","NM_2"],["Maximum","NM_3"]]
}
var VideoContrast = {
	"name" : "Video Contrast",
	"translate" : "ID_CONTR_L121",
	"type": nodeType.range,
	"range": {"current":50, "min":0, "max":100},	
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_cnt",
	"setMode":2,
	"hinttext":"MAIN_CH_VIDEO_CONTRAST",
	"hintimg_upper":"ID_MAX",
	"hintimg_lower":"ID_MIN",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Video_contrast:NA",		
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"hintimg":brandPath+"hint_images_pq_video_contrast.png",
	
}
var LightSensor = {
	"name" : "Light Sensor",
	"translate" : "ID_LIGHT_SNR",
	"type": nodeType.action,
	"actionType": actionType.func,
	"action":"g_video__pq_setting_light_sensor",
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_light_sensor",
	"setMode":2,
	"hinttext":"MAIN_CH_LIGHT_SENSOR",
	"hintimg_upper":"ID_ESTICKER_OFF",
	"hintimg_lower":"ID_ESTICKER_ON",
	"hintimg":brandPath+"hint_images_pq_lightsensor.png",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Light_sensor:NA",				
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"item" : ""
}

var Gamma = {
	"name" : "Gamma",
	"translate" : "ID_DISP_GAMMA",
	"type": nodeType.range,
	"range": {"current":2, "min":0, "max":4},	
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_disp_gamma",
	"setMode":2,
	"hinttext":"MAIN_CH_GAMMA",
	"hintimg_upper":"ID_MIN",
	"hintimg_lower":"ID_MAX",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Gamma:NA",			
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"hintimg":brandPath+"hint_images_pq_gamma.png",
}
var UltraResolution = {
	"name" : "Ultra Resolution",
	"translate" : "ID_ADV_SHARP_ULTRA",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_lti",
	"setMode":2,
	"hinttext":"MAIN_CH_ULTRA_RESOLUTION",
	"hintimg_upper":"ID_ESTICKER_OFF",
	"hintimg_lower":"ID_ESTICKER_ON",
	"hintimg":brandPath+"hint_images_pq_super_resolution.png",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Ultra_resolution:NA",				
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"item" : [["Off","OFF"],["On","ON"]]
}
var NoiseReduction = {
	"name" : "Noise Reduction",
	"translate" : "ID_DNR_L12A",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_dnr",
	"setMode":2,
	"hinttext":"MAIN_CH_NOISE_REDUCTION",
	"hintimg_upper":"OFF",
	"hintimg_lower":"ID_MAX",
	"hintimg":brandPath+"hint_images_pq_noise_reduction.png",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Noise_reduction:NA",					
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"item" : [["Off","NM_0"],["Minimum","NM_1"],["Medium","NM_2"],["Maximum","NM_3"]]
}

var MPEGArtefactReduction = {
	"name" : "MPEG Artefact Reduction",
	"translate" : "ID_MPEGA_L12B",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_deblocking",
	"setMode":2,
	"hinttext":"MAIN_CH_MPEG_ARTEFACT_REDUCTION",
	"hintimg_upper":"OFF",
	"hintimg_lower":"ID_MAX",
	"hintimg":brandPath+"hint_images_pq_mpeg_artefact_reduction.png",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:MPEG_artefact_reduction:NA",						
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"item" : [["Off","NM_0"],["Minimum","NM_1"],["Medium","NM_2"],["Maximum","NM_3"]]
}
var MotionStyles = {
	"name" : "Motion Styles",
	"translate" : "MAIN_MOTION_STYLE",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_motion_style",
	"setMode":2,
	"hinttext":"MAIN_CH_MOTION_STYLES",
	"hintimg_upper":"",
	"hintimg_lower":"",
	"hintimg":"", /* no img */
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Motion_style:NA",
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],
	"item" : [["Off","MAIN_OFF"],["Movie","MAIN_MOVIE"],["Sports","MAIN_SPORTS"],["Standard","MAIN_STANDARD"],["Smooth","MAIN_SMOOTH"],["Personal","MAIN_PERSONAL"]]
}
var NaturalMotion = {
	"name" : "Natural Motion",
	"translate" : "ID_MOTIO_L129",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_mjc",
	"setMode":2,
	"hinttext":"MAIN_CH_DIGITAL_NATURAL_MOTION",
	"hintimg_upper":"OFF",
	"hintimg_lower":"ID_MAX",
	"hintimg":brandPath+"hint_images_pq_hd_natural_motion.png",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Natural_Motion:NA",	
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],		
	"item" : [["Off","NM_0"],["Minimum","NM_1"],["Medium","NM_2"],["Maximum","NM_3"]]
}

var PerfectClearMotion = {
	"name" : "Perfect Clear Motion",
	"translate" : "MISC_PERFECT_CLEAR_MOTION",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_clear_motion",
	"setMode":2,
	"hinttext":"MAIN_CH_PERFECT_CLEAR_MOTION",
	"hintimg_upper":"",
	"hintimg_lower":"",
	"hintimg":"",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Perfect_Clear_Motion:NA",	
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],		
	"item" : [["Off","NM_0"],["Minimum","NM_1"],["Medium","NM_2"],["Maximum","NM_3"]]
}

var ClearResidualImage ={
	"name" : "Clear Residual Image",
	"translate" : "MAIN_CLEAR_IMAGE_RESIDUAL",
	"type": nodeType.action,
	"actionType": actionType.dialog,
	"action": "",
	"showMode": showMode.hide,
	"focusIndex":0,
	"acfgKey":"",
	"setMode":2,
	"hinttext":"MAIN_CH_CLEAR_IMAGE_RESIDUAL",
	"hintimg_upper":"",
	"hintimg_lower":"",
	"hintimg":"",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Clear_residual_image:NA",				
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],		
	"item" : ""
}


var PictureStyle = {
	"name" : "Picture Style",
	"translate" : "ID_SMART_PIC",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_misc__cust_picture_style",
	"setMode":2,
	"hinttext":"MAIN_CH_PICTURE_STYLE",
	"hintimg_upper":"SMART_PIC_4",
	"hintimg_lower":"SMART_PIC_2",
	"hintimg":brandPath+"hint_images_pq_picture_style.png",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Picture_Style:NA:NA",		
	"colorkey":[{"show":true,"name":"Restore style"},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],	
	"item" : [["Personal","MAIN_PIC_PERSONAL"], ["Vivid","MAIN_PIC_VIVID"], ["Natural","MAIN_PIC_NATURAL"], ["Standard","MAIN_PIC_STANDARD"], ["Movie","MAIN_PIC_MOVIE"], ["Game","MAIN_PIC_GAME"]] 
};

var Colour = {
	"name" : "Colour",
	"translate" : "ID_COLOR_CLR",
	"type": nodeType.range,
	"range": {"current":50, "min":0, "max":100},
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_sat",
	"setMode":2,
	"hinttext":"MAIN_CH_COLOUR",
	"hintimg_upper":"ID_MIN",
	"hintimg_lower":"ID_MAX",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Colour:NA:NA",			
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],		
	"hintimg":brandPath+"hint_images_pq_colour.png"
	
}

var Contrast = {
	"name" : "Contrast",
	"translate" : "ID_BLK_CONTR",
	"type": nodeType.range,
	"range": {"current":50, "min":0, "max":100},	
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_disp_back_light",
	"setMode":2,
	"hinttext":"MAIN_CH_CONTRAST",
	"hintimg_upper":"ID_MIN",
	"hintimg_lower":"ID_MAX",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Contrast:NA:NA",	
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],		
	"hintimg":brandPath+"hint_images_pq_contrast.png",
	
}

var Sharpness = {
	"name" : "Sharpness",
	"translate" : "ID_SHARP_L125",
	"type": nodeType.range,
	"range": {"current":50, "min":0, "max":100},	
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_shp",
	"setMode":2,
	"hinttext":"MAIN_CH_SHARPNESS",
	"hintimg_upper":"ID_MIN",
	"hintimg_lower":"ID_MAX",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Sharpness:NA:NA",		
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],		
	"hintimg":brandPath+"hint_images_pq_sharpness.png",
	
}


var Brightness = {
	"name" : "Brightness",
	"translate" : "ID_BRIGH_L122",
	"type": nodeType.range,
	"range": {"current":50, "min":0, "max":100},	
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"g_video__pq_setting_bri",
	"setMode":0,
	"hinttext":"MAIN_CH_BRIGHTNESS",
	"hintimg_upper":"ID_MIN",
	"hintimg_lower":"ID_MAX",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Brightness:NA",			
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],		
	"hintimg":brandPath+"hint_images_pq_brightness.png",
	
}

var ExpertMode = {
	"name" : "Expert Mode",
	"translate" : "MAIN_EXPERT_MODE_SETTINGS",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"",
	"setMode":0,
	"hinttext":"MAIN_CH_ADVANCED_PICTURE",
	"hintimg_upper":"",
	"hintimg_lower":"",
	"hintimg":"",/* no img */
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Expert_mode_settings:NA:NA",				
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],		
	"item" : []
}

var PictureFormat ={
	"name" : "Picture Format",
	"translate" : "ID_FORMA_L12E",
	"type": nodeType.action,
	"actionType": actionType.page,
	"action": "sys_picture_format",
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"",
	"setMode":2,
	"hinttext":"MAIN_CH_PICTURE_FORMAT",
	"hintimg_upper":"",
	"hintimg_lower":"",
	"hintimg":"",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Picture_Format:NA:NA",				
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],		
	"item" : ""
}

var QuickPictureSetting ={
	"name" : "Quick Picture Setting",
	"translate" : "MAIN_QUICK_PICTURE_SETTINGS",
	"type": nodeType.action,
	"actionType": actionType.page,
	"action": "sys_qucick_picture",
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"",
	"setMode":2,
	"hinttext":"MAIN_CH_QUICK_PICTURE_SETTINGS",
	"hintimg_upper":"",
	"hintimg_lower":"",
	"hintimg":"",
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Quick_picture_settings:NA:NA",				
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],		
	"item" : ""
}


var Picture = {
	"name" : "Picture",
	"translate" : "ID_PICTU_L13",
	"type": nodeType.list,
	"showMode": showMode.normal,
	"focusIndex":0,
	"acfgKey":"",
	"setMode":0,
	"hinttext":"MAIN_CH_PICTURE",
	"hintimg_upper":"",
	"hintimg_lower":"",
	"hintimg":"",/* no img */
	"helpurl":"/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:NA:NA:NA",			
	"colorkey":[{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":""},{"show":true,"name":"Help"},{"show":false,"name":"Option"},{"show":false,"name":"Info"}],		
	"item" : [] 
}

var Picture_List 	 = [Object.assign({}, PictureStyle),
						Object.assign({}, Colour),
						Object.assign({}, Contrast),
						Object.assign({}, Sharpness),
						Object.assign({}, Brightness),						
						Object.assign({}, ExpertMode),
						Object.assign({}, PictureFormat),
						Object.assign({}, QuickPictureSetting)];
/*
var Expert_Mode_List = [Object.assign({}, Tint),
	 					Object.assign({}, ColourEnhancement),
	 					Object.assign({}, ColourGamut),
	 					Object.assign({}, ColourTemperature),
	 					Object.assign({}, CustomColourTemperature),
	 					Object.assign({}, ContrastMode),
						Object.assign({}, HDRPlus),
						Object.assign({}, DynamicContrast),
						Object.assign({}, VideoContrast),
						Object.assign({}, LightSensor),
						Object.assign({}, Gamma),
						Object.assign({}, UltraResolution),
						Object.assign({}, NoiseReduction),
						Object.assign({}, MPEGArtefactReduction),
						Object.assign({}, MotionStyles),
						Object.assign({}, NaturalMotion),
						Object.assign({}, PerfectClearMotion)];
*/

var display_mode = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_OPT_DISPLAY_RES_TYPE);
var motion_mode  = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_OPT_NATURAL_MOTION_TYPE);	
var detect_HDR 	 = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_DETECT_HDR);
var region 		 = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_OPT_REGION_TYPE);	
var color_gamut_type = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_OPT_COLOR_GAMUT_TYPE);	 
var light_sensor_status = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_OPT_LIGHT_SENSOR_STATUS);	 
var set_hz		= mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_OPT_HW_SET_HZ);	 
var panel_type  = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_OPT_PANEL_TYPE);
var hdr_type    = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_OPT_HDR_OPTION_TYPE);
var light_sensor_value = mtvObj.acfgGetConfigValue(LightSensor.acfgKey); 
var energy_saving = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_ENERGY_SAVING);


function Picture_list_init()
{
	/* Init list show/hide status according option code to control */

	/* change node attributes */	
	if (PLF_OPT_REGION_TYPE.PLF_OPT_REGION_LATAM == region)
	{
		Colour.name = "Color";
		Colour.translate = "ID_COLOR_L123_LT";
		ColourEnhancement.name = "Color Enhancement";
		ColourEnhancement.translate = "ID_ENHAN_L12C_LT";
		ColourTemperature.name = "Color Temperature";
		ColourTemperature.translate = "ID_TEMPE_L126_LT";
		CustomColourTemperature.name = "Custom Color Temperature";
		CustomColourTemperature.translate = "ID_CUSTOM_TINT_LT";
		MPEGArtefactReduction.name = "MPEG Artifact Reduction";
		MPEGArtefactReduction.translate = "ID_MPEGA_L12B_LT";
	}
	
	if ( (PLF_OPT_DISPLAY_RES_TYPE.PLF_OPT_HD == display_mode) ||
		 (PLF_OPT_DISPLAY_RES_TYPE.PLF_OPT_FHD == display_mode))
	{		
		UltraResolution.name = "Super Resolution";
		UltraResolution.translate = "ID_ADV_SHARP_DC";
		UltraResolution.hinttext = "MAIN_CH_SUPER_RESOLUTION";
		UltraResolution.helpurl = "/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Super_resolution:NA";
	}

	if (PLF_OPT_NATURAL_MOTION_TYPE.PERFECT_NATURAL_MOTION == motion_mode)
	{
		NaturalMotion.name = "Perfect Natural Motion";
		NaturalMotion.translate = "MISC_PERFECT_NATURAL_MOTION";
		NaturalMotion.hinttext = "MAIN_CH_PERFECT_CLEAR_MOTION";
		NaturalMotion.helpurl = "/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:Perfect_Clear_Motion:NA";
	}
	
	if (PLF_OPT_PANEL_TYPE.PLF_OPT_PANEL_TYPE_OLED == panel_type)
	{
		ContrastMode.item = [["Normal","MAIN_NORMAL"],["Optimized for picture","MAIN_OPTMIZED_FOR_PICTURE"],["Optimized for energy savings","MAIN_OPTMIZED_FOR_ENERGY_SAVING"]]
		ClearResidualImage.showMode = showMode.normal;
	}

	if (PLF_OPT_HDR_OPTION_TYPE.PLF_OPT_HDR_PERFECT == hdr_type)
	{
		HDRPlus.name = "HDR Perfect";
		HDRPlus.translate =	"MAIN_HDR_PREFECT";
		HDRPlus.hinttext =	"MAIN_CH_HDR_PERFECT";
		HDRPlus.helpurl = "/usr/opera/opera_dir/pages/edfu/index.html?book=Picture:Advanced:HDR_Perfect:NA";
	}

	if (PLF_OPT_HW_SET_HZ.PLF_OPT_100_120_HZ == set_hz)
	{
		PerfectClearMotion.showMode = showMode.normal;
	}
	else
	{
		PerfectClearMotion.showMode = showMode.hide;
	}

	if (PLF_OPT_NATURAL_MOTION_TYPE.OFF == motion_mode)
	{
		MotionStyles.showMode = showMode.hide;
		NaturalMotion.showMode = showMode.hide;
	}

	if ((PLF_OPT_COLOR_GAMUT_TYPE.PLF_OPT_COLOR_GAMUT_WCG_1 == color_gamut_type) ||
		(PLF_OPT_COLOR_GAMUT_TYPE.PLF_OPT_COLOR_GAMUT_WCG_2 == color_gamut_type)
		)
	{
		var b_bt2020_clr_space = mtvObj.acfgGetConfigValue(CFG_VIDEO_IS_BT2020_CLR_SPACE);
		if (b_bt2020_clr_space)
		{
			ColourGamut.showMode = showMode.hide;
		}
		else
		{
			ColourGamut.showMode = showMode.normal;
		}
	}
	else
	{
		ColourGamut.showMode = showMode.hide;
	}

	if (PLF_OPT_LIGHT_SENSOR_STATUS.PLF_OPT_LIGHT_SENSOR_ON == light_sensor_status)
	{
		LightSensor.showMode = showMode.normal;
	}
	else
	{
		LightSensor.showMode = showMode.hide;
	}
}

function UpdatePictureStyleList()
{
	var new_Item = [];
	var detect_HDR = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_DETECT_HDR);
	var b_CE_timing_to_PC_mode = mtvObj.acfgGetConfigValue(CFG_CUSTOM_VIDEO_CE_TIMING_TO_PC_MODE);
	var b_smart_pic_game_mode_enable = mtvObj.acfgGetConfigValue(CFG_CUSTOM_VIDEO_SMART_GAME_MODE_ENABLE);
	var PictureStyleMonitor = ["Monitor","MAIN_PIC_MONITOR_2K18"];
	var PictureStyleGame = ["Game","MAIN_PIC_GAME"];
	var PictureStyleHDRGame = ["HDR Game","MAIN_HDR_GAME"];
	var PictureStyleTemp;
	
	if(1 == detect_HDR) /* 20170807 modify for picture style lists are different from all settings when watching HDR content */
	{
		PictureStyleTemp = Object.assign({}, PictureStyle);
		if (PLF_OPT_REGION_TYPE.PLF_OPT_REGION_LATAM == region)
		{
			new_Item = [["HDR Personal","MAIN_HDR_PERSONAL_LT"], ["HDR Vivid","MAIN_HDR_VIVID_LT"], ["HDR Football","MAIN_HDR_FOOTBALL_LT"], ["HDR Movie","MAIN_HDR_MOVIE_LT"]];
		}
		else
		{
			new_Item = [["HDR Personal","MAIN_HDR_PERSONAL"], ["HDR Vivid","MAIN_HDR_VIVID"], ["HDR Natural","MAIN_HDR_NATURAL"], ["HDR Movie","MAIN_HDR_MOVIE"]];
		}
		
		if (b_smart_pic_game_mode_enable)
		{
			var find_game = false;
			for (var i = 0; i < new_Item.length; i++ )
			{
				if (new_Item[i] == PictureStyleHDRGame[0])
				{
					find_game = true;
				}
			}
			if (!find_game)
				new_Item.push(PictureStyleHDRGame);		
		}
		PictureStyleTemp.item = new_Item;
	}
	else
	{
		PictureStyleTemp = Object.assign({}, PictureStyle);
		if (PLF_OPT_REGION_TYPE.PLF_OPT_REGION_LATAM == region)
		{
			new_Item = [["Personal","MAIN_PIC_PERSONAL_2K18_LT"], ["Vivid","MAIN_PIC_VIVID_2K18_LT"], ["Football","MAIN_PIC_FOOTBALL_2K18_LT"], ["Standard","MAIN_PIC_STANDARD_2K18_LT"], ["Movie","MAIN_PIC_MOVIE_2K18_LT"]];
		}
		else
		{
			new_Item = [["Personal","MAIN_PIC_PERSONAL"], ["Vivid","MAIN_PIC_VIVID"], ["Natural","MAIN_PIC_NATURAL"], ["Standard","MAIN_PIC_STANDARD"], ["Movie","MAIN_PIC_MOVIE"]];
		}

		if (b_smart_pic_game_mode_enable)
		{
			var find_game = false;
			for (var i = 0; i < new_Item.length; i++ )
			{
				if (new_Item[i] == PictureStyleGame[0])
				{
					find_game = true;
				}
			}
			if (!find_game)
				new_Item.push(PictureStyleGame);
		
		}
		/*
		else 
		{	
			for (var i = 0; i < PictureStyleTemp.item.length; i++ )
			{

				if (PictureStyleTemp.item[i][0] == PictureStyleGame[0])
				{
					new_Item.splice(i, 1);
					break;
				}			
			}
		}
		*/

		if (b_CE_timing_to_PC_mode) /* 20170831 Louis.Chiang if CE timing but to be IT application , need add Monitor pciture mode */
		{
			var find_monitor = false;
			for (var i = 0; i < new_Item.length; i++ )
			{
				if (new_Item[i] == PictureStyleMonitor[0])
				{
					find_monitor = true;
				}
			}
			if (!find_monitor)
				new_Item.push(PictureStyleMonitor);
		}
		/*
		else 
		{	
			for (var i = 0; i < PictureStyleTemp.item.length; i++ )
			{

				if (PictureStyleTemp.item[i][0] == PictureStyleMonitor[0])
				{
					new_Item.splice(i, 1);
					break;
				}			
			}
		}
		*/
		PictureStyleTemp.item = new_Item;
	}

	return PictureStyleTemp;
}

function Hide_picture_all_list_in_PC_timing(list)
{
	for (var i = 0; i < list.length; i++)
	{
		if ((list[i].name == Contrast.name) ||
			(list[i].name == ExpertMode.name) ||
			(list[i].name == PictureFormat.name) ||
			(list[i].name == ColourTemperature.name) ||
			(list[i].name == CustomColourTemperature.name) ||
			(list[i].name == LightSensor.name) ||
			(list[i].name == Gamma.name) 			
			)
		{
			continue;
		}
		else if (list[i].name == PictureStyle.name)
		{
			if (mtvObj.acfgGetConfigValue(CFG_CUSTOM_VIDEO_CE_TIMING_TO_PC_MODE))
			{
				list[i].showMode = showMode.normal;
			}
			else
			{
				list[i].showMode = showMode.hide;
			}
			continue;
		}

		list[i].showMode = showMode.hide;
	}
}

function UpdatePictureList() /* refine tree node attribute when open menu  */
{

	var list = [];	
	
	var pf_valid = mtvObj.acfgGetConfigValue(CFG_VIDEO_PICTURE_FORMAT_IS_KEY_VALID);
	var pic_mode 	= mtvObj.acfgGetConfigValue(PictureStyle.acfgKey);
	var spec_mode 	 = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_SPECICIAL_MODE);
	var new_Item = [];		

	Picture_list_init();

	/* deep copy array of object to avoid to modify original object attribure after picture list init finish */
	list = [Object.assign({}, PictureStyle),
			Object.assign({}, Colour),
			Object.assign({}, Contrast),
			Object.assign({}, Sharpness),
			Object.assign({}, Brightness),						
			Object.assign({}, ExpertMode),
			Object.assign({}, PictureFormat),
			Object.assign({}, QuickPictureSetting)]
	
	for (var i = 0; i < list.length; i++)
	{
		if (PictureFormat.name == list[i].name)
		{
			if (!pf_valid)
			{
				list[i].showMode = showMode.hide;
			}
		}
	}
	
		
	if (SPEC_MODE.PC == spec_mode && PictureMode.Monitor != pic_mode) /* hidden some node in direct PC timing */
	{
		Hide_picture_all_list_in_PC_timing(list);
	}
	else
	{
		if (PictureMode.Monitor == pic_mode)
		{
			Hide_picture_all_list_in_PC_timing(list);
		}
		/*
		else
		{
			Update_node_status_in_PC_timing(showMode.normal);
		}
		*/
	}			

	for (var i = 0; i < list.length; i++)
	{
		if (list[i].name == PictureStyle.name && list[i].showMode == showMode.normal)
		{
			list[i] = UpdatePictureStyleList();
		}
		else if (list[i].name == ExpertMode.name)
		{
			list[i].item = UpdatePicExpertModeList();
		}
	}
	
	
	for (var i = 0; i < list.length; i++)
	{
		if (list[i].showMode == showMode.hide)
		{
			continue;
		}
		
		new_Item.push(list[i]);
	}
	return new_Item;

}
function UpdatePicExpertModeList()
{
	var list = [];
	
	var detect_HDR = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_DETECT_HDR);
	var pic_mode 	= mtvObj.acfgGetConfigValue(PictureStyle.acfgKey);
	var spec_mode 	 = mtvObj.acfgGetConfigValue(CFG_CUSTOM_BASE_SPECICIAL_MODE);

	Picture_list_init();

	/* deep copy array of object to avoid to modify original object attribure after picture list init finish */
	list = [Object.assign({}, Tint),
			Object.assign({}, ColourEnhancement),
			Object.assign({}, ColourGamut),
			Object.assign({}, ColourTemperature),
			Object.assign({}, CustomColourTemperature),
			Object.assign({}, ContrastMode),
			Object.assign({}, HDRPlus),
			Object.assign({}, DynamicContrast),
			Object.assign({}, VideoContrast),
			Object.assign({}, LightSensor),
			Object.assign({}, Gamma),
			Object.assign({}, UltraResolution),
			Object.assign({}, NoiseReduction),
			Object.assign({}, MPEGArtefactReduction),
			Object.assign({}, MotionStyles),
			Object.assign({}, NaturalMotion),
			Object.assign({}, PerfectClearMotion),
			Object.assign({}, ClearResidualImage)
			];
	

	for (var i = 0; i < list.length; i++)
	{
		/* Control show/hide status in different condition */
		if (Tint.name == list[i].name)
		{
			if (((PLF_OPT_REGION_TYPE.PLF_OPT_REGION_LATAM == region) || (PLF_OPT_REGION_TYPE.PLF_OPT_REGION_AP == region) 
			  || (PLF_OPT_REGION_TYPE.PLF_OPT_REGION_INDIA == region) 
			  || (PLF_OPT_REGION_TYPE.PLF_OPT_REGION_MEA == region))  /* 20180313 add for MEA region */
				&&
				mtvObj.acfgGetConfigValue(CFG_VIDEO_IS_NTSC_SIGNAL))
			{
				list[i].showMode = showMode.normal;
			}
			else
			{
				list[i].showMode = showMode.hide;
			}
		}
		else if (CustomColourTemperature.name == list[i].name)
		{
			if (ACFG_ColorTemperature.CUSTOM == mtvObj.acfgGetConfigValue(ColourTemperature.acfgKey))
			{
				list[i].showMode = showMode.normal;
			}
			else
			{
				list[i].showMode = showMode.hide;
			}
		}
		else if (NaturalMotion.name == list[i].name)
		{
			if ((MotionStyles.showMode == showMode.normal) && 
				(Motion_style.PERSONAL == mtvObj.acfgGetConfigValue(MotionStyles.acfgKey))
				)
			{
				list[i].showMode = showMode.normal;
			}
			else
			{
				list[i].showMode = showMode.hide;
			}
		}
		else if (HDRPlus.name == list[i].name)
		{
			if (!detect_HDR)
			{
				list[i].showMode = showMode.hide;
			}
		}
		else if (MotionStyles.name == list[i].name)
		{
			if (PictureMode.Game == pic_mode)
			{
				list[i].showMode = showMode.hide;
			}
		}
		else if (DynamicContrast.name == list[i].name)
		{
			if (detect_HDR)
			{
				list[i].showMode = showMode.hide;
			}
		}
		else if (PerfectClearMotion.name == list[i].name)
		{
			if ((PerfectClearMotion.showMode == showMode.normal) && 
				(Motion_style.PERSONAL == mtvObj.acfgGetConfigValue(MotionStyles.acfgKey))
				)
			{
				list[i].showMode = showMode.normal;
			}
			else
			{
				list[i].showMode = showMode.hide;
			}	
		}
	}


	if (SPEC_MODE.PC == spec_mode && PictureMode.Monitor != pic_mode) /* hidden some node in direct PC timing */
	{
		Hide_picture_all_list_in_PC_timing(list);
	}
	else
	{
		if (PictureMode.Monitor == pic_mode)
		{
			Hide_picture_all_list_in_PC_timing(list);
		}
		else
		{
			//Update_node_status_in_PC_timing(showMode.normal);
		}
	}		
	
	var new_Item = [];
	for (var i = 0; i < list.length; i++)
	{
		if (list[i].showMode == showMode.hide)
		{
			continue;
		}

		new_Item.push(list[i]);
	}
	return new_Item;
}

