/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_VIEWS_BINDINGS_LUA_EXPOSE_CPP_TO_LUA_XML_VIEW_TRANSCODER_LUA_BINDING_H_
#define PLUGIN_VIEWS_BINDINGS_LUA_EXPOSE_CPP_TO_LUA_XML_VIEW_TRANSCODER_LUA_BINDING_H_

#include "transcoder/XmlViewTranscoder.h"
#include "ffi/LuaFFIUserData.h"
#include "ViewsConfig.h"

namespace ignition
{

CREATE_FFI_USER_DATA(XmlViewTranscoder, views);

namespace views
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct XmlViewTranscoderUserData XmlViewTranscoderUserData;

typedef struct TranscodedView
{
	char* data;
	size_t length;
} TranscodedView;

PLUGINVIEWS_API TranscodedView* views_XmlViewTranscoder_transcodeView(
		XmlViewTranscoderUserData* self,
		const char* filePath,
		const char* content);

PLUGINVIEWS_API void views_XmlViewTranscoder_deleteTranscodedView(
		XmlViewTranscoderUserData* self,
		TranscodedView* view);

/* @end_ffi_externs */

} // extern "C"
} // namespace views
} // namespace ignition

#endif // PLUGIN_VIEWS_BINDINGS_LUA_EXPOSE_CPP_TO_LUA_XML_VIEW_TRANSCODER_LUA_BINDING_H_
