/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_VIEWS_BINDINGS_LUA_EXPOSE_CPP_TO_LUA_VIEW_HANDLE_PTR_LUA_BINDING_H_
#define PLUGIN_VIEWS_BINDINGS_LUA_EXPOSE_CPP_TO_LUA_VIEW_HANDLE_PTR_LUA_BINDING_H_

#include "view/ViewHandlePtr.h"
#include "view/ViewHandle.h"
#include "ffi/LuaFFIUserData.h"
#include "ViewsConfig.h"

#include <bindings/types/LuaReflectableValueVectorBinding.h>

namespace ignition
{

using core::ReflectableValueVectorUserData;

CREATE_FFI_USER_DATA_SHARED_PTR(ViewHandle, views);

namespace views
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct ViewHandleSharedPtrUserData ViewHandleSharedPtrUserData;

PLUGINVIEWS_API ViewHandleSharedPtrUserData* views_ViewHandleSharedPtr_new();

PLUGINVIEWS_API void views_ViewHandleSharedPtr_gc(
		ViewHandleSharedPtrUserData* self);

PLUGINVIEWS_API uint32_t views_ViewHandleSharedPtr_getUuid(
		ViewHandleSharedPtrUserData* self);

PLUGINVIEWS_API void views_ViewHandleSharedPtr_assignLuaViewInstanceUuid(
		ViewHandleSharedPtrUserData* self,
		uint32_t uuid);

PLUGINVIEWS_API void views_ViewHandleSharedPtr_dispatchJsSignal(
		ViewHandleSharedPtrUserData* self,
		const char* signalDescriptor,
		ReflectableValueVectorUserData* params);

PLUGINVIEWS_API void views_ViewHandleSharedPtr_setDefaultFocusedNode(
		ViewHandleSharedPtrUserData* self,
		const char* name);

PLUGINVIEWS_API void views_ViewHandleSharedPtr_setMediationGroup(
		ViewHandleSharedPtrUserData* self,
		const char* mediationGroup);

PLUGINVIEWS_API const char* views_ViewHandleSharedPtr_getMediationGroup(
		ViewHandleSharedPtrUserData* self);

PLUGINVIEWS_API void views_ViewHandleSharedPtr_markAsDisposing(
		ViewHandleSharedPtrUserData* self);

/* @end_ffi_externs */

} // extern "C"
} // namespace views
} // namespace ignition

#endif // PLUGIN_VIEWS_BINDINGS_LUA_EXPOSE_CPP_TO_LUA_VIEW_HANDLE_PTR_LUA_BINDING_H_
