/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_VIEWS_BINDINGS_LUA_EXPOSE_CPP_TO_LUA_VIEW_COMPONENT_MANAGER_LUA_BINDING_H_
#define PLUGIN_VIEWS_BINDINGS_LUA_EXPOSE_CPP_TO_LUA_VIEW_COMPONENT_MANAGER_LUA_BINDING_H_

#include "management/ViewComponentManager.h"
#include "ffi/LuaFFIUserData.h"
#include "ViewsConfig.h"

namespace ignition
{

CREATE_FFI_USER_DATA(ViewComponentManager, views);

namespace views
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct ViewComponentManagerUserData ViewComponentManagerUserData;
typedef struct ViewHandleSharedPtrUserData ViewHandleSharedPtrUserData;

PLUGINVIEWS_API int views_ViewComponentManager_loadView(
		ViewComponentManagerUserData* self,
		const char* className);

PLUGINVIEWS_API void views_ViewComponentManager_createMediator(
		ViewComponentManagerUserData* self,
		const char* className,
		ViewHandleSharedPtrUserData* handle);

PLUGINVIEWS_API void views_ViewComponentManager_assignJsObjectRetainer(
		ViewComponentManagerUserData* self,
		ViewHandleSharedPtrUserData* handle);

/* @end_ffi_externs */

} // extern "C"
} // namespace views
} // namespace ignition

#endif // PLUGIN_VIEWS_BINDINGS_LUA_EXPOSE_CPP_TO_LUA_VIEW_COMPONENT_MANAGER_LUA_BINDING_H_
