-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractViewportPositioner = class(function(self)
end)

function AbstractViewportPositioner:_getStartAndEndIndices(
		highlightedIndex, viewport)
	error("AbstractViewportPositioner:_getStartAndEndIndices() is"
			.. " not implemented!")
end

function AbstractViewportPositioner:setHighlightedIndex(viewport, index)
	local startIndex, endIndex =
			self:_getStartAndEndIndices(index, viewport)

	viewport:setStartIndex(startIndex)
	viewport:setEndIndex(endIndex)
	viewport:setHighlightedIndex(index)
end

function AbstractViewportPositioner:moveHighlightedIndex(viewport, delta)
	self:setHighlightedIndex(viewport, viewport:getHighlightedIndex() + delta)
end

function AbstractViewportPositioner:shouldReposition(viewport)
	error("AbstractViewportPositioner:shouldReposition() is not implemented!")
end

function AbstractViewportPositioner:reposition(
		viewport, viewportViews, iterator, options)
	error("AbstractViewportPositioner:reposition() is not implemented!")
end

return AbstractViewportPositioner