-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

-- Represents a chunk of data within a larger data set.
-- the startRequestIndex and endRequestIndex are the indices with respect to
-- the requests that are made to the server. the startIndex and endIndex
-- are the actual indices of the data within the dataBuffer
local DataChunk = class(function(self, startRequestIndex, endRequestIndex,
			data, objectId, startIndex, endIndex)
	if endRequestIndex < startRequestIndex then
		error('End index must be greater than or equal to the start index')
	elseif data ~= nil and #data > endRequestIndex - startRequestIndex + 1 then
		error('The number of items in the data array is bigger than the chunk size requested')
	end
	if data and startIndex and endIndex then
		assert(#data == (endIndex - (startIndex - 1)))
	end

	self._startRequestIndex = startRequestIndex
	self._endRequestIndex = endRequestIndex
	self._data = data
	self._objectId = objectId
	self._startIndex = startIndex
	self._endIndex = endIndex
end)

function DataChunk:getStartIndex()
	return self._startIndex
end

function DataChunk:getEndIndex()
	return self._endIndex
end

function DataChunk:setStartIndex(index)
	self._startIndex = index
end

function DataChunk:setEndIndex(index)
	self._endIndex = index
end

function DataChunk:getSize()
	return #self._data
end

function DataChunk:getData()
	return self._data
end

function DataChunk:getObjectId()
	return self._objectId
end

function DataChunk:getStartRequestIndex()
	return self._startRequestIndex
end

function DataChunk:getEndRequestIndex()
	return self._endRequestIndex
end

return DataChunk
