-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local ViewPropertiesRegistry = plugins.views:lazyRequire('core.definitions.ViewPropertiesRegistry')

local ViewPropertiesMixin = {}

ViewPropertiesMixin._ctor = function(self, propertyDefinitions, initialPropertyValues)
	self._propertiesRegistry = ViewPropertiesRegistry.new(propertyDefinitions)
	self._propertiesRegistry:setView(self)

	if type(initialPropertyValues) == "table" then
		for propName, propValue in pairs(initialPropertyValues) do
			self:setProperty(propName, propValue)
		end
	end
end

ViewPropertiesMixin.acceptsProperty = function(self, name)
	return self._propertiesRegistry:accepts(name)
end

ViewPropertiesMixin.setProperty = function(self, name, value)
	self._propertiesRegistry:set(name, value)
end

ViewPropertiesMixin.getProperty = function(self, name, value)
	return self._propertiesRegistry:get(name)
end

ViewPropertiesMixin.validateProperties = function(self)
	self._propertiesRegistry:validateProperties()
end

return ViewPropertiesMixin
