-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local Timer = plugins.views:lazyRequire('utils.Timer')

local Timers = class(function(self)
	self._timers = {}
	
	self.LOAD_VIEW = self:_addTimer('Load View')
	self.FLUSH_OPS = self:_addTimer('Flush Operations')
end)

function Timers:_addTimer(description)	
	local timer = Timer.new(description)
	table.insert(self._timers, timer)
	return timer
end

function Timers:getAllTimings()
	local timings = {}
	
	for i, timer in ipairs(self._timers) do
		timings[timer:getDescription()] = timer:getTimings()
	end
	
	return timings
end

function Timers:resetAllTimers()
	for i, timer in ipairs(self._timers) do
		timer:reset()
	end
end

return Timers
