-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local Timer = class(function(self, description)
	self._description = description
	
	self:reset()
end)

function Timer:reset()
	self._timings = {}
	self._inProgressTimings = {}
end

function Timer:getDescription()
	return self._description
end

function Timer:getTimings()
	return self._timings
end

function Timer:startTiming()
	table.insert(self._inProgressTimings, timer.getTimeInMilliseconds())
	
	return #self._inProgressTimings
end

function Timer:endTiming(index)
	if self._inProgressTimings[index] == nil then
		error('Timer:endTiming() was called with an invalid timing index')
	else
		local delta = timer.getTimeInMilliseconds() - self._inProgressTimings[index]
		self._timings[index] = delta
		return delta
	end
end

return Timer
