-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local NodeBumper = class(function(self)
end)

function NodeBumper.bump(node, propertyManager, distance, duration)
	local propertyName = propertyManager:getPropertyName()
	if not NodeBumper._lastAnimationOver(node, propertyName) then
		return
	end
	local currentPropertyValue = propertyManager:getValue(node)
	local endValue = currentPropertyValue + distance

	NodeBumper._queueAnimation(node,
			propertyName,
			nil,
			endValue,
			duration/2)

	NodeBumper._queueAnimation(node,
			propertyName,
			endValue,
			currentPropertyValue,
			duration/2)
end

function NodeBumper._queueAnimation(node, propertyName, startValue, endValue, duration)
	local animationStart = ReflectableValueUserData.new()
	animationStart:set(startValue)
	local animationEnd = ReflectableValueUserData.new()
	animationEnd:set(endValue)

	return animation.queue(node, propertyName, animation.type.FIXED_DURATION,
	{
		from = animationStart,
		to = animationEnd,
		duration = duration,
		easingParams = {0, 0, 0, 0},
		easing = "linear",
		repetitions = 0
	})
end

function NodeBumper._lastAnimationOver(node, propertyName)
	return animation.length(node, propertyName) == 0
end

return NodeBumper
