-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local FileLoader = class()

-- If 'keepOriginalLineEndings' is set to false or nil (default behaviour),
-- the line endings will be normalized to unix format.
function FileLoader.loadFile(filename, keepOriginalLineEndings)
	local resolvedPath = plugins.resolvePath(filename) or filename
	local file = io.open(resolvedPath, "r");

	if (file ~= nil) then
		local lines = file:read("*a")
		file:close()

		if keepOriginalLineEndings then
			return lines
		else
			return FileLoader._normalizeLineEndings(lines)
		end
	end
end

function FileLoader._normalizeLineEndings(lines)
    return lines:gsub('\r\n?', '\n')
end

return FileLoader