-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractPropertyManager = plugins.views:lazyRequire('properties.iterator.propertyManagers.AbstractPropertyManager')

local XPropertyManager = class(AbstractPropertyManager, function(self)
end)

function XPropertyManager:getIteratingDirections()
	return {["left"] = true, ["right"] = true}
end

function XPropertyManager:getPropertiesAffectingNodeSize()
	return { width = true }
end

function XPropertyManager:getNodeSize(node)
	return node:getWidth()
end

function XPropertyManager:getValue(node)
	return node:getX()
end

function XPropertyManager:getMinBound(node)
	return node:getLeft()
end

function XPropertyManager:getMaxBound(node)
	return node:getRight()
end

function XPropertyManager:setValue(node, value)
	node:setX(value)
end

function XPropertyManager:setMinBound(node, value)
	node:setX(value + node:getPivotPosition().x + node:getWidth() / 2)
end

function XPropertyManager:setMaxBound(node, value)
	node:setX(value + node:getPivotPosition().x - node:getWidth() / 2)
end

function XPropertyManager:getPropertyName()
	return "x"
end

return XPropertyManager
