-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local DynamicSpacingIterator = plugins.views:lazyRequire("properties.iterator.internal.DynamicSpacingIterator")
local YPropertyManager = plugins.views:lazyRequire("properties.iterator.propertyManagers.YPropertyManager")

local DynamicSpacingVertical = class(DynamicSpacingIterator, function(self, settings)
	DynamicSpacingIterator._ctor(self, YPropertyManager.new(), -settings.spacing)
end)

-- This is a special case, since the elements should be iterated "down"
-- when the margin is 0, but Y grows to the top of the screen.
function DynamicSpacingVertical:_getMultiplierForMargin(margin)
	if margin <= 0 then
		return -1
	else
		return 1
	end
end

return DynamicSpacingVertical
