-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local DefaultPropertyFactory = plugins.views:lazyRequire('properties.DefaultPropertyFactory')
local IIterator = plugins.views:lazyRequire('properties.iterator.internal.IIterator')

local IteratorFactory = class(DefaultPropertyFactory)

local function isIteratorInstance(value)
	return type(value) == "table" and
			type(value.instanceOf) == "function" and
			value:instanceOf(IIterator)
end

function IteratorFactory:create(propertyName, propertyDescription)
	-- Iterators are an edge case in the sense that we need to support iterator objects
	-- themselves being passed as the property description
	if isIteratorInstance(propertyDescription) then
		return propertyDescription
	else
		return DefaultPropertyFactory.create(self, propertyName, propertyDescription)
	end
end

return IteratorFactory
