-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local HexToVec4 = lazyRequire("typeConverters.HexColorToNormalizedVec4")
local RgbaToVec4 = lazyRequire("typeConverters.RgbaToNormalizedVec4")

local function isNumber(val)
	return type(val) == "number"
end

return function(value)
	if type(value) == "string" then
		return HexToVec4(value)
	elseif type(value) == "table" then
		if isNumber(value.r) and isNumber(value.g) and isNumber(value.b) then
			return RgbaToVec4(value)
		elseif isNumber(value.x) and isNumber(value.y) and isNumber(value.z) then
			local w = isNumber(value.w) and value.w or 1
			return LuaVec4(value.x, value.y, value.z, w)
		end
	end

	return nil
end
