-- Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local ParentDirective = DirectiveClass('SceneNodeDirective')
local Directive = class(ParentDirective)
local ColorToVec = lazyRequire("directives.utils.ColorToVec")

--[[
-- @inheritdoc
--
--]]
Directive.typeName = 'TextNodeDirective'

function Directive:_createNode()
	return SceneNodeFactory.createTextNode()
end

Directive.setterTable = ParentDirective:mergeSetters(
{
	text = function (node, value) node:setText(tostring(value)) end,
	locale = function (node, value) node:setLocale(tostring(value)) end,
	fontFace = function (node, value) node:setFontFace(tostring(value)) end,
	fontSize = function (node, value) node:setFontSize(value) end,
	fontHexColor = function (node, value)
		log.warn("'TextNodeDirective:setFontHexColor()' is deprecated. Use " ..
				"'<scene:text fontColor=@{value}/>' instead of " ..
				"'<scene:text fontHexColor=@{value}/>' in XML views.")
		node:setFontHexColor(value)
	end,
	fontColor = function (node, value)
		local colorVec = ColorToVec(value)
		if colorVec then
			-- Projects colorVec (a Vec4) into a Vec3
			value = LuaVec3(colorVec.x, colorVec.y, colorVec.z)
		end
		node:setFontColor(value)
	end
})

return Directive
