-- Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local ParentDirective = DirectiveClass('SceneNodeDirective')
local Directive = class(ParentDirective)

--[[
-- @inheritdoc
--
--]]
Directive.typeName = 'ImageNodeDirective'

function Directive:_createNode()
	return SceneNodeFactory.createImageNode()
end

Directive.setterTable = ParentDirective:mergeSetters(
{
	source = function (node, value)
		if type(value) == "string" then
			node:setSource(value)
		else
			log.error("ImageNodeDirective.setSource parameter should be a string, received " .. type(value) .. " instead")
			node:setSource("")
		end
	end,
	fileType = function (node, value) node:setFileType(tostring(value)) end
})

return Directive
