-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

--[[
-- Takes an incoming property value and looks it up in the i18n table.
--
-- If a value is found, this is used as the property value. If not, the
-- string '[unknown i18n key: foo]' is returned.
--
--]]
local i18n = function(prop)
    prop.value = context:getI18nDictionary():getValue(prop.value)
			  or '[unknown i18n key: ' .. prop.value .. ']'
end

return i18n
