-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

-- [[
-- Toggles a property by creating if value == false, or it's marked as
-- deleted; else delete it.
--
-- ]]
local createIfFalse = function(prop, value)
    if (prop.type == OpsContainer.OPERATION_DELETE) or
            (prop.value == false) then
        prop.type = OpsContainer.OPERATION_CREATE
    else
        prop.type = OpsContainer.OPERATION_DELETE
    end
    prop.value = value
end

return createIfFalse
