-- Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local IView = plugins.views:lazyRequire('core.types.IView')
local IDirective = plugins.views:lazyRequire('core.types.IDirective')
local LookupPrefix = plugins.views:lazyRequire('core.LookupPrefix')

--[[
-- Returns a class builder function
 - -
--]]
local function buildClassFactory(baseClass, loadDefinitionFn)
	return function (parentClassNameOrDefinition, ctor)
		local parentClass
		local newClass

		if parentClassNameOrDefinition == nil then
			parentClass = baseClass
		elseif type(parentClassNameOrDefinition) == 'table' then
			parentClass = parentClassNameOrDefinition
		elseif type(parentClassNameOrDefinition) == 'string' then
			parentClass = loadDefinitionFn(parentClassNameOrDefinition)
		else
			error('Invalid parent class: ' .. tostring(parentClassNameOrDefinition))
		end

		newClass = class(parentClass, ctor)
		return newClass
	end
end

--[[
-- Requires View Classes
--
--]]
ViewClass = buildClassFactory(
	IView,
	function(className)
		local parentClass
		local viewDefinitionTable = context:getViewDefinitionTable()

		if viewDefinitionTable:has(className) then
			parentClass = viewDefinitionTable:get(className)
		else
			parentClass = viewDefinitionTable:loadFromLuaSearchPath(className)
		end

		return parentClass
end)


--[[
-- Requires Directive Classes
--
--]]
DirectiveClass = buildClassFactory(
	IDirective,
	function(className)
		return lazyRequire(LookupPrefix.DIRECTIVES .. className)
end)
