-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local SEPARATOR = ':'

local SignalInfo = class(function(self, sourceName, signalName)
	self._sourceName = sourceName
	self._signalName = signalName
	if self._sourceName then
		self._descriptor = self._sourceName .. SEPARATOR .. self._signalName
	else
		self._descriptor = self._signalName
	end
end)

function SignalInfo:getSourceName()
	return self._sourceName
end

function SignalInfo:getSignalName()
	return self._signalName
end

function SignalInfo:getDescriptor()
	return self._descriptor
end

function SignalInfo.fromDescriptor(descriptor)
	if type(descriptor) ~= 'string' then
		error(
			'The descriptor argument to SignalInfo.fromDescriptor() is ' ..
			'required, and must be a string'
		)
	end

	local sourceName = nil
	local signalName = nil
	local sourceNameIndex = descriptor:find(SEPARATOR)

	if sourceNameIndex == nil then
		signalName = descriptor
	else
		sourceName = descriptor:sub(1, sourceNameIndex - 1)
		signalName = descriptor:sub(sourceNameIndex + 1)

		if (not sourceName) or (sourceName:len() == 0) then
			error(
				'Source name must not be empty. ' ..
				'Supplied value was \'' .. descriptor .. '\'.'
			)
		end
	end

	if (not signalName) or (signalName:len() == 0) then
		error(
			'Signal name must not be empty. ' ..
			'Supplied value was \'' .. descriptor .. '\'.'
		)
	end

	return SignalInfo.new(sourceName, signalName)
end

return SignalInfo